package software.amazon.awscdk.services.iotwireless;

/**
 * A partner account.
 * <p>
 * If <code>PartnerAccountId</code> and <code>PartnerType</code> are <code>null</code> , returns all partner accounts.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.iotwireless.*;
 * CfnPartnerAccount cfnPartnerAccount = CfnPartnerAccount.Builder.create(this, "MyCfnPartnerAccount")
 *         .accountLinked(false)
 *         .partnerAccountId("partnerAccountId")
 *         .partnerType("partnerType")
 *         .sidewalk(SidewalkAccountInfoProperty.builder()
 *                 .appServerPrivateKey("appServerPrivateKey")
 *                 .build())
 *         .sidewalkResponse(SidewalkAccountInfoWithFingerprintProperty.builder()
 *                 .amazonId("amazonId")
 *                 .arn("arn")
 *                 .fingerprint("fingerprint")
 *                 .build())
 *         .sidewalkUpdate(SidewalkUpdateAccountProperty.builder()
 *                 .appServerPrivateKey("appServerPrivateKey")
 *                 .build())
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotwireless-partneraccount.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotwireless-partneraccount.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-05-20T23:52:58.024Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_iotwireless.CfnPartnerAccount")
public class CfnPartnerAccount extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable, software.amazon.awscdk.ITaggable {

    protected CfnPartnerAccount(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnPartnerAccount(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.iotwireless.CfnPartnerAccount.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * @param scope Scope in which this resource is defined. This parameter is required.
     * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
     * @param props Resource properties.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnPartnerAccount(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.iotwireless.CfnPartnerAccountProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), props });
    }

    /**
     * @param scope Scope in which this resource is defined. This parameter is required.
     * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnPartnerAccount(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     * The Amazon Resource Name (ARN) of the resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrArn() {
        return software.amazon.jsii.Kernel.get(this, "attrArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The fingerprint of the Sidewalk application server private key.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrFingerprint() {
        return software.amazon.jsii.Kernel.get(this, "attrFingerprint", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * Tag Manager which manages the tags for this resource.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.TagManager getTags() {
        return software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TagManager.class));
    }

    /**
     * Whether the partner account is linked to the AWS account.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getAccountLinked() {
        return software.amazon.jsii.Kernel.get(this, "accountLinked", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Whether the partner account is linked to the AWS account.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAccountLinked(final @org.jetbrains.annotations.Nullable java.lang.Boolean value) {
        software.amazon.jsii.Kernel.set(this, "accountLinked", value);
    }

    /**
     * Whether the partner account is linked to the AWS account.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAccountLinked(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "accountLinked", value);
    }

    /**
     * The ID of the partner account to update.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getPartnerAccountId() {
        return software.amazon.jsii.Kernel.get(this, "partnerAccountId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The ID of the partner account to update.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setPartnerAccountId(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "partnerAccountId", value);
    }

    /**
     * The partner type.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getPartnerType() {
        return software.amazon.jsii.Kernel.get(this, "partnerType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The partner type.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setPartnerType(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "partnerType", value);
    }

    /**
     * The Sidewalk account credentials.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getSidewalk() {
        return software.amazon.jsii.Kernel.get(this, "sidewalk", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The Sidewalk account credentials.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSidewalk(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "sidewalk", value);
    }

    /**
     * The Sidewalk account credentials.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSidewalk(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.iotwireless.CfnPartnerAccount.SidewalkAccountInfoProperty value) {
        software.amazon.jsii.Kernel.set(this, "sidewalk", value);
    }

    /**
     * Information about a Sidewalk account.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getSidewalkResponse() {
        return software.amazon.jsii.Kernel.get(this, "sidewalkResponse", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Information about a Sidewalk account.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSidewalkResponse(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "sidewalkResponse", value);
    }

    /**
     * Information about a Sidewalk account.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSidewalkResponse(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.iotwireless.CfnPartnerAccount.SidewalkAccountInfoWithFingerprintProperty value) {
        software.amazon.jsii.Kernel.set(this, "sidewalkResponse", value);
    }

    /**
     * Sidewalk update.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getSidewalkUpdate() {
        return software.amazon.jsii.Kernel.get(this, "sidewalkUpdate", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Sidewalk update.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSidewalkUpdate(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "sidewalkUpdate", value);
    }

    /**
     * Sidewalk update.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSidewalkUpdate(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.iotwireless.CfnPartnerAccount.SidewalkUpdateAccountProperty value) {
        software.amazon.jsii.Kernel.set(this, "sidewalkUpdate", value);
    }

    /**
     * The tags are an array of key-value pairs to attach to the specified resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTagsRaw() {
        return java.util.Optional.ofNullable((java.util.List<software.amazon.awscdk.CfnTag>)(software.amazon.jsii.Kernel.get(this, "tagsRaw", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     * The tags are an array of key-value pairs to attach to the specified resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTagsRaw(final @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> value) {
        software.amazon.jsii.Kernel.set(this, "tagsRaw", value);
    }
    /**
     * Information about a Sidewalk account.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.iotwireless.*;
     * SidewalkAccountInfoProperty sidewalkAccountInfoProperty = SidewalkAccountInfoProperty.builder()
     *         .appServerPrivateKey("appServerPrivateKey")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotwireless-partneraccount-sidewalkaccountinfo.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotwireless-partneraccount-sidewalkaccountinfo.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_iotwireless.CfnPartnerAccount.SidewalkAccountInfoProperty")
    @software.amazon.jsii.Jsii.Proxy(SidewalkAccountInfoProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface SidewalkAccountInfoProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The Sidewalk application server private key.
         * <p>
         * The application server private key is a secret key, which you should handle in a similar way as you would an application password. You can protect the application server private key by storing the value in the AWS Secrets Manager and use the <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/dynamic-references.html#dynamic-references-secretsmanager">secretsmanager</a> to reference this value.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotwireless-partneraccount-sidewalkaccountinfo.html#cfn-iotwireless-partneraccount-sidewalkaccountinfo-appserverprivatekey">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotwireless-partneraccount-sidewalkaccountinfo.html#cfn-iotwireless-partneraccount-sidewalkaccountinfo-appserverprivatekey</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getAppServerPrivateKey();

        /**
         * @return a {@link Builder} of {@link SidewalkAccountInfoProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link SidewalkAccountInfoProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<SidewalkAccountInfoProperty> {
            java.lang.String appServerPrivateKey;

            /**
             * Sets the value of {@link SidewalkAccountInfoProperty#getAppServerPrivateKey}
             * @param appServerPrivateKey The Sidewalk application server private key. This parameter is required.
             *                            The application server private key is a secret key, which you should handle in a similar way as you would an application password. You can protect the application server private key by storing the value in the AWS Secrets Manager and use the <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/dynamic-references.html#dynamic-references-secretsmanager">secretsmanager</a> to reference this value.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder appServerPrivateKey(java.lang.String appServerPrivateKey) {
                this.appServerPrivateKey = appServerPrivateKey;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link SidewalkAccountInfoProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public SidewalkAccountInfoProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link SidewalkAccountInfoProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SidewalkAccountInfoProperty {
            private final java.lang.String appServerPrivateKey;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.appServerPrivateKey = software.amazon.jsii.Kernel.get(this, "appServerPrivateKey", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.appServerPrivateKey = java.util.Objects.requireNonNull(builder.appServerPrivateKey, "appServerPrivateKey is required");
            }

            @Override
            public final java.lang.String getAppServerPrivateKey() {
                return this.appServerPrivateKey;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("appServerPrivateKey", om.valueToTree(this.getAppServerPrivateKey()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_iotwireless.CfnPartnerAccount.SidewalkAccountInfoProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                SidewalkAccountInfoProperty.Jsii$Proxy that = (SidewalkAccountInfoProperty.Jsii$Proxy) o;

                return this.appServerPrivateKey.equals(that.appServerPrivateKey);
            }

            @Override
            public final int hashCode() {
                int result = this.appServerPrivateKey.hashCode();
                return result;
            }
        }
    }
    /**
     * Information about a Sidewalk account.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.iotwireless.*;
     * SidewalkAccountInfoWithFingerprintProperty sidewalkAccountInfoWithFingerprintProperty = SidewalkAccountInfoWithFingerprintProperty.builder()
     *         .amazonId("amazonId")
     *         .arn("arn")
     *         .fingerprint("fingerprint")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotwireless-partneraccount-sidewalkaccountinfowithfingerprint.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotwireless-partneraccount-sidewalkaccountinfowithfingerprint.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_iotwireless.CfnPartnerAccount.SidewalkAccountInfoWithFingerprintProperty")
    @software.amazon.jsii.Jsii.Proxy(SidewalkAccountInfoWithFingerprintProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface SidewalkAccountInfoWithFingerprintProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The Sidewalk Amazon ID.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotwireless-partneraccount-sidewalkaccountinfowithfingerprint.html#cfn-iotwireless-partneraccount-sidewalkaccountinfowithfingerprint-amazonid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotwireless-partneraccount-sidewalkaccountinfowithfingerprint.html#cfn-iotwireless-partneraccount-sidewalkaccountinfowithfingerprint-amazonid</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getAmazonId() {
            return null;
        }

        /**
         * The Amazon Resource Name (ARN) of the resource.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotwireless-partneraccount-sidewalkaccountinfowithfingerprint.html#cfn-iotwireless-partneraccount-sidewalkaccountinfowithfingerprint-arn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotwireless-partneraccount-sidewalkaccountinfowithfingerprint.html#cfn-iotwireless-partneraccount-sidewalkaccountinfowithfingerprint-arn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getArn() {
            return null;
        }

        /**
         * The fingerprint of the Sidewalk application server private key.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotwireless-partneraccount-sidewalkaccountinfowithfingerprint.html#cfn-iotwireless-partneraccount-sidewalkaccountinfowithfingerprint-fingerprint">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotwireless-partneraccount-sidewalkaccountinfowithfingerprint.html#cfn-iotwireless-partneraccount-sidewalkaccountinfowithfingerprint-fingerprint</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getFingerprint() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link SidewalkAccountInfoWithFingerprintProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link SidewalkAccountInfoWithFingerprintProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<SidewalkAccountInfoWithFingerprintProperty> {
            java.lang.String amazonId;
            java.lang.String arn;
            java.lang.String fingerprint;

            /**
             * Sets the value of {@link SidewalkAccountInfoWithFingerprintProperty#getAmazonId}
             * @param amazonId The Sidewalk Amazon ID.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder amazonId(java.lang.String amazonId) {
                this.amazonId = amazonId;
                return this;
            }

            /**
             * Sets the value of {@link SidewalkAccountInfoWithFingerprintProperty#getArn}
             * @param arn The Amazon Resource Name (ARN) of the resource.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder arn(java.lang.String arn) {
                this.arn = arn;
                return this;
            }

            /**
             * Sets the value of {@link SidewalkAccountInfoWithFingerprintProperty#getFingerprint}
             * @param fingerprint The fingerprint of the Sidewalk application server private key.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder fingerprint(java.lang.String fingerprint) {
                this.fingerprint = fingerprint;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link SidewalkAccountInfoWithFingerprintProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public SidewalkAccountInfoWithFingerprintProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link SidewalkAccountInfoWithFingerprintProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SidewalkAccountInfoWithFingerprintProperty {
            private final java.lang.String amazonId;
            private final java.lang.String arn;
            private final java.lang.String fingerprint;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.amazonId = software.amazon.jsii.Kernel.get(this, "amazonId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.arn = software.amazon.jsii.Kernel.get(this, "arn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.fingerprint = software.amazon.jsii.Kernel.get(this, "fingerprint", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.amazonId = builder.amazonId;
                this.arn = builder.arn;
                this.fingerprint = builder.fingerprint;
            }

            @Override
            public final java.lang.String getAmazonId() {
                return this.amazonId;
            }

            @Override
            public final java.lang.String getArn() {
                return this.arn;
            }

            @Override
            public final java.lang.String getFingerprint() {
                return this.fingerprint;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getAmazonId() != null) {
                    data.set("amazonId", om.valueToTree(this.getAmazonId()));
                }
                if (this.getArn() != null) {
                    data.set("arn", om.valueToTree(this.getArn()));
                }
                if (this.getFingerprint() != null) {
                    data.set("fingerprint", om.valueToTree(this.getFingerprint()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_iotwireless.CfnPartnerAccount.SidewalkAccountInfoWithFingerprintProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                SidewalkAccountInfoWithFingerprintProperty.Jsii$Proxy that = (SidewalkAccountInfoWithFingerprintProperty.Jsii$Proxy) o;

                if (this.amazonId != null ? !this.amazonId.equals(that.amazonId) : that.amazonId != null) return false;
                if (this.arn != null ? !this.arn.equals(that.arn) : that.arn != null) return false;
                return this.fingerprint != null ? this.fingerprint.equals(that.fingerprint) : that.fingerprint == null;
            }

            @Override
            public final int hashCode() {
                int result = this.amazonId != null ? this.amazonId.hashCode() : 0;
                result = 31 * result + (this.arn != null ? this.arn.hashCode() : 0);
                result = 31 * result + (this.fingerprint != null ? this.fingerprint.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Sidewalk update.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.iotwireless.*;
     * SidewalkUpdateAccountProperty sidewalkUpdateAccountProperty = SidewalkUpdateAccountProperty.builder()
     *         .appServerPrivateKey("appServerPrivateKey")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotwireless-partneraccount-sidewalkupdateaccount.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotwireless-partneraccount-sidewalkupdateaccount.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_iotwireless.CfnPartnerAccount.SidewalkUpdateAccountProperty")
    @software.amazon.jsii.Jsii.Proxy(SidewalkUpdateAccountProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface SidewalkUpdateAccountProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The new Sidewalk application server private key.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotwireless-partneraccount-sidewalkupdateaccount.html#cfn-iotwireless-partneraccount-sidewalkupdateaccount-appserverprivatekey">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotwireless-partneraccount-sidewalkupdateaccount.html#cfn-iotwireless-partneraccount-sidewalkupdateaccount-appserverprivatekey</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getAppServerPrivateKey() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link SidewalkUpdateAccountProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link SidewalkUpdateAccountProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<SidewalkUpdateAccountProperty> {
            java.lang.String appServerPrivateKey;

            /**
             * Sets the value of {@link SidewalkUpdateAccountProperty#getAppServerPrivateKey}
             * @param appServerPrivateKey The new Sidewalk application server private key.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder appServerPrivateKey(java.lang.String appServerPrivateKey) {
                this.appServerPrivateKey = appServerPrivateKey;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link SidewalkUpdateAccountProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public SidewalkUpdateAccountProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link SidewalkUpdateAccountProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SidewalkUpdateAccountProperty {
            private final java.lang.String appServerPrivateKey;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.appServerPrivateKey = software.amazon.jsii.Kernel.get(this, "appServerPrivateKey", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.appServerPrivateKey = builder.appServerPrivateKey;
            }

            @Override
            public final java.lang.String getAppServerPrivateKey() {
                return this.appServerPrivateKey;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getAppServerPrivateKey() != null) {
                    data.set("appServerPrivateKey", om.valueToTree(this.getAppServerPrivateKey()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_iotwireless.CfnPartnerAccount.SidewalkUpdateAccountProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                SidewalkUpdateAccountProperty.Jsii$Proxy that = (SidewalkUpdateAccountProperty.Jsii$Proxy) o;

                return this.appServerPrivateKey != null ? this.appServerPrivateKey.equals(that.appServerPrivateKey) : that.appServerPrivateKey == null;
            }

            @Override
            public final int hashCode() {
                int result = this.appServerPrivateKey != null ? this.appServerPrivateKey.hashCode() : 0;
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.iotwireless.CfnPartnerAccount}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.iotwireless.CfnPartnerAccount> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope Scope in which this resource is defined. This parameter is required.
         * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private software.amazon.awscdk.services.iotwireless.CfnPartnerAccountProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
        }

        /**
         * Whether the partner account is linked to the AWS account.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotwireless-partneraccount.html#cfn-iotwireless-partneraccount-accountlinked">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotwireless-partneraccount.html#cfn-iotwireless-partneraccount-accountlinked</a>
         * @param accountLinked Whether the partner account is linked to the AWS account. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder accountLinked(final java.lang.Boolean accountLinked) {
            this.props().accountLinked(accountLinked);
            return this;
        }
        /**
         * Whether the partner account is linked to the AWS account.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotwireless-partneraccount.html#cfn-iotwireless-partneraccount-accountlinked">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotwireless-partneraccount.html#cfn-iotwireless-partneraccount-accountlinked</a>
         * @param accountLinked Whether the partner account is linked to the AWS account. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder accountLinked(final software.amazon.awscdk.IResolvable accountLinked) {
            this.props().accountLinked(accountLinked);
            return this;
        }

        /**
         * The ID of the partner account to update.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotwireless-partneraccount.html#cfn-iotwireless-partneraccount-partneraccountid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotwireless-partneraccount.html#cfn-iotwireless-partneraccount-partneraccountid</a>
         * @param partnerAccountId The ID of the partner account to update. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder partnerAccountId(final java.lang.String partnerAccountId) {
            this.props().partnerAccountId(partnerAccountId);
            return this;
        }

        /**
         * The partner type.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotwireless-partneraccount.html#cfn-iotwireless-partneraccount-partnertype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotwireless-partneraccount.html#cfn-iotwireless-partneraccount-partnertype</a>
         * @param partnerType The partner type. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder partnerType(final java.lang.String partnerType) {
            this.props().partnerType(partnerType);
            return this;
        }

        /**
         * The Sidewalk account credentials.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotwireless-partneraccount.html#cfn-iotwireless-partneraccount-sidewalk">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotwireless-partneraccount.html#cfn-iotwireless-partneraccount-sidewalk</a>
         * @param sidewalk The Sidewalk account credentials. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder sidewalk(final software.amazon.awscdk.IResolvable sidewalk) {
            this.props().sidewalk(sidewalk);
            return this;
        }
        /**
         * The Sidewalk account credentials.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotwireless-partneraccount.html#cfn-iotwireless-partneraccount-sidewalk">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotwireless-partneraccount.html#cfn-iotwireless-partneraccount-sidewalk</a>
         * @param sidewalk The Sidewalk account credentials. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder sidewalk(final software.amazon.awscdk.services.iotwireless.CfnPartnerAccount.SidewalkAccountInfoProperty sidewalk) {
            this.props().sidewalk(sidewalk);
            return this;
        }

        /**
         * Information about a Sidewalk account.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotwireless-partneraccount.html#cfn-iotwireless-partneraccount-sidewalkresponse">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotwireless-partneraccount.html#cfn-iotwireless-partneraccount-sidewalkresponse</a>
         * @param sidewalkResponse Information about a Sidewalk account. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder sidewalkResponse(final software.amazon.awscdk.IResolvable sidewalkResponse) {
            this.props().sidewalkResponse(sidewalkResponse);
            return this;
        }
        /**
         * Information about a Sidewalk account.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotwireless-partneraccount.html#cfn-iotwireless-partneraccount-sidewalkresponse">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotwireless-partneraccount.html#cfn-iotwireless-partneraccount-sidewalkresponse</a>
         * @param sidewalkResponse Information about a Sidewalk account. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder sidewalkResponse(final software.amazon.awscdk.services.iotwireless.CfnPartnerAccount.SidewalkAccountInfoWithFingerprintProperty sidewalkResponse) {
            this.props().sidewalkResponse(sidewalkResponse);
            return this;
        }

        /**
         * Sidewalk update.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotwireless-partneraccount.html#cfn-iotwireless-partneraccount-sidewalkupdate">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotwireless-partneraccount.html#cfn-iotwireless-partneraccount-sidewalkupdate</a>
         * @param sidewalkUpdate Sidewalk update. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder sidewalkUpdate(final software.amazon.awscdk.IResolvable sidewalkUpdate) {
            this.props().sidewalkUpdate(sidewalkUpdate);
            return this;
        }
        /**
         * Sidewalk update.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotwireless-partneraccount.html#cfn-iotwireless-partneraccount-sidewalkupdate">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotwireless-partneraccount.html#cfn-iotwireless-partneraccount-sidewalkupdate</a>
         * @param sidewalkUpdate Sidewalk update. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder sidewalkUpdate(final software.amazon.awscdk.services.iotwireless.CfnPartnerAccount.SidewalkUpdateAccountProperty sidewalkUpdate) {
            this.props().sidewalkUpdate(sidewalkUpdate);
            return this;
        }

        /**
         * The tags are an array of key-value pairs to attach to the specified resource.
         * <p>
         * Tags can have a minimum of 0 and a maximum of 50 items.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotwireless-partneraccount.html#cfn-iotwireless-partneraccount-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotwireless-partneraccount.html#cfn-iotwireless-partneraccount-tags</a>
         * @param tags The tags are an array of key-value pairs to attach to the specified resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(final java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.props().tags(tags);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.iotwireless.CfnPartnerAccount}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.iotwireless.CfnPartnerAccount build() {
            return new software.amazon.awscdk.services.iotwireless.CfnPartnerAccount(
                this.scope,
                this.id,
                this.props != null ? this.props.build() : null
            );
        }

        private software.amazon.awscdk.services.iotwireless.CfnPartnerAccountProps.Builder props() {
            if (this.props == null) {
                this.props = new software.amazon.awscdk.services.iotwireless.CfnPartnerAccountProps.Builder();
            }
            return this.props;
        }
    }
}
