package software.amazon.awscdk.services.lakeformation;

/**
 * Properties for defining a <code>CfnPermissions</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.lakeformation.*;
 * CfnPermissionsProps cfnPermissionsProps = CfnPermissionsProps.builder()
 *         .dataLakePrincipal(DataLakePrincipalProperty.builder()
 *                 .dataLakePrincipalIdentifier("dataLakePrincipalIdentifier")
 *                 .build())
 *         .resource(ResourceProperty.builder()
 *                 .databaseResource(DatabaseResourceProperty.builder()
 *                         .catalogId("catalogId")
 *                         .name("name")
 *                         .build())
 *                 .dataLocationResource(DataLocationResourceProperty.builder()
 *                         .catalogId("catalogId")
 *                         .s3Resource("s3Resource")
 *                         .build())
 *                 .tableResource(TableResourceProperty.builder()
 *                         .catalogId("catalogId")
 *                         .databaseName("databaseName")
 *                         .name("name")
 *                         .tableWildcard(TableWildcardProperty.builder().build())
 *                         .build())
 *                 .tableWithColumnsResource(TableWithColumnsResourceProperty.builder()
 *                         .catalogId("catalogId")
 *                         .columnNames(List.of("columnNames"))
 *                         .columnWildcard(ColumnWildcardProperty.builder()
 *                                 .excludedColumnNames(List.of("excludedColumnNames"))
 *                                 .build())
 *                         .databaseName("databaseName")
 *                         .name("name")
 *                         .build())
 *                 .build())
 *         // the properties below are optional
 *         .permissions(List.of("permissions"))
 *         .permissionsWithGrantOption(List.of("permissionsWithGrantOption"))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lakeformation-permissions.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lakeformation-permissions.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-05-20T23:52:58.470Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_lakeformation.CfnPermissionsProps")
@software.amazon.jsii.Jsii.Proxy(CfnPermissionsProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnPermissionsProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The AWS Lake Formation principal.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lakeformation-permissions.html#cfn-lakeformation-permissions-datalakeprincipal">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lakeformation-permissions.html#cfn-lakeformation-permissions-datalakeprincipal</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Object getDataLakePrincipal();

    /**
     * A structure for the resource.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lakeformation-permissions.html#cfn-lakeformation-permissions-resource">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lakeformation-permissions.html#cfn-lakeformation-permissions-resource</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Object getResource();

    /**
     * The permissions granted or revoked.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lakeformation-permissions.html#cfn-lakeformation-permissions-permissions">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lakeformation-permissions.html#cfn-lakeformation-permissions-permissions</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getPermissions() {
        return null;
    }

    /**
     * Indicates the ability to grant permissions (as a subset of permissions granted).
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lakeformation-permissions.html#cfn-lakeformation-permissions-permissionswithgrantoption">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lakeformation-permissions.html#cfn-lakeformation-permissions-permissionswithgrantoption</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getPermissionsWithGrantOption() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnPermissionsProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnPermissionsProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnPermissionsProps> {
        java.lang.Object dataLakePrincipal;
        java.lang.Object resource;
        java.util.List<java.lang.String> permissions;
        java.util.List<java.lang.String> permissionsWithGrantOption;

        /**
         * Sets the value of {@link CfnPermissionsProps#getDataLakePrincipal}
         * @param dataLakePrincipal The AWS Lake Formation principal. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dataLakePrincipal(software.amazon.awscdk.IResolvable dataLakePrincipal) {
            this.dataLakePrincipal = dataLakePrincipal;
            return this;
        }

        /**
         * Sets the value of {@link CfnPermissionsProps#getDataLakePrincipal}
         * @param dataLakePrincipal The AWS Lake Formation principal. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dataLakePrincipal(software.amazon.awscdk.services.lakeformation.CfnPermissions.DataLakePrincipalProperty dataLakePrincipal) {
            this.dataLakePrincipal = dataLakePrincipal;
            return this;
        }

        /**
         * Sets the value of {@link CfnPermissionsProps#getResource}
         * @param resource A structure for the resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder resource(software.amazon.awscdk.IResolvable resource) {
            this.resource = resource;
            return this;
        }

        /**
         * Sets the value of {@link CfnPermissionsProps#getResource}
         * @param resource A structure for the resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder resource(software.amazon.awscdk.services.lakeformation.CfnPermissions.ResourceProperty resource) {
            this.resource = resource;
            return this;
        }

        /**
         * Sets the value of {@link CfnPermissionsProps#getPermissions}
         * @param permissions The permissions granted or revoked.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder permissions(java.util.List<java.lang.String> permissions) {
            this.permissions = permissions;
            return this;
        }

        /**
         * Sets the value of {@link CfnPermissionsProps#getPermissionsWithGrantOption}
         * @param permissionsWithGrantOption Indicates the ability to grant permissions (as a subset of permissions granted).
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder permissionsWithGrantOption(java.util.List<java.lang.String> permissionsWithGrantOption) {
            this.permissionsWithGrantOption = permissionsWithGrantOption;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnPermissionsProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnPermissionsProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnPermissionsProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnPermissionsProps {
        private final java.lang.Object dataLakePrincipal;
        private final java.lang.Object resource;
        private final java.util.List<java.lang.String> permissions;
        private final java.util.List<java.lang.String> permissionsWithGrantOption;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.dataLakePrincipal = software.amazon.jsii.Kernel.get(this, "dataLakePrincipal", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.resource = software.amazon.jsii.Kernel.get(this, "resource", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.permissions = software.amazon.jsii.Kernel.get(this, "permissions", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.permissionsWithGrantOption = software.amazon.jsii.Kernel.get(this, "permissionsWithGrantOption", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.dataLakePrincipal = java.util.Objects.requireNonNull(builder.dataLakePrincipal, "dataLakePrincipal is required");
            this.resource = java.util.Objects.requireNonNull(builder.resource, "resource is required");
            this.permissions = builder.permissions;
            this.permissionsWithGrantOption = builder.permissionsWithGrantOption;
        }

        @Override
        public final java.lang.Object getDataLakePrincipal() {
            return this.dataLakePrincipal;
        }

        @Override
        public final java.lang.Object getResource() {
            return this.resource;
        }

        @Override
        public final java.util.List<java.lang.String> getPermissions() {
            return this.permissions;
        }

        @Override
        public final java.util.List<java.lang.String> getPermissionsWithGrantOption() {
            return this.permissionsWithGrantOption;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("dataLakePrincipal", om.valueToTree(this.getDataLakePrincipal()));
            data.set("resource", om.valueToTree(this.getResource()));
            if (this.getPermissions() != null) {
                data.set("permissions", om.valueToTree(this.getPermissions()));
            }
            if (this.getPermissionsWithGrantOption() != null) {
                data.set("permissionsWithGrantOption", om.valueToTree(this.getPermissionsWithGrantOption()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_lakeformation.CfnPermissionsProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnPermissionsProps.Jsii$Proxy that = (CfnPermissionsProps.Jsii$Proxy) o;

            if (!dataLakePrincipal.equals(that.dataLakePrincipal)) return false;
            if (!resource.equals(that.resource)) return false;
            if (this.permissions != null ? !this.permissions.equals(that.permissions) : that.permissions != null) return false;
            return this.permissionsWithGrantOption != null ? this.permissionsWithGrantOption.equals(that.permissionsWithGrantOption) : that.permissionsWithGrantOption == null;
        }

        @Override
        public final int hashCode() {
            int result = this.dataLakePrincipal.hashCode();
            result = 31 * result + (this.resource.hashCode());
            result = 31 * result + (this.permissions != null ? this.permissions.hashCode() : 0);
            result = 31 * result + (this.permissionsWithGrantOption != null ? this.permissionsWithGrantOption.hashCode() : 0);
            return result;
        }
    }
}
