package software.amazon.awscdk.services.lex;

/**
 * <blockquote><p>Amazon Lex V2 is the only supported version in AWS CloudFormation .<p></blockquote>
 * <p>
 * Specifies an alias for the specified version of a bot. Use an alias to enable you to change the version of a bot without updating applications that use the bot.
 * <p>
 * For example, you can specify an alias called "PROD" that your applications use to call the Amazon Lex bot.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.lex.*;
 * Object sentimentAnalysisSettings;
 * CfnBotAlias cfnBotAlias = CfnBotAlias.Builder.create(this, "MyCfnBotAlias")
 *         .botAliasName("botAliasName")
 *         .botId("botId")
 *         // the properties below are optional
 *         .botAliasLocaleSettings(List.of(BotAliasLocaleSettingsItemProperty.builder()
 *                 .botAliasLocaleSetting(BotAliasLocaleSettingsProperty.builder()
 *                         .enabled(false)
 *                         // the properties below are optional
 *                         .codeHookSpecification(CodeHookSpecificationProperty.builder()
 *                                 .lambdaCodeHook(LambdaCodeHookProperty.builder()
 *                                         .codeHookInterfaceVersion("codeHookInterfaceVersion")
 *                                         .lambdaArn("lambdaArn")
 *                                         .build())
 *                                 .build())
 *                         .build())
 *                 .localeId("localeId")
 *                 .build()))
 *         .botAliasTags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .botVersion("botVersion")
 *         .conversationLogSettings(ConversationLogSettingsProperty.builder()
 *                 .audioLogSettings(List.of(AudioLogSettingProperty.builder()
 *                         .destination(AudioLogDestinationProperty.builder()
 *                                 .s3Bucket(S3BucketLogDestinationProperty.builder()
 *                                         .logPrefix("logPrefix")
 *                                         .s3BucketArn("s3BucketArn")
 *                                         // the properties below are optional
 *                                         .kmsKeyArn("kmsKeyArn")
 *                                         .build())
 *                                 .build())
 *                         .enabled(false)
 *                         .build()))
 *                 .textLogSettings(List.of(TextLogSettingProperty.builder()
 *                         .destination(TextLogDestinationProperty.builder()
 *                                 .cloudWatch(CloudWatchLogGroupLogDestinationProperty.builder()
 *                                         .cloudWatchLogGroupArn("cloudWatchLogGroupArn")
 *                                         .logPrefix("logPrefix")
 *                                         .build())
 *                                 .build())
 *                         .enabled(false)
 *                         .build()))
 *                 .build())
 *         .description("description")
 *         .sentimentAnalysisSettings(sentimentAnalysisSettings)
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lex-botalias.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lex-botalias.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-05-20T23:52:58.842Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_lex.CfnBotAlias")
public class CfnBotAlias extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable {

    protected CfnBotAlias(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnBotAlias(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.lex.CfnBotAlias.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * @param scope Scope in which this resource is defined. This parameter is required.
     * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
     * @param props Resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnBotAlias(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.lex.CfnBotAliasProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     * The Amazon Resource Name (ARN) of the bot alias.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrArn() {
        return software.amazon.jsii.Kernel.get(this, "attrArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The unique identifier of the bot alias.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrBotAliasId() {
        return software.amazon.jsii.Kernel.get(this, "attrBotAliasId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The current status of the bot alias.
     * <p>
     * When the status is Available the alias is ready for use with your bot.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrBotAliasStatus() {
        return software.amazon.jsii.Kernel.get(this, "attrBotAliasStatus", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * The name of the bot alias.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getBotAliasName() {
        return software.amazon.jsii.Kernel.get(this, "botAliasName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name of the bot alias.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setBotAliasName(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "botAliasName", java.util.Objects.requireNonNull(value, "botAliasName is required"));
    }

    /**
     * The unique identifier of the bot.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getBotId() {
        return software.amazon.jsii.Kernel.get(this, "botId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The unique identifier of the bot.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setBotId(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "botId", java.util.Objects.requireNonNull(value, "botId is required"));
    }

    /**
     * Specifies settings that are unique to a locale.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getBotAliasLocaleSettings() {
        return software.amazon.jsii.Kernel.get(this, "botAliasLocaleSettings", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Specifies settings that are unique to a locale.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setBotAliasLocaleSettings(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "botAliasLocaleSettings", value);
    }

    /**
     * Specifies settings that are unique to a locale.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setBotAliasLocaleSettings(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.Object> value) {
        if (software.amazon.jsii.Configuration.getRuntimeTypeChecking()) {
            for (int __idx_ac66f0 = 0; __idx_ac66f0 < value.size(); __idx_ac66f0++) {
                final java.lang.Object __val_ac66f0 = value.get(__idx_ac66f0);
                if (
                     !(__val_ac66f0 instanceof software.amazon.awscdk.IResolvable)
                    && !(__val_ac66f0 instanceof software.amazon.awscdk.services.lex.CfnBotAlias.BotAliasLocaleSettingsItemProperty)
                    && !(__val_ac66f0.getClass().equals(software.amazon.jsii.JsiiObject.class))
                ) {
                    throw new IllegalArgumentException(
                        new java.lang.StringBuilder("Expected ")
                            .append("value").append(".get(").append(__idx_ac66f0).append(")")
                            .append(" to be one of: software.amazon.awscdk.IResolvable, software.amazon.awscdk.services.lex.CfnBotAlias.BotAliasLocaleSettingsItemProperty; received ")
                            .append(__val_ac66f0.getClass()).toString());
                }
            }
        }
        software.amazon.jsii.Kernel.set(this, "botAliasLocaleSettings", value);
    }

    /**
     * An array of key-value pairs to apply to this resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getBotAliasTags() {
        return software.amazon.jsii.Kernel.get(this, "botAliasTags", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * An array of key-value pairs to apply to this resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setBotAliasTags(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "botAliasTags", value);
    }

    /**
     * An array of key-value pairs to apply to this resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setBotAliasTags(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.Object> value) {
        if (software.amazon.jsii.Configuration.getRuntimeTypeChecking()) {
            for (int __idx_ac66f0 = 0; __idx_ac66f0 < value.size(); __idx_ac66f0++) {
                final java.lang.Object __val_ac66f0 = value.get(__idx_ac66f0);
                if (
                     !(__val_ac66f0 instanceof software.amazon.awscdk.IResolvable)
                    && !(__val_ac66f0 instanceof software.amazon.awscdk.CfnTag)
                    && !(__val_ac66f0.getClass().equals(software.amazon.jsii.JsiiObject.class))
                ) {
                    throw new IllegalArgumentException(
                        new java.lang.StringBuilder("Expected ")
                            .append("value").append(".get(").append(__idx_ac66f0).append(")")
                            .append(" to be one of: software.amazon.awscdk.IResolvable, software.amazon.awscdk.CfnTag; received ")
                            .append(__val_ac66f0.getClass()).toString());
                }
            }
        }
        software.amazon.jsii.Kernel.set(this, "botAliasTags", value);
    }

    /**
     * The version of the bot that the bot alias references.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getBotVersion() {
        return software.amazon.jsii.Kernel.get(this, "botVersion", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The version of the bot that the bot alias references.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setBotVersion(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "botVersion", value);
    }

    /**
     * Specifies whether Amazon Lex logs text and audio for conversations with the bot.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getConversationLogSettings() {
        return software.amazon.jsii.Kernel.get(this, "conversationLogSettings", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Specifies whether Amazon Lex logs text and audio for conversations with the bot.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setConversationLogSettings(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "conversationLogSettings", value);
    }

    /**
     * Specifies whether Amazon Lex logs text and audio for conversations with the bot.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setConversationLogSettings(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.lex.CfnBotAlias.ConversationLogSettingsProperty value) {
        software.amazon.jsii.Kernel.set(this, "conversationLogSettings", value);
    }

    /**
     * The description of the bot alias.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
        return software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The description of the bot alias.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDescription(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "description", value);
    }

    /**
     * Determines whether Amazon Lex will use Amazon Comprehend to detect the sentiment of user utterances.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getSentimentAnalysisSettings() {
        return software.amazon.jsii.Kernel.get(this, "sentimentAnalysisSettings", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Determines whether Amazon Lex will use Amazon Comprehend to detect the sentiment of user utterances.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSentimentAnalysisSettings(final @org.jetbrains.annotations.Nullable java.lang.Object value) {
        software.amazon.jsii.Kernel.set(this, "sentimentAnalysisSettings", value);
    }
    /**
     * Specifies the S3 bucket location where audio logs are stored.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.lex.*;
     * AudioLogDestinationProperty audioLogDestinationProperty = AudioLogDestinationProperty.builder()
     *         .s3Bucket(S3BucketLogDestinationProperty.builder()
     *                 .logPrefix("logPrefix")
     *                 .s3BucketArn("s3BucketArn")
     *                 // the properties below are optional
     *                 .kmsKeyArn("kmsKeyArn")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-botalias-audiologdestination.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-botalias-audiologdestination.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_lex.CfnBotAlias.AudioLogDestinationProperty")
    @software.amazon.jsii.Jsii.Proxy(AudioLogDestinationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface AudioLogDestinationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The S3 bucket location where audio logs are stored.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-botalias-audiologdestination.html#cfn-lex-botalias-audiologdestination-s3bucket">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-botalias-audiologdestination.html#cfn-lex-botalias-audiologdestination-s3bucket</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getS3Bucket();

        /**
         * @return a {@link Builder} of {@link AudioLogDestinationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link AudioLogDestinationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<AudioLogDestinationProperty> {
            java.lang.Object s3Bucket;

            /**
             * Sets the value of {@link AudioLogDestinationProperty#getS3Bucket}
             * @param s3Bucket The S3 bucket location where audio logs are stored. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder s3Bucket(software.amazon.awscdk.IResolvable s3Bucket) {
                this.s3Bucket = s3Bucket;
                return this;
            }

            /**
             * Sets the value of {@link AudioLogDestinationProperty#getS3Bucket}
             * @param s3Bucket The S3 bucket location where audio logs are stored. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder s3Bucket(software.amazon.awscdk.services.lex.CfnBotAlias.S3BucketLogDestinationProperty s3Bucket) {
                this.s3Bucket = s3Bucket;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link AudioLogDestinationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public AudioLogDestinationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link AudioLogDestinationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AudioLogDestinationProperty {
            private final java.lang.Object s3Bucket;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.s3Bucket = software.amazon.jsii.Kernel.get(this, "s3Bucket", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.s3Bucket = java.util.Objects.requireNonNull(builder.s3Bucket, "s3Bucket is required");
            }

            @Override
            public final java.lang.Object getS3Bucket() {
                return this.s3Bucket;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("s3Bucket", om.valueToTree(this.getS3Bucket()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_lex.CfnBotAlias.AudioLogDestinationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                AudioLogDestinationProperty.Jsii$Proxy that = (AudioLogDestinationProperty.Jsii$Proxy) o;

                return this.s3Bucket.equals(that.s3Bucket);
            }

            @Override
            public final int hashCode() {
                int result = this.s3Bucket.hashCode();
                return result;
            }
        }
    }
    /**
     * Settings for logging audio of conversations between Amazon Lex and a user.
     * <p>
     * You specify whether to log audio and the Amazon S3 bucket where the audio file is stored.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.lex.*;
     * AudioLogSettingProperty audioLogSettingProperty = AudioLogSettingProperty.builder()
     *         .destination(AudioLogDestinationProperty.builder()
     *                 .s3Bucket(S3BucketLogDestinationProperty.builder()
     *                         .logPrefix("logPrefix")
     *                         .s3BucketArn("s3BucketArn")
     *                         // the properties below are optional
     *                         .kmsKeyArn("kmsKeyArn")
     *                         .build())
     *                 .build())
     *         .enabled(false)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-botalias-audiologsetting.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-botalias-audiologsetting.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_lex.CfnBotAlias.AudioLogSettingProperty")
    @software.amazon.jsii.Jsii.Proxy(AudioLogSettingProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface AudioLogSettingProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The location of audio log files collected when conversation logging is enabled for a bot.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-botalias-audiologsetting.html#cfn-lex-botalias-audiologsetting-destination">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-botalias-audiologsetting.html#cfn-lex-botalias-audiologsetting-destination</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getDestination();

        /**
         * Determines whether audio logging in enabled for the bot.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-botalias-audiologsetting.html#cfn-lex-botalias-audiologsetting-enabled">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-botalias-audiologsetting.html#cfn-lex-botalias-audiologsetting-enabled</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getEnabled();

        /**
         * @return a {@link Builder} of {@link AudioLogSettingProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link AudioLogSettingProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<AudioLogSettingProperty> {
            java.lang.Object destination;
            java.lang.Object enabled;

            /**
             * Sets the value of {@link AudioLogSettingProperty#getDestination}
             * @param destination The location of audio log files collected when conversation logging is enabled for a bot. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder destination(software.amazon.awscdk.IResolvable destination) {
                this.destination = destination;
                return this;
            }

            /**
             * Sets the value of {@link AudioLogSettingProperty#getDestination}
             * @param destination The location of audio log files collected when conversation logging is enabled for a bot. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder destination(software.amazon.awscdk.services.lex.CfnBotAlias.AudioLogDestinationProperty destination) {
                this.destination = destination;
                return this;
            }

            /**
             * Sets the value of {@link AudioLogSettingProperty#getEnabled}
             * @param enabled Determines whether audio logging in enabled for the bot. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder enabled(java.lang.Boolean enabled) {
                this.enabled = enabled;
                return this;
            }

            /**
             * Sets the value of {@link AudioLogSettingProperty#getEnabled}
             * @param enabled Determines whether audio logging in enabled for the bot. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder enabled(software.amazon.awscdk.IResolvable enabled) {
                this.enabled = enabled;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link AudioLogSettingProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public AudioLogSettingProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link AudioLogSettingProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AudioLogSettingProperty {
            private final java.lang.Object destination;
            private final java.lang.Object enabled;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.destination = software.amazon.jsii.Kernel.get(this, "destination", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.enabled = software.amazon.jsii.Kernel.get(this, "enabled", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.destination = java.util.Objects.requireNonNull(builder.destination, "destination is required");
                this.enabled = java.util.Objects.requireNonNull(builder.enabled, "enabled is required");
            }

            @Override
            public final java.lang.Object getDestination() {
                return this.destination;
            }

            @Override
            public final java.lang.Object getEnabled() {
                return this.enabled;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("destination", om.valueToTree(this.getDestination()));
                data.set("enabled", om.valueToTree(this.getEnabled()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_lex.CfnBotAlias.AudioLogSettingProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                AudioLogSettingProperty.Jsii$Proxy that = (AudioLogSettingProperty.Jsii$Proxy) o;

                if (!destination.equals(that.destination)) return false;
                return this.enabled.equals(that.enabled);
            }

            @Override
            public final int hashCode() {
                int result = this.destination.hashCode();
                result = 31 * result + (this.enabled.hashCode());
                return result;
            }
        }
    }
    /**
     * Specifies settings that are unique to a locale.
     * <p>
     * For example, you can use different Lambda function depending on the bot's locale.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.lex.*;
     * BotAliasLocaleSettingsItemProperty botAliasLocaleSettingsItemProperty = BotAliasLocaleSettingsItemProperty.builder()
     *         .botAliasLocaleSetting(BotAliasLocaleSettingsProperty.builder()
     *                 .enabled(false)
     *                 // the properties below are optional
     *                 .codeHookSpecification(CodeHookSpecificationProperty.builder()
     *                         .lambdaCodeHook(LambdaCodeHookProperty.builder()
     *                                 .codeHookInterfaceVersion("codeHookInterfaceVersion")
     *                                 .lambdaArn("lambdaArn")
     *                                 .build())
     *                         .build())
     *                 .build())
     *         .localeId("localeId")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-botalias-botaliaslocalesettingsitem.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-botalias-botaliaslocalesettingsitem.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_lex.CfnBotAlias.BotAliasLocaleSettingsItemProperty")
    @software.amazon.jsii.Jsii.Proxy(BotAliasLocaleSettingsItemProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface BotAliasLocaleSettingsItemProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Specifies settings that are unique to a locale.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-botalias-botaliaslocalesettingsitem.html#cfn-lex-botalias-botaliaslocalesettingsitem-botaliaslocalesetting">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-botalias-botaliaslocalesettingsitem.html#cfn-lex-botalias-botaliaslocalesettingsitem-botaliaslocalesetting</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getBotAliasLocaleSetting();

        /**
         * The unique identifier of the locale.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-botalias-botaliaslocalesettingsitem.html#cfn-lex-botalias-botaliaslocalesettingsitem-localeid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-botalias-botaliaslocalesettingsitem.html#cfn-lex-botalias-botaliaslocalesettingsitem-localeid</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getLocaleId();

        /**
         * @return a {@link Builder} of {@link BotAliasLocaleSettingsItemProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link BotAliasLocaleSettingsItemProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<BotAliasLocaleSettingsItemProperty> {
            java.lang.Object botAliasLocaleSetting;
            java.lang.String localeId;

            /**
             * Sets the value of {@link BotAliasLocaleSettingsItemProperty#getBotAliasLocaleSetting}
             * @param botAliasLocaleSetting Specifies settings that are unique to a locale. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder botAliasLocaleSetting(software.amazon.awscdk.IResolvable botAliasLocaleSetting) {
                this.botAliasLocaleSetting = botAliasLocaleSetting;
                return this;
            }

            /**
             * Sets the value of {@link BotAliasLocaleSettingsItemProperty#getBotAliasLocaleSetting}
             * @param botAliasLocaleSetting Specifies settings that are unique to a locale. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder botAliasLocaleSetting(software.amazon.awscdk.services.lex.CfnBotAlias.BotAliasLocaleSettingsProperty botAliasLocaleSetting) {
                this.botAliasLocaleSetting = botAliasLocaleSetting;
                return this;
            }

            /**
             * Sets the value of {@link BotAliasLocaleSettingsItemProperty#getLocaleId}
             * @param localeId The unique identifier of the locale. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder localeId(java.lang.String localeId) {
                this.localeId = localeId;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link BotAliasLocaleSettingsItemProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public BotAliasLocaleSettingsItemProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link BotAliasLocaleSettingsItemProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements BotAliasLocaleSettingsItemProperty {
            private final java.lang.Object botAliasLocaleSetting;
            private final java.lang.String localeId;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.botAliasLocaleSetting = software.amazon.jsii.Kernel.get(this, "botAliasLocaleSetting", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.localeId = software.amazon.jsii.Kernel.get(this, "localeId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.botAliasLocaleSetting = java.util.Objects.requireNonNull(builder.botAliasLocaleSetting, "botAliasLocaleSetting is required");
                this.localeId = java.util.Objects.requireNonNull(builder.localeId, "localeId is required");
            }

            @Override
            public final java.lang.Object getBotAliasLocaleSetting() {
                return this.botAliasLocaleSetting;
            }

            @Override
            public final java.lang.String getLocaleId() {
                return this.localeId;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("botAliasLocaleSetting", om.valueToTree(this.getBotAliasLocaleSetting()));
                data.set("localeId", om.valueToTree(this.getLocaleId()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_lex.CfnBotAlias.BotAliasLocaleSettingsItemProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                BotAliasLocaleSettingsItemProperty.Jsii$Proxy that = (BotAliasLocaleSettingsItemProperty.Jsii$Proxy) o;

                if (!botAliasLocaleSetting.equals(that.botAliasLocaleSetting)) return false;
                return this.localeId.equals(that.localeId);
            }

            @Override
            public final int hashCode() {
                int result = this.botAliasLocaleSetting.hashCode();
                result = 31 * result + (this.localeId.hashCode());
                return result;
            }
        }
    }
    /**
     * Specifies settings that are unique to a locale.
     * <p>
     * For example, you can use different Lambda function depending on the bot's locale.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.lex.*;
     * BotAliasLocaleSettingsProperty botAliasLocaleSettingsProperty = BotAliasLocaleSettingsProperty.builder()
     *         .enabled(false)
     *         // the properties below are optional
     *         .codeHookSpecification(CodeHookSpecificationProperty.builder()
     *                 .lambdaCodeHook(LambdaCodeHookProperty.builder()
     *                         .codeHookInterfaceVersion("codeHookInterfaceVersion")
     *                         .lambdaArn("lambdaArn")
     *                         .build())
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-botalias-botaliaslocalesettings.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-botalias-botaliaslocalesettings.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_lex.CfnBotAlias.BotAliasLocaleSettingsProperty")
    @software.amazon.jsii.Jsii.Proxy(BotAliasLocaleSettingsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface BotAliasLocaleSettingsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Determines whether the locale is enabled for the bot.
         * <p>
         * If the value is <code>false</code> , the locale isn't available for use.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-botalias-botaliaslocalesettings.html#cfn-lex-botalias-botaliaslocalesettings-enabled">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-botalias-botaliaslocalesettings.html#cfn-lex-botalias-botaliaslocalesettings-enabled</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getEnabled();

        /**
         * Specifies the Lambda function that should be used in the locale.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-botalias-botaliaslocalesettings.html#cfn-lex-botalias-botaliaslocalesettings-codehookspecification">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-botalias-botaliaslocalesettings.html#cfn-lex-botalias-botaliaslocalesettings-codehookspecification</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getCodeHookSpecification() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link BotAliasLocaleSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link BotAliasLocaleSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<BotAliasLocaleSettingsProperty> {
            java.lang.Object enabled;
            java.lang.Object codeHookSpecification;

            /**
             * Sets the value of {@link BotAliasLocaleSettingsProperty#getEnabled}
             * @param enabled Determines whether the locale is enabled for the bot. This parameter is required.
             *                If the value is <code>false</code> , the locale isn't available for use.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder enabled(java.lang.Boolean enabled) {
                this.enabled = enabled;
                return this;
            }

            /**
             * Sets the value of {@link BotAliasLocaleSettingsProperty#getEnabled}
             * @param enabled Determines whether the locale is enabled for the bot. This parameter is required.
             *                If the value is <code>false</code> , the locale isn't available for use.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder enabled(software.amazon.awscdk.IResolvable enabled) {
                this.enabled = enabled;
                return this;
            }

            /**
             * Sets the value of {@link BotAliasLocaleSettingsProperty#getCodeHookSpecification}
             * @param codeHookSpecification Specifies the Lambda function that should be used in the locale.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder codeHookSpecification(software.amazon.awscdk.IResolvable codeHookSpecification) {
                this.codeHookSpecification = codeHookSpecification;
                return this;
            }

            /**
             * Sets the value of {@link BotAliasLocaleSettingsProperty#getCodeHookSpecification}
             * @param codeHookSpecification Specifies the Lambda function that should be used in the locale.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder codeHookSpecification(software.amazon.awscdk.services.lex.CfnBotAlias.CodeHookSpecificationProperty codeHookSpecification) {
                this.codeHookSpecification = codeHookSpecification;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link BotAliasLocaleSettingsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public BotAliasLocaleSettingsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link BotAliasLocaleSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements BotAliasLocaleSettingsProperty {
            private final java.lang.Object enabled;
            private final java.lang.Object codeHookSpecification;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.enabled = software.amazon.jsii.Kernel.get(this, "enabled", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.codeHookSpecification = software.amazon.jsii.Kernel.get(this, "codeHookSpecification", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.enabled = java.util.Objects.requireNonNull(builder.enabled, "enabled is required");
                this.codeHookSpecification = builder.codeHookSpecification;
            }

            @Override
            public final java.lang.Object getEnabled() {
                return this.enabled;
            }

            @Override
            public final java.lang.Object getCodeHookSpecification() {
                return this.codeHookSpecification;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("enabled", om.valueToTree(this.getEnabled()));
                if (this.getCodeHookSpecification() != null) {
                    data.set("codeHookSpecification", om.valueToTree(this.getCodeHookSpecification()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_lex.CfnBotAlias.BotAliasLocaleSettingsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                BotAliasLocaleSettingsProperty.Jsii$Proxy that = (BotAliasLocaleSettingsProperty.Jsii$Proxy) o;

                if (!enabled.equals(that.enabled)) return false;
                return this.codeHookSpecification != null ? this.codeHookSpecification.equals(that.codeHookSpecification) : that.codeHookSpecification == null;
            }

            @Override
            public final int hashCode() {
                int result = this.enabled.hashCode();
                result = 31 * result + (this.codeHookSpecification != null ? this.codeHookSpecification.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The Amazon CloudWatch Logs log group where the text and metadata logs are delivered.
     * <p>
     * The log group must exist before you enable logging.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.lex.*;
     * CloudWatchLogGroupLogDestinationProperty cloudWatchLogGroupLogDestinationProperty = CloudWatchLogGroupLogDestinationProperty.builder()
     *         .cloudWatchLogGroupArn("cloudWatchLogGroupArn")
     *         .logPrefix("logPrefix")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-botalias-cloudwatchloggrouplogdestination.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-botalias-cloudwatchloggrouplogdestination.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_lex.CfnBotAlias.CloudWatchLogGroupLogDestinationProperty")
    @software.amazon.jsii.Jsii.Proxy(CloudWatchLogGroupLogDestinationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface CloudWatchLogGroupLogDestinationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The Amazon Resource Name (ARN) of the log group where text and metadata logs are delivered.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-botalias-cloudwatchloggrouplogdestination.html#cfn-lex-botalias-cloudwatchloggrouplogdestination-cloudwatchloggrouparn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-botalias-cloudwatchloggrouplogdestination.html#cfn-lex-botalias-cloudwatchloggrouplogdestination-cloudwatchloggrouparn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getCloudWatchLogGroupArn();

        /**
         * The prefix of the log stream name within the log group that you specified.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-botalias-cloudwatchloggrouplogdestination.html#cfn-lex-botalias-cloudwatchloggrouplogdestination-logprefix">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-botalias-cloudwatchloggrouplogdestination.html#cfn-lex-botalias-cloudwatchloggrouplogdestination-logprefix</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getLogPrefix();

        /**
         * @return a {@link Builder} of {@link CloudWatchLogGroupLogDestinationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link CloudWatchLogGroupLogDestinationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<CloudWatchLogGroupLogDestinationProperty> {
            java.lang.String cloudWatchLogGroupArn;
            java.lang.String logPrefix;

            /**
             * Sets the value of {@link CloudWatchLogGroupLogDestinationProperty#getCloudWatchLogGroupArn}
             * @param cloudWatchLogGroupArn The Amazon Resource Name (ARN) of the log group where text and metadata logs are delivered. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder cloudWatchLogGroupArn(java.lang.String cloudWatchLogGroupArn) {
                this.cloudWatchLogGroupArn = cloudWatchLogGroupArn;
                return this;
            }

            /**
             * Sets the value of {@link CloudWatchLogGroupLogDestinationProperty#getLogPrefix}
             * @param logPrefix The prefix of the log stream name within the log group that you specified. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder logPrefix(java.lang.String logPrefix) {
                this.logPrefix = logPrefix;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link CloudWatchLogGroupLogDestinationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public CloudWatchLogGroupLogDestinationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link CloudWatchLogGroupLogDestinationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CloudWatchLogGroupLogDestinationProperty {
            private final java.lang.String cloudWatchLogGroupArn;
            private final java.lang.String logPrefix;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.cloudWatchLogGroupArn = software.amazon.jsii.Kernel.get(this, "cloudWatchLogGroupArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.logPrefix = software.amazon.jsii.Kernel.get(this, "logPrefix", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.cloudWatchLogGroupArn = java.util.Objects.requireNonNull(builder.cloudWatchLogGroupArn, "cloudWatchLogGroupArn is required");
                this.logPrefix = java.util.Objects.requireNonNull(builder.logPrefix, "logPrefix is required");
            }

            @Override
            public final java.lang.String getCloudWatchLogGroupArn() {
                return this.cloudWatchLogGroupArn;
            }

            @Override
            public final java.lang.String getLogPrefix() {
                return this.logPrefix;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("cloudWatchLogGroupArn", om.valueToTree(this.getCloudWatchLogGroupArn()));
                data.set("logPrefix", om.valueToTree(this.getLogPrefix()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_lex.CfnBotAlias.CloudWatchLogGroupLogDestinationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                CloudWatchLogGroupLogDestinationProperty.Jsii$Proxy that = (CloudWatchLogGroupLogDestinationProperty.Jsii$Proxy) o;

                if (!cloudWatchLogGroupArn.equals(that.cloudWatchLogGroupArn)) return false;
                return this.logPrefix.equals(that.logPrefix);
            }

            @Override
            public final int hashCode() {
                int result = this.cloudWatchLogGroupArn.hashCode();
                result = 31 * result + (this.logPrefix.hashCode());
                return result;
            }
        }
    }
    /**
     * Contains information about code hooks that Amazon Lex calls during a conversation.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.lex.*;
     * CodeHookSpecificationProperty codeHookSpecificationProperty = CodeHookSpecificationProperty.builder()
     *         .lambdaCodeHook(LambdaCodeHookProperty.builder()
     *                 .codeHookInterfaceVersion("codeHookInterfaceVersion")
     *                 .lambdaArn("lambdaArn")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-botalias-codehookspecification.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-botalias-codehookspecification.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_lex.CfnBotAlias.CodeHookSpecificationProperty")
    @software.amazon.jsii.Jsii.Proxy(CodeHookSpecificationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface CodeHookSpecificationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Specifies a Lambda function that verifies requests to a bot or fulfills the user's request to a bot.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-botalias-codehookspecification.html#cfn-lex-botalias-codehookspecification-lambdacodehook">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-botalias-codehookspecification.html#cfn-lex-botalias-codehookspecification-lambdacodehook</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getLambdaCodeHook();

        /**
         * @return a {@link Builder} of {@link CodeHookSpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link CodeHookSpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<CodeHookSpecificationProperty> {
            java.lang.Object lambdaCodeHook;

            /**
             * Sets the value of {@link CodeHookSpecificationProperty#getLambdaCodeHook}
             * @param lambdaCodeHook Specifies a Lambda function that verifies requests to a bot or fulfills the user's request to a bot. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder lambdaCodeHook(software.amazon.awscdk.IResolvable lambdaCodeHook) {
                this.lambdaCodeHook = lambdaCodeHook;
                return this;
            }

            /**
             * Sets the value of {@link CodeHookSpecificationProperty#getLambdaCodeHook}
             * @param lambdaCodeHook Specifies a Lambda function that verifies requests to a bot or fulfills the user's request to a bot. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder lambdaCodeHook(software.amazon.awscdk.services.lex.CfnBotAlias.LambdaCodeHookProperty lambdaCodeHook) {
                this.lambdaCodeHook = lambdaCodeHook;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link CodeHookSpecificationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public CodeHookSpecificationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link CodeHookSpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CodeHookSpecificationProperty {
            private final java.lang.Object lambdaCodeHook;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.lambdaCodeHook = software.amazon.jsii.Kernel.get(this, "lambdaCodeHook", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.lambdaCodeHook = java.util.Objects.requireNonNull(builder.lambdaCodeHook, "lambdaCodeHook is required");
            }

            @Override
            public final java.lang.Object getLambdaCodeHook() {
                return this.lambdaCodeHook;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("lambdaCodeHook", om.valueToTree(this.getLambdaCodeHook()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_lex.CfnBotAlias.CodeHookSpecificationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                CodeHookSpecificationProperty.Jsii$Proxy that = (CodeHookSpecificationProperty.Jsii$Proxy) o;

                return this.lambdaCodeHook.equals(that.lambdaCodeHook);
            }

            @Override
            public final int hashCode() {
                int result = this.lambdaCodeHook.hashCode();
                return result;
            }
        }
    }
    /**
     * Configures conversation logging that saves audio, text, and metadata for the conversations with your users.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.lex.*;
     * ConversationLogSettingsProperty conversationLogSettingsProperty = ConversationLogSettingsProperty.builder()
     *         .audioLogSettings(List.of(AudioLogSettingProperty.builder()
     *                 .destination(AudioLogDestinationProperty.builder()
     *                         .s3Bucket(S3BucketLogDestinationProperty.builder()
     *                                 .logPrefix("logPrefix")
     *                                 .s3BucketArn("s3BucketArn")
     *                                 // the properties below are optional
     *                                 .kmsKeyArn("kmsKeyArn")
     *                                 .build())
     *                         .build())
     *                 .enabled(false)
     *                 .build()))
     *         .textLogSettings(List.of(TextLogSettingProperty.builder()
     *                 .destination(TextLogDestinationProperty.builder()
     *                         .cloudWatch(CloudWatchLogGroupLogDestinationProperty.builder()
     *                                 .cloudWatchLogGroupArn("cloudWatchLogGroupArn")
     *                                 .logPrefix("logPrefix")
     *                                 .build())
     *                         .build())
     *                 .enabled(false)
     *                 .build()))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-botalias-conversationlogsettings.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-botalias-conversationlogsettings.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_lex.CfnBotAlias.ConversationLogSettingsProperty")
    @software.amazon.jsii.Jsii.Proxy(ConversationLogSettingsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ConversationLogSettingsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The Amazon S3 settings for logging audio to an S3 bucket.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-botalias-conversationlogsettings.html#cfn-lex-botalias-conversationlogsettings-audiologsettings">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-botalias-conversationlogsettings.html#cfn-lex-botalias-conversationlogsettings-audiologsettings</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getAudioLogSettings() {
            return null;
        }

        /**
         * The Amazon CloudWatch Logs settings for logging text and metadata.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-botalias-conversationlogsettings.html#cfn-lex-botalias-conversationlogsettings-textlogsettings">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-botalias-conversationlogsettings.html#cfn-lex-botalias-conversationlogsettings-textlogsettings</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getTextLogSettings() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ConversationLogSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ConversationLogSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ConversationLogSettingsProperty> {
            java.lang.Object audioLogSettings;
            java.lang.Object textLogSettings;

            /**
             * Sets the value of {@link ConversationLogSettingsProperty#getAudioLogSettings}
             * @param audioLogSettings The Amazon S3 settings for logging audio to an S3 bucket.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder audioLogSettings(software.amazon.awscdk.IResolvable audioLogSettings) {
                this.audioLogSettings = audioLogSettings;
                return this;
            }

            /**
             * Sets the value of {@link ConversationLogSettingsProperty#getAudioLogSettings}
             * @param audioLogSettings The Amazon S3 settings for logging audio to an S3 bucket.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder audioLogSettings(java.util.List<? extends java.lang.Object> audioLogSettings) {
                this.audioLogSettings = audioLogSettings;
                return this;
            }

            /**
             * Sets the value of {@link ConversationLogSettingsProperty#getTextLogSettings}
             * @param textLogSettings The Amazon CloudWatch Logs settings for logging text and metadata.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder textLogSettings(software.amazon.awscdk.IResolvable textLogSettings) {
                this.textLogSettings = textLogSettings;
                return this;
            }

            /**
             * Sets the value of {@link ConversationLogSettingsProperty#getTextLogSettings}
             * @param textLogSettings The Amazon CloudWatch Logs settings for logging text and metadata.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder textLogSettings(java.util.List<? extends java.lang.Object> textLogSettings) {
                this.textLogSettings = textLogSettings;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ConversationLogSettingsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ConversationLogSettingsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ConversationLogSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ConversationLogSettingsProperty {
            private final java.lang.Object audioLogSettings;
            private final java.lang.Object textLogSettings;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.audioLogSettings = software.amazon.jsii.Kernel.get(this, "audioLogSettings", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.textLogSettings = software.amazon.jsii.Kernel.get(this, "textLogSettings", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.audioLogSettings = builder.audioLogSettings;
                this.textLogSettings = builder.textLogSettings;
            }

            @Override
            public final java.lang.Object getAudioLogSettings() {
                return this.audioLogSettings;
            }

            @Override
            public final java.lang.Object getTextLogSettings() {
                return this.textLogSettings;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getAudioLogSettings() != null) {
                    data.set("audioLogSettings", om.valueToTree(this.getAudioLogSettings()));
                }
                if (this.getTextLogSettings() != null) {
                    data.set("textLogSettings", om.valueToTree(this.getTextLogSettings()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_lex.CfnBotAlias.ConversationLogSettingsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ConversationLogSettingsProperty.Jsii$Proxy that = (ConversationLogSettingsProperty.Jsii$Proxy) o;

                if (this.audioLogSettings != null ? !this.audioLogSettings.equals(that.audioLogSettings) : that.audioLogSettings != null) return false;
                return this.textLogSettings != null ? this.textLogSettings.equals(that.textLogSettings) : that.textLogSettings == null;
            }

            @Override
            public final int hashCode() {
                int result = this.audioLogSettings != null ? this.audioLogSettings.hashCode() : 0;
                result = 31 * result + (this.textLogSettings != null ? this.textLogSettings.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Specifies a Lambda function that verifies requests to a bot or fulfills the user's request to a bot.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.lex.*;
     * LambdaCodeHookProperty lambdaCodeHookProperty = LambdaCodeHookProperty.builder()
     *         .codeHookInterfaceVersion("codeHookInterfaceVersion")
     *         .lambdaArn("lambdaArn")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-botalias-lambdacodehook.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-botalias-lambdacodehook.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_lex.CfnBotAlias.LambdaCodeHookProperty")
    @software.amazon.jsii.Jsii.Proxy(LambdaCodeHookProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface LambdaCodeHookProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The version of the request-response that you want Amazon Lex to use to invoke your Lambda function.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-botalias-lambdacodehook.html#cfn-lex-botalias-lambdacodehook-codehookinterfaceversion">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-botalias-lambdacodehook.html#cfn-lex-botalias-lambdacodehook-codehookinterfaceversion</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getCodeHookInterfaceVersion();

        /**
         * The Amazon Resource Name (ARN) of the Lambda function.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-botalias-lambdacodehook.html#cfn-lex-botalias-lambdacodehook-lambdaarn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-botalias-lambdacodehook.html#cfn-lex-botalias-lambdacodehook-lambdaarn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getLambdaArn();

        /**
         * @return a {@link Builder} of {@link LambdaCodeHookProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link LambdaCodeHookProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<LambdaCodeHookProperty> {
            java.lang.String codeHookInterfaceVersion;
            java.lang.String lambdaArn;

            /**
             * Sets the value of {@link LambdaCodeHookProperty#getCodeHookInterfaceVersion}
             * @param codeHookInterfaceVersion The version of the request-response that you want Amazon Lex to use to invoke your Lambda function. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder codeHookInterfaceVersion(java.lang.String codeHookInterfaceVersion) {
                this.codeHookInterfaceVersion = codeHookInterfaceVersion;
                return this;
            }

            /**
             * Sets the value of {@link LambdaCodeHookProperty#getLambdaArn}
             * @param lambdaArn The Amazon Resource Name (ARN) of the Lambda function. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder lambdaArn(java.lang.String lambdaArn) {
                this.lambdaArn = lambdaArn;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link LambdaCodeHookProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public LambdaCodeHookProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link LambdaCodeHookProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements LambdaCodeHookProperty {
            private final java.lang.String codeHookInterfaceVersion;
            private final java.lang.String lambdaArn;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.codeHookInterfaceVersion = software.amazon.jsii.Kernel.get(this, "codeHookInterfaceVersion", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.lambdaArn = software.amazon.jsii.Kernel.get(this, "lambdaArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.codeHookInterfaceVersion = java.util.Objects.requireNonNull(builder.codeHookInterfaceVersion, "codeHookInterfaceVersion is required");
                this.lambdaArn = java.util.Objects.requireNonNull(builder.lambdaArn, "lambdaArn is required");
            }

            @Override
            public final java.lang.String getCodeHookInterfaceVersion() {
                return this.codeHookInterfaceVersion;
            }

            @Override
            public final java.lang.String getLambdaArn() {
                return this.lambdaArn;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("codeHookInterfaceVersion", om.valueToTree(this.getCodeHookInterfaceVersion()));
                data.set("lambdaArn", om.valueToTree(this.getLambdaArn()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_lex.CfnBotAlias.LambdaCodeHookProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                LambdaCodeHookProperty.Jsii$Proxy that = (LambdaCodeHookProperty.Jsii$Proxy) o;

                if (!codeHookInterfaceVersion.equals(that.codeHookInterfaceVersion)) return false;
                return this.lambdaArn.equals(that.lambdaArn);
            }

            @Override
            public final int hashCode() {
                int result = this.codeHookInterfaceVersion.hashCode();
                result = 31 * result + (this.lambdaArn.hashCode());
                return result;
            }
        }
    }
    /**
     * Specifies an Amazon S3 bucket for logging audio conversations.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.lex.*;
     * S3BucketLogDestinationProperty s3BucketLogDestinationProperty = S3BucketLogDestinationProperty.builder()
     *         .logPrefix("logPrefix")
     *         .s3BucketArn("s3BucketArn")
     *         // the properties below are optional
     *         .kmsKeyArn("kmsKeyArn")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-botalias-s3bucketlogdestination.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-botalias-s3bucketlogdestination.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_lex.CfnBotAlias.S3BucketLogDestinationProperty")
    @software.amazon.jsii.Jsii.Proxy(S3BucketLogDestinationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface S3BucketLogDestinationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The S3 prefix to assign to audio log files.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-botalias-s3bucketlogdestination.html#cfn-lex-botalias-s3bucketlogdestination-logprefix">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-botalias-s3bucketlogdestination.html#cfn-lex-botalias-s3bucketlogdestination-logprefix</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getLogPrefix();

        /**
         * The Amazon Resource Name (ARN) of an Amazon S3 bucket where audio log files are stored.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-botalias-s3bucketlogdestination.html#cfn-lex-botalias-s3bucketlogdestination-s3bucketarn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-botalias-s3bucketlogdestination.html#cfn-lex-botalias-s3bucketlogdestination-s3bucketarn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getS3BucketArn();

        /**
         * The Amazon Resource Name (ARN) of an AWS Key Management Service (KMS) key for encrypting audio log files stored in an Amazon S3 bucket.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-botalias-s3bucketlogdestination.html#cfn-lex-botalias-s3bucketlogdestination-kmskeyarn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-botalias-s3bucketlogdestination.html#cfn-lex-botalias-s3bucketlogdestination-kmskeyarn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getKmsKeyArn() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link S3BucketLogDestinationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link S3BucketLogDestinationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<S3BucketLogDestinationProperty> {
            java.lang.String logPrefix;
            java.lang.String s3BucketArn;
            java.lang.String kmsKeyArn;

            /**
             * Sets the value of {@link S3BucketLogDestinationProperty#getLogPrefix}
             * @param logPrefix The S3 prefix to assign to audio log files. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder logPrefix(java.lang.String logPrefix) {
                this.logPrefix = logPrefix;
                return this;
            }

            /**
             * Sets the value of {@link S3BucketLogDestinationProperty#getS3BucketArn}
             * @param s3BucketArn The Amazon Resource Name (ARN) of an Amazon S3 bucket where audio log files are stored. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder s3BucketArn(java.lang.String s3BucketArn) {
                this.s3BucketArn = s3BucketArn;
                return this;
            }

            /**
             * Sets the value of {@link S3BucketLogDestinationProperty#getKmsKeyArn}
             * @param kmsKeyArn The Amazon Resource Name (ARN) of an AWS Key Management Service (KMS) key for encrypting audio log files stored in an Amazon S3 bucket.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder kmsKeyArn(java.lang.String kmsKeyArn) {
                this.kmsKeyArn = kmsKeyArn;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link S3BucketLogDestinationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public S3BucketLogDestinationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link S3BucketLogDestinationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements S3BucketLogDestinationProperty {
            private final java.lang.String logPrefix;
            private final java.lang.String s3BucketArn;
            private final java.lang.String kmsKeyArn;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.logPrefix = software.amazon.jsii.Kernel.get(this, "logPrefix", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.s3BucketArn = software.amazon.jsii.Kernel.get(this, "s3BucketArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.kmsKeyArn = software.amazon.jsii.Kernel.get(this, "kmsKeyArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.logPrefix = java.util.Objects.requireNonNull(builder.logPrefix, "logPrefix is required");
                this.s3BucketArn = java.util.Objects.requireNonNull(builder.s3BucketArn, "s3BucketArn is required");
                this.kmsKeyArn = builder.kmsKeyArn;
            }

            @Override
            public final java.lang.String getLogPrefix() {
                return this.logPrefix;
            }

            @Override
            public final java.lang.String getS3BucketArn() {
                return this.s3BucketArn;
            }

            @Override
            public final java.lang.String getKmsKeyArn() {
                return this.kmsKeyArn;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("logPrefix", om.valueToTree(this.getLogPrefix()));
                data.set("s3BucketArn", om.valueToTree(this.getS3BucketArn()));
                if (this.getKmsKeyArn() != null) {
                    data.set("kmsKeyArn", om.valueToTree(this.getKmsKeyArn()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_lex.CfnBotAlias.S3BucketLogDestinationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                S3BucketLogDestinationProperty.Jsii$Proxy that = (S3BucketLogDestinationProperty.Jsii$Proxy) o;

                if (!logPrefix.equals(that.logPrefix)) return false;
                if (!s3BucketArn.equals(that.s3BucketArn)) return false;
                return this.kmsKeyArn != null ? this.kmsKeyArn.equals(that.kmsKeyArn) : that.kmsKeyArn == null;
            }

            @Override
            public final int hashCode() {
                int result = this.logPrefix.hashCode();
                result = 31 * result + (this.s3BucketArn.hashCode());
                result = 31 * result + (this.kmsKeyArn != null ? this.kmsKeyArn.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Determines whether Amazon Lex will use Amazon Comprehend to detect the sentiment of user utterances.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.lex.*;
     * SentimentAnalysisSettingsProperty sentimentAnalysisSettingsProperty = SentimentAnalysisSettingsProperty.builder()
     *         .detectSentiment(false)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-botalias-sentimentanalysissettings.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-botalias-sentimentanalysissettings.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_lex.CfnBotAlias.SentimentAnalysisSettingsProperty")
    @software.amazon.jsii.Jsii.Proxy(SentimentAnalysisSettingsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface SentimentAnalysisSettingsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Sets whether Amazon Lex uses Amazon Comprehend to detect the sentiment of user utterances.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-botalias-sentimentanalysissettings.html#cfn-lex-botalias-sentimentanalysissettings-detectsentiment">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-botalias-sentimentanalysissettings.html#cfn-lex-botalias-sentimentanalysissettings-detectsentiment</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getDetectSentiment();

        /**
         * @return a {@link Builder} of {@link SentimentAnalysisSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link SentimentAnalysisSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<SentimentAnalysisSettingsProperty> {
            java.lang.Object detectSentiment;

            /**
             * Sets the value of {@link SentimentAnalysisSettingsProperty#getDetectSentiment}
             * @param detectSentiment Sets whether Amazon Lex uses Amazon Comprehend to detect the sentiment of user utterances. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder detectSentiment(java.lang.Boolean detectSentiment) {
                this.detectSentiment = detectSentiment;
                return this;
            }

            /**
             * Sets the value of {@link SentimentAnalysisSettingsProperty#getDetectSentiment}
             * @param detectSentiment Sets whether Amazon Lex uses Amazon Comprehend to detect the sentiment of user utterances. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder detectSentiment(software.amazon.awscdk.IResolvable detectSentiment) {
                this.detectSentiment = detectSentiment;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link SentimentAnalysisSettingsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public SentimentAnalysisSettingsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link SentimentAnalysisSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SentimentAnalysisSettingsProperty {
            private final java.lang.Object detectSentiment;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.detectSentiment = software.amazon.jsii.Kernel.get(this, "detectSentiment", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.detectSentiment = java.util.Objects.requireNonNull(builder.detectSentiment, "detectSentiment is required");
            }

            @Override
            public final java.lang.Object getDetectSentiment() {
                return this.detectSentiment;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("detectSentiment", om.valueToTree(this.getDetectSentiment()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_lex.CfnBotAlias.SentimentAnalysisSettingsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                SentimentAnalysisSettingsProperty.Jsii$Proxy that = (SentimentAnalysisSettingsProperty.Jsii$Proxy) o;

                return this.detectSentiment.equals(that.detectSentiment);
            }

            @Override
            public final int hashCode() {
                int result = this.detectSentiment.hashCode();
                return result;
            }
        }
    }
    /**
     * Defines the Amazon CloudWatch Logs destination log group for conversation text logs.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.lex.*;
     * TextLogDestinationProperty textLogDestinationProperty = TextLogDestinationProperty.builder()
     *         .cloudWatch(CloudWatchLogGroupLogDestinationProperty.builder()
     *                 .cloudWatchLogGroupArn("cloudWatchLogGroupArn")
     *                 .logPrefix("logPrefix")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-botalias-textlogdestination.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-botalias-textlogdestination.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_lex.CfnBotAlias.TextLogDestinationProperty")
    @software.amazon.jsii.Jsii.Proxy(TextLogDestinationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface TextLogDestinationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Defines the Amazon CloudWatch Logs log group where text and metadata logs are delivered.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-botalias-textlogdestination.html#cfn-lex-botalias-textlogdestination-cloudwatch">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-botalias-textlogdestination.html#cfn-lex-botalias-textlogdestination-cloudwatch</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getCloudWatch();

        /**
         * @return a {@link Builder} of {@link TextLogDestinationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link TextLogDestinationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<TextLogDestinationProperty> {
            java.lang.Object cloudWatch;

            /**
             * Sets the value of {@link TextLogDestinationProperty#getCloudWatch}
             * @param cloudWatch Defines the Amazon CloudWatch Logs log group where text and metadata logs are delivered. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder cloudWatch(software.amazon.awscdk.IResolvable cloudWatch) {
                this.cloudWatch = cloudWatch;
                return this;
            }

            /**
             * Sets the value of {@link TextLogDestinationProperty#getCloudWatch}
             * @param cloudWatch Defines the Amazon CloudWatch Logs log group where text and metadata logs are delivered. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder cloudWatch(software.amazon.awscdk.services.lex.CfnBotAlias.CloudWatchLogGroupLogDestinationProperty cloudWatch) {
                this.cloudWatch = cloudWatch;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link TextLogDestinationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public TextLogDestinationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link TextLogDestinationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements TextLogDestinationProperty {
            private final java.lang.Object cloudWatch;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.cloudWatch = software.amazon.jsii.Kernel.get(this, "cloudWatch", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.cloudWatch = java.util.Objects.requireNonNull(builder.cloudWatch, "cloudWatch is required");
            }

            @Override
            public final java.lang.Object getCloudWatch() {
                return this.cloudWatch;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("cloudWatch", om.valueToTree(this.getCloudWatch()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_lex.CfnBotAlias.TextLogDestinationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                TextLogDestinationProperty.Jsii$Proxy that = (TextLogDestinationProperty.Jsii$Proxy) o;

                return this.cloudWatch.equals(that.cloudWatch);
            }

            @Override
            public final int hashCode() {
                int result = this.cloudWatch.hashCode();
                return result;
            }
        }
    }
    /**
     * Defines settings to enable text conversation logs.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.lex.*;
     * TextLogSettingProperty textLogSettingProperty = TextLogSettingProperty.builder()
     *         .destination(TextLogDestinationProperty.builder()
     *                 .cloudWatch(CloudWatchLogGroupLogDestinationProperty.builder()
     *                         .cloudWatchLogGroupArn("cloudWatchLogGroupArn")
     *                         .logPrefix("logPrefix")
     *                         .build())
     *                 .build())
     *         .enabled(false)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-botalias-textlogsetting.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-botalias-textlogsetting.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_lex.CfnBotAlias.TextLogSettingProperty")
    @software.amazon.jsii.Jsii.Proxy(TextLogSettingProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface TextLogSettingProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Defines the Amazon CloudWatch Logs destination log group for conversation text logs.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-botalias-textlogsetting.html#cfn-lex-botalias-textlogsetting-destination">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-botalias-textlogsetting.html#cfn-lex-botalias-textlogsetting-destination</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getDestination();

        /**
         * Determines whether conversation logs should be stored for an alias.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-botalias-textlogsetting.html#cfn-lex-botalias-textlogsetting-enabled">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-botalias-textlogsetting.html#cfn-lex-botalias-textlogsetting-enabled</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getEnabled();

        /**
         * @return a {@link Builder} of {@link TextLogSettingProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link TextLogSettingProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<TextLogSettingProperty> {
            java.lang.Object destination;
            java.lang.Object enabled;

            /**
             * Sets the value of {@link TextLogSettingProperty#getDestination}
             * @param destination Defines the Amazon CloudWatch Logs destination log group for conversation text logs. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder destination(software.amazon.awscdk.IResolvable destination) {
                this.destination = destination;
                return this;
            }

            /**
             * Sets the value of {@link TextLogSettingProperty#getDestination}
             * @param destination Defines the Amazon CloudWatch Logs destination log group for conversation text logs. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder destination(software.amazon.awscdk.services.lex.CfnBotAlias.TextLogDestinationProperty destination) {
                this.destination = destination;
                return this;
            }

            /**
             * Sets the value of {@link TextLogSettingProperty#getEnabled}
             * @param enabled Determines whether conversation logs should be stored for an alias. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder enabled(java.lang.Boolean enabled) {
                this.enabled = enabled;
                return this;
            }

            /**
             * Sets the value of {@link TextLogSettingProperty#getEnabled}
             * @param enabled Determines whether conversation logs should be stored for an alias. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder enabled(software.amazon.awscdk.IResolvable enabled) {
                this.enabled = enabled;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link TextLogSettingProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public TextLogSettingProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link TextLogSettingProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements TextLogSettingProperty {
            private final java.lang.Object destination;
            private final java.lang.Object enabled;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.destination = software.amazon.jsii.Kernel.get(this, "destination", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.enabled = software.amazon.jsii.Kernel.get(this, "enabled", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.destination = java.util.Objects.requireNonNull(builder.destination, "destination is required");
                this.enabled = java.util.Objects.requireNonNull(builder.enabled, "enabled is required");
            }

            @Override
            public final java.lang.Object getDestination() {
                return this.destination;
            }

            @Override
            public final java.lang.Object getEnabled() {
                return this.enabled;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("destination", om.valueToTree(this.getDestination()));
                data.set("enabled", om.valueToTree(this.getEnabled()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_lex.CfnBotAlias.TextLogSettingProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                TextLogSettingProperty.Jsii$Proxy that = (TextLogSettingProperty.Jsii$Proxy) o;

                if (!destination.equals(that.destination)) return false;
                return this.enabled.equals(that.enabled);
            }

            @Override
            public final int hashCode() {
                int result = this.destination.hashCode();
                result = 31 * result + (this.enabled.hashCode());
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.lex.CfnBotAlias}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.lex.CfnBotAlias> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope Scope in which this resource is defined. This parameter is required.
         * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.lex.CfnBotAliasProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.lex.CfnBotAliasProps.Builder();
        }

        /**
         * The name of the bot alias.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lex-botalias.html#cfn-lex-botalias-botaliasname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lex-botalias.html#cfn-lex-botalias-botaliasname</a>
         * @param botAliasName The name of the bot alias. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder botAliasName(final java.lang.String botAliasName) {
            this.props.botAliasName(botAliasName);
            return this;
        }

        /**
         * The unique identifier of the bot.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lex-botalias.html#cfn-lex-botalias-botid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lex-botalias.html#cfn-lex-botalias-botid</a>
         * @param botId The unique identifier of the bot. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder botId(final java.lang.String botId) {
            this.props.botId(botId);
            return this;
        }

        /**
         * Specifies settings that are unique to a locale.
         * <p>
         * For example, you can use different Lambda function depending on the bot's locale.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lex-botalias.html#cfn-lex-botalias-botaliaslocalesettings">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lex-botalias.html#cfn-lex-botalias-botaliaslocalesettings</a>
         * @param botAliasLocaleSettings Specifies settings that are unique to a locale. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder botAliasLocaleSettings(final software.amazon.awscdk.IResolvable botAliasLocaleSettings) {
            this.props.botAliasLocaleSettings(botAliasLocaleSettings);
            return this;
        }
        /**
         * Specifies settings that are unique to a locale.
         * <p>
         * For example, you can use different Lambda function depending on the bot's locale.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lex-botalias.html#cfn-lex-botalias-botaliaslocalesettings">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lex-botalias.html#cfn-lex-botalias-botaliaslocalesettings</a>
         * @param botAliasLocaleSettings Specifies settings that are unique to a locale. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder botAliasLocaleSettings(final java.util.List<? extends java.lang.Object> botAliasLocaleSettings) {
            this.props.botAliasLocaleSettings(botAliasLocaleSettings);
            return this;
        }

        /**
         * An array of key-value pairs to apply to this resource.
         * <p>
         * You can only add tags when you specify an alias.
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-resource-tags.html">Tag</a> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lex-botalias.html#cfn-lex-botalias-botaliastags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lex-botalias.html#cfn-lex-botalias-botaliastags</a>
         * @param botAliasTags An array of key-value pairs to apply to this resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder botAliasTags(final software.amazon.awscdk.IResolvable botAliasTags) {
            this.props.botAliasTags(botAliasTags);
            return this;
        }
        /**
         * An array of key-value pairs to apply to this resource.
         * <p>
         * You can only add tags when you specify an alias.
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-resource-tags.html">Tag</a> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lex-botalias.html#cfn-lex-botalias-botaliastags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lex-botalias.html#cfn-lex-botalias-botaliastags</a>
         * @param botAliasTags An array of key-value pairs to apply to this resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder botAliasTags(final java.util.List<? extends java.lang.Object> botAliasTags) {
            this.props.botAliasTags(botAliasTags);
            return this;
        }

        /**
         * The version of the bot that the bot alias references.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lex-botalias.html#cfn-lex-botalias-botversion">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lex-botalias.html#cfn-lex-botalias-botversion</a>
         * @param botVersion The version of the bot that the bot alias references. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder botVersion(final java.lang.String botVersion) {
            this.props.botVersion(botVersion);
            return this;
        }

        /**
         * Specifies whether Amazon Lex logs text and audio for conversations with the bot.
         * <p>
         * When you enable conversation logs, text logs store text input, transcripts of audio input, and associated metadata in Amazon CloudWatch logs. Audio logs store input in Amazon S3 .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lex-botalias.html#cfn-lex-botalias-conversationlogsettings">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lex-botalias.html#cfn-lex-botalias-conversationlogsettings</a>
         * @param conversationLogSettings Specifies whether Amazon Lex logs text and audio for conversations with the bot. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder conversationLogSettings(final software.amazon.awscdk.IResolvable conversationLogSettings) {
            this.props.conversationLogSettings(conversationLogSettings);
            return this;
        }
        /**
         * Specifies whether Amazon Lex logs text and audio for conversations with the bot.
         * <p>
         * When you enable conversation logs, text logs store text input, transcripts of audio input, and associated metadata in Amazon CloudWatch logs. Audio logs store input in Amazon S3 .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lex-botalias.html#cfn-lex-botalias-conversationlogsettings">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lex-botalias.html#cfn-lex-botalias-conversationlogsettings</a>
         * @param conversationLogSettings Specifies whether Amazon Lex logs text and audio for conversations with the bot. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder conversationLogSettings(final software.amazon.awscdk.services.lex.CfnBotAlias.ConversationLogSettingsProperty conversationLogSettings) {
            this.props.conversationLogSettings(conversationLogSettings);
            return this;
        }

        /**
         * The description of the bot alias.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lex-botalias.html#cfn-lex-botalias-description">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lex-botalias.html#cfn-lex-botalias-description</a>
         * @param description The description of the bot alias. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(final java.lang.String description) {
            this.props.description(description);
            return this;
        }

        /**
         * Determines whether Amazon Lex will use Amazon Comprehend to detect the sentiment of user utterances.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lex-botalias.html#cfn-lex-botalias-sentimentanalysissettings">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lex-botalias.html#cfn-lex-botalias-sentimentanalysissettings</a>
         * @param sentimentAnalysisSettings Determines whether Amazon Lex will use Amazon Comprehend to detect the sentiment of user utterances. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder sentimentAnalysisSettings(final java.lang.Object sentimentAnalysisSettings) {
            this.props.sentimentAnalysisSettings(sentimentAnalysisSettings);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.lex.CfnBotAlias}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.lex.CfnBotAlias build() {
            return new software.amazon.awscdk.services.lex.CfnBotAlias(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
