package software.amazon.awscdk.services.mediaconnect;

/**
 * Properties for defining a <code>CfnBridgeOutput</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.mediaconnect.*;
 * CfnBridgeOutputProps cfnBridgeOutputProps = CfnBridgeOutputProps.builder()
 *         .bridgeArn("bridgeArn")
 *         .name("name")
 *         .networkOutput(BridgeNetworkOutputProperty.builder()
 *                 .ipAddress("ipAddress")
 *                 .networkName("networkName")
 *                 .port(123)
 *                 .protocol("protocol")
 *                 .ttl(123)
 *                 .build())
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-bridgeoutput.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-bridgeoutput.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-05-20T23:52:59.138Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_mediaconnect.CfnBridgeOutputProps")
@software.amazon.jsii.Jsii.Proxy(CfnBridgeOutputProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnBridgeOutputProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The Amazon Resource Name (ARN) of the bridge that you want to update.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-bridgeoutput.html#cfn-mediaconnect-bridgeoutput-bridgearn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-bridgeoutput.html#cfn-mediaconnect-bridgeoutput-bridgearn</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getBridgeArn();

    /**
     * The network output name.
     * <p>
     * This name is used to reference the output and must be unique among outputs in this bridge.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-bridgeoutput.html#cfn-mediaconnect-bridgeoutput-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-bridgeoutput.html#cfn-mediaconnect-bridgeoutput-name</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getName();

    /**
     * The network output of the bridge.
     * <p>
     * A network output is delivered to your premises.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-bridgeoutput.html#cfn-mediaconnect-bridgeoutput-networkoutput">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-bridgeoutput.html#cfn-mediaconnect-bridgeoutput-networkoutput</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Object getNetworkOutput();

    /**
     * @return a {@link Builder} of {@link CfnBridgeOutputProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnBridgeOutputProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnBridgeOutputProps> {
        java.lang.String bridgeArn;
        java.lang.String name;
        java.lang.Object networkOutput;

        /**
         * Sets the value of {@link CfnBridgeOutputProps#getBridgeArn}
         * @param bridgeArn The Amazon Resource Name (ARN) of the bridge that you want to update. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder bridgeArn(java.lang.String bridgeArn) {
            this.bridgeArn = bridgeArn;
            return this;
        }

        /**
         * Sets the value of {@link CfnBridgeOutputProps#getName}
         * @param name The network output name. This parameter is required.
         *             This name is used to reference the output and must be unique among outputs in this bridge.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(java.lang.String name) {
            this.name = name;
            return this;
        }

        /**
         * Sets the value of {@link CfnBridgeOutputProps#getNetworkOutput}
         * @param networkOutput The network output of the bridge. This parameter is required.
         *                      A network output is delivered to your premises.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder networkOutput(software.amazon.awscdk.IResolvable networkOutput) {
            this.networkOutput = networkOutput;
            return this;
        }

        /**
         * Sets the value of {@link CfnBridgeOutputProps#getNetworkOutput}
         * @param networkOutput The network output of the bridge. This parameter is required.
         *                      A network output is delivered to your premises.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder networkOutput(software.amazon.awscdk.services.mediaconnect.CfnBridgeOutput.BridgeNetworkOutputProperty networkOutput) {
            this.networkOutput = networkOutput;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnBridgeOutputProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnBridgeOutputProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnBridgeOutputProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnBridgeOutputProps {
        private final java.lang.String bridgeArn;
        private final java.lang.String name;
        private final java.lang.Object networkOutput;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.bridgeArn = software.amazon.jsii.Kernel.get(this, "bridgeArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.networkOutput = software.amazon.jsii.Kernel.get(this, "networkOutput", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.bridgeArn = java.util.Objects.requireNonNull(builder.bridgeArn, "bridgeArn is required");
            this.name = java.util.Objects.requireNonNull(builder.name, "name is required");
            this.networkOutput = java.util.Objects.requireNonNull(builder.networkOutput, "networkOutput is required");
        }

        @Override
        public final java.lang.String getBridgeArn() {
            return this.bridgeArn;
        }

        @Override
        public final java.lang.String getName() {
            return this.name;
        }

        @Override
        public final java.lang.Object getNetworkOutput() {
            return this.networkOutput;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("bridgeArn", om.valueToTree(this.getBridgeArn()));
            data.set("name", om.valueToTree(this.getName()));
            data.set("networkOutput", om.valueToTree(this.getNetworkOutput()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_mediaconnect.CfnBridgeOutputProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnBridgeOutputProps.Jsii$Proxy that = (CfnBridgeOutputProps.Jsii$Proxy) o;

            if (!bridgeArn.equals(that.bridgeArn)) return false;
            if (!name.equals(that.name)) return false;
            return this.networkOutput.equals(that.networkOutput);
        }

        @Override
        public final int hashCode() {
            int result = this.bridgeArn.hashCode();
            result = 31 * result + (this.name.hashCode());
            result = 31 * result + (this.networkOutput.hashCode());
            return result;
        }
    }
}
