package software.amazon.awscdk.services.msk;

/**
 * Creates the replicator.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.msk.*;
 * CfnReplicator cfnReplicator = CfnReplicator.Builder.create(this, "MyCfnReplicator")
 *         .kafkaClusters(List.of(KafkaClusterProperty.builder()
 *                 .amazonMskCluster(AmazonMskClusterProperty.builder()
 *                         .mskClusterArn("mskClusterArn")
 *                         .build())
 *                 .vpcConfig(KafkaClusterClientVpcConfigProperty.builder()
 *                         .subnetIds(List.of("subnetIds"))
 *                         // the properties below are optional
 *                         .securityGroupIds(List.of("securityGroupIds"))
 *                         .build())
 *                 .build()))
 *         .replicationInfoList(List.of(ReplicationInfoProperty.builder()
 *                 .consumerGroupReplication(ConsumerGroupReplicationProperty.builder()
 *                         .consumerGroupsToReplicate(List.of("consumerGroupsToReplicate"))
 *                         // the properties below are optional
 *                         .consumerGroupsToExclude(List.of("consumerGroupsToExclude"))
 *                         .detectAndCopyNewConsumerGroups(false)
 *                         .synchroniseConsumerGroupOffsets(false)
 *                         .build())
 *                 .sourceKafkaClusterArn("sourceKafkaClusterArn")
 *                 .targetCompressionType("targetCompressionType")
 *                 .targetKafkaClusterArn("targetKafkaClusterArn")
 *                 .topicReplication(TopicReplicationProperty.builder()
 *                         .topicsToReplicate(List.of("topicsToReplicate"))
 *                         // the properties below are optional
 *                         .copyAccessControlListsForTopics(false)
 *                         .copyTopicConfigurations(false)
 *                         .detectAndCopyNewTopics(false)
 *                         .startingPosition(ReplicationStartingPositionProperty.builder()
 *                                 .type("type")
 *                                 .build())
 *                         .topicNameConfiguration(ReplicationTopicNameConfigurationProperty.builder()
 *                                 .type("type")
 *                                 .build())
 *                         .topicsToExclude(List.of("topicsToExclude"))
 *                         .build())
 *                 .build()))
 *         .replicatorName("replicatorName")
 *         .serviceExecutionRoleArn("serviceExecutionRoleArn")
 *         // the properties below are optional
 *         .description("description")
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-msk-replicator.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-msk-replicator.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-05-20T23:52:59.566Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_msk.CfnReplicator")
public class CfnReplicator extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable, software.amazon.awscdk.ITaggableV2 {

    protected CfnReplicator(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnReplicator(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.msk.CfnReplicator.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * @param scope Scope in which this resource is defined. This parameter is required.
     * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
     * @param props Resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnReplicator(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.msk.CfnReplicatorProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     * The current version number of the replicator.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrCurrentVersion() {
        return software.amazon.jsii.Kernel.get(this, "attrCurrentVersion", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Amazon Resource Name (ARN) for the created replicator.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrReplicatorArn() {
        return software.amazon.jsii.Kernel.get(this, "attrReplicatorArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Tag Manager which manages the tags for this resource.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.TagManager getCdkTagManager() {
        return software.amazon.jsii.Kernel.get(this, "cdkTagManager", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TagManager.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * Kafka Clusters to use in setting up sources / targets for replication.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Object getKafkaClusters() {
        return software.amazon.jsii.Kernel.get(this, "kafkaClusters", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Kafka Clusters to use in setting up sources / targets for replication.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setKafkaClusters(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "kafkaClusters", java.util.Objects.requireNonNull(value, "kafkaClusters is required"));
    }

    /**
     * Kafka Clusters to use in setting up sources / targets for replication.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setKafkaClusters(final @org.jetbrains.annotations.NotNull java.util.List<java.lang.Object> value) {
        if (software.amazon.jsii.Configuration.getRuntimeTypeChecking()) {
            for (int __idx_ac66f0 = 0; __idx_ac66f0 < value.size(); __idx_ac66f0++) {
                final java.lang.Object __val_ac66f0 = value.get(__idx_ac66f0);
                if (
                     !(__val_ac66f0 instanceof software.amazon.awscdk.IResolvable)
                    && !(__val_ac66f0 instanceof software.amazon.awscdk.services.msk.CfnReplicator.KafkaClusterProperty)
                    && !(__val_ac66f0.getClass().equals(software.amazon.jsii.JsiiObject.class))
                ) {
                    throw new IllegalArgumentException(
                        new java.lang.StringBuilder("Expected ")
                            .append("value").append(".get(").append(__idx_ac66f0).append(")")
                            .append(" to be one of: software.amazon.awscdk.IResolvable, software.amazon.awscdk.services.msk.CfnReplicator.KafkaClusterProperty; received ")
                            .append(__val_ac66f0.getClass()).toString());
                }
            }
        }
        software.amazon.jsii.Kernel.set(this, "kafkaClusters", java.util.Objects.requireNonNull(value, "kafkaClusters is required"));
    }

    /**
     * A list of replication configurations, where each configuration targets a given source cluster to target cluster replication flow.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Object getReplicationInfoList() {
        return software.amazon.jsii.Kernel.get(this, "replicationInfoList", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * A list of replication configurations, where each configuration targets a given source cluster to target cluster replication flow.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setReplicationInfoList(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "replicationInfoList", java.util.Objects.requireNonNull(value, "replicationInfoList is required"));
    }

    /**
     * A list of replication configurations, where each configuration targets a given source cluster to target cluster replication flow.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setReplicationInfoList(final @org.jetbrains.annotations.NotNull java.util.List<java.lang.Object> value) {
        if (software.amazon.jsii.Configuration.getRuntimeTypeChecking()) {
            for (int __idx_ac66f0 = 0; __idx_ac66f0 < value.size(); __idx_ac66f0++) {
                final java.lang.Object __val_ac66f0 = value.get(__idx_ac66f0);
                if (
                     !(__val_ac66f0 instanceof software.amazon.awscdk.IResolvable)
                    && !(__val_ac66f0 instanceof software.amazon.awscdk.services.msk.CfnReplicator.ReplicationInfoProperty)
                    && !(__val_ac66f0.getClass().equals(software.amazon.jsii.JsiiObject.class))
                ) {
                    throw new IllegalArgumentException(
                        new java.lang.StringBuilder("Expected ")
                            .append("value").append(".get(").append(__idx_ac66f0).append(")")
                            .append(" to be one of: software.amazon.awscdk.IResolvable, software.amazon.awscdk.services.msk.CfnReplicator.ReplicationInfoProperty; received ")
                            .append(__val_ac66f0.getClass()).toString());
                }
            }
        }
        software.amazon.jsii.Kernel.set(this, "replicationInfoList", java.util.Objects.requireNonNull(value, "replicationInfoList is required"));
    }

    /**
     * The name of the replicator.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getReplicatorName() {
        return software.amazon.jsii.Kernel.get(this, "replicatorName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name of the replicator.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setReplicatorName(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "replicatorName", java.util.Objects.requireNonNull(value, "replicatorName is required"));
    }

    /**
     * The ARN of the IAM role used by the replicator to access resources in the customer's account (e.g source and target clusters).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getServiceExecutionRoleArn() {
        return software.amazon.jsii.Kernel.get(this, "serviceExecutionRoleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The ARN of the IAM role used by the replicator to access resources in the customer's account (e.g source and target clusters).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setServiceExecutionRoleArn(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "serviceExecutionRoleArn", java.util.Objects.requireNonNull(value, "serviceExecutionRoleArn is required"));
    }

    /**
     * A summary description of the replicator.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
        return software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * A summary description of the replicator.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDescription(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "description", value);
    }

    /**
     * List of tags to attach to created Replicator.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTags() {
        return java.util.Optional.ofNullable((java.util.List<software.amazon.awscdk.CfnTag>)(software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     * List of tags to attach to created Replicator.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTags(final @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> value) {
        software.amazon.jsii.Kernel.set(this, "tags", value);
    }
    /**
     * Details of an Amazon MSK Cluster.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.msk.*;
     * AmazonMskClusterProperty amazonMskClusterProperty = AmazonMskClusterProperty.builder()
     *         .mskClusterArn("mskClusterArn")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-msk-replicator-amazonmskcluster.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-msk-replicator-amazonmskcluster.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_msk.CfnReplicator.AmazonMskClusterProperty")
    @software.amazon.jsii.Jsii.Proxy(AmazonMskClusterProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface AmazonMskClusterProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The Amazon Resource Name (ARN) of an Amazon MSK cluster.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-msk-replicator-amazonmskcluster.html#cfn-msk-replicator-amazonmskcluster-mskclusterarn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-msk-replicator-amazonmskcluster.html#cfn-msk-replicator-amazonmskcluster-mskclusterarn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getMskClusterArn();

        /**
         * @return a {@link Builder} of {@link AmazonMskClusterProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link AmazonMskClusterProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<AmazonMskClusterProperty> {
            java.lang.String mskClusterArn;

            /**
             * Sets the value of {@link AmazonMskClusterProperty#getMskClusterArn}
             * @param mskClusterArn The Amazon Resource Name (ARN) of an Amazon MSK cluster. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder mskClusterArn(java.lang.String mskClusterArn) {
                this.mskClusterArn = mskClusterArn;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link AmazonMskClusterProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public AmazonMskClusterProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link AmazonMskClusterProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AmazonMskClusterProperty {
            private final java.lang.String mskClusterArn;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.mskClusterArn = software.amazon.jsii.Kernel.get(this, "mskClusterArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.mskClusterArn = java.util.Objects.requireNonNull(builder.mskClusterArn, "mskClusterArn is required");
            }

            @Override
            public final java.lang.String getMskClusterArn() {
                return this.mskClusterArn;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("mskClusterArn", om.valueToTree(this.getMskClusterArn()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_msk.CfnReplicator.AmazonMskClusterProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                AmazonMskClusterProperty.Jsii$Proxy that = (AmazonMskClusterProperty.Jsii$Proxy) o;

                return this.mskClusterArn.equals(that.mskClusterArn);
            }

            @Override
            public final int hashCode() {
                int result = this.mskClusterArn.hashCode();
                return result;
            }
        }
    }
    /**
     * Details about consumer group replication.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.msk.*;
     * ConsumerGroupReplicationProperty consumerGroupReplicationProperty = ConsumerGroupReplicationProperty.builder()
     *         .consumerGroupsToReplicate(List.of("consumerGroupsToReplicate"))
     *         // the properties below are optional
     *         .consumerGroupsToExclude(List.of("consumerGroupsToExclude"))
     *         .detectAndCopyNewConsumerGroups(false)
     *         .synchroniseConsumerGroupOffsets(false)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-msk-replicator-consumergroupreplication.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-msk-replicator-consumergroupreplication.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_msk.CfnReplicator.ConsumerGroupReplicationProperty")
    @software.amazon.jsii.Jsii.Proxy(ConsumerGroupReplicationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ConsumerGroupReplicationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * List of regular expression patterns indicating the consumer groups to copy.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-msk-replicator-consumergroupreplication.html#cfn-msk-replicator-consumergroupreplication-consumergroupstoreplicate">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-msk-replicator-consumergroupreplication.html#cfn-msk-replicator-consumergroupreplication-consumergroupstoreplicate</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> getConsumerGroupsToReplicate();

        /**
         * List of regular expression patterns indicating the consumer groups that should not be replicated.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-msk-replicator-consumergroupreplication.html#cfn-msk-replicator-consumergroupreplication-consumergroupstoexclude">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-msk-replicator-consumergroupreplication.html#cfn-msk-replicator-consumergroupreplication-consumergroupstoexclude</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getConsumerGroupsToExclude() {
            return null;
        }

        /**
         * Enables synchronization of consumer groups to target cluster.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-msk-replicator-consumergroupreplication.html#cfn-msk-replicator-consumergroupreplication-detectandcopynewconsumergroups">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-msk-replicator-consumergroupreplication.html#cfn-msk-replicator-consumergroupreplication-detectandcopynewconsumergroups</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getDetectAndCopyNewConsumerGroups() {
            return null;
        }

        /**
         * Enables synchronization of consumer group offsets to target cluster.
         * <p>
         * The translated offsets will be written to topic __consumer_offsets.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-msk-replicator-consumergroupreplication.html#cfn-msk-replicator-consumergroupreplication-synchroniseconsumergroupoffsets">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-msk-replicator-consumergroupreplication.html#cfn-msk-replicator-consumergroupreplication-synchroniseconsumergroupoffsets</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getSynchroniseConsumerGroupOffsets() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ConsumerGroupReplicationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ConsumerGroupReplicationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ConsumerGroupReplicationProperty> {
            java.util.List<java.lang.String> consumerGroupsToReplicate;
            java.util.List<java.lang.String> consumerGroupsToExclude;
            java.lang.Object detectAndCopyNewConsumerGroups;
            java.lang.Object synchroniseConsumerGroupOffsets;

            /**
             * Sets the value of {@link ConsumerGroupReplicationProperty#getConsumerGroupsToReplicate}
             * @param consumerGroupsToReplicate List of regular expression patterns indicating the consumer groups to copy. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder consumerGroupsToReplicate(java.util.List<java.lang.String> consumerGroupsToReplicate) {
                this.consumerGroupsToReplicate = consumerGroupsToReplicate;
                return this;
            }

            /**
             * Sets the value of {@link ConsumerGroupReplicationProperty#getConsumerGroupsToExclude}
             * @param consumerGroupsToExclude List of regular expression patterns indicating the consumer groups that should not be replicated.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder consumerGroupsToExclude(java.util.List<java.lang.String> consumerGroupsToExclude) {
                this.consumerGroupsToExclude = consumerGroupsToExclude;
                return this;
            }

            /**
             * Sets the value of {@link ConsumerGroupReplicationProperty#getDetectAndCopyNewConsumerGroups}
             * @param detectAndCopyNewConsumerGroups Enables synchronization of consumer groups to target cluster.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder detectAndCopyNewConsumerGroups(java.lang.Boolean detectAndCopyNewConsumerGroups) {
                this.detectAndCopyNewConsumerGroups = detectAndCopyNewConsumerGroups;
                return this;
            }

            /**
             * Sets the value of {@link ConsumerGroupReplicationProperty#getDetectAndCopyNewConsumerGroups}
             * @param detectAndCopyNewConsumerGroups Enables synchronization of consumer groups to target cluster.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder detectAndCopyNewConsumerGroups(software.amazon.awscdk.IResolvable detectAndCopyNewConsumerGroups) {
                this.detectAndCopyNewConsumerGroups = detectAndCopyNewConsumerGroups;
                return this;
            }

            /**
             * Sets the value of {@link ConsumerGroupReplicationProperty#getSynchroniseConsumerGroupOffsets}
             * @param synchroniseConsumerGroupOffsets Enables synchronization of consumer group offsets to target cluster.
             *                                        The translated offsets will be written to topic __consumer_offsets.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder synchroniseConsumerGroupOffsets(java.lang.Boolean synchroniseConsumerGroupOffsets) {
                this.synchroniseConsumerGroupOffsets = synchroniseConsumerGroupOffsets;
                return this;
            }

            /**
             * Sets the value of {@link ConsumerGroupReplicationProperty#getSynchroniseConsumerGroupOffsets}
             * @param synchroniseConsumerGroupOffsets Enables synchronization of consumer group offsets to target cluster.
             *                                        The translated offsets will be written to topic __consumer_offsets.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder synchroniseConsumerGroupOffsets(software.amazon.awscdk.IResolvable synchroniseConsumerGroupOffsets) {
                this.synchroniseConsumerGroupOffsets = synchroniseConsumerGroupOffsets;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ConsumerGroupReplicationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ConsumerGroupReplicationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ConsumerGroupReplicationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ConsumerGroupReplicationProperty {
            private final java.util.List<java.lang.String> consumerGroupsToReplicate;
            private final java.util.List<java.lang.String> consumerGroupsToExclude;
            private final java.lang.Object detectAndCopyNewConsumerGroups;
            private final java.lang.Object synchroniseConsumerGroupOffsets;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.consumerGroupsToReplicate = software.amazon.jsii.Kernel.get(this, "consumerGroupsToReplicate", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.consumerGroupsToExclude = software.amazon.jsii.Kernel.get(this, "consumerGroupsToExclude", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.detectAndCopyNewConsumerGroups = software.amazon.jsii.Kernel.get(this, "detectAndCopyNewConsumerGroups", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.synchroniseConsumerGroupOffsets = software.amazon.jsii.Kernel.get(this, "synchroniseConsumerGroupOffsets", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.consumerGroupsToReplicate = java.util.Objects.requireNonNull(builder.consumerGroupsToReplicate, "consumerGroupsToReplicate is required");
                this.consumerGroupsToExclude = builder.consumerGroupsToExclude;
                this.detectAndCopyNewConsumerGroups = builder.detectAndCopyNewConsumerGroups;
                this.synchroniseConsumerGroupOffsets = builder.synchroniseConsumerGroupOffsets;
            }

            @Override
            public final java.util.List<java.lang.String> getConsumerGroupsToReplicate() {
                return this.consumerGroupsToReplicate;
            }

            @Override
            public final java.util.List<java.lang.String> getConsumerGroupsToExclude() {
                return this.consumerGroupsToExclude;
            }

            @Override
            public final java.lang.Object getDetectAndCopyNewConsumerGroups() {
                return this.detectAndCopyNewConsumerGroups;
            }

            @Override
            public final java.lang.Object getSynchroniseConsumerGroupOffsets() {
                return this.synchroniseConsumerGroupOffsets;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("consumerGroupsToReplicate", om.valueToTree(this.getConsumerGroupsToReplicate()));
                if (this.getConsumerGroupsToExclude() != null) {
                    data.set("consumerGroupsToExclude", om.valueToTree(this.getConsumerGroupsToExclude()));
                }
                if (this.getDetectAndCopyNewConsumerGroups() != null) {
                    data.set("detectAndCopyNewConsumerGroups", om.valueToTree(this.getDetectAndCopyNewConsumerGroups()));
                }
                if (this.getSynchroniseConsumerGroupOffsets() != null) {
                    data.set("synchroniseConsumerGroupOffsets", om.valueToTree(this.getSynchroniseConsumerGroupOffsets()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_msk.CfnReplicator.ConsumerGroupReplicationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ConsumerGroupReplicationProperty.Jsii$Proxy that = (ConsumerGroupReplicationProperty.Jsii$Proxy) o;

                if (!consumerGroupsToReplicate.equals(that.consumerGroupsToReplicate)) return false;
                if (this.consumerGroupsToExclude != null ? !this.consumerGroupsToExclude.equals(that.consumerGroupsToExclude) : that.consumerGroupsToExclude != null) return false;
                if (this.detectAndCopyNewConsumerGroups != null ? !this.detectAndCopyNewConsumerGroups.equals(that.detectAndCopyNewConsumerGroups) : that.detectAndCopyNewConsumerGroups != null) return false;
                return this.synchroniseConsumerGroupOffsets != null ? this.synchroniseConsumerGroupOffsets.equals(that.synchroniseConsumerGroupOffsets) : that.synchroniseConsumerGroupOffsets == null;
            }

            @Override
            public final int hashCode() {
                int result = this.consumerGroupsToReplicate.hashCode();
                result = 31 * result + (this.consumerGroupsToExclude != null ? this.consumerGroupsToExclude.hashCode() : 0);
                result = 31 * result + (this.detectAndCopyNewConsumerGroups != null ? this.detectAndCopyNewConsumerGroups.hashCode() : 0);
                result = 31 * result + (this.synchroniseConsumerGroupOffsets != null ? this.synchroniseConsumerGroupOffsets.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Details of an Amazon VPC which has network connectivity to the Apache Kafka cluster.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.msk.*;
     * KafkaClusterClientVpcConfigProperty kafkaClusterClientVpcConfigProperty = KafkaClusterClientVpcConfigProperty.builder()
     *         .subnetIds(List.of("subnetIds"))
     *         // the properties below are optional
     *         .securityGroupIds(List.of("securityGroupIds"))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-msk-replicator-kafkaclusterclientvpcconfig.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-msk-replicator-kafkaclusterclientvpcconfig.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_msk.CfnReplicator.KafkaClusterClientVpcConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(KafkaClusterClientVpcConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface KafkaClusterClientVpcConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The list of subnets in the client VPC to connect to.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-msk-replicator-kafkaclusterclientvpcconfig.html#cfn-msk-replicator-kafkaclusterclientvpcconfig-subnetids">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-msk-replicator-kafkaclusterclientvpcconfig.html#cfn-msk-replicator-kafkaclusterclientvpcconfig-subnetids</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> getSubnetIds();

        /**
         * The security groups to attach to the ENIs for the broker nodes.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-msk-replicator-kafkaclusterclientvpcconfig.html#cfn-msk-replicator-kafkaclusterclientvpcconfig-securitygroupids">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-msk-replicator-kafkaclusterclientvpcconfig.html#cfn-msk-replicator-kafkaclusterclientvpcconfig-securitygroupids</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getSecurityGroupIds() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link KafkaClusterClientVpcConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link KafkaClusterClientVpcConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<KafkaClusterClientVpcConfigProperty> {
            java.util.List<java.lang.String> subnetIds;
            java.util.List<java.lang.String> securityGroupIds;

            /**
             * Sets the value of {@link KafkaClusterClientVpcConfigProperty#getSubnetIds}
             * @param subnetIds The list of subnets in the client VPC to connect to. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder subnetIds(java.util.List<java.lang.String> subnetIds) {
                this.subnetIds = subnetIds;
                return this;
            }

            /**
             * Sets the value of {@link KafkaClusterClientVpcConfigProperty#getSecurityGroupIds}
             * @param securityGroupIds The security groups to attach to the ENIs for the broker nodes.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder securityGroupIds(java.util.List<java.lang.String> securityGroupIds) {
                this.securityGroupIds = securityGroupIds;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link KafkaClusterClientVpcConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public KafkaClusterClientVpcConfigProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link KafkaClusterClientVpcConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements KafkaClusterClientVpcConfigProperty {
            private final java.util.List<java.lang.String> subnetIds;
            private final java.util.List<java.lang.String> securityGroupIds;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.subnetIds = software.amazon.jsii.Kernel.get(this, "subnetIds", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.securityGroupIds = software.amazon.jsii.Kernel.get(this, "securityGroupIds", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.subnetIds = java.util.Objects.requireNonNull(builder.subnetIds, "subnetIds is required");
                this.securityGroupIds = builder.securityGroupIds;
            }

            @Override
            public final java.util.List<java.lang.String> getSubnetIds() {
                return this.subnetIds;
            }

            @Override
            public final java.util.List<java.lang.String> getSecurityGroupIds() {
                return this.securityGroupIds;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("subnetIds", om.valueToTree(this.getSubnetIds()));
                if (this.getSecurityGroupIds() != null) {
                    data.set("securityGroupIds", om.valueToTree(this.getSecurityGroupIds()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_msk.CfnReplicator.KafkaClusterClientVpcConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                KafkaClusterClientVpcConfigProperty.Jsii$Proxy that = (KafkaClusterClientVpcConfigProperty.Jsii$Proxy) o;

                if (!subnetIds.equals(that.subnetIds)) return false;
                return this.securityGroupIds != null ? this.securityGroupIds.equals(that.securityGroupIds) : that.securityGroupIds == null;
            }

            @Override
            public final int hashCode() {
                int result = this.subnetIds.hashCode();
                result = 31 * result + (this.securityGroupIds != null ? this.securityGroupIds.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Information about Kafka Cluster to be used as source / target for replication.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.msk.*;
     * KafkaClusterProperty kafkaClusterProperty = KafkaClusterProperty.builder()
     *         .amazonMskCluster(AmazonMskClusterProperty.builder()
     *                 .mskClusterArn("mskClusterArn")
     *                 .build())
     *         .vpcConfig(KafkaClusterClientVpcConfigProperty.builder()
     *                 .subnetIds(List.of("subnetIds"))
     *                 // the properties below are optional
     *                 .securityGroupIds(List.of("securityGroupIds"))
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-msk-replicator-kafkacluster.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-msk-replicator-kafkacluster.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_msk.CfnReplicator.KafkaClusterProperty")
    @software.amazon.jsii.Jsii.Proxy(KafkaClusterProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface KafkaClusterProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Details of an Amazon MSK Cluster.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-msk-replicator-kafkacluster.html#cfn-msk-replicator-kafkacluster-amazonmskcluster">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-msk-replicator-kafkacluster.html#cfn-msk-replicator-kafkacluster-amazonmskcluster</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getAmazonMskCluster();

        /**
         * Details of an Amazon VPC which has network connectivity to the Apache Kafka cluster.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-msk-replicator-kafkacluster.html#cfn-msk-replicator-kafkacluster-vpcconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-msk-replicator-kafkacluster.html#cfn-msk-replicator-kafkacluster-vpcconfig</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getVpcConfig();

        /**
         * @return a {@link Builder} of {@link KafkaClusterProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link KafkaClusterProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<KafkaClusterProperty> {
            java.lang.Object amazonMskCluster;
            java.lang.Object vpcConfig;

            /**
             * Sets the value of {@link KafkaClusterProperty#getAmazonMskCluster}
             * @param amazonMskCluster Details of an Amazon MSK Cluster. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder amazonMskCluster(software.amazon.awscdk.IResolvable amazonMskCluster) {
                this.amazonMskCluster = amazonMskCluster;
                return this;
            }

            /**
             * Sets the value of {@link KafkaClusterProperty#getAmazonMskCluster}
             * @param amazonMskCluster Details of an Amazon MSK Cluster. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder amazonMskCluster(software.amazon.awscdk.services.msk.CfnReplicator.AmazonMskClusterProperty amazonMskCluster) {
                this.amazonMskCluster = amazonMskCluster;
                return this;
            }

            /**
             * Sets the value of {@link KafkaClusterProperty#getVpcConfig}
             * @param vpcConfig Details of an Amazon VPC which has network connectivity to the Apache Kafka cluster. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder vpcConfig(software.amazon.awscdk.IResolvable vpcConfig) {
                this.vpcConfig = vpcConfig;
                return this;
            }

            /**
             * Sets the value of {@link KafkaClusterProperty#getVpcConfig}
             * @param vpcConfig Details of an Amazon VPC which has network connectivity to the Apache Kafka cluster. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder vpcConfig(software.amazon.awscdk.services.msk.CfnReplicator.KafkaClusterClientVpcConfigProperty vpcConfig) {
                this.vpcConfig = vpcConfig;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link KafkaClusterProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public KafkaClusterProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link KafkaClusterProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements KafkaClusterProperty {
            private final java.lang.Object amazonMskCluster;
            private final java.lang.Object vpcConfig;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.amazonMskCluster = software.amazon.jsii.Kernel.get(this, "amazonMskCluster", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.vpcConfig = software.amazon.jsii.Kernel.get(this, "vpcConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.amazonMskCluster = java.util.Objects.requireNonNull(builder.amazonMskCluster, "amazonMskCluster is required");
                this.vpcConfig = java.util.Objects.requireNonNull(builder.vpcConfig, "vpcConfig is required");
            }

            @Override
            public final java.lang.Object getAmazonMskCluster() {
                return this.amazonMskCluster;
            }

            @Override
            public final java.lang.Object getVpcConfig() {
                return this.vpcConfig;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("amazonMskCluster", om.valueToTree(this.getAmazonMskCluster()));
                data.set("vpcConfig", om.valueToTree(this.getVpcConfig()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_msk.CfnReplicator.KafkaClusterProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                KafkaClusterProperty.Jsii$Proxy that = (KafkaClusterProperty.Jsii$Proxy) o;

                if (!amazonMskCluster.equals(that.amazonMskCluster)) return false;
                return this.vpcConfig.equals(that.vpcConfig);
            }

            @Override
            public final int hashCode() {
                int result = this.amazonMskCluster.hashCode();
                result = 31 * result + (this.vpcConfig.hashCode());
                return result;
            }
        }
    }
    /**
     * Specifies configuration for replication between a source and target Kafka cluster.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.msk.*;
     * ReplicationInfoProperty replicationInfoProperty = ReplicationInfoProperty.builder()
     *         .consumerGroupReplication(ConsumerGroupReplicationProperty.builder()
     *                 .consumerGroupsToReplicate(List.of("consumerGroupsToReplicate"))
     *                 // the properties below are optional
     *                 .consumerGroupsToExclude(List.of("consumerGroupsToExclude"))
     *                 .detectAndCopyNewConsumerGroups(false)
     *                 .synchroniseConsumerGroupOffsets(false)
     *                 .build())
     *         .sourceKafkaClusterArn("sourceKafkaClusterArn")
     *         .targetCompressionType("targetCompressionType")
     *         .targetKafkaClusterArn("targetKafkaClusterArn")
     *         .topicReplication(TopicReplicationProperty.builder()
     *                 .topicsToReplicate(List.of("topicsToReplicate"))
     *                 // the properties below are optional
     *                 .copyAccessControlListsForTopics(false)
     *                 .copyTopicConfigurations(false)
     *                 .detectAndCopyNewTopics(false)
     *                 .startingPosition(ReplicationStartingPositionProperty.builder()
     *                         .type("type")
     *                         .build())
     *                 .topicNameConfiguration(ReplicationTopicNameConfigurationProperty.builder()
     *                         .type("type")
     *                         .build())
     *                 .topicsToExclude(List.of("topicsToExclude"))
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-msk-replicator-replicationinfo.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-msk-replicator-replicationinfo.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_msk.CfnReplicator.ReplicationInfoProperty")
    @software.amazon.jsii.Jsii.Proxy(ReplicationInfoProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ReplicationInfoProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Configuration relating to consumer group replication.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-msk-replicator-replicationinfo.html#cfn-msk-replicator-replicationinfo-consumergroupreplication">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-msk-replicator-replicationinfo.html#cfn-msk-replicator-replicationinfo-consumergroupreplication</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getConsumerGroupReplication();

        /**
         * The ARN of the source Kafka cluster.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-msk-replicator-replicationinfo.html#cfn-msk-replicator-replicationinfo-sourcekafkaclusterarn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-msk-replicator-replicationinfo.html#cfn-msk-replicator-replicationinfo-sourcekafkaclusterarn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getSourceKafkaClusterArn();

        /**
         * The compression type to use when producing records to target cluster.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-msk-replicator-replicationinfo.html#cfn-msk-replicator-replicationinfo-targetcompressiontype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-msk-replicator-replicationinfo.html#cfn-msk-replicator-replicationinfo-targetcompressiontype</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getTargetCompressionType();

        /**
         * The ARN of the target Kafka cluster.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-msk-replicator-replicationinfo.html#cfn-msk-replicator-replicationinfo-targetkafkaclusterarn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-msk-replicator-replicationinfo.html#cfn-msk-replicator-replicationinfo-targetkafkaclusterarn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getTargetKafkaClusterArn();

        /**
         * Configuration relating to topic replication.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-msk-replicator-replicationinfo.html#cfn-msk-replicator-replicationinfo-topicreplication">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-msk-replicator-replicationinfo.html#cfn-msk-replicator-replicationinfo-topicreplication</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getTopicReplication();

        /**
         * @return a {@link Builder} of {@link ReplicationInfoProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ReplicationInfoProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ReplicationInfoProperty> {
            java.lang.Object consumerGroupReplication;
            java.lang.String sourceKafkaClusterArn;
            java.lang.String targetCompressionType;
            java.lang.String targetKafkaClusterArn;
            java.lang.Object topicReplication;

            /**
             * Sets the value of {@link ReplicationInfoProperty#getConsumerGroupReplication}
             * @param consumerGroupReplication Configuration relating to consumer group replication. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder consumerGroupReplication(software.amazon.awscdk.IResolvable consumerGroupReplication) {
                this.consumerGroupReplication = consumerGroupReplication;
                return this;
            }

            /**
             * Sets the value of {@link ReplicationInfoProperty#getConsumerGroupReplication}
             * @param consumerGroupReplication Configuration relating to consumer group replication. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder consumerGroupReplication(software.amazon.awscdk.services.msk.CfnReplicator.ConsumerGroupReplicationProperty consumerGroupReplication) {
                this.consumerGroupReplication = consumerGroupReplication;
                return this;
            }

            /**
             * Sets the value of {@link ReplicationInfoProperty#getSourceKafkaClusterArn}
             * @param sourceKafkaClusterArn The ARN of the source Kafka cluster. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sourceKafkaClusterArn(java.lang.String sourceKafkaClusterArn) {
                this.sourceKafkaClusterArn = sourceKafkaClusterArn;
                return this;
            }

            /**
             * Sets the value of {@link ReplicationInfoProperty#getTargetCompressionType}
             * @param targetCompressionType The compression type to use when producing records to target cluster. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder targetCompressionType(java.lang.String targetCompressionType) {
                this.targetCompressionType = targetCompressionType;
                return this;
            }

            /**
             * Sets the value of {@link ReplicationInfoProperty#getTargetKafkaClusterArn}
             * @param targetKafkaClusterArn The ARN of the target Kafka cluster. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder targetKafkaClusterArn(java.lang.String targetKafkaClusterArn) {
                this.targetKafkaClusterArn = targetKafkaClusterArn;
                return this;
            }

            /**
             * Sets the value of {@link ReplicationInfoProperty#getTopicReplication}
             * @param topicReplication Configuration relating to topic replication. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder topicReplication(software.amazon.awscdk.IResolvable topicReplication) {
                this.topicReplication = topicReplication;
                return this;
            }

            /**
             * Sets the value of {@link ReplicationInfoProperty#getTopicReplication}
             * @param topicReplication Configuration relating to topic replication. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder topicReplication(software.amazon.awscdk.services.msk.CfnReplicator.TopicReplicationProperty topicReplication) {
                this.topicReplication = topicReplication;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ReplicationInfoProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ReplicationInfoProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ReplicationInfoProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ReplicationInfoProperty {
            private final java.lang.Object consumerGroupReplication;
            private final java.lang.String sourceKafkaClusterArn;
            private final java.lang.String targetCompressionType;
            private final java.lang.String targetKafkaClusterArn;
            private final java.lang.Object topicReplication;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.consumerGroupReplication = software.amazon.jsii.Kernel.get(this, "consumerGroupReplication", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.sourceKafkaClusterArn = software.amazon.jsii.Kernel.get(this, "sourceKafkaClusterArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.targetCompressionType = software.amazon.jsii.Kernel.get(this, "targetCompressionType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.targetKafkaClusterArn = software.amazon.jsii.Kernel.get(this, "targetKafkaClusterArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.topicReplication = software.amazon.jsii.Kernel.get(this, "topicReplication", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.consumerGroupReplication = java.util.Objects.requireNonNull(builder.consumerGroupReplication, "consumerGroupReplication is required");
                this.sourceKafkaClusterArn = java.util.Objects.requireNonNull(builder.sourceKafkaClusterArn, "sourceKafkaClusterArn is required");
                this.targetCompressionType = java.util.Objects.requireNonNull(builder.targetCompressionType, "targetCompressionType is required");
                this.targetKafkaClusterArn = java.util.Objects.requireNonNull(builder.targetKafkaClusterArn, "targetKafkaClusterArn is required");
                this.topicReplication = java.util.Objects.requireNonNull(builder.topicReplication, "topicReplication is required");
            }

            @Override
            public final java.lang.Object getConsumerGroupReplication() {
                return this.consumerGroupReplication;
            }

            @Override
            public final java.lang.String getSourceKafkaClusterArn() {
                return this.sourceKafkaClusterArn;
            }

            @Override
            public final java.lang.String getTargetCompressionType() {
                return this.targetCompressionType;
            }

            @Override
            public final java.lang.String getTargetKafkaClusterArn() {
                return this.targetKafkaClusterArn;
            }

            @Override
            public final java.lang.Object getTopicReplication() {
                return this.topicReplication;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("consumerGroupReplication", om.valueToTree(this.getConsumerGroupReplication()));
                data.set("sourceKafkaClusterArn", om.valueToTree(this.getSourceKafkaClusterArn()));
                data.set("targetCompressionType", om.valueToTree(this.getTargetCompressionType()));
                data.set("targetKafkaClusterArn", om.valueToTree(this.getTargetKafkaClusterArn()));
                data.set("topicReplication", om.valueToTree(this.getTopicReplication()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_msk.CfnReplicator.ReplicationInfoProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ReplicationInfoProperty.Jsii$Proxy that = (ReplicationInfoProperty.Jsii$Proxy) o;

                if (!consumerGroupReplication.equals(that.consumerGroupReplication)) return false;
                if (!sourceKafkaClusterArn.equals(that.sourceKafkaClusterArn)) return false;
                if (!targetCompressionType.equals(that.targetCompressionType)) return false;
                if (!targetKafkaClusterArn.equals(that.targetKafkaClusterArn)) return false;
                return this.topicReplication.equals(that.topicReplication);
            }

            @Override
            public final int hashCode() {
                int result = this.consumerGroupReplication.hashCode();
                result = 31 * result + (this.sourceKafkaClusterArn.hashCode());
                result = 31 * result + (this.targetCompressionType.hashCode());
                result = 31 * result + (this.targetKafkaClusterArn.hashCode());
                result = 31 * result + (this.topicReplication.hashCode());
                return result;
            }
        }
    }
    /**
     * Specifies the position in the topics to start replicating from.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.msk.*;
     * ReplicationStartingPositionProperty replicationStartingPositionProperty = ReplicationStartingPositionProperty.builder()
     *         .type("type")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-msk-replicator-replicationstartingposition.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-msk-replicator-replicationstartingposition.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_msk.CfnReplicator.ReplicationStartingPositionProperty")
    @software.amazon.jsii.Jsii.Proxy(ReplicationStartingPositionProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ReplicationStartingPositionProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The type of replication starting position.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-msk-replicator-replicationstartingposition.html#cfn-msk-replicator-replicationstartingposition-type">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-msk-replicator-replicationstartingposition.html#cfn-msk-replicator-replicationstartingposition-type</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getType() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ReplicationStartingPositionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ReplicationStartingPositionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ReplicationStartingPositionProperty> {
            java.lang.String type;

            /**
             * Sets the value of {@link ReplicationStartingPositionProperty#getType}
             * @param type The type of replication starting position.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder type(java.lang.String type) {
                this.type = type;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ReplicationStartingPositionProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ReplicationStartingPositionProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ReplicationStartingPositionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ReplicationStartingPositionProperty {
            private final java.lang.String type;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.type = software.amazon.jsii.Kernel.get(this, "type", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.type = builder.type;
            }

            @Override
            public final java.lang.String getType() {
                return this.type;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getType() != null) {
                    data.set("type", om.valueToTree(this.getType()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_msk.CfnReplicator.ReplicationStartingPositionProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ReplicationStartingPositionProperty.Jsii$Proxy that = (ReplicationStartingPositionProperty.Jsii$Proxy) o;

                return this.type != null ? this.type.equals(that.type) : that.type == null;
            }

            @Override
            public final int hashCode() {
                int result = this.type != null ? this.type.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * Configuration for specifying replicated topic names will be the same as their corresponding upstream topics or prefixed with source cluster alias.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.msk.*;
     * ReplicationTopicNameConfigurationProperty replicationTopicNameConfigurationProperty = ReplicationTopicNameConfigurationProperty.builder()
     *         .type("type")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-msk-replicator-replicationtopicnameconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-msk-replicator-replicationtopicnameconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_msk.CfnReplicator.ReplicationTopicNameConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(ReplicationTopicNameConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ReplicationTopicNameConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The type of replication topic name configuration, identical to upstream topic name or prefixed with source cluster alias.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-msk-replicator-replicationtopicnameconfiguration.html#cfn-msk-replicator-replicationtopicnameconfiguration-type">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-msk-replicator-replicationtopicnameconfiguration.html#cfn-msk-replicator-replicationtopicnameconfiguration-type</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getType() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ReplicationTopicNameConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ReplicationTopicNameConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ReplicationTopicNameConfigurationProperty> {
            java.lang.String type;

            /**
             * Sets the value of {@link ReplicationTopicNameConfigurationProperty#getType}
             * @param type The type of replication topic name configuration, identical to upstream topic name or prefixed with source cluster alias.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder type(java.lang.String type) {
                this.type = type;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ReplicationTopicNameConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ReplicationTopicNameConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ReplicationTopicNameConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ReplicationTopicNameConfigurationProperty {
            private final java.lang.String type;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.type = software.amazon.jsii.Kernel.get(this, "type", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.type = builder.type;
            }

            @Override
            public final java.lang.String getType() {
                return this.type;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getType() != null) {
                    data.set("type", om.valueToTree(this.getType()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_msk.CfnReplicator.ReplicationTopicNameConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ReplicationTopicNameConfigurationProperty.Jsii$Proxy that = (ReplicationTopicNameConfigurationProperty.Jsii$Proxy) o;

                return this.type != null ? this.type.equals(that.type) : that.type == null;
            }

            @Override
            public final int hashCode() {
                int result = this.type != null ? this.type.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * Details about topic replication.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.msk.*;
     * TopicReplicationProperty topicReplicationProperty = TopicReplicationProperty.builder()
     *         .topicsToReplicate(List.of("topicsToReplicate"))
     *         // the properties below are optional
     *         .copyAccessControlListsForTopics(false)
     *         .copyTopicConfigurations(false)
     *         .detectAndCopyNewTopics(false)
     *         .startingPosition(ReplicationStartingPositionProperty.builder()
     *                 .type("type")
     *                 .build())
     *         .topicNameConfiguration(ReplicationTopicNameConfigurationProperty.builder()
     *                 .type("type")
     *                 .build())
     *         .topicsToExclude(List.of("topicsToExclude"))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-msk-replicator-topicreplication.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-msk-replicator-topicreplication.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_msk.CfnReplicator.TopicReplicationProperty")
    @software.amazon.jsii.Jsii.Proxy(TopicReplicationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface TopicReplicationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * List of regular expression patterns indicating the topics to copy.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-msk-replicator-topicreplication.html#cfn-msk-replicator-topicreplication-topicstoreplicate">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-msk-replicator-topicreplication.html#cfn-msk-replicator-topicreplication-topicstoreplicate</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> getTopicsToReplicate();

        /**
         * Whether to periodically configure remote topic ACLs to match their corresponding upstream topics.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-msk-replicator-topicreplication.html#cfn-msk-replicator-topicreplication-copyaccesscontrollistsfortopics">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-msk-replicator-topicreplication.html#cfn-msk-replicator-topicreplication-copyaccesscontrollistsfortopics</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getCopyAccessControlListsForTopics() {
            return null;
        }

        /**
         * Whether to periodically configure remote topics to match their corresponding upstream topics.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-msk-replicator-topicreplication.html#cfn-msk-replicator-topicreplication-copytopicconfigurations">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-msk-replicator-topicreplication.html#cfn-msk-replicator-topicreplication-copytopicconfigurations</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getCopyTopicConfigurations() {
            return null;
        }

        /**
         * Whether to periodically check for new topics and partitions.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-msk-replicator-topicreplication.html#cfn-msk-replicator-topicreplication-detectandcopynewtopics">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-msk-replicator-topicreplication.html#cfn-msk-replicator-topicreplication-detectandcopynewtopics</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getDetectAndCopyNewTopics() {
            return null;
        }

        /**
         * Specifies the position in the topics to start replicating from.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-msk-replicator-topicreplication.html#cfn-msk-replicator-topicreplication-startingposition">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-msk-replicator-topicreplication.html#cfn-msk-replicator-topicreplication-startingposition</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getStartingPosition() {
            return null;
        }

        /**
         * Configuration for specifying replicated topic names will be the same as their corresponding upstream topics or prefixed with source cluster alias.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-msk-replicator-topicreplication.html#cfn-msk-replicator-topicreplication-topicnameconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-msk-replicator-topicreplication.html#cfn-msk-replicator-topicreplication-topicnameconfiguration</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getTopicNameConfiguration() {
            return null;
        }

        /**
         * List of regular expression patterns indicating the topics that should not be replicated.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-msk-replicator-topicreplication.html#cfn-msk-replicator-topicreplication-topicstoexclude">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-msk-replicator-topicreplication.html#cfn-msk-replicator-topicreplication-topicstoexclude</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getTopicsToExclude() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link TopicReplicationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link TopicReplicationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<TopicReplicationProperty> {
            java.util.List<java.lang.String> topicsToReplicate;
            java.lang.Object copyAccessControlListsForTopics;
            java.lang.Object copyTopicConfigurations;
            java.lang.Object detectAndCopyNewTopics;
            java.lang.Object startingPosition;
            java.lang.Object topicNameConfiguration;
            java.util.List<java.lang.String> topicsToExclude;

            /**
             * Sets the value of {@link TopicReplicationProperty#getTopicsToReplicate}
             * @param topicsToReplicate List of regular expression patterns indicating the topics to copy. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder topicsToReplicate(java.util.List<java.lang.String> topicsToReplicate) {
                this.topicsToReplicate = topicsToReplicate;
                return this;
            }

            /**
             * Sets the value of {@link TopicReplicationProperty#getCopyAccessControlListsForTopics}
             * @param copyAccessControlListsForTopics Whether to periodically configure remote topic ACLs to match their corresponding upstream topics.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder copyAccessControlListsForTopics(java.lang.Boolean copyAccessControlListsForTopics) {
                this.copyAccessControlListsForTopics = copyAccessControlListsForTopics;
                return this;
            }

            /**
             * Sets the value of {@link TopicReplicationProperty#getCopyAccessControlListsForTopics}
             * @param copyAccessControlListsForTopics Whether to periodically configure remote topic ACLs to match their corresponding upstream topics.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder copyAccessControlListsForTopics(software.amazon.awscdk.IResolvable copyAccessControlListsForTopics) {
                this.copyAccessControlListsForTopics = copyAccessControlListsForTopics;
                return this;
            }

            /**
             * Sets the value of {@link TopicReplicationProperty#getCopyTopicConfigurations}
             * @param copyTopicConfigurations Whether to periodically configure remote topics to match their corresponding upstream topics.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder copyTopicConfigurations(java.lang.Boolean copyTopicConfigurations) {
                this.copyTopicConfigurations = copyTopicConfigurations;
                return this;
            }

            /**
             * Sets the value of {@link TopicReplicationProperty#getCopyTopicConfigurations}
             * @param copyTopicConfigurations Whether to periodically configure remote topics to match their corresponding upstream topics.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder copyTopicConfigurations(software.amazon.awscdk.IResolvable copyTopicConfigurations) {
                this.copyTopicConfigurations = copyTopicConfigurations;
                return this;
            }

            /**
             * Sets the value of {@link TopicReplicationProperty#getDetectAndCopyNewTopics}
             * @param detectAndCopyNewTopics Whether to periodically check for new topics and partitions.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder detectAndCopyNewTopics(java.lang.Boolean detectAndCopyNewTopics) {
                this.detectAndCopyNewTopics = detectAndCopyNewTopics;
                return this;
            }

            /**
             * Sets the value of {@link TopicReplicationProperty#getDetectAndCopyNewTopics}
             * @param detectAndCopyNewTopics Whether to periodically check for new topics and partitions.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder detectAndCopyNewTopics(software.amazon.awscdk.IResolvable detectAndCopyNewTopics) {
                this.detectAndCopyNewTopics = detectAndCopyNewTopics;
                return this;
            }

            /**
             * Sets the value of {@link TopicReplicationProperty#getStartingPosition}
             * @param startingPosition Specifies the position in the topics to start replicating from.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder startingPosition(software.amazon.awscdk.IResolvable startingPosition) {
                this.startingPosition = startingPosition;
                return this;
            }

            /**
             * Sets the value of {@link TopicReplicationProperty#getStartingPosition}
             * @param startingPosition Specifies the position in the topics to start replicating from.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder startingPosition(software.amazon.awscdk.services.msk.CfnReplicator.ReplicationStartingPositionProperty startingPosition) {
                this.startingPosition = startingPosition;
                return this;
            }

            /**
             * Sets the value of {@link TopicReplicationProperty#getTopicNameConfiguration}
             * @param topicNameConfiguration Configuration for specifying replicated topic names will be the same as their corresponding upstream topics or prefixed with source cluster alias.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder topicNameConfiguration(software.amazon.awscdk.IResolvable topicNameConfiguration) {
                this.topicNameConfiguration = topicNameConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link TopicReplicationProperty#getTopicNameConfiguration}
             * @param topicNameConfiguration Configuration for specifying replicated topic names will be the same as their corresponding upstream topics or prefixed with source cluster alias.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder topicNameConfiguration(software.amazon.awscdk.services.msk.CfnReplicator.ReplicationTopicNameConfigurationProperty topicNameConfiguration) {
                this.topicNameConfiguration = topicNameConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link TopicReplicationProperty#getTopicsToExclude}
             * @param topicsToExclude List of regular expression patterns indicating the topics that should not be replicated.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder topicsToExclude(java.util.List<java.lang.String> topicsToExclude) {
                this.topicsToExclude = topicsToExclude;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link TopicReplicationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public TopicReplicationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link TopicReplicationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements TopicReplicationProperty {
            private final java.util.List<java.lang.String> topicsToReplicate;
            private final java.lang.Object copyAccessControlListsForTopics;
            private final java.lang.Object copyTopicConfigurations;
            private final java.lang.Object detectAndCopyNewTopics;
            private final java.lang.Object startingPosition;
            private final java.lang.Object topicNameConfiguration;
            private final java.util.List<java.lang.String> topicsToExclude;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.topicsToReplicate = software.amazon.jsii.Kernel.get(this, "topicsToReplicate", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.copyAccessControlListsForTopics = software.amazon.jsii.Kernel.get(this, "copyAccessControlListsForTopics", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.copyTopicConfigurations = software.amazon.jsii.Kernel.get(this, "copyTopicConfigurations", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.detectAndCopyNewTopics = software.amazon.jsii.Kernel.get(this, "detectAndCopyNewTopics", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.startingPosition = software.amazon.jsii.Kernel.get(this, "startingPosition", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.topicNameConfiguration = software.amazon.jsii.Kernel.get(this, "topicNameConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.topicsToExclude = software.amazon.jsii.Kernel.get(this, "topicsToExclude", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.topicsToReplicate = java.util.Objects.requireNonNull(builder.topicsToReplicate, "topicsToReplicate is required");
                this.copyAccessControlListsForTopics = builder.copyAccessControlListsForTopics;
                this.copyTopicConfigurations = builder.copyTopicConfigurations;
                this.detectAndCopyNewTopics = builder.detectAndCopyNewTopics;
                this.startingPosition = builder.startingPosition;
                this.topicNameConfiguration = builder.topicNameConfiguration;
                this.topicsToExclude = builder.topicsToExclude;
            }

            @Override
            public final java.util.List<java.lang.String> getTopicsToReplicate() {
                return this.topicsToReplicate;
            }

            @Override
            public final java.lang.Object getCopyAccessControlListsForTopics() {
                return this.copyAccessControlListsForTopics;
            }

            @Override
            public final java.lang.Object getCopyTopicConfigurations() {
                return this.copyTopicConfigurations;
            }

            @Override
            public final java.lang.Object getDetectAndCopyNewTopics() {
                return this.detectAndCopyNewTopics;
            }

            @Override
            public final java.lang.Object getStartingPosition() {
                return this.startingPosition;
            }

            @Override
            public final java.lang.Object getTopicNameConfiguration() {
                return this.topicNameConfiguration;
            }

            @Override
            public final java.util.List<java.lang.String> getTopicsToExclude() {
                return this.topicsToExclude;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("topicsToReplicate", om.valueToTree(this.getTopicsToReplicate()));
                if (this.getCopyAccessControlListsForTopics() != null) {
                    data.set("copyAccessControlListsForTopics", om.valueToTree(this.getCopyAccessControlListsForTopics()));
                }
                if (this.getCopyTopicConfigurations() != null) {
                    data.set("copyTopicConfigurations", om.valueToTree(this.getCopyTopicConfigurations()));
                }
                if (this.getDetectAndCopyNewTopics() != null) {
                    data.set("detectAndCopyNewTopics", om.valueToTree(this.getDetectAndCopyNewTopics()));
                }
                if (this.getStartingPosition() != null) {
                    data.set("startingPosition", om.valueToTree(this.getStartingPosition()));
                }
                if (this.getTopicNameConfiguration() != null) {
                    data.set("topicNameConfiguration", om.valueToTree(this.getTopicNameConfiguration()));
                }
                if (this.getTopicsToExclude() != null) {
                    data.set("topicsToExclude", om.valueToTree(this.getTopicsToExclude()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_msk.CfnReplicator.TopicReplicationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                TopicReplicationProperty.Jsii$Proxy that = (TopicReplicationProperty.Jsii$Proxy) o;

                if (!topicsToReplicate.equals(that.topicsToReplicate)) return false;
                if (this.copyAccessControlListsForTopics != null ? !this.copyAccessControlListsForTopics.equals(that.copyAccessControlListsForTopics) : that.copyAccessControlListsForTopics != null) return false;
                if (this.copyTopicConfigurations != null ? !this.copyTopicConfigurations.equals(that.copyTopicConfigurations) : that.copyTopicConfigurations != null) return false;
                if (this.detectAndCopyNewTopics != null ? !this.detectAndCopyNewTopics.equals(that.detectAndCopyNewTopics) : that.detectAndCopyNewTopics != null) return false;
                if (this.startingPosition != null ? !this.startingPosition.equals(that.startingPosition) : that.startingPosition != null) return false;
                if (this.topicNameConfiguration != null ? !this.topicNameConfiguration.equals(that.topicNameConfiguration) : that.topicNameConfiguration != null) return false;
                return this.topicsToExclude != null ? this.topicsToExclude.equals(that.topicsToExclude) : that.topicsToExclude == null;
            }

            @Override
            public final int hashCode() {
                int result = this.topicsToReplicate.hashCode();
                result = 31 * result + (this.copyAccessControlListsForTopics != null ? this.copyAccessControlListsForTopics.hashCode() : 0);
                result = 31 * result + (this.copyTopicConfigurations != null ? this.copyTopicConfigurations.hashCode() : 0);
                result = 31 * result + (this.detectAndCopyNewTopics != null ? this.detectAndCopyNewTopics.hashCode() : 0);
                result = 31 * result + (this.startingPosition != null ? this.startingPosition.hashCode() : 0);
                result = 31 * result + (this.topicNameConfiguration != null ? this.topicNameConfiguration.hashCode() : 0);
                result = 31 * result + (this.topicsToExclude != null ? this.topicsToExclude.hashCode() : 0);
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.msk.CfnReplicator}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.msk.CfnReplicator> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope Scope in which this resource is defined. This parameter is required.
         * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.msk.CfnReplicatorProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.msk.CfnReplicatorProps.Builder();
        }

        /**
         * Kafka Clusters to use in setting up sources / targets for replication.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-msk-replicator.html#cfn-msk-replicator-kafkaclusters">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-msk-replicator.html#cfn-msk-replicator-kafkaclusters</a>
         * @param kafkaClusters Kafka Clusters to use in setting up sources / targets for replication. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder kafkaClusters(final software.amazon.awscdk.IResolvable kafkaClusters) {
            this.props.kafkaClusters(kafkaClusters);
            return this;
        }
        /**
         * Kafka Clusters to use in setting up sources / targets for replication.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-msk-replicator.html#cfn-msk-replicator-kafkaclusters">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-msk-replicator.html#cfn-msk-replicator-kafkaclusters</a>
         * @param kafkaClusters Kafka Clusters to use in setting up sources / targets for replication. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder kafkaClusters(final java.util.List<? extends java.lang.Object> kafkaClusters) {
            this.props.kafkaClusters(kafkaClusters);
            return this;
        }

        /**
         * A list of replication configurations, where each configuration targets a given source cluster to target cluster replication flow.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-msk-replicator.html#cfn-msk-replicator-replicationinfolist">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-msk-replicator.html#cfn-msk-replicator-replicationinfolist</a>
         * @param replicationInfoList A list of replication configurations, where each configuration targets a given source cluster to target cluster replication flow. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder replicationInfoList(final software.amazon.awscdk.IResolvable replicationInfoList) {
            this.props.replicationInfoList(replicationInfoList);
            return this;
        }
        /**
         * A list of replication configurations, where each configuration targets a given source cluster to target cluster replication flow.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-msk-replicator.html#cfn-msk-replicator-replicationinfolist">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-msk-replicator.html#cfn-msk-replicator-replicationinfolist</a>
         * @param replicationInfoList A list of replication configurations, where each configuration targets a given source cluster to target cluster replication flow. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder replicationInfoList(final java.util.List<? extends java.lang.Object> replicationInfoList) {
            this.props.replicationInfoList(replicationInfoList);
            return this;
        }

        /**
         * The name of the replicator.
         * <p>
         * Alpha-numeric characters with '-' are allowed.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-msk-replicator.html#cfn-msk-replicator-replicatorname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-msk-replicator.html#cfn-msk-replicator-replicatorname</a>
         * @param replicatorName The name of the replicator. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder replicatorName(final java.lang.String replicatorName) {
            this.props.replicatorName(replicatorName);
            return this;
        }

        /**
         * The ARN of the IAM role used by the replicator to access resources in the customer's account (e.g source and target clusters).
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-msk-replicator.html#cfn-msk-replicator-serviceexecutionrolearn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-msk-replicator.html#cfn-msk-replicator-serviceexecutionrolearn</a>
         * @param serviceExecutionRoleArn The ARN of the IAM role used by the replicator to access resources in the customer's account (e.g source and target clusters). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder serviceExecutionRoleArn(final java.lang.String serviceExecutionRoleArn) {
            this.props.serviceExecutionRoleArn(serviceExecutionRoleArn);
            return this;
        }

        /**
         * A summary description of the replicator.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-msk-replicator.html#cfn-msk-replicator-description">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-msk-replicator.html#cfn-msk-replicator-description</a>
         * @param description A summary description of the replicator. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(final java.lang.String description) {
            this.props.description(description);
            return this;
        }

        /**
         * List of tags to attach to created Replicator.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-msk-replicator.html#cfn-msk-replicator-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-msk-replicator.html#cfn-msk-replicator-tags</a>
         * @param tags List of tags to attach to created Replicator. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(final java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.props.tags(tags);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.msk.CfnReplicator}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.msk.CfnReplicator build() {
            return new software.amazon.awscdk.services.msk.CfnReplicator(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
