package software.amazon.awscdk.services.networkmanager;

/**
 * Properties for defining a <code>CfnSiteToSiteVpnAttachment</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.networkmanager.*;
 * CfnSiteToSiteVpnAttachmentProps cfnSiteToSiteVpnAttachmentProps = CfnSiteToSiteVpnAttachmentProps.builder()
 *         .coreNetworkId("coreNetworkId")
 *         .vpnConnectionArn("vpnConnectionArn")
 *         // the properties below are optional
 *         .networkFunctionGroupName("networkFunctionGroupName")
 *         .proposedNetworkFunctionGroupChange(ProposedNetworkFunctionGroupChangeProperty.builder()
 *                 .attachmentPolicyRuleNumber(123)
 *                 .networkFunctionGroupName("networkFunctionGroupName")
 *                 .tags(List.of(CfnTag.builder()
 *                         .key("key")
 *                         .value("value")
 *                         .build()))
 *                 .build())
 *         .proposedSegmentChange(ProposedSegmentChangeProperty.builder()
 *                 .attachmentPolicyRuleNumber(123)
 *                 .segmentName("segmentName")
 *                 .tags(List.of(CfnTag.builder()
 *                         .key("key")
 *                         .value("value")
 *                         .build()))
 *                 .build())
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-networkmanager-sitetositevpnattachment.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-networkmanager-sitetositevpnattachment.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-05-20T23:52:59.712Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_networkmanager.CfnSiteToSiteVpnAttachmentProps")
@software.amazon.jsii.Jsii.Proxy(CfnSiteToSiteVpnAttachmentProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnSiteToSiteVpnAttachmentProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The ID of a core network where you're creating a site-to-site VPN attachment.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-networkmanager-sitetositevpnattachment.html#cfn-networkmanager-sitetositevpnattachment-corenetworkid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-networkmanager-sitetositevpnattachment.html#cfn-networkmanager-sitetositevpnattachment-corenetworkid</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getCoreNetworkId();

    /**
     * The ARN of the site-to-site VPN attachment.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-networkmanager-sitetositevpnattachment.html#cfn-networkmanager-sitetositevpnattachment-vpnconnectionarn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-networkmanager-sitetositevpnattachment.html#cfn-networkmanager-sitetositevpnattachment-vpnconnectionarn</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getVpnConnectionArn();

    /**
     * The name of the network function group.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-networkmanager-sitetositevpnattachment.html#cfn-networkmanager-sitetositevpnattachment-networkfunctiongroupname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-networkmanager-sitetositevpnattachment.html#cfn-networkmanager-sitetositevpnattachment-networkfunctiongroupname</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getNetworkFunctionGroupName() {
        return null;
    }

    /**
     * Describes proposed changes to a network function group.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-networkmanager-sitetositevpnattachment.html#cfn-networkmanager-sitetositevpnattachment-proposednetworkfunctiongroupchange">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-networkmanager-sitetositevpnattachment.html#cfn-networkmanager-sitetositevpnattachment-proposednetworkfunctiongroupchange</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getProposedNetworkFunctionGroupChange() {
        return null;
    }

    /**
     * Describes a proposed segment change.
     * <p>
     * In some cases, the segment change must first be evaluated and accepted.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-networkmanager-sitetositevpnattachment.html#cfn-networkmanager-sitetositevpnattachment-proposedsegmentchange">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-networkmanager-sitetositevpnattachment.html#cfn-networkmanager-sitetositevpnattachment-proposedsegmentchange</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getProposedSegmentChange() {
        return null;
    }

    /**
     * The tags associated with the Site-to-Site VPN attachment.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-networkmanager-sitetositevpnattachment.html#cfn-networkmanager-sitetositevpnattachment-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-networkmanager-sitetositevpnattachment.html#cfn-networkmanager-sitetositevpnattachment-tags</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTags() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnSiteToSiteVpnAttachmentProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnSiteToSiteVpnAttachmentProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnSiteToSiteVpnAttachmentProps> {
        java.lang.String coreNetworkId;
        java.lang.String vpnConnectionArn;
        java.lang.String networkFunctionGroupName;
        java.lang.Object proposedNetworkFunctionGroupChange;
        java.lang.Object proposedSegmentChange;
        java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Sets the value of {@link CfnSiteToSiteVpnAttachmentProps#getCoreNetworkId}
         * @param coreNetworkId The ID of a core network where you're creating a site-to-site VPN attachment. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder coreNetworkId(java.lang.String coreNetworkId) {
            this.coreNetworkId = coreNetworkId;
            return this;
        }

        /**
         * Sets the value of {@link CfnSiteToSiteVpnAttachmentProps#getVpnConnectionArn}
         * @param vpnConnectionArn The ARN of the site-to-site VPN attachment. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder vpnConnectionArn(java.lang.String vpnConnectionArn) {
            this.vpnConnectionArn = vpnConnectionArn;
            return this;
        }

        /**
         * Sets the value of {@link CfnSiteToSiteVpnAttachmentProps#getNetworkFunctionGroupName}
         * @param networkFunctionGroupName The name of the network function group.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder networkFunctionGroupName(java.lang.String networkFunctionGroupName) {
            this.networkFunctionGroupName = networkFunctionGroupName;
            return this;
        }

        /**
         * Sets the value of {@link CfnSiteToSiteVpnAttachmentProps#getProposedNetworkFunctionGroupChange}
         * @param proposedNetworkFunctionGroupChange Describes proposed changes to a network function group.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder proposedNetworkFunctionGroupChange(software.amazon.awscdk.IResolvable proposedNetworkFunctionGroupChange) {
            this.proposedNetworkFunctionGroupChange = proposedNetworkFunctionGroupChange;
            return this;
        }

        /**
         * Sets the value of {@link CfnSiteToSiteVpnAttachmentProps#getProposedNetworkFunctionGroupChange}
         * @param proposedNetworkFunctionGroupChange Describes proposed changes to a network function group.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder proposedNetworkFunctionGroupChange(software.amazon.awscdk.services.networkmanager.CfnSiteToSiteVpnAttachment.ProposedNetworkFunctionGroupChangeProperty proposedNetworkFunctionGroupChange) {
            this.proposedNetworkFunctionGroupChange = proposedNetworkFunctionGroupChange;
            return this;
        }

        /**
         * Sets the value of {@link CfnSiteToSiteVpnAttachmentProps#getProposedSegmentChange}
         * @param proposedSegmentChange Describes a proposed segment change.
         *                              In some cases, the segment change must first be evaluated and accepted.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder proposedSegmentChange(software.amazon.awscdk.IResolvable proposedSegmentChange) {
            this.proposedSegmentChange = proposedSegmentChange;
            return this;
        }

        /**
         * Sets the value of {@link CfnSiteToSiteVpnAttachmentProps#getProposedSegmentChange}
         * @param proposedSegmentChange Describes a proposed segment change.
         *                              In some cases, the segment change must first be evaluated and accepted.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder proposedSegmentChange(software.amazon.awscdk.services.networkmanager.CfnSiteToSiteVpnAttachment.ProposedSegmentChangeProperty proposedSegmentChange) {
            this.proposedSegmentChange = proposedSegmentChange;
            return this;
        }

        /**
         * Sets the value of {@link CfnSiteToSiteVpnAttachmentProps#getTags}
         * @param tags The tags associated with the Site-to-Site VPN attachment.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder tags(java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)tags;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnSiteToSiteVpnAttachmentProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnSiteToSiteVpnAttachmentProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnSiteToSiteVpnAttachmentProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnSiteToSiteVpnAttachmentProps {
        private final java.lang.String coreNetworkId;
        private final java.lang.String vpnConnectionArn;
        private final java.lang.String networkFunctionGroupName;
        private final java.lang.Object proposedNetworkFunctionGroupChange;
        private final java.lang.Object proposedSegmentChange;
        private final java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.coreNetworkId = software.amazon.jsii.Kernel.get(this, "coreNetworkId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.vpnConnectionArn = software.amazon.jsii.Kernel.get(this, "vpnConnectionArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.networkFunctionGroupName = software.amazon.jsii.Kernel.get(this, "networkFunctionGroupName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.proposedNetworkFunctionGroupChange = software.amazon.jsii.Kernel.get(this, "proposedNetworkFunctionGroupChange", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.proposedSegmentChange = software.amazon.jsii.Kernel.get(this, "proposedSegmentChange", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.coreNetworkId = java.util.Objects.requireNonNull(builder.coreNetworkId, "coreNetworkId is required");
            this.vpnConnectionArn = java.util.Objects.requireNonNull(builder.vpnConnectionArn, "vpnConnectionArn is required");
            this.networkFunctionGroupName = builder.networkFunctionGroupName;
            this.proposedNetworkFunctionGroupChange = builder.proposedNetworkFunctionGroupChange;
            this.proposedSegmentChange = builder.proposedSegmentChange;
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)builder.tags;
        }

        @Override
        public final java.lang.String getCoreNetworkId() {
            return this.coreNetworkId;
        }

        @Override
        public final java.lang.String getVpnConnectionArn() {
            return this.vpnConnectionArn;
        }

        @Override
        public final java.lang.String getNetworkFunctionGroupName() {
            return this.networkFunctionGroupName;
        }

        @Override
        public final java.lang.Object getProposedNetworkFunctionGroupChange() {
            return this.proposedNetworkFunctionGroupChange;
        }

        @Override
        public final java.lang.Object getProposedSegmentChange() {
            return this.proposedSegmentChange;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.CfnTag> getTags() {
            return this.tags;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("coreNetworkId", om.valueToTree(this.getCoreNetworkId()));
            data.set("vpnConnectionArn", om.valueToTree(this.getVpnConnectionArn()));
            if (this.getNetworkFunctionGroupName() != null) {
                data.set("networkFunctionGroupName", om.valueToTree(this.getNetworkFunctionGroupName()));
            }
            if (this.getProposedNetworkFunctionGroupChange() != null) {
                data.set("proposedNetworkFunctionGroupChange", om.valueToTree(this.getProposedNetworkFunctionGroupChange()));
            }
            if (this.getProposedSegmentChange() != null) {
                data.set("proposedSegmentChange", om.valueToTree(this.getProposedSegmentChange()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_networkmanager.CfnSiteToSiteVpnAttachmentProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnSiteToSiteVpnAttachmentProps.Jsii$Proxy that = (CfnSiteToSiteVpnAttachmentProps.Jsii$Proxy) o;

            if (!coreNetworkId.equals(that.coreNetworkId)) return false;
            if (!vpnConnectionArn.equals(that.vpnConnectionArn)) return false;
            if (this.networkFunctionGroupName != null ? !this.networkFunctionGroupName.equals(that.networkFunctionGroupName) : that.networkFunctionGroupName != null) return false;
            if (this.proposedNetworkFunctionGroupChange != null ? !this.proposedNetworkFunctionGroupChange.equals(that.proposedNetworkFunctionGroupChange) : that.proposedNetworkFunctionGroupChange != null) return false;
            if (this.proposedSegmentChange != null ? !this.proposedSegmentChange.equals(that.proposedSegmentChange) : that.proposedSegmentChange != null) return false;
            return this.tags != null ? this.tags.equals(that.tags) : that.tags == null;
        }

        @Override
        public final int hashCode() {
            int result = this.coreNetworkId.hashCode();
            result = 31 * result + (this.vpnConnectionArn.hashCode());
            result = 31 * result + (this.networkFunctionGroupName != null ? this.networkFunctionGroupName.hashCode() : 0);
            result = 31 * result + (this.proposedNetworkFunctionGroupChange != null ? this.proposedNetworkFunctionGroupChange.hashCode() : 0);
            result = 31 * result + (this.proposedSegmentChange != null ? this.proposedSegmentChange.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            return result;
        }
    }
}
