package software.amazon.awscdk.services.networkmanager;

/**
 * Properties for defining a <code>CfnTransitGatewayRouteTableAttachment</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.networkmanager.*;
 * CfnTransitGatewayRouteTableAttachmentProps cfnTransitGatewayRouteTableAttachmentProps = CfnTransitGatewayRouteTableAttachmentProps.builder()
 *         .peeringId("peeringId")
 *         .transitGatewayRouteTableArn("transitGatewayRouteTableArn")
 *         // the properties below are optional
 *         .networkFunctionGroupName("networkFunctionGroupName")
 *         .proposedNetworkFunctionGroupChange(ProposedNetworkFunctionGroupChangeProperty.builder()
 *                 .attachmentPolicyRuleNumber(123)
 *                 .networkFunctionGroupName("networkFunctionGroupName")
 *                 .tags(List.of(CfnTag.builder()
 *                         .key("key")
 *                         .value("value")
 *                         .build()))
 *                 .build())
 *         .proposedSegmentChange(ProposedSegmentChangeProperty.builder()
 *                 .attachmentPolicyRuleNumber(123)
 *                 .segmentName("segmentName")
 *                 .tags(List.of(CfnTag.builder()
 *                         .key("key")
 *                         .value("value")
 *                         .build()))
 *                 .build())
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-networkmanager-transitgatewayroutetableattachment.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-networkmanager-transitgatewayroutetableattachment.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-05-20T23:52:59.717Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_networkmanager.CfnTransitGatewayRouteTableAttachmentProps")
@software.amazon.jsii.Jsii.Proxy(CfnTransitGatewayRouteTableAttachmentProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnTransitGatewayRouteTableAttachmentProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The ID of the transit gateway peering.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-networkmanager-transitgatewayroutetableattachment.html#cfn-networkmanager-transitgatewayroutetableattachment-peeringid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-networkmanager-transitgatewayroutetableattachment.html#cfn-networkmanager-transitgatewayroutetableattachment-peeringid</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getPeeringId();

    /**
     * The ARN of the transit gateway attachment route table.
     * <p>
     * For example, <code>"TransitGatewayRouteTableArn": "arn:aws:ec2:us-west-2:123456789012:transit-gateway-route-table/tgw-rtb-9876543210123456"</code> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-networkmanager-transitgatewayroutetableattachment.html#cfn-networkmanager-transitgatewayroutetableattachment-transitgatewayroutetablearn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-networkmanager-transitgatewayroutetableattachment.html#cfn-networkmanager-transitgatewayroutetableattachment-transitgatewayroutetablearn</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getTransitGatewayRouteTableArn();

    /**
     * The name of the network function group.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-networkmanager-transitgatewayroutetableattachment.html#cfn-networkmanager-transitgatewayroutetableattachment-networkfunctiongroupname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-networkmanager-transitgatewayroutetableattachment.html#cfn-networkmanager-transitgatewayroutetableattachment-networkfunctiongroupname</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getNetworkFunctionGroupName() {
        return null;
    }

    /**
     * Describes proposed changes to a network function group.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-networkmanager-transitgatewayroutetableattachment.html#cfn-networkmanager-transitgatewayroutetableattachment-proposednetworkfunctiongroupchange">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-networkmanager-transitgatewayroutetableattachment.html#cfn-networkmanager-transitgatewayroutetableattachment-proposednetworkfunctiongroupchange</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getProposedNetworkFunctionGroupChange() {
        return null;
    }

    /**
     * This property is read-only.
     * <p>
     * Values can't be assigned to it.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-networkmanager-transitgatewayroutetableattachment.html#cfn-networkmanager-transitgatewayroutetableattachment-proposedsegmentchange">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-networkmanager-transitgatewayroutetableattachment.html#cfn-networkmanager-transitgatewayroutetableattachment-proposedsegmentchange</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getProposedSegmentChange() {
        return null;
    }

    /**
     * The list of key-value pairs associated with the transit gateway route table attachment.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-networkmanager-transitgatewayroutetableattachment.html#cfn-networkmanager-transitgatewayroutetableattachment-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-networkmanager-transitgatewayroutetableattachment.html#cfn-networkmanager-transitgatewayroutetableattachment-tags</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTags() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnTransitGatewayRouteTableAttachmentProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnTransitGatewayRouteTableAttachmentProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnTransitGatewayRouteTableAttachmentProps> {
        java.lang.String peeringId;
        java.lang.String transitGatewayRouteTableArn;
        java.lang.String networkFunctionGroupName;
        java.lang.Object proposedNetworkFunctionGroupChange;
        java.lang.Object proposedSegmentChange;
        java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Sets the value of {@link CfnTransitGatewayRouteTableAttachmentProps#getPeeringId}
         * @param peeringId The ID of the transit gateway peering. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder peeringId(java.lang.String peeringId) {
            this.peeringId = peeringId;
            return this;
        }

        /**
         * Sets the value of {@link CfnTransitGatewayRouteTableAttachmentProps#getTransitGatewayRouteTableArn}
         * @param transitGatewayRouteTableArn The ARN of the transit gateway attachment route table. This parameter is required.
         *                                    For example, <code>"TransitGatewayRouteTableArn": "arn:aws:ec2:us-west-2:123456789012:transit-gateway-route-table/tgw-rtb-9876543210123456"</code> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder transitGatewayRouteTableArn(java.lang.String transitGatewayRouteTableArn) {
            this.transitGatewayRouteTableArn = transitGatewayRouteTableArn;
            return this;
        }

        /**
         * Sets the value of {@link CfnTransitGatewayRouteTableAttachmentProps#getNetworkFunctionGroupName}
         * @param networkFunctionGroupName The name of the network function group.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder networkFunctionGroupName(java.lang.String networkFunctionGroupName) {
            this.networkFunctionGroupName = networkFunctionGroupName;
            return this;
        }

        /**
         * Sets the value of {@link CfnTransitGatewayRouteTableAttachmentProps#getProposedNetworkFunctionGroupChange}
         * @param proposedNetworkFunctionGroupChange Describes proposed changes to a network function group.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder proposedNetworkFunctionGroupChange(software.amazon.awscdk.IResolvable proposedNetworkFunctionGroupChange) {
            this.proposedNetworkFunctionGroupChange = proposedNetworkFunctionGroupChange;
            return this;
        }

        /**
         * Sets the value of {@link CfnTransitGatewayRouteTableAttachmentProps#getProposedNetworkFunctionGroupChange}
         * @param proposedNetworkFunctionGroupChange Describes proposed changes to a network function group.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder proposedNetworkFunctionGroupChange(software.amazon.awscdk.services.networkmanager.CfnTransitGatewayRouteTableAttachment.ProposedNetworkFunctionGroupChangeProperty proposedNetworkFunctionGroupChange) {
            this.proposedNetworkFunctionGroupChange = proposedNetworkFunctionGroupChange;
            return this;
        }

        /**
         * Sets the value of {@link CfnTransitGatewayRouteTableAttachmentProps#getProposedSegmentChange}
         * @param proposedSegmentChange This property is read-only.
         *                              Values can't be assigned to it.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder proposedSegmentChange(software.amazon.awscdk.IResolvable proposedSegmentChange) {
            this.proposedSegmentChange = proposedSegmentChange;
            return this;
        }

        /**
         * Sets the value of {@link CfnTransitGatewayRouteTableAttachmentProps#getProposedSegmentChange}
         * @param proposedSegmentChange This property is read-only.
         *                              Values can't be assigned to it.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder proposedSegmentChange(software.amazon.awscdk.services.networkmanager.CfnTransitGatewayRouteTableAttachment.ProposedSegmentChangeProperty proposedSegmentChange) {
            this.proposedSegmentChange = proposedSegmentChange;
            return this;
        }

        /**
         * Sets the value of {@link CfnTransitGatewayRouteTableAttachmentProps#getTags}
         * @param tags The list of key-value pairs associated with the transit gateway route table attachment.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder tags(java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)tags;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnTransitGatewayRouteTableAttachmentProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnTransitGatewayRouteTableAttachmentProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnTransitGatewayRouteTableAttachmentProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnTransitGatewayRouteTableAttachmentProps {
        private final java.lang.String peeringId;
        private final java.lang.String transitGatewayRouteTableArn;
        private final java.lang.String networkFunctionGroupName;
        private final java.lang.Object proposedNetworkFunctionGroupChange;
        private final java.lang.Object proposedSegmentChange;
        private final java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.peeringId = software.amazon.jsii.Kernel.get(this, "peeringId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.transitGatewayRouteTableArn = software.amazon.jsii.Kernel.get(this, "transitGatewayRouteTableArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.networkFunctionGroupName = software.amazon.jsii.Kernel.get(this, "networkFunctionGroupName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.proposedNetworkFunctionGroupChange = software.amazon.jsii.Kernel.get(this, "proposedNetworkFunctionGroupChange", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.proposedSegmentChange = software.amazon.jsii.Kernel.get(this, "proposedSegmentChange", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.peeringId = java.util.Objects.requireNonNull(builder.peeringId, "peeringId is required");
            this.transitGatewayRouteTableArn = java.util.Objects.requireNonNull(builder.transitGatewayRouteTableArn, "transitGatewayRouteTableArn is required");
            this.networkFunctionGroupName = builder.networkFunctionGroupName;
            this.proposedNetworkFunctionGroupChange = builder.proposedNetworkFunctionGroupChange;
            this.proposedSegmentChange = builder.proposedSegmentChange;
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)builder.tags;
        }

        @Override
        public final java.lang.String getPeeringId() {
            return this.peeringId;
        }

        @Override
        public final java.lang.String getTransitGatewayRouteTableArn() {
            return this.transitGatewayRouteTableArn;
        }

        @Override
        public final java.lang.String getNetworkFunctionGroupName() {
            return this.networkFunctionGroupName;
        }

        @Override
        public final java.lang.Object getProposedNetworkFunctionGroupChange() {
            return this.proposedNetworkFunctionGroupChange;
        }

        @Override
        public final java.lang.Object getProposedSegmentChange() {
            return this.proposedSegmentChange;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.CfnTag> getTags() {
            return this.tags;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("peeringId", om.valueToTree(this.getPeeringId()));
            data.set("transitGatewayRouteTableArn", om.valueToTree(this.getTransitGatewayRouteTableArn()));
            if (this.getNetworkFunctionGroupName() != null) {
                data.set("networkFunctionGroupName", om.valueToTree(this.getNetworkFunctionGroupName()));
            }
            if (this.getProposedNetworkFunctionGroupChange() != null) {
                data.set("proposedNetworkFunctionGroupChange", om.valueToTree(this.getProposedNetworkFunctionGroupChange()));
            }
            if (this.getProposedSegmentChange() != null) {
                data.set("proposedSegmentChange", om.valueToTree(this.getProposedSegmentChange()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_networkmanager.CfnTransitGatewayRouteTableAttachmentProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnTransitGatewayRouteTableAttachmentProps.Jsii$Proxy that = (CfnTransitGatewayRouteTableAttachmentProps.Jsii$Proxy) o;

            if (!peeringId.equals(that.peeringId)) return false;
            if (!transitGatewayRouteTableArn.equals(that.transitGatewayRouteTableArn)) return false;
            if (this.networkFunctionGroupName != null ? !this.networkFunctionGroupName.equals(that.networkFunctionGroupName) : that.networkFunctionGroupName != null) return false;
            if (this.proposedNetworkFunctionGroupChange != null ? !this.proposedNetworkFunctionGroupChange.equals(that.proposedNetworkFunctionGroupChange) : that.proposedNetworkFunctionGroupChange != null) return false;
            if (this.proposedSegmentChange != null ? !this.proposedSegmentChange.equals(that.proposedSegmentChange) : that.proposedSegmentChange != null) return false;
            return this.tags != null ? this.tags.equals(that.tags) : that.tags == null;
        }

        @Override
        public final int hashCode() {
            int result = this.peeringId.hashCode();
            result = 31 * result + (this.transitGatewayRouteTableArn.hashCode());
            result = 31 * result + (this.networkFunctionGroupName != null ? this.networkFunctionGroupName.hashCode() : 0);
            result = 31 * result + (this.proposedNetworkFunctionGroupChange != null ? this.proposedNetworkFunctionGroupChange.hashCode() : 0);
            result = 31 * result + (this.proposedSegmentChange != null ? this.proposedSegmentChange.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            return result;
        }
    }
}
