package software.amazon.awscdk.services.opensearchserverless;

/**
 * Properties for defining a <code>CfnIndex</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.opensearchserverless.*;
 * PropertyMappingProperty propertyMappingProperty_;
 * CfnIndexProps cfnIndexProps = CfnIndexProps.builder()
 *         .collectionEndpoint("collectionEndpoint")
 *         .indexName("indexName")
 *         // the properties below are optional
 *         .mappings(MappingsProperty.builder()
 *                 .properties(Map.of(
 *                         "propertiesKey", PropertyMappingProperty.builder()
 *                                 .type("type")
 *                                 // the properties below are optional
 *                                 .dimension(123)
 *                                 .index(false)
 *                                 .method(MethodProperty.builder()
 *                                         .engine("engine")
 *                                         .name("name")
 *                                         // the properties below are optional
 *                                         .parameters(ParametersProperty.builder()
 *                                                 .efConstruction(123)
 *                                                 .m(123)
 *                                                 .build())
 *                                         .spaceType("spaceType")
 *                                         .build())
 *                                 .properties(Map.of(
 *                                         "propertiesKey", propertyMappingProperty_))
 *                                 .value("value")
 *                                 .build()))
 *                 .build())
 *         .settings(IndexSettingsProperty.builder()
 *                 .index(IndexProperty.builder()
 *                         .knn(false)
 *                         .knnAlgoParamEfSearch(123)
 *                         .refreshInterval("refreshInterval")
 *                         .build())
 *                 .build())
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opensearchserverless-index.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opensearchserverless-index.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-05-20T23:52:59.798Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_opensearchserverless.CfnIndexProps")
@software.amazon.jsii.Jsii.Proxy(CfnIndexProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnIndexProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The endpoint for the collection.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opensearchserverless-index.html#cfn-opensearchserverless-index-collectionendpoint">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opensearchserverless-index.html#cfn-opensearchserverless-index-collectionendpoint</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getCollectionEndpoint();

    /**
     * The name of the OpenSearch Serverless index.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opensearchserverless-index.html#cfn-opensearchserverless-index-indexname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opensearchserverless-index.html#cfn-opensearchserverless-index-indexname</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getIndexName();

    /**
     * Index mappings for the OpenSearch Serverless index.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opensearchserverless-index.html#cfn-opensearchserverless-index-mappings">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opensearchserverless-index.html#cfn-opensearchserverless-index-mappings</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getMappings() {
        return null;
    }

    /**
     * Index settings for the OpenSearch Serverless index.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opensearchserverless-index.html#cfn-opensearchserverless-index-settings">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opensearchserverless-index.html#cfn-opensearchserverless-index-settings</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getSettings() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnIndexProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnIndexProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnIndexProps> {
        java.lang.String collectionEndpoint;
        java.lang.String indexName;
        java.lang.Object mappings;
        java.lang.Object settings;

        /**
         * Sets the value of {@link CfnIndexProps#getCollectionEndpoint}
         * @param collectionEndpoint The endpoint for the collection. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder collectionEndpoint(java.lang.String collectionEndpoint) {
            this.collectionEndpoint = collectionEndpoint;
            return this;
        }

        /**
         * Sets the value of {@link CfnIndexProps#getIndexName}
         * @param indexName The name of the OpenSearch Serverless index. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder indexName(java.lang.String indexName) {
            this.indexName = indexName;
            return this;
        }

        /**
         * Sets the value of {@link CfnIndexProps#getMappings}
         * @param mappings Index mappings for the OpenSearch Serverless index.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder mappings(software.amazon.awscdk.IResolvable mappings) {
            this.mappings = mappings;
            return this;
        }

        /**
         * Sets the value of {@link CfnIndexProps#getMappings}
         * @param mappings Index mappings for the OpenSearch Serverless index.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder mappings(software.amazon.awscdk.services.opensearchserverless.CfnIndex.MappingsProperty mappings) {
            this.mappings = mappings;
            return this;
        }

        /**
         * Sets the value of {@link CfnIndexProps#getSettings}
         * @param settings Index settings for the OpenSearch Serverless index.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder settings(software.amazon.awscdk.IResolvable settings) {
            this.settings = settings;
            return this;
        }

        /**
         * Sets the value of {@link CfnIndexProps#getSettings}
         * @param settings Index settings for the OpenSearch Serverless index.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder settings(software.amazon.awscdk.services.opensearchserverless.CfnIndex.IndexSettingsProperty settings) {
            this.settings = settings;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnIndexProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnIndexProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnIndexProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnIndexProps {
        private final java.lang.String collectionEndpoint;
        private final java.lang.String indexName;
        private final java.lang.Object mappings;
        private final java.lang.Object settings;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.collectionEndpoint = software.amazon.jsii.Kernel.get(this, "collectionEndpoint", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.indexName = software.amazon.jsii.Kernel.get(this, "indexName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.mappings = software.amazon.jsii.Kernel.get(this, "mappings", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.settings = software.amazon.jsii.Kernel.get(this, "settings", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.collectionEndpoint = java.util.Objects.requireNonNull(builder.collectionEndpoint, "collectionEndpoint is required");
            this.indexName = java.util.Objects.requireNonNull(builder.indexName, "indexName is required");
            this.mappings = builder.mappings;
            this.settings = builder.settings;
        }

        @Override
        public final java.lang.String getCollectionEndpoint() {
            return this.collectionEndpoint;
        }

        @Override
        public final java.lang.String getIndexName() {
            return this.indexName;
        }

        @Override
        public final java.lang.Object getMappings() {
            return this.mappings;
        }

        @Override
        public final java.lang.Object getSettings() {
            return this.settings;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("collectionEndpoint", om.valueToTree(this.getCollectionEndpoint()));
            data.set("indexName", om.valueToTree(this.getIndexName()));
            if (this.getMappings() != null) {
                data.set("mappings", om.valueToTree(this.getMappings()));
            }
            if (this.getSettings() != null) {
                data.set("settings", om.valueToTree(this.getSettings()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_opensearchserverless.CfnIndexProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnIndexProps.Jsii$Proxy that = (CfnIndexProps.Jsii$Proxy) o;

            if (!collectionEndpoint.equals(that.collectionEndpoint)) return false;
            if (!indexName.equals(that.indexName)) return false;
            if (this.mappings != null ? !this.mappings.equals(that.mappings) : that.mappings != null) return false;
            return this.settings != null ? this.settings.equals(that.settings) : that.settings == null;
        }

        @Override
        public final int hashCode() {
            int result = this.collectionEndpoint.hashCode();
            result = 31 * result + (this.indexName.hashCode());
            result = 31 * result + (this.mappings != null ? this.mappings.hashCode() : 0);
            result = 31 * result + (this.settings != null ? this.settings.hashCode() : 0);
            return result;
        }
    }
}
