package software.amazon.awscdk.services.pinpoint;

/**
 * Properties for defining a <code>CfnEmailTemplate</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.pinpoint.*;
 * Object tags;
 * CfnEmailTemplateProps cfnEmailTemplateProps = CfnEmailTemplateProps.builder()
 *         .subject("subject")
 *         .templateName("templateName")
 *         // the properties below are optional
 *         .defaultSubstitutions("defaultSubstitutions")
 *         .htmlPart("htmlPart")
 *         .tags(tags)
 *         .templateDescription("templateDescription")
 *         .textPart("textPart")
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-emailtemplate.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-emailtemplate.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-05-20T23:53:00.129Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_pinpoint.CfnEmailTemplateProps")
@software.amazon.jsii.Jsii.Proxy(CfnEmailTemplateProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnEmailTemplateProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The subject line, or title, to use in email messages that are based on the message template.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-emailtemplate.html#cfn-pinpoint-emailtemplate-subject">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-emailtemplate.html#cfn-pinpoint-emailtemplate-subject</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getSubject();

    /**
     * The name of the message template.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-emailtemplate.html#cfn-pinpoint-emailtemplate-templatename">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-emailtemplate.html#cfn-pinpoint-emailtemplate-templatename</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getTemplateName();

    /**
     * A JSON object that specifies the default values to use for message variables in the message template.
     * <p>
     * This object is a set of key-value pairs. Each key defines a message variable in the template. The corresponding value defines the default value for that variable. When you create a message that's based on the template, you can override these defaults with message-specific and address-specific variables and values.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-emailtemplate.html#cfn-pinpoint-emailtemplate-defaultsubstitutions">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-emailtemplate.html#cfn-pinpoint-emailtemplate-defaultsubstitutions</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDefaultSubstitutions() {
        return null;
    }

    /**
     * The message body, in HTML format, to use in email messages that are based on the message template.
     * <p>
     * We recommend using HTML format for email clients that render HTML content. You can include links, formatted text, and more in an HTML message.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-emailtemplate.html#cfn-pinpoint-emailtemplate-htmlpart">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-emailtemplate.html#cfn-pinpoint-emailtemplate-htmlpart</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getHtmlPart() {
        return null;
    }

    /**
     * An array of key-value pairs to apply to this resource.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-resource-tags.html">Tag</a> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-emailtemplate.html#cfn-pinpoint-emailtemplate-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-emailtemplate.html#cfn-pinpoint-emailtemplate-tags</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getTags() {
        return null;
    }

    /**
     * A custom description of the message template.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-emailtemplate.html#cfn-pinpoint-emailtemplate-templatedescription">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-emailtemplate.html#cfn-pinpoint-emailtemplate-templatedescription</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getTemplateDescription() {
        return null;
    }

    /**
     * The message body, in plain text format, to use in email messages that are based on the message template.
     * <p>
     * We recommend using plain text format for email clients that don't render HTML content and clients that are connected to high-latency networks, such as mobile devices.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-emailtemplate.html#cfn-pinpoint-emailtemplate-textpart">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-emailtemplate.html#cfn-pinpoint-emailtemplate-textpart</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getTextPart() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnEmailTemplateProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnEmailTemplateProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnEmailTemplateProps> {
        java.lang.String subject;
        java.lang.String templateName;
        java.lang.String defaultSubstitutions;
        java.lang.String htmlPart;
        java.lang.Object tags;
        java.lang.String templateDescription;
        java.lang.String textPart;

        /**
         * Sets the value of {@link CfnEmailTemplateProps#getSubject}
         * @param subject The subject line, or title, to use in email messages that are based on the message template. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder subject(java.lang.String subject) {
            this.subject = subject;
            return this;
        }

        /**
         * Sets the value of {@link CfnEmailTemplateProps#getTemplateName}
         * @param templateName The name of the message template. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder templateName(java.lang.String templateName) {
            this.templateName = templateName;
            return this;
        }

        /**
         * Sets the value of {@link CfnEmailTemplateProps#getDefaultSubstitutions}
         * @param defaultSubstitutions A JSON object that specifies the default values to use for message variables in the message template.
         *                             This object is a set of key-value pairs. Each key defines a message variable in the template. The corresponding value defines the default value for that variable. When you create a message that's based on the template, you can override these defaults with message-specific and address-specific variables and values.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder defaultSubstitutions(java.lang.String defaultSubstitutions) {
            this.defaultSubstitutions = defaultSubstitutions;
            return this;
        }

        /**
         * Sets the value of {@link CfnEmailTemplateProps#getHtmlPart}
         * @param htmlPart The message body, in HTML format, to use in email messages that are based on the message template.
         *                 We recommend using HTML format for email clients that render HTML content. You can include links, formatted text, and more in an HTML message.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder htmlPart(java.lang.String htmlPart) {
            this.htmlPart = htmlPart;
            return this;
        }

        /**
         * Sets the value of {@link CfnEmailTemplateProps#getTags}
         * @param tags An array of key-value pairs to apply to this resource.
         *             For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-resource-tags.html">Tag</a> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(java.lang.Object tags) {
            this.tags = tags;
            return this;
        }

        /**
         * Sets the value of {@link CfnEmailTemplateProps#getTemplateDescription}
         * @param templateDescription A custom description of the message template.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder templateDescription(java.lang.String templateDescription) {
            this.templateDescription = templateDescription;
            return this;
        }

        /**
         * Sets the value of {@link CfnEmailTemplateProps#getTextPart}
         * @param textPart The message body, in plain text format, to use in email messages that are based on the message template.
         *                 We recommend using plain text format for email clients that don't render HTML content and clients that are connected to high-latency networks, such as mobile devices.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder textPart(java.lang.String textPart) {
            this.textPart = textPart;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnEmailTemplateProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnEmailTemplateProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnEmailTemplateProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnEmailTemplateProps {
        private final java.lang.String subject;
        private final java.lang.String templateName;
        private final java.lang.String defaultSubstitutions;
        private final java.lang.String htmlPart;
        private final java.lang.Object tags;
        private final java.lang.String templateDescription;
        private final java.lang.String textPart;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.subject = software.amazon.jsii.Kernel.get(this, "subject", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.templateName = software.amazon.jsii.Kernel.get(this, "templateName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.defaultSubstitutions = software.amazon.jsii.Kernel.get(this, "defaultSubstitutions", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.htmlPart = software.amazon.jsii.Kernel.get(this, "htmlPart", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.templateDescription = software.amazon.jsii.Kernel.get(this, "templateDescription", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.textPart = software.amazon.jsii.Kernel.get(this, "textPart", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.subject = java.util.Objects.requireNonNull(builder.subject, "subject is required");
            this.templateName = java.util.Objects.requireNonNull(builder.templateName, "templateName is required");
            this.defaultSubstitutions = builder.defaultSubstitutions;
            this.htmlPart = builder.htmlPart;
            this.tags = builder.tags;
            this.templateDescription = builder.templateDescription;
            this.textPart = builder.textPart;
        }

        @Override
        public final java.lang.String getSubject() {
            return this.subject;
        }

        @Override
        public final java.lang.String getTemplateName() {
            return this.templateName;
        }

        @Override
        public final java.lang.String getDefaultSubstitutions() {
            return this.defaultSubstitutions;
        }

        @Override
        public final java.lang.String getHtmlPart() {
            return this.htmlPart;
        }

        @Override
        public final java.lang.Object getTags() {
            return this.tags;
        }

        @Override
        public final java.lang.String getTemplateDescription() {
            return this.templateDescription;
        }

        @Override
        public final java.lang.String getTextPart() {
            return this.textPart;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("subject", om.valueToTree(this.getSubject()));
            data.set("templateName", om.valueToTree(this.getTemplateName()));
            if (this.getDefaultSubstitutions() != null) {
                data.set("defaultSubstitutions", om.valueToTree(this.getDefaultSubstitutions()));
            }
            if (this.getHtmlPart() != null) {
                data.set("htmlPart", om.valueToTree(this.getHtmlPart()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }
            if (this.getTemplateDescription() != null) {
                data.set("templateDescription", om.valueToTree(this.getTemplateDescription()));
            }
            if (this.getTextPart() != null) {
                data.set("textPart", om.valueToTree(this.getTextPart()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_pinpoint.CfnEmailTemplateProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnEmailTemplateProps.Jsii$Proxy that = (CfnEmailTemplateProps.Jsii$Proxy) o;

            if (!subject.equals(that.subject)) return false;
            if (!templateName.equals(that.templateName)) return false;
            if (this.defaultSubstitutions != null ? !this.defaultSubstitutions.equals(that.defaultSubstitutions) : that.defaultSubstitutions != null) return false;
            if (this.htmlPart != null ? !this.htmlPart.equals(that.htmlPart) : that.htmlPart != null) return false;
            if (this.tags != null ? !this.tags.equals(that.tags) : that.tags != null) return false;
            if (this.templateDescription != null ? !this.templateDescription.equals(that.templateDescription) : that.templateDescription != null) return false;
            return this.textPart != null ? this.textPart.equals(that.textPart) : that.textPart == null;
        }

        @Override
        public final int hashCode() {
            int result = this.subject.hashCode();
            result = 31 * result + (this.templateName.hashCode());
            result = 31 * result + (this.defaultSubstitutions != null ? this.defaultSubstitutions.hashCode() : 0);
            result = 31 * result + (this.htmlPart != null ? this.htmlPart.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            result = 31 * result + (this.templateDescription != null ? this.templateDescription.hashCode() : 0);
            result = 31 * result + (this.textPart != null ? this.textPart.hashCode() : 0);
            return result;
        }
    }
}
