package software.amazon.awscdk.services.qbusiness;

/**
 * Creates an Amazon Q Business application.
 * <p>
 * <blockquote>
 * <p>
 * There are new tiers for Amazon Q Business. Not all features in Amazon Q Business Pro are also available in Amazon Q Business Lite. For information on what's included in Amazon Q Business Lite and what's included in Amazon Q Business Pro, see <a href="https://docs.aws.amazon.com/amazonq/latest/qbusiness-ug/tiers.html#user-sub-tiers">Amazon Q Business tiers</a> . You must use the Amazon Q Business console to assign subscription tiers to users.
 * <p>
 * An Amazon Q Apps service linked role will be created if it's absent in the AWS account when <code>QAppsConfiguration</code> is enabled in the request. For more information, see <a href="https://docs.aws.amazon.com/amazonq/latest/qbusiness-ug/using-service-linked-roles-qapps.html">Using service-linked roles for Q Apps</a> .
 * <p>
 * When you create an application, Amazon Q Business may securely transmit data for processing from your selected AWS region, but within your geography. For more information, see <a href="https://docs.aws.amazon.com/amazonq/latest/qbusiness-ug/cross-region-inference.html">Cross region inference in Amazon Q Business</a> .
 * <p>
 * </blockquote>
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.qbusiness.*;
 * CfnApplication cfnApplication = CfnApplication.Builder.create(this, "MyCfnApplication")
 *         .displayName("displayName")
 *         // the properties below are optional
 *         .attachmentsConfiguration(AttachmentsConfigurationProperty.builder()
 *                 .attachmentsControlMode("attachmentsControlMode")
 *                 .build())
 *         .autoSubscriptionConfiguration(AutoSubscriptionConfigurationProperty.builder()
 *                 .autoSubscribe("autoSubscribe")
 *                 // the properties below are optional
 *                 .defaultSubscriptionType("defaultSubscriptionType")
 *                 .build())
 *         .clientIdsForOidc(List.of("clientIdsForOidc"))
 *         .description("description")
 *         .encryptionConfiguration(EncryptionConfigurationProperty.builder()
 *                 .kmsKeyId("kmsKeyId")
 *                 .build())
 *         .iamIdentityProviderArn("iamIdentityProviderArn")
 *         .identityCenterInstanceArn("identityCenterInstanceArn")
 *         .identityType("identityType")
 *         .personalizationConfiguration(PersonalizationConfigurationProperty.builder()
 *                 .personalizationControlMode("personalizationControlMode")
 *                 .build())
 *         .qAppsConfiguration(QAppsConfigurationProperty.builder()
 *                 .qAppsControlMode("qAppsControlMode")
 *                 .build())
 *         .quickSightConfiguration(QuickSightConfigurationProperty.builder()
 *                 .clientNamespace("clientNamespace")
 *                 .build())
 *         .roleArn("roleArn")
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-qbusiness-application.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-qbusiness-application.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-05-20T23:53:00.248Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_qbusiness.CfnApplication")
public class CfnApplication extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable, software.amazon.awscdk.ITaggableV2 {

    protected CfnApplication(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnApplication(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.qbusiness.CfnApplication.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * @param scope Scope in which this resource is defined. This parameter is required.
     * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
     * @param props Resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnApplication(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.qbusiness.CfnApplicationProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     * The Amazon Resource Name (ARN) of the Amazon Q Business application.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrApplicationArn() {
        return software.amazon.jsii.Kernel.get(this, "attrApplicationArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The identifier for the Amazon Q Business application.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrApplicationId() {
        return software.amazon.jsii.Kernel.get(this, "attrApplicationId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The Unix timestamp when the Amazon Q Business application was created.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrCreatedAt() {
        return software.amazon.jsii.Kernel.get(this, "attrCreatedAt", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The Amazon Resource Name (ARN) of the AWS IAM Identity Center instance attached to your Amazon Q Business application.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrIdentityCenterApplicationArn() {
        return software.amazon.jsii.Kernel.get(this, "attrIdentityCenterApplicationArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The status of the Amazon Q Business application.
     * <p>
     * The application is ready to use when the status is <code>ACTIVE</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrStatus() {
        return software.amazon.jsii.Kernel.get(this, "attrStatus", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The Unix timestamp when the Amazon Q Business application was last updated.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrUpdatedAt() {
        return software.amazon.jsii.Kernel.get(this, "attrUpdatedAt", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Tag Manager which manages the tags for this resource.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.TagManager getCdkTagManager() {
        return software.amazon.jsii.Kernel.get(this, "cdkTagManager", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TagManager.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * The name of the Amazon Q Business application.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getDisplayName() {
        return software.amazon.jsii.Kernel.get(this, "displayName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name of the Amazon Q Business application.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDisplayName(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "displayName", java.util.Objects.requireNonNull(value, "displayName is required"));
    }

    /**
     * Configuration information for the file upload during chat feature.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getAttachmentsConfiguration() {
        return software.amazon.jsii.Kernel.get(this, "attachmentsConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Configuration information for the file upload during chat feature.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAttachmentsConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "attachmentsConfiguration", value);
    }

    /**
     * Configuration information for the file upload during chat feature.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAttachmentsConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.qbusiness.CfnApplication.AttachmentsConfigurationProperty value) {
        software.amazon.jsii.Kernel.set(this, "attachmentsConfiguration", value);
    }

    /**
     * Subscription configuration information for an Amazon Q Business application using IAM identity federation for user management.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getAutoSubscriptionConfiguration() {
        return software.amazon.jsii.Kernel.get(this, "autoSubscriptionConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Subscription configuration information for an Amazon Q Business application using IAM identity federation for user management.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAutoSubscriptionConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "autoSubscriptionConfiguration", value);
    }

    /**
     * Subscription configuration information for an Amazon Q Business application using IAM identity federation for user management.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAutoSubscriptionConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.qbusiness.CfnApplication.AutoSubscriptionConfigurationProperty value) {
        software.amazon.jsii.Kernel.set(this, "autoSubscriptionConfiguration", value);
    }

    /**
     * The OIDC client ID for a Amazon Q Business application.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getClientIdsForOidc() {
        return java.util.Optional.ofNullable((java.util.List<java.lang.String>)(software.amazon.jsii.Kernel.get(this, "clientIdsForOidc", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     * The OIDC client ID for a Amazon Q Business application.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setClientIdsForOidc(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> value) {
        software.amazon.jsii.Kernel.set(this, "clientIdsForOidc", value);
    }

    /**
     * A description for the Amazon Q Business application.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
        return software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * A description for the Amazon Q Business application.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDescription(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "description", value);
    }

    /**
     * Provides the identifier of the AWS KMS key used to encrypt data indexed by Amazon Q Business.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getEncryptionConfiguration() {
        return software.amazon.jsii.Kernel.get(this, "encryptionConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Provides the identifier of the AWS KMS key used to encrypt data indexed by Amazon Q Business.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setEncryptionConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "encryptionConfiguration", value);
    }

    /**
     * Provides the identifier of the AWS KMS key used to encrypt data indexed by Amazon Q Business.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setEncryptionConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.qbusiness.CfnApplication.EncryptionConfigurationProperty value) {
        software.amazon.jsii.Kernel.set(this, "encryptionConfiguration", value);
    }

    /**
     * The Amazon Resource Name (ARN) of an identity provider being used by an Amazon Q Business application.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getIamIdentityProviderArn() {
        return software.amazon.jsii.Kernel.get(this, "iamIdentityProviderArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The Amazon Resource Name (ARN) of an identity provider being used by an Amazon Q Business application.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setIamIdentityProviderArn(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "iamIdentityProviderArn", value);
    }

    /**
     * The Amazon Resource Name (ARN) of the IAM Identity Center instance you are either creating for—or connecting to—your Amazon Q Business application.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getIdentityCenterInstanceArn() {
        return software.amazon.jsii.Kernel.get(this, "identityCenterInstanceArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The Amazon Resource Name (ARN) of the IAM Identity Center instance you are either creating for—or connecting to—your Amazon Q Business application.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setIdentityCenterInstanceArn(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "identityCenterInstanceArn", value);
    }

    /**
     * The authentication type being used by a Amazon Q Business application.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getIdentityType() {
        return software.amazon.jsii.Kernel.get(this, "identityType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The authentication type being used by a Amazon Q Business application.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setIdentityType(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "identityType", value);
    }

    /**
     * Configuration information about chat response personalization.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getPersonalizationConfiguration() {
        return software.amazon.jsii.Kernel.get(this, "personalizationConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Configuration information about chat response personalization.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setPersonalizationConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "personalizationConfiguration", value);
    }

    /**
     * Configuration information about chat response personalization.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setPersonalizationConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.qbusiness.CfnApplication.PersonalizationConfigurationProperty value) {
        software.amazon.jsii.Kernel.set(this, "personalizationConfiguration", value);
    }

    /**
     * Configuration information about Amazon Q Apps.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getQAppsConfiguration() {
        return software.amazon.jsii.Kernel.get(this, "qAppsConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Configuration information about Amazon Q Apps.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setQAppsConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "qAppsConfiguration", value);
    }

    /**
     * Configuration information about Amazon Q Apps.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setQAppsConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.qbusiness.CfnApplication.QAppsConfigurationProperty value) {
        software.amazon.jsii.Kernel.set(this, "qAppsConfiguration", value);
    }

    /**
     * The Amazon QuickSight configuration for an Amazon Q Business application that uses QuickSight as the identity provider.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getQuickSightConfiguration() {
        return software.amazon.jsii.Kernel.get(this, "quickSightConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The Amazon QuickSight configuration for an Amazon Q Business application that uses QuickSight as the identity provider.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setQuickSightConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "quickSightConfiguration", value);
    }

    /**
     * The Amazon QuickSight configuration for an Amazon Q Business application that uses QuickSight as the identity provider.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setQuickSightConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.qbusiness.CfnApplication.QuickSightConfigurationProperty value) {
        software.amazon.jsii.Kernel.set(this, "quickSightConfiguration", value);
    }

    /**
     * The Amazon Resource Name (ARN) of an IAM role with permissions to access your Amazon CloudWatch logs and metrics.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getRoleArn() {
        return software.amazon.jsii.Kernel.get(this, "roleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The Amazon Resource Name (ARN) of an IAM role with permissions to access your Amazon CloudWatch logs and metrics.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setRoleArn(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "roleArn", value);
    }

    /**
     * A list of key-value pairs that identify or categorize your Amazon Q Business application.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTags() {
        return java.util.Optional.ofNullable((java.util.List<software.amazon.awscdk.CfnTag>)(software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     * A list of key-value pairs that identify or categorize your Amazon Q Business application.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTags(final @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> value) {
        software.amazon.jsii.Kernel.set(this, "tags", value);
    }
    /**
     * Configuration information for the file upload during chat feature.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.qbusiness.*;
     * AttachmentsConfigurationProperty attachmentsConfigurationProperty = AttachmentsConfigurationProperty.builder()
     *         .attachmentsControlMode("attachmentsControlMode")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-qbusiness-application-attachmentsconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-qbusiness-application-attachmentsconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_qbusiness.CfnApplication.AttachmentsConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(AttachmentsConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface AttachmentsConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Status information about whether file upload functionality is activated or deactivated for your end user.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-qbusiness-application-attachmentsconfiguration.html#cfn-qbusiness-application-attachmentsconfiguration-attachmentscontrolmode">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-qbusiness-application-attachmentsconfiguration.html#cfn-qbusiness-application-attachmentsconfiguration-attachmentscontrolmode</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getAttachmentsControlMode();

        /**
         * @return a {@link Builder} of {@link AttachmentsConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link AttachmentsConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<AttachmentsConfigurationProperty> {
            java.lang.String attachmentsControlMode;

            /**
             * Sets the value of {@link AttachmentsConfigurationProperty#getAttachmentsControlMode}
             * @param attachmentsControlMode Status information about whether file upload functionality is activated or deactivated for your end user. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder attachmentsControlMode(java.lang.String attachmentsControlMode) {
                this.attachmentsControlMode = attachmentsControlMode;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link AttachmentsConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public AttachmentsConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link AttachmentsConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AttachmentsConfigurationProperty {
            private final java.lang.String attachmentsControlMode;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.attachmentsControlMode = software.amazon.jsii.Kernel.get(this, "attachmentsControlMode", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.attachmentsControlMode = java.util.Objects.requireNonNull(builder.attachmentsControlMode, "attachmentsControlMode is required");
            }

            @Override
            public final java.lang.String getAttachmentsControlMode() {
                return this.attachmentsControlMode;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("attachmentsControlMode", om.valueToTree(this.getAttachmentsControlMode()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_qbusiness.CfnApplication.AttachmentsConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                AttachmentsConfigurationProperty.Jsii$Proxy that = (AttachmentsConfigurationProperty.Jsii$Proxy) o;

                return this.attachmentsControlMode.equals(that.attachmentsControlMode);
            }

            @Override
            public final int hashCode() {
                int result = this.attachmentsControlMode.hashCode();
                return result;
            }
        }
    }
    /**
     * Subscription configuration information for an Amazon Q Business application using IAM identity federation for user management.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.qbusiness.*;
     * AutoSubscriptionConfigurationProperty autoSubscriptionConfigurationProperty = AutoSubscriptionConfigurationProperty.builder()
     *         .autoSubscribe("autoSubscribe")
     *         // the properties below are optional
     *         .defaultSubscriptionType("defaultSubscriptionType")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-qbusiness-application-autosubscriptionconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-qbusiness-application-autosubscriptionconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_qbusiness.CfnApplication.AutoSubscriptionConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(AutoSubscriptionConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface AutoSubscriptionConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Describes whether automatic subscriptions are enabled for an Amazon Q Business application using IAM identity federation for user management.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-qbusiness-application-autosubscriptionconfiguration.html#cfn-qbusiness-application-autosubscriptionconfiguration-autosubscribe">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-qbusiness-application-autosubscriptionconfiguration.html#cfn-qbusiness-application-autosubscriptionconfiguration-autosubscribe</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getAutoSubscribe();

        /**
         * Describes the default subscription type assigned to an Amazon Q Business application using IAM identity federation for user management.
         * <p>
         * If the value for <code>autoSubscribe</code> is set to <code>ENABLED</code> you must select a value for this field.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-qbusiness-application-autosubscriptionconfiguration.html#cfn-qbusiness-application-autosubscriptionconfiguration-defaultsubscriptiontype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-qbusiness-application-autosubscriptionconfiguration.html#cfn-qbusiness-application-autosubscriptionconfiguration-defaultsubscriptiontype</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getDefaultSubscriptionType() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link AutoSubscriptionConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link AutoSubscriptionConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<AutoSubscriptionConfigurationProperty> {
            java.lang.String autoSubscribe;
            java.lang.String defaultSubscriptionType;

            /**
             * Sets the value of {@link AutoSubscriptionConfigurationProperty#getAutoSubscribe}
             * @param autoSubscribe Describes whether automatic subscriptions are enabled for an Amazon Q Business application using IAM identity federation for user management. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder autoSubscribe(java.lang.String autoSubscribe) {
                this.autoSubscribe = autoSubscribe;
                return this;
            }

            /**
             * Sets the value of {@link AutoSubscriptionConfigurationProperty#getDefaultSubscriptionType}
             * @param defaultSubscriptionType Describes the default subscription type assigned to an Amazon Q Business application using IAM identity federation for user management.
             *                                If the value for <code>autoSubscribe</code> is set to <code>ENABLED</code> you must select a value for this field.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder defaultSubscriptionType(java.lang.String defaultSubscriptionType) {
                this.defaultSubscriptionType = defaultSubscriptionType;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link AutoSubscriptionConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public AutoSubscriptionConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link AutoSubscriptionConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AutoSubscriptionConfigurationProperty {
            private final java.lang.String autoSubscribe;
            private final java.lang.String defaultSubscriptionType;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.autoSubscribe = software.amazon.jsii.Kernel.get(this, "autoSubscribe", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.defaultSubscriptionType = software.amazon.jsii.Kernel.get(this, "defaultSubscriptionType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.autoSubscribe = java.util.Objects.requireNonNull(builder.autoSubscribe, "autoSubscribe is required");
                this.defaultSubscriptionType = builder.defaultSubscriptionType;
            }

            @Override
            public final java.lang.String getAutoSubscribe() {
                return this.autoSubscribe;
            }

            @Override
            public final java.lang.String getDefaultSubscriptionType() {
                return this.defaultSubscriptionType;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("autoSubscribe", om.valueToTree(this.getAutoSubscribe()));
                if (this.getDefaultSubscriptionType() != null) {
                    data.set("defaultSubscriptionType", om.valueToTree(this.getDefaultSubscriptionType()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_qbusiness.CfnApplication.AutoSubscriptionConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                AutoSubscriptionConfigurationProperty.Jsii$Proxy that = (AutoSubscriptionConfigurationProperty.Jsii$Proxy) o;

                if (!autoSubscribe.equals(that.autoSubscribe)) return false;
                return this.defaultSubscriptionType != null ? this.defaultSubscriptionType.equals(that.defaultSubscriptionType) : that.defaultSubscriptionType == null;
            }

            @Override
            public final int hashCode() {
                int result = this.autoSubscribe.hashCode();
                result = 31 * result + (this.defaultSubscriptionType != null ? this.defaultSubscriptionType.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Provides the identifier of the AWS KMS key used to encrypt data indexed by Amazon Q Business.
     * <p>
     * Amazon Q Business doesn't support asymmetric keys.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.qbusiness.*;
     * EncryptionConfigurationProperty encryptionConfigurationProperty = EncryptionConfigurationProperty.builder()
     *         .kmsKeyId("kmsKeyId")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-qbusiness-application-encryptionconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-qbusiness-application-encryptionconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_qbusiness.CfnApplication.EncryptionConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(EncryptionConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface EncryptionConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The identifier of the AWS KMS key.
         * <p>
         * Amazon Q Business doesn't support asymmetric keys.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-qbusiness-application-encryptionconfiguration.html#cfn-qbusiness-application-encryptionconfiguration-kmskeyid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-qbusiness-application-encryptionconfiguration.html#cfn-qbusiness-application-encryptionconfiguration-kmskeyid</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getKmsKeyId() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link EncryptionConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link EncryptionConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<EncryptionConfigurationProperty> {
            java.lang.String kmsKeyId;

            /**
             * Sets the value of {@link EncryptionConfigurationProperty#getKmsKeyId}
             * @param kmsKeyId The identifier of the AWS KMS key.
             *                 Amazon Q Business doesn't support asymmetric keys.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder kmsKeyId(java.lang.String kmsKeyId) {
                this.kmsKeyId = kmsKeyId;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link EncryptionConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public EncryptionConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link EncryptionConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements EncryptionConfigurationProperty {
            private final java.lang.String kmsKeyId;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.kmsKeyId = software.amazon.jsii.Kernel.get(this, "kmsKeyId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.kmsKeyId = builder.kmsKeyId;
            }

            @Override
            public final java.lang.String getKmsKeyId() {
                return this.kmsKeyId;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getKmsKeyId() != null) {
                    data.set("kmsKeyId", om.valueToTree(this.getKmsKeyId()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_qbusiness.CfnApplication.EncryptionConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                EncryptionConfigurationProperty.Jsii$Proxy that = (EncryptionConfigurationProperty.Jsii$Proxy) o;

                return this.kmsKeyId != null ? this.kmsKeyId.equals(that.kmsKeyId) : that.kmsKeyId == null;
            }

            @Override
            public final int hashCode() {
                int result = this.kmsKeyId != null ? this.kmsKeyId.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * Configuration information about chat response personalization.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/amazonq/latest/qbusiness-ug/personalizing-chat-responses.html">Personalizing chat responses</a> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.qbusiness.*;
     * PersonalizationConfigurationProperty personalizationConfigurationProperty = PersonalizationConfigurationProperty.builder()
     *         .personalizationControlMode("personalizationControlMode")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-qbusiness-application-personalizationconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-qbusiness-application-personalizationconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_qbusiness.CfnApplication.PersonalizationConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(PersonalizationConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface PersonalizationConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * An option to allow Amazon Q Business to customize chat responses using user specific metadata—specifically, location and job information—in your IAM Identity Center instance.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-qbusiness-application-personalizationconfiguration.html#cfn-qbusiness-application-personalizationconfiguration-personalizationcontrolmode">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-qbusiness-application-personalizationconfiguration.html#cfn-qbusiness-application-personalizationconfiguration-personalizationcontrolmode</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getPersonalizationControlMode();

        /**
         * @return a {@link Builder} of {@link PersonalizationConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link PersonalizationConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<PersonalizationConfigurationProperty> {
            java.lang.String personalizationControlMode;

            /**
             * Sets the value of {@link PersonalizationConfigurationProperty#getPersonalizationControlMode}
             * @param personalizationControlMode An option to allow Amazon Q Business to customize chat responses using user specific metadata—specifically, location and job information—in your IAM Identity Center instance. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder personalizationControlMode(java.lang.String personalizationControlMode) {
                this.personalizationControlMode = personalizationControlMode;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link PersonalizationConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public PersonalizationConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link PersonalizationConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements PersonalizationConfigurationProperty {
            private final java.lang.String personalizationControlMode;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.personalizationControlMode = software.amazon.jsii.Kernel.get(this, "personalizationControlMode", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.personalizationControlMode = java.util.Objects.requireNonNull(builder.personalizationControlMode, "personalizationControlMode is required");
            }

            @Override
            public final java.lang.String getPersonalizationControlMode() {
                return this.personalizationControlMode;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("personalizationControlMode", om.valueToTree(this.getPersonalizationControlMode()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_qbusiness.CfnApplication.PersonalizationConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                PersonalizationConfigurationProperty.Jsii$Proxy that = (PersonalizationConfigurationProperty.Jsii$Proxy) o;

                return this.personalizationControlMode.equals(that.personalizationControlMode);
            }

            @Override
            public final int hashCode() {
                int result = this.personalizationControlMode.hashCode();
                return result;
            }
        }
    }
    /**
     * Configuration information about Amazon Q Apps.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.qbusiness.*;
     * QAppsConfigurationProperty qAppsConfigurationProperty = QAppsConfigurationProperty.builder()
     *         .qAppsControlMode("qAppsControlMode")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-qbusiness-application-qappsconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-qbusiness-application-qappsconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_qbusiness.CfnApplication.QAppsConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(QAppsConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface QAppsConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Status information about whether end users can create and use Amazon Q Apps in the web experience.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-qbusiness-application-qappsconfiguration.html#cfn-qbusiness-application-qappsconfiguration-qappscontrolmode">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-qbusiness-application-qappsconfiguration.html#cfn-qbusiness-application-qappsconfiguration-qappscontrolmode</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getQAppsControlMode();

        /**
         * @return a {@link Builder} of {@link QAppsConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link QAppsConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<QAppsConfigurationProperty> {
            java.lang.String qAppsControlMode;

            /**
             * Sets the value of {@link QAppsConfigurationProperty#getQAppsControlMode}
             * @param qAppsControlMode Status information about whether end users can create and use Amazon Q Apps in the web experience. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder qAppsControlMode(java.lang.String qAppsControlMode) {
                this.qAppsControlMode = qAppsControlMode;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link QAppsConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public QAppsConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link QAppsConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements QAppsConfigurationProperty {
            private final java.lang.String qAppsControlMode;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.qAppsControlMode = software.amazon.jsii.Kernel.get(this, "qAppsControlMode", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.qAppsControlMode = java.util.Objects.requireNonNull(builder.qAppsControlMode, "qAppsControlMode is required");
            }

            @Override
            public final java.lang.String getQAppsControlMode() {
                return this.qAppsControlMode;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("qAppsControlMode", om.valueToTree(this.getQAppsControlMode()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_qbusiness.CfnApplication.QAppsConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                QAppsConfigurationProperty.Jsii$Proxy that = (QAppsConfigurationProperty.Jsii$Proxy) o;

                return this.qAppsControlMode.equals(that.qAppsControlMode);
            }

            @Override
            public final int hashCode() {
                int result = this.qAppsControlMode.hashCode();
                return result;
            }
        }
    }
    /**
     * The Amazon QuickSight configuration for an Amazon Q Business application that uses QuickSight as the identity provider.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/amazonq/latest/qbusiness-ug/create-quicksight-integrated-application.html">Creating an Amazon QuickSight integrated application</a> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.qbusiness.*;
     * QuickSightConfigurationProperty quickSightConfigurationProperty = QuickSightConfigurationProperty.builder()
     *         .clientNamespace("clientNamespace")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-qbusiness-application-quicksightconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-qbusiness-application-quicksightconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_qbusiness.CfnApplication.QuickSightConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(QuickSightConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface QuickSightConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The Amazon QuickSight namespace that is used as the identity provider.
         * <p>
         * For more information about QuickSight namespaces, see <a href="https://docs.aws.amazon.com/quicksight/latest/developerguide/namespace-operations.html">Namespace operations</a> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-qbusiness-application-quicksightconfiguration.html#cfn-qbusiness-application-quicksightconfiguration-clientnamespace">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-qbusiness-application-quicksightconfiguration.html#cfn-qbusiness-application-quicksightconfiguration-clientnamespace</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getClientNamespace();

        /**
         * @return a {@link Builder} of {@link QuickSightConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link QuickSightConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<QuickSightConfigurationProperty> {
            java.lang.String clientNamespace;

            /**
             * Sets the value of {@link QuickSightConfigurationProperty#getClientNamespace}
             * @param clientNamespace The Amazon QuickSight namespace that is used as the identity provider. This parameter is required.
             *                        For more information about QuickSight namespaces, see <a href="https://docs.aws.amazon.com/quicksight/latest/developerguide/namespace-operations.html">Namespace operations</a> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder clientNamespace(java.lang.String clientNamespace) {
                this.clientNamespace = clientNamespace;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link QuickSightConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public QuickSightConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link QuickSightConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements QuickSightConfigurationProperty {
            private final java.lang.String clientNamespace;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.clientNamespace = software.amazon.jsii.Kernel.get(this, "clientNamespace", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.clientNamespace = java.util.Objects.requireNonNull(builder.clientNamespace, "clientNamespace is required");
            }

            @Override
            public final java.lang.String getClientNamespace() {
                return this.clientNamespace;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("clientNamespace", om.valueToTree(this.getClientNamespace()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_qbusiness.CfnApplication.QuickSightConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                QuickSightConfigurationProperty.Jsii$Proxy that = (QuickSightConfigurationProperty.Jsii$Proxy) o;

                return this.clientNamespace.equals(that.clientNamespace);
            }

            @Override
            public final int hashCode() {
                int result = this.clientNamespace.hashCode();
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.qbusiness.CfnApplication}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.qbusiness.CfnApplication> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope Scope in which this resource is defined. This parameter is required.
         * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.qbusiness.CfnApplicationProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.qbusiness.CfnApplicationProps.Builder();
        }

        /**
         * The name of the Amazon Q Business application.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-qbusiness-application.html#cfn-qbusiness-application-displayname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-qbusiness-application.html#cfn-qbusiness-application-displayname</a>
         * @param displayName The name of the Amazon Q Business application. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder displayName(final java.lang.String displayName) {
            this.props.displayName(displayName);
            return this;
        }

        /**
         * Configuration information for the file upload during chat feature.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-qbusiness-application.html#cfn-qbusiness-application-attachmentsconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-qbusiness-application.html#cfn-qbusiness-application-attachmentsconfiguration</a>
         * @param attachmentsConfiguration Configuration information for the file upload during chat feature. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder attachmentsConfiguration(final software.amazon.awscdk.IResolvable attachmentsConfiguration) {
            this.props.attachmentsConfiguration(attachmentsConfiguration);
            return this;
        }
        /**
         * Configuration information for the file upload during chat feature.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-qbusiness-application.html#cfn-qbusiness-application-attachmentsconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-qbusiness-application.html#cfn-qbusiness-application-attachmentsconfiguration</a>
         * @param attachmentsConfiguration Configuration information for the file upload during chat feature. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder attachmentsConfiguration(final software.amazon.awscdk.services.qbusiness.CfnApplication.AttachmentsConfigurationProperty attachmentsConfiguration) {
            this.props.attachmentsConfiguration(attachmentsConfiguration);
            return this;
        }

        /**
         * Subscription configuration information for an Amazon Q Business application using IAM identity federation for user management.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-qbusiness-application.html#cfn-qbusiness-application-autosubscriptionconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-qbusiness-application.html#cfn-qbusiness-application-autosubscriptionconfiguration</a>
         * @param autoSubscriptionConfiguration Subscription configuration information for an Amazon Q Business application using IAM identity federation for user management. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder autoSubscriptionConfiguration(final software.amazon.awscdk.IResolvable autoSubscriptionConfiguration) {
            this.props.autoSubscriptionConfiguration(autoSubscriptionConfiguration);
            return this;
        }
        /**
         * Subscription configuration information for an Amazon Q Business application using IAM identity federation for user management.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-qbusiness-application.html#cfn-qbusiness-application-autosubscriptionconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-qbusiness-application.html#cfn-qbusiness-application-autosubscriptionconfiguration</a>
         * @param autoSubscriptionConfiguration Subscription configuration information for an Amazon Q Business application using IAM identity federation for user management. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder autoSubscriptionConfiguration(final software.amazon.awscdk.services.qbusiness.CfnApplication.AutoSubscriptionConfigurationProperty autoSubscriptionConfiguration) {
            this.props.autoSubscriptionConfiguration(autoSubscriptionConfiguration);
            return this;
        }

        /**
         * The OIDC client ID for a Amazon Q Business application.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-qbusiness-application.html#cfn-qbusiness-application-clientidsforoidc">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-qbusiness-application.html#cfn-qbusiness-application-clientidsforoidc</a>
         * @param clientIdsForOidc The OIDC client ID for a Amazon Q Business application. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder clientIdsForOidc(final java.util.List<java.lang.String> clientIdsForOidc) {
            this.props.clientIdsForOidc(clientIdsForOidc);
            return this;
        }

        /**
         * A description for the Amazon Q Business application.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-qbusiness-application.html#cfn-qbusiness-application-description">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-qbusiness-application.html#cfn-qbusiness-application-description</a>
         * @param description A description for the Amazon Q Business application. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(final java.lang.String description) {
            this.props.description(description);
            return this;
        }

        /**
         * Provides the identifier of the AWS KMS key used to encrypt data indexed by Amazon Q Business.
         * <p>
         * Amazon Q Business doesn't support asymmetric keys.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-qbusiness-application.html#cfn-qbusiness-application-encryptionconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-qbusiness-application.html#cfn-qbusiness-application-encryptionconfiguration</a>
         * @param encryptionConfiguration Provides the identifier of the AWS KMS key used to encrypt data indexed by Amazon Q Business. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder encryptionConfiguration(final software.amazon.awscdk.IResolvable encryptionConfiguration) {
            this.props.encryptionConfiguration(encryptionConfiguration);
            return this;
        }
        /**
         * Provides the identifier of the AWS KMS key used to encrypt data indexed by Amazon Q Business.
         * <p>
         * Amazon Q Business doesn't support asymmetric keys.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-qbusiness-application.html#cfn-qbusiness-application-encryptionconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-qbusiness-application.html#cfn-qbusiness-application-encryptionconfiguration</a>
         * @param encryptionConfiguration Provides the identifier of the AWS KMS key used to encrypt data indexed by Amazon Q Business. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder encryptionConfiguration(final software.amazon.awscdk.services.qbusiness.CfnApplication.EncryptionConfigurationProperty encryptionConfiguration) {
            this.props.encryptionConfiguration(encryptionConfiguration);
            return this;
        }

        /**
         * The Amazon Resource Name (ARN) of an identity provider being used by an Amazon Q Business application.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-qbusiness-application.html#cfn-qbusiness-application-iamidentityproviderarn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-qbusiness-application.html#cfn-qbusiness-application-iamidentityproviderarn</a>
         * @param iamIdentityProviderArn The Amazon Resource Name (ARN) of an identity provider being used by an Amazon Q Business application. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder iamIdentityProviderArn(final java.lang.String iamIdentityProviderArn) {
            this.props.iamIdentityProviderArn(iamIdentityProviderArn);
            return this;
        }

        /**
         * The Amazon Resource Name (ARN) of the IAM Identity Center instance you are either creating for—or connecting to—your Amazon Q Business application.
         * <p>
         * <em>Required</em> : <code>Yes</code>
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-qbusiness-application.html#cfn-qbusiness-application-identitycenterinstancearn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-qbusiness-application.html#cfn-qbusiness-application-identitycenterinstancearn</a>
         * @param identityCenterInstanceArn The Amazon Resource Name (ARN) of the IAM Identity Center instance you are either creating for—or connecting to—your Amazon Q Business application. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder identityCenterInstanceArn(final java.lang.String identityCenterInstanceArn) {
            this.props.identityCenterInstanceArn(identityCenterInstanceArn);
            return this;
        }

        /**
         * The authentication type being used by a Amazon Q Business application.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-qbusiness-application.html#cfn-qbusiness-application-identitytype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-qbusiness-application.html#cfn-qbusiness-application-identitytype</a>
         * @param identityType The authentication type being used by a Amazon Q Business application. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder identityType(final java.lang.String identityType) {
            this.props.identityType(identityType);
            return this;
        }

        /**
         * Configuration information about chat response personalization.
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/amazonq/latest/qbusiness-ug/personalizing-chat-responses.html">Personalizing chat responses</a> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-qbusiness-application.html#cfn-qbusiness-application-personalizationconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-qbusiness-application.html#cfn-qbusiness-application-personalizationconfiguration</a>
         * @param personalizationConfiguration Configuration information about chat response personalization. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder personalizationConfiguration(final software.amazon.awscdk.IResolvable personalizationConfiguration) {
            this.props.personalizationConfiguration(personalizationConfiguration);
            return this;
        }
        /**
         * Configuration information about chat response personalization.
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/amazonq/latest/qbusiness-ug/personalizing-chat-responses.html">Personalizing chat responses</a> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-qbusiness-application.html#cfn-qbusiness-application-personalizationconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-qbusiness-application.html#cfn-qbusiness-application-personalizationconfiguration</a>
         * @param personalizationConfiguration Configuration information about chat response personalization. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder personalizationConfiguration(final software.amazon.awscdk.services.qbusiness.CfnApplication.PersonalizationConfigurationProperty personalizationConfiguration) {
            this.props.personalizationConfiguration(personalizationConfiguration);
            return this;
        }

        /**
         * Configuration information about Amazon Q Apps.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-qbusiness-application.html#cfn-qbusiness-application-qappsconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-qbusiness-application.html#cfn-qbusiness-application-qappsconfiguration</a>
         * @param qAppsConfiguration Configuration information about Amazon Q Apps. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder qAppsConfiguration(final software.amazon.awscdk.IResolvable qAppsConfiguration) {
            this.props.qAppsConfiguration(qAppsConfiguration);
            return this;
        }
        /**
         * Configuration information about Amazon Q Apps.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-qbusiness-application.html#cfn-qbusiness-application-qappsconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-qbusiness-application.html#cfn-qbusiness-application-qappsconfiguration</a>
         * @param qAppsConfiguration Configuration information about Amazon Q Apps. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder qAppsConfiguration(final software.amazon.awscdk.services.qbusiness.CfnApplication.QAppsConfigurationProperty qAppsConfiguration) {
            this.props.qAppsConfiguration(qAppsConfiguration);
            return this;
        }

        /**
         * The Amazon QuickSight configuration for an Amazon Q Business application that uses QuickSight as the identity provider.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-qbusiness-application.html#cfn-qbusiness-application-quicksightconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-qbusiness-application.html#cfn-qbusiness-application-quicksightconfiguration</a>
         * @param quickSightConfiguration The Amazon QuickSight configuration for an Amazon Q Business application that uses QuickSight as the identity provider. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder quickSightConfiguration(final software.amazon.awscdk.IResolvable quickSightConfiguration) {
            this.props.quickSightConfiguration(quickSightConfiguration);
            return this;
        }
        /**
         * The Amazon QuickSight configuration for an Amazon Q Business application that uses QuickSight as the identity provider.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-qbusiness-application.html#cfn-qbusiness-application-quicksightconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-qbusiness-application.html#cfn-qbusiness-application-quicksightconfiguration</a>
         * @param quickSightConfiguration The Amazon QuickSight configuration for an Amazon Q Business application that uses QuickSight as the identity provider. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder quickSightConfiguration(final software.amazon.awscdk.services.qbusiness.CfnApplication.QuickSightConfigurationProperty quickSightConfiguration) {
            this.props.quickSightConfiguration(quickSightConfiguration);
            return this;
        }

        /**
         * The Amazon Resource Name (ARN) of an IAM role with permissions to access your Amazon CloudWatch logs and metrics.
         * <p>
         * If this property is not specified, Amazon Q Business will create a <a href="https://docs.aws.amazon.com/amazonq/latest/qbusiness-ug/using-service-linked-roles.html#slr-permissions">service linked role (SLR)</a> and use it as the application's role.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-qbusiness-application.html#cfn-qbusiness-application-rolearn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-qbusiness-application.html#cfn-qbusiness-application-rolearn</a>
         * @param roleArn The Amazon Resource Name (ARN) of an IAM role with permissions to access your Amazon CloudWatch logs and metrics. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder roleArn(final java.lang.String roleArn) {
            this.props.roleArn(roleArn);
            return this;
        }

        /**
         * A list of key-value pairs that identify or categorize your Amazon Q Business application.
         * <p>
         * You can also use tags to help control access to the application. Tag keys and values can consist of Unicode letters, digits, white space, and any of the following symbols: _ . : / = + -
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-qbusiness-application.html#cfn-qbusiness-application-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-qbusiness-application.html#cfn-qbusiness-application-tags</a>
         * @param tags A list of key-value pairs that identify or categorize your Amazon Q Business application. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(final java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.props.tags(tags);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.qbusiness.CfnApplication}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.qbusiness.CfnApplication build() {
            return new software.amazon.awscdk.services.qbusiness.CfnApplication(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
