package software.amazon.awscdk.services.rds;

/**
 * Properties for defining a <code>CfnDBParameterGroup</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.rds.*;
 * Object parameters;
 * CfnDBParameterGroupProps cfnDBParameterGroupProps = CfnDBParameterGroupProps.builder()
 *         .description("description")
 *         .family("family")
 *         // the properties below are optional
 *         .dbParameterGroupName("dbParameterGroupName")
 *         .parameters(parameters)
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbparametergroup.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbparametergroup.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-05-20T23:53:02.178Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_rds.CfnDBParameterGroupProps")
@software.amazon.jsii.Jsii.Proxy(CfnDBParameterGroupProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnDBParameterGroupProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * Provides the customer-specified description for this DB parameter group.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbparametergroup.html#cfn-rds-dbparametergroup-description">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbparametergroup.html#cfn-rds-dbparametergroup-description</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getDescription();

    /**
     * The DB parameter group family name.
     * <p>
     * A DB parameter group can be associated with one and only one DB parameter group family, and can be applied only to a DB instance running a database engine and engine version compatible with that DB parameter group family.
     * <p>
     * To list all of the available parameter group families for a DB engine, use the following command:
     * <p>
     * <code>aws rds describe-db-engine-versions --query "DBEngineVersions[].DBParameterGroupFamily" --engine &lt;engine&gt;</code>
     * <p>
     * For example, to list all of the available parameter group families for the MySQL DB engine, use the following command:
     * <p>
     * <code>aws rds describe-db-engine-versions --query "DBEngineVersions[].DBParameterGroupFamily" --engine mysql</code>
     * <p>
     * <blockquote>
     * <p>
     * The output contains duplicates.
     * <p>
     * </blockquote>
     * <p>
     * The following are the valid DB engine values:
     * <p>
     * <ul>
     * <li><code>aurora-mysql</code></li>
     * <li><code>aurora-postgresql</code></li>
     * <li><code>db2-ae</code></li>
     * <li><code>db2-se</code></li>
     * <li><code>mysql</code></li>
     * <li><code>oracle-ee</code></li>
     * <li><code>oracle-ee-cdb</code></li>
     * <li><code>oracle-se2</code></li>
     * <li><code>oracle-se2-cdb</code></li>
     * <li><code>postgres</code></li>
     * <li><code>sqlserver-ee</code></li>
     * <li><code>sqlserver-se</code></li>
     * <li><code>sqlserver-ex</code></li>
     * <li><code>sqlserver-web</code></li>
     * </ul>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbparametergroup.html#cfn-rds-dbparametergroup-family">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbparametergroup.html#cfn-rds-dbparametergroup-family</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getFamily();

    /**
     * The name of the DB parameter group.
     * <p>
     * Constraints:
     * <p>
     * <ul>
     * <li>Must be 1 to 255 letters, numbers, or hyphens.</li>
     * <li>First character must be a letter</li>
     * <li>Can't end with a hyphen or contain two consecutive hyphens</li>
     * </ul>
     * <p>
     * If you don't specify a value for <code>DBParameterGroupName</code> property, a name is automatically created for the DB parameter group.
     * <p>
     * <blockquote>
     * <p>
     * This value is stored as a lowercase string.
     * <p>
     * </blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbparametergroup.html#cfn-rds-dbparametergroup-dbparametergroupname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbparametergroup.html#cfn-rds-dbparametergroup-dbparametergroupname</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDbParameterGroupName() {
        return null;
    }

    /**
     * A mapping of parameter names and values for the parameter update.
     * <p>
     * You must specify at least one parameter name and value.
     * <p>
     * For more information about parameter groups, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_WorkingWithParamGroups.html">Working with parameter groups</a> in the <em>Amazon RDS User Guide</em> , or <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/USER_WorkingWithParamGroups.html">Working with parameter groups</a> in the <em>Amazon Aurora User Guide</em> .
     * <p>
     * <blockquote>
     * <p>
     * AWS CloudFormation doesn't support specifying an apply method for each individual parameter. The default apply method for each parameter is used.
     * <p>
     * </blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbparametergroup.html#cfn-rds-dbparametergroup-parameters">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbparametergroup.html#cfn-rds-dbparametergroup-parameters</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getParameters() {
        return null;
    }

    /**
     * Tags to assign to the DB parameter group.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbparametergroup.html#cfn-rds-dbparametergroup-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbparametergroup.html#cfn-rds-dbparametergroup-tags</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTags() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnDBParameterGroupProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnDBParameterGroupProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnDBParameterGroupProps> {
        java.lang.String description;
        java.lang.String family;
        java.lang.String dbParameterGroupName;
        java.lang.Object parameters;
        java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Sets the value of {@link CfnDBParameterGroupProps#getDescription}
         * @param description Provides the customer-specified description for this DB parameter group. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(java.lang.String description) {
            this.description = description;
            return this;
        }

        /**
         * Sets the value of {@link CfnDBParameterGroupProps#getFamily}
         * @param family The DB parameter group family name. This parameter is required.
         *               A DB parameter group can be associated with one and only one DB parameter group family, and can be applied only to a DB instance running a database engine and engine version compatible with that DB parameter group family.
         *               <p>
         *               To list all of the available parameter group families for a DB engine, use the following command:
         *               <p>
         *               <code>aws rds describe-db-engine-versions --query "DBEngineVersions[].DBParameterGroupFamily" --engine &lt;engine&gt;</code>
         *               <p>
         *               For example, to list all of the available parameter group families for the MySQL DB engine, use the following command:
         *               <p>
         *               <code>aws rds describe-db-engine-versions --query "DBEngineVersions[].DBParameterGroupFamily" --engine mysql</code>
         *               <p>
         *               <blockquote>
         *               <p>
         *               The output contains duplicates.
         *               <p>
         *               </blockquote>
         *               <p>
         *               The following are the valid DB engine values:
         *               <p>
         *               <ul>
         *               <li><code>aurora-mysql</code></li>
         *               <li><code>aurora-postgresql</code></li>
         *               <li><code>db2-ae</code></li>
         *               <li><code>db2-se</code></li>
         *               <li><code>mysql</code></li>
         *               <li><code>oracle-ee</code></li>
         *               <li><code>oracle-ee-cdb</code></li>
         *               <li><code>oracle-se2</code></li>
         *               <li><code>oracle-se2-cdb</code></li>
         *               <li><code>postgres</code></li>
         *               <li><code>sqlserver-ee</code></li>
         *               <li><code>sqlserver-se</code></li>
         *               <li><code>sqlserver-ex</code></li>
         *               <li><code>sqlserver-web</code></li>
         *               </ul>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder family(java.lang.String family) {
            this.family = family;
            return this;
        }

        /**
         * Sets the value of {@link CfnDBParameterGroupProps#getDbParameterGroupName}
         * @param dbParameterGroupName The name of the DB parameter group.
         *                             Constraints:
         *                             <p>
         *                             <ul>
         *                             <li>Must be 1 to 255 letters, numbers, or hyphens.</li>
         *                             <li>First character must be a letter</li>
         *                             <li>Can't end with a hyphen or contain two consecutive hyphens</li>
         *                             </ul>
         *                             <p>
         *                             If you don't specify a value for <code>DBParameterGroupName</code> property, a name is automatically created for the DB parameter group.
         *                             <p>
         *                             <blockquote>
         *                             <p>
         *                             This value is stored as a lowercase string.
         *                             <p>
         *                             </blockquote>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dbParameterGroupName(java.lang.String dbParameterGroupName) {
            this.dbParameterGroupName = dbParameterGroupName;
            return this;
        }

        /**
         * Sets the value of {@link CfnDBParameterGroupProps#getParameters}
         * @param parameters A mapping of parameter names and values for the parameter update.
         *                   You must specify at least one parameter name and value.
         *                   <p>
         *                   For more information about parameter groups, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_WorkingWithParamGroups.html">Working with parameter groups</a> in the <em>Amazon RDS User Guide</em> , or <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/USER_WorkingWithParamGroups.html">Working with parameter groups</a> in the <em>Amazon Aurora User Guide</em> .
         *                   <p>
         *                   <blockquote>
         *                   <p>
         *                   AWS CloudFormation doesn't support specifying an apply method for each individual parameter. The default apply method for each parameter is used.
         *                   <p>
         *                   </blockquote>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder parameters(java.lang.Object parameters) {
            this.parameters = parameters;
            return this;
        }

        /**
         * Sets the value of {@link CfnDBParameterGroupProps#getTags}
         * @param tags Tags to assign to the DB parameter group.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder tags(java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)tags;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnDBParameterGroupProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnDBParameterGroupProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnDBParameterGroupProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnDBParameterGroupProps {
        private final java.lang.String description;
        private final java.lang.String family;
        private final java.lang.String dbParameterGroupName;
        private final java.lang.Object parameters;
        private final java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.description = software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.family = software.amazon.jsii.Kernel.get(this, "family", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.dbParameterGroupName = software.amazon.jsii.Kernel.get(this, "dbParameterGroupName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.parameters = software.amazon.jsii.Kernel.get(this, "parameters", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.description = java.util.Objects.requireNonNull(builder.description, "description is required");
            this.family = java.util.Objects.requireNonNull(builder.family, "family is required");
            this.dbParameterGroupName = builder.dbParameterGroupName;
            this.parameters = builder.parameters;
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)builder.tags;
        }

        @Override
        public final java.lang.String getDescription() {
            return this.description;
        }

        @Override
        public final java.lang.String getFamily() {
            return this.family;
        }

        @Override
        public final java.lang.String getDbParameterGroupName() {
            return this.dbParameterGroupName;
        }

        @Override
        public final java.lang.Object getParameters() {
            return this.parameters;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.CfnTag> getTags() {
            return this.tags;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("description", om.valueToTree(this.getDescription()));
            data.set("family", om.valueToTree(this.getFamily()));
            if (this.getDbParameterGroupName() != null) {
                data.set("dbParameterGroupName", om.valueToTree(this.getDbParameterGroupName()));
            }
            if (this.getParameters() != null) {
                data.set("parameters", om.valueToTree(this.getParameters()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_rds.CfnDBParameterGroupProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnDBParameterGroupProps.Jsii$Proxy that = (CfnDBParameterGroupProps.Jsii$Proxy) o;

            if (!description.equals(that.description)) return false;
            if (!family.equals(that.family)) return false;
            if (this.dbParameterGroupName != null ? !this.dbParameterGroupName.equals(that.dbParameterGroupName) : that.dbParameterGroupName != null) return false;
            if (this.parameters != null ? !this.parameters.equals(that.parameters) : that.parameters != null) return false;
            return this.tags != null ? this.tags.equals(that.tags) : that.tags == null;
        }

        @Override
        public final int hashCode() {
            int result = this.description.hashCode();
            result = 31 * result + (this.family.hashCode());
            result = 31 * result + (this.dbParameterGroupName != null ? this.dbParameterGroupName.hashCode() : 0);
            result = 31 * result + (this.parameters != null ? this.parameters.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            return result;
        }
    }
}
