package software.amazon.awscdk.services.sagemaker;

/**
 * Properties for defining a <code>CfnPartnerApp</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.sagemaker.*;
 * CfnPartnerAppProps cfnPartnerAppProps = CfnPartnerAppProps.builder()
 *         .authType("authType")
 *         .executionRoleArn("executionRoleArn")
 *         .name("name")
 *         .tier("tier")
 *         .type("type")
 *         // the properties below are optional
 *         .applicationConfig(PartnerAppConfigProperty.builder()
 *                 .adminUsers(List.of("adminUsers"))
 *                 .arguments(Map.of(
 *                         "argumentsKey", "arguments"))
 *                 .build())
 *         .clientToken("clientToken")
 *         .enableIamSessionBasedIdentity(false)
 *         .kmsKeyId("kmsKeyId")
 *         .maintenanceConfig(PartnerAppMaintenanceConfigProperty.builder()
 *                 .maintenanceWindowStart("maintenanceWindowStart")
 *                 .build())
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-partnerapp.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-partnerapp.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-05-20T23:53:03.319Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_sagemaker.CfnPartnerAppProps")
@software.amazon.jsii.Jsii.Proxy(CfnPartnerAppProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnPartnerAppProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * Defines the authentication type used for the Partner AI App.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-partnerapp.html#cfn-sagemaker-partnerapp-authtype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-partnerapp.html#cfn-sagemaker-partnerapp-authtype</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getAuthType();

    /**
     * The Amazon Resource Name (ARN) of the IAM role of the user.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-partnerapp.html#cfn-sagemaker-partnerapp-executionrolearn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-partnerapp.html#cfn-sagemaker-partnerapp-executionrolearn</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getExecutionRoleArn();

    /**
     * The name of the Partner AI App.
     * <p>
     * This name must be unique within your account and region.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-partnerapp.html#cfn-sagemaker-partnerapp-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-partnerapp.html#cfn-sagemaker-partnerapp-name</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getName();

    /**
     * Specifies the tier or level of the Partner AI App.
     * <p>
     * The tier size impacts the speed and capabilities of the application. For more information, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/partner-app-onboard.html">Set up Partner AI Apps</a> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-partnerapp.html#cfn-sagemaker-partnerapp-tier">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-partnerapp.html#cfn-sagemaker-partnerapp-tier</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getTier();

    /**
     * Specifies the type of Partner AI App being created.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-partnerapp.html#cfn-sagemaker-partnerapp-type">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-partnerapp.html#cfn-sagemaker-partnerapp-type</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getType();

    /**
     * Configuration settings for the Partner AI App.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-partnerapp.html#cfn-sagemaker-partnerapp-applicationconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-partnerapp.html#cfn-sagemaker-partnerapp-applicationconfig</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getApplicationConfig() {
        return null;
    }

    /**
     * (deprecated) The client token for the PartnerApp.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-partnerapp.html#cfn-sagemaker-partnerapp-clienttoken">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-partnerapp.html#cfn-sagemaker-partnerapp-clienttoken</a>
     * @deprecated this property has been deprecated
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    default @org.jetbrains.annotations.Nullable java.lang.String getClientToken() {
        return null;
    }

    /**
     * Enables IAM Session based Identity for PartnerApp.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-partnerapp.html#cfn-sagemaker-partnerapp-enableiamsessionbasedidentity">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-partnerapp.html#cfn-sagemaker-partnerapp-enableiamsessionbasedidentity</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getEnableIamSessionBasedIdentity() {
        return null;
    }

    /**
     * The AWS KMS customer managed key used to encrypt the data associated with the PartnerApp.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-partnerapp.html#cfn-sagemaker-partnerapp-kmskeyid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-partnerapp.html#cfn-sagemaker-partnerapp-kmskeyid</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getKmsKeyId() {
        return null;
    }

    /**
     * A collection of settings that specify the maintenance schedule for the PartnerApp.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-partnerapp.html#cfn-sagemaker-partnerapp-maintenanceconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-partnerapp.html#cfn-sagemaker-partnerapp-maintenanceconfig</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getMaintenanceConfig() {
        return null;
    }

    /**
     * A list of tags to apply to the PartnerApp.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-partnerapp.html#cfn-sagemaker-partnerapp-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-partnerapp.html#cfn-sagemaker-partnerapp-tags</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTags() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnPartnerAppProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnPartnerAppProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnPartnerAppProps> {
        java.lang.String authType;
        java.lang.String executionRoleArn;
        java.lang.String name;
        java.lang.String tier;
        java.lang.String type;
        java.lang.Object applicationConfig;
        java.lang.String clientToken;
        java.lang.Object enableIamSessionBasedIdentity;
        java.lang.String kmsKeyId;
        java.lang.Object maintenanceConfig;
        java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Sets the value of {@link CfnPartnerAppProps#getAuthType}
         * @param authType Defines the authentication type used for the Partner AI App. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder authType(java.lang.String authType) {
            this.authType = authType;
            return this;
        }

        /**
         * Sets the value of {@link CfnPartnerAppProps#getExecutionRoleArn}
         * @param executionRoleArn The Amazon Resource Name (ARN) of the IAM role of the user. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder executionRoleArn(java.lang.String executionRoleArn) {
            this.executionRoleArn = executionRoleArn;
            return this;
        }

        /**
         * Sets the value of {@link CfnPartnerAppProps#getName}
         * @param name The name of the Partner AI App. This parameter is required.
         *             This name must be unique within your account and region.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(java.lang.String name) {
            this.name = name;
            return this;
        }

        /**
         * Sets the value of {@link CfnPartnerAppProps#getTier}
         * @param tier Specifies the tier or level of the Partner AI App. This parameter is required.
         *             The tier size impacts the speed and capabilities of the application. For more information, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/partner-app-onboard.html">Set up Partner AI Apps</a> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tier(java.lang.String tier) {
            this.tier = tier;
            return this;
        }

        /**
         * Sets the value of {@link CfnPartnerAppProps#getType}
         * @param type Specifies the type of Partner AI App being created. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder type(java.lang.String type) {
            this.type = type;
            return this;
        }

        /**
         * Sets the value of {@link CfnPartnerAppProps#getApplicationConfig}
         * @param applicationConfig Configuration settings for the Partner AI App.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder applicationConfig(software.amazon.awscdk.IResolvable applicationConfig) {
            this.applicationConfig = applicationConfig;
            return this;
        }

        /**
         * Sets the value of {@link CfnPartnerAppProps#getApplicationConfig}
         * @param applicationConfig Configuration settings for the Partner AI App.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder applicationConfig(software.amazon.awscdk.services.sagemaker.CfnPartnerApp.PartnerAppConfigProperty applicationConfig) {
            this.applicationConfig = applicationConfig;
            return this;
        }

        /**
         * Sets the value of {@link CfnPartnerAppProps#getClientToken}
         * @param clientToken The client token for the PartnerApp.
         * @return {@code this}
         * @deprecated this property has been deprecated
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
        @Deprecated
        public Builder clientToken(java.lang.String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        /**
         * Sets the value of {@link CfnPartnerAppProps#getEnableIamSessionBasedIdentity}
         * @param enableIamSessionBasedIdentity Enables IAM Session based Identity for PartnerApp.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder enableIamSessionBasedIdentity(java.lang.Boolean enableIamSessionBasedIdentity) {
            this.enableIamSessionBasedIdentity = enableIamSessionBasedIdentity;
            return this;
        }

        /**
         * Sets the value of {@link CfnPartnerAppProps#getEnableIamSessionBasedIdentity}
         * @param enableIamSessionBasedIdentity Enables IAM Session based Identity for PartnerApp.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder enableIamSessionBasedIdentity(software.amazon.awscdk.IResolvable enableIamSessionBasedIdentity) {
            this.enableIamSessionBasedIdentity = enableIamSessionBasedIdentity;
            return this;
        }

        /**
         * Sets the value of {@link CfnPartnerAppProps#getKmsKeyId}
         * @param kmsKeyId The AWS KMS customer managed key used to encrypt the data associated with the PartnerApp.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder kmsKeyId(java.lang.String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            return this;
        }

        /**
         * Sets the value of {@link CfnPartnerAppProps#getMaintenanceConfig}
         * @param maintenanceConfig A collection of settings that specify the maintenance schedule for the PartnerApp.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder maintenanceConfig(software.amazon.awscdk.IResolvable maintenanceConfig) {
            this.maintenanceConfig = maintenanceConfig;
            return this;
        }

        /**
         * Sets the value of {@link CfnPartnerAppProps#getMaintenanceConfig}
         * @param maintenanceConfig A collection of settings that specify the maintenance schedule for the PartnerApp.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder maintenanceConfig(software.amazon.awscdk.services.sagemaker.CfnPartnerApp.PartnerAppMaintenanceConfigProperty maintenanceConfig) {
            this.maintenanceConfig = maintenanceConfig;
            return this;
        }

        /**
         * Sets the value of {@link CfnPartnerAppProps#getTags}
         * @param tags A list of tags to apply to the PartnerApp.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder tags(java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)tags;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnPartnerAppProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnPartnerAppProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnPartnerAppProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnPartnerAppProps {
        private final java.lang.String authType;
        private final java.lang.String executionRoleArn;
        private final java.lang.String name;
        private final java.lang.String tier;
        private final java.lang.String type;
        private final java.lang.Object applicationConfig;
        private final java.lang.String clientToken;
        private final java.lang.Object enableIamSessionBasedIdentity;
        private final java.lang.String kmsKeyId;
        private final java.lang.Object maintenanceConfig;
        private final java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.authType = software.amazon.jsii.Kernel.get(this, "authType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.executionRoleArn = software.amazon.jsii.Kernel.get(this, "executionRoleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.tier = software.amazon.jsii.Kernel.get(this, "tier", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.type = software.amazon.jsii.Kernel.get(this, "type", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.applicationConfig = software.amazon.jsii.Kernel.get(this, "applicationConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.clientToken = software.amazon.jsii.Kernel.get(this, "clientToken", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.enableIamSessionBasedIdentity = software.amazon.jsii.Kernel.get(this, "enableIamSessionBasedIdentity", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.kmsKeyId = software.amazon.jsii.Kernel.get(this, "kmsKeyId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.maintenanceConfig = software.amazon.jsii.Kernel.get(this, "maintenanceConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.authType = java.util.Objects.requireNonNull(builder.authType, "authType is required");
            this.executionRoleArn = java.util.Objects.requireNonNull(builder.executionRoleArn, "executionRoleArn is required");
            this.name = java.util.Objects.requireNonNull(builder.name, "name is required");
            this.tier = java.util.Objects.requireNonNull(builder.tier, "tier is required");
            this.type = java.util.Objects.requireNonNull(builder.type, "type is required");
            this.applicationConfig = builder.applicationConfig;
            this.clientToken = builder.clientToken;
            this.enableIamSessionBasedIdentity = builder.enableIamSessionBasedIdentity;
            this.kmsKeyId = builder.kmsKeyId;
            this.maintenanceConfig = builder.maintenanceConfig;
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)builder.tags;
        }

        @Override
        public final java.lang.String getAuthType() {
            return this.authType;
        }

        @Override
        public final java.lang.String getExecutionRoleArn() {
            return this.executionRoleArn;
        }

        @Override
        public final java.lang.String getName() {
            return this.name;
        }

        @Override
        public final java.lang.String getTier() {
            return this.tier;
        }

        @Override
        public final java.lang.String getType() {
            return this.type;
        }

        @Override
        public final java.lang.Object getApplicationConfig() {
            return this.applicationConfig;
        }

        @Override
        public final java.lang.String getClientToken() {
            return this.clientToken;
        }

        @Override
        public final java.lang.Object getEnableIamSessionBasedIdentity() {
            return this.enableIamSessionBasedIdentity;
        }

        @Override
        public final java.lang.String getKmsKeyId() {
            return this.kmsKeyId;
        }

        @Override
        public final java.lang.Object getMaintenanceConfig() {
            return this.maintenanceConfig;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.CfnTag> getTags() {
            return this.tags;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("authType", om.valueToTree(this.getAuthType()));
            data.set("executionRoleArn", om.valueToTree(this.getExecutionRoleArn()));
            data.set("name", om.valueToTree(this.getName()));
            data.set("tier", om.valueToTree(this.getTier()));
            data.set("type", om.valueToTree(this.getType()));
            if (this.getApplicationConfig() != null) {
                data.set("applicationConfig", om.valueToTree(this.getApplicationConfig()));
            }
            if (this.getClientToken() != null) {
                data.set("clientToken", om.valueToTree(this.getClientToken()));
            }
            if (this.getEnableIamSessionBasedIdentity() != null) {
                data.set("enableIamSessionBasedIdentity", om.valueToTree(this.getEnableIamSessionBasedIdentity()));
            }
            if (this.getKmsKeyId() != null) {
                data.set("kmsKeyId", om.valueToTree(this.getKmsKeyId()));
            }
            if (this.getMaintenanceConfig() != null) {
                data.set("maintenanceConfig", om.valueToTree(this.getMaintenanceConfig()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_sagemaker.CfnPartnerAppProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnPartnerAppProps.Jsii$Proxy that = (CfnPartnerAppProps.Jsii$Proxy) o;

            if (!authType.equals(that.authType)) return false;
            if (!executionRoleArn.equals(that.executionRoleArn)) return false;
            if (!name.equals(that.name)) return false;
            if (!tier.equals(that.tier)) return false;
            if (!type.equals(that.type)) return false;
            if (this.applicationConfig != null ? !this.applicationConfig.equals(that.applicationConfig) : that.applicationConfig != null) return false;
            if (this.clientToken != null ? !this.clientToken.equals(that.clientToken) : that.clientToken != null) return false;
            if (this.enableIamSessionBasedIdentity != null ? !this.enableIamSessionBasedIdentity.equals(that.enableIamSessionBasedIdentity) : that.enableIamSessionBasedIdentity != null) return false;
            if (this.kmsKeyId != null ? !this.kmsKeyId.equals(that.kmsKeyId) : that.kmsKeyId != null) return false;
            if (this.maintenanceConfig != null ? !this.maintenanceConfig.equals(that.maintenanceConfig) : that.maintenanceConfig != null) return false;
            return this.tags != null ? this.tags.equals(that.tags) : that.tags == null;
        }

        @Override
        public final int hashCode() {
            int result = this.authType.hashCode();
            result = 31 * result + (this.executionRoleArn.hashCode());
            result = 31 * result + (this.name.hashCode());
            result = 31 * result + (this.tier.hashCode());
            result = 31 * result + (this.type.hashCode());
            result = 31 * result + (this.applicationConfig != null ? this.applicationConfig.hashCode() : 0);
            result = 31 * result + (this.clientToken != null ? this.clientToken.hashCode() : 0);
            result = 31 * result + (this.enableIamSessionBasedIdentity != null ? this.enableIamSessionBasedIdentity.hashCode() : 0);
            result = 31 * result + (this.kmsKeyId != null ? this.kmsKeyId.hashCode() : 0);
            result = 31 * result + (this.maintenanceConfig != null ? this.maintenanceConfig.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            return result;
        }
    }
}
