package software.amazon.awscdk.services.scheduler;

/**
 * Config of a Schedule Target used during initialization of Schedule.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.iam.*;
 * import software.amazon.awscdk.services.scheduler.*;
 * Role role;
 * ScheduleTargetInput scheduleTargetInput;
 * Object tags;
 * ScheduleTargetConfig scheduleTargetConfig = ScheduleTargetConfig.builder()
 *         .arn("arn")
 *         .role(role)
 *         // the properties below are optional
 *         .deadLetterConfig(DeadLetterConfigProperty.builder()
 *                 .arn("arn")
 *                 .build())
 *         .ecsParameters(EcsParametersProperty.builder()
 *                 .taskDefinitionArn("taskDefinitionArn")
 *                 // the properties below are optional
 *                 .capacityProviderStrategy(List.of(CapacityProviderStrategyItemProperty.builder()
 *                         .capacityProvider("capacityProvider")
 *                         // the properties below are optional
 *                         .base(123)
 *                         .weight(123)
 *                         .build()))
 *                 .enableEcsManagedTags(false)
 *                 .enableExecuteCommand(false)
 *                 .group("group")
 *                 .launchType("launchType")
 *                 .networkConfiguration(NetworkConfigurationProperty.builder()
 *                         .awsvpcConfiguration(AwsVpcConfigurationProperty.builder()
 *                                 .subnets(List.of("subnets"))
 *                                 // the properties below are optional
 *                                 .assignPublicIp("assignPublicIp")
 *                                 .securityGroups(List.of("securityGroups"))
 *                                 .build())
 *                         .build())
 *                 .placementConstraints(List.of(PlacementConstraintProperty.builder()
 *                         .expression("expression")
 *                         .type("type")
 *                         .build()))
 *                 .placementStrategy(List.of(PlacementStrategyProperty.builder()
 *                         .field("field")
 *                         .type("type")
 *                         .build()))
 *                 .platformVersion("platformVersion")
 *                 .propagateTags("propagateTags")
 *                 .referenceId("referenceId")
 *                 .tags(tags)
 *                 .taskCount(123)
 *                 .build())
 *         .eventBridgeParameters(EventBridgeParametersProperty.builder()
 *                 .detailType("detailType")
 *                 .source("source")
 *                 .build())
 *         .input(scheduleTargetInput)
 *         .kinesisParameters(KinesisParametersProperty.builder()
 *                 .partitionKey("partitionKey")
 *                 .build())
 *         .retryPolicy(RetryPolicyProperty.builder()
 *                 .maximumEventAgeInSeconds(123)
 *                 .maximumRetryAttempts(123)
 *                 .build())
 *         .sageMakerPipelineParameters(SageMakerPipelineParametersProperty.builder()
 *                 .pipelineParameterList(List.of(SageMakerPipelineParameterProperty.builder()
 *                         .name("name")
 *                         .value("value")
 *                         .build()))
 *                 .build())
 *         .sqsParameters(SqsParametersProperty.builder()
 *                 .messageGroupId("messageGroupId")
 *                 .build())
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-05-20T23:53:03.481Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_scheduler.ScheduleTargetConfig")
@software.amazon.jsii.Jsii.Proxy(ScheduleTargetConfig.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface ScheduleTargetConfig extends software.amazon.jsii.JsiiSerializable {

    /**
     * The Amazon Resource Name (ARN) of the target.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getArn();

    /**
     * Role to use to invoke this event target.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IRole getRole();

    /**
     * An object that contains information about an Amazon SQS queue that EventBridge Scheduler uses as a dead-letter queue for your schedule.
     * <p>
     * If specified, EventBridge Scheduler delivers failed events that could not be successfully delivered to a target to the queue.
     * <p>
     * Default: - No dead-letter queue
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.scheduler.CfnSchedule.DeadLetterConfigProperty getDeadLetterConfig() {
        return null;
    }

    /**
     * The templated target type for the Amazon ECS RunTask API Operation.
     * <p>
     * Default: - No parameters
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.scheduler.CfnSchedule.EcsParametersProperty getEcsParameters() {
        return null;
    }

    /**
     * The templated target type for the EventBridge PutEvents API operation.
     * <p>
     * Default: - No parameters
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.scheduler.CfnSchedule.EventBridgeParametersProperty getEventBridgeParameters() {
        return null;
    }

    /**
     * What input to pass to the target.
     * <p>
     * Default: - No input
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.scheduler.ScheduleTargetInput getInput() {
        return null;
    }

    /**
     * The templated target type for the Amazon Kinesis PutRecord API operation.
     * <p>
     * Default: - No parameters
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.scheduler.CfnSchedule.KinesisParametersProperty getKinesisParameters() {
        return null;
    }

    /**
     * A <code>RetryPolicy</code> object that includes information about the retry policy settings, including the maximum age of an event, and the maximum number of times EventBridge Scheduler will try to deliver the event to a target.
     * <p>
     * Default: - Maximum retry attempts of 185 and maximum age of 86400 seconds (1 day)
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.scheduler.CfnSchedule.RetryPolicyProperty getRetryPolicy() {
        return null;
    }

    /**
     * The templated target type for the Amazon SageMaker StartPipelineExecution API operation.
     * <p>
     * Default: - No parameters
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.scheduler.CfnSchedule.SageMakerPipelineParametersProperty getSageMakerPipelineParameters() {
        return null;
    }

    /**
     * The templated target type for the Amazon SQS SendMessage API Operation.
     * <p>
     * Default: - No parameters
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.scheduler.CfnSchedule.SqsParametersProperty getSqsParameters() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link ScheduleTargetConfig}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link ScheduleTargetConfig}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<ScheduleTargetConfig> {
        java.lang.String arn;
        software.amazon.awscdk.services.iam.IRole role;
        software.amazon.awscdk.services.scheduler.CfnSchedule.DeadLetterConfigProperty deadLetterConfig;
        software.amazon.awscdk.services.scheduler.CfnSchedule.EcsParametersProperty ecsParameters;
        software.amazon.awscdk.services.scheduler.CfnSchedule.EventBridgeParametersProperty eventBridgeParameters;
        software.amazon.awscdk.services.scheduler.ScheduleTargetInput input;
        software.amazon.awscdk.services.scheduler.CfnSchedule.KinesisParametersProperty kinesisParameters;
        software.amazon.awscdk.services.scheduler.CfnSchedule.RetryPolicyProperty retryPolicy;
        software.amazon.awscdk.services.scheduler.CfnSchedule.SageMakerPipelineParametersProperty sageMakerPipelineParameters;
        software.amazon.awscdk.services.scheduler.CfnSchedule.SqsParametersProperty sqsParameters;

        /**
         * Sets the value of {@link ScheduleTargetConfig#getArn}
         * @param arn The Amazon Resource Name (ARN) of the target. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder arn(java.lang.String arn) {
            this.arn = arn;
            return this;
        }

        /**
         * Sets the value of {@link ScheduleTargetConfig#getRole}
         * @param role Role to use to invoke this event target. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder role(software.amazon.awscdk.services.iam.IRole role) {
            this.role = role;
            return this;
        }

        /**
         * Sets the value of {@link ScheduleTargetConfig#getDeadLetterConfig}
         * @param deadLetterConfig An object that contains information about an Amazon SQS queue that EventBridge Scheduler uses as a dead-letter queue for your schedule.
         *                         If specified, EventBridge Scheduler delivers failed events that could not be successfully delivered to a target to the queue.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder deadLetterConfig(software.amazon.awscdk.services.scheduler.CfnSchedule.DeadLetterConfigProperty deadLetterConfig) {
            this.deadLetterConfig = deadLetterConfig;
            return this;
        }

        /**
         * Sets the value of {@link ScheduleTargetConfig#getEcsParameters}
         * @param ecsParameters The templated target type for the Amazon ECS RunTask API Operation.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ecsParameters(software.amazon.awscdk.services.scheduler.CfnSchedule.EcsParametersProperty ecsParameters) {
            this.ecsParameters = ecsParameters;
            return this;
        }

        /**
         * Sets the value of {@link ScheduleTargetConfig#getEventBridgeParameters}
         * @param eventBridgeParameters The templated target type for the EventBridge PutEvents API operation.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder eventBridgeParameters(software.amazon.awscdk.services.scheduler.CfnSchedule.EventBridgeParametersProperty eventBridgeParameters) {
            this.eventBridgeParameters = eventBridgeParameters;
            return this;
        }

        /**
         * Sets the value of {@link ScheduleTargetConfig#getInput}
         * @param input What input to pass to the target.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder input(software.amazon.awscdk.services.scheduler.ScheduleTargetInput input) {
            this.input = input;
            return this;
        }

        /**
         * Sets the value of {@link ScheduleTargetConfig#getKinesisParameters}
         * @param kinesisParameters The templated target type for the Amazon Kinesis PutRecord API operation.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder kinesisParameters(software.amazon.awscdk.services.scheduler.CfnSchedule.KinesisParametersProperty kinesisParameters) {
            this.kinesisParameters = kinesisParameters;
            return this;
        }

        /**
         * Sets the value of {@link ScheduleTargetConfig#getRetryPolicy}
         * @param retryPolicy A <code>RetryPolicy</code> object that includes information about the retry policy settings, including the maximum age of an event, and the maximum number of times EventBridge Scheduler will try to deliver the event to a target.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder retryPolicy(software.amazon.awscdk.services.scheduler.CfnSchedule.RetryPolicyProperty retryPolicy) {
            this.retryPolicy = retryPolicy;
            return this;
        }

        /**
         * Sets the value of {@link ScheduleTargetConfig#getSageMakerPipelineParameters}
         * @param sageMakerPipelineParameters The templated target type for the Amazon SageMaker StartPipelineExecution API operation.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder sageMakerPipelineParameters(software.amazon.awscdk.services.scheduler.CfnSchedule.SageMakerPipelineParametersProperty sageMakerPipelineParameters) {
            this.sageMakerPipelineParameters = sageMakerPipelineParameters;
            return this;
        }

        /**
         * Sets the value of {@link ScheduleTargetConfig#getSqsParameters}
         * @param sqsParameters The templated target type for the Amazon SQS SendMessage API Operation.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder sqsParameters(software.amazon.awscdk.services.scheduler.CfnSchedule.SqsParametersProperty sqsParameters) {
            this.sqsParameters = sqsParameters;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link ScheduleTargetConfig}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public ScheduleTargetConfig build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link ScheduleTargetConfig}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ScheduleTargetConfig {
        private final java.lang.String arn;
        private final software.amazon.awscdk.services.iam.IRole role;
        private final software.amazon.awscdk.services.scheduler.CfnSchedule.DeadLetterConfigProperty deadLetterConfig;
        private final software.amazon.awscdk.services.scheduler.CfnSchedule.EcsParametersProperty ecsParameters;
        private final software.amazon.awscdk.services.scheduler.CfnSchedule.EventBridgeParametersProperty eventBridgeParameters;
        private final software.amazon.awscdk.services.scheduler.ScheduleTargetInput input;
        private final software.amazon.awscdk.services.scheduler.CfnSchedule.KinesisParametersProperty kinesisParameters;
        private final software.amazon.awscdk.services.scheduler.CfnSchedule.RetryPolicyProperty retryPolicy;
        private final software.amazon.awscdk.services.scheduler.CfnSchedule.SageMakerPipelineParametersProperty sageMakerPipelineParameters;
        private final software.amazon.awscdk.services.scheduler.CfnSchedule.SqsParametersProperty sqsParameters;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.arn = software.amazon.jsii.Kernel.get(this, "arn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.role = software.amazon.jsii.Kernel.get(this, "role", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.IRole.class));
            this.deadLetterConfig = software.amazon.jsii.Kernel.get(this, "deadLetterConfig", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.scheduler.CfnSchedule.DeadLetterConfigProperty.class));
            this.ecsParameters = software.amazon.jsii.Kernel.get(this, "ecsParameters", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.scheduler.CfnSchedule.EcsParametersProperty.class));
            this.eventBridgeParameters = software.amazon.jsii.Kernel.get(this, "eventBridgeParameters", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.scheduler.CfnSchedule.EventBridgeParametersProperty.class));
            this.input = software.amazon.jsii.Kernel.get(this, "input", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.scheduler.ScheduleTargetInput.class));
            this.kinesisParameters = software.amazon.jsii.Kernel.get(this, "kinesisParameters", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.scheduler.CfnSchedule.KinesisParametersProperty.class));
            this.retryPolicy = software.amazon.jsii.Kernel.get(this, "retryPolicy", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.scheduler.CfnSchedule.RetryPolicyProperty.class));
            this.sageMakerPipelineParameters = software.amazon.jsii.Kernel.get(this, "sageMakerPipelineParameters", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.scheduler.CfnSchedule.SageMakerPipelineParametersProperty.class));
            this.sqsParameters = software.amazon.jsii.Kernel.get(this, "sqsParameters", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.scheduler.CfnSchedule.SqsParametersProperty.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.arn = java.util.Objects.requireNonNull(builder.arn, "arn is required");
            this.role = java.util.Objects.requireNonNull(builder.role, "role is required");
            this.deadLetterConfig = builder.deadLetterConfig;
            this.ecsParameters = builder.ecsParameters;
            this.eventBridgeParameters = builder.eventBridgeParameters;
            this.input = builder.input;
            this.kinesisParameters = builder.kinesisParameters;
            this.retryPolicy = builder.retryPolicy;
            this.sageMakerPipelineParameters = builder.sageMakerPipelineParameters;
            this.sqsParameters = builder.sqsParameters;
        }

        @Override
        public final java.lang.String getArn() {
            return this.arn;
        }

        @Override
        public final software.amazon.awscdk.services.iam.IRole getRole() {
            return this.role;
        }

        @Override
        public final software.amazon.awscdk.services.scheduler.CfnSchedule.DeadLetterConfigProperty getDeadLetterConfig() {
            return this.deadLetterConfig;
        }

        @Override
        public final software.amazon.awscdk.services.scheduler.CfnSchedule.EcsParametersProperty getEcsParameters() {
            return this.ecsParameters;
        }

        @Override
        public final software.amazon.awscdk.services.scheduler.CfnSchedule.EventBridgeParametersProperty getEventBridgeParameters() {
            return this.eventBridgeParameters;
        }

        @Override
        public final software.amazon.awscdk.services.scheduler.ScheduleTargetInput getInput() {
            return this.input;
        }

        @Override
        public final software.amazon.awscdk.services.scheduler.CfnSchedule.KinesisParametersProperty getKinesisParameters() {
            return this.kinesisParameters;
        }

        @Override
        public final software.amazon.awscdk.services.scheduler.CfnSchedule.RetryPolicyProperty getRetryPolicy() {
            return this.retryPolicy;
        }

        @Override
        public final software.amazon.awscdk.services.scheduler.CfnSchedule.SageMakerPipelineParametersProperty getSageMakerPipelineParameters() {
            return this.sageMakerPipelineParameters;
        }

        @Override
        public final software.amazon.awscdk.services.scheduler.CfnSchedule.SqsParametersProperty getSqsParameters() {
            return this.sqsParameters;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("arn", om.valueToTree(this.getArn()));
            data.set("role", om.valueToTree(this.getRole()));
            if (this.getDeadLetterConfig() != null) {
                data.set("deadLetterConfig", om.valueToTree(this.getDeadLetterConfig()));
            }
            if (this.getEcsParameters() != null) {
                data.set("ecsParameters", om.valueToTree(this.getEcsParameters()));
            }
            if (this.getEventBridgeParameters() != null) {
                data.set("eventBridgeParameters", om.valueToTree(this.getEventBridgeParameters()));
            }
            if (this.getInput() != null) {
                data.set("input", om.valueToTree(this.getInput()));
            }
            if (this.getKinesisParameters() != null) {
                data.set("kinesisParameters", om.valueToTree(this.getKinesisParameters()));
            }
            if (this.getRetryPolicy() != null) {
                data.set("retryPolicy", om.valueToTree(this.getRetryPolicy()));
            }
            if (this.getSageMakerPipelineParameters() != null) {
                data.set("sageMakerPipelineParameters", om.valueToTree(this.getSageMakerPipelineParameters()));
            }
            if (this.getSqsParameters() != null) {
                data.set("sqsParameters", om.valueToTree(this.getSqsParameters()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_scheduler.ScheduleTargetConfig"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            ScheduleTargetConfig.Jsii$Proxy that = (ScheduleTargetConfig.Jsii$Proxy) o;

            if (!arn.equals(that.arn)) return false;
            if (!role.equals(that.role)) return false;
            if (this.deadLetterConfig != null ? !this.deadLetterConfig.equals(that.deadLetterConfig) : that.deadLetterConfig != null) return false;
            if (this.ecsParameters != null ? !this.ecsParameters.equals(that.ecsParameters) : that.ecsParameters != null) return false;
            if (this.eventBridgeParameters != null ? !this.eventBridgeParameters.equals(that.eventBridgeParameters) : that.eventBridgeParameters != null) return false;
            if (this.input != null ? !this.input.equals(that.input) : that.input != null) return false;
            if (this.kinesisParameters != null ? !this.kinesisParameters.equals(that.kinesisParameters) : that.kinesisParameters != null) return false;
            if (this.retryPolicy != null ? !this.retryPolicy.equals(that.retryPolicy) : that.retryPolicy != null) return false;
            if (this.sageMakerPipelineParameters != null ? !this.sageMakerPipelineParameters.equals(that.sageMakerPipelineParameters) : that.sageMakerPipelineParameters != null) return false;
            return this.sqsParameters != null ? this.sqsParameters.equals(that.sqsParameters) : that.sqsParameters == null;
        }

        @Override
        public final int hashCode() {
            int result = this.arn.hashCode();
            result = 31 * result + (this.role.hashCode());
            result = 31 * result + (this.deadLetterConfig != null ? this.deadLetterConfig.hashCode() : 0);
            result = 31 * result + (this.ecsParameters != null ? this.ecsParameters.hashCode() : 0);
            result = 31 * result + (this.eventBridgeParameters != null ? this.eventBridgeParameters.hashCode() : 0);
            result = 31 * result + (this.input != null ? this.input.hashCode() : 0);
            result = 31 * result + (this.kinesisParameters != null ? this.kinesisParameters.hashCode() : 0);
            result = 31 * result + (this.retryPolicy != null ? this.retryPolicy.hashCode() : 0);
            result = 31 * result + (this.sageMakerPipelineParameters != null ? this.sageMakerPipelineParameters.hashCode() : 0);
            result = 31 * result + (this.sqsParameters != null ? this.sqsParameters.hashCode() : 0);
            return result;
        }
    }
}
