package software.amazon.awscdk.services.secretsmanager;

/**
 * Construction properties for a RotationSchedule.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.*;
 * import software.amazon.awscdk.services.lambda.*;
 * import software.amazon.awscdk.services.secretsmanager.*;
 * Function function_;
 * HostedRotation hostedRotation;
 * Secret secret;
 * RotationScheduleProps rotationScheduleProps = RotationScheduleProps.builder()
 *         .secret(secret)
 *         // the properties below are optional
 *         .automaticallyAfter(Duration.minutes(30))
 *         .hostedRotation(hostedRotation)
 *         .rotateImmediatelyOnUpdate(false)
 *         .rotationLambda(function_)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-05-20T23:53:03.554Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_secretsmanager.RotationScheduleProps")
@software.amazon.jsii.Jsii.Proxy(RotationScheduleProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface RotationScheduleProps extends software.amazon.jsii.JsiiSerializable, software.amazon.awscdk.services.secretsmanager.RotationScheduleOptions {

    /**
     * The secret to rotate.
     * <p>
     * If hosted rotation is used, this must be a JSON string with the following format:
     * <p>
     * <blockquote><pre>
     * {
     *   "engine": &lt;required: database engine&gt;,
     *   "host": &lt;required: instance host name&gt;,
     *   "username": &lt;required: username&gt;,
     *   "password": &lt;required: password&gt;,
     *   "dbname": &lt;optional: database name&gt;,
     *   "port": &lt;optional: if not specified, default port will be used&gt;,
     *   "masterarn": &lt;required for multi user rotation: the arn of the master secret which will be used to create users/change passwords&gt;
     * }
     * </pre></blockquote>
     * <p>
     * This is typically the case for a secret referenced from an <code>AWS::SecretsManager::SecretTargetAttachment</code>
     * or an <code>ISecret</code> returned by the <code>attach()</code> method of <code>Secret</code>.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.secretsmanager.ISecret getSecret();

    /**
     * @return a {@link Builder} of {@link RotationScheduleProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link RotationScheduleProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<RotationScheduleProps> {
        software.amazon.awscdk.services.secretsmanager.ISecret secret;
        software.amazon.awscdk.Duration automaticallyAfter;
        software.amazon.awscdk.services.secretsmanager.HostedRotation hostedRotation;
        java.lang.Boolean rotateImmediatelyOnUpdate;
        software.amazon.awscdk.services.lambda.IFunction rotationLambda;

        /**
         * Sets the value of {@link RotationScheduleProps#getSecret}
         * @param secret The secret to rotate. This parameter is required.
         *               If hosted rotation is used, this must be a JSON string with the following format:
         *               <p>
         *               <blockquote><pre>
         *               {
         *                 "engine": &lt;required: database engine&gt;,
         *                 "host": &lt;required: instance host name&gt;,
         *                 "username": &lt;required: username&gt;,
         *                 "password": &lt;required: password&gt;,
         *                 "dbname": &lt;optional: database name&gt;,
         *                 "port": &lt;optional: if not specified, default port will be used&gt;,
         *                 "masterarn": &lt;required for multi user rotation: the arn of the master secret which will be used to create users/change passwords&gt;
         *               }
         *               </pre></blockquote>
         *               <p>
         *               This is typically the case for a secret referenced from an <code>AWS::SecretsManager::SecretTargetAttachment</code>
         *               or an <code>ISecret</code> returned by the <code>attach()</code> method of <code>Secret</code>.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder secret(software.amazon.awscdk.services.secretsmanager.ISecret secret) {
            this.secret = secret;
            return this;
        }

        /**
         * Sets the value of {@link RotationScheduleProps#getAutomaticallyAfter}
         * @param automaticallyAfter Specifies the number of days after the previous rotation before Secrets Manager triggers the next automatic rotation.
         *                           The minimum value is 4 hours.
         *                           The maximum value is 1000 days.
         *                           <p>
         *                           A value of zero (<code>Duration.days(0)</code>) will not create RotationRules.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder automaticallyAfter(software.amazon.awscdk.Duration automaticallyAfter) {
            this.automaticallyAfter = automaticallyAfter;
            return this;
        }

        /**
         * Sets the value of {@link RotationScheduleProps#getHostedRotation}
         * @param hostedRotation Hosted rotation.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder hostedRotation(software.amazon.awscdk.services.secretsmanager.HostedRotation hostedRotation) {
            this.hostedRotation = hostedRotation;
            return this;
        }

        /**
         * Sets the value of {@link RotationScheduleProps#getRotateImmediatelyOnUpdate}
         * @param rotateImmediatelyOnUpdate Specifies whether to rotate the secret immediately or wait until the next scheduled rotation window.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder rotateImmediatelyOnUpdate(java.lang.Boolean rotateImmediatelyOnUpdate) {
            this.rotateImmediatelyOnUpdate = rotateImmediatelyOnUpdate;
            return this;
        }

        /**
         * Sets the value of {@link RotationScheduleProps#getRotationLambda}
         * @param rotationLambda A Lambda function that can rotate the secret.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder rotationLambda(software.amazon.awscdk.services.lambda.IFunction rotationLambda) {
            this.rotationLambda = rotationLambda;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link RotationScheduleProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public RotationScheduleProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link RotationScheduleProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements RotationScheduleProps {
        private final software.amazon.awscdk.services.secretsmanager.ISecret secret;
        private final software.amazon.awscdk.Duration automaticallyAfter;
        private final software.amazon.awscdk.services.secretsmanager.HostedRotation hostedRotation;
        private final java.lang.Boolean rotateImmediatelyOnUpdate;
        private final software.amazon.awscdk.services.lambda.IFunction rotationLambda;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.secret = software.amazon.jsii.Kernel.get(this, "secret", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.secretsmanager.ISecret.class));
            this.automaticallyAfter = software.amazon.jsii.Kernel.get(this, "automaticallyAfter", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.Duration.class));
            this.hostedRotation = software.amazon.jsii.Kernel.get(this, "hostedRotation", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.secretsmanager.HostedRotation.class));
            this.rotateImmediatelyOnUpdate = software.amazon.jsii.Kernel.get(this, "rotateImmediatelyOnUpdate", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.rotationLambda = software.amazon.jsii.Kernel.get(this, "rotationLambda", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.lambda.IFunction.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.secret = java.util.Objects.requireNonNull(builder.secret, "secret is required");
            this.automaticallyAfter = builder.automaticallyAfter;
            this.hostedRotation = builder.hostedRotation;
            this.rotateImmediatelyOnUpdate = builder.rotateImmediatelyOnUpdate;
            this.rotationLambda = builder.rotationLambda;
        }

        @Override
        public final software.amazon.awscdk.services.secretsmanager.ISecret getSecret() {
            return this.secret;
        }

        @Override
        public final software.amazon.awscdk.Duration getAutomaticallyAfter() {
            return this.automaticallyAfter;
        }

        @Override
        public final software.amazon.awscdk.services.secretsmanager.HostedRotation getHostedRotation() {
            return this.hostedRotation;
        }

        @Override
        public final java.lang.Boolean getRotateImmediatelyOnUpdate() {
            return this.rotateImmediatelyOnUpdate;
        }

        @Override
        public final software.amazon.awscdk.services.lambda.IFunction getRotationLambda() {
            return this.rotationLambda;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("secret", om.valueToTree(this.getSecret()));
            if (this.getAutomaticallyAfter() != null) {
                data.set("automaticallyAfter", om.valueToTree(this.getAutomaticallyAfter()));
            }
            if (this.getHostedRotation() != null) {
                data.set("hostedRotation", om.valueToTree(this.getHostedRotation()));
            }
            if (this.getRotateImmediatelyOnUpdate() != null) {
                data.set("rotateImmediatelyOnUpdate", om.valueToTree(this.getRotateImmediatelyOnUpdate()));
            }
            if (this.getRotationLambda() != null) {
                data.set("rotationLambda", om.valueToTree(this.getRotationLambda()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_secretsmanager.RotationScheduleProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            RotationScheduleProps.Jsii$Proxy that = (RotationScheduleProps.Jsii$Proxy) o;

            if (!secret.equals(that.secret)) return false;
            if (this.automaticallyAfter != null ? !this.automaticallyAfter.equals(that.automaticallyAfter) : that.automaticallyAfter != null) return false;
            if (this.hostedRotation != null ? !this.hostedRotation.equals(that.hostedRotation) : that.hostedRotation != null) return false;
            if (this.rotateImmediatelyOnUpdate != null ? !this.rotateImmediatelyOnUpdate.equals(that.rotateImmediatelyOnUpdate) : that.rotateImmediatelyOnUpdate != null) return false;
            return this.rotationLambda != null ? this.rotationLambda.equals(that.rotationLambda) : that.rotationLambda == null;
        }

        @Override
        public final int hashCode() {
            int result = this.secret.hashCode();
            result = 31 * result + (this.automaticallyAfter != null ? this.automaticallyAfter.hashCode() : 0);
            result = 31 * result + (this.hostedRotation != null ? this.hostedRotation.hashCode() : 0);
            result = 31 * result + (this.rotateImmediatelyOnUpdate != null ? this.rotateImmediatelyOnUpdate.hashCode() : 0);
            result = 31 * result + (this.rotationLambda != null ? this.rotationLambda.hashCode() : 0);
            return result;
        }
    }
}
