package software.amazon.awscdk.services.securityhub;

/**
 * The <code>AWS::SecurityHub::ConfigurationPolicy</code> resource creates a central configuration policy with the defined settings.
 * <p>
 * Only the AWS Security Hub delegated administrator can create this resource in the home Region. For more information, see <a href="https://docs.aws.amazon.com/securityhub/latest/userguide/central-configuration-intro.html">Central configuration in Security Hub</a> in the <em>AWS Security Hub User Guide</em> .
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.securityhub.*;
 * CfnConfigurationPolicy cfnConfigurationPolicy = CfnConfigurationPolicy.Builder.create(this, "MyCfnConfigurationPolicy")
 *         .configurationPolicy(PolicyProperty.builder()
 *                 .securityHub(SecurityHubPolicyProperty.builder()
 *                         .enabledStandardIdentifiers(List.of("enabledStandardIdentifiers"))
 *                         .securityControlsConfiguration(SecurityControlsConfigurationProperty.builder()
 *                                 .disabledSecurityControlIdentifiers(List.of("disabledSecurityControlIdentifiers"))
 *                                 .enabledSecurityControlIdentifiers(List.of("enabledSecurityControlIdentifiers"))
 *                                 .securityControlCustomParameters(List.of(SecurityControlCustomParameterProperty.builder()
 *                                         .parameters(Map.of(
 *                                                 "parametersKey", ParameterConfigurationProperty.builder()
 *                                                         .valueType("valueType")
 *                                                         // the properties below are optional
 *                                                         .value(ParameterValueProperty.builder()
 *                                                                 .boolean(false)
 *                                                                 .double(123)
 *                                                                 .enum("enum")
 *                                                                 .enumList(List.of("enumList"))
 *                                                                 .integer(123)
 *                                                                 .integerList(List.of(123))
 *                                                                 .string("string")
 *                                                                 .stringList(List.of("stringList"))
 *                                                                 .build())
 *                                                         .build()))
 *                                         .securityControlId("securityControlId")
 *                                         .build()))
 *                                 .build())
 *                         .serviceEnabled(false)
 *                         .build())
 *                 .build())
 *         .name("name")
 *         // the properties below are optional
 *         .description("description")
 *         .tags(Map.of(
 *                 "tagsKey", "tags"))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-securityhub-configurationpolicy.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-securityhub-configurationpolicy.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-05-20T23:53:03.593Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_securityhub.CfnConfigurationPolicy")
public class CfnConfigurationPolicy extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable, software.amazon.awscdk.ITaggableV2 {

    protected CfnConfigurationPolicy(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnConfigurationPolicy(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.securityhub.CfnConfigurationPolicy.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * @param scope Scope in which this resource is defined. This parameter is required.
     * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
     * @param props Resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnConfigurationPolicy(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.securityhub.CfnConfigurationPolicyProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     * The ARN of the configuration policy.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrArn() {
        return software.amazon.jsii.Kernel.get(this, "attrArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The date and time, in UTC and ISO 8601 format.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrCreatedAt() {
        return software.amazon.jsii.Kernel.get(this, "attrCreatedAt", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The universally unique identifier (UUID) of the configuration policy.
     * <p>
     * A self-managed configuration has no UUID. The identifier of a self-managed configuration is <code>SELF_MANAGED_SECURITY_HUB</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrId() {
        return software.amazon.jsii.Kernel.get(this, "attrId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Indicates whether the service that the configuration policy applies to is enabled in the policy.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.IResolvable getAttrServiceEnabled() {
        return software.amazon.jsii.Kernel.get(this, "attrServiceEnabled", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.IResolvable.class));
    }

    /**
     * The date and time, in UTC and ISO 8601 format, that the configuration policy was last updated.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrUpdatedAt() {
        return software.amazon.jsii.Kernel.get(this, "attrUpdatedAt", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Tag Manager which manages the tags for this resource.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.TagManager getCdkTagManager() {
        return software.amazon.jsii.Kernel.get(this, "cdkTagManager", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TagManager.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * An object that defines how AWS Security Hub is configured.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Object getConfigurationPolicy() {
        return software.amazon.jsii.Kernel.get(this, "configurationPolicy", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * An object that defines how AWS Security Hub is configured.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setConfigurationPolicy(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "configurationPolicy", java.util.Objects.requireNonNull(value, "configurationPolicy is required"));
    }

    /**
     * An object that defines how AWS Security Hub is configured.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setConfigurationPolicy(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.securityhub.CfnConfigurationPolicy.PolicyProperty value) {
        software.amazon.jsii.Kernel.set(this, "configurationPolicy", java.util.Objects.requireNonNull(value, "configurationPolicy is required"));
    }

    /**
     * The name of the configuration policy.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getName() {
        return software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name of the configuration policy.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setName(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "name", java.util.Objects.requireNonNull(value, "name is required"));
    }

    /**
     * The description of the configuration policy.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
        return software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The description of the configuration policy.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDescription(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "description", value);
    }

    /**
     * User-defined tags associated with a configuration policy.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, java.lang.String> getTags() {
        return java.util.Optional.ofNullable((java.util.Map<java.lang.String, java.lang.String>)(software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))))).map(java.util.Collections::unmodifiableMap).orElse(null);
    }

    /**
     * User-defined tags associated with a configuration policy.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTags(final @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, java.lang.String> value) {
        software.amazon.jsii.Kernel.set(this, "tags", value);
    }
    /**
     * An object that provides the current value of a security control parameter and identifies whether it has been customized.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.securityhub.*;
     * ParameterConfigurationProperty parameterConfigurationProperty = ParameterConfigurationProperty.builder()
     *         .valueType("valueType")
     *         // the properties below are optional
     *         .value(ParameterValueProperty.builder()
     *                 .boolean(false)
     *                 .double(123)
     *                 .enum("enum")
     *                 .enumList(List.of("enumList"))
     *                 .integer(123)
     *                 .integerList(List.of(123))
     *                 .string("string")
     *                 .stringList(List.of("stringList"))
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-configurationpolicy-parameterconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-configurationpolicy-parameterconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_securityhub.CfnConfigurationPolicy.ParameterConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(ParameterConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ParameterConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Identifies whether a control parameter uses a custom user-defined value or subscribes to the default AWS Security Hub behavior.
         * <p>
         * When <code>ValueType</code> is set equal to <code>DEFAULT</code> , the default behavior can be a specific Security Hub default value, or the default behavior can be to ignore a specific parameter. When <code>ValueType</code> is set equal to <code>DEFAULT</code> , Security Hub ignores user-provided input for the <code>Value</code> field.
         * <p>
         * When <code>ValueType</code> is set equal to <code>CUSTOM</code> , the <code>Value</code> field can't be empty.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-configurationpolicy-parameterconfiguration.html#cfn-securityhub-configurationpolicy-parameterconfiguration-valuetype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-configurationpolicy-parameterconfiguration.html#cfn-securityhub-configurationpolicy-parameterconfiguration-valuetype</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getValueType();

        /**
         * The current value of a control parameter.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-configurationpolicy-parameterconfiguration.html#cfn-securityhub-configurationpolicy-parameterconfiguration-value">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-configurationpolicy-parameterconfiguration.html#cfn-securityhub-configurationpolicy-parameterconfiguration-value</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getValue() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ParameterConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ParameterConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ParameterConfigurationProperty> {
            java.lang.String valueType;
            java.lang.Object value;

            /**
             * Sets the value of {@link ParameterConfigurationProperty#getValueType}
             * @param valueType Identifies whether a control parameter uses a custom user-defined value or subscribes to the default AWS Security Hub behavior. This parameter is required.
             *                  When <code>ValueType</code> is set equal to <code>DEFAULT</code> , the default behavior can be a specific Security Hub default value, or the default behavior can be to ignore a specific parameter. When <code>ValueType</code> is set equal to <code>DEFAULT</code> , Security Hub ignores user-provided input for the <code>Value</code> field.
             *                  <p>
             *                  When <code>ValueType</code> is set equal to <code>CUSTOM</code> , the <code>Value</code> field can't be empty.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder valueType(java.lang.String valueType) {
                this.valueType = valueType;
                return this;
            }

            /**
             * Sets the value of {@link ParameterConfigurationProperty#getValue}
             * @param value The current value of a control parameter.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder value(software.amazon.awscdk.IResolvable value) {
                this.value = value;
                return this;
            }

            /**
             * Sets the value of {@link ParameterConfigurationProperty#getValue}
             * @param value The current value of a control parameter.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder value(software.amazon.awscdk.services.securityhub.CfnConfigurationPolicy.ParameterValueProperty value) {
                this.value = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ParameterConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ParameterConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ParameterConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ParameterConfigurationProperty {
            private final java.lang.String valueType;
            private final java.lang.Object value;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.valueType = software.amazon.jsii.Kernel.get(this, "valueType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.value = software.amazon.jsii.Kernel.get(this, "value", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.valueType = java.util.Objects.requireNonNull(builder.valueType, "valueType is required");
                this.value = builder.value;
            }

            @Override
            public final java.lang.String getValueType() {
                return this.valueType;
            }

            @Override
            public final java.lang.Object getValue() {
                return this.value;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("valueType", om.valueToTree(this.getValueType()));
                if (this.getValue() != null) {
                    data.set("value", om.valueToTree(this.getValue()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_securityhub.CfnConfigurationPolicy.ParameterConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ParameterConfigurationProperty.Jsii$Proxy that = (ParameterConfigurationProperty.Jsii$Proxy) o;

                if (!valueType.equals(that.valueType)) return false;
                return this.value != null ? this.value.equals(that.value) : that.value == null;
            }

            @Override
            public final int hashCode() {
                int result = this.valueType.hashCode();
                result = 31 * result + (this.value != null ? this.value.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * An object that includes the data type of a security control parameter and its current value.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.securityhub.*;
     * ParameterValueProperty parameterValueProperty = ParameterValueProperty.builder()
     *         .boolean(false)
     *         .double(123)
     *         .enum("enum")
     *         .enumList(List.of("enumList"))
     *         .integer(123)
     *         .integerList(List.of(123))
     *         .string("string")
     *         .stringList(List.of("stringList"))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-configurationpolicy-parametervalue.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-configurationpolicy-parametervalue.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_securityhub.CfnConfigurationPolicy.ParameterValueProperty")
    @software.amazon.jsii.Jsii.Proxy(ParameterValueProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ParameterValueProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * A control parameter that is a boolean.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-configurationpolicy-parametervalue.html#cfn-securityhub-configurationpolicy-parametervalue-boolean">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-configurationpolicy-parametervalue.html#cfn-securityhub-configurationpolicy-parametervalue-boolean</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getBooleanValue() {
            return null;
        }

        /**
         * A control parameter that is a double.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-configurationpolicy-parametervalue.html#cfn-securityhub-configurationpolicy-parametervalue-double">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-configurationpolicy-parametervalue.html#cfn-securityhub-configurationpolicy-parametervalue-double</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getDoubleValue() {
            return null;
        }

        /**
         * A control parameter that is an enum.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-configurationpolicy-parametervalue.html#cfn-securityhub-configurationpolicy-parametervalue-enum">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-configurationpolicy-parametervalue.html#cfn-securityhub-configurationpolicy-parametervalue-enum</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getEnumValue() {
            return null;
        }

        /**
         * A control parameter that is a list of enums.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-configurationpolicy-parametervalue.html#cfn-securityhub-configurationpolicy-parametervalue-enumlist">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-configurationpolicy-parametervalue.html#cfn-securityhub-configurationpolicy-parametervalue-enumlist</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getEnumList() {
            return null;
        }

        /**
         * A control parameter that is an integer.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-configurationpolicy-parametervalue.html#cfn-securityhub-configurationpolicy-parametervalue-integer">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-configurationpolicy-parametervalue.html#cfn-securityhub-configurationpolicy-parametervalue-integer</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getInteger() {
            return null;
        }

        /**
         * A control parameter that is a list of integers.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-configurationpolicy-parametervalue.html#cfn-securityhub-configurationpolicy-parametervalue-integerlist">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-configurationpolicy-parametervalue.html#cfn-securityhub-configurationpolicy-parametervalue-integerlist</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getIntegerList() {
            return null;
        }

        /**
         * A control parameter that is a string.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-configurationpolicy-parametervalue.html#cfn-securityhub-configurationpolicy-parametervalue-string">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-configurationpolicy-parametervalue.html#cfn-securityhub-configurationpolicy-parametervalue-string</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getString() {
            return null;
        }

        /**
         * A control parameter that is a list of strings.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-configurationpolicy-parametervalue.html#cfn-securityhub-configurationpolicy-parametervalue-stringlist">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-configurationpolicy-parametervalue.html#cfn-securityhub-configurationpolicy-parametervalue-stringlist</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getStringList() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ParameterValueProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ParameterValueProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ParameterValueProperty> {
            java.lang.Object booleanValue;
            java.lang.Number doubleValue;
            java.lang.String enumValue;
            java.util.List<java.lang.String> enumList;
            java.lang.Number integer;
            java.lang.Object integerList;
            java.lang.String string;
            java.util.List<java.lang.String> stringList;

            /**
             * Sets the value of {@link ParameterValueProperty#getBooleanValue}
             * @param booleanValue A control parameter that is a boolean.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder booleanValue(java.lang.Boolean booleanValue) {
                this.booleanValue = booleanValue;
                return this;
            }

            /**
             * Sets the value of {@link ParameterValueProperty#getBooleanValue}
             * @param booleanValue A control parameter that is a boolean.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder booleanValue(software.amazon.awscdk.IResolvable booleanValue) {
                this.booleanValue = booleanValue;
                return this;
            }

            /**
             * Sets the value of {@link ParameterValueProperty#getDoubleValue}
             * @param doubleValue A control parameter that is a double.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder doubleValue(java.lang.Number doubleValue) {
                this.doubleValue = doubleValue;
                return this;
            }

            /**
             * Sets the value of {@link ParameterValueProperty#getEnumValue}
             * @param enumValue A control parameter that is an enum.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder enumValue(java.lang.String enumValue) {
                this.enumValue = enumValue;
                return this;
            }

            /**
             * Sets the value of {@link ParameterValueProperty#getEnumList}
             * @param enumList A control parameter that is a list of enums.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder enumList(java.util.List<java.lang.String> enumList) {
                this.enumList = enumList;
                return this;
            }

            /**
             * Sets the value of {@link ParameterValueProperty#getInteger}
             * @param integer A control parameter that is an integer.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder integer(java.lang.Number integer) {
                this.integer = integer;
                return this;
            }

            /**
             * Sets the value of {@link ParameterValueProperty#getIntegerList}
             * @param integerList A control parameter that is a list of integers.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder integerList(java.util.List<? extends java.lang.Number> integerList) {
                this.integerList = integerList;
                return this;
            }

            /**
             * Sets the value of {@link ParameterValueProperty#getIntegerList}
             * @param integerList A control parameter that is a list of integers.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder integerList(software.amazon.awscdk.IResolvable integerList) {
                this.integerList = integerList;
                return this;
            }

            /**
             * Sets the value of {@link ParameterValueProperty#getString}
             * @param string A control parameter that is a string.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder string(java.lang.String string) {
                this.string = string;
                return this;
            }

            /**
             * Sets the value of {@link ParameterValueProperty#getStringList}
             * @param stringList A control parameter that is a list of strings.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder stringList(java.util.List<java.lang.String> stringList) {
                this.stringList = stringList;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ParameterValueProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ParameterValueProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ParameterValueProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ParameterValueProperty {
            private final java.lang.Object booleanValue;
            private final java.lang.Number doubleValue;
            private final java.lang.String enumValue;
            private final java.util.List<java.lang.String> enumList;
            private final java.lang.Number integer;
            private final java.lang.Object integerList;
            private final java.lang.String string;
            private final java.util.List<java.lang.String> stringList;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.booleanValue = software.amazon.jsii.Kernel.get(this, "boolean", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.doubleValue = software.amazon.jsii.Kernel.get(this, "double", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.enumValue = software.amazon.jsii.Kernel.get(this, "enum", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.enumList = software.amazon.jsii.Kernel.get(this, "enumList", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.integer = software.amazon.jsii.Kernel.get(this, "integer", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.integerList = software.amazon.jsii.Kernel.get(this, "integerList", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.string = software.amazon.jsii.Kernel.get(this, "string", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.stringList = software.amazon.jsii.Kernel.get(this, "stringList", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.booleanValue = builder.booleanValue;
                this.doubleValue = builder.doubleValue;
                this.enumValue = builder.enumValue;
                this.enumList = builder.enumList;
                this.integer = builder.integer;
                this.integerList = builder.integerList;
                this.string = builder.string;
                this.stringList = builder.stringList;
            }

            @Override
            public final java.lang.Object getBooleanValue() {
                return this.booleanValue;
            }

            @Override
            public final java.lang.Number getDoubleValue() {
                return this.doubleValue;
            }

            @Override
            public final java.lang.String getEnumValue() {
                return this.enumValue;
            }

            @Override
            public final java.util.List<java.lang.String> getEnumList() {
                return this.enumList;
            }

            @Override
            public final java.lang.Number getInteger() {
                return this.integer;
            }

            @Override
            public final java.lang.Object getIntegerList() {
                return this.integerList;
            }

            @Override
            public final java.lang.String getString() {
                return this.string;
            }

            @Override
            public final java.util.List<java.lang.String> getStringList() {
                return this.stringList;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getBooleanValue() != null) {
                    data.set("boolean", om.valueToTree(this.getBooleanValue()));
                }
                if (this.getDoubleValue() != null) {
                    data.set("double", om.valueToTree(this.getDoubleValue()));
                }
                if (this.getEnumValue() != null) {
                    data.set("enum", om.valueToTree(this.getEnumValue()));
                }
                if (this.getEnumList() != null) {
                    data.set("enumList", om.valueToTree(this.getEnumList()));
                }
                if (this.getInteger() != null) {
                    data.set("integer", om.valueToTree(this.getInteger()));
                }
                if (this.getIntegerList() != null) {
                    data.set("integerList", om.valueToTree(this.getIntegerList()));
                }
                if (this.getString() != null) {
                    data.set("string", om.valueToTree(this.getString()));
                }
                if (this.getStringList() != null) {
                    data.set("stringList", om.valueToTree(this.getStringList()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_securityhub.CfnConfigurationPolicy.ParameterValueProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ParameterValueProperty.Jsii$Proxy that = (ParameterValueProperty.Jsii$Proxy) o;

                if (this.booleanValue != null ? !this.booleanValue.equals(that.booleanValue) : that.booleanValue != null) return false;
                if (this.doubleValue != null ? !this.doubleValue.equals(that.doubleValue) : that.doubleValue != null) return false;
                if (this.enumValue != null ? !this.enumValue.equals(that.enumValue) : that.enumValue != null) return false;
                if (this.enumList != null ? !this.enumList.equals(that.enumList) : that.enumList != null) return false;
                if (this.integer != null ? !this.integer.equals(that.integer) : that.integer != null) return false;
                if (this.integerList != null ? !this.integerList.equals(that.integerList) : that.integerList != null) return false;
                if (this.string != null ? !this.string.equals(that.string) : that.string != null) return false;
                return this.stringList != null ? this.stringList.equals(that.stringList) : that.stringList == null;
            }

            @Override
            public final int hashCode() {
                int result = this.booleanValue != null ? this.booleanValue.hashCode() : 0;
                result = 31 * result + (this.doubleValue != null ? this.doubleValue.hashCode() : 0);
                result = 31 * result + (this.enumValue != null ? this.enumValue.hashCode() : 0);
                result = 31 * result + (this.enumList != null ? this.enumList.hashCode() : 0);
                result = 31 * result + (this.integer != null ? this.integer.hashCode() : 0);
                result = 31 * result + (this.integerList != null ? this.integerList.hashCode() : 0);
                result = 31 * result + (this.string != null ? this.string.hashCode() : 0);
                result = 31 * result + (this.stringList != null ? this.stringList.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * An object that defines how AWS Security Hub is configured.
     * <p>
     * It includes whether Security Hub is enabled or disabled, a list of enabled security standards, a list of enabled or disabled security controls, and a list of custom parameter values for specified controls. If you provide a list of security controls that are enabled in the configuration policy, Security Hub disables all other controls (including newly released controls). If you provide a list of security controls that are disabled in the configuration policy, Security Hub enables all other controls (including newly released controls).
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.securityhub.*;
     * PolicyProperty policyProperty = PolicyProperty.builder()
     *         .securityHub(SecurityHubPolicyProperty.builder()
     *                 .enabledStandardIdentifiers(List.of("enabledStandardIdentifiers"))
     *                 .securityControlsConfiguration(SecurityControlsConfigurationProperty.builder()
     *                         .disabledSecurityControlIdentifiers(List.of("disabledSecurityControlIdentifiers"))
     *                         .enabledSecurityControlIdentifiers(List.of("enabledSecurityControlIdentifiers"))
     *                         .securityControlCustomParameters(List.of(SecurityControlCustomParameterProperty.builder()
     *                                 .parameters(Map.of(
     *                                         "parametersKey", ParameterConfigurationProperty.builder()
     *                                                 .valueType("valueType")
     *                                                 // the properties below are optional
     *                                                 .value(ParameterValueProperty.builder()
     *                                                         .boolean(false)
     *                                                         .double(123)
     *                                                         .enum("enum")
     *                                                         .enumList(List.of("enumList"))
     *                                                         .integer(123)
     *                                                         .integerList(List.of(123))
     *                                                         .string("string")
     *                                                         .stringList(List.of("stringList"))
     *                                                         .build())
     *                                                 .build()))
     *                                 .securityControlId("securityControlId")
     *                                 .build()))
     *                         .build())
     *                 .serviceEnabled(false)
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-configurationpolicy-policy.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-configurationpolicy-policy.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_securityhub.CfnConfigurationPolicy.PolicyProperty")
    @software.amazon.jsii.Jsii.Proxy(PolicyProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface PolicyProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The AWS service that the configuration policy applies to.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-configurationpolicy-policy.html#cfn-securityhub-configurationpolicy-policy-securityhub">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-configurationpolicy-policy.html#cfn-securityhub-configurationpolicy-policy-securityhub</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getSecurityHub() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link PolicyProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link PolicyProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<PolicyProperty> {
            java.lang.Object securityHub;

            /**
             * Sets the value of {@link PolicyProperty#getSecurityHub}
             * @param securityHub The AWS service that the configuration policy applies to.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder securityHub(software.amazon.awscdk.IResolvable securityHub) {
                this.securityHub = securityHub;
                return this;
            }

            /**
             * Sets the value of {@link PolicyProperty#getSecurityHub}
             * @param securityHub The AWS service that the configuration policy applies to.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder securityHub(software.amazon.awscdk.services.securityhub.CfnConfigurationPolicy.SecurityHubPolicyProperty securityHub) {
                this.securityHub = securityHub;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link PolicyProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public PolicyProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link PolicyProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements PolicyProperty {
            private final java.lang.Object securityHub;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.securityHub = software.amazon.jsii.Kernel.get(this, "securityHub", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.securityHub = builder.securityHub;
            }

            @Override
            public final java.lang.Object getSecurityHub() {
                return this.securityHub;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getSecurityHub() != null) {
                    data.set("securityHub", om.valueToTree(this.getSecurityHub()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_securityhub.CfnConfigurationPolicy.PolicyProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                PolicyProperty.Jsii$Proxy that = (PolicyProperty.Jsii$Proxy) o;

                return this.securityHub != null ? this.securityHub.equals(that.securityHub) : that.securityHub == null;
            }

            @Override
            public final int hashCode() {
                int result = this.securityHub != null ? this.securityHub.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * A list of security controls and control parameter values that are included in a configuration policy.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.securityhub.*;
     * SecurityControlCustomParameterProperty securityControlCustomParameterProperty = SecurityControlCustomParameterProperty.builder()
     *         .parameters(Map.of(
     *                 "parametersKey", ParameterConfigurationProperty.builder()
     *                         .valueType("valueType")
     *                         // the properties below are optional
     *                         .value(ParameterValueProperty.builder()
     *                                 .boolean(false)
     *                                 .double(123)
     *                                 .enum("enum")
     *                                 .enumList(List.of("enumList"))
     *                                 .integer(123)
     *                                 .integerList(List.of(123))
     *                                 .string("string")
     *                                 .stringList(List.of("stringList"))
     *                                 .build())
     *                         .build()))
     *         .securityControlId("securityControlId")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-configurationpolicy-securitycontrolcustomparameter.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-configurationpolicy-securitycontrolcustomparameter.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_securityhub.CfnConfigurationPolicy.SecurityControlCustomParameterProperty")
    @software.amazon.jsii.Jsii.Proxy(SecurityControlCustomParameterProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface SecurityControlCustomParameterProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * An object that specifies parameter values for a control in a configuration policy.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-configurationpolicy-securitycontrolcustomparameter.html#cfn-securityhub-configurationpolicy-securitycontrolcustomparameter-parameters">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-configurationpolicy-securitycontrolcustomparameter.html#cfn-securityhub-configurationpolicy-securitycontrolcustomparameter-parameters</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getParameters() {
            return null;
        }

        /**
         * The ID of the security control.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-configurationpolicy-securitycontrolcustomparameter.html#cfn-securityhub-configurationpolicy-securitycontrolcustomparameter-securitycontrolid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-configurationpolicy-securitycontrolcustomparameter.html#cfn-securityhub-configurationpolicy-securitycontrolcustomparameter-securitycontrolid</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getSecurityControlId() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link SecurityControlCustomParameterProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link SecurityControlCustomParameterProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<SecurityControlCustomParameterProperty> {
            java.lang.Object parameters;
            java.lang.String securityControlId;

            /**
             * Sets the value of {@link SecurityControlCustomParameterProperty#getParameters}
             * @param parameters An object that specifies parameter values for a control in a configuration policy.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder parameters(software.amazon.awscdk.IResolvable parameters) {
                this.parameters = parameters;
                return this;
            }

            /**
             * Sets the value of {@link SecurityControlCustomParameterProperty#getParameters}
             * @param parameters An object that specifies parameter values for a control in a configuration policy.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder parameters(java.util.Map<java.lang.String, ? extends java.lang.Object> parameters) {
                this.parameters = parameters;
                return this;
            }

            /**
             * Sets the value of {@link SecurityControlCustomParameterProperty#getSecurityControlId}
             * @param securityControlId The ID of the security control.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder securityControlId(java.lang.String securityControlId) {
                this.securityControlId = securityControlId;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link SecurityControlCustomParameterProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public SecurityControlCustomParameterProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link SecurityControlCustomParameterProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SecurityControlCustomParameterProperty {
            private final java.lang.Object parameters;
            private final java.lang.String securityControlId;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.parameters = software.amazon.jsii.Kernel.get(this, "parameters", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.securityControlId = software.amazon.jsii.Kernel.get(this, "securityControlId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.parameters = builder.parameters;
                this.securityControlId = builder.securityControlId;
            }

            @Override
            public final java.lang.Object getParameters() {
                return this.parameters;
            }

            @Override
            public final java.lang.String getSecurityControlId() {
                return this.securityControlId;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getParameters() != null) {
                    data.set("parameters", om.valueToTree(this.getParameters()));
                }
                if (this.getSecurityControlId() != null) {
                    data.set("securityControlId", om.valueToTree(this.getSecurityControlId()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_securityhub.CfnConfigurationPolicy.SecurityControlCustomParameterProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                SecurityControlCustomParameterProperty.Jsii$Proxy that = (SecurityControlCustomParameterProperty.Jsii$Proxy) o;

                if (this.parameters != null ? !this.parameters.equals(that.parameters) : that.parameters != null) return false;
                return this.securityControlId != null ? this.securityControlId.equals(that.securityControlId) : that.securityControlId == null;
            }

            @Override
            public final int hashCode() {
                int result = this.parameters != null ? this.parameters.hashCode() : 0;
                result = 31 * result + (this.securityControlId != null ? this.securityControlId.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * An object that defines which security controls are enabled in an AWS Security Hub configuration policy.
     * <p>
     * The enablement status of a control is aligned across all of the enabled standards in an account.
     * <p>
     * This property is required only if <code>ServiceEnabled</code> is set to <code>true</code> in your configuration policy.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.securityhub.*;
     * SecurityControlsConfigurationProperty securityControlsConfigurationProperty = SecurityControlsConfigurationProperty.builder()
     *         .disabledSecurityControlIdentifiers(List.of("disabledSecurityControlIdentifiers"))
     *         .enabledSecurityControlIdentifiers(List.of("enabledSecurityControlIdentifiers"))
     *         .securityControlCustomParameters(List.of(SecurityControlCustomParameterProperty.builder()
     *                 .parameters(Map.of(
     *                         "parametersKey", ParameterConfigurationProperty.builder()
     *                                 .valueType("valueType")
     *                                 // the properties below are optional
     *                                 .value(ParameterValueProperty.builder()
     *                                         .boolean(false)
     *                                         .double(123)
     *                                         .enum("enum")
     *                                         .enumList(List.of("enumList"))
     *                                         .integer(123)
     *                                         .integerList(List.of(123))
     *                                         .string("string")
     *                                         .stringList(List.of("stringList"))
     *                                         .build())
     *                                 .build()))
     *                 .securityControlId("securityControlId")
     *                 .build()))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-configurationpolicy-securitycontrolsconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-configurationpolicy-securitycontrolsconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_securityhub.CfnConfigurationPolicy.SecurityControlsConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(SecurityControlsConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface SecurityControlsConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * A list of security controls that are disabled in the configuration policy.
         * <p>
         * Provide only one of <code>EnabledSecurityControlIdentifiers</code> or <code>DisabledSecurityControlIdentifiers</code> .
         * <p>
         * If you provide <code>DisabledSecurityControlIdentifiers</code> , Security Hub enables all other controls not in the list, and enables <a href="https://docs.aws.amazon.com/securityhub/1.0/APIReference/API_UpdateSecurityHubConfiguration.html#securityhub-UpdateSecurityHubConfiguration-request-AutoEnableControls">AutoEnableControls</a> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-configurationpolicy-securitycontrolsconfiguration.html#cfn-securityhub-configurationpolicy-securitycontrolsconfiguration-disabledsecuritycontrolidentifiers">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-configurationpolicy-securitycontrolsconfiguration.html#cfn-securityhub-configurationpolicy-securitycontrolsconfiguration-disabledsecuritycontrolidentifiers</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getDisabledSecurityControlIdentifiers() {
            return null;
        }

        /**
         * A list of security controls that are enabled in the configuration policy.
         * <p>
         * Provide only one of <code>EnabledSecurityControlIdentifiers</code> or <code>DisabledSecurityControlIdentifiers</code> .
         * <p>
         * If you provide <code>EnabledSecurityControlIdentifiers</code> , Security Hub disables all other controls not in the list, and disables <a href="https://docs.aws.amazon.com/securityhub/1.0/APIReference/API_UpdateSecurityHubConfiguration.html#securityhub-UpdateSecurityHubConfiguration-request-AutoEnableControls">AutoEnableControls</a> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-configurationpolicy-securitycontrolsconfiguration.html#cfn-securityhub-configurationpolicy-securitycontrolsconfiguration-enabledsecuritycontrolidentifiers">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-configurationpolicy-securitycontrolsconfiguration.html#cfn-securityhub-configurationpolicy-securitycontrolsconfiguration-enabledsecuritycontrolidentifiers</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getEnabledSecurityControlIdentifiers() {
            return null;
        }

        /**
         * A list of security controls and control parameter values that are included in a configuration policy.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-configurationpolicy-securitycontrolsconfiguration.html#cfn-securityhub-configurationpolicy-securitycontrolsconfiguration-securitycontrolcustomparameters">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-configurationpolicy-securitycontrolsconfiguration.html#cfn-securityhub-configurationpolicy-securitycontrolsconfiguration-securitycontrolcustomparameters</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getSecurityControlCustomParameters() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link SecurityControlsConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link SecurityControlsConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<SecurityControlsConfigurationProperty> {
            java.util.List<java.lang.String> disabledSecurityControlIdentifiers;
            java.util.List<java.lang.String> enabledSecurityControlIdentifiers;
            java.lang.Object securityControlCustomParameters;

            /**
             * Sets the value of {@link SecurityControlsConfigurationProperty#getDisabledSecurityControlIdentifiers}
             * @param disabledSecurityControlIdentifiers A list of security controls that are disabled in the configuration policy.
             *                                           Provide only one of <code>EnabledSecurityControlIdentifiers</code> or <code>DisabledSecurityControlIdentifiers</code> .
             *                                           <p>
             *                                           If you provide <code>DisabledSecurityControlIdentifiers</code> , Security Hub enables all other controls not in the list, and enables <a href="https://docs.aws.amazon.com/securityhub/1.0/APIReference/API_UpdateSecurityHubConfiguration.html#securityhub-UpdateSecurityHubConfiguration-request-AutoEnableControls">AutoEnableControls</a> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder disabledSecurityControlIdentifiers(java.util.List<java.lang.String> disabledSecurityControlIdentifiers) {
                this.disabledSecurityControlIdentifiers = disabledSecurityControlIdentifiers;
                return this;
            }

            /**
             * Sets the value of {@link SecurityControlsConfigurationProperty#getEnabledSecurityControlIdentifiers}
             * @param enabledSecurityControlIdentifiers A list of security controls that are enabled in the configuration policy.
             *                                          Provide only one of <code>EnabledSecurityControlIdentifiers</code> or <code>DisabledSecurityControlIdentifiers</code> .
             *                                          <p>
             *                                          If you provide <code>EnabledSecurityControlIdentifiers</code> , Security Hub disables all other controls not in the list, and disables <a href="https://docs.aws.amazon.com/securityhub/1.0/APIReference/API_UpdateSecurityHubConfiguration.html#securityhub-UpdateSecurityHubConfiguration-request-AutoEnableControls">AutoEnableControls</a> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder enabledSecurityControlIdentifiers(java.util.List<java.lang.String> enabledSecurityControlIdentifiers) {
                this.enabledSecurityControlIdentifiers = enabledSecurityControlIdentifiers;
                return this;
            }

            /**
             * Sets the value of {@link SecurityControlsConfigurationProperty#getSecurityControlCustomParameters}
             * @param securityControlCustomParameters A list of security controls and control parameter values that are included in a configuration policy.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder securityControlCustomParameters(software.amazon.awscdk.IResolvable securityControlCustomParameters) {
                this.securityControlCustomParameters = securityControlCustomParameters;
                return this;
            }

            /**
             * Sets the value of {@link SecurityControlsConfigurationProperty#getSecurityControlCustomParameters}
             * @param securityControlCustomParameters A list of security controls and control parameter values that are included in a configuration policy.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder securityControlCustomParameters(java.util.List<? extends java.lang.Object> securityControlCustomParameters) {
                this.securityControlCustomParameters = securityControlCustomParameters;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link SecurityControlsConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public SecurityControlsConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link SecurityControlsConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SecurityControlsConfigurationProperty {
            private final java.util.List<java.lang.String> disabledSecurityControlIdentifiers;
            private final java.util.List<java.lang.String> enabledSecurityControlIdentifiers;
            private final java.lang.Object securityControlCustomParameters;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.disabledSecurityControlIdentifiers = software.amazon.jsii.Kernel.get(this, "disabledSecurityControlIdentifiers", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.enabledSecurityControlIdentifiers = software.amazon.jsii.Kernel.get(this, "enabledSecurityControlIdentifiers", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.securityControlCustomParameters = software.amazon.jsii.Kernel.get(this, "securityControlCustomParameters", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.disabledSecurityControlIdentifiers = builder.disabledSecurityControlIdentifiers;
                this.enabledSecurityControlIdentifiers = builder.enabledSecurityControlIdentifiers;
                this.securityControlCustomParameters = builder.securityControlCustomParameters;
            }

            @Override
            public final java.util.List<java.lang.String> getDisabledSecurityControlIdentifiers() {
                return this.disabledSecurityControlIdentifiers;
            }

            @Override
            public final java.util.List<java.lang.String> getEnabledSecurityControlIdentifiers() {
                return this.enabledSecurityControlIdentifiers;
            }

            @Override
            public final java.lang.Object getSecurityControlCustomParameters() {
                return this.securityControlCustomParameters;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getDisabledSecurityControlIdentifiers() != null) {
                    data.set("disabledSecurityControlIdentifiers", om.valueToTree(this.getDisabledSecurityControlIdentifiers()));
                }
                if (this.getEnabledSecurityControlIdentifiers() != null) {
                    data.set("enabledSecurityControlIdentifiers", om.valueToTree(this.getEnabledSecurityControlIdentifiers()));
                }
                if (this.getSecurityControlCustomParameters() != null) {
                    data.set("securityControlCustomParameters", om.valueToTree(this.getSecurityControlCustomParameters()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_securityhub.CfnConfigurationPolicy.SecurityControlsConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                SecurityControlsConfigurationProperty.Jsii$Proxy that = (SecurityControlsConfigurationProperty.Jsii$Proxy) o;

                if (this.disabledSecurityControlIdentifiers != null ? !this.disabledSecurityControlIdentifiers.equals(that.disabledSecurityControlIdentifiers) : that.disabledSecurityControlIdentifiers != null) return false;
                if (this.enabledSecurityControlIdentifiers != null ? !this.enabledSecurityControlIdentifiers.equals(that.enabledSecurityControlIdentifiers) : that.enabledSecurityControlIdentifiers != null) return false;
                return this.securityControlCustomParameters != null ? this.securityControlCustomParameters.equals(that.securityControlCustomParameters) : that.securityControlCustomParameters == null;
            }

            @Override
            public final int hashCode() {
                int result = this.disabledSecurityControlIdentifiers != null ? this.disabledSecurityControlIdentifiers.hashCode() : 0;
                result = 31 * result + (this.enabledSecurityControlIdentifiers != null ? this.enabledSecurityControlIdentifiers.hashCode() : 0);
                result = 31 * result + (this.securityControlCustomParameters != null ? this.securityControlCustomParameters.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * An object that defines how AWS Security Hub is configured.
     * <p>
     * The configuration policy includes whether Security Hub is enabled or disabled, a list of enabled security standards, a list of enabled or disabled security controls, and a list of custom parameter values for specified controls. If you provide a list of security controls that are enabled in the configuration policy, Security Hub disables all other controls (including newly released controls). If you provide a list of security controls that are disabled in the configuration policy, Security Hub enables all other controls (including newly released controls).
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.securityhub.*;
     * SecurityHubPolicyProperty securityHubPolicyProperty = SecurityHubPolicyProperty.builder()
     *         .enabledStandardIdentifiers(List.of("enabledStandardIdentifiers"))
     *         .securityControlsConfiguration(SecurityControlsConfigurationProperty.builder()
     *                 .disabledSecurityControlIdentifiers(List.of("disabledSecurityControlIdentifiers"))
     *                 .enabledSecurityControlIdentifiers(List.of("enabledSecurityControlIdentifiers"))
     *                 .securityControlCustomParameters(List.of(SecurityControlCustomParameterProperty.builder()
     *                         .parameters(Map.of(
     *                                 "parametersKey", ParameterConfigurationProperty.builder()
     *                                         .valueType("valueType")
     *                                         // the properties below are optional
     *                                         .value(ParameterValueProperty.builder()
     *                                                 .boolean(false)
     *                                                 .double(123)
     *                                                 .enum("enum")
     *                                                 .enumList(List.of("enumList"))
     *                                                 .integer(123)
     *                                                 .integerList(List.of(123))
     *                                                 .string("string")
     *                                                 .stringList(List.of("stringList"))
     *                                                 .build())
     *                                         .build()))
     *                         .securityControlId("securityControlId")
     *                         .build()))
     *                 .build())
     *         .serviceEnabled(false)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-configurationpolicy-securityhubpolicy.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-configurationpolicy-securityhubpolicy.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_securityhub.CfnConfigurationPolicy.SecurityHubPolicyProperty")
    @software.amazon.jsii.Jsii.Proxy(SecurityHubPolicyProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface SecurityHubPolicyProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * A list that defines which security standards are enabled in the configuration policy.
         * <p>
         * This property is required only if <code>ServiceEnabled</code> is set to <code>true</code> in your configuration policy.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-configurationpolicy-securityhubpolicy.html#cfn-securityhub-configurationpolicy-securityhubpolicy-enabledstandardidentifiers">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-configurationpolicy-securityhubpolicy.html#cfn-securityhub-configurationpolicy-securityhubpolicy-enabledstandardidentifiers</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getEnabledStandardIdentifiers() {
            return null;
        }

        /**
         * An object that defines which security controls are enabled in the configuration policy.
         * <p>
         * The enablement status of a control is aligned across all of the enabled standards in an account.
         * <p>
         * This property is required only if <code>ServiceEnabled</code> is set to true in your configuration policy.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-configurationpolicy-securityhubpolicy.html#cfn-securityhub-configurationpolicy-securityhubpolicy-securitycontrolsconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-configurationpolicy-securityhubpolicy.html#cfn-securityhub-configurationpolicy-securityhubpolicy-securitycontrolsconfiguration</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getSecurityControlsConfiguration() {
            return null;
        }

        /**
         * Indicates whether Security Hub is enabled in the policy.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-configurationpolicy-securityhubpolicy.html#cfn-securityhub-configurationpolicy-securityhubpolicy-serviceenabled">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-configurationpolicy-securityhubpolicy.html#cfn-securityhub-configurationpolicy-securityhubpolicy-serviceenabled</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getServiceEnabled() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link SecurityHubPolicyProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link SecurityHubPolicyProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<SecurityHubPolicyProperty> {
            java.util.List<java.lang.String> enabledStandardIdentifiers;
            java.lang.Object securityControlsConfiguration;
            java.lang.Object serviceEnabled;

            /**
             * Sets the value of {@link SecurityHubPolicyProperty#getEnabledStandardIdentifiers}
             * @param enabledStandardIdentifiers A list that defines which security standards are enabled in the configuration policy.
             *                                   This property is required only if <code>ServiceEnabled</code> is set to <code>true</code> in your configuration policy.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder enabledStandardIdentifiers(java.util.List<java.lang.String> enabledStandardIdentifiers) {
                this.enabledStandardIdentifiers = enabledStandardIdentifiers;
                return this;
            }

            /**
             * Sets the value of {@link SecurityHubPolicyProperty#getSecurityControlsConfiguration}
             * @param securityControlsConfiguration An object that defines which security controls are enabled in the configuration policy.
             *                                      The enablement status of a control is aligned across all of the enabled standards in an account.
             *                                      <p>
             *                                      This property is required only if <code>ServiceEnabled</code> is set to true in your configuration policy.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder securityControlsConfiguration(software.amazon.awscdk.IResolvable securityControlsConfiguration) {
                this.securityControlsConfiguration = securityControlsConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link SecurityHubPolicyProperty#getSecurityControlsConfiguration}
             * @param securityControlsConfiguration An object that defines which security controls are enabled in the configuration policy.
             *                                      The enablement status of a control is aligned across all of the enabled standards in an account.
             *                                      <p>
             *                                      This property is required only if <code>ServiceEnabled</code> is set to true in your configuration policy.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder securityControlsConfiguration(software.amazon.awscdk.services.securityhub.CfnConfigurationPolicy.SecurityControlsConfigurationProperty securityControlsConfiguration) {
                this.securityControlsConfiguration = securityControlsConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link SecurityHubPolicyProperty#getServiceEnabled}
             * @param serviceEnabled Indicates whether Security Hub is enabled in the policy.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder serviceEnabled(java.lang.Boolean serviceEnabled) {
                this.serviceEnabled = serviceEnabled;
                return this;
            }

            /**
             * Sets the value of {@link SecurityHubPolicyProperty#getServiceEnabled}
             * @param serviceEnabled Indicates whether Security Hub is enabled in the policy.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder serviceEnabled(software.amazon.awscdk.IResolvable serviceEnabled) {
                this.serviceEnabled = serviceEnabled;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link SecurityHubPolicyProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public SecurityHubPolicyProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link SecurityHubPolicyProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SecurityHubPolicyProperty {
            private final java.util.List<java.lang.String> enabledStandardIdentifiers;
            private final java.lang.Object securityControlsConfiguration;
            private final java.lang.Object serviceEnabled;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.enabledStandardIdentifiers = software.amazon.jsii.Kernel.get(this, "enabledStandardIdentifiers", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.securityControlsConfiguration = software.amazon.jsii.Kernel.get(this, "securityControlsConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.serviceEnabled = software.amazon.jsii.Kernel.get(this, "serviceEnabled", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.enabledStandardIdentifiers = builder.enabledStandardIdentifiers;
                this.securityControlsConfiguration = builder.securityControlsConfiguration;
                this.serviceEnabled = builder.serviceEnabled;
            }

            @Override
            public final java.util.List<java.lang.String> getEnabledStandardIdentifiers() {
                return this.enabledStandardIdentifiers;
            }

            @Override
            public final java.lang.Object getSecurityControlsConfiguration() {
                return this.securityControlsConfiguration;
            }

            @Override
            public final java.lang.Object getServiceEnabled() {
                return this.serviceEnabled;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getEnabledStandardIdentifiers() != null) {
                    data.set("enabledStandardIdentifiers", om.valueToTree(this.getEnabledStandardIdentifiers()));
                }
                if (this.getSecurityControlsConfiguration() != null) {
                    data.set("securityControlsConfiguration", om.valueToTree(this.getSecurityControlsConfiguration()));
                }
                if (this.getServiceEnabled() != null) {
                    data.set("serviceEnabled", om.valueToTree(this.getServiceEnabled()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_securityhub.CfnConfigurationPolicy.SecurityHubPolicyProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                SecurityHubPolicyProperty.Jsii$Proxy that = (SecurityHubPolicyProperty.Jsii$Proxy) o;

                if (this.enabledStandardIdentifiers != null ? !this.enabledStandardIdentifiers.equals(that.enabledStandardIdentifiers) : that.enabledStandardIdentifiers != null) return false;
                if (this.securityControlsConfiguration != null ? !this.securityControlsConfiguration.equals(that.securityControlsConfiguration) : that.securityControlsConfiguration != null) return false;
                return this.serviceEnabled != null ? this.serviceEnabled.equals(that.serviceEnabled) : that.serviceEnabled == null;
            }

            @Override
            public final int hashCode() {
                int result = this.enabledStandardIdentifiers != null ? this.enabledStandardIdentifiers.hashCode() : 0;
                result = 31 * result + (this.securityControlsConfiguration != null ? this.securityControlsConfiguration.hashCode() : 0);
                result = 31 * result + (this.serviceEnabled != null ? this.serviceEnabled.hashCode() : 0);
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.securityhub.CfnConfigurationPolicy}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.securityhub.CfnConfigurationPolicy> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope Scope in which this resource is defined. This parameter is required.
         * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.securityhub.CfnConfigurationPolicyProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.securityhub.CfnConfigurationPolicyProps.Builder();
        }

        /**
         * An object that defines how AWS Security Hub is configured.
         * <p>
         * It includes whether Security Hub is enabled or disabled, a list of enabled security standards, a list of enabled or disabled security controls, and a list of custom parameter values for specified controls. If you provide a list of security controls that are enabled in the configuration policy, Security Hub disables all other controls (including newly released controls). If you provide a list of security controls that are disabled in the configuration policy, Security Hub enables all other controls (including newly released controls).
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-securityhub-configurationpolicy.html#cfn-securityhub-configurationpolicy-configurationpolicy">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-securityhub-configurationpolicy.html#cfn-securityhub-configurationpolicy-configurationpolicy</a>
         * @param configurationPolicy An object that defines how AWS Security Hub is configured. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder configurationPolicy(final software.amazon.awscdk.IResolvable configurationPolicy) {
            this.props.configurationPolicy(configurationPolicy);
            return this;
        }
        /**
         * An object that defines how AWS Security Hub is configured.
         * <p>
         * It includes whether Security Hub is enabled or disabled, a list of enabled security standards, a list of enabled or disabled security controls, and a list of custom parameter values for specified controls. If you provide a list of security controls that are enabled in the configuration policy, Security Hub disables all other controls (including newly released controls). If you provide a list of security controls that are disabled in the configuration policy, Security Hub enables all other controls (including newly released controls).
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-securityhub-configurationpolicy.html#cfn-securityhub-configurationpolicy-configurationpolicy">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-securityhub-configurationpolicy.html#cfn-securityhub-configurationpolicy-configurationpolicy</a>
         * @param configurationPolicy An object that defines how AWS Security Hub is configured. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder configurationPolicy(final software.amazon.awscdk.services.securityhub.CfnConfigurationPolicy.PolicyProperty configurationPolicy) {
            this.props.configurationPolicy(configurationPolicy);
            return this;
        }

        /**
         * The name of the configuration policy.
         * <p>
         * Alphanumeric characters and the following ASCII characters are permitted: <code>-, ., !, *, /</code> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-securityhub-configurationpolicy.html#cfn-securityhub-configurationpolicy-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-securityhub-configurationpolicy.html#cfn-securityhub-configurationpolicy-name</a>
         * @param name The name of the configuration policy. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(final java.lang.String name) {
            this.props.name(name);
            return this;
        }

        /**
         * The description of the configuration policy.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-securityhub-configurationpolicy.html#cfn-securityhub-configurationpolicy-description">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-securityhub-configurationpolicy.html#cfn-securityhub-configurationpolicy-description</a>
         * @param description The description of the configuration policy. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(final java.lang.String description) {
            this.props.description(description);
            return this;
        }

        /**
         * User-defined tags associated with a configuration policy.
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/securityhub/latest/userguide/tagging-resources.html">Tagging AWS Security Hub resources</a> in the <em>Security Hub user guide</em> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-securityhub-configurationpolicy.html#cfn-securityhub-configurationpolicy-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-securityhub-configurationpolicy.html#cfn-securityhub-configurationpolicy-tags</a>
         * @param tags User-defined tags associated with a configuration policy. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(final java.util.Map<java.lang.String, java.lang.String> tags) {
            this.props.tags(tags);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.securityhub.CfnConfigurationPolicy}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.securityhub.CfnConfigurationPolicy build() {
            return new software.amazon.awscdk.services.securityhub.CfnConfigurationPolicy(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
