package software.amazon.awscdk.services.securityhub;

/**
 * Properties for defining a <code>CfnSecurityControl</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.securityhub.*;
 * CfnSecurityControlProps cfnSecurityControlProps = CfnSecurityControlProps.builder()
 *         .parameters(Map.of(
 *                 "parametersKey", ParameterConfigurationProperty.builder()
 *                         .valueType("valueType")
 *                         // the properties below are optional
 *                         .value(ParameterValueProperty.builder()
 *                                 .boolean(false)
 *                                 .double(123)
 *                                 .enum("enum")
 *                                 .enumList(List.of("enumList"))
 *                                 .integer(123)
 *                                 .integerList(List.of(123))
 *                                 .string("string")
 *                                 .stringList(List.of("stringList"))
 *                                 .build())
 *                         .build()))
 *         // the properties below are optional
 *         .lastUpdateReason("lastUpdateReason")
 *         .securityControlArn("securityControlArn")
 *         .securityControlId("securityControlId")
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-securityhub-securitycontrol.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-securityhub-securitycontrol.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-05-20T23:53:03.650Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_securityhub.CfnSecurityControlProps")
@software.amazon.jsii.Jsii.Proxy(CfnSecurityControlProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnSecurityControlProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * An object that identifies the name of a control parameter, its current value, and whether it has been customized.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-securityhub-securitycontrol.html#cfn-securityhub-securitycontrol-parameters">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-securityhub-securitycontrol.html#cfn-securityhub-securitycontrol-parameters</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Object getParameters();

    /**
     * The most recent reason for updating the customizable properties of a security control.
     * <p>
     * This differs from the <code>UpdateReason</code> field of the <a href="https://docs.aws.amazon.com/securityhub/1.0/APIReference/API_BatchUpdateStandardsControlAssociations.html"><code>BatchUpdateStandardsControlAssociations</code></a> API, which tracks the reason for updating the enablement status of a control. This field accepts alphanumeric characters in addition to white spaces, dashes, and underscores.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-securityhub-securitycontrol.html#cfn-securityhub-securitycontrol-lastupdatereason">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-securityhub-securitycontrol.html#cfn-securityhub-securitycontrol-lastupdatereason</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getLastUpdateReason() {
        return null;
    }

    /**
     * The Amazon Resource Name (ARN) for a security control across standards, such as <code>arn:aws:securityhub:eu-central-1:123456789012:security-control/S3.1</code> . This parameter doesn't mention a specific standard.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-securityhub-securitycontrol.html#cfn-securityhub-securitycontrol-securitycontrolarn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-securityhub-securitycontrol.html#cfn-securityhub-securitycontrol-securitycontrolarn</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getSecurityControlArn() {
        return null;
    }

    /**
     * The unique identifier of a security control across standards.
     * <p>
     * Values for this field typically consist of an AWS service name and a number, such as APIGateway.3.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-securityhub-securitycontrol.html#cfn-securityhub-securitycontrol-securitycontrolid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-securityhub-securitycontrol.html#cfn-securityhub-securitycontrol-securitycontrolid</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getSecurityControlId() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnSecurityControlProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnSecurityControlProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnSecurityControlProps> {
        java.lang.Object parameters;
        java.lang.String lastUpdateReason;
        java.lang.String securityControlArn;
        java.lang.String securityControlId;

        /**
         * Sets the value of {@link CfnSecurityControlProps#getParameters}
         * @param parameters An object that identifies the name of a control parameter, its current value, and whether it has been customized. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder parameters(software.amazon.awscdk.IResolvable parameters) {
            this.parameters = parameters;
            return this;
        }

        /**
         * Sets the value of {@link CfnSecurityControlProps#getParameters}
         * @param parameters An object that identifies the name of a control parameter, its current value, and whether it has been customized. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder parameters(java.util.Map<java.lang.String, ? extends java.lang.Object> parameters) {
            this.parameters = parameters;
            return this;
        }

        /**
         * Sets the value of {@link CfnSecurityControlProps#getLastUpdateReason}
         * @param lastUpdateReason The most recent reason for updating the customizable properties of a security control.
         *                         This differs from the <code>UpdateReason</code> field of the <a href="https://docs.aws.amazon.com/securityhub/1.0/APIReference/API_BatchUpdateStandardsControlAssociations.html"><code>BatchUpdateStandardsControlAssociations</code></a> API, which tracks the reason for updating the enablement status of a control. This field accepts alphanumeric characters in addition to white spaces, dashes, and underscores.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder lastUpdateReason(java.lang.String lastUpdateReason) {
            this.lastUpdateReason = lastUpdateReason;
            return this;
        }

        /**
         * Sets the value of {@link CfnSecurityControlProps#getSecurityControlArn}
         * @param securityControlArn The Amazon Resource Name (ARN) for a security control across standards, such as <code>arn:aws:securityhub:eu-central-1:123456789012:security-control/S3.1</code> . This parameter doesn't mention a specific standard.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder securityControlArn(java.lang.String securityControlArn) {
            this.securityControlArn = securityControlArn;
            return this;
        }

        /**
         * Sets the value of {@link CfnSecurityControlProps#getSecurityControlId}
         * @param securityControlId The unique identifier of a security control across standards.
         *                          Values for this field typically consist of an AWS service name and a number, such as APIGateway.3.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder securityControlId(java.lang.String securityControlId) {
            this.securityControlId = securityControlId;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnSecurityControlProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnSecurityControlProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnSecurityControlProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnSecurityControlProps {
        private final java.lang.Object parameters;
        private final java.lang.String lastUpdateReason;
        private final java.lang.String securityControlArn;
        private final java.lang.String securityControlId;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.parameters = software.amazon.jsii.Kernel.get(this, "parameters", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.lastUpdateReason = software.amazon.jsii.Kernel.get(this, "lastUpdateReason", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.securityControlArn = software.amazon.jsii.Kernel.get(this, "securityControlArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.securityControlId = software.amazon.jsii.Kernel.get(this, "securityControlId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.parameters = java.util.Objects.requireNonNull(builder.parameters, "parameters is required");
            this.lastUpdateReason = builder.lastUpdateReason;
            this.securityControlArn = builder.securityControlArn;
            this.securityControlId = builder.securityControlId;
        }

        @Override
        public final java.lang.Object getParameters() {
            return this.parameters;
        }

        @Override
        public final java.lang.String getLastUpdateReason() {
            return this.lastUpdateReason;
        }

        @Override
        public final java.lang.String getSecurityControlArn() {
            return this.securityControlArn;
        }

        @Override
        public final java.lang.String getSecurityControlId() {
            return this.securityControlId;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("parameters", om.valueToTree(this.getParameters()));
            if (this.getLastUpdateReason() != null) {
                data.set("lastUpdateReason", om.valueToTree(this.getLastUpdateReason()));
            }
            if (this.getSecurityControlArn() != null) {
                data.set("securityControlArn", om.valueToTree(this.getSecurityControlArn()));
            }
            if (this.getSecurityControlId() != null) {
                data.set("securityControlId", om.valueToTree(this.getSecurityControlId()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_securityhub.CfnSecurityControlProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnSecurityControlProps.Jsii$Proxy that = (CfnSecurityControlProps.Jsii$Proxy) o;

            if (!parameters.equals(that.parameters)) return false;
            if (this.lastUpdateReason != null ? !this.lastUpdateReason.equals(that.lastUpdateReason) : that.lastUpdateReason != null) return false;
            if (this.securityControlArn != null ? !this.securityControlArn.equals(that.securityControlArn) : that.securityControlArn != null) return false;
            return this.securityControlId != null ? this.securityControlId.equals(that.securityControlId) : that.securityControlId == null;
        }

        @Override
        public final int hashCode() {
            int result = this.parameters.hashCode();
            result = 31 * result + (this.lastUpdateReason != null ? this.lastUpdateReason.hashCode() : 0);
            result = 31 * result + (this.securityControlArn != null ? this.securityControlArn.hashCode() : 0);
            result = 31 * result + (this.securityControlId != null ? this.securityControlId.hashCode() : 0);
            return result;
        }
    }
}
