package software.amazon.awscdk.services.securityhub;

/**
 * Properties for defining a <code>CfnStandard</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.securityhub.*;
 * CfnStandardProps cfnStandardProps = CfnStandardProps.builder()
 *         .standardsArn("standardsArn")
 *         // the properties below are optional
 *         .disabledStandardsControls(List.of(StandardsControlProperty.builder()
 *                 .standardsControlArn("standardsControlArn")
 *                 // the properties below are optional
 *                 .reason("reason")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-securityhub-standard.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-securityhub-standard.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-05-20T23:53:03.652Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_securityhub.CfnStandardProps")
@software.amazon.jsii.Jsii.Proxy(CfnStandardProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnStandardProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The ARN of the standard that you want to enable.
     * <p>
     * To view a list of available Security Hub standards and their ARNs, use the <a href="https://docs.aws.amazon.com/securityhub/1.0/APIReference/API_DescribeStandards.html"><code>DescribeStandards</code></a> API operation.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-securityhub-standard.html#cfn-securityhub-standard-standardsarn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-securityhub-standard.html#cfn-securityhub-standard-standardsarn</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getStandardsArn();

    /**
     * Specifies which controls are to be disabled in a standard.
     * <p>
     * <em>Maximum</em> : <code>100</code>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-securityhub-standard.html#cfn-securityhub-standard-disabledstandardscontrols">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-securityhub-standard.html#cfn-securityhub-standard-disabledstandardscontrols</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getDisabledStandardsControls() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnStandardProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnStandardProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnStandardProps> {
        java.lang.String standardsArn;
        java.lang.Object disabledStandardsControls;

        /**
         * Sets the value of {@link CfnStandardProps#getStandardsArn}
         * @param standardsArn The ARN of the standard that you want to enable. This parameter is required.
         *                     To view a list of available Security Hub standards and their ARNs, use the <a href="https://docs.aws.amazon.com/securityhub/1.0/APIReference/API_DescribeStandards.html"><code>DescribeStandards</code></a> API operation.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder standardsArn(java.lang.String standardsArn) {
            this.standardsArn = standardsArn;
            return this;
        }

        /**
         * Sets the value of {@link CfnStandardProps#getDisabledStandardsControls}
         * @param disabledStandardsControls Specifies which controls are to be disabled in a standard.
         *                                  <em>Maximum</em> : <code>100</code>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder disabledStandardsControls(software.amazon.awscdk.IResolvable disabledStandardsControls) {
            this.disabledStandardsControls = disabledStandardsControls;
            return this;
        }

        /**
         * Sets the value of {@link CfnStandardProps#getDisabledStandardsControls}
         * @param disabledStandardsControls Specifies which controls are to be disabled in a standard.
         *                                  <em>Maximum</em> : <code>100</code>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder disabledStandardsControls(java.util.List<? extends java.lang.Object> disabledStandardsControls) {
            this.disabledStandardsControls = disabledStandardsControls;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnStandardProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnStandardProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnStandardProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnStandardProps {
        private final java.lang.String standardsArn;
        private final java.lang.Object disabledStandardsControls;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.standardsArn = software.amazon.jsii.Kernel.get(this, "standardsArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.disabledStandardsControls = software.amazon.jsii.Kernel.get(this, "disabledStandardsControls", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.standardsArn = java.util.Objects.requireNonNull(builder.standardsArn, "standardsArn is required");
            this.disabledStandardsControls = builder.disabledStandardsControls;
        }

        @Override
        public final java.lang.String getStandardsArn() {
            return this.standardsArn;
        }

        @Override
        public final java.lang.Object getDisabledStandardsControls() {
            return this.disabledStandardsControls;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("standardsArn", om.valueToTree(this.getStandardsArn()));
            if (this.getDisabledStandardsControls() != null) {
                data.set("disabledStandardsControls", om.valueToTree(this.getDisabledStandardsControls()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_securityhub.CfnStandardProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnStandardProps.Jsii$Proxy that = (CfnStandardProps.Jsii$Proxy) o;

            if (!standardsArn.equals(that.standardsArn)) return false;
            return this.disabledStandardsControls != null ? this.disabledStandardsControls.equals(that.disabledStandardsControls) : that.disabledStandardsControls == null;
        }

        @Override
        public final int hashCode() {
            int result = this.standardsArn.hashCode();
            result = 31 * result + (this.disabledStandardsControls != null ? this.disabledStandardsControls.hashCode() : 0);
            return result;
        }
    }
}
