package software.amazon.awscdk.services.servicecatalog;

/**
 * Properties for deploying with Stackset, which creates a StackSet constraint.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Portfolio portfolio;
 * CloudFormationProduct product;
 * Role adminRole = Role.Builder.create(this, "AdminRole")
 *         .assumedBy(new AccountRootPrincipal())
 *         .build();
 * portfolio.deployWithStackSets(product, StackSetsConstraintOptions.builder()
 *         .accounts(List.of("012345678901", "012345678902", "012345678903"))
 *         .regions(List.of("us-west-1", "us-east-1", "us-west-2", "us-east-1"))
 *         .adminRole(adminRole)
 *         .executionRoleName("SCStackSetExecutionRole") // Name of role deployed in end users accounts.
 *         .allowStackSetInstanceOperations(true)
 *         .build());
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-05-20T23:53:03.738Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_servicecatalog.StackSetsConstraintOptions")
@software.amazon.jsii.Jsii.Proxy(StackSetsConstraintOptions.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface StackSetsConstraintOptions extends software.amazon.jsii.JsiiSerializable, software.amazon.awscdk.services.servicecatalog.CommonConstraintOptions {

    /**
     * List of accounts to deploy stacks to.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> getAccounts();

    /**
     * IAM role used to administer the StackSets configuration.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IRole getAdminRole();

    /**
     * IAM role used to provision the products in the Stacks.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getExecutionRoleName();

    /**
     * List of regions to deploy stacks to.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> getRegions();

    /**
     * Wether to allow end users to create, update, and delete stacks.
     * <p>
     * Default: false
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getAllowStackSetInstanceOperations() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link StackSetsConstraintOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link StackSetsConstraintOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<StackSetsConstraintOptions> {
        java.util.List<java.lang.String> accounts;
        software.amazon.awscdk.services.iam.IRole adminRole;
        java.lang.String executionRoleName;
        java.util.List<java.lang.String> regions;
        java.lang.Boolean allowStackSetInstanceOperations;
        java.lang.String description;
        software.amazon.awscdk.services.servicecatalog.MessageLanguage messageLanguage;

        /**
         * Sets the value of {@link StackSetsConstraintOptions#getAccounts}
         * @param accounts List of accounts to deploy stacks to. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder accounts(java.util.List<java.lang.String> accounts) {
            this.accounts = accounts;
            return this;
        }

        /**
         * Sets the value of {@link StackSetsConstraintOptions#getAdminRole}
         * @param adminRole IAM role used to administer the StackSets configuration. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder adminRole(software.amazon.awscdk.services.iam.IRole adminRole) {
            this.adminRole = adminRole;
            return this;
        }

        /**
         * Sets the value of {@link StackSetsConstraintOptions#getExecutionRoleName}
         * @param executionRoleName IAM role used to provision the products in the Stacks. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder executionRoleName(java.lang.String executionRoleName) {
            this.executionRoleName = executionRoleName;
            return this;
        }

        /**
         * Sets the value of {@link StackSetsConstraintOptions#getRegions}
         * @param regions List of regions to deploy stacks to. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder regions(java.util.List<java.lang.String> regions) {
            this.regions = regions;
            return this;
        }

        /**
         * Sets the value of {@link StackSetsConstraintOptions#getAllowStackSetInstanceOperations}
         * @param allowStackSetInstanceOperations Wether to allow end users to create, update, and delete stacks.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder allowStackSetInstanceOperations(java.lang.Boolean allowStackSetInstanceOperations) {
            this.allowStackSetInstanceOperations = allowStackSetInstanceOperations;
            return this;
        }

        /**
         * Sets the value of {@link StackSetsConstraintOptions#getDescription}
         * @param description The description of the constraint.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(java.lang.String description) {
            this.description = description;
            return this;
        }

        /**
         * Sets the value of {@link StackSetsConstraintOptions#getMessageLanguage}
         * @param messageLanguage The language code.
         *                        Configures the language for error messages from service catalog.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder messageLanguage(software.amazon.awscdk.services.servicecatalog.MessageLanguage messageLanguage) {
            this.messageLanguage = messageLanguage;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link StackSetsConstraintOptions}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public StackSetsConstraintOptions build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link StackSetsConstraintOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements StackSetsConstraintOptions {
        private final java.util.List<java.lang.String> accounts;
        private final software.amazon.awscdk.services.iam.IRole adminRole;
        private final java.lang.String executionRoleName;
        private final java.util.List<java.lang.String> regions;
        private final java.lang.Boolean allowStackSetInstanceOperations;
        private final java.lang.String description;
        private final software.amazon.awscdk.services.servicecatalog.MessageLanguage messageLanguage;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.accounts = software.amazon.jsii.Kernel.get(this, "accounts", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.adminRole = software.amazon.jsii.Kernel.get(this, "adminRole", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.IRole.class));
            this.executionRoleName = software.amazon.jsii.Kernel.get(this, "executionRoleName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.regions = software.amazon.jsii.Kernel.get(this, "regions", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.allowStackSetInstanceOperations = software.amazon.jsii.Kernel.get(this, "allowStackSetInstanceOperations", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.description = software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.messageLanguage = software.amazon.jsii.Kernel.get(this, "messageLanguage", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.servicecatalog.MessageLanguage.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.accounts = java.util.Objects.requireNonNull(builder.accounts, "accounts is required");
            this.adminRole = java.util.Objects.requireNonNull(builder.adminRole, "adminRole is required");
            this.executionRoleName = java.util.Objects.requireNonNull(builder.executionRoleName, "executionRoleName is required");
            this.regions = java.util.Objects.requireNonNull(builder.regions, "regions is required");
            this.allowStackSetInstanceOperations = builder.allowStackSetInstanceOperations;
            this.description = builder.description;
            this.messageLanguage = builder.messageLanguage;
        }

        @Override
        public final java.util.List<java.lang.String> getAccounts() {
            return this.accounts;
        }

        @Override
        public final software.amazon.awscdk.services.iam.IRole getAdminRole() {
            return this.adminRole;
        }

        @Override
        public final java.lang.String getExecutionRoleName() {
            return this.executionRoleName;
        }

        @Override
        public final java.util.List<java.lang.String> getRegions() {
            return this.regions;
        }

        @Override
        public final java.lang.Boolean getAllowStackSetInstanceOperations() {
            return this.allowStackSetInstanceOperations;
        }

        @Override
        public final java.lang.String getDescription() {
            return this.description;
        }

        @Override
        public final software.amazon.awscdk.services.servicecatalog.MessageLanguage getMessageLanguage() {
            return this.messageLanguage;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("accounts", om.valueToTree(this.getAccounts()));
            data.set("adminRole", om.valueToTree(this.getAdminRole()));
            data.set("executionRoleName", om.valueToTree(this.getExecutionRoleName()));
            data.set("regions", om.valueToTree(this.getRegions()));
            if (this.getAllowStackSetInstanceOperations() != null) {
                data.set("allowStackSetInstanceOperations", om.valueToTree(this.getAllowStackSetInstanceOperations()));
            }
            if (this.getDescription() != null) {
                data.set("description", om.valueToTree(this.getDescription()));
            }
            if (this.getMessageLanguage() != null) {
                data.set("messageLanguage", om.valueToTree(this.getMessageLanguage()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_servicecatalog.StackSetsConstraintOptions"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            StackSetsConstraintOptions.Jsii$Proxy that = (StackSetsConstraintOptions.Jsii$Proxy) o;

            if (!accounts.equals(that.accounts)) return false;
            if (!adminRole.equals(that.adminRole)) return false;
            if (!executionRoleName.equals(that.executionRoleName)) return false;
            if (!regions.equals(that.regions)) return false;
            if (this.allowStackSetInstanceOperations != null ? !this.allowStackSetInstanceOperations.equals(that.allowStackSetInstanceOperations) : that.allowStackSetInstanceOperations != null) return false;
            if (this.description != null ? !this.description.equals(that.description) : that.description != null) return false;
            return this.messageLanguage != null ? this.messageLanguage.equals(that.messageLanguage) : that.messageLanguage == null;
        }

        @Override
        public final int hashCode() {
            int result = this.accounts.hashCode();
            result = 31 * result + (this.adminRole.hashCode());
            result = 31 * result + (this.executionRoleName.hashCode());
            result = 31 * result + (this.regions.hashCode());
            result = 31 * result + (this.allowStackSetInstanceOperations != null ? this.allowStackSetInstanceOperations.hashCode() : 0);
            result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
            result = 31 * result + (this.messageLanguage != null ? this.messageLanguage.hashCode() : 0);
            return result;
        }
    }
}
