package software.amazon.awscdk.services.ses;

/**
 * Resource to create a rule set for a Mail Manager ingress endpoint which contains a list of rules that are evaluated sequentially for each email.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.ses.*;
 * Object drop;
 * CfnMailManagerRuleSet cfnMailManagerRuleSet = CfnMailManagerRuleSet.Builder.create(this, "MyCfnMailManagerRuleSet")
 *         .rules(List.of(RuleProperty.builder()
 *                 .actions(List.of(RuleActionProperty.builder()
 *                         .addHeader(AddHeaderActionProperty.builder()
 *                                 .headerName("headerName")
 *                                 .headerValue("headerValue")
 *                                 .build())
 *                         .archive(ArchiveActionProperty.builder()
 *                                 .targetArchive("targetArchive")
 *                                 // the properties below are optional
 *                                 .actionFailurePolicy("actionFailurePolicy")
 *                                 .build())
 *                         .deliverToMailbox(DeliverToMailboxActionProperty.builder()
 *                                 .mailboxArn("mailboxArn")
 *                                 .roleArn("roleArn")
 *                                 // the properties below are optional
 *                                 .actionFailurePolicy("actionFailurePolicy")
 *                                 .build())
 *                         .deliverToQBusiness(DeliverToQBusinessActionProperty.builder()
 *                                 .applicationId("applicationId")
 *                                 .indexId("indexId")
 *                                 .roleArn("roleArn")
 *                                 // the properties below are optional
 *                                 .actionFailurePolicy("actionFailurePolicy")
 *                                 .build())
 *                         .drop(drop)
 *                         .relay(RelayActionProperty.builder()
 *                                 .relay("relay")
 *                                 // the properties below are optional
 *                                 .actionFailurePolicy("actionFailurePolicy")
 *                                 .mailFrom("mailFrom")
 *                                 .build())
 *                         .replaceRecipient(ReplaceRecipientActionProperty.builder()
 *                                 .replaceWith(List.of("replaceWith"))
 *                                 .build())
 *                         .send(SendActionProperty.builder()
 *                                 .roleArn("roleArn")
 *                                 // the properties below are optional
 *                                 .actionFailurePolicy("actionFailurePolicy")
 *                                 .build())
 *                         .writeToS3(S3ActionProperty.builder()
 *                                 .roleArn("roleArn")
 *                                 .s3Bucket("s3Bucket")
 *                                 // the properties below are optional
 *                                 .actionFailurePolicy("actionFailurePolicy")
 *                                 .s3Prefix("s3Prefix")
 *                                 .s3SseKmsKeyId("s3SseKmsKeyId")
 *                                 .build())
 *                         .build()))
 *                 // the properties below are optional
 *                 .conditions(List.of(RuleConditionProperty.builder()
 *                         .booleanExpression(RuleBooleanExpressionProperty.builder()
 *                                 .evaluate(RuleBooleanToEvaluateProperty.builder()
 *                                         .analysis(AnalysisProperty.builder()
 *                                                 .analyzer("analyzer")
 *                                                 .resultField("resultField")
 *                                                 .build())
 *                                         .attribute("attribute")
 *                                         .build())
 *                                 .operator("operator")
 *                                 .build())
 *                         .dmarcExpression(RuleDmarcExpressionProperty.builder()
 *                                 .operator("operator")
 *                                 .values(List.of("values"))
 *                                 .build())
 *                         .ipExpression(RuleIpExpressionProperty.builder()
 *                                 .evaluate(RuleIpToEvaluateProperty.builder()
 *                                         .attribute("attribute")
 *                                         .build())
 *                                 .operator("operator")
 *                                 .values(List.of("values"))
 *                                 .build())
 *                         .numberExpression(RuleNumberExpressionProperty.builder()
 *                                 .evaluate(RuleNumberToEvaluateProperty.builder()
 *                                         .attribute("attribute")
 *                                         .build())
 *                                 .operator("operator")
 *                                 .value(123)
 *                                 .build())
 *                         .stringExpression(RuleStringExpressionProperty.builder()
 *                                 .evaluate(RuleStringToEvaluateProperty.builder()
 *                                         .analysis(AnalysisProperty.builder()
 *                                                 .analyzer("analyzer")
 *                                                 .resultField("resultField")
 *                                                 .build())
 *                                         .attribute("attribute")
 *                                         .mimeHeaderAttribute("mimeHeaderAttribute")
 *                                         .build())
 *                                 .operator("operator")
 *                                 .values(List.of("values"))
 *                                 .build())
 *                         .verdictExpression(RuleVerdictExpressionProperty.builder()
 *                                 .evaluate(RuleVerdictToEvaluateProperty.builder()
 *                                         .analysis(AnalysisProperty.builder()
 *                                                 .analyzer("analyzer")
 *                                                 .resultField("resultField")
 *                                                 .build())
 *                                         .attribute("attribute")
 *                                         .build())
 *                                 .operator("operator")
 *                                 .values(List.of("values"))
 *                                 .build())
 *                         .build()))
 *                 .name("name")
 *                 .unless(List.of(RuleConditionProperty.builder()
 *                         .booleanExpression(RuleBooleanExpressionProperty.builder()
 *                                 .evaluate(RuleBooleanToEvaluateProperty.builder()
 *                                         .analysis(AnalysisProperty.builder()
 *                                                 .analyzer("analyzer")
 *                                                 .resultField("resultField")
 *                                                 .build())
 *                                         .attribute("attribute")
 *                                         .build())
 *                                 .operator("operator")
 *                                 .build())
 *                         .dmarcExpression(RuleDmarcExpressionProperty.builder()
 *                                 .operator("operator")
 *                                 .values(List.of("values"))
 *                                 .build())
 *                         .ipExpression(RuleIpExpressionProperty.builder()
 *                                 .evaluate(RuleIpToEvaluateProperty.builder()
 *                                         .attribute("attribute")
 *                                         .build())
 *                                 .operator("operator")
 *                                 .values(List.of("values"))
 *                                 .build())
 *                         .numberExpression(RuleNumberExpressionProperty.builder()
 *                                 .evaluate(RuleNumberToEvaluateProperty.builder()
 *                                         .attribute("attribute")
 *                                         .build())
 *                                 .operator("operator")
 *                                 .value(123)
 *                                 .build())
 *                         .stringExpression(RuleStringExpressionProperty.builder()
 *                                 .evaluate(RuleStringToEvaluateProperty.builder()
 *                                         .analysis(AnalysisProperty.builder()
 *                                                 .analyzer("analyzer")
 *                                                 .resultField("resultField")
 *                                                 .build())
 *                                         .attribute("attribute")
 *                                         .mimeHeaderAttribute("mimeHeaderAttribute")
 *                                         .build())
 *                                 .operator("operator")
 *                                 .values(List.of("values"))
 *                                 .build())
 *                         .verdictExpression(RuleVerdictExpressionProperty.builder()
 *                                 .evaluate(RuleVerdictToEvaluateProperty.builder()
 *                                         .analysis(AnalysisProperty.builder()
 *                                                 .analyzer("analyzer")
 *                                                 .resultField("resultField")
 *                                                 .build())
 *                                         .attribute("attribute")
 *                                         .build())
 *                                 .operator("operator")
 *                                 .values(List.of("values"))
 *                                 .build())
 *                         .build()))
 *                 .build()))
 *         // the properties below are optional
 *         .ruleSetName("ruleSetName")
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ses-mailmanagerruleset.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ses-mailmanagerruleset.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-05-20T23:53:03.852Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ses.CfnMailManagerRuleSet")
public class CfnMailManagerRuleSet extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable, software.amazon.awscdk.ITaggableV2 {

    protected CfnMailManagerRuleSet(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnMailManagerRuleSet(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.ses.CfnMailManagerRuleSet.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * @param scope Scope in which this resource is defined. This parameter is required.
     * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
     * @param props Resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnMailManagerRuleSet(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ses.CfnMailManagerRuleSetProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     * The Amazon Resource Name (ARN) of the rule set resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrRuleSetArn() {
        return software.amazon.jsii.Kernel.get(this, "attrRuleSetArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The identifier of the rule set.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrRuleSetId() {
        return software.amazon.jsii.Kernel.get(this, "attrRuleSetId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Tag Manager which manages the tags for this resource.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.TagManager getCdkTagManager() {
        return software.amazon.jsii.Kernel.get(this, "cdkTagManager", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TagManager.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * Conditional rules that are evaluated for determining actions on email.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Object getRules() {
        return software.amazon.jsii.Kernel.get(this, "rules", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Conditional rules that are evaluated for determining actions on email.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setRules(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "rules", java.util.Objects.requireNonNull(value, "rules is required"));
    }

    /**
     * Conditional rules that are evaluated for determining actions on email.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setRules(final @org.jetbrains.annotations.NotNull java.util.List<java.lang.Object> value) {
        if (software.amazon.jsii.Configuration.getRuntimeTypeChecking()) {
            for (int __idx_ac66f0 = 0; __idx_ac66f0 < value.size(); __idx_ac66f0++) {
                final java.lang.Object __val_ac66f0 = value.get(__idx_ac66f0);
                if (
                     !(__val_ac66f0 instanceof software.amazon.awscdk.IResolvable)
                    && !(__val_ac66f0 instanceof software.amazon.awscdk.services.ses.CfnMailManagerRuleSet.RuleProperty)
                    && !(__val_ac66f0.getClass().equals(software.amazon.jsii.JsiiObject.class))
                ) {
                    throw new IllegalArgumentException(
                        new java.lang.StringBuilder("Expected ")
                            .append("value").append(".get(").append(__idx_ac66f0).append(")")
                            .append(" to be one of: software.amazon.awscdk.IResolvable, software.amazon.awscdk.services.ses.CfnMailManagerRuleSet.RuleProperty; received ")
                            .append(__val_ac66f0.getClass()).toString());
                }
            }
        }
        software.amazon.jsii.Kernel.set(this, "rules", java.util.Objects.requireNonNull(value, "rules is required"));
    }

    /**
     * A user-friendly name for the rule set.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getRuleSetName() {
        return software.amazon.jsii.Kernel.get(this, "ruleSetName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * A user-friendly name for the rule set.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setRuleSetName(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "ruleSetName", value);
    }

    /**
     * The tags used to organize, track, or control access for the resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTags() {
        return java.util.Optional.ofNullable((java.util.List<software.amazon.awscdk.CfnTag>)(software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     * The tags used to organize, track, or control access for the resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTags(final @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> value) {
        software.amazon.jsii.Kernel.set(this, "tags", value);
    }
    /**
     * The action to add a header to a message.
     * <p>
     * When executed, this action will add the given header to the message.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.ses.*;
     * AddHeaderActionProperty addHeaderActionProperty = AddHeaderActionProperty.builder()
     *         .headerName("headerName")
     *         .headerValue("headerValue")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ses-mailmanagerruleset-addheaderaction.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ses-mailmanagerruleset-addheaderaction.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ses.CfnMailManagerRuleSet.AddHeaderActionProperty")
    @software.amazon.jsii.Jsii.Proxy(AddHeaderActionProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface AddHeaderActionProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The name of the header to add to an email.
         * <p>
         * The header must be prefixed with "X-". Headers are added regardless of whether the header name pre-existed in the email.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ses-mailmanagerruleset-addheaderaction.html#cfn-ses-mailmanagerruleset-addheaderaction-headername">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ses-mailmanagerruleset-addheaderaction.html#cfn-ses-mailmanagerruleset-addheaderaction-headername</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getHeaderName();

        /**
         * The value of the header to add to the email.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ses-mailmanagerruleset-addheaderaction.html#cfn-ses-mailmanagerruleset-addheaderaction-headervalue">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ses-mailmanagerruleset-addheaderaction.html#cfn-ses-mailmanagerruleset-addheaderaction-headervalue</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getHeaderValue();

        /**
         * @return a {@link Builder} of {@link AddHeaderActionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link AddHeaderActionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<AddHeaderActionProperty> {
            java.lang.String headerName;
            java.lang.String headerValue;

            /**
             * Sets the value of {@link AddHeaderActionProperty#getHeaderName}
             * @param headerName The name of the header to add to an email. This parameter is required.
             *                   The header must be prefixed with "X-". Headers are added regardless of whether the header name pre-existed in the email.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder headerName(java.lang.String headerName) {
                this.headerName = headerName;
                return this;
            }

            /**
             * Sets the value of {@link AddHeaderActionProperty#getHeaderValue}
             * @param headerValue The value of the header to add to the email. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder headerValue(java.lang.String headerValue) {
                this.headerValue = headerValue;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link AddHeaderActionProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public AddHeaderActionProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link AddHeaderActionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AddHeaderActionProperty {
            private final java.lang.String headerName;
            private final java.lang.String headerValue;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.headerName = software.amazon.jsii.Kernel.get(this, "headerName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.headerValue = software.amazon.jsii.Kernel.get(this, "headerValue", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.headerName = java.util.Objects.requireNonNull(builder.headerName, "headerName is required");
                this.headerValue = java.util.Objects.requireNonNull(builder.headerValue, "headerValue is required");
            }

            @Override
            public final java.lang.String getHeaderName() {
                return this.headerName;
            }

            @Override
            public final java.lang.String getHeaderValue() {
                return this.headerValue;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("headerName", om.valueToTree(this.getHeaderName()));
                data.set("headerValue", om.valueToTree(this.getHeaderValue()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ses.CfnMailManagerRuleSet.AddHeaderActionProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                AddHeaderActionProperty.Jsii$Proxy that = (AddHeaderActionProperty.Jsii$Proxy) o;

                if (!headerName.equals(that.headerName)) return false;
                return this.headerValue.equals(that.headerValue);
            }

            @Override
            public final int hashCode() {
                int result = this.headerName.hashCode();
                result = 31 * result + (this.headerValue.hashCode());
                return result;
            }
        }
    }
    /**
     * The result of an analysis can be used in conditions to trigger actions.
     * <p>
     * Analyses can inspect the email content and report a certain aspect of the email.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.ses.*;
     * AnalysisProperty analysisProperty = AnalysisProperty.builder()
     *         .analyzer("analyzer")
     *         .resultField("resultField")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ses-mailmanagerruleset-analysis.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ses-mailmanagerruleset-analysis.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ses.CfnMailManagerRuleSet.AnalysisProperty")
    @software.amazon.jsii.Jsii.Proxy(AnalysisProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface AnalysisProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The Amazon Resource Name (ARN) of an Add On.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ses-mailmanagerruleset-analysis.html#cfn-ses-mailmanagerruleset-analysis-analyzer">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ses-mailmanagerruleset-analysis.html#cfn-ses-mailmanagerruleset-analysis-analyzer</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getAnalyzer();

        /**
         * The returned value from an Add On.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ses-mailmanagerruleset-analysis.html#cfn-ses-mailmanagerruleset-analysis-resultfield">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ses-mailmanagerruleset-analysis.html#cfn-ses-mailmanagerruleset-analysis-resultfield</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getResultField();

        /**
         * @return a {@link Builder} of {@link AnalysisProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link AnalysisProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<AnalysisProperty> {
            java.lang.String analyzer;
            java.lang.String resultField;

            /**
             * Sets the value of {@link AnalysisProperty#getAnalyzer}
             * @param analyzer The Amazon Resource Name (ARN) of an Add On. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder analyzer(java.lang.String analyzer) {
                this.analyzer = analyzer;
                return this;
            }

            /**
             * Sets the value of {@link AnalysisProperty#getResultField}
             * @param resultField The returned value from an Add On. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder resultField(java.lang.String resultField) {
                this.resultField = resultField;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link AnalysisProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public AnalysisProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link AnalysisProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AnalysisProperty {
            private final java.lang.String analyzer;
            private final java.lang.String resultField;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.analyzer = software.amazon.jsii.Kernel.get(this, "analyzer", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.resultField = software.amazon.jsii.Kernel.get(this, "resultField", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.analyzer = java.util.Objects.requireNonNull(builder.analyzer, "analyzer is required");
                this.resultField = java.util.Objects.requireNonNull(builder.resultField, "resultField is required");
            }

            @Override
            public final java.lang.String getAnalyzer() {
                return this.analyzer;
            }

            @Override
            public final java.lang.String getResultField() {
                return this.resultField;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("analyzer", om.valueToTree(this.getAnalyzer()));
                data.set("resultField", om.valueToTree(this.getResultField()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ses.CfnMailManagerRuleSet.AnalysisProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                AnalysisProperty.Jsii$Proxy that = (AnalysisProperty.Jsii$Proxy) o;

                if (!analyzer.equals(that.analyzer)) return false;
                return this.resultField.equals(that.resultField);
            }

            @Override
            public final int hashCode() {
                int result = this.analyzer.hashCode();
                result = 31 * result + (this.resultField.hashCode());
                return result;
            }
        }
    }
    /**
     * The action to archive the email by delivering the email to an Amazon SES archive.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.ses.*;
     * ArchiveActionProperty archiveActionProperty = ArchiveActionProperty.builder()
     *         .targetArchive("targetArchive")
     *         // the properties below are optional
     *         .actionFailurePolicy("actionFailurePolicy")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ses-mailmanagerruleset-archiveaction.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ses-mailmanagerruleset-archiveaction.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ses.CfnMailManagerRuleSet.ArchiveActionProperty")
    @software.amazon.jsii.Jsii.Proxy(ArchiveActionProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ArchiveActionProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The identifier of the archive to send the email to.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ses-mailmanagerruleset-archiveaction.html#cfn-ses-mailmanagerruleset-archiveaction-targetarchive">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ses-mailmanagerruleset-archiveaction.html#cfn-ses-mailmanagerruleset-archiveaction-targetarchive</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getTargetArchive();

        /**
         * A policy that states what to do in the case of failure.
         * <p>
         * The action will fail if there are configuration errors. For example, the specified archive has been deleted.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ses-mailmanagerruleset-archiveaction.html#cfn-ses-mailmanagerruleset-archiveaction-actionfailurepolicy">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ses-mailmanagerruleset-archiveaction.html#cfn-ses-mailmanagerruleset-archiveaction-actionfailurepolicy</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getActionFailurePolicy() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ArchiveActionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ArchiveActionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ArchiveActionProperty> {
            java.lang.String targetArchive;
            java.lang.String actionFailurePolicy;

            /**
             * Sets the value of {@link ArchiveActionProperty#getTargetArchive}
             * @param targetArchive The identifier of the archive to send the email to. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder targetArchive(java.lang.String targetArchive) {
                this.targetArchive = targetArchive;
                return this;
            }

            /**
             * Sets the value of {@link ArchiveActionProperty#getActionFailurePolicy}
             * @param actionFailurePolicy A policy that states what to do in the case of failure.
             *                            The action will fail if there are configuration errors. For example, the specified archive has been deleted.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder actionFailurePolicy(java.lang.String actionFailurePolicy) {
                this.actionFailurePolicy = actionFailurePolicy;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ArchiveActionProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ArchiveActionProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ArchiveActionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ArchiveActionProperty {
            private final java.lang.String targetArchive;
            private final java.lang.String actionFailurePolicy;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.targetArchive = software.amazon.jsii.Kernel.get(this, "targetArchive", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.actionFailurePolicy = software.amazon.jsii.Kernel.get(this, "actionFailurePolicy", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.targetArchive = java.util.Objects.requireNonNull(builder.targetArchive, "targetArchive is required");
                this.actionFailurePolicy = builder.actionFailurePolicy;
            }

            @Override
            public final java.lang.String getTargetArchive() {
                return this.targetArchive;
            }

            @Override
            public final java.lang.String getActionFailurePolicy() {
                return this.actionFailurePolicy;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("targetArchive", om.valueToTree(this.getTargetArchive()));
                if (this.getActionFailurePolicy() != null) {
                    data.set("actionFailurePolicy", om.valueToTree(this.getActionFailurePolicy()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ses.CfnMailManagerRuleSet.ArchiveActionProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ArchiveActionProperty.Jsii$Proxy that = (ArchiveActionProperty.Jsii$Proxy) o;

                if (!targetArchive.equals(that.targetArchive)) return false;
                return this.actionFailurePolicy != null ? this.actionFailurePolicy.equals(that.actionFailurePolicy) : that.actionFailurePolicy == null;
            }

            @Override
            public final int hashCode() {
                int result = this.targetArchive.hashCode();
                result = 31 * result + (this.actionFailurePolicy != null ? this.actionFailurePolicy.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * This action to delivers an email to a mailbox.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.ses.*;
     * DeliverToMailboxActionProperty deliverToMailboxActionProperty = DeliverToMailboxActionProperty.builder()
     *         .mailboxArn("mailboxArn")
     *         .roleArn("roleArn")
     *         // the properties below are optional
     *         .actionFailurePolicy("actionFailurePolicy")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ses-mailmanagerruleset-delivertomailboxaction.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ses-mailmanagerruleset-delivertomailboxaction.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ses.CfnMailManagerRuleSet.DeliverToMailboxActionProperty")
    @software.amazon.jsii.Jsii.Proxy(DeliverToMailboxActionProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface DeliverToMailboxActionProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The Amazon Resource Name (ARN) of a WorkMail organization to deliver the email to.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ses-mailmanagerruleset-delivertomailboxaction.html#cfn-ses-mailmanagerruleset-delivertomailboxaction-mailboxarn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ses-mailmanagerruleset-delivertomailboxaction.html#cfn-ses-mailmanagerruleset-delivertomailboxaction-mailboxarn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getMailboxArn();

        /**
         * The Amazon Resource Name (ARN) of an IAM role to use to execute this action.
         * <p>
         * The role must have access to the workmail:DeliverToMailbox API.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ses-mailmanagerruleset-delivertomailboxaction.html#cfn-ses-mailmanagerruleset-delivertomailboxaction-rolearn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ses-mailmanagerruleset-delivertomailboxaction.html#cfn-ses-mailmanagerruleset-delivertomailboxaction-rolearn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getRoleArn();

        /**
         * A policy that states what to do in the case of failure.
         * <p>
         * The action will fail if there are configuration errors. For example, the mailbox ARN is no longer valid.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ses-mailmanagerruleset-delivertomailboxaction.html#cfn-ses-mailmanagerruleset-delivertomailboxaction-actionfailurepolicy">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ses-mailmanagerruleset-delivertomailboxaction.html#cfn-ses-mailmanagerruleset-delivertomailboxaction-actionfailurepolicy</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getActionFailurePolicy() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link DeliverToMailboxActionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link DeliverToMailboxActionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<DeliverToMailboxActionProperty> {
            java.lang.String mailboxArn;
            java.lang.String roleArn;
            java.lang.String actionFailurePolicy;

            /**
             * Sets the value of {@link DeliverToMailboxActionProperty#getMailboxArn}
             * @param mailboxArn The Amazon Resource Name (ARN) of a WorkMail organization to deliver the email to. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder mailboxArn(java.lang.String mailboxArn) {
                this.mailboxArn = mailboxArn;
                return this;
            }

            /**
             * Sets the value of {@link DeliverToMailboxActionProperty#getRoleArn}
             * @param roleArn The Amazon Resource Name (ARN) of an IAM role to use to execute this action. This parameter is required.
             *                The role must have access to the workmail:DeliverToMailbox API.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder roleArn(java.lang.String roleArn) {
                this.roleArn = roleArn;
                return this;
            }

            /**
             * Sets the value of {@link DeliverToMailboxActionProperty#getActionFailurePolicy}
             * @param actionFailurePolicy A policy that states what to do in the case of failure.
             *                            The action will fail if there are configuration errors. For example, the mailbox ARN is no longer valid.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder actionFailurePolicy(java.lang.String actionFailurePolicy) {
                this.actionFailurePolicy = actionFailurePolicy;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link DeliverToMailboxActionProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public DeliverToMailboxActionProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link DeliverToMailboxActionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DeliverToMailboxActionProperty {
            private final java.lang.String mailboxArn;
            private final java.lang.String roleArn;
            private final java.lang.String actionFailurePolicy;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.mailboxArn = software.amazon.jsii.Kernel.get(this, "mailboxArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.roleArn = software.amazon.jsii.Kernel.get(this, "roleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.actionFailurePolicy = software.amazon.jsii.Kernel.get(this, "actionFailurePolicy", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.mailboxArn = java.util.Objects.requireNonNull(builder.mailboxArn, "mailboxArn is required");
                this.roleArn = java.util.Objects.requireNonNull(builder.roleArn, "roleArn is required");
                this.actionFailurePolicy = builder.actionFailurePolicy;
            }

            @Override
            public final java.lang.String getMailboxArn() {
                return this.mailboxArn;
            }

            @Override
            public final java.lang.String getRoleArn() {
                return this.roleArn;
            }

            @Override
            public final java.lang.String getActionFailurePolicy() {
                return this.actionFailurePolicy;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("mailboxArn", om.valueToTree(this.getMailboxArn()));
                data.set("roleArn", om.valueToTree(this.getRoleArn()));
                if (this.getActionFailurePolicy() != null) {
                    data.set("actionFailurePolicy", om.valueToTree(this.getActionFailurePolicy()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ses.CfnMailManagerRuleSet.DeliverToMailboxActionProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                DeliverToMailboxActionProperty.Jsii$Proxy that = (DeliverToMailboxActionProperty.Jsii$Proxy) o;

                if (!mailboxArn.equals(that.mailboxArn)) return false;
                if (!roleArn.equals(that.roleArn)) return false;
                return this.actionFailurePolicy != null ? this.actionFailurePolicy.equals(that.actionFailurePolicy) : that.actionFailurePolicy == null;
            }

            @Override
            public final int hashCode() {
                int result = this.mailboxArn.hashCode();
                result = 31 * result + (this.roleArn.hashCode());
                result = 31 * result + (this.actionFailurePolicy != null ? this.actionFailurePolicy.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The action to deliver incoming emails to an Amazon Q Business application for indexing.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.ses.*;
     * DeliverToQBusinessActionProperty deliverToQBusinessActionProperty = DeliverToQBusinessActionProperty.builder()
     *         .applicationId("applicationId")
     *         .indexId("indexId")
     *         .roleArn("roleArn")
     *         // the properties below are optional
     *         .actionFailurePolicy("actionFailurePolicy")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ses-mailmanagerruleset-delivertoqbusinessaction.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ses-mailmanagerruleset-delivertoqbusinessaction.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ses.CfnMailManagerRuleSet.DeliverToQBusinessActionProperty")
    @software.amazon.jsii.Jsii.Proxy(DeliverToQBusinessActionProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface DeliverToQBusinessActionProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The unique identifier of the Amazon Q Business application instance where the email content will be delivered.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ses-mailmanagerruleset-delivertoqbusinessaction.html#cfn-ses-mailmanagerruleset-delivertoqbusinessaction-applicationid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ses-mailmanagerruleset-delivertoqbusinessaction.html#cfn-ses-mailmanagerruleset-delivertoqbusinessaction-applicationid</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getApplicationId();

        /**
         * The identifier of the knowledge base index within the Amazon Q Business application where the email content will be stored and indexed.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ses-mailmanagerruleset-delivertoqbusinessaction.html#cfn-ses-mailmanagerruleset-delivertoqbusinessaction-indexid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ses-mailmanagerruleset-delivertoqbusinessaction.html#cfn-ses-mailmanagerruleset-delivertoqbusinessaction-indexid</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getIndexId();

        /**
         * The Amazon Resource Name (ARN) of the IAM Role to use while delivering to Amazon Q Business.
         * <p>
         * This role must have access to the <code>qbusiness:BatchPutDocument</code> API for the given application and index.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ses-mailmanagerruleset-delivertoqbusinessaction.html#cfn-ses-mailmanagerruleset-delivertoqbusinessaction-rolearn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ses-mailmanagerruleset-delivertoqbusinessaction.html#cfn-ses-mailmanagerruleset-delivertoqbusinessaction-rolearn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getRoleArn();

        /**
         * A policy that states what to do in the case of failure.
         * <p>
         * The action will fail if there are configuration errors. For example, the specified application has been deleted or the role lacks necessary permissions to call the <code>qbusiness:BatchPutDocument</code> API.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ses-mailmanagerruleset-delivertoqbusinessaction.html#cfn-ses-mailmanagerruleset-delivertoqbusinessaction-actionfailurepolicy">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ses-mailmanagerruleset-delivertoqbusinessaction.html#cfn-ses-mailmanagerruleset-delivertoqbusinessaction-actionfailurepolicy</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getActionFailurePolicy() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link DeliverToQBusinessActionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link DeliverToQBusinessActionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<DeliverToQBusinessActionProperty> {
            java.lang.String applicationId;
            java.lang.String indexId;
            java.lang.String roleArn;
            java.lang.String actionFailurePolicy;

            /**
             * Sets the value of {@link DeliverToQBusinessActionProperty#getApplicationId}
             * @param applicationId The unique identifier of the Amazon Q Business application instance where the email content will be delivered. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder applicationId(java.lang.String applicationId) {
                this.applicationId = applicationId;
                return this;
            }

            /**
             * Sets the value of {@link DeliverToQBusinessActionProperty#getIndexId}
             * @param indexId The identifier of the knowledge base index within the Amazon Q Business application where the email content will be stored and indexed. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder indexId(java.lang.String indexId) {
                this.indexId = indexId;
                return this;
            }

            /**
             * Sets the value of {@link DeliverToQBusinessActionProperty#getRoleArn}
             * @param roleArn The Amazon Resource Name (ARN) of the IAM Role to use while delivering to Amazon Q Business. This parameter is required.
             *                This role must have access to the <code>qbusiness:BatchPutDocument</code> API for the given application and index.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder roleArn(java.lang.String roleArn) {
                this.roleArn = roleArn;
                return this;
            }

            /**
             * Sets the value of {@link DeliverToQBusinessActionProperty#getActionFailurePolicy}
             * @param actionFailurePolicy A policy that states what to do in the case of failure.
             *                            The action will fail if there are configuration errors. For example, the specified application has been deleted or the role lacks necessary permissions to call the <code>qbusiness:BatchPutDocument</code> API.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder actionFailurePolicy(java.lang.String actionFailurePolicy) {
                this.actionFailurePolicy = actionFailurePolicy;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link DeliverToQBusinessActionProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public DeliverToQBusinessActionProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link DeliverToQBusinessActionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DeliverToQBusinessActionProperty {
            private final java.lang.String applicationId;
            private final java.lang.String indexId;
            private final java.lang.String roleArn;
            private final java.lang.String actionFailurePolicy;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.applicationId = software.amazon.jsii.Kernel.get(this, "applicationId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.indexId = software.amazon.jsii.Kernel.get(this, "indexId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.roleArn = software.amazon.jsii.Kernel.get(this, "roleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.actionFailurePolicy = software.amazon.jsii.Kernel.get(this, "actionFailurePolicy", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.applicationId = java.util.Objects.requireNonNull(builder.applicationId, "applicationId is required");
                this.indexId = java.util.Objects.requireNonNull(builder.indexId, "indexId is required");
                this.roleArn = java.util.Objects.requireNonNull(builder.roleArn, "roleArn is required");
                this.actionFailurePolicy = builder.actionFailurePolicy;
            }

            @Override
            public final java.lang.String getApplicationId() {
                return this.applicationId;
            }

            @Override
            public final java.lang.String getIndexId() {
                return this.indexId;
            }

            @Override
            public final java.lang.String getRoleArn() {
                return this.roleArn;
            }

            @Override
            public final java.lang.String getActionFailurePolicy() {
                return this.actionFailurePolicy;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("applicationId", om.valueToTree(this.getApplicationId()));
                data.set("indexId", om.valueToTree(this.getIndexId()));
                data.set("roleArn", om.valueToTree(this.getRoleArn()));
                if (this.getActionFailurePolicy() != null) {
                    data.set("actionFailurePolicy", om.valueToTree(this.getActionFailurePolicy()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ses.CfnMailManagerRuleSet.DeliverToQBusinessActionProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                DeliverToQBusinessActionProperty.Jsii$Proxy that = (DeliverToQBusinessActionProperty.Jsii$Proxy) o;

                if (!applicationId.equals(that.applicationId)) return false;
                if (!indexId.equals(that.indexId)) return false;
                if (!roleArn.equals(that.roleArn)) return false;
                return this.actionFailurePolicy != null ? this.actionFailurePolicy.equals(that.actionFailurePolicy) : that.actionFailurePolicy == null;
            }

            @Override
            public final int hashCode() {
                int result = this.applicationId.hashCode();
                result = 31 * result + (this.indexId.hashCode());
                result = 31 * result + (this.roleArn.hashCode());
                result = 31 * result + (this.actionFailurePolicy != null ? this.actionFailurePolicy.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The action relays the email via SMTP to another specific SMTP server.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.ses.*;
     * RelayActionProperty relayActionProperty = RelayActionProperty.builder()
     *         .relay("relay")
     *         // the properties below are optional
     *         .actionFailurePolicy("actionFailurePolicy")
     *         .mailFrom("mailFrom")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ses-mailmanagerruleset-relayaction.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ses-mailmanagerruleset-relayaction.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ses.CfnMailManagerRuleSet.RelayActionProperty")
    @software.amazon.jsii.Jsii.Proxy(RelayActionProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface RelayActionProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The identifier of the relay resource to be used when relaying an email.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ses-mailmanagerruleset-relayaction.html#cfn-ses-mailmanagerruleset-relayaction-relay">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ses-mailmanagerruleset-relayaction.html#cfn-ses-mailmanagerruleset-relayaction-relay</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getRelay();

        /**
         * A policy that states what to do in the case of failure.
         * <p>
         * The action will fail if there are configuration errors. For example, the specified relay has been deleted.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ses-mailmanagerruleset-relayaction.html#cfn-ses-mailmanagerruleset-relayaction-actionfailurepolicy">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ses-mailmanagerruleset-relayaction.html#cfn-ses-mailmanagerruleset-relayaction-actionfailurepolicy</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getActionFailurePolicy() {
            return null;
        }

        /**
         * This action specifies whether to preserve or replace original mail from address while relaying received emails to a destination server.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ses-mailmanagerruleset-relayaction.html#cfn-ses-mailmanagerruleset-relayaction-mailfrom">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ses-mailmanagerruleset-relayaction.html#cfn-ses-mailmanagerruleset-relayaction-mailfrom</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getMailFrom() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link RelayActionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link RelayActionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<RelayActionProperty> {
            java.lang.String relay;
            java.lang.String actionFailurePolicy;
            java.lang.String mailFrom;

            /**
             * Sets the value of {@link RelayActionProperty#getRelay}
             * @param relay The identifier of the relay resource to be used when relaying an email. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder relay(java.lang.String relay) {
                this.relay = relay;
                return this;
            }

            /**
             * Sets the value of {@link RelayActionProperty#getActionFailurePolicy}
             * @param actionFailurePolicy A policy that states what to do in the case of failure.
             *                            The action will fail if there are configuration errors. For example, the specified relay has been deleted.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder actionFailurePolicy(java.lang.String actionFailurePolicy) {
                this.actionFailurePolicy = actionFailurePolicy;
                return this;
            }

            /**
             * Sets the value of {@link RelayActionProperty#getMailFrom}
             * @param mailFrom This action specifies whether to preserve or replace original mail from address while relaying received emails to a destination server.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder mailFrom(java.lang.String mailFrom) {
                this.mailFrom = mailFrom;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link RelayActionProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public RelayActionProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link RelayActionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements RelayActionProperty {
            private final java.lang.String relay;
            private final java.lang.String actionFailurePolicy;
            private final java.lang.String mailFrom;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.relay = software.amazon.jsii.Kernel.get(this, "relay", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.actionFailurePolicy = software.amazon.jsii.Kernel.get(this, "actionFailurePolicy", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.mailFrom = software.amazon.jsii.Kernel.get(this, "mailFrom", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.relay = java.util.Objects.requireNonNull(builder.relay, "relay is required");
                this.actionFailurePolicy = builder.actionFailurePolicy;
                this.mailFrom = builder.mailFrom;
            }

            @Override
            public final java.lang.String getRelay() {
                return this.relay;
            }

            @Override
            public final java.lang.String getActionFailurePolicy() {
                return this.actionFailurePolicy;
            }

            @Override
            public final java.lang.String getMailFrom() {
                return this.mailFrom;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("relay", om.valueToTree(this.getRelay()));
                if (this.getActionFailurePolicy() != null) {
                    data.set("actionFailurePolicy", om.valueToTree(this.getActionFailurePolicy()));
                }
                if (this.getMailFrom() != null) {
                    data.set("mailFrom", om.valueToTree(this.getMailFrom()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ses.CfnMailManagerRuleSet.RelayActionProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                RelayActionProperty.Jsii$Proxy that = (RelayActionProperty.Jsii$Proxy) o;

                if (!relay.equals(that.relay)) return false;
                if (this.actionFailurePolicy != null ? !this.actionFailurePolicy.equals(that.actionFailurePolicy) : that.actionFailurePolicy != null) return false;
                return this.mailFrom != null ? this.mailFrom.equals(that.mailFrom) : that.mailFrom == null;
            }

            @Override
            public final int hashCode() {
                int result = this.relay.hashCode();
                result = 31 * result + (this.actionFailurePolicy != null ? this.actionFailurePolicy.hashCode() : 0);
                result = 31 * result + (this.mailFrom != null ? this.mailFrom.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * This action replaces the email envelope recipients with the given list of recipients.
     * <p>
     * If the condition of this action applies only to a subset of recipients, only those recipients are replaced with the recipients specified in the action. The message contents and headers are unaffected by this action, only the envelope recipients are updated.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.ses.*;
     * ReplaceRecipientActionProperty replaceRecipientActionProperty = ReplaceRecipientActionProperty.builder()
     *         .replaceWith(List.of("replaceWith"))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ses-mailmanagerruleset-replacerecipientaction.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ses-mailmanagerruleset-replacerecipientaction.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ses.CfnMailManagerRuleSet.ReplaceRecipientActionProperty")
    @software.amazon.jsii.Jsii.Proxy(ReplaceRecipientActionProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ReplaceRecipientActionProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * This action specifies the replacement recipient email addresses to insert.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ses-mailmanagerruleset-replacerecipientaction.html#cfn-ses-mailmanagerruleset-replacerecipientaction-replacewith">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ses-mailmanagerruleset-replacerecipientaction.html#cfn-ses-mailmanagerruleset-replacerecipientaction-replacewith</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getReplaceWith() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ReplaceRecipientActionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ReplaceRecipientActionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ReplaceRecipientActionProperty> {
            java.util.List<java.lang.String> replaceWith;

            /**
             * Sets the value of {@link ReplaceRecipientActionProperty#getReplaceWith}
             * @param replaceWith This action specifies the replacement recipient email addresses to insert.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder replaceWith(java.util.List<java.lang.String> replaceWith) {
                this.replaceWith = replaceWith;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ReplaceRecipientActionProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ReplaceRecipientActionProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ReplaceRecipientActionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ReplaceRecipientActionProperty {
            private final java.util.List<java.lang.String> replaceWith;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.replaceWith = software.amazon.jsii.Kernel.get(this, "replaceWith", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.replaceWith = builder.replaceWith;
            }

            @Override
            public final java.util.List<java.lang.String> getReplaceWith() {
                return this.replaceWith;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getReplaceWith() != null) {
                    data.set("replaceWith", om.valueToTree(this.getReplaceWith()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ses.CfnMailManagerRuleSet.ReplaceRecipientActionProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ReplaceRecipientActionProperty.Jsii$Proxy that = (ReplaceRecipientActionProperty.Jsii$Proxy) o;

                return this.replaceWith != null ? this.replaceWith.equals(that.replaceWith) : that.replaceWith == null;
            }

            @Override
            public final int hashCode() {
                int result = this.replaceWith != null ? this.replaceWith.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * The action for a rule to take. Only one of the contained actions can be set.
     * <p>
     * <blockquote>
     * <p>
     * This data type is a UNION, so only one of the following members can be specified when used or returned.
     * <p>
     * </blockquote>
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.ses.*;
     * Object drop;
     * RuleActionProperty ruleActionProperty = RuleActionProperty.builder()
     *         .addHeader(AddHeaderActionProperty.builder()
     *                 .headerName("headerName")
     *                 .headerValue("headerValue")
     *                 .build())
     *         .archive(ArchiveActionProperty.builder()
     *                 .targetArchive("targetArchive")
     *                 // the properties below are optional
     *                 .actionFailurePolicy("actionFailurePolicy")
     *                 .build())
     *         .deliverToMailbox(DeliverToMailboxActionProperty.builder()
     *                 .mailboxArn("mailboxArn")
     *                 .roleArn("roleArn")
     *                 // the properties below are optional
     *                 .actionFailurePolicy("actionFailurePolicy")
     *                 .build())
     *         .deliverToQBusiness(DeliverToQBusinessActionProperty.builder()
     *                 .applicationId("applicationId")
     *                 .indexId("indexId")
     *                 .roleArn("roleArn")
     *                 // the properties below are optional
     *                 .actionFailurePolicy("actionFailurePolicy")
     *                 .build())
     *         .drop(drop)
     *         .relay(RelayActionProperty.builder()
     *                 .relay("relay")
     *                 // the properties below are optional
     *                 .actionFailurePolicy("actionFailurePolicy")
     *                 .mailFrom("mailFrom")
     *                 .build())
     *         .replaceRecipient(ReplaceRecipientActionProperty.builder()
     *                 .replaceWith(List.of("replaceWith"))
     *                 .build())
     *         .send(SendActionProperty.builder()
     *                 .roleArn("roleArn")
     *                 // the properties below are optional
     *                 .actionFailurePolicy("actionFailurePolicy")
     *                 .build())
     *         .writeToS3(S3ActionProperty.builder()
     *                 .roleArn("roleArn")
     *                 .s3Bucket("s3Bucket")
     *                 // the properties below are optional
     *                 .actionFailurePolicy("actionFailurePolicy")
     *                 .s3Prefix("s3Prefix")
     *                 .s3SseKmsKeyId("s3SseKmsKeyId")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ses-mailmanagerruleset-ruleaction.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ses-mailmanagerruleset-ruleaction.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ses.CfnMailManagerRuleSet.RuleActionProperty")
    @software.amazon.jsii.Jsii.Proxy(RuleActionProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface RuleActionProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * This action adds a header.
         * <p>
         * This can be used to add arbitrary email headers.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ses-mailmanagerruleset-ruleaction.html#cfn-ses-mailmanagerruleset-ruleaction-addheader">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ses-mailmanagerruleset-ruleaction.html#cfn-ses-mailmanagerruleset-ruleaction-addheader</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getAddHeader() {
            return null;
        }

        /**
         * This action archives the email.
         * <p>
         * This can be used to deliver an email to an archive.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ses-mailmanagerruleset-ruleaction.html#cfn-ses-mailmanagerruleset-ruleaction-archive">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ses-mailmanagerruleset-ruleaction.html#cfn-ses-mailmanagerruleset-ruleaction-archive</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getArchive() {
            return null;
        }

        /**
         * This action delivers an email to a WorkMail mailbox.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ses-mailmanagerruleset-ruleaction.html#cfn-ses-mailmanagerruleset-ruleaction-delivertomailbox">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ses-mailmanagerruleset-ruleaction.html#cfn-ses-mailmanagerruleset-ruleaction-delivertomailbox</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getDeliverToMailbox() {
            return null;
        }

        /**
         * This action delivers an email to an Amazon Q Business application for ingestion into its knowledge base.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ses-mailmanagerruleset-ruleaction.html#cfn-ses-mailmanagerruleset-ruleaction-delivertoqbusiness">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ses-mailmanagerruleset-ruleaction.html#cfn-ses-mailmanagerruleset-ruleaction-delivertoqbusiness</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getDeliverToQBusiness() {
            return null;
        }

        /**
         * This action terminates the evaluation of rules in the rule set.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ses-mailmanagerruleset-ruleaction.html#cfn-ses-mailmanagerruleset-ruleaction-drop">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ses-mailmanagerruleset-ruleaction.html#cfn-ses-mailmanagerruleset-ruleaction-drop</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getDrop() {
            return null;
        }

        /**
         * This action relays the email to another SMTP server.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ses-mailmanagerruleset-ruleaction.html#cfn-ses-mailmanagerruleset-ruleaction-relay">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ses-mailmanagerruleset-ruleaction.html#cfn-ses-mailmanagerruleset-ruleaction-relay</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getRelay() {
            return null;
        }

        /**
         * The action replaces certain or all recipients with a different set of recipients.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ses-mailmanagerruleset-ruleaction.html#cfn-ses-mailmanagerruleset-ruleaction-replacerecipient">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ses-mailmanagerruleset-ruleaction.html#cfn-ses-mailmanagerruleset-ruleaction-replacerecipient</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getReplaceRecipient() {
            return null;
        }

        /**
         * This action sends the email to the internet.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ses-mailmanagerruleset-ruleaction.html#cfn-ses-mailmanagerruleset-ruleaction-send">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ses-mailmanagerruleset-ruleaction.html#cfn-ses-mailmanagerruleset-ruleaction-send</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getSend() {
            return null;
        }

        /**
         * This action writes the MIME content of the email to an S3 bucket.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ses-mailmanagerruleset-ruleaction.html#cfn-ses-mailmanagerruleset-ruleaction-writetos3">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ses-mailmanagerruleset-ruleaction.html#cfn-ses-mailmanagerruleset-ruleaction-writetos3</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getWriteToS3() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link RuleActionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link RuleActionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<RuleActionProperty> {
            java.lang.Object addHeader;
            java.lang.Object archive;
            java.lang.Object deliverToMailbox;
            java.lang.Object deliverToQBusiness;
            java.lang.Object drop;
            java.lang.Object relay;
            java.lang.Object replaceRecipient;
            java.lang.Object send;
            java.lang.Object writeToS3;

            /**
             * Sets the value of {@link RuleActionProperty#getAddHeader}
             * @param addHeader This action adds a header.
             *                  This can be used to add arbitrary email headers.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder addHeader(software.amazon.awscdk.IResolvable addHeader) {
                this.addHeader = addHeader;
                return this;
            }

            /**
             * Sets the value of {@link RuleActionProperty#getAddHeader}
             * @param addHeader This action adds a header.
             *                  This can be used to add arbitrary email headers.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder addHeader(software.amazon.awscdk.services.ses.CfnMailManagerRuleSet.AddHeaderActionProperty addHeader) {
                this.addHeader = addHeader;
                return this;
            }

            /**
             * Sets the value of {@link RuleActionProperty#getArchive}
             * @param archive This action archives the email.
             *                This can be used to deliver an email to an archive.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder archive(software.amazon.awscdk.IResolvable archive) {
                this.archive = archive;
                return this;
            }

            /**
             * Sets the value of {@link RuleActionProperty#getArchive}
             * @param archive This action archives the email.
             *                This can be used to deliver an email to an archive.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder archive(software.amazon.awscdk.services.ses.CfnMailManagerRuleSet.ArchiveActionProperty archive) {
                this.archive = archive;
                return this;
            }

            /**
             * Sets the value of {@link RuleActionProperty#getDeliverToMailbox}
             * @param deliverToMailbox This action delivers an email to a WorkMail mailbox.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder deliverToMailbox(software.amazon.awscdk.IResolvable deliverToMailbox) {
                this.deliverToMailbox = deliverToMailbox;
                return this;
            }

            /**
             * Sets the value of {@link RuleActionProperty#getDeliverToMailbox}
             * @param deliverToMailbox This action delivers an email to a WorkMail mailbox.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder deliverToMailbox(software.amazon.awscdk.services.ses.CfnMailManagerRuleSet.DeliverToMailboxActionProperty deliverToMailbox) {
                this.deliverToMailbox = deliverToMailbox;
                return this;
            }

            /**
             * Sets the value of {@link RuleActionProperty#getDeliverToQBusiness}
             * @param deliverToQBusiness This action delivers an email to an Amazon Q Business application for ingestion into its knowledge base.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder deliverToQBusiness(software.amazon.awscdk.IResolvable deliverToQBusiness) {
                this.deliverToQBusiness = deliverToQBusiness;
                return this;
            }

            /**
             * Sets the value of {@link RuleActionProperty#getDeliverToQBusiness}
             * @param deliverToQBusiness This action delivers an email to an Amazon Q Business application for ingestion into its knowledge base.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder deliverToQBusiness(software.amazon.awscdk.services.ses.CfnMailManagerRuleSet.DeliverToQBusinessActionProperty deliverToQBusiness) {
                this.deliverToQBusiness = deliverToQBusiness;
                return this;
            }

            /**
             * Sets the value of {@link RuleActionProperty#getDrop}
             * @param drop This action terminates the evaluation of rules in the rule set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder drop(java.lang.Object drop) {
                this.drop = drop;
                return this;
            }

            /**
             * Sets the value of {@link RuleActionProperty#getRelay}
             * @param relay This action relays the email to another SMTP server.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder relay(software.amazon.awscdk.IResolvable relay) {
                this.relay = relay;
                return this;
            }

            /**
             * Sets the value of {@link RuleActionProperty#getRelay}
             * @param relay This action relays the email to another SMTP server.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder relay(software.amazon.awscdk.services.ses.CfnMailManagerRuleSet.RelayActionProperty relay) {
                this.relay = relay;
                return this;
            }

            /**
             * Sets the value of {@link RuleActionProperty#getReplaceRecipient}
             * @param replaceRecipient The action replaces certain or all recipients with a different set of recipients.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder replaceRecipient(software.amazon.awscdk.IResolvable replaceRecipient) {
                this.replaceRecipient = replaceRecipient;
                return this;
            }

            /**
             * Sets the value of {@link RuleActionProperty#getReplaceRecipient}
             * @param replaceRecipient The action replaces certain or all recipients with a different set of recipients.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder replaceRecipient(software.amazon.awscdk.services.ses.CfnMailManagerRuleSet.ReplaceRecipientActionProperty replaceRecipient) {
                this.replaceRecipient = replaceRecipient;
                return this;
            }

            /**
             * Sets the value of {@link RuleActionProperty#getSend}
             * @param send This action sends the email to the internet.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder send(software.amazon.awscdk.IResolvable send) {
                this.send = send;
                return this;
            }

            /**
             * Sets the value of {@link RuleActionProperty#getSend}
             * @param send This action sends the email to the internet.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder send(software.amazon.awscdk.services.ses.CfnMailManagerRuleSet.SendActionProperty send) {
                this.send = send;
                return this;
            }

            /**
             * Sets the value of {@link RuleActionProperty#getWriteToS3}
             * @param writeToS3 This action writes the MIME content of the email to an S3 bucket.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder writeToS3(software.amazon.awscdk.IResolvable writeToS3) {
                this.writeToS3 = writeToS3;
                return this;
            }

            /**
             * Sets the value of {@link RuleActionProperty#getWriteToS3}
             * @param writeToS3 This action writes the MIME content of the email to an S3 bucket.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder writeToS3(software.amazon.awscdk.services.ses.CfnMailManagerRuleSet.S3ActionProperty writeToS3) {
                this.writeToS3 = writeToS3;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link RuleActionProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public RuleActionProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link RuleActionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements RuleActionProperty {
            private final java.lang.Object addHeader;
            private final java.lang.Object archive;
            private final java.lang.Object deliverToMailbox;
            private final java.lang.Object deliverToQBusiness;
            private final java.lang.Object drop;
            private final java.lang.Object relay;
            private final java.lang.Object replaceRecipient;
            private final java.lang.Object send;
            private final java.lang.Object writeToS3;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.addHeader = software.amazon.jsii.Kernel.get(this, "addHeader", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.archive = software.amazon.jsii.Kernel.get(this, "archive", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.deliverToMailbox = software.amazon.jsii.Kernel.get(this, "deliverToMailbox", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.deliverToQBusiness = software.amazon.jsii.Kernel.get(this, "deliverToQBusiness", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.drop = software.amazon.jsii.Kernel.get(this, "drop", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.relay = software.amazon.jsii.Kernel.get(this, "relay", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.replaceRecipient = software.amazon.jsii.Kernel.get(this, "replaceRecipient", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.send = software.amazon.jsii.Kernel.get(this, "send", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.writeToS3 = software.amazon.jsii.Kernel.get(this, "writeToS3", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.addHeader = builder.addHeader;
                this.archive = builder.archive;
                this.deliverToMailbox = builder.deliverToMailbox;
                this.deliverToQBusiness = builder.deliverToQBusiness;
                this.drop = builder.drop;
                this.relay = builder.relay;
                this.replaceRecipient = builder.replaceRecipient;
                this.send = builder.send;
                this.writeToS3 = builder.writeToS3;
            }

            @Override
            public final java.lang.Object getAddHeader() {
                return this.addHeader;
            }

            @Override
            public final java.lang.Object getArchive() {
                return this.archive;
            }

            @Override
            public final java.lang.Object getDeliverToMailbox() {
                return this.deliverToMailbox;
            }

            @Override
            public final java.lang.Object getDeliverToQBusiness() {
                return this.deliverToQBusiness;
            }

            @Override
            public final java.lang.Object getDrop() {
                return this.drop;
            }

            @Override
            public final java.lang.Object getRelay() {
                return this.relay;
            }

            @Override
            public final java.lang.Object getReplaceRecipient() {
                return this.replaceRecipient;
            }

            @Override
            public final java.lang.Object getSend() {
                return this.send;
            }

            @Override
            public final java.lang.Object getWriteToS3() {
                return this.writeToS3;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getAddHeader() != null) {
                    data.set("addHeader", om.valueToTree(this.getAddHeader()));
                }
                if (this.getArchive() != null) {
                    data.set("archive", om.valueToTree(this.getArchive()));
                }
                if (this.getDeliverToMailbox() != null) {
                    data.set("deliverToMailbox", om.valueToTree(this.getDeliverToMailbox()));
                }
                if (this.getDeliverToQBusiness() != null) {
                    data.set("deliverToQBusiness", om.valueToTree(this.getDeliverToQBusiness()));
                }
                if (this.getDrop() != null) {
                    data.set("drop", om.valueToTree(this.getDrop()));
                }
                if (this.getRelay() != null) {
                    data.set("relay", om.valueToTree(this.getRelay()));
                }
                if (this.getReplaceRecipient() != null) {
                    data.set("replaceRecipient", om.valueToTree(this.getReplaceRecipient()));
                }
                if (this.getSend() != null) {
                    data.set("send", om.valueToTree(this.getSend()));
                }
                if (this.getWriteToS3() != null) {
                    data.set("writeToS3", om.valueToTree(this.getWriteToS3()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ses.CfnMailManagerRuleSet.RuleActionProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                RuleActionProperty.Jsii$Proxy that = (RuleActionProperty.Jsii$Proxy) o;

                if (this.addHeader != null ? !this.addHeader.equals(that.addHeader) : that.addHeader != null) return false;
                if (this.archive != null ? !this.archive.equals(that.archive) : that.archive != null) return false;
                if (this.deliverToMailbox != null ? !this.deliverToMailbox.equals(that.deliverToMailbox) : that.deliverToMailbox != null) return false;
                if (this.deliverToQBusiness != null ? !this.deliverToQBusiness.equals(that.deliverToQBusiness) : that.deliverToQBusiness != null) return false;
                if (this.drop != null ? !this.drop.equals(that.drop) : that.drop != null) return false;
                if (this.relay != null ? !this.relay.equals(that.relay) : that.relay != null) return false;
                if (this.replaceRecipient != null ? !this.replaceRecipient.equals(that.replaceRecipient) : that.replaceRecipient != null) return false;
                if (this.send != null ? !this.send.equals(that.send) : that.send != null) return false;
                return this.writeToS3 != null ? this.writeToS3.equals(that.writeToS3) : that.writeToS3 == null;
            }

            @Override
            public final int hashCode() {
                int result = this.addHeader != null ? this.addHeader.hashCode() : 0;
                result = 31 * result + (this.archive != null ? this.archive.hashCode() : 0);
                result = 31 * result + (this.deliverToMailbox != null ? this.deliverToMailbox.hashCode() : 0);
                result = 31 * result + (this.deliverToQBusiness != null ? this.deliverToQBusiness.hashCode() : 0);
                result = 31 * result + (this.drop != null ? this.drop.hashCode() : 0);
                result = 31 * result + (this.relay != null ? this.relay.hashCode() : 0);
                result = 31 * result + (this.replaceRecipient != null ? this.replaceRecipient.hashCode() : 0);
                result = 31 * result + (this.send != null ? this.send.hashCode() : 0);
                result = 31 * result + (this.writeToS3 != null ? this.writeToS3.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * A boolean expression to be used in a rule condition.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.ses.*;
     * RuleBooleanExpressionProperty ruleBooleanExpressionProperty = RuleBooleanExpressionProperty.builder()
     *         .evaluate(RuleBooleanToEvaluateProperty.builder()
     *                 .analysis(AnalysisProperty.builder()
     *                         .analyzer("analyzer")
     *                         .resultField("resultField")
     *                         .build())
     *                 .attribute("attribute")
     *                 .build())
     *         .operator("operator")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ses-mailmanagerruleset-rulebooleanexpression.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ses-mailmanagerruleset-rulebooleanexpression.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ses.CfnMailManagerRuleSet.RuleBooleanExpressionProperty")
    @software.amazon.jsii.Jsii.Proxy(RuleBooleanExpressionProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface RuleBooleanExpressionProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The operand on which to perform a boolean condition operation.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ses-mailmanagerruleset-rulebooleanexpression.html#cfn-ses-mailmanagerruleset-rulebooleanexpression-evaluate">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ses-mailmanagerruleset-rulebooleanexpression.html#cfn-ses-mailmanagerruleset-rulebooleanexpression-evaluate</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getEvaluate();

        /**
         * The matching operator for a boolean condition expression.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ses-mailmanagerruleset-rulebooleanexpression.html#cfn-ses-mailmanagerruleset-rulebooleanexpression-operator">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ses-mailmanagerruleset-rulebooleanexpression.html#cfn-ses-mailmanagerruleset-rulebooleanexpression-operator</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getOperator();

        /**
         * @return a {@link Builder} of {@link RuleBooleanExpressionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link RuleBooleanExpressionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<RuleBooleanExpressionProperty> {
            java.lang.Object evaluate;
            java.lang.String operator;

            /**
             * Sets the value of {@link RuleBooleanExpressionProperty#getEvaluate}
             * @param evaluate The operand on which to perform a boolean condition operation. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder evaluate(software.amazon.awscdk.IResolvable evaluate) {
                this.evaluate = evaluate;
                return this;
            }

            /**
             * Sets the value of {@link RuleBooleanExpressionProperty#getEvaluate}
             * @param evaluate The operand on which to perform a boolean condition operation. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder evaluate(software.amazon.awscdk.services.ses.CfnMailManagerRuleSet.RuleBooleanToEvaluateProperty evaluate) {
                this.evaluate = evaluate;
                return this;
            }

            /**
             * Sets the value of {@link RuleBooleanExpressionProperty#getOperator}
             * @param operator The matching operator for a boolean condition expression. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder operator(java.lang.String operator) {
                this.operator = operator;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link RuleBooleanExpressionProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public RuleBooleanExpressionProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link RuleBooleanExpressionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements RuleBooleanExpressionProperty {
            private final java.lang.Object evaluate;
            private final java.lang.String operator;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.evaluate = software.amazon.jsii.Kernel.get(this, "evaluate", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.operator = software.amazon.jsii.Kernel.get(this, "operator", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.evaluate = java.util.Objects.requireNonNull(builder.evaluate, "evaluate is required");
                this.operator = java.util.Objects.requireNonNull(builder.operator, "operator is required");
            }

            @Override
            public final java.lang.Object getEvaluate() {
                return this.evaluate;
            }

            @Override
            public final java.lang.String getOperator() {
                return this.operator;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("evaluate", om.valueToTree(this.getEvaluate()));
                data.set("operator", om.valueToTree(this.getOperator()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ses.CfnMailManagerRuleSet.RuleBooleanExpressionProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                RuleBooleanExpressionProperty.Jsii$Proxy that = (RuleBooleanExpressionProperty.Jsii$Proxy) o;

                if (!evaluate.equals(that.evaluate)) return false;
                return this.operator.equals(that.operator);
            }

            @Override
            public final int hashCode() {
                int result = this.evaluate.hashCode();
                result = 31 * result + (this.operator.hashCode());
                return result;
            }
        }
    }
    /**
     * The union type representing the allowed types of operands for a boolean condition.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.ses.*;
     * RuleBooleanToEvaluateProperty ruleBooleanToEvaluateProperty = RuleBooleanToEvaluateProperty.builder()
     *         .analysis(AnalysisProperty.builder()
     *                 .analyzer("analyzer")
     *                 .resultField("resultField")
     *                 .build())
     *         .attribute("attribute")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ses-mailmanagerruleset-rulebooleantoevaluate.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ses-mailmanagerruleset-rulebooleantoevaluate.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ses.CfnMailManagerRuleSet.RuleBooleanToEvaluateProperty")
    @software.amazon.jsii.Jsii.Proxy(RuleBooleanToEvaluateProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface RuleBooleanToEvaluateProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The Add On ARN and its returned value to evaluate in a boolean condition expression.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ses-mailmanagerruleset-rulebooleantoevaluate.html#cfn-ses-mailmanagerruleset-rulebooleantoevaluate-analysis">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ses-mailmanagerruleset-rulebooleantoevaluate.html#cfn-ses-mailmanagerruleset-rulebooleantoevaluate-analysis</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getAnalysis() {
            return null;
        }

        /**
         * The boolean type representing the allowed attribute types for an email.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ses-mailmanagerruleset-rulebooleantoevaluate.html#cfn-ses-mailmanagerruleset-rulebooleantoevaluate-attribute">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ses-mailmanagerruleset-rulebooleantoevaluate.html#cfn-ses-mailmanagerruleset-rulebooleantoevaluate-attribute</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getAttribute() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link RuleBooleanToEvaluateProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link RuleBooleanToEvaluateProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<RuleBooleanToEvaluateProperty> {
            java.lang.Object analysis;
            java.lang.String attribute;

            /**
             * Sets the value of {@link RuleBooleanToEvaluateProperty#getAnalysis}
             * @param analysis The Add On ARN and its returned value to evaluate in a boolean condition expression.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder analysis(software.amazon.awscdk.IResolvable analysis) {
                this.analysis = analysis;
                return this;
            }

            /**
             * Sets the value of {@link RuleBooleanToEvaluateProperty#getAnalysis}
             * @param analysis The Add On ARN and its returned value to evaluate in a boolean condition expression.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder analysis(software.amazon.awscdk.services.ses.CfnMailManagerRuleSet.AnalysisProperty analysis) {
                this.analysis = analysis;
                return this;
            }

            /**
             * Sets the value of {@link RuleBooleanToEvaluateProperty#getAttribute}
             * @param attribute The boolean type representing the allowed attribute types for an email.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder attribute(java.lang.String attribute) {
                this.attribute = attribute;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link RuleBooleanToEvaluateProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public RuleBooleanToEvaluateProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link RuleBooleanToEvaluateProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements RuleBooleanToEvaluateProperty {
            private final java.lang.Object analysis;
            private final java.lang.String attribute;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.analysis = software.amazon.jsii.Kernel.get(this, "analysis", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.attribute = software.amazon.jsii.Kernel.get(this, "attribute", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.analysis = builder.analysis;
                this.attribute = builder.attribute;
            }

            @Override
            public final java.lang.Object getAnalysis() {
                return this.analysis;
            }

            @Override
            public final java.lang.String getAttribute() {
                return this.attribute;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getAnalysis() != null) {
                    data.set("analysis", om.valueToTree(this.getAnalysis()));
                }
                if (this.getAttribute() != null) {
                    data.set("attribute", om.valueToTree(this.getAttribute()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ses.CfnMailManagerRuleSet.RuleBooleanToEvaluateProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                RuleBooleanToEvaluateProperty.Jsii$Proxy that = (RuleBooleanToEvaluateProperty.Jsii$Proxy) o;

                if (this.analysis != null ? !this.analysis.equals(that.analysis) : that.analysis != null) return false;
                return this.attribute != null ? this.attribute.equals(that.attribute) : that.attribute == null;
            }

            @Override
            public final int hashCode() {
                int result = this.analysis != null ? this.analysis.hashCode() : 0;
                result = 31 * result + (this.attribute != null ? this.attribute.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The conditional expression used to evaluate an email for determining if a rule action should be taken.
     * <p>
     * <blockquote>
     * <p>
     * This data type is a UNION, so only one of the following members can be specified when used or returned.
     * <p>
     * </blockquote>
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.ses.*;
     * RuleConditionProperty ruleConditionProperty = RuleConditionProperty.builder()
     *         .booleanExpression(RuleBooleanExpressionProperty.builder()
     *                 .evaluate(RuleBooleanToEvaluateProperty.builder()
     *                         .analysis(AnalysisProperty.builder()
     *                                 .analyzer("analyzer")
     *                                 .resultField("resultField")
     *                                 .build())
     *                         .attribute("attribute")
     *                         .build())
     *                 .operator("operator")
     *                 .build())
     *         .dmarcExpression(RuleDmarcExpressionProperty.builder()
     *                 .operator("operator")
     *                 .values(List.of("values"))
     *                 .build())
     *         .ipExpression(RuleIpExpressionProperty.builder()
     *                 .evaluate(RuleIpToEvaluateProperty.builder()
     *                         .attribute("attribute")
     *                         .build())
     *                 .operator("operator")
     *                 .values(List.of("values"))
     *                 .build())
     *         .numberExpression(RuleNumberExpressionProperty.builder()
     *                 .evaluate(RuleNumberToEvaluateProperty.builder()
     *                         .attribute("attribute")
     *                         .build())
     *                 .operator("operator")
     *                 .value(123)
     *                 .build())
     *         .stringExpression(RuleStringExpressionProperty.builder()
     *                 .evaluate(RuleStringToEvaluateProperty.builder()
     *                         .analysis(AnalysisProperty.builder()
     *                                 .analyzer("analyzer")
     *                                 .resultField("resultField")
     *                                 .build())
     *                         .attribute("attribute")
     *                         .mimeHeaderAttribute("mimeHeaderAttribute")
     *                         .build())
     *                 .operator("operator")
     *                 .values(List.of("values"))
     *                 .build())
     *         .verdictExpression(RuleVerdictExpressionProperty.builder()
     *                 .evaluate(RuleVerdictToEvaluateProperty.builder()
     *                         .analysis(AnalysisProperty.builder()
     *                                 .analyzer("analyzer")
     *                                 .resultField("resultField")
     *                                 .build())
     *                         .attribute("attribute")
     *                         .build())
     *                 .operator("operator")
     *                 .values(List.of("values"))
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ses-mailmanagerruleset-rulecondition.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ses-mailmanagerruleset-rulecondition.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ses.CfnMailManagerRuleSet.RuleConditionProperty")
    @software.amazon.jsii.Jsii.Proxy(RuleConditionProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface RuleConditionProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The condition applies to a boolean expression passed in this field.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ses-mailmanagerruleset-rulecondition.html#cfn-ses-mailmanagerruleset-rulecondition-booleanexpression">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ses-mailmanagerruleset-rulecondition.html#cfn-ses-mailmanagerruleset-rulecondition-booleanexpression</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getBooleanExpression() {
            return null;
        }

        /**
         * The condition applies to a DMARC policy expression passed in this field.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ses-mailmanagerruleset-rulecondition.html#cfn-ses-mailmanagerruleset-rulecondition-dmarcexpression">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ses-mailmanagerruleset-rulecondition.html#cfn-ses-mailmanagerruleset-rulecondition-dmarcexpression</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getDmarcExpression() {
            return null;
        }

        /**
         * The condition applies to an IP address expression passed in this field.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ses-mailmanagerruleset-rulecondition.html#cfn-ses-mailmanagerruleset-rulecondition-ipexpression">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ses-mailmanagerruleset-rulecondition.html#cfn-ses-mailmanagerruleset-rulecondition-ipexpression</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getIpExpression() {
            return null;
        }

        /**
         * The condition applies to a number expression passed in this field.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ses-mailmanagerruleset-rulecondition.html#cfn-ses-mailmanagerruleset-rulecondition-numberexpression">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ses-mailmanagerruleset-rulecondition.html#cfn-ses-mailmanagerruleset-rulecondition-numberexpression</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getNumberExpression() {
            return null;
        }

        /**
         * The condition applies to a string expression passed in this field.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ses-mailmanagerruleset-rulecondition.html#cfn-ses-mailmanagerruleset-rulecondition-stringexpression">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ses-mailmanagerruleset-rulecondition.html#cfn-ses-mailmanagerruleset-rulecondition-stringexpression</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getStringExpression() {
            return null;
        }

        /**
         * The condition applies to a verdict expression passed in this field.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ses-mailmanagerruleset-rulecondition.html#cfn-ses-mailmanagerruleset-rulecondition-verdictexpression">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ses-mailmanagerruleset-rulecondition.html#cfn-ses-mailmanagerruleset-rulecondition-verdictexpression</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getVerdictExpression() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link RuleConditionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link RuleConditionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<RuleConditionProperty> {
            java.lang.Object booleanExpression;
            java.lang.Object dmarcExpression;
            java.lang.Object ipExpression;
            java.lang.Object numberExpression;
            java.lang.Object stringExpression;
            java.lang.Object verdictExpression;

            /**
             * Sets the value of {@link RuleConditionProperty#getBooleanExpression}
             * @param booleanExpression The condition applies to a boolean expression passed in this field.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder booleanExpression(software.amazon.awscdk.IResolvable booleanExpression) {
                this.booleanExpression = booleanExpression;
                return this;
            }

            /**
             * Sets the value of {@link RuleConditionProperty#getBooleanExpression}
             * @param booleanExpression The condition applies to a boolean expression passed in this field.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder booleanExpression(software.amazon.awscdk.services.ses.CfnMailManagerRuleSet.RuleBooleanExpressionProperty booleanExpression) {
                this.booleanExpression = booleanExpression;
                return this;
            }

            /**
             * Sets the value of {@link RuleConditionProperty#getDmarcExpression}
             * @param dmarcExpression The condition applies to a DMARC policy expression passed in this field.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dmarcExpression(software.amazon.awscdk.IResolvable dmarcExpression) {
                this.dmarcExpression = dmarcExpression;
                return this;
            }

            /**
             * Sets the value of {@link RuleConditionProperty#getDmarcExpression}
             * @param dmarcExpression The condition applies to a DMARC policy expression passed in this field.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dmarcExpression(software.amazon.awscdk.services.ses.CfnMailManagerRuleSet.RuleDmarcExpressionProperty dmarcExpression) {
                this.dmarcExpression = dmarcExpression;
                return this;
            }

            /**
             * Sets the value of {@link RuleConditionProperty#getIpExpression}
             * @param ipExpression The condition applies to an IP address expression passed in this field.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder ipExpression(software.amazon.awscdk.IResolvable ipExpression) {
                this.ipExpression = ipExpression;
                return this;
            }

            /**
             * Sets the value of {@link RuleConditionProperty#getIpExpression}
             * @param ipExpression The condition applies to an IP address expression passed in this field.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder ipExpression(software.amazon.awscdk.services.ses.CfnMailManagerRuleSet.RuleIpExpressionProperty ipExpression) {
                this.ipExpression = ipExpression;
                return this;
            }

            /**
             * Sets the value of {@link RuleConditionProperty#getNumberExpression}
             * @param numberExpression The condition applies to a number expression passed in this field.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder numberExpression(software.amazon.awscdk.IResolvable numberExpression) {
                this.numberExpression = numberExpression;
                return this;
            }

            /**
             * Sets the value of {@link RuleConditionProperty#getNumberExpression}
             * @param numberExpression The condition applies to a number expression passed in this field.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder numberExpression(software.amazon.awscdk.services.ses.CfnMailManagerRuleSet.RuleNumberExpressionProperty numberExpression) {
                this.numberExpression = numberExpression;
                return this;
            }

            /**
             * Sets the value of {@link RuleConditionProperty#getStringExpression}
             * @param stringExpression The condition applies to a string expression passed in this field.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder stringExpression(software.amazon.awscdk.IResolvable stringExpression) {
                this.stringExpression = stringExpression;
                return this;
            }

            /**
             * Sets the value of {@link RuleConditionProperty#getStringExpression}
             * @param stringExpression The condition applies to a string expression passed in this field.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder stringExpression(software.amazon.awscdk.services.ses.CfnMailManagerRuleSet.RuleStringExpressionProperty stringExpression) {
                this.stringExpression = stringExpression;
                return this;
            }

            /**
             * Sets the value of {@link RuleConditionProperty#getVerdictExpression}
             * @param verdictExpression The condition applies to a verdict expression passed in this field.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder verdictExpression(software.amazon.awscdk.IResolvable verdictExpression) {
                this.verdictExpression = verdictExpression;
                return this;
            }

            /**
             * Sets the value of {@link RuleConditionProperty#getVerdictExpression}
             * @param verdictExpression The condition applies to a verdict expression passed in this field.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder verdictExpression(software.amazon.awscdk.services.ses.CfnMailManagerRuleSet.RuleVerdictExpressionProperty verdictExpression) {
                this.verdictExpression = verdictExpression;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link RuleConditionProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public RuleConditionProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link RuleConditionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements RuleConditionProperty {
            private final java.lang.Object booleanExpression;
            private final java.lang.Object dmarcExpression;
            private final java.lang.Object ipExpression;
            private final java.lang.Object numberExpression;
            private final java.lang.Object stringExpression;
            private final java.lang.Object verdictExpression;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.booleanExpression = software.amazon.jsii.Kernel.get(this, "booleanExpression", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.dmarcExpression = software.amazon.jsii.Kernel.get(this, "dmarcExpression", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.ipExpression = software.amazon.jsii.Kernel.get(this, "ipExpression", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.numberExpression = software.amazon.jsii.Kernel.get(this, "numberExpression", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.stringExpression = software.amazon.jsii.Kernel.get(this, "stringExpression", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.verdictExpression = software.amazon.jsii.Kernel.get(this, "verdictExpression", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.booleanExpression = builder.booleanExpression;
                this.dmarcExpression = builder.dmarcExpression;
                this.ipExpression = builder.ipExpression;
                this.numberExpression = builder.numberExpression;
                this.stringExpression = builder.stringExpression;
                this.verdictExpression = builder.verdictExpression;
            }

            @Override
            public final java.lang.Object getBooleanExpression() {
                return this.booleanExpression;
            }

            @Override
            public final java.lang.Object getDmarcExpression() {
                return this.dmarcExpression;
            }

            @Override
            public final java.lang.Object getIpExpression() {
                return this.ipExpression;
            }

            @Override
            public final java.lang.Object getNumberExpression() {
                return this.numberExpression;
            }

            @Override
            public final java.lang.Object getStringExpression() {
                return this.stringExpression;
            }

            @Override
            public final java.lang.Object getVerdictExpression() {
                return this.verdictExpression;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getBooleanExpression() != null) {
                    data.set("booleanExpression", om.valueToTree(this.getBooleanExpression()));
                }
                if (this.getDmarcExpression() != null) {
                    data.set("dmarcExpression", om.valueToTree(this.getDmarcExpression()));
                }
                if (this.getIpExpression() != null) {
                    data.set("ipExpression", om.valueToTree(this.getIpExpression()));
                }
                if (this.getNumberExpression() != null) {
                    data.set("numberExpression", om.valueToTree(this.getNumberExpression()));
                }
                if (this.getStringExpression() != null) {
                    data.set("stringExpression", om.valueToTree(this.getStringExpression()));
                }
                if (this.getVerdictExpression() != null) {
                    data.set("verdictExpression", om.valueToTree(this.getVerdictExpression()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ses.CfnMailManagerRuleSet.RuleConditionProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                RuleConditionProperty.Jsii$Proxy that = (RuleConditionProperty.Jsii$Proxy) o;

                if (this.booleanExpression != null ? !this.booleanExpression.equals(that.booleanExpression) : that.booleanExpression != null) return false;
                if (this.dmarcExpression != null ? !this.dmarcExpression.equals(that.dmarcExpression) : that.dmarcExpression != null) return false;
                if (this.ipExpression != null ? !this.ipExpression.equals(that.ipExpression) : that.ipExpression != null) return false;
                if (this.numberExpression != null ? !this.numberExpression.equals(that.numberExpression) : that.numberExpression != null) return false;
                if (this.stringExpression != null ? !this.stringExpression.equals(that.stringExpression) : that.stringExpression != null) return false;
                return this.verdictExpression != null ? this.verdictExpression.equals(that.verdictExpression) : that.verdictExpression == null;
            }

            @Override
            public final int hashCode() {
                int result = this.booleanExpression != null ? this.booleanExpression.hashCode() : 0;
                result = 31 * result + (this.dmarcExpression != null ? this.dmarcExpression.hashCode() : 0);
                result = 31 * result + (this.ipExpression != null ? this.ipExpression.hashCode() : 0);
                result = 31 * result + (this.numberExpression != null ? this.numberExpression.hashCode() : 0);
                result = 31 * result + (this.stringExpression != null ? this.stringExpression.hashCode() : 0);
                result = 31 * result + (this.verdictExpression != null ? this.verdictExpression.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * A DMARC policy expression.
     * <p>
     * The condition matches if the given DMARC policy matches that of the incoming email.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.ses.*;
     * RuleDmarcExpressionProperty ruleDmarcExpressionProperty = RuleDmarcExpressionProperty.builder()
     *         .operator("operator")
     *         .values(List.of("values"))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ses-mailmanagerruleset-ruledmarcexpression.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ses-mailmanagerruleset-ruledmarcexpression.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ses.CfnMailManagerRuleSet.RuleDmarcExpressionProperty")
    @software.amazon.jsii.Jsii.Proxy(RuleDmarcExpressionProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface RuleDmarcExpressionProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The operator to apply to the DMARC policy of the incoming email.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ses-mailmanagerruleset-ruledmarcexpression.html#cfn-ses-mailmanagerruleset-ruledmarcexpression-operator">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ses-mailmanagerruleset-ruledmarcexpression.html#cfn-ses-mailmanagerruleset-ruledmarcexpression-operator</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getOperator();

        /**
         * The values to use for the given DMARC policy operator.
         * <p>
         * For the operator EQUALS, if multiple values are given, they are evaluated as an OR. That is, if any of the given values match, the condition is deemed to match. For the operator NOT_EQUALS, if multiple values are given, they are evaluated as an AND. That is, only if the email's DMARC policy is not equal to any of the given values, then the condition is deemed to match.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ses-mailmanagerruleset-ruledmarcexpression.html#cfn-ses-mailmanagerruleset-ruledmarcexpression-values">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ses-mailmanagerruleset-ruledmarcexpression.html#cfn-ses-mailmanagerruleset-ruledmarcexpression-values</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> getValues();

        /**
         * @return a {@link Builder} of {@link RuleDmarcExpressionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link RuleDmarcExpressionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<RuleDmarcExpressionProperty> {
            java.lang.String operator;
            java.util.List<java.lang.String> values;

            /**
             * Sets the value of {@link RuleDmarcExpressionProperty#getOperator}
             * @param operator The operator to apply to the DMARC policy of the incoming email. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder operator(java.lang.String operator) {
                this.operator = operator;
                return this;
            }

            /**
             * Sets the value of {@link RuleDmarcExpressionProperty#getValues}
             * @param values The values to use for the given DMARC policy operator. This parameter is required.
             *               For the operator EQUALS, if multiple values are given, they are evaluated as an OR. That is, if any of the given values match, the condition is deemed to match. For the operator NOT_EQUALS, if multiple values are given, they are evaluated as an AND. That is, only if the email's DMARC policy is not equal to any of the given values, then the condition is deemed to match.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder values(java.util.List<java.lang.String> values) {
                this.values = values;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link RuleDmarcExpressionProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public RuleDmarcExpressionProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link RuleDmarcExpressionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements RuleDmarcExpressionProperty {
            private final java.lang.String operator;
            private final java.util.List<java.lang.String> values;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.operator = software.amazon.jsii.Kernel.get(this, "operator", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.values = software.amazon.jsii.Kernel.get(this, "values", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.operator = java.util.Objects.requireNonNull(builder.operator, "operator is required");
                this.values = java.util.Objects.requireNonNull(builder.values, "values is required");
            }

            @Override
            public final java.lang.String getOperator() {
                return this.operator;
            }

            @Override
            public final java.util.List<java.lang.String> getValues() {
                return this.values;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("operator", om.valueToTree(this.getOperator()));
                data.set("values", om.valueToTree(this.getValues()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ses.CfnMailManagerRuleSet.RuleDmarcExpressionProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                RuleDmarcExpressionProperty.Jsii$Proxy that = (RuleDmarcExpressionProperty.Jsii$Proxy) o;

                if (!operator.equals(that.operator)) return false;
                return this.values.equals(that.values);
            }

            @Override
            public final int hashCode() {
                int result = this.operator.hashCode();
                result = 31 * result + (this.values.hashCode());
                return result;
            }
        }
    }
    /**
     * An IP address expression matching certain IP addresses within a given range of IP addresses.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.ses.*;
     * RuleIpExpressionProperty ruleIpExpressionProperty = RuleIpExpressionProperty.builder()
     *         .evaluate(RuleIpToEvaluateProperty.builder()
     *                 .attribute("attribute")
     *                 .build())
     *         .operator("operator")
     *         .values(List.of("values"))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ses-mailmanagerruleset-ruleipexpression.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ses-mailmanagerruleset-ruleipexpression.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ses.CfnMailManagerRuleSet.RuleIpExpressionProperty")
    @software.amazon.jsii.Jsii.Proxy(RuleIpExpressionProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface RuleIpExpressionProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The IP address to evaluate in this condition.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ses-mailmanagerruleset-ruleipexpression.html#cfn-ses-mailmanagerruleset-ruleipexpression-evaluate">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ses-mailmanagerruleset-ruleipexpression.html#cfn-ses-mailmanagerruleset-ruleipexpression-evaluate</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getEvaluate();

        /**
         * The operator to evaluate the IP address.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ses-mailmanagerruleset-ruleipexpression.html#cfn-ses-mailmanagerruleset-ruleipexpression-operator">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ses-mailmanagerruleset-ruleipexpression.html#cfn-ses-mailmanagerruleset-ruleipexpression-operator</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getOperator();

        /**
         * The IP CIDR blocks in format "x.y.z.w/n" (eg 10.0.0.0/8) to match with the email's IP address. For the operator CIDR_MATCHES, if multiple values are given, they are evaluated as an OR. That is, if the IP address is contained within any of the given CIDR ranges, the condition is deemed to match. For NOT_CIDR_MATCHES, if multiple CIDR ranges are given, the condition is deemed to match if the IP address is not contained in any of the given CIDR ranges.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ses-mailmanagerruleset-ruleipexpression.html#cfn-ses-mailmanagerruleset-ruleipexpression-values">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ses-mailmanagerruleset-ruleipexpression.html#cfn-ses-mailmanagerruleset-ruleipexpression-values</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> getValues();

        /**
         * @return a {@link Builder} of {@link RuleIpExpressionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link RuleIpExpressionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<RuleIpExpressionProperty> {
            java.lang.Object evaluate;
            java.lang.String operator;
            java.util.List<java.lang.String> values;

            /**
             * Sets the value of {@link RuleIpExpressionProperty#getEvaluate}
             * @param evaluate The IP address to evaluate in this condition. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder evaluate(software.amazon.awscdk.IResolvable evaluate) {
                this.evaluate = evaluate;
                return this;
            }

            /**
             * Sets the value of {@link RuleIpExpressionProperty#getEvaluate}
             * @param evaluate The IP address to evaluate in this condition. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder evaluate(software.amazon.awscdk.services.ses.CfnMailManagerRuleSet.RuleIpToEvaluateProperty evaluate) {
                this.evaluate = evaluate;
                return this;
            }

            /**
             * Sets the value of {@link RuleIpExpressionProperty#getOperator}
             * @param operator The operator to evaluate the IP address. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder operator(java.lang.String operator) {
                this.operator = operator;
                return this;
            }

            /**
             * Sets the value of {@link RuleIpExpressionProperty#getValues}
             * @param values The IP CIDR blocks in format "x.y.z.w/n" (eg 10.0.0.0/8) to match with the email's IP address. For the operator CIDR_MATCHES, if multiple values are given, they are evaluated as an OR. That is, if the IP address is contained within any of the given CIDR ranges, the condition is deemed to match. For NOT_CIDR_MATCHES, if multiple CIDR ranges are given, the condition is deemed to match if the IP address is not contained in any of the given CIDR ranges. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder values(java.util.List<java.lang.String> values) {
                this.values = values;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link RuleIpExpressionProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public RuleIpExpressionProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link RuleIpExpressionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements RuleIpExpressionProperty {
            private final java.lang.Object evaluate;
            private final java.lang.String operator;
            private final java.util.List<java.lang.String> values;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.evaluate = software.amazon.jsii.Kernel.get(this, "evaluate", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.operator = software.amazon.jsii.Kernel.get(this, "operator", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.values = software.amazon.jsii.Kernel.get(this, "values", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.evaluate = java.util.Objects.requireNonNull(builder.evaluate, "evaluate is required");
                this.operator = java.util.Objects.requireNonNull(builder.operator, "operator is required");
                this.values = java.util.Objects.requireNonNull(builder.values, "values is required");
            }

            @Override
            public final java.lang.Object getEvaluate() {
                return this.evaluate;
            }

            @Override
            public final java.lang.String getOperator() {
                return this.operator;
            }

            @Override
            public final java.util.List<java.lang.String> getValues() {
                return this.values;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("evaluate", om.valueToTree(this.getEvaluate()));
                data.set("operator", om.valueToTree(this.getOperator()));
                data.set("values", om.valueToTree(this.getValues()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ses.CfnMailManagerRuleSet.RuleIpExpressionProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                RuleIpExpressionProperty.Jsii$Proxy that = (RuleIpExpressionProperty.Jsii$Proxy) o;

                if (!evaluate.equals(that.evaluate)) return false;
                if (!operator.equals(that.operator)) return false;
                return this.values.equals(that.values);
            }

            @Override
            public final int hashCode() {
                int result = this.evaluate.hashCode();
                result = 31 * result + (this.operator.hashCode());
                result = 31 * result + (this.values.hashCode());
                return result;
            }
        }
    }
    /**
     * The IP address to evaluate for this condition.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.ses.*;
     * RuleIpToEvaluateProperty ruleIpToEvaluateProperty = RuleIpToEvaluateProperty.builder()
     *         .attribute("attribute")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ses-mailmanagerruleset-ruleiptoevaluate.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ses-mailmanagerruleset-ruleiptoevaluate.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ses.CfnMailManagerRuleSet.RuleIpToEvaluateProperty")
    @software.amazon.jsii.Jsii.Proxy(RuleIpToEvaluateProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface RuleIpToEvaluateProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The attribute of the email to evaluate.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ses-mailmanagerruleset-ruleiptoevaluate.html#cfn-ses-mailmanagerruleset-ruleiptoevaluate-attribute">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ses-mailmanagerruleset-ruleiptoevaluate.html#cfn-ses-mailmanagerruleset-ruleiptoevaluate-attribute</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getAttribute();

        /**
         * @return a {@link Builder} of {@link RuleIpToEvaluateProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link RuleIpToEvaluateProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<RuleIpToEvaluateProperty> {
            java.lang.String attribute;

            /**
             * Sets the value of {@link RuleIpToEvaluateProperty#getAttribute}
             * @param attribute The attribute of the email to evaluate. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder attribute(java.lang.String attribute) {
                this.attribute = attribute;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link RuleIpToEvaluateProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public RuleIpToEvaluateProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link RuleIpToEvaluateProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements RuleIpToEvaluateProperty {
            private final java.lang.String attribute;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.attribute = software.amazon.jsii.Kernel.get(this, "attribute", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.attribute = java.util.Objects.requireNonNull(builder.attribute, "attribute is required");
            }

            @Override
            public final java.lang.String getAttribute() {
                return this.attribute;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("attribute", om.valueToTree(this.getAttribute()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ses.CfnMailManagerRuleSet.RuleIpToEvaluateProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                RuleIpToEvaluateProperty.Jsii$Proxy that = (RuleIpToEvaluateProperty.Jsii$Proxy) o;

                return this.attribute.equals(that.attribute);
            }

            @Override
            public final int hashCode() {
                int result = this.attribute.hashCode();
                return result;
            }
        }
    }
    /**
     * A number expression to match numeric conditions with integers from the incoming email.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.ses.*;
     * RuleNumberExpressionProperty ruleNumberExpressionProperty = RuleNumberExpressionProperty.builder()
     *         .evaluate(RuleNumberToEvaluateProperty.builder()
     *                 .attribute("attribute")
     *                 .build())
     *         .operator("operator")
     *         .value(123)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ses-mailmanagerruleset-rulenumberexpression.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ses-mailmanagerruleset-rulenumberexpression.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ses.CfnMailManagerRuleSet.RuleNumberExpressionProperty")
    @software.amazon.jsii.Jsii.Proxy(RuleNumberExpressionProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface RuleNumberExpressionProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The number to evaluate in a numeric condition expression.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ses-mailmanagerruleset-rulenumberexpression.html#cfn-ses-mailmanagerruleset-rulenumberexpression-evaluate">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ses-mailmanagerruleset-rulenumberexpression.html#cfn-ses-mailmanagerruleset-rulenumberexpression-evaluate</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getEvaluate();

        /**
         * The operator for a numeric condition expression.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ses-mailmanagerruleset-rulenumberexpression.html#cfn-ses-mailmanagerruleset-rulenumberexpression-operator">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ses-mailmanagerruleset-rulenumberexpression.html#cfn-ses-mailmanagerruleset-rulenumberexpression-operator</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getOperator();

        /**
         * The value to evaluate in a numeric condition expression.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ses-mailmanagerruleset-rulenumberexpression.html#cfn-ses-mailmanagerruleset-rulenumberexpression-value">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ses-mailmanagerruleset-rulenumberexpression.html#cfn-ses-mailmanagerruleset-rulenumberexpression-value</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Number getValue();

        /**
         * @return a {@link Builder} of {@link RuleNumberExpressionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link RuleNumberExpressionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<RuleNumberExpressionProperty> {
            java.lang.Object evaluate;
            java.lang.String operator;
            java.lang.Number value;

            /**
             * Sets the value of {@link RuleNumberExpressionProperty#getEvaluate}
             * @param evaluate The number to evaluate in a numeric condition expression. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder evaluate(software.amazon.awscdk.IResolvable evaluate) {
                this.evaluate = evaluate;
                return this;
            }

            /**
             * Sets the value of {@link RuleNumberExpressionProperty#getEvaluate}
             * @param evaluate The number to evaluate in a numeric condition expression. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder evaluate(software.amazon.awscdk.services.ses.CfnMailManagerRuleSet.RuleNumberToEvaluateProperty evaluate) {
                this.evaluate = evaluate;
                return this;
            }

            /**
             * Sets the value of {@link RuleNumberExpressionProperty#getOperator}
             * @param operator The operator for a numeric condition expression. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder operator(java.lang.String operator) {
                this.operator = operator;
                return this;
            }

            /**
             * Sets the value of {@link RuleNumberExpressionProperty#getValue}
             * @param value The value to evaluate in a numeric condition expression. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder value(java.lang.Number value) {
                this.value = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link RuleNumberExpressionProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public RuleNumberExpressionProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link RuleNumberExpressionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements RuleNumberExpressionProperty {
            private final java.lang.Object evaluate;
            private final java.lang.String operator;
            private final java.lang.Number value;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.evaluate = software.amazon.jsii.Kernel.get(this, "evaluate", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.operator = software.amazon.jsii.Kernel.get(this, "operator", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.value = software.amazon.jsii.Kernel.get(this, "value", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.evaluate = java.util.Objects.requireNonNull(builder.evaluate, "evaluate is required");
                this.operator = java.util.Objects.requireNonNull(builder.operator, "operator is required");
                this.value = java.util.Objects.requireNonNull(builder.value, "value is required");
            }

            @Override
            public final java.lang.Object getEvaluate() {
                return this.evaluate;
            }

            @Override
            public final java.lang.String getOperator() {
                return this.operator;
            }

            @Override
            public final java.lang.Number getValue() {
                return this.value;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("evaluate", om.valueToTree(this.getEvaluate()));
                data.set("operator", om.valueToTree(this.getOperator()));
                data.set("value", om.valueToTree(this.getValue()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ses.CfnMailManagerRuleSet.RuleNumberExpressionProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                RuleNumberExpressionProperty.Jsii$Proxy that = (RuleNumberExpressionProperty.Jsii$Proxy) o;

                if (!evaluate.equals(that.evaluate)) return false;
                if (!operator.equals(that.operator)) return false;
                return this.value.equals(that.value);
            }

            @Override
            public final int hashCode() {
                int result = this.evaluate.hashCode();
                result = 31 * result + (this.operator.hashCode());
                result = 31 * result + (this.value.hashCode());
                return result;
            }
        }
    }
    /**
     * The number to evaluate in a numeric condition expression.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.ses.*;
     * RuleNumberToEvaluateProperty ruleNumberToEvaluateProperty = RuleNumberToEvaluateProperty.builder()
     *         .attribute("attribute")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ses-mailmanagerruleset-rulenumbertoevaluate.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ses-mailmanagerruleset-rulenumbertoevaluate.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ses.CfnMailManagerRuleSet.RuleNumberToEvaluateProperty")
    @software.amazon.jsii.Jsii.Proxy(RuleNumberToEvaluateProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface RuleNumberToEvaluateProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * An email attribute that is used as the number to evaluate.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ses-mailmanagerruleset-rulenumbertoevaluate.html#cfn-ses-mailmanagerruleset-rulenumbertoevaluate-attribute">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ses-mailmanagerruleset-rulenumbertoevaluate.html#cfn-ses-mailmanagerruleset-rulenumbertoevaluate-attribute</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getAttribute();

        /**
         * @return a {@link Builder} of {@link RuleNumberToEvaluateProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link RuleNumberToEvaluateProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<RuleNumberToEvaluateProperty> {
            java.lang.String attribute;

            /**
             * Sets the value of {@link RuleNumberToEvaluateProperty#getAttribute}
             * @param attribute An email attribute that is used as the number to evaluate. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder attribute(java.lang.String attribute) {
                this.attribute = attribute;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link RuleNumberToEvaluateProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public RuleNumberToEvaluateProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link RuleNumberToEvaluateProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements RuleNumberToEvaluateProperty {
            private final java.lang.String attribute;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.attribute = software.amazon.jsii.Kernel.get(this, "attribute", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.attribute = java.util.Objects.requireNonNull(builder.attribute, "attribute is required");
            }

            @Override
            public final java.lang.String getAttribute() {
                return this.attribute;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("attribute", om.valueToTree(this.getAttribute()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ses.CfnMailManagerRuleSet.RuleNumberToEvaluateProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                RuleNumberToEvaluateProperty.Jsii$Proxy that = (RuleNumberToEvaluateProperty.Jsii$Proxy) o;

                return this.attribute.equals(that.attribute);
            }

            @Override
            public final int hashCode() {
                int result = this.attribute.hashCode();
                return result;
            }
        }
    }
    /**
     * A rule contains conditions, "unless conditions" and actions.
     * <p>
     * For each envelope recipient of an email, if all conditions match and none of the "unless conditions" match, then all of the actions are executed sequentially. If no conditions are provided, the rule always applies and the actions are implicitly executed. If only "unless conditions" are provided, the rule applies if the email does not match the evaluation of the "unless conditions".
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.ses.*;
     * Object drop;
     * RuleProperty ruleProperty = RuleProperty.builder()
     *         .actions(List.of(RuleActionProperty.builder()
     *                 .addHeader(AddHeaderActionProperty.builder()
     *                         .headerName("headerName")
     *                         .headerValue("headerValue")
     *                         .build())
     *                 .archive(ArchiveActionProperty.builder()
     *                         .targetArchive("targetArchive")
     *                         // the properties below are optional
     *                         .actionFailurePolicy("actionFailurePolicy")
     *                         .build())
     *                 .deliverToMailbox(DeliverToMailboxActionProperty.builder()
     *                         .mailboxArn("mailboxArn")
     *                         .roleArn("roleArn")
     *                         // the properties below are optional
     *                         .actionFailurePolicy("actionFailurePolicy")
     *                         .build())
     *                 .deliverToQBusiness(DeliverToQBusinessActionProperty.builder()
     *                         .applicationId("applicationId")
     *                         .indexId("indexId")
     *                         .roleArn("roleArn")
     *                         // the properties below are optional
     *                         .actionFailurePolicy("actionFailurePolicy")
     *                         .build())
     *                 .drop(drop)
     *                 .relay(RelayActionProperty.builder()
     *                         .relay("relay")
     *                         // the properties below are optional
     *                         .actionFailurePolicy("actionFailurePolicy")
     *                         .mailFrom("mailFrom")
     *                         .build())
     *                 .replaceRecipient(ReplaceRecipientActionProperty.builder()
     *                         .replaceWith(List.of("replaceWith"))
     *                         .build())
     *                 .send(SendActionProperty.builder()
     *                         .roleArn("roleArn")
     *                         // the properties below are optional
     *                         .actionFailurePolicy("actionFailurePolicy")
     *                         .build())
     *                 .writeToS3(S3ActionProperty.builder()
     *                         .roleArn("roleArn")
     *                         .s3Bucket("s3Bucket")
     *                         // the properties below are optional
     *                         .actionFailurePolicy("actionFailurePolicy")
     *                         .s3Prefix("s3Prefix")
     *                         .s3SseKmsKeyId("s3SseKmsKeyId")
     *                         .build())
     *                 .build()))
     *         // the properties below are optional
     *         .conditions(List.of(RuleConditionProperty.builder()
     *                 .booleanExpression(RuleBooleanExpressionProperty.builder()
     *                         .evaluate(RuleBooleanToEvaluateProperty.builder()
     *                                 .analysis(AnalysisProperty.builder()
     *                                         .analyzer("analyzer")
     *                                         .resultField("resultField")
     *                                         .build())
     *                                 .attribute("attribute")
     *                                 .build())
     *                         .operator("operator")
     *                         .build())
     *                 .dmarcExpression(RuleDmarcExpressionProperty.builder()
     *                         .operator("operator")
     *                         .values(List.of("values"))
     *                         .build())
     *                 .ipExpression(RuleIpExpressionProperty.builder()
     *                         .evaluate(RuleIpToEvaluateProperty.builder()
     *                                 .attribute("attribute")
     *                                 .build())
     *                         .operator("operator")
     *                         .values(List.of("values"))
     *                         .build())
     *                 .numberExpression(RuleNumberExpressionProperty.builder()
     *                         .evaluate(RuleNumberToEvaluateProperty.builder()
     *                                 .attribute("attribute")
     *                                 .build())
     *                         .operator("operator")
     *                         .value(123)
     *                         .build())
     *                 .stringExpression(RuleStringExpressionProperty.builder()
     *                         .evaluate(RuleStringToEvaluateProperty.builder()
     *                                 .analysis(AnalysisProperty.builder()
     *                                         .analyzer("analyzer")
     *                                         .resultField("resultField")
     *                                         .build())
     *                                 .attribute("attribute")
     *                                 .mimeHeaderAttribute("mimeHeaderAttribute")
     *                                 .build())
     *                         .operator("operator")
     *                         .values(List.of("values"))
     *                         .build())
     *                 .verdictExpression(RuleVerdictExpressionProperty.builder()
     *                         .evaluate(RuleVerdictToEvaluateProperty.builder()
     *                                 .analysis(AnalysisProperty.builder()
     *                                         .analyzer("analyzer")
     *                                         .resultField("resultField")
     *                                         .build())
     *                                 .attribute("attribute")
     *                                 .build())
     *                         .operator("operator")
     *                         .values(List.of("values"))
     *                         .build())
     *                 .build()))
     *         .name("name")
     *         .unless(List.of(RuleConditionProperty.builder()
     *                 .booleanExpression(RuleBooleanExpressionProperty.builder()
     *                         .evaluate(RuleBooleanToEvaluateProperty.builder()
     *                                 .analysis(AnalysisProperty.builder()
     *                                         .analyzer("analyzer")
     *                                         .resultField("resultField")
     *                                         .build())
     *                                 .attribute("attribute")
     *                                 .build())
     *                         .operator("operator")
     *                         .build())
     *                 .dmarcExpression(RuleDmarcExpressionProperty.builder()
     *                         .operator("operator")
     *                         .values(List.of("values"))
     *                         .build())
     *                 .ipExpression(RuleIpExpressionProperty.builder()
     *                         .evaluate(RuleIpToEvaluateProperty.builder()
     *                                 .attribute("attribute")
     *                                 .build())
     *                         .operator("operator")
     *                         .values(List.of("values"))
     *                         .build())
     *                 .numberExpression(RuleNumberExpressionProperty.builder()
     *                         .evaluate(RuleNumberToEvaluateProperty.builder()
     *                                 .attribute("attribute")
     *                                 .build())
     *                         .operator("operator")
     *                         .value(123)
     *                         .build())
     *                 .stringExpression(RuleStringExpressionProperty.builder()
     *                         .evaluate(RuleStringToEvaluateProperty.builder()
     *                                 .analysis(AnalysisProperty.builder()
     *                                         .analyzer("analyzer")
     *                                         .resultField("resultField")
     *                                         .build())
     *                                 .attribute("attribute")
     *                                 .mimeHeaderAttribute("mimeHeaderAttribute")
     *                                 .build())
     *                         .operator("operator")
     *                         .values(List.of("values"))
     *                         .build())
     *                 .verdictExpression(RuleVerdictExpressionProperty.builder()
     *                         .evaluate(RuleVerdictToEvaluateProperty.builder()
     *                                 .analysis(AnalysisProperty.builder()
     *                                         .analyzer("analyzer")
     *                                         .resultField("resultField")
     *                                         .build())
     *                                 .attribute("attribute")
     *                                 .build())
     *                         .operator("operator")
     *                         .values(List.of("values"))
     *                         .build())
     *                 .build()))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ses-mailmanagerruleset-rule.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ses-mailmanagerruleset-rule.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ses.CfnMailManagerRuleSet.RuleProperty")
    @software.amazon.jsii.Jsii.Proxy(RuleProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface RuleProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The list of actions to execute when the conditions match the incoming email, and none of the "unless conditions" match.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ses-mailmanagerruleset-rule.html#cfn-ses-mailmanagerruleset-rule-actions">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ses-mailmanagerruleset-rule.html#cfn-ses-mailmanagerruleset-rule-actions</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getActions();

        /**
         * The conditions of this rule.
         * <p>
         * All conditions must match the email for the actions to be executed. An empty list of conditions means that all emails match, but are still subject to any "unless conditions"
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ses-mailmanagerruleset-rule.html#cfn-ses-mailmanagerruleset-rule-conditions">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ses-mailmanagerruleset-rule.html#cfn-ses-mailmanagerruleset-rule-conditions</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getConditions() {
            return null;
        }

        /**
         * The user-friendly name of the rule.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ses-mailmanagerruleset-rule.html#cfn-ses-mailmanagerruleset-rule-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ses-mailmanagerruleset-rule.html#cfn-ses-mailmanagerruleset-rule-name</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getName() {
            return null;
        }

        /**
         * The "unless conditions" of this rule.
         * <p>
         * None of the conditions can match the email for the actions to be executed. If any of these conditions do match the email, then the actions are not executed.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ses-mailmanagerruleset-rule.html#cfn-ses-mailmanagerruleset-rule-unless">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ses-mailmanagerruleset-rule.html#cfn-ses-mailmanagerruleset-rule-unless</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getUnless() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link RuleProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link RuleProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<RuleProperty> {
            java.lang.Object actions;
            java.lang.Object conditions;
            java.lang.String name;
            java.lang.Object unless;

            /**
             * Sets the value of {@link RuleProperty#getActions}
             * @param actions The list of actions to execute when the conditions match the incoming email, and none of the "unless conditions" match. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder actions(software.amazon.awscdk.IResolvable actions) {
                this.actions = actions;
                return this;
            }

            /**
             * Sets the value of {@link RuleProperty#getActions}
             * @param actions The list of actions to execute when the conditions match the incoming email, and none of the "unless conditions" match. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder actions(java.util.List<? extends java.lang.Object> actions) {
                this.actions = actions;
                return this;
            }

            /**
             * Sets the value of {@link RuleProperty#getConditions}
             * @param conditions The conditions of this rule.
             *                   All conditions must match the email for the actions to be executed. An empty list of conditions means that all emails match, but are still subject to any "unless conditions"
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder conditions(software.amazon.awscdk.IResolvable conditions) {
                this.conditions = conditions;
                return this;
            }

            /**
             * Sets the value of {@link RuleProperty#getConditions}
             * @param conditions The conditions of this rule.
             *                   All conditions must match the email for the actions to be executed. An empty list of conditions means that all emails match, but are still subject to any "unless conditions"
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder conditions(java.util.List<? extends java.lang.Object> conditions) {
                this.conditions = conditions;
                return this;
            }

            /**
             * Sets the value of {@link RuleProperty#getName}
             * @param name The user-friendly name of the rule.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder name(java.lang.String name) {
                this.name = name;
                return this;
            }

            /**
             * Sets the value of {@link RuleProperty#getUnless}
             * @param unless The "unless conditions" of this rule.
             *               None of the conditions can match the email for the actions to be executed. If any of these conditions do match the email, then the actions are not executed.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder unless(software.amazon.awscdk.IResolvable unless) {
                this.unless = unless;
                return this;
            }

            /**
             * Sets the value of {@link RuleProperty#getUnless}
             * @param unless The "unless conditions" of this rule.
             *               None of the conditions can match the email for the actions to be executed. If any of these conditions do match the email, then the actions are not executed.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder unless(java.util.List<? extends java.lang.Object> unless) {
                this.unless = unless;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link RuleProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public RuleProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link RuleProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements RuleProperty {
            private final java.lang.Object actions;
            private final java.lang.Object conditions;
            private final java.lang.String name;
            private final java.lang.Object unless;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.actions = software.amazon.jsii.Kernel.get(this, "actions", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.conditions = software.amazon.jsii.Kernel.get(this, "conditions", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.unless = software.amazon.jsii.Kernel.get(this, "unless", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.actions = java.util.Objects.requireNonNull(builder.actions, "actions is required");
                this.conditions = builder.conditions;
                this.name = builder.name;
                this.unless = builder.unless;
            }

            @Override
            public final java.lang.Object getActions() {
                return this.actions;
            }

            @Override
            public final java.lang.Object getConditions() {
                return this.conditions;
            }

            @Override
            public final java.lang.String getName() {
                return this.name;
            }

            @Override
            public final java.lang.Object getUnless() {
                return this.unless;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("actions", om.valueToTree(this.getActions()));
                if (this.getConditions() != null) {
                    data.set("conditions", om.valueToTree(this.getConditions()));
                }
                if (this.getName() != null) {
                    data.set("name", om.valueToTree(this.getName()));
                }
                if (this.getUnless() != null) {
                    data.set("unless", om.valueToTree(this.getUnless()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ses.CfnMailManagerRuleSet.RuleProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                RuleProperty.Jsii$Proxy that = (RuleProperty.Jsii$Proxy) o;

                if (!actions.equals(that.actions)) return false;
                if (this.conditions != null ? !this.conditions.equals(that.conditions) : that.conditions != null) return false;
                if (this.name != null ? !this.name.equals(that.name) : that.name != null) return false;
                return this.unless != null ? this.unless.equals(that.unless) : that.unless == null;
            }

            @Override
            public final int hashCode() {
                int result = this.actions.hashCode();
                result = 31 * result + (this.conditions != null ? this.conditions.hashCode() : 0);
                result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
                result = 31 * result + (this.unless != null ? this.unless.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * A string expression is evaluated against strings or substrings of the email.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.ses.*;
     * RuleStringExpressionProperty ruleStringExpressionProperty = RuleStringExpressionProperty.builder()
     *         .evaluate(RuleStringToEvaluateProperty.builder()
     *                 .analysis(AnalysisProperty.builder()
     *                         .analyzer("analyzer")
     *                         .resultField("resultField")
     *                         .build())
     *                 .attribute("attribute")
     *                 .mimeHeaderAttribute("mimeHeaderAttribute")
     *                 .build())
     *         .operator("operator")
     *         .values(List.of("values"))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ses-mailmanagerruleset-rulestringexpression.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ses-mailmanagerruleset-rulestringexpression.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ses.CfnMailManagerRuleSet.RuleStringExpressionProperty")
    @software.amazon.jsii.Jsii.Proxy(RuleStringExpressionProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface RuleStringExpressionProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The string to evaluate in a string condition expression.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ses-mailmanagerruleset-rulestringexpression.html#cfn-ses-mailmanagerruleset-rulestringexpression-evaluate">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ses-mailmanagerruleset-rulestringexpression.html#cfn-ses-mailmanagerruleset-rulestringexpression-evaluate</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getEvaluate();

        /**
         * The matching operator for a string condition expression.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ses-mailmanagerruleset-rulestringexpression.html#cfn-ses-mailmanagerruleset-rulestringexpression-operator">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ses-mailmanagerruleset-rulestringexpression.html#cfn-ses-mailmanagerruleset-rulestringexpression-operator</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getOperator();

        /**
         * The string(s) to be evaluated in a string condition expression.
         * <p>
         * For all operators, except for NOT_EQUALS, if multiple values are given, the values are processed as an OR. That is, if any of the values match the email's string using the given operator, the condition is deemed to match. However, for NOT_EQUALS, the condition is only deemed to match if none of the given strings match the email's string.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ses-mailmanagerruleset-rulestringexpression.html#cfn-ses-mailmanagerruleset-rulestringexpression-values">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ses-mailmanagerruleset-rulestringexpression.html#cfn-ses-mailmanagerruleset-rulestringexpression-values</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> getValues();

        /**
         * @return a {@link Builder} of {@link RuleStringExpressionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link RuleStringExpressionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<RuleStringExpressionProperty> {
            java.lang.Object evaluate;
            java.lang.String operator;
            java.util.List<java.lang.String> values;

            /**
             * Sets the value of {@link RuleStringExpressionProperty#getEvaluate}
             * @param evaluate The string to evaluate in a string condition expression. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder evaluate(software.amazon.awscdk.IResolvable evaluate) {
                this.evaluate = evaluate;
                return this;
            }

            /**
             * Sets the value of {@link RuleStringExpressionProperty#getEvaluate}
             * @param evaluate The string to evaluate in a string condition expression. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder evaluate(software.amazon.awscdk.services.ses.CfnMailManagerRuleSet.RuleStringToEvaluateProperty evaluate) {
                this.evaluate = evaluate;
                return this;
            }

            /**
             * Sets the value of {@link RuleStringExpressionProperty#getOperator}
             * @param operator The matching operator for a string condition expression. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder operator(java.lang.String operator) {
                this.operator = operator;
                return this;
            }

            /**
             * Sets the value of {@link RuleStringExpressionProperty#getValues}
             * @param values The string(s) to be evaluated in a string condition expression. This parameter is required.
             *               For all operators, except for NOT_EQUALS, if multiple values are given, the values are processed as an OR. That is, if any of the values match the email's string using the given operator, the condition is deemed to match. However, for NOT_EQUALS, the condition is only deemed to match if none of the given strings match the email's string.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder values(java.util.List<java.lang.String> values) {
                this.values = values;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link RuleStringExpressionProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public RuleStringExpressionProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link RuleStringExpressionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements RuleStringExpressionProperty {
            private final java.lang.Object evaluate;
            private final java.lang.String operator;
            private final java.util.List<java.lang.String> values;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.evaluate = software.amazon.jsii.Kernel.get(this, "evaluate", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.operator = software.amazon.jsii.Kernel.get(this, "operator", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.values = software.amazon.jsii.Kernel.get(this, "values", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.evaluate = java.util.Objects.requireNonNull(builder.evaluate, "evaluate is required");
                this.operator = java.util.Objects.requireNonNull(builder.operator, "operator is required");
                this.values = java.util.Objects.requireNonNull(builder.values, "values is required");
            }

            @Override
            public final java.lang.Object getEvaluate() {
                return this.evaluate;
            }

            @Override
            public final java.lang.String getOperator() {
                return this.operator;
            }

            @Override
            public final java.util.List<java.lang.String> getValues() {
                return this.values;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("evaluate", om.valueToTree(this.getEvaluate()));
                data.set("operator", om.valueToTree(this.getOperator()));
                data.set("values", om.valueToTree(this.getValues()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ses.CfnMailManagerRuleSet.RuleStringExpressionProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                RuleStringExpressionProperty.Jsii$Proxy that = (RuleStringExpressionProperty.Jsii$Proxy) o;

                if (!evaluate.equals(that.evaluate)) return false;
                if (!operator.equals(that.operator)) return false;
                return this.values.equals(that.values);
            }

            @Override
            public final int hashCode() {
                int result = this.evaluate.hashCode();
                result = 31 * result + (this.operator.hashCode());
                result = 31 * result + (this.values.hashCode());
                return result;
            }
        }
    }
    /**
     * The string to evaluate in a string condition expression.
     * <p>
     * <blockquote>
     * <p>
     * This data type is a UNION, so only one of the following members can be specified when used or returned.
     * <p>
     * </blockquote>
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.ses.*;
     * RuleStringToEvaluateProperty ruleStringToEvaluateProperty = RuleStringToEvaluateProperty.builder()
     *         .analysis(AnalysisProperty.builder()
     *                 .analyzer("analyzer")
     *                 .resultField("resultField")
     *                 .build())
     *         .attribute("attribute")
     *         .mimeHeaderAttribute("mimeHeaderAttribute")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ses-mailmanagerruleset-rulestringtoevaluate.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ses-mailmanagerruleset-rulestringtoevaluate.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ses.CfnMailManagerRuleSet.RuleStringToEvaluateProperty")
    @software.amazon.jsii.Jsii.Proxy(RuleStringToEvaluateProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface RuleStringToEvaluateProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The Add On ARN and its returned value to evaluate in a string condition expression.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ses-mailmanagerruleset-rulestringtoevaluate.html#cfn-ses-mailmanagerruleset-rulestringtoevaluate-analysis">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ses-mailmanagerruleset-rulestringtoevaluate.html#cfn-ses-mailmanagerruleset-rulestringtoevaluate-analysis</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getAnalysis() {
            return null;
        }

        /**
         * The email attribute to evaluate in a string condition expression.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ses-mailmanagerruleset-rulestringtoevaluate.html#cfn-ses-mailmanagerruleset-rulestringtoevaluate-attribute">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ses-mailmanagerruleset-rulestringtoevaluate.html#cfn-ses-mailmanagerruleset-rulestringtoevaluate-attribute</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getAttribute() {
            return null;
        }

        /**
         * The email MIME X-Header attribute to evaluate in a string condition expression.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ses-mailmanagerruleset-rulestringtoevaluate.html#cfn-ses-mailmanagerruleset-rulestringtoevaluate-mimeheaderattribute">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ses-mailmanagerruleset-rulestringtoevaluate.html#cfn-ses-mailmanagerruleset-rulestringtoevaluate-mimeheaderattribute</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getMimeHeaderAttribute() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link RuleStringToEvaluateProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link RuleStringToEvaluateProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<RuleStringToEvaluateProperty> {
            java.lang.Object analysis;
            java.lang.String attribute;
            java.lang.String mimeHeaderAttribute;

            /**
             * Sets the value of {@link RuleStringToEvaluateProperty#getAnalysis}
             * @param analysis The Add On ARN and its returned value to evaluate in a string condition expression.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder analysis(software.amazon.awscdk.IResolvable analysis) {
                this.analysis = analysis;
                return this;
            }

            /**
             * Sets the value of {@link RuleStringToEvaluateProperty#getAnalysis}
             * @param analysis The Add On ARN and its returned value to evaluate in a string condition expression.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder analysis(software.amazon.awscdk.services.ses.CfnMailManagerRuleSet.AnalysisProperty analysis) {
                this.analysis = analysis;
                return this;
            }

            /**
             * Sets the value of {@link RuleStringToEvaluateProperty#getAttribute}
             * @param attribute The email attribute to evaluate in a string condition expression.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder attribute(java.lang.String attribute) {
                this.attribute = attribute;
                return this;
            }

            /**
             * Sets the value of {@link RuleStringToEvaluateProperty#getMimeHeaderAttribute}
             * @param mimeHeaderAttribute The email MIME X-Header attribute to evaluate in a string condition expression.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder mimeHeaderAttribute(java.lang.String mimeHeaderAttribute) {
                this.mimeHeaderAttribute = mimeHeaderAttribute;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link RuleStringToEvaluateProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public RuleStringToEvaluateProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link RuleStringToEvaluateProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements RuleStringToEvaluateProperty {
            private final java.lang.Object analysis;
            private final java.lang.String attribute;
            private final java.lang.String mimeHeaderAttribute;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.analysis = software.amazon.jsii.Kernel.get(this, "analysis", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.attribute = software.amazon.jsii.Kernel.get(this, "attribute", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.mimeHeaderAttribute = software.amazon.jsii.Kernel.get(this, "mimeHeaderAttribute", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.analysis = builder.analysis;
                this.attribute = builder.attribute;
                this.mimeHeaderAttribute = builder.mimeHeaderAttribute;
            }

            @Override
            public final java.lang.Object getAnalysis() {
                return this.analysis;
            }

            @Override
            public final java.lang.String getAttribute() {
                return this.attribute;
            }

            @Override
            public final java.lang.String getMimeHeaderAttribute() {
                return this.mimeHeaderAttribute;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getAnalysis() != null) {
                    data.set("analysis", om.valueToTree(this.getAnalysis()));
                }
                if (this.getAttribute() != null) {
                    data.set("attribute", om.valueToTree(this.getAttribute()));
                }
                if (this.getMimeHeaderAttribute() != null) {
                    data.set("mimeHeaderAttribute", om.valueToTree(this.getMimeHeaderAttribute()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ses.CfnMailManagerRuleSet.RuleStringToEvaluateProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                RuleStringToEvaluateProperty.Jsii$Proxy that = (RuleStringToEvaluateProperty.Jsii$Proxy) o;

                if (this.analysis != null ? !this.analysis.equals(that.analysis) : that.analysis != null) return false;
                if (this.attribute != null ? !this.attribute.equals(that.attribute) : that.attribute != null) return false;
                return this.mimeHeaderAttribute != null ? this.mimeHeaderAttribute.equals(that.mimeHeaderAttribute) : that.mimeHeaderAttribute == null;
            }

            @Override
            public final int hashCode() {
                int result = this.analysis != null ? this.analysis.hashCode() : 0;
                result = 31 * result + (this.attribute != null ? this.attribute.hashCode() : 0);
                result = 31 * result + (this.mimeHeaderAttribute != null ? this.mimeHeaderAttribute.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * A verdict expression is evaluated against verdicts of the email.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.ses.*;
     * RuleVerdictExpressionProperty ruleVerdictExpressionProperty = RuleVerdictExpressionProperty.builder()
     *         .evaluate(RuleVerdictToEvaluateProperty.builder()
     *                 .analysis(AnalysisProperty.builder()
     *                         .analyzer("analyzer")
     *                         .resultField("resultField")
     *                         .build())
     *                 .attribute("attribute")
     *                 .build())
     *         .operator("operator")
     *         .values(List.of("values"))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ses-mailmanagerruleset-ruleverdictexpression.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ses-mailmanagerruleset-ruleverdictexpression.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ses.CfnMailManagerRuleSet.RuleVerdictExpressionProperty")
    @software.amazon.jsii.Jsii.Proxy(RuleVerdictExpressionProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface RuleVerdictExpressionProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The verdict to evaluate in a verdict condition expression.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ses-mailmanagerruleset-ruleverdictexpression.html#cfn-ses-mailmanagerruleset-ruleverdictexpression-evaluate">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ses-mailmanagerruleset-ruleverdictexpression.html#cfn-ses-mailmanagerruleset-ruleverdictexpression-evaluate</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getEvaluate();

        /**
         * The matching operator for a verdict condition expression.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ses-mailmanagerruleset-ruleverdictexpression.html#cfn-ses-mailmanagerruleset-ruleverdictexpression-operator">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ses-mailmanagerruleset-ruleverdictexpression.html#cfn-ses-mailmanagerruleset-ruleverdictexpression-operator</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getOperator();

        /**
         * The values to match with the email's verdict using the given operator.
         * <p>
         * For the EQUALS operator, if multiple values are given, the condition is deemed to match if any of the given verdicts match that of the email. For the NOT_EQUALS operator, if multiple values are given, the condition is deemed to match of none of the given verdicts match the verdict of the email.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ses-mailmanagerruleset-ruleverdictexpression.html#cfn-ses-mailmanagerruleset-ruleverdictexpression-values">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ses-mailmanagerruleset-ruleverdictexpression.html#cfn-ses-mailmanagerruleset-ruleverdictexpression-values</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> getValues();

        /**
         * @return a {@link Builder} of {@link RuleVerdictExpressionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link RuleVerdictExpressionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<RuleVerdictExpressionProperty> {
            java.lang.Object evaluate;
            java.lang.String operator;
            java.util.List<java.lang.String> values;

            /**
             * Sets the value of {@link RuleVerdictExpressionProperty#getEvaluate}
             * @param evaluate The verdict to evaluate in a verdict condition expression. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder evaluate(software.amazon.awscdk.IResolvable evaluate) {
                this.evaluate = evaluate;
                return this;
            }

            /**
             * Sets the value of {@link RuleVerdictExpressionProperty#getEvaluate}
             * @param evaluate The verdict to evaluate in a verdict condition expression. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder evaluate(software.amazon.awscdk.services.ses.CfnMailManagerRuleSet.RuleVerdictToEvaluateProperty evaluate) {
                this.evaluate = evaluate;
                return this;
            }

            /**
             * Sets the value of {@link RuleVerdictExpressionProperty#getOperator}
             * @param operator The matching operator for a verdict condition expression. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder operator(java.lang.String operator) {
                this.operator = operator;
                return this;
            }

            /**
             * Sets the value of {@link RuleVerdictExpressionProperty#getValues}
             * @param values The values to match with the email's verdict using the given operator. This parameter is required.
             *               For the EQUALS operator, if multiple values are given, the condition is deemed to match if any of the given verdicts match that of the email. For the NOT_EQUALS operator, if multiple values are given, the condition is deemed to match of none of the given verdicts match the verdict of the email.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder values(java.util.List<java.lang.String> values) {
                this.values = values;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link RuleVerdictExpressionProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public RuleVerdictExpressionProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link RuleVerdictExpressionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements RuleVerdictExpressionProperty {
            private final java.lang.Object evaluate;
            private final java.lang.String operator;
            private final java.util.List<java.lang.String> values;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.evaluate = software.amazon.jsii.Kernel.get(this, "evaluate", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.operator = software.amazon.jsii.Kernel.get(this, "operator", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.values = software.amazon.jsii.Kernel.get(this, "values", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.evaluate = java.util.Objects.requireNonNull(builder.evaluate, "evaluate is required");
                this.operator = java.util.Objects.requireNonNull(builder.operator, "operator is required");
                this.values = java.util.Objects.requireNonNull(builder.values, "values is required");
            }

            @Override
            public final java.lang.Object getEvaluate() {
                return this.evaluate;
            }

            @Override
            public final java.lang.String getOperator() {
                return this.operator;
            }

            @Override
            public final java.util.List<java.lang.String> getValues() {
                return this.values;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("evaluate", om.valueToTree(this.getEvaluate()));
                data.set("operator", om.valueToTree(this.getOperator()));
                data.set("values", om.valueToTree(this.getValues()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ses.CfnMailManagerRuleSet.RuleVerdictExpressionProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                RuleVerdictExpressionProperty.Jsii$Proxy that = (RuleVerdictExpressionProperty.Jsii$Proxy) o;

                if (!evaluate.equals(that.evaluate)) return false;
                if (!operator.equals(that.operator)) return false;
                return this.values.equals(that.values);
            }

            @Override
            public final int hashCode() {
                int result = this.evaluate.hashCode();
                result = 31 * result + (this.operator.hashCode());
                result = 31 * result + (this.values.hashCode());
                return result;
            }
        }
    }
    /**
     * The verdict to evaluate in a verdict condition expression.
     * <p>
     * <blockquote>
     * <p>
     * This data type is a UNION, so only one of the following members can be specified when used or returned.
     * <p>
     * </blockquote>
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.ses.*;
     * RuleVerdictToEvaluateProperty ruleVerdictToEvaluateProperty = RuleVerdictToEvaluateProperty.builder()
     *         .analysis(AnalysisProperty.builder()
     *                 .analyzer("analyzer")
     *                 .resultField("resultField")
     *                 .build())
     *         .attribute("attribute")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ses-mailmanagerruleset-ruleverdicttoevaluate.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ses-mailmanagerruleset-ruleverdicttoevaluate.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ses.CfnMailManagerRuleSet.RuleVerdictToEvaluateProperty")
    @software.amazon.jsii.Jsii.Proxy(RuleVerdictToEvaluateProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface RuleVerdictToEvaluateProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The Add On ARN and its returned value to evaluate in a verdict condition expression.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ses-mailmanagerruleset-ruleverdicttoevaluate.html#cfn-ses-mailmanagerruleset-ruleverdicttoevaluate-analysis">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ses-mailmanagerruleset-ruleverdicttoevaluate.html#cfn-ses-mailmanagerruleset-ruleverdicttoevaluate-analysis</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getAnalysis() {
            return null;
        }

        /**
         * The email verdict attribute to evaluate in a string verdict expression.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ses-mailmanagerruleset-ruleverdicttoevaluate.html#cfn-ses-mailmanagerruleset-ruleverdicttoevaluate-attribute">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ses-mailmanagerruleset-ruleverdicttoevaluate.html#cfn-ses-mailmanagerruleset-ruleverdicttoevaluate-attribute</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getAttribute() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link RuleVerdictToEvaluateProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link RuleVerdictToEvaluateProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<RuleVerdictToEvaluateProperty> {
            java.lang.Object analysis;
            java.lang.String attribute;

            /**
             * Sets the value of {@link RuleVerdictToEvaluateProperty#getAnalysis}
             * @param analysis The Add On ARN and its returned value to evaluate in a verdict condition expression.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder analysis(software.amazon.awscdk.IResolvable analysis) {
                this.analysis = analysis;
                return this;
            }

            /**
             * Sets the value of {@link RuleVerdictToEvaluateProperty#getAnalysis}
             * @param analysis The Add On ARN and its returned value to evaluate in a verdict condition expression.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder analysis(software.amazon.awscdk.services.ses.CfnMailManagerRuleSet.AnalysisProperty analysis) {
                this.analysis = analysis;
                return this;
            }

            /**
             * Sets the value of {@link RuleVerdictToEvaluateProperty#getAttribute}
             * @param attribute The email verdict attribute to evaluate in a string verdict expression.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder attribute(java.lang.String attribute) {
                this.attribute = attribute;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link RuleVerdictToEvaluateProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public RuleVerdictToEvaluateProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link RuleVerdictToEvaluateProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements RuleVerdictToEvaluateProperty {
            private final java.lang.Object analysis;
            private final java.lang.String attribute;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.analysis = software.amazon.jsii.Kernel.get(this, "analysis", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.attribute = software.amazon.jsii.Kernel.get(this, "attribute", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.analysis = builder.analysis;
                this.attribute = builder.attribute;
            }

            @Override
            public final java.lang.Object getAnalysis() {
                return this.analysis;
            }

            @Override
            public final java.lang.String getAttribute() {
                return this.attribute;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getAnalysis() != null) {
                    data.set("analysis", om.valueToTree(this.getAnalysis()));
                }
                if (this.getAttribute() != null) {
                    data.set("attribute", om.valueToTree(this.getAttribute()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ses.CfnMailManagerRuleSet.RuleVerdictToEvaluateProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                RuleVerdictToEvaluateProperty.Jsii$Proxy that = (RuleVerdictToEvaluateProperty.Jsii$Proxy) o;

                if (this.analysis != null ? !this.analysis.equals(that.analysis) : that.analysis != null) return false;
                return this.attribute != null ? this.attribute.equals(that.attribute) : that.attribute == null;
            }

            @Override
            public final int hashCode() {
                int result = this.analysis != null ? this.analysis.hashCode() : 0;
                result = 31 * result + (this.attribute != null ? this.attribute.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Writes the MIME content of the email to an S3 bucket.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.ses.*;
     * S3ActionProperty s3ActionProperty = S3ActionProperty.builder()
     *         .roleArn("roleArn")
     *         .s3Bucket("s3Bucket")
     *         // the properties below are optional
     *         .actionFailurePolicy("actionFailurePolicy")
     *         .s3Prefix("s3Prefix")
     *         .s3SseKmsKeyId("s3SseKmsKeyId")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ses-mailmanagerruleset-s3action.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ses-mailmanagerruleset-s3action.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ses.CfnMailManagerRuleSet.S3ActionProperty")
    @software.amazon.jsii.Jsii.Proxy(S3ActionProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface S3ActionProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The Amazon Resource Name (ARN) of the IAM Role to use while writing to S3.
         * <p>
         * This role must have access to the s3:PutObject, kms:Encrypt, and kms:GenerateDataKey APIs for the given bucket.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ses-mailmanagerruleset-s3action.html#cfn-ses-mailmanagerruleset-s3action-rolearn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ses-mailmanagerruleset-s3action.html#cfn-ses-mailmanagerruleset-s3action-rolearn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getRoleArn();

        /**
         * The bucket name of the S3 bucket to write to.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ses-mailmanagerruleset-s3action.html#cfn-ses-mailmanagerruleset-s3action-s3bucket">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ses-mailmanagerruleset-s3action.html#cfn-ses-mailmanagerruleset-s3action-s3bucket</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getS3Bucket();

        /**
         * A policy that states what to do in the case of failure.
         * <p>
         * The action will fail if there are configuration errors. For example, the specified the bucket has been deleted.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ses-mailmanagerruleset-s3action.html#cfn-ses-mailmanagerruleset-s3action-actionfailurepolicy">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ses-mailmanagerruleset-s3action.html#cfn-ses-mailmanagerruleset-s3action-actionfailurepolicy</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getActionFailurePolicy() {
            return null;
        }

        /**
         * The S3 prefix to use for the write to the s3 bucket.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ses-mailmanagerruleset-s3action.html#cfn-ses-mailmanagerruleset-s3action-s3prefix">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ses-mailmanagerruleset-s3action.html#cfn-ses-mailmanagerruleset-s3action-s3prefix</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getS3Prefix() {
            return null;
        }

        /**
         * The KMS Key ID to use to encrypt the message in S3.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ses-mailmanagerruleset-s3action.html#cfn-ses-mailmanagerruleset-s3action-s3ssekmskeyid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ses-mailmanagerruleset-s3action.html#cfn-ses-mailmanagerruleset-s3action-s3ssekmskeyid</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getS3SseKmsKeyId() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link S3ActionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link S3ActionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<S3ActionProperty> {
            java.lang.String roleArn;
            java.lang.String s3Bucket;
            java.lang.String actionFailurePolicy;
            java.lang.String s3Prefix;
            java.lang.String s3SseKmsKeyId;

            /**
             * Sets the value of {@link S3ActionProperty#getRoleArn}
             * @param roleArn The Amazon Resource Name (ARN) of the IAM Role to use while writing to S3. This parameter is required.
             *                This role must have access to the s3:PutObject, kms:Encrypt, and kms:GenerateDataKey APIs for the given bucket.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder roleArn(java.lang.String roleArn) {
                this.roleArn = roleArn;
                return this;
            }

            /**
             * Sets the value of {@link S3ActionProperty#getS3Bucket}
             * @param s3Bucket The bucket name of the S3 bucket to write to. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder s3Bucket(java.lang.String s3Bucket) {
                this.s3Bucket = s3Bucket;
                return this;
            }

            /**
             * Sets the value of {@link S3ActionProperty#getActionFailurePolicy}
             * @param actionFailurePolicy A policy that states what to do in the case of failure.
             *                            The action will fail if there are configuration errors. For example, the specified the bucket has been deleted.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder actionFailurePolicy(java.lang.String actionFailurePolicy) {
                this.actionFailurePolicy = actionFailurePolicy;
                return this;
            }

            /**
             * Sets the value of {@link S3ActionProperty#getS3Prefix}
             * @param s3Prefix The S3 prefix to use for the write to the s3 bucket.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder s3Prefix(java.lang.String s3Prefix) {
                this.s3Prefix = s3Prefix;
                return this;
            }

            /**
             * Sets the value of {@link S3ActionProperty#getS3SseKmsKeyId}
             * @param s3SseKmsKeyId The KMS Key ID to use to encrypt the message in S3.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder s3SseKmsKeyId(java.lang.String s3SseKmsKeyId) {
                this.s3SseKmsKeyId = s3SseKmsKeyId;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link S3ActionProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public S3ActionProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link S3ActionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements S3ActionProperty {
            private final java.lang.String roleArn;
            private final java.lang.String s3Bucket;
            private final java.lang.String actionFailurePolicy;
            private final java.lang.String s3Prefix;
            private final java.lang.String s3SseKmsKeyId;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.roleArn = software.amazon.jsii.Kernel.get(this, "roleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.s3Bucket = software.amazon.jsii.Kernel.get(this, "s3Bucket", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.actionFailurePolicy = software.amazon.jsii.Kernel.get(this, "actionFailurePolicy", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.s3Prefix = software.amazon.jsii.Kernel.get(this, "s3Prefix", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.s3SseKmsKeyId = software.amazon.jsii.Kernel.get(this, "s3SseKmsKeyId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.roleArn = java.util.Objects.requireNonNull(builder.roleArn, "roleArn is required");
                this.s3Bucket = java.util.Objects.requireNonNull(builder.s3Bucket, "s3Bucket is required");
                this.actionFailurePolicy = builder.actionFailurePolicy;
                this.s3Prefix = builder.s3Prefix;
                this.s3SseKmsKeyId = builder.s3SseKmsKeyId;
            }

            @Override
            public final java.lang.String getRoleArn() {
                return this.roleArn;
            }

            @Override
            public final java.lang.String getS3Bucket() {
                return this.s3Bucket;
            }

            @Override
            public final java.lang.String getActionFailurePolicy() {
                return this.actionFailurePolicy;
            }

            @Override
            public final java.lang.String getS3Prefix() {
                return this.s3Prefix;
            }

            @Override
            public final java.lang.String getS3SseKmsKeyId() {
                return this.s3SseKmsKeyId;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("roleArn", om.valueToTree(this.getRoleArn()));
                data.set("s3Bucket", om.valueToTree(this.getS3Bucket()));
                if (this.getActionFailurePolicy() != null) {
                    data.set("actionFailurePolicy", om.valueToTree(this.getActionFailurePolicy()));
                }
                if (this.getS3Prefix() != null) {
                    data.set("s3Prefix", om.valueToTree(this.getS3Prefix()));
                }
                if (this.getS3SseKmsKeyId() != null) {
                    data.set("s3SseKmsKeyId", om.valueToTree(this.getS3SseKmsKeyId()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ses.CfnMailManagerRuleSet.S3ActionProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                S3ActionProperty.Jsii$Proxy that = (S3ActionProperty.Jsii$Proxy) o;

                if (!roleArn.equals(that.roleArn)) return false;
                if (!s3Bucket.equals(that.s3Bucket)) return false;
                if (this.actionFailurePolicy != null ? !this.actionFailurePolicy.equals(that.actionFailurePolicy) : that.actionFailurePolicy != null) return false;
                if (this.s3Prefix != null ? !this.s3Prefix.equals(that.s3Prefix) : that.s3Prefix != null) return false;
                return this.s3SseKmsKeyId != null ? this.s3SseKmsKeyId.equals(that.s3SseKmsKeyId) : that.s3SseKmsKeyId == null;
            }

            @Override
            public final int hashCode() {
                int result = this.roleArn.hashCode();
                result = 31 * result + (this.s3Bucket.hashCode());
                result = 31 * result + (this.actionFailurePolicy != null ? this.actionFailurePolicy.hashCode() : 0);
                result = 31 * result + (this.s3Prefix != null ? this.s3Prefix.hashCode() : 0);
                result = 31 * result + (this.s3SseKmsKeyId != null ? this.s3SseKmsKeyId.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Sends the email to the internet using the ses:SendRawEmail API.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.ses.*;
     * SendActionProperty sendActionProperty = SendActionProperty.builder()
     *         .roleArn("roleArn")
     *         // the properties below are optional
     *         .actionFailurePolicy("actionFailurePolicy")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ses-mailmanagerruleset-sendaction.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ses-mailmanagerruleset-sendaction.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ses.CfnMailManagerRuleSet.SendActionProperty")
    @software.amazon.jsii.Jsii.Proxy(SendActionProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface SendActionProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The Amazon Resource Name (ARN) of the role to use for this action.
         * <p>
         * This role must have access to the ses:SendRawEmail API.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ses-mailmanagerruleset-sendaction.html#cfn-ses-mailmanagerruleset-sendaction-rolearn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ses-mailmanagerruleset-sendaction.html#cfn-ses-mailmanagerruleset-sendaction-rolearn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getRoleArn();

        /**
         * A policy that states what to do in the case of failure.
         * <p>
         * The action will fail if there are configuration errors. For example, the caller does not have the permissions to call the sendRawEmail API.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ses-mailmanagerruleset-sendaction.html#cfn-ses-mailmanagerruleset-sendaction-actionfailurepolicy">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ses-mailmanagerruleset-sendaction.html#cfn-ses-mailmanagerruleset-sendaction-actionfailurepolicy</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getActionFailurePolicy() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link SendActionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link SendActionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<SendActionProperty> {
            java.lang.String roleArn;
            java.lang.String actionFailurePolicy;

            /**
             * Sets the value of {@link SendActionProperty#getRoleArn}
             * @param roleArn The Amazon Resource Name (ARN) of the role to use for this action. This parameter is required.
             *                This role must have access to the ses:SendRawEmail API.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder roleArn(java.lang.String roleArn) {
                this.roleArn = roleArn;
                return this;
            }

            /**
             * Sets the value of {@link SendActionProperty#getActionFailurePolicy}
             * @param actionFailurePolicy A policy that states what to do in the case of failure.
             *                            The action will fail if there are configuration errors. For example, the caller does not have the permissions to call the sendRawEmail API.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder actionFailurePolicy(java.lang.String actionFailurePolicy) {
                this.actionFailurePolicy = actionFailurePolicy;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link SendActionProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public SendActionProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link SendActionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SendActionProperty {
            private final java.lang.String roleArn;
            private final java.lang.String actionFailurePolicy;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.roleArn = software.amazon.jsii.Kernel.get(this, "roleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.actionFailurePolicy = software.amazon.jsii.Kernel.get(this, "actionFailurePolicy", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.roleArn = java.util.Objects.requireNonNull(builder.roleArn, "roleArn is required");
                this.actionFailurePolicy = builder.actionFailurePolicy;
            }

            @Override
            public final java.lang.String getRoleArn() {
                return this.roleArn;
            }

            @Override
            public final java.lang.String getActionFailurePolicy() {
                return this.actionFailurePolicy;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("roleArn", om.valueToTree(this.getRoleArn()));
                if (this.getActionFailurePolicy() != null) {
                    data.set("actionFailurePolicy", om.valueToTree(this.getActionFailurePolicy()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ses.CfnMailManagerRuleSet.SendActionProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                SendActionProperty.Jsii$Proxy that = (SendActionProperty.Jsii$Proxy) o;

                if (!roleArn.equals(that.roleArn)) return false;
                return this.actionFailurePolicy != null ? this.actionFailurePolicy.equals(that.actionFailurePolicy) : that.actionFailurePolicy == null;
            }

            @Override
            public final int hashCode() {
                int result = this.roleArn.hashCode();
                result = 31 * result + (this.actionFailurePolicy != null ? this.actionFailurePolicy.hashCode() : 0);
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.ses.CfnMailManagerRuleSet}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.ses.CfnMailManagerRuleSet> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope Scope in which this resource is defined. This parameter is required.
         * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.ses.CfnMailManagerRuleSetProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.ses.CfnMailManagerRuleSetProps.Builder();
        }

        /**
         * Conditional rules that are evaluated for determining actions on email.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ses-mailmanagerruleset.html#cfn-ses-mailmanagerruleset-rules">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ses-mailmanagerruleset.html#cfn-ses-mailmanagerruleset-rules</a>
         * @param rules Conditional rules that are evaluated for determining actions on email. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder rules(final software.amazon.awscdk.IResolvable rules) {
            this.props.rules(rules);
            return this;
        }
        /**
         * Conditional rules that are evaluated for determining actions on email.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ses-mailmanagerruleset.html#cfn-ses-mailmanagerruleset-rules">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ses-mailmanagerruleset.html#cfn-ses-mailmanagerruleset-rules</a>
         * @param rules Conditional rules that are evaluated for determining actions on email. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder rules(final java.util.List<? extends java.lang.Object> rules) {
            this.props.rules(rules);
            return this;
        }

        /**
         * A user-friendly name for the rule set.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ses-mailmanagerruleset.html#cfn-ses-mailmanagerruleset-rulesetname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ses-mailmanagerruleset.html#cfn-ses-mailmanagerruleset-rulesetname</a>
         * @param ruleSetName A user-friendly name for the rule set. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ruleSetName(final java.lang.String ruleSetName) {
            this.props.ruleSetName(ruleSetName);
            return this;
        }

        /**
         * The tags used to organize, track, or control access for the resource.
         * <p>
         * For example, { "tags": {"key1":"value1", "key2":"value2"} }.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ses-mailmanagerruleset.html#cfn-ses-mailmanagerruleset-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ses-mailmanagerruleset.html#cfn-ses-mailmanagerruleset-tags</a>
         * @param tags The tags used to organize, track, or control access for the resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(final java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.props.tags(tags);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.ses.CfnMailManagerRuleSet}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.ses.CfnMailManagerRuleSet build() {
            return new software.amazon.awscdk.services.ses.CfnMailManagerRuleSet(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
