package software.amazon.awscdk.services.ses;

/**
 * Source for CloudWatch dimension.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-05-20T23:53:03.898Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ses.CloudWatchDimensionSource")
public enum CloudWatchDimensionSource {
    /**
     * Amazon SES retrieves the dimension name and value from a header in the email.
     * <p>
     * Note: You can't use any of the following email headers as the Dimension Name:
     * <code>Received</code>, <code>To</code>, <code>From</code>, <code>DKIM-Signature</code>, <code>CC</code>, <code>message-id</code>, or <code>Return-Path</code>.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    EMAIL_HEADER,
    /**
     * Amazon SES retrieves the dimension name and value from a tag that you specified in a link.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/ses/latest/dg/faqs-metrics.html#sending-metric-faqs-clicks-q5">https://docs.aws.amazon.com/ses/latest/dg/faqs-metrics.html#sending-metric-faqs-clicks-q5</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    LINK_TAG,
    /**
     * Amazon SES retrieves the dimension name and value from a tag that you specify by using the <code>X-SES-MESSAGE-TAGS</code> header or the Tags API parameter.
     * <p>
     * You can also use the Message Tag value source to create dimensions based on Amazon SES auto-tags.
     * To use an auto-tag, type the complete name of the auto-tag as the Dimension Name. For example,
     * to create a dimension based on the configuration set auto-tag, use <code>ses:configuration-set</code> for the
     * Dimension Name, and the name of the configuration set for the Default Value.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/ses/latest/dg/monitor-using-event-publishing.html#event-publishing-how-works">https://docs.aws.amazon.com/ses/latest/dg/monitor-using-event-publishing.html#event-publishing-how-works</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    MESSAGE_TAG,
}
