package software.amazon.awscdk.services.ses.actions;

/**
 * Construction properties for a bounce action.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.ses.actions.*;
 * import software.amazon.awscdk.services.sns.*;
 * BounceTemplate bounceTemplate;
 * Topic topic;
 * BounceProps bounceProps = BounceProps.builder()
 *         .sender("sender")
 *         .template(bounceTemplate)
 *         // the properties below are optional
 *         .topic(topic)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-05-20T23:53:03.933Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ses_actions.BounceProps")
@software.amazon.jsii.Jsii.Proxy(BounceProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface BounceProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The email address of the sender of the bounced email.
     * <p>
     * This is the address
     * from which the bounce message will be sent.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getSender();

    /**
     * The template containing the message, reply code and status code.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ses.actions.BounceTemplate getTemplate();

    /**
     * The SNS topic to notify when the bounce action is taken.
     * <p>
     * Default: no notification
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.sns.ITopic getTopic() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link BounceProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link BounceProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<BounceProps> {
        java.lang.String sender;
        software.amazon.awscdk.services.ses.actions.BounceTemplate template;
        software.amazon.awscdk.services.sns.ITopic topic;

        /**
         * Sets the value of {@link BounceProps#getSender}
         * @param sender The email address of the sender of the bounced email. This parameter is required.
         *               This is the address
         *               from which the bounce message will be sent.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder sender(java.lang.String sender) {
            this.sender = sender;
            return this;
        }

        /**
         * Sets the value of {@link BounceProps#getTemplate}
         * @param template The template containing the message, reply code and status code. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder template(software.amazon.awscdk.services.ses.actions.BounceTemplate template) {
            this.template = template;
            return this;
        }

        /**
         * Sets the value of {@link BounceProps#getTopic}
         * @param topic The SNS topic to notify when the bounce action is taken.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder topic(software.amazon.awscdk.services.sns.ITopic topic) {
            this.topic = topic;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link BounceProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public BounceProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link BounceProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements BounceProps {
        private final java.lang.String sender;
        private final software.amazon.awscdk.services.ses.actions.BounceTemplate template;
        private final software.amazon.awscdk.services.sns.ITopic topic;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.sender = software.amazon.jsii.Kernel.get(this, "sender", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.template = software.amazon.jsii.Kernel.get(this, "template", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ses.actions.BounceTemplate.class));
            this.topic = software.amazon.jsii.Kernel.get(this, "topic", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.sns.ITopic.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.sender = java.util.Objects.requireNonNull(builder.sender, "sender is required");
            this.template = java.util.Objects.requireNonNull(builder.template, "template is required");
            this.topic = builder.topic;
        }

        @Override
        public final java.lang.String getSender() {
            return this.sender;
        }

        @Override
        public final software.amazon.awscdk.services.ses.actions.BounceTemplate getTemplate() {
            return this.template;
        }

        @Override
        public final software.amazon.awscdk.services.sns.ITopic getTopic() {
            return this.topic;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("sender", om.valueToTree(this.getSender()));
            data.set("template", om.valueToTree(this.getTemplate()));
            if (this.getTopic() != null) {
                data.set("topic", om.valueToTree(this.getTopic()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ses_actions.BounceProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            BounceProps.Jsii$Proxy that = (BounceProps.Jsii$Proxy) o;

            if (!sender.equals(that.sender)) return false;
            if (!template.equals(that.template)) return false;
            return this.topic != null ? this.topic.equals(that.topic) : that.topic == null;
        }

        @Override
        public final int hashCode() {
            int result = this.sender.hashCode();
            result = 31 * result + (this.template.hashCode());
            result = 31 * result + (this.topic != null ? this.topic.hashCode() : 0);
            return result;
        }
    }
}
