package software.amazon.awscdk.services.sns;

/**
 * Represents an SNS topic defined outside of this stack.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.sns.*;
 * TopicAttributes topicAttributes = TopicAttributes.builder()
 *         .topicArn("topicArn")
 *         // the properties below are optional
 *         .contentBasedDeduplication(false)
 *         .keyArn("keyArn")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-05-20T23:53:04.009Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_sns.TopicAttributes")
@software.amazon.jsii.Jsii.Proxy(TopicAttributes.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface TopicAttributes extends software.amazon.jsii.JsiiSerializable {

    /**
     * The ARN of the SNS topic.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getTopicArn();

    /**
     * Whether content-based deduplication is enabled.
     * <p>
     * Only applicable for FIFO topics.
     * <p>
     * Default: false
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getContentBasedDeduplication() {
        return null;
    }

    /**
     * KMS encryption key, if this topic is server-side encrypted by a KMS key.
     * <p>
     * Default: - None
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getKeyArn() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link TopicAttributes}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link TopicAttributes}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<TopicAttributes> {
        java.lang.String topicArn;
        java.lang.Boolean contentBasedDeduplication;
        java.lang.String keyArn;

        /**
         * Sets the value of {@link TopicAttributes#getTopicArn}
         * @param topicArn The ARN of the SNS topic. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder topicArn(java.lang.String topicArn) {
            this.topicArn = topicArn;
            return this;
        }

        /**
         * Sets the value of {@link TopicAttributes#getContentBasedDeduplication}
         * @param contentBasedDeduplication Whether content-based deduplication is enabled.
         *                                  Only applicable for FIFO topics.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder contentBasedDeduplication(java.lang.Boolean contentBasedDeduplication) {
            this.contentBasedDeduplication = contentBasedDeduplication;
            return this;
        }

        /**
         * Sets the value of {@link TopicAttributes#getKeyArn}
         * @param keyArn KMS encryption key, if this topic is server-side encrypted by a KMS key.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder keyArn(java.lang.String keyArn) {
            this.keyArn = keyArn;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link TopicAttributes}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public TopicAttributes build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link TopicAttributes}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements TopicAttributes {
        private final java.lang.String topicArn;
        private final java.lang.Boolean contentBasedDeduplication;
        private final java.lang.String keyArn;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.topicArn = software.amazon.jsii.Kernel.get(this, "topicArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.contentBasedDeduplication = software.amazon.jsii.Kernel.get(this, "contentBasedDeduplication", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.keyArn = software.amazon.jsii.Kernel.get(this, "keyArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.topicArn = java.util.Objects.requireNonNull(builder.topicArn, "topicArn is required");
            this.contentBasedDeduplication = builder.contentBasedDeduplication;
            this.keyArn = builder.keyArn;
        }

        @Override
        public final java.lang.String getTopicArn() {
            return this.topicArn;
        }

        @Override
        public final java.lang.Boolean getContentBasedDeduplication() {
            return this.contentBasedDeduplication;
        }

        @Override
        public final java.lang.String getKeyArn() {
            return this.keyArn;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("topicArn", om.valueToTree(this.getTopicArn()));
            if (this.getContentBasedDeduplication() != null) {
                data.set("contentBasedDeduplication", om.valueToTree(this.getContentBasedDeduplication()));
            }
            if (this.getKeyArn() != null) {
                data.set("keyArn", om.valueToTree(this.getKeyArn()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_sns.TopicAttributes"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            TopicAttributes.Jsii$Proxy that = (TopicAttributes.Jsii$Proxy) o;

            if (!topicArn.equals(that.topicArn)) return false;
            if (this.contentBasedDeduplication != null ? !this.contentBasedDeduplication.equals(that.contentBasedDeduplication) : that.contentBasedDeduplication != null) return false;
            return this.keyArn != null ? this.keyArn.equals(that.keyArn) : that.keyArn == null;
        }

        @Override
        public final int hashCode() {
            int result = this.topicArn.hashCode();
            result = 31 * result + (this.contentBasedDeduplication != null ? this.contentBasedDeduplication.hashCode() : 0);
            result = 31 * result + (this.keyArn != null ? this.keyArn.hashCode() : 0);
            return result;
        }
    }
}
