package software.amazon.awscdk.services.sns;

/**
 * Properties for a new SNS topic.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Topic topic = Topic.Builder.create(this, "MyTopic")
 *         .fifo(true)
 *         .fifoThroughputScope(FifoThroughputScope.TOPIC)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-05-20T23:53:04.011Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_sns.TopicProps")
@software.amazon.jsii.Jsii.Proxy(TopicProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface TopicProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * Enables content-based deduplication for FIFO topics.
     * <p>
     * Default: None
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getContentBasedDeduplication() {
        return null;
    }

    /**
     * A developer-defined string that can be used to identify this SNS topic.
     * <p>
     * The display name must be maximum 100 characters long, including hyphens (-),
     * underscores (_), spaces, and tabs.
     * <p>
     * Default: None
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDisplayName() {
        return null;
    }

    /**
     * Adds a statement to enforce encryption of data in transit when publishing to the topic.
     * <p>
     * Default: false
     * <p>
     * @see <a href="https://docs.aws.amazon.com/sns/latest/dg/sns-security-best-practices.html#enforce-encryption-data-in-transit.">https://docs.aws.amazon.com/sns/latest/dg/sns-security-best-practices.html#enforce-encryption-data-in-transit.</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getEnforceSSL() {
        return null;
    }

    /**
     * Set to true to create a FIFO topic.
     * <p>
     * Default: None
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getFifo() {
        return null;
    }

    /**
     * Specifies the throughput quota and deduplication behavior to apply for the FIFO topic.
     * <p>
     * You can only set this property when <code>fifo</code> is <code>true</code>.
     * <p>
     * Default: undefined - SNS default setting is FifoThroughputScope.TOPIC
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.sns.FifoThroughputScope getFifoThroughputScope() {
        return null;
    }

    /**
     * The list of delivery status logging configurations for the topic.
     * <p>
     * Default: None
     * <p>
     * @see <a href="https://docs.aws.amazon.com/sns/latest/dg/sns-topic-attributes.html.">https://docs.aws.amazon.com/sns/latest/dg/sns-topic-attributes.html.</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.services.sns.LoggingConfig> getLoggingConfigs() {
        return null;
    }

    /**
     * A KMS Key, either managed by this CDK app, or imported.
     * <p>
     * Default: None
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.kms.IKey getMasterKey() {
        return null;
    }

    /**
     * The number of days Amazon SNS retains messages.
     * <p>
     * It can only be set for FIFO topics.
     * <p>
     * Default: - do not archive messages
     * <p>
     * @see <a href="https://docs.aws.amazon.com/sns/latest/dg/fifo-message-archiving-replay.html">https://docs.aws.amazon.com/sns/latest/dg/fifo-message-archiving-replay.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getMessageRetentionPeriodInDays() {
        return null;
    }

    /**
     * The signature version corresponds to the hashing algorithm used while creating the signature of the notifications, subscription confirmations, or unsubscribe confirmation messages sent by Amazon SNS.
     * <p>
     * Default: 1
     * <p>
     * @see <a href="https://docs.aws.amazon.com/sns/latest/dg/sns-verify-signature-of-message.html.">https://docs.aws.amazon.com/sns/latest/dg/sns-verify-signature-of-message.html.</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getSignatureVersion() {
        return null;
    }

    /**
     * A name for the topic.
     * <p>
     * If you don't specify a name, AWS CloudFormation generates a unique
     * physical ID and uses that ID for the topic name. For more information,
     * see Name Type.
     * <p>
     * Default: Generated name
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getTopicName() {
        return null;
    }

    /**
     * Tracing mode of an Amazon SNS topic.
     * <p>
     * Default: TracingConfig.PASS_THROUGH
     * <p>
     * @see <a href="https://docs.aws.amazon.com/sns/latest/dg/sns-active-tracing.html">https://docs.aws.amazon.com/sns/latest/dg/sns-active-tracing.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.sns.TracingConfig getTracingConfig() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link TopicProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link TopicProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<TopicProps> {
        java.lang.Boolean contentBasedDeduplication;
        java.lang.String displayName;
        java.lang.Boolean enforceSsl;
        java.lang.Boolean fifo;
        software.amazon.awscdk.services.sns.FifoThroughputScope fifoThroughputScope;
        java.util.List<software.amazon.awscdk.services.sns.LoggingConfig> loggingConfigs;
        software.amazon.awscdk.services.kms.IKey masterKey;
        java.lang.Number messageRetentionPeriodInDays;
        java.lang.String signatureVersion;
        java.lang.String topicName;
        software.amazon.awscdk.services.sns.TracingConfig tracingConfig;

        /**
         * Sets the value of {@link TopicProps#getContentBasedDeduplication}
         * @param contentBasedDeduplication Enables content-based deduplication for FIFO topics.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder contentBasedDeduplication(java.lang.Boolean contentBasedDeduplication) {
            this.contentBasedDeduplication = contentBasedDeduplication;
            return this;
        }

        /**
         * Sets the value of {@link TopicProps#getDisplayName}
         * @param displayName A developer-defined string that can be used to identify this SNS topic.
         *                    The display name must be maximum 100 characters long, including hyphens (-),
         *                    underscores (_), spaces, and tabs.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder displayName(java.lang.String displayName) {
            this.displayName = displayName;
            return this;
        }

        /**
         * Sets the value of {@link TopicProps#getEnforceSsl}
         * @param enforceSsl Adds a statement to enforce encryption of data in transit when publishing to the topic.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder enforceSsl(java.lang.Boolean enforceSsl) {
            this.enforceSsl = enforceSsl;
            return this;
        }

        /**
         * Sets the value of {@link TopicProps#getFifo}
         * @param fifo Set to true to create a FIFO topic.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder fifo(java.lang.Boolean fifo) {
            this.fifo = fifo;
            return this;
        }

        /**
         * Sets the value of {@link TopicProps#getFifoThroughputScope}
         * @param fifoThroughputScope Specifies the throughput quota and deduplication behavior to apply for the FIFO topic.
         *                            You can only set this property when <code>fifo</code> is <code>true</code>.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder fifoThroughputScope(software.amazon.awscdk.services.sns.FifoThroughputScope fifoThroughputScope) {
            this.fifoThroughputScope = fifoThroughputScope;
            return this;
        }

        /**
         * Sets the value of {@link TopicProps#getLoggingConfigs}
         * @param loggingConfigs The list of delivery status logging configurations for the topic.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder loggingConfigs(java.util.List<? extends software.amazon.awscdk.services.sns.LoggingConfig> loggingConfigs) {
            this.loggingConfigs = (java.util.List<software.amazon.awscdk.services.sns.LoggingConfig>)loggingConfigs;
            return this;
        }

        /**
         * Sets the value of {@link TopicProps#getMasterKey}
         * @param masterKey A KMS Key, either managed by this CDK app, or imported.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder masterKey(software.amazon.awscdk.services.kms.IKey masterKey) {
            this.masterKey = masterKey;
            return this;
        }

        /**
         * Sets the value of {@link TopicProps#getMessageRetentionPeriodInDays}
         * @param messageRetentionPeriodInDays The number of days Amazon SNS retains messages.
         *                                     It can only be set for FIFO topics.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder messageRetentionPeriodInDays(java.lang.Number messageRetentionPeriodInDays) {
            this.messageRetentionPeriodInDays = messageRetentionPeriodInDays;
            return this;
        }

        /**
         * Sets the value of {@link TopicProps#getSignatureVersion}
         * @param signatureVersion The signature version corresponds to the hashing algorithm used while creating the signature of the notifications, subscription confirmations, or unsubscribe confirmation messages sent by Amazon SNS.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder signatureVersion(java.lang.String signatureVersion) {
            this.signatureVersion = signatureVersion;
            return this;
        }

        /**
         * Sets the value of {@link TopicProps#getTopicName}
         * @param topicName A name for the topic.
         *                  If you don't specify a name, AWS CloudFormation generates a unique
         *                  physical ID and uses that ID for the topic name. For more information,
         *                  see Name Type.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder topicName(java.lang.String topicName) {
            this.topicName = topicName;
            return this;
        }

        /**
         * Sets the value of {@link TopicProps#getTracingConfig}
         * @param tracingConfig Tracing mode of an Amazon SNS topic.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tracingConfig(software.amazon.awscdk.services.sns.TracingConfig tracingConfig) {
            this.tracingConfig = tracingConfig;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link TopicProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public TopicProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link TopicProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements TopicProps {
        private final java.lang.Boolean contentBasedDeduplication;
        private final java.lang.String displayName;
        private final java.lang.Boolean enforceSsl;
        private final java.lang.Boolean fifo;
        private final software.amazon.awscdk.services.sns.FifoThroughputScope fifoThroughputScope;
        private final java.util.List<software.amazon.awscdk.services.sns.LoggingConfig> loggingConfigs;
        private final software.amazon.awscdk.services.kms.IKey masterKey;
        private final java.lang.Number messageRetentionPeriodInDays;
        private final java.lang.String signatureVersion;
        private final java.lang.String topicName;
        private final software.amazon.awscdk.services.sns.TracingConfig tracingConfig;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.contentBasedDeduplication = software.amazon.jsii.Kernel.get(this, "contentBasedDeduplication", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.displayName = software.amazon.jsii.Kernel.get(this, "displayName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.enforceSsl = software.amazon.jsii.Kernel.get(this, "enforceSSL", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.fifo = software.amazon.jsii.Kernel.get(this, "fifo", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.fifoThroughputScope = software.amazon.jsii.Kernel.get(this, "fifoThroughputScope", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.sns.FifoThroughputScope.class));
            this.loggingConfigs = software.amazon.jsii.Kernel.get(this, "loggingConfigs", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.sns.LoggingConfig.class)));
            this.masterKey = software.amazon.jsii.Kernel.get(this, "masterKey", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.kms.IKey.class));
            this.messageRetentionPeriodInDays = software.amazon.jsii.Kernel.get(this, "messageRetentionPeriodInDays", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.signatureVersion = software.amazon.jsii.Kernel.get(this, "signatureVersion", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.topicName = software.amazon.jsii.Kernel.get(this, "topicName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.tracingConfig = software.amazon.jsii.Kernel.get(this, "tracingConfig", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.sns.TracingConfig.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.contentBasedDeduplication = builder.contentBasedDeduplication;
            this.displayName = builder.displayName;
            this.enforceSsl = builder.enforceSsl;
            this.fifo = builder.fifo;
            this.fifoThroughputScope = builder.fifoThroughputScope;
            this.loggingConfigs = (java.util.List<software.amazon.awscdk.services.sns.LoggingConfig>)builder.loggingConfigs;
            this.masterKey = builder.masterKey;
            this.messageRetentionPeriodInDays = builder.messageRetentionPeriodInDays;
            this.signatureVersion = builder.signatureVersion;
            this.topicName = builder.topicName;
            this.tracingConfig = builder.tracingConfig;
        }

        @Override
        public final java.lang.Boolean getContentBasedDeduplication() {
            return this.contentBasedDeduplication;
        }

        @Override
        public final java.lang.String getDisplayName() {
            return this.displayName;
        }

        @Override
        public final java.lang.Boolean getEnforceSSL() {
            return this.enforceSsl;
        }

        @Override
        public final java.lang.Boolean getFifo() {
            return this.fifo;
        }

        @Override
        public final software.amazon.awscdk.services.sns.FifoThroughputScope getFifoThroughputScope() {
            return this.fifoThroughputScope;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.services.sns.LoggingConfig> getLoggingConfigs() {
            return this.loggingConfigs;
        }

        @Override
        public final software.amazon.awscdk.services.kms.IKey getMasterKey() {
            return this.masterKey;
        }

        @Override
        public final java.lang.Number getMessageRetentionPeriodInDays() {
            return this.messageRetentionPeriodInDays;
        }

        @Override
        public final java.lang.String getSignatureVersion() {
            return this.signatureVersion;
        }

        @Override
        public final java.lang.String getTopicName() {
            return this.topicName;
        }

        @Override
        public final software.amazon.awscdk.services.sns.TracingConfig getTracingConfig() {
            return this.tracingConfig;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getContentBasedDeduplication() != null) {
                data.set("contentBasedDeduplication", om.valueToTree(this.getContentBasedDeduplication()));
            }
            if (this.getDisplayName() != null) {
                data.set("displayName", om.valueToTree(this.getDisplayName()));
            }
            if (this.getEnforceSSL() != null) {
                data.set("enforceSSL", om.valueToTree(this.getEnforceSSL()));
            }
            if (this.getFifo() != null) {
                data.set("fifo", om.valueToTree(this.getFifo()));
            }
            if (this.getFifoThroughputScope() != null) {
                data.set("fifoThroughputScope", om.valueToTree(this.getFifoThroughputScope()));
            }
            if (this.getLoggingConfigs() != null) {
                data.set("loggingConfigs", om.valueToTree(this.getLoggingConfigs()));
            }
            if (this.getMasterKey() != null) {
                data.set("masterKey", om.valueToTree(this.getMasterKey()));
            }
            if (this.getMessageRetentionPeriodInDays() != null) {
                data.set("messageRetentionPeriodInDays", om.valueToTree(this.getMessageRetentionPeriodInDays()));
            }
            if (this.getSignatureVersion() != null) {
                data.set("signatureVersion", om.valueToTree(this.getSignatureVersion()));
            }
            if (this.getTopicName() != null) {
                data.set("topicName", om.valueToTree(this.getTopicName()));
            }
            if (this.getTracingConfig() != null) {
                data.set("tracingConfig", om.valueToTree(this.getTracingConfig()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_sns.TopicProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            TopicProps.Jsii$Proxy that = (TopicProps.Jsii$Proxy) o;

            if (this.contentBasedDeduplication != null ? !this.contentBasedDeduplication.equals(that.contentBasedDeduplication) : that.contentBasedDeduplication != null) return false;
            if (this.displayName != null ? !this.displayName.equals(that.displayName) : that.displayName != null) return false;
            if (this.enforceSsl != null ? !this.enforceSsl.equals(that.enforceSsl) : that.enforceSsl != null) return false;
            if (this.fifo != null ? !this.fifo.equals(that.fifo) : that.fifo != null) return false;
            if (this.fifoThroughputScope != null ? !this.fifoThroughputScope.equals(that.fifoThroughputScope) : that.fifoThroughputScope != null) return false;
            if (this.loggingConfigs != null ? !this.loggingConfigs.equals(that.loggingConfigs) : that.loggingConfigs != null) return false;
            if (this.masterKey != null ? !this.masterKey.equals(that.masterKey) : that.masterKey != null) return false;
            if (this.messageRetentionPeriodInDays != null ? !this.messageRetentionPeriodInDays.equals(that.messageRetentionPeriodInDays) : that.messageRetentionPeriodInDays != null) return false;
            if (this.signatureVersion != null ? !this.signatureVersion.equals(that.signatureVersion) : that.signatureVersion != null) return false;
            if (this.topicName != null ? !this.topicName.equals(that.topicName) : that.topicName != null) return false;
            return this.tracingConfig != null ? this.tracingConfig.equals(that.tracingConfig) : that.tracingConfig == null;
        }

        @Override
        public final int hashCode() {
            int result = this.contentBasedDeduplication != null ? this.contentBasedDeduplication.hashCode() : 0;
            result = 31 * result + (this.displayName != null ? this.displayName.hashCode() : 0);
            result = 31 * result + (this.enforceSsl != null ? this.enforceSsl.hashCode() : 0);
            result = 31 * result + (this.fifo != null ? this.fifo.hashCode() : 0);
            result = 31 * result + (this.fifoThroughputScope != null ? this.fifoThroughputScope.hashCode() : 0);
            result = 31 * result + (this.loggingConfigs != null ? this.loggingConfigs.hashCode() : 0);
            result = 31 * result + (this.masterKey != null ? this.masterKey.hashCode() : 0);
            result = 31 * result + (this.messageRetentionPeriodInDays != null ? this.messageRetentionPeriodInDays.hashCode() : 0);
            result = 31 * result + (this.signatureVersion != null ? this.signatureVersion.hashCode() : 0);
            result = 31 * result + (this.topicName != null ? this.topicName.hashCode() : 0);
            result = 31 * result + (this.tracingConfig != null ? this.tracingConfig.hashCode() : 0);
            return result;
        }
    }
}
