package software.amazon.awscdk.services.stepfunctions;

/**
 * Options for selecting the choice paths.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.stepfunctions.*;
 * AfterwardsOptions afterwardsOptions = AfterwardsOptions.builder()
 *         .includeErrorHandlers(false)
 *         .includeOtherwise(false)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-05-20T23:53:04.226Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_stepfunctions.AfterwardsOptions")
@software.amazon.jsii.Jsii.Proxy(AfterwardsOptions.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface AfterwardsOptions extends software.amazon.jsii.JsiiSerializable {

    /**
     * Whether to include error handling states.
     * <p>
     * If this is true, all states which are error handlers (added through 'onError')
     * and states reachable via error handlers will be included as well.
     * <p>
     * Default: false
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getIncludeErrorHandlers() {
        return null;
    }

    /**
     * Whether to include the default/otherwise transition for the current Choice state.
     * <p>
     * If this is true and the current Choice does not have a default outgoing
     * transition, one will be added included when .next() is called on the chain.
     * <p>
     * Default: false
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getIncludeOtherwise() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link AfterwardsOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link AfterwardsOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<AfterwardsOptions> {
        java.lang.Boolean includeErrorHandlers;
        java.lang.Boolean includeOtherwise;

        /**
         * Sets the value of {@link AfterwardsOptions#getIncludeErrorHandlers}
         * @param includeErrorHandlers Whether to include error handling states.
         *                             If this is true, all states which are error handlers (added through 'onError')
         *                             and states reachable via error handlers will be included as well.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder includeErrorHandlers(java.lang.Boolean includeErrorHandlers) {
            this.includeErrorHandlers = includeErrorHandlers;
            return this;
        }

        /**
         * Sets the value of {@link AfterwardsOptions#getIncludeOtherwise}
         * @param includeOtherwise Whether to include the default/otherwise transition for the current Choice state.
         *                         If this is true and the current Choice does not have a default outgoing
         *                         transition, one will be added included when .next() is called on the chain.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder includeOtherwise(java.lang.Boolean includeOtherwise) {
            this.includeOtherwise = includeOtherwise;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link AfterwardsOptions}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public AfterwardsOptions build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link AfterwardsOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AfterwardsOptions {
        private final java.lang.Boolean includeErrorHandlers;
        private final java.lang.Boolean includeOtherwise;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.includeErrorHandlers = software.amazon.jsii.Kernel.get(this, "includeErrorHandlers", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.includeOtherwise = software.amazon.jsii.Kernel.get(this, "includeOtherwise", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.includeErrorHandlers = builder.includeErrorHandlers;
            this.includeOtherwise = builder.includeOtherwise;
        }

        @Override
        public final java.lang.Boolean getIncludeErrorHandlers() {
            return this.includeErrorHandlers;
        }

        @Override
        public final java.lang.Boolean getIncludeOtherwise() {
            return this.includeOtherwise;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getIncludeErrorHandlers() != null) {
                data.set("includeErrorHandlers", om.valueToTree(this.getIncludeErrorHandlers()));
            }
            if (this.getIncludeOtherwise() != null) {
                data.set("includeOtherwise", om.valueToTree(this.getIncludeOtherwise()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_stepfunctions.AfterwardsOptions"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            AfterwardsOptions.Jsii$Proxy that = (AfterwardsOptions.Jsii$Proxy) o;

            if (this.includeErrorHandlers != null ? !this.includeErrorHandlers.equals(that.includeErrorHandlers) : that.includeErrorHandlers != null) return false;
            return this.includeOtherwise != null ? this.includeOtherwise.equals(that.includeOtherwise) : that.includeOtherwise == null;
        }

        @Override
        public final int hashCode() {
            int result = this.includeErrorHandlers != null ? this.includeErrorHandlers.hashCode() : 0;
            result = 31 * result + (this.includeOtherwise != null ? this.includeOtherwise.hashCode() : 0);
            return result;
        }
    }
}
