package software.amazon.awscdk.services.stepfunctions;

/**
 * The format of the Output of the child workflow executions.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.services.s3.*;
 * // create a bucket
 * Bucket bucket = new Bucket(this, "Bucket");
 * // create a WriterConfig
 * DistributedMap distributedMap = DistributedMap.Builder.create(this, "Distributed Map State")
 *         .resultWriterV2(ResultWriterV2.Builder.create()
 *                 .bucket(bucket)
 *                 .prefix("my-prefix")
 *                 .writerConfig(Map.of(
 *                         "outputType", OutputType.JSONL,
 *                         "transformation", Transformation.NONE))
 *                 .build())
 *         .build();
 * distributedMap.itemProcessor(new Pass(this, "Pass State"));
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-05-20T23:53:04.306Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_stepfunctions.OutputType")
public enum OutputType {
    /**
     * Formats the results as a JSON array.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    JSON,
    /**
     * Formats the results as JSON Lines.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    JSONL,
}
