package software.amazon.awscdk.services.stepfunctions.tasks;

/**
 * Options to configure a cron expression.
 * <p>
 * All fields are strings so you can use complex expressions. Absence of
 * a field implies '*' or '?', whichever one is appropriate.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.stepfunctions.tasks.*;
 * CronOptions cronOptions = CronOptions.builder()
 *         .day("day")
 *         .hour("hour")
 *         .minute("minute")
 *         .month("month")
 *         .weekDay("weekDay")
 *         .year("year")
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch_Synthetics_Canaries_cron.html">https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch_Synthetics_Canaries_cron.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-05-20T23:53:04.499Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_stepfunctions_tasks.CronOptions")
@software.amazon.jsii.Jsii.Proxy(CronOptions.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CronOptions extends software.amazon.jsii.JsiiSerializable {

    /**
     * The day of the month to run this rule at.
     * <p>
     * Default: - Every day of the month
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDay() {
        return null;
    }

    /**
     * The hour to run this rule at.
     * <p>
     * Default: - Every hour
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getHour() {
        return null;
    }

    /**
     * The minute to run this rule at.
     * <p>
     * Default: - Every minute
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getMinute() {
        return null;
    }

    /**
     * The month to run this rule at.
     * <p>
     * Default: - Every month
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getMonth() {
        return null;
    }

    /**
     * The day of the week to run this rule at.
     * <p>
     * Default: - Whichever day of the week that `day` falls on
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getWeekDay() {
        return null;
    }

    /**
     * The year to run this rule at.
     * <p>
     * Default: - Every year
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getYear() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CronOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CronOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CronOptions> {
        java.lang.String day;
        java.lang.String hour;
        java.lang.String minute;
        java.lang.String month;
        java.lang.String weekDay;
        java.lang.String year;

        /**
         * Sets the value of {@link CronOptions#getDay}
         * @param day The day of the month to run this rule at.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder day(java.lang.String day) {
            this.day = day;
            return this;
        }

        /**
         * Sets the value of {@link CronOptions#getHour}
         * @param hour The hour to run this rule at.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder hour(java.lang.String hour) {
            this.hour = hour;
            return this;
        }

        /**
         * Sets the value of {@link CronOptions#getMinute}
         * @param minute The minute to run this rule at.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder minute(java.lang.String minute) {
            this.minute = minute;
            return this;
        }

        /**
         * Sets the value of {@link CronOptions#getMonth}
         * @param month The month to run this rule at.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder month(java.lang.String month) {
            this.month = month;
            return this;
        }

        /**
         * Sets the value of {@link CronOptions#getWeekDay}
         * @param weekDay The day of the week to run this rule at.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder weekDay(java.lang.String weekDay) {
            this.weekDay = weekDay;
            return this;
        }

        /**
         * Sets the value of {@link CronOptions#getYear}
         * @param year The year to run this rule at.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder year(java.lang.String year) {
            this.year = year;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CronOptions}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CronOptions build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CronOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CronOptions {
        private final java.lang.String day;
        private final java.lang.String hour;
        private final java.lang.String minute;
        private final java.lang.String month;
        private final java.lang.String weekDay;
        private final java.lang.String year;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.day = software.amazon.jsii.Kernel.get(this, "day", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.hour = software.amazon.jsii.Kernel.get(this, "hour", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.minute = software.amazon.jsii.Kernel.get(this, "minute", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.month = software.amazon.jsii.Kernel.get(this, "month", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.weekDay = software.amazon.jsii.Kernel.get(this, "weekDay", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.year = software.amazon.jsii.Kernel.get(this, "year", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.day = builder.day;
            this.hour = builder.hour;
            this.minute = builder.minute;
            this.month = builder.month;
            this.weekDay = builder.weekDay;
            this.year = builder.year;
        }

        @Override
        public final java.lang.String getDay() {
            return this.day;
        }

        @Override
        public final java.lang.String getHour() {
            return this.hour;
        }

        @Override
        public final java.lang.String getMinute() {
            return this.minute;
        }

        @Override
        public final java.lang.String getMonth() {
            return this.month;
        }

        @Override
        public final java.lang.String getWeekDay() {
            return this.weekDay;
        }

        @Override
        public final java.lang.String getYear() {
            return this.year;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getDay() != null) {
                data.set("day", om.valueToTree(this.getDay()));
            }
            if (this.getHour() != null) {
                data.set("hour", om.valueToTree(this.getHour()));
            }
            if (this.getMinute() != null) {
                data.set("minute", om.valueToTree(this.getMinute()));
            }
            if (this.getMonth() != null) {
                data.set("month", om.valueToTree(this.getMonth()));
            }
            if (this.getWeekDay() != null) {
                data.set("weekDay", om.valueToTree(this.getWeekDay()));
            }
            if (this.getYear() != null) {
                data.set("year", om.valueToTree(this.getYear()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_stepfunctions_tasks.CronOptions"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CronOptions.Jsii$Proxy that = (CronOptions.Jsii$Proxy) o;

            if (this.day != null ? !this.day.equals(that.day) : that.day != null) return false;
            if (this.hour != null ? !this.hour.equals(that.hour) : that.hour != null) return false;
            if (this.minute != null ? !this.minute.equals(that.minute) : that.minute != null) return false;
            if (this.month != null ? !this.month.equals(that.month) : that.month != null) return false;
            if (this.weekDay != null ? !this.weekDay.equals(that.weekDay) : that.weekDay != null) return false;
            return this.year != null ? this.year.equals(that.year) : that.year == null;
        }

        @Override
        public final int hashCode() {
            int result = this.day != null ? this.day.hashCode() : 0;
            result = 31 * result + (this.hour != null ? this.hour.hashCode() : 0);
            result = 31 * result + (this.minute != null ? this.minute.hashCode() : 0);
            result = 31 * result + (this.month != null ? this.month.hashCode() : 0);
            result = 31 * result + (this.weekDay != null ? this.weekDay.hashCode() : 0);
            result = 31 * result + (this.year != null ? this.year.hashCode() : 0);
            return result;
        }
    }
}
