package software.amazon.awscdk.services.stepfunctions.tasks;

/**
 * Properties for creating an AWS EventBridge Scheduler schedule using JSONata.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.*;
 * import software.amazon.awscdk.services.kms.*;
 * import software.amazon.awscdk.services.stepfunctions.*;
 * import software.amazon.awscdk.services.stepfunctions.tasks.*;
 * Object assign;
 * EventBridgeSchedulerTarget eventBridgeSchedulerTarget;
 * Key key;
 * Object outputs;
 * Schedule schedule;
 * TaskRole taskRole;
 * Timeout timeout;
 * EventBridgeSchedulerCreateScheduleTaskJsonataProps eventBridgeSchedulerCreateScheduleTaskJsonataProps = EventBridgeSchedulerCreateScheduleTaskJsonataProps.builder()
 *         .schedule(schedule)
 *         .scheduleName("scheduleName")
 *         .target(eventBridgeSchedulerTarget)
 *         // the properties below are optional
 *         .actionAfterCompletion(ActionAfterCompletion.NONE)
 *         .assign(Map.of(
 *                 "assignKey", assign))
 *         .clientToken("clientToken")
 *         .comment("comment")
 *         .credentials(Credentials.builder()
 *                 .role(taskRole)
 *                 .build())
 *         .description("description")
 *         .enabled(false)
 *         .endDate(new Date())
 *         .flexibleTimeWindow(Duration.minutes(30))
 *         .groupName("groupName")
 *         .heartbeat(Duration.minutes(30))
 *         .heartbeatTimeout(timeout)
 *         .integrationPattern(IntegrationPattern.REQUEST_RESPONSE)
 *         .kmsKey(key)
 *         .outputs(outputs)
 *         .queryLanguage(QueryLanguage.JSON_PATH)
 *         .startDate(new Date())
 *         .stateName("stateName")
 *         .taskTimeout(timeout)
 *         .timeout(Duration.minutes(30))
 *         .timezone("timezone")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-05-20T23:53:04.670Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_stepfunctions_tasks.EventBridgeSchedulerCreateScheduleTaskJsonataProps")
@software.amazon.jsii.Jsii.Proxy(EventBridgeSchedulerCreateScheduleTaskJsonataProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface EventBridgeSchedulerCreateScheduleTaskJsonataProps extends software.amazon.jsii.JsiiSerializable, software.amazon.awscdk.services.stepfunctions.TaskStateJsonataBaseProps {

    /**
     * The schedule that defines when the schedule will trigger.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/scheduler/latest/UserGuide/schedule-types.html">https://docs.aws.amazon.com/scheduler/latest/UserGuide/schedule-types.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.stepfunctions.tasks.Schedule getSchedule();

    /**
     * Schedule name.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getScheduleName();

    /**
     * The schedule's target.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.stepfunctions.tasks.EventBridgeSchedulerTarget getTarget();

    /**
     * Specifies the action that EventBridge Scheduler applies to the schedule after the schedule completes invoking the target.
     * <p>
     * Default: ActionAfterCompletion.NONE
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.stepfunctions.tasks.ActionAfterCompletion getActionAfterCompletion() {
        return null;
    }

    /**
     * Unique, case-sensitive identifier to ensure the idempotency of the request.
     * <p>
     * Default: - Automatically generated
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getClientToken() {
        return null;
    }

    /**
     * The description for the schedule.
     * <p>
     * Default: - No description
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
        return null;
    }

    /**
     * Specifies whether the schedule is enabled or disabled.
     * <p>
     * Default: true
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getEnabled() {
        return null;
    }

    /**
     * The date, in UTC, before which the schedule can invoke its target.
     * <p>
     * Depending on the schedule's recurrence expression, invocations might stop on, or before, the EndDate you specify.
     * EventBridge Scheduler ignores EndDate for one-time schedules.
     * <p>
     * Default: - No end date
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.time.Instant getEndDate() {
        return null;
    }

    /**
     * The maximum time window during which a schedule can be invoked.
     * <p>
     * Minimum value is 1 minute.
     * Maximum value is 1440 minutes (1 day).
     * <p>
     * Default: - Flexible time window is not enabled.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.Duration getFlexibleTimeWindow() {
        return null;
    }

    /**
     * The name of the schedule group to associate with this schedule.
     * <p>
     * Default: - The default schedule group is used.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getGroupName() {
        return null;
    }

    /**
     * The customer managed KMS key that EventBridge Scheduler will use to encrypt and decrypt payload.
     * <p>
     * Default: - Use automatically generated KMS key
     * <p>
     * @see <a href="https://docs.aws.amazon.com/scheduler/latest/UserGuide/encryption-rest.html">https://docs.aws.amazon.com/scheduler/latest/UserGuide/encryption-rest.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.kms.IKey getKmsKey() {
        return null;
    }

    /**
     * The date, in UTC, after which the schedule can begin invoking its target.
     * <p>
     * Depending on the schedule's recurrence expression, invocations might occur on, or after, the StartDate you specify.
     * EventBridge Scheduler ignores StartDate for one-time schedules.
     * <p>
     * Default: - No start date
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.time.Instant getStartDate() {
        return null;
    }

    /**
     * The timezone in which the scheduling expression is evaluated.
     * <p>
     * Default: - UTC
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getTimezone() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link EventBridgeSchedulerCreateScheduleTaskJsonataProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link EventBridgeSchedulerCreateScheduleTaskJsonataProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<EventBridgeSchedulerCreateScheduleTaskJsonataProps> {
        software.amazon.awscdk.services.stepfunctions.tasks.Schedule schedule;
        java.lang.String scheduleName;
        software.amazon.awscdk.services.stepfunctions.tasks.EventBridgeSchedulerTarget target;
        software.amazon.awscdk.services.stepfunctions.tasks.ActionAfterCompletion actionAfterCompletion;
        java.lang.String clientToken;
        java.lang.String description;
        java.lang.Boolean enabled;
        java.time.Instant endDate;
        software.amazon.awscdk.Duration flexibleTimeWindow;
        java.lang.String groupName;
        software.amazon.awscdk.services.kms.IKey kmsKey;
        java.time.Instant startDate;
        java.lang.String timezone;
        java.lang.String comment;
        software.amazon.awscdk.services.stepfunctions.QueryLanguage queryLanguage;
        java.lang.String stateName;
        software.amazon.awscdk.services.stepfunctions.Credentials credentials;
        software.amazon.awscdk.Duration heartbeat;
        software.amazon.awscdk.services.stepfunctions.Timeout heartbeatTimeout;
        software.amazon.awscdk.services.stepfunctions.IntegrationPattern integrationPattern;
        software.amazon.awscdk.services.stepfunctions.Timeout taskTimeout;
        software.amazon.awscdk.Duration timeout;
        java.util.Map<java.lang.String, java.lang.Object> assign;
        java.lang.Object outputs;

        /**
         * Sets the value of {@link EventBridgeSchedulerCreateScheduleTaskJsonataProps#getSchedule}
         * @param schedule The schedule that defines when the schedule will trigger. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder schedule(software.amazon.awscdk.services.stepfunctions.tasks.Schedule schedule) {
            this.schedule = schedule;
            return this;
        }

        /**
         * Sets the value of {@link EventBridgeSchedulerCreateScheduleTaskJsonataProps#getScheduleName}
         * @param scheduleName Schedule name. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder scheduleName(java.lang.String scheduleName) {
            this.scheduleName = scheduleName;
            return this;
        }

        /**
         * Sets the value of {@link EventBridgeSchedulerCreateScheduleTaskJsonataProps#getTarget}
         * @param target The schedule's target. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder target(software.amazon.awscdk.services.stepfunctions.tasks.EventBridgeSchedulerTarget target) {
            this.target = target;
            return this;
        }

        /**
         * Sets the value of {@link EventBridgeSchedulerCreateScheduleTaskJsonataProps#getActionAfterCompletion}
         * @param actionAfterCompletion Specifies the action that EventBridge Scheduler applies to the schedule after the schedule completes invoking the target.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder actionAfterCompletion(software.amazon.awscdk.services.stepfunctions.tasks.ActionAfterCompletion actionAfterCompletion) {
            this.actionAfterCompletion = actionAfterCompletion;
            return this;
        }

        /**
         * Sets the value of {@link EventBridgeSchedulerCreateScheduleTaskJsonataProps#getClientToken}
         * @param clientToken Unique, case-sensitive identifier to ensure the idempotency of the request.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder clientToken(java.lang.String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        /**
         * Sets the value of {@link EventBridgeSchedulerCreateScheduleTaskJsonataProps#getDescription}
         * @param description The description for the schedule.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(java.lang.String description) {
            this.description = description;
            return this;
        }

        /**
         * Sets the value of {@link EventBridgeSchedulerCreateScheduleTaskJsonataProps#getEnabled}
         * @param enabled Specifies whether the schedule is enabled or disabled.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder enabled(java.lang.Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        /**
         * Sets the value of {@link EventBridgeSchedulerCreateScheduleTaskJsonataProps#getEndDate}
         * @param endDate The date, in UTC, before which the schedule can invoke its target.
         *                Depending on the schedule's recurrence expression, invocations might stop on, or before, the EndDate you specify.
         *                EventBridge Scheduler ignores EndDate for one-time schedules.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder endDate(java.time.Instant endDate) {
            this.endDate = endDate;
            return this;
        }

        /**
         * Sets the value of {@link EventBridgeSchedulerCreateScheduleTaskJsonataProps#getFlexibleTimeWindow}
         * @param flexibleTimeWindow The maximum time window during which a schedule can be invoked.
         *                           Minimum value is 1 minute.
         *                           Maximum value is 1440 minutes (1 day).
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder flexibleTimeWindow(software.amazon.awscdk.Duration flexibleTimeWindow) {
            this.flexibleTimeWindow = flexibleTimeWindow;
            return this;
        }

        /**
         * Sets the value of {@link EventBridgeSchedulerCreateScheduleTaskJsonataProps#getGroupName}
         * @param groupName The name of the schedule group to associate with this schedule.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder groupName(java.lang.String groupName) {
            this.groupName = groupName;
            return this;
        }

        /**
         * Sets the value of {@link EventBridgeSchedulerCreateScheduleTaskJsonataProps#getKmsKey}
         * @param kmsKey The customer managed KMS key that EventBridge Scheduler will use to encrypt and decrypt payload.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder kmsKey(software.amazon.awscdk.services.kms.IKey kmsKey) {
            this.kmsKey = kmsKey;
            return this;
        }

        /**
         * Sets the value of {@link EventBridgeSchedulerCreateScheduleTaskJsonataProps#getStartDate}
         * @param startDate The date, in UTC, after which the schedule can begin invoking its target.
         *                  Depending on the schedule's recurrence expression, invocations might occur on, or after, the StartDate you specify.
         *                  EventBridge Scheduler ignores StartDate for one-time schedules.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder startDate(java.time.Instant startDate) {
            this.startDate = startDate;
            return this;
        }

        /**
         * Sets the value of {@link EventBridgeSchedulerCreateScheduleTaskJsonataProps#getTimezone}
         * @param timezone The timezone in which the scheduling expression is evaluated.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder timezone(java.lang.String timezone) {
            this.timezone = timezone;
            return this;
        }

        /**
         * Sets the value of {@link EventBridgeSchedulerCreateScheduleTaskJsonataProps#getComment}
         * @param comment A comment describing this state.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder comment(java.lang.String comment) {
            this.comment = comment;
            return this;
        }

        /**
         * Sets the value of {@link EventBridgeSchedulerCreateScheduleTaskJsonataProps#getQueryLanguage}
         * @param queryLanguage The name of the query language used by the state.
         *                      If the state does not contain a <code>queryLanguage</code> field,
         *                      then it will use the query language specified in the top-level <code>queryLanguage</code> field.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder queryLanguage(software.amazon.awscdk.services.stepfunctions.QueryLanguage queryLanguage) {
            this.queryLanguage = queryLanguage;
            return this;
        }

        /**
         * Sets the value of {@link EventBridgeSchedulerCreateScheduleTaskJsonataProps#getStateName}
         * @param stateName Optional name for this state.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder stateName(java.lang.String stateName) {
            this.stateName = stateName;
            return this;
        }

        /**
         * Sets the value of {@link EventBridgeSchedulerCreateScheduleTaskJsonataProps#getCredentials}
         * @param credentials Credentials for an IAM Role that the State Machine assumes for executing the task.
         *                    This enables cross-account resource invocations.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder credentials(software.amazon.awscdk.services.stepfunctions.Credentials credentials) {
            this.credentials = credentials;
            return this;
        }

        /**
         * Sets the value of {@link EventBridgeSchedulerCreateScheduleTaskJsonataProps#getHeartbeat}
         * @param heartbeat Timeout for the heartbeat.
         * @return {@code this}
         * @deprecated use `heartbeatTimeout`
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
        @Deprecated
        public Builder heartbeat(software.amazon.awscdk.Duration heartbeat) {
            this.heartbeat = heartbeat;
            return this;
        }

        /**
         * Sets the value of {@link EventBridgeSchedulerCreateScheduleTaskJsonataProps#getHeartbeatTimeout}
         * @param heartbeatTimeout Timeout for the heartbeat.
         *                         [disable-awslint:duration-prop-type] is needed because all props interface in
         *                         aws-stepfunctions-tasks extend this interface
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder heartbeatTimeout(software.amazon.awscdk.services.stepfunctions.Timeout heartbeatTimeout) {
            this.heartbeatTimeout = heartbeatTimeout;
            return this;
        }

        /**
         * Sets the value of {@link EventBridgeSchedulerCreateScheduleTaskJsonataProps#getIntegrationPattern}
         * @param integrationPattern AWS Step Functions integrates with services directly in the Amazon States Language.
         *                           You can control these AWS services using service integration patterns.
         *                           <p>
         *                           Depending on the AWS Service, the Service Integration Pattern availability will vary.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder integrationPattern(software.amazon.awscdk.services.stepfunctions.IntegrationPattern integrationPattern) {
            this.integrationPattern = integrationPattern;
            return this;
        }

        /**
         * Sets the value of {@link EventBridgeSchedulerCreateScheduleTaskJsonataProps#getTaskTimeout}
         * @param taskTimeout Timeout for the task.
         *                    [disable-awslint:duration-prop-type] is needed because all props interface in
         *                    aws-stepfunctions-tasks extend this interface
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder taskTimeout(software.amazon.awscdk.services.stepfunctions.Timeout taskTimeout) {
            this.taskTimeout = taskTimeout;
            return this;
        }

        /**
         * Sets the value of {@link EventBridgeSchedulerCreateScheduleTaskJsonataProps#getTimeout}
         * @param timeout Timeout for the task.
         * @return {@code this}
         * @deprecated use `taskTimeout`
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
        @Deprecated
        public Builder timeout(software.amazon.awscdk.Duration timeout) {
            this.timeout = timeout;
            return this;
        }

        /**
         * Sets the value of {@link EventBridgeSchedulerCreateScheduleTaskJsonataProps#getAssign}
         * @param assign Workflow variables to store in this step.
         *               Using workflow variables, you can store data in a step and retrieve that data in future steps.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder assign(java.util.Map<java.lang.String, ? extends java.lang.Object> assign) {
            this.assign = (java.util.Map<java.lang.String, java.lang.Object>)assign;
            return this;
        }

        /**
         * Sets the value of {@link EventBridgeSchedulerCreateScheduleTaskJsonataProps#getOutputs}
         * @param outputs Used to specify and transform output from the state.
         *                When specified, the value overrides the state output default.
         *                The output field accepts any JSON value (object, array, string, number, boolean, null).
         *                Any string value, including those inside objects or arrays,
         *                will be evaluated as JSONata if surrounded by {% %} characters.
         *                Output also accepts a JSONata expression directly.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder outputs(java.lang.Object outputs) {
            this.outputs = outputs;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link EventBridgeSchedulerCreateScheduleTaskJsonataProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public EventBridgeSchedulerCreateScheduleTaskJsonataProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link EventBridgeSchedulerCreateScheduleTaskJsonataProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements EventBridgeSchedulerCreateScheduleTaskJsonataProps {
        private final software.amazon.awscdk.services.stepfunctions.tasks.Schedule schedule;
        private final java.lang.String scheduleName;
        private final software.amazon.awscdk.services.stepfunctions.tasks.EventBridgeSchedulerTarget target;
        private final software.amazon.awscdk.services.stepfunctions.tasks.ActionAfterCompletion actionAfterCompletion;
        private final java.lang.String clientToken;
        private final java.lang.String description;
        private final java.lang.Boolean enabled;
        private final java.time.Instant endDate;
        private final software.amazon.awscdk.Duration flexibleTimeWindow;
        private final java.lang.String groupName;
        private final software.amazon.awscdk.services.kms.IKey kmsKey;
        private final java.time.Instant startDate;
        private final java.lang.String timezone;
        private final java.lang.String comment;
        private final software.amazon.awscdk.services.stepfunctions.QueryLanguage queryLanguage;
        private final java.lang.String stateName;
        private final software.amazon.awscdk.services.stepfunctions.Credentials credentials;
        private final software.amazon.awscdk.Duration heartbeat;
        private final software.amazon.awscdk.services.stepfunctions.Timeout heartbeatTimeout;
        private final software.amazon.awscdk.services.stepfunctions.IntegrationPattern integrationPattern;
        private final software.amazon.awscdk.services.stepfunctions.Timeout taskTimeout;
        private final software.amazon.awscdk.Duration timeout;
        private final java.util.Map<java.lang.String, java.lang.Object> assign;
        private final java.lang.Object outputs;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.schedule = software.amazon.jsii.Kernel.get(this, "schedule", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.stepfunctions.tasks.Schedule.class));
            this.scheduleName = software.amazon.jsii.Kernel.get(this, "scheduleName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.target = software.amazon.jsii.Kernel.get(this, "target", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.stepfunctions.tasks.EventBridgeSchedulerTarget.class));
            this.actionAfterCompletion = software.amazon.jsii.Kernel.get(this, "actionAfterCompletion", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.stepfunctions.tasks.ActionAfterCompletion.class));
            this.clientToken = software.amazon.jsii.Kernel.get(this, "clientToken", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.description = software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.enabled = software.amazon.jsii.Kernel.get(this, "enabled", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.endDate = software.amazon.jsii.Kernel.get(this, "endDate", software.amazon.jsii.NativeType.forClass(java.time.Instant.class));
            this.flexibleTimeWindow = software.amazon.jsii.Kernel.get(this, "flexibleTimeWindow", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.Duration.class));
            this.groupName = software.amazon.jsii.Kernel.get(this, "groupName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.kmsKey = software.amazon.jsii.Kernel.get(this, "kmsKey", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.kms.IKey.class));
            this.startDate = software.amazon.jsii.Kernel.get(this, "startDate", software.amazon.jsii.NativeType.forClass(java.time.Instant.class));
            this.timezone = software.amazon.jsii.Kernel.get(this, "timezone", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.comment = software.amazon.jsii.Kernel.get(this, "comment", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.queryLanguage = software.amazon.jsii.Kernel.get(this, "queryLanguage", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.stepfunctions.QueryLanguage.class));
            this.stateName = software.amazon.jsii.Kernel.get(this, "stateName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.credentials = software.amazon.jsii.Kernel.get(this, "credentials", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.stepfunctions.Credentials.class));
            this.heartbeat = software.amazon.jsii.Kernel.get(this, "heartbeat", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.Duration.class));
            this.heartbeatTimeout = software.amazon.jsii.Kernel.get(this, "heartbeatTimeout", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.stepfunctions.Timeout.class));
            this.integrationPattern = software.amazon.jsii.Kernel.get(this, "integrationPattern", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.stepfunctions.IntegrationPattern.class));
            this.taskTimeout = software.amazon.jsii.Kernel.get(this, "taskTimeout", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.stepfunctions.Timeout.class));
            this.timeout = software.amazon.jsii.Kernel.get(this, "timeout", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.Duration.class));
            this.assign = software.amazon.jsii.Kernel.get(this, "assign", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)));
            this.outputs = software.amazon.jsii.Kernel.get(this, "outputs", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.schedule = java.util.Objects.requireNonNull(builder.schedule, "schedule is required");
            this.scheduleName = java.util.Objects.requireNonNull(builder.scheduleName, "scheduleName is required");
            this.target = java.util.Objects.requireNonNull(builder.target, "target is required");
            this.actionAfterCompletion = builder.actionAfterCompletion;
            this.clientToken = builder.clientToken;
            this.description = builder.description;
            this.enabled = builder.enabled;
            this.endDate = builder.endDate;
            this.flexibleTimeWindow = builder.flexibleTimeWindow;
            this.groupName = builder.groupName;
            this.kmsKey = builder.kmsKey;
            this.startDate = builder.startDate;
            this.timezone = builder.timezone;
            this.comment = builder.comment;
            this.queryLanguage = builder.queryLanguage;
            this.stateName = builder.stateName;
            this.credentials = builder.credentials;
            this.heartbeat = builder.heartbeat;
            this.heartbeatTimeout = builder.heartbeatTimeout;
            this.integrationPattern = builder.integrationPattern;
            this.taskTimeout = builder.taskTimeout;
            this.timeout = builder.timeout;
            this.assign = (java.util.Map<java.lang.String, java.lang.Object>)builder.assign;
            this.outputs = builder.outputs;
        }

        @Override
        public final software.amazon.awscdk.services.stepfunctions.tasks.Schedule getSchedule() {
            return this.schedule;
        }

        @Override
        public final java.lang.String getScheduleName() {
            return this.scheduleName;
        }

        @Override
        public final software.amazon.awscdk.services.stepfunctions.tasks.EventBridgeSchedulerTarget getTarget() {
            return this.target;
        }

        @Override
        public final software.amazon.awscdk.services.stepfunctions.tasks.ActionAfterCompletion getActionAfterCompletion() {
            return this.actionAfterCompletion;
        }

        @Override
        public final java.lang.String getClientToken() {
            return this.clientToken;
        }

        @Override
        public final java.lang.String getDescription() {
            return this.description;
        }

        @Override
        public final java.lang.Boolean getEnabled() {
            return this.enabled;
        }

        @Override
        public final java.time.Instant getEndDate() {
            return this.endDate;
        }

        @Override
        public final software.amazon.awscdk.Duration getFlexibleTimeWindow() {
            return this.flexibleTimeWindow;
        }

        @Override
        public final java.lang.String getGroupName() {
            return this.groupName;
        }

        @Override
        public final software.amazon.awscdk.services.kms.IKey getKmsKey() {
            return this.kmsKey;
        }

        @Override
        public final java.time.Instant getStartDate() {
            return this.startDate;
        }

        @Override
        public final java.lang.String getTimezone() {
            return this.timezone;
        }

        @Override
        public final java.lang.String getComment() {
            return this.comment;
        }

        @Override
        public final software.amazon.awscdk.services.stepfunctions.QueryLanguage getQueryLanguage() {
            return this.queryLanguage;
        }

        @Override
        public final java.lang.String getStateName() {
            return this.stateName;
        }

        @Override
        public final software.amazon.awscdk.services.stepfunctions.Credentials getCredentials() {
            return this.credentials;
        }

        @Override
        public final software.amazon.awscdk.Duration getHeartbeat() {
            return this.heartbeat;
        }

        @Override
        public final software.amazon.awscdk.services.stepfunctions.Timeout getHeartbeatTimeout() {
            return this.heartbeatTimeout;
        }

        @Override
        public final software.amazon.awscdk.services.stepfunctions.IntegrationPattern getIntegrationPattern() {
            return this.integrationPattern;
        }

        @Override
        public final software.amazon.awscdk.services.stepfunctions.Timeout getTaskTimeout() {
            return this.taskTimeout;
        }

        @Override
        public final software.amazon.awscdk.Duration getTimeout() {
            return this.timeout;
        }

        @Override
        public final java.util.Map<java.lang.String, java.lang.Object> getAssign() {
            return this.assign;
        }

        @Override
        public final java.lang.Object getOutputs() {
            return this.outputs;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("schedule", om.valueToTree(this.getSchedule()));
            data.set("scheduleName", om.valueToTree(this.getScheduleName()));
            data.set("target", om.valueToTree(this.getTarget()));
            if (this.getActionAfterCompletion() != null) {
                data.set("actionAfterCompletion", om.valueToTree(this.getActionAfterCompletion()));
            }
            if (this.getClientToken() != null) {
                data.set("clientToken", om.valueToTree(this.getClientToken()));
            }
            if (this.getDescription() != null) {
                data.set("description", om.valueToTree(this.getDescription()));
            }
            if (this.getEnabled() != null) {
                data.set("enabled", om.valueToTree(this.getEnabled()));
            }
            if (this.getEndDate() != null) {
                data.set("endDate", om.valueToTree(this.getEndDate()));
            }
            if (this.getFlexibleTimeWindow() != null) {
                data.set("flexibleTimeWindow", om.valueToTree(this.getFlexibleTimeWindow()));
            }
            if (this.getGroupName() != null) {
                data.set("groupName", om.valueToTree(this.getGroupName()));
            }
            if (this.getKmsKey() != null) {
                data.set("kmsKey", om.valueToTree(this.getKmsKey()));
            }
            if (this.getStartDate() != null) {
                data.set("startDate", om.valueToTree(this.getStartDate()));
            }
            if (this.getTimezone() != null) {
                data.set("timezone", om.valueToTree(this.getTimezone()));
            }
            if (this.getComment() != null) {
                data.set("comment", om.valueToTree(this.getComment()));
            }
            if (this.getQueryLanguage() != null) {
                data.set("queryLanguage", om.valueToTree(this.getQueryLanguage()));
            }
            if (this.getStateName() != null) {
                data.set("stateName", om.valueToTree(this.getStateName()));
            }
            if (this.getCredentials() != null) {
                data.set("credentials", om.valueToTree(this.getCredentials()));
            }
            if (this.getHeartbeat() != null) {
                data.set("heartbeat", om.valueToTree(this.getHeartbeat()));
            }
            if (this.getHeartbeatTimeout() != null) {
                data.set("heartbeatTimeout", om.valueToTree(this.getHeartbeatTimeout()));
            }
            if (this.getIntegrationPattern() != null) {
                data.set("integrationPattern", om.valueToTree(this.getIntegrationPattern()));
            }
            if (this.getTaskTimeout() != null) {
                data.set("taskTimeout", om.valueToTree(this.getTaskTimeout()));
            }
            if (this.getTimeout() != null) {
                data.set("timeout", om.valueToTree(this.getTimeout()));
            }
            if (this.getAssign() != null) {
                data.set("assign", om.valueToTree(this.getAssign()));
            }
            if (this.getOutputs() != null) {
                data.set("outputs", om.valueToTree(this.getOutputs()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_stepfunctions_tasks.EventBridgeSchedulerCreateScheduleTaskJsonataProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            EventBridgeSchedulerCreateScheduleTaskJsonataProps.Jsii$Proxy that = (EventBridgeSchedulerCreateScheduleTaskJsonataProps.Jsii$Proxy) o;

            if (!schedule.equals(that.schedule)) return false;
            if (!scheduleName.equals(that.scheduleName)) return false;
            if (!target.equals(that.target)) return false;
            if (this.actionAfterCompletion != null ? !this.actionAfterCompletion.equals(that.actionAfterCompletion) : that.actionAfterCompletion != null) return false;
            if (this.clientToken != null ? !this.clientToken.equals(that.clientToken) : that.clientToken != null) return false;
            if (this.description != null ? !this.description.equals(that.description) : that.description != null) return false;
            if (this.enabled != null ? !this.enabled.equals(that.enabled) : that.enabled != null) return false;
            if (this.endDate != null ? !this.endDate.equals(that.endDate) : that.endDate != null) return false;
            if (this.flexibleTimeWindow != null ? !this.flexibleTimeWindow.equals(that.flexibleTimeWindow) : that.flexibleTimeWindow != null) return false;
            if (this.groupName != null ? !this.groupName.equals(that.groupName) : that.groupName != null) return false;
            if (this.kmsKey != null ? !this.kmsKey.equals(that.kmsKey) : that.kmsKey != null) return false;
            if (this.startDate != null ? !this.startDate.equals(that.startDate) : that.startDate != null) return false;
            if (this.timezone != null ? !this.timezone.equals(that.timezone) : that.timezone != null) return false;
            if (this.comment != null ? !this.comment.equals(that.comment) : that.comment != null) return false;
            if (this.queryLanguage != null ? !this.queryLanguage.equals(that.queryLanguage) : that.queryLanguage != null) return false;
            if (this.stateName != null ? !this.stateName.equals(that.stateName) : that.stateName != null) return false;
            if (this.credentials != null ? !this.credentials.equals(that.credentials) : that.credentials != null) return false;
            if (this.heartbeat != null ? !this.heartbeat.equals(that.heartbeat) : that.heartbeat != null) return false;
            if (this.heartbeatTimeout != null ? !this.heartbeatTimeout.equals(that.heartbeatTimeout) : that.heartbeatTimeout != null) return false;
            if (this.integrationPattern != null ? !this.integrationPattern.equals(that.integrationPattern) : that.integrationPattern != null) return false;
            if (this.taskTimeout != null ? !this.taskTimeout.equals(that.taskTimeout) : that.taskTimeout != null) return false;
            if (this.timeout != null ? !this.timeout.equals(that.timeout) : that.timeout != null) return false;
            if (this.assign != null ? !this.assign.equals(that.assign) : that.assign != null) return false;
            return this.outputs != null ? this.outputs.equals(that.outputs) : that.outputs == null;
        }

        @Override
        public final int hashCode() {
            int result = this.schedule.hashCode();
            result = 31 * result + (this.scheduleName.hashCode());
            result = 31 * result + (this.target.hashCode());
            result = 31 * result + (this.actionAfterCompletion != null ? this.actionAfterCompletion.hashCode() : 0);
            result = 31 * result + (this.clientToken != null ? this.clientToken.hashCode() : 0);
            result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
            result = 31 * result + (this.enabled != null ? this.enabled.hashCode() : 0);
            result = 31 * result + (this.endDate != null ? this.endDate.hashCode() : 0);
            result = 31 * result + (this.flexibleTimeWindow != null ? this.flexibleTimeWindow.hashCode() : 0);
            result = 31 * result + (this.groupName != null ? this.groupName.hashCode() : 0);
            result = 31 * result + (this.kmsKey != null ? this.kmsKey.hashCode() : 0);
            result = 31 * result + (this.startDate != null ? this.startDate.hashCode() : 0);
            result = 31 * result + (this.timezone != null ? this.timezone.hashCode() : 0);
            result = 31 * result + (this.comment != null ? this.comment.hashCode() : 0);
            result = 31 * result + (this.queryLanguage != null ? this.queryLanguage.hashCode() : 0);
            result = 31 * result + (this.stateName != null ? this.stateName.hashCode() : 0);
            result = 31 * result + (this.credentials != null ? this.credentials.hashCode() : 0);
            result = 31 * result + (this.heartbeat != null ? this.heartbeat.hashCode() : 0);
            result = 31 * result + (this.heartbeatTimeout != null ? this.heartbeatTimeout.hashCode() : 0);
            result = 31 * result + (this.integrationPattern != null ? this.integrationPattern.hashCode() : 0);
            result = 31 * result + (this.taskTimeout != null ? this.taskTimeout.hashCode() : 0);
            result = 31 * result + (this.timeout != null ? this.timeout.hashCode() : 0);
            result = 31 * result + (this.assign != null ? this.assign.hashCode() : 0);
            result = 31 * result + (this.outputs != null ? this.outputs.hashCode() : 0);
            return result;
        }
    }
}
