package software.amazon.awscdk.services.stepfunctions.tasks;

/**
 * Http Methods that API Gateway supports.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.services.apigateway.*;
 * RestApi api;
 * CallApiGatewayRestApiEndpoint.jsonata(this, "Endpoint", CallApiGatewayRestApiEndpointJsonataProps.builder()
 *         .api(api)
 *         .stageName("Stage")
 *         .method(HttpMethod.PUT)
 *         .integrationPattern(IntegrationPattern.WAIT_FOR_TASK_TOKEN)
 *         .headers(TaskInput.fromObject(Map.of(
 *                 "TaskToken", "{% States.Array($states.context.taskToken) %}")))
 *         .build());
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-05-20T23:53:04.703Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_stepfunctions_tasks.HttpMethod")
public enum HttpMethod {
    /**
     * Retrieve data from a server at the specified resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    GET,
    /**
     * Send data to the API endpoint to create or udpate a resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    POST,
    /**
     * Send data to the API endpoint to update or create a resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    PUT,
    /**
     * Delete the resource at the specified endpoint.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    DELETE,
    /**
     * Apply partial modifications to the resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    PATCH,
    /**
     * Retrieve data from a server at the specified resource without the response body.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    HEAD,
    /**
     * Return data describing what other methods and operations the server supports.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    OPTIONS,
}
