package software.amazon.awscdk.services.synthetics;

/**
 * The code the canary should execute.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.*;
 * Canary canary = Canary.Builder.create(this, "MyCanary")
 *         .schedule(Schedule.rate(Duration.minutes(5)))
 *         .test(Test.custom(CustomTestOptions.builder()
 *                 .code(Code.fromAsset(join(__dirname, "canary")))
 *                 .handler("index.handler")
 *                 .build()))
 *         .runtime(Runtime.SYNTHETICS_NODEJS_PUPPETEER_6_2)
 *         .memory(Size.mebibytes(1024))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-05-20T23:53:04.849Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_synthetics.Code")
public abstract class Code extends software.amazon.jsii.JsiiObject {

    protected Code(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected Code(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected Code() {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this);
    }

    /**
     * Specify code from a local path.
     * <p>
     * Path must include the folder structure <code>nodejs/node_modules/myCanaryFilename.js</code>.
     * <p>
     * @return <code>AssetCode</code> associated with the specified path.
     * @see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch_Synthetics_Canaries_WritingCanary.html#CloudWatch_Synthetics_Canaries_write_from_scratch">https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch_Synthetics_Canaries_WritingCanary.html#CloudWatch_Synthetics_Canaries_write_from_scratch</a>
     * @param assetPath Either a directory or a .zip file. This parameter is required.
     * @param options
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.synthetics.AssetCode fromAsset(final @org.jetbrains.annotations.NotNull java.lang.String assetPath, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.s3.assets.AssetOptions options) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.synthetics.Code.class, "fromAsset", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.synthetics.AssetCode.class), new Object[] { java.util.Objects.requireNonNull(assetPath, "assetPath is required"), options });
    }

    /**
     * Specify code from a local path.
     * <p>
     * Path must include the folder structure <code>nodejs/node_modules/myCanaryFilename.js</code>.
     * <p>
     * @return <code>AssetCode</code> associated with the specified path.
     * @see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch_Synthetics_Canaries_WritingCanary.html#CloudWatch_Synthetics_Canaries_write_from_scratch">https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch_Synthetics_Canaries_WritingCanary.html#CloudWatch_Synthetics_Canaries_write_from_scratch</a>
     * @param assetPath Either a directory or a .zip file. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.synthetics.AssetCode fromAsset(final @org.jetbrains.annotations.NotNull java.lang.String assetPath) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.synthetics.Code.class, "fromAsset", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.synthetics.AssetCode.class), new Object[] { java.util.Objects.requireNonNull(assetPath, "assetPath is required") });
    }

    /**
     * Specify code from an s3 bucket.
     * <p>
     * The object in the s3 bucket must be a .zip file that contains
     * the structure <code>nodejs/node_modules/myCanaryFilename.js</code>.
     * <p>
     * @return <code>S3Code</code> associated with the specified S3 object.
     * @see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch_Synthetics_Canaries_WritingCanary.html#CloudWatch_Synthetics_Canaries_write_from_scratch">https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch_Synthetics_Canaries_WritingCanary.html#CloudWatch_Synthetics_Canaries_write_from_scratch</a>
     * @param bucket The S3 bucket. This parameter is required.
     * @param key The object key. This parameter is required.
     * @param objectVersion Optional S3 object version.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.synthetics.S3Code fromBucket(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.s3.IBucket bucket, final @org.jetbrains.annotations.NotNull java.lang.String key, final @org.jetbrains.annotations.Nullable java.lang.String objectVersion) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.synthetics.Code.class, "fromBucket", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.synthetics.S3Code.class), new Object[] { java.util.Objects.requireNonNull(bucket, "bucket is required"), java.util.Objects.requireNonNull(key, "key is required"), objectVersion });
    }

    /**
     * Specify code from an s3 bucket.
     * <p>
     * The object in the s3 bucket must be a .zip file that contains
     * the structure <code>nodejs/node_modules/myCanaryFilename.js</code>.
     * <p>
     * @return <code>S3Code</code> associated with the specified S3 object.
     * @see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch_Synthetics_Canaries_WritingCanary.html#CloudWatch_Synthetics_Canaries_write_from_scratch">https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch_Synthetics_Canaries_WritingCanary.html#CloudWatch_Synthetics_Canaries_write_from_scratch</a>
     * @param bucket The S3 bucket. This parameter is required.
     * @param key The object key. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.synthetics.S3Code fromBucket(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.s3.IBucket bucket, final @org.jetbrains.annotations.NotNull java.lang.String key) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.synthetics.Code.class, "fromBucket", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.synthetics.S3Code.class), new Object[] { java.util.Objects.requireNonNull(bucket, "bucket is required"), java.util.Objects.requireNonNull(key, "key is required") });
    }

    /**
     * Specify code inline.
     * <p>
     * @return <code>InlineCode</code> with inline code.
     * @param code The actual handler code (limited to 5MB). This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.synthetics.InlineCode fromInline(final @org.jetbrains.annotations.NotNull java.lang.String code) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.synthetics.Code.class, "fromInline", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.synthetics.InlineCode.class), new Object[] { java.util.Objects.requireNonNull(code, "code is required") });
    }

    /**
     * Called when the canary is initialized to allow this object to bind to the stack, add resources and have fun.
     * <p>
     * @return a bound <code>CodeConfig</code>.
     * @param scope The binding scope. This parameter is required.
     * @param handler This parameter is required.
     * @param family This parameter is required.
     * @param runtimeName
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public abstract @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.synthetics.CodeConfig bind(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String handler, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.synthetics.RuntimeFamily family, final @org.jetbrains.annotations.Nullable java.lang.String runtimeName);

    /**
     * Called when the canary is initialized to allow this object to bind to the stack, add resources and have fun.
     * <p>
     * @return a bound <code>CodeConfig</code>.
     * @param scope The binding scope. This parameter is required.
     * @param handler This parameter is required.
     * @param family This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public abstract @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.synthetics.CodeConfig bind(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String handler, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.synthetics.RuntimeFamily family);

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    @software.amazon.jsii.Internal
    private static final class Jsii$Proxy extends software.amazon.awscdk.services.synthetics.Code {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
        }

        /**
         * Called when the canary is initialized to allow this object to bind to the stack, add resources and have fun.
         * <p>
         * @return a bound <code>CodeConfig</code>.
         * @param scope The binding scope. This parameter is required.
         * @param handler This parameter is required.
         * @param family This parameter is required.
         * @param runtimeName
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.synthetics.CodeConfig bind(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String handler, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.synthetics.RuntimeFamily family, final @org.jetbrains.annotations.Nullable java.lang.String runtimeName) {
            return software.amazon.jsii.Kernel.call(this, "bind", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.synthetics.CodeConfig.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(handler, "handler is required"), java.util.Objects.requireNonNull(family, "family is required"), runtimeName });
        }

        /**
         * Called when the canary is initialized to allow this object to bind to the stack, add resources and have fun.
         * <p>
         * @return a bound <code>CodeConfig</code>.
         * @param scope The binding scope. This parameter is required.
         * @param handler This parameter is required.
         * @param family This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.synthetics.CodeConfig bind(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String handler, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.synthetics.RuntimeFamily family) {
            return software.amazon.jsii.Kernel.call(this, "bind", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.synthetics.CodeConfig.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(handler, "handler is required"), java.util.Objects.requireNonNull(family, "family is required") });
        }
    }
}
