package software.amazon.awscdk.services.workspacesthinclient;

/**
 * Properties for defining a <code>CfnEnvironment</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.workspacesthinclient.*;
 * CfnEnvironmentProps cfnEnvironmentProps = CfnEnvironmentProps.builder()
 *         .desktopArn("desktopArn")
 *         // the properties below are optional
 *         .desiredSoftwareSetId("desiredSoftwareSetId")
 *         .desktopEndpoint("desktopEndpoint")
 *         .deviceCreationTags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .kmsKeyArn("kmsKeyArn")
 *         .maintenanceWindow(MaintenanceWindowProperty.builder()
 *                 .type("type")
 *                 // the properties below are optional
 *                 .applyTimeOf("applyTimeOf")
 *                 .daysOfTheWeek(List.of("daysOfTheWeek"))
 *                 .endTimeHour(123)
 *                 .endTimeMinute(123)
 *                 .startTimeHour(123)
 *                 .startTimeMinute(123)
 *                 .build())
 *         .name("name")
 *         .softwareSetUpdateMode("softwareSetUpdateMode")
 *         .softwareSetUpdateSchedule("softwareSetUpdateSchedule")
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-workspacesthinclient-environment.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-workspacesthinclient-environment.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-05-20T23:53:05.327Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_workspacesthinclient.CfnEnvironmentProps")
@software.amazon.jsii.Jsii.Proxy(CfnEnvironmentProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnEnvironmentProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The Amazon Resource Name (ARN) of the desktop to stream from Amazon WorkSpaces, WorkSpaces Secure Browser, or AppStream 2.0.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-workspacesthinclient-environment.html#cfn-workspacesthinclient-environment-desktoparn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-workspacesthinclient-environment.html#cfn-workspacesthinclient-environment-desktoparn</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getDesktopArn();

    /**
     * The ID of the software set to apply.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-workspacesthinclient-environment.html#cfn-workspacesthinclient-environment-desiredsoftwaresetid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-workspacesthinclient-environment.html#cfn-workspacesthinclient-environment-desiredsoftwaresetid</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDesiredSoftwareSetId() {
        return null;
    }

    /**
     * The URL for the identity provider login (only for environments that use AppStream 2.0).
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-workspacesthinclient-environment.html#cfn-workspacesthinclient-environment-desktopendpoint">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-workspacesthinclient-environment.html#cfn-workspacesthinclient-environment-desktopendpoint</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDesktopEndpoint() {
        return null;
    }

    /**
     * An array of key-value pairs to apply to the newly created devices for this environment.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-workspacesthinclient-environment.html#cfn-workspacesthinclient-environment-devicecreationtags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-workspacesthinclient-environment.html#cfn-workspacesthinclient-environment-devicecreationtags</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getDeviceCreationTags() {
        return null;
    }

    /**
     * The Amazon Resource Name (ARN) of the AWS Key Management Service key used to encrypt the environment.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-workspacesthinclient-environment.html#cfn-workspacesthinclient-environment-kmskeyarn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-workspacesthinclient-environment.html#cfn-workspacesthinclient-environment-kmskeyarn</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getKmsKeyArn() {
        return null;
    }

    /**
     * A specification for a time window to apply software updates.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-workspacesthinclient-environment.html#cfn-workspacesthinclient-environment-maintenancewindow">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-workspacesthinclient-environment.html#cfn-workspacesthinclient-environment-maintenancewindow</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getMaintenanceWindow() {
        return null;
    }

    /**
     * The name of the environment.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-workspacesthinclient-environment.html#cfn-workspacesthinclient-environment-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-workspacesthinclient-environment.html#cfn-workspacesthinclient-environment-name</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getName() {
        return null;
    }

    /**
     * An option to define which software updates to apply.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-workspacesthinclient-environment.html#cfn-workspacesthinclient-environment-softwaresetupdatemode">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-workspacesthinclient-environment.html#cfn-workspacesthinclient-environment-softwaresetupdatemode</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getSoftwareSetUpdateMode() {
        return null;
    }

    /**
     * An option to define if software updates should be applied within a maintenance window.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-workspacesthinclient-environment.html#cfn-workspacesthinclient-environment-softwaresetupdateschedule">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-workspacesthinclient-environment.html#cfn-workspacesthinclient-environment-softwaresetupdateschedule</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getSoftwareSetUpdateSchedule() {
        return null;
    }

    /**
     * An array of key-value pairs to apply to this resource.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-resource-tags.html">Tag</a> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-workspacesthinclient-environment.html#cfn-workspacesthinclient-environment-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-workspacesthinclient-environment.html#cfn-workspacesthinclient-environment-tags</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTags() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnEnvironmentProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnEnvironmentProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnEnvironmentProps> {
        java.lang.String desktopArn;
        java.lang.String desiredSoftwareSetId;
        java.lang.String desktopEndpoint;
        java.lang.Object deviceCreationTags;
        java.lang.String kmsKeyArn;
        java.lang.Object maintenanceWindow;
        java.lang.String name;
        java.lang.String softwareSetUpdateMode;
        java.lang.String softwareSetUpdateSchedule;
        java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Sets the value of {@link CfnEnvironmentProps#getDesktopArn}
         * @param desktopArn The Amazon Resource Name (ARN) of the desktop to stream from Amazon WorkSpaces, WorkSpaces Secure Browser, or AppStream 2.0. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder desktopArn(java.lang.String desktopArn) {
            this.desktopArn = desktopArn;
            return this;
        }

        /**
         * Sets the value of {@link CfnEnvironmentProps#getDesiredSoftwareSetId}
         * @param desiredSoftwareSetId The ID of the software set to apply.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder desiredSoftwareSetId(java.lang.String desiredSoftwareSetId) {
            this.desiredSoftwareSetId = desiredSoftwareSetId;
            return this;
        }

        /**
         * Sets the value of {@link CfnEnvironmentProps#getDesktopEndpoint}
         * @param desktopEndpoint The URL for the identity provider login (only for environments that use AppStream 2.0).
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder desktopEndpoint(java.lang.String desktopEndpoint) {
            this.desktopEndpoint = desktopEndpoint;
            return this;
        }

        /**
         * Sets the value of {@link CfnEnvironmentProps#getDeviceCreationTags}
         * @param deviceCreationTags An array of key-value pairs to apply to the newly created devices for this environment.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder deviceCreationTags(software.amazon.awscdk.IResolvable deviceCreationTags) {
            this.deviceCreationTags = deviceCreationTags;
            return this;
        }

        /**
         * Sets the value of {@link CfnEnvironmentProps#getDeviceCreationTags}
         * @param deviceCreationTags An array of key-value pairs to apply to the newly created devices for this environment.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder deviceCreationTags(java.util.List<? extends java.lang.Object> deviceCreationTags) {
            this.deviceCreationTags = deviceCreationTags;
            return this;
        }

        /**
         * Sets the value of {@link CfnEnvironmentProps#getKmsKeyArn}
         * @param kmsKeyArn The Amazon Resource Name (ARN) of the AWS Key Management Service key used to encrypt the environment.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder kmsKeyArn(java.lang.String kmsKeyArn) {
            this.kmsKeyArn = kmsKeyArn;
            return this;
        }

        /**
         * Sets the value of {@link CfnEnvironmentProps#getMaintenanceWindow}
         * @param maintenanceWindow A specification for a time window to apply software updates.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder maintenanceWindow(software.amazon.awscdk.IResolvable maintenanceWindow) {
            this.maintenanceWindow = maintenanceWindow;
            return this;
        }

        /**
         * Sets the value of {@link CfnEnvironmentProps#getMaintenanceWindow}
         * @param maintenanceWindow A specification for a time window to apply software updates.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder maintenanceWindow(software.amazon.awscdk.services.workspacesthinclient.CfnEnvironment.MaintenanceWindowProperty maintenanceWindow) {
            this.maintenanceWindow = maintenanceWindow;
            return this;
        }

        /**
         * Sets the value of {@link CfnEnvironmentProps#getName}
         * @param name The name of the environment.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(java.lang.String name) {
            this.name = name;
            return this;
        }

        /**
         * Sets the value of {@link CfnEnvironmentProps#getSoftwareSetUpdateMode}
         * @param softwareSetUpdateMode An option to define which software updates to apply.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder softwareSetUpdateMode(java.lang.String softwareSetUpdateMode) {
            this.softwareSetUpdateMode = softwareSetUpdateMode;
            return this;
        }

        /**
         * Sets the value of {@link CfnEnvironmentProps#getSoftwareSetUpdateSchedule}
         * @param softwareSetUpdateSchedule An option to define if software updates should be applied within a maintenance window.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder softwareSetUpdateSchedule(java.lang.String softwareSetUpdateSchedule) {
            this.softwareSetUpdateSchedule = softwareSetUpdateSchedule;
            return this;
        }

        /**
         * Sets the value of {@link CfnEnvironmentProps#getTags}
         * @param tags An array of key-value pairs to apply to this resource.
         *             For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-resource-tags.html">Tag</a> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder tags(java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)tags;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnEnvironmentProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnEnvironmentProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnEnvironmentProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnEnvironmentProps {
        private final java.lang.String desktopArn;
        private final java.lang.String desiredSoftwareSetId;
        private final java.lang.String desktopEndpoint;
        private final java.lang.Object deviceCreationTags;
        private final java.lang.String kmsKeyArn;
        private final java.lang.Object maintenanceWindow;
        private final java.lang.String name;
        private final java.lang.String softwareSetUpdateMode;
        private final java.lang.String softwareSetUpdateSchedule;
        private final java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.desktopArn = software.amazon.jsii.Kernel.get(this, "desktopArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.desiredSoftwareSetId = software.amazon.jsii.Kernel.get(this, "desiredSoftwareSetId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.desktopEndpoint = software.amazon.jsii.Kernel.get(this, "desktopEndpoint", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.deviceCreationTags = software.amazon.jsii.Kernel.get(this, "deviceCreationTags", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.kmsKeyArn = software.amazon.jsii.Kernel.get(this, "kmsKeyArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.maintenanceWindow = software.amazon.jsii.Kernel.get(this, "maintenanceWindow", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.softwareSetUpdateMode = software.amazon.jsii.Kernel.get(this, "softwareSetUpdateMode", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.softwareSetUpdateSchedule = software.amazon.jsii.Kernel.get(this, "softwareSetUpdateSchedule", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.desktopArn = java.util.Objects.requireNonNull(builder.desktopArn, "desktopArn is required");
            this.desiredSoftwareSetId = builder.desiredSoftwareSetId;
            this.desktopEndpoint = builder.desktopEndpoint;
            this.deviceCreationTags = builder.deviceCreationTags;
            this.kmsKeyArn = builder.kmsKeyArn;
            this.maintenanceWindow = builder.maintenanceWindow;
            this.name = builder.name;
            this.softwareSetUpdateMode = builder.softwareSetUpdateMode;
            this.softwareSetUpdateSchedule = builder.softwareSetUpdateSchedule;
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)builder.tags;
        }

        @Override
        public final java.lang.String getDesktopArn() {
            return this.desktopArn;
        }

        @Override
        public final java.lang.String getDesiredSoftwareSetId() {
            return this.desiredSoftwareSetId;
        }

        @Override
        public final java.lang.String getDesktopEndpoint() {
            return this.desktopEndpoint;
        }

        @Override
        public final java.lang.Object getDeviceCreationTags() {
            return this.deviceCreationTags;
        }

        @Override
        public final java.lang.String getKmsKeyArn() {
            return this.kmsKeyArn;
        }

        @Override
        public final java.lang.Object getMaintenanceWindow() {
            return this.maintenanceWindow;
        }

        @Override
        public final java.lang.String getName() {
            return this.name;
        }

        @Override
        public final java.lang.String getSoftwareSetUpdateMode() {
            return this.softwareSetUpdateMode;
        }

        @Override
        public final java.lang.String getSoftwareSetUpdateSchedule() {
            return this.softwareSetUpdateSchedule;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.CfnTag> getTags() {
            return this.tags;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("desktopArn", om.valueToTree(this.getDesktopArn()));
            if (this.getDesiredSoftwareSetId() != null) {
                data.set("desiredSoftwareSetId", om.valueToTree(this.getDesiredSoftwareSetId()));
            }
            if (this.getDesktopEndpoint() != null) {
                data.set("desktopEndpoint", om.valueToTree(this.getDesktopEndpoint()));
            }
            if (this.getDeviceCreationTags() != null) {
                data.set("deviceCreationTags", om.valueToTree(this.getDeviceCreationTags()));
            }
            if (this.getKmsKeyArn() != null) {
                data.set("kmsKeyArn", om.valueToTree(this.getKmsKeyArn()));
            }
            if (this.getMaintenanceWindow() != null) {
                data.set("maintenanceWindow", om.valueToTree(this.getMaintenanceWindow()));
            }
            if (this.getName() != null) {
                data.set("name", om.valueToTree(this.getName()));
            }
            if (this.getSoftwareSetUpdateMode() != null) {
                data.set("softwareSetUpdateMode", om.valueToTree(this.getSoftwareSetUpdateMode()));
            }
            if (this.getSoftwareSetUpdateSchedule() != null) {
                data.set("softwareSetUpdateSchedule", om.valueToTree(this.getSoftwareSetUpdateSchedule()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_workspacesthinclient.CfnEnvironmentProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnEnvironmentProps.Jsii$Proxy that = (CfnEnvironmentProps.Jsii$Proxy) o;

            if (!desktopArn.equals(that.desktopArn)) return false;
            if (this.desiredSoftwareSetId != null ? !this.desiredSoftwareSetId.equals(that.desiredSoftwareSetId) : that.desiredSoftwareSetId != null) return false;
            if (this.desktopEndpoint != null ? !this.desktopEndpoint.equals(that.desktopEndpoint) : that.desktopEndpoint != null) return false;
            if (this.deviceCreationTags != null ? !this.deviceCreationTags.equals(that.deviceCreationTags) : that.deviceCreationTags != null) return false;
            if (this.kmsKeyArn != null ? !this.kmsKeyArn.equals(that.kmsKeyArn) : that.kmsKeyArn != null) return false;
            if (this.maintenanceWindow != null ? !this.maintenanceWindow.equals(that.maintenanceWindow) : that.maintenanceWindow != null) return false;
            if (this.name != null ? !this.name.equals(that.name) : that.name != null) return false;
            if (this.softwareSetUpdateMode != null ? !this.softwareSetUpdateMode.equals(that.softwareSetUpdateMode) : that.softwareSetUpdateMode != null) return false;
            if (this.softwareSetUpdateSchedule != null ? !this.softwareSetUpdateSchedule.equals(that.softwareSetUpdateSchedule) : that.softwareSetUpdateSchedule != null) return false;
            return this.tags != null ? this.tags.equals(that.tags) : that.tags == null;
        }

        @Override
        public final int hashCode() {
            int result = this.desktopArn.hashCode();
            result = 31 * result + (this.desiredSoftwareSetId != null ? this.desiredSoftwareSetId.hashCode() : 0);
            result = 31 * result + (this.desktopEndpoint != null ? this.desktopEndpoint.hashCode() : 0);
            result = 31 * result + (this.deviceCreationTags != null ? this.deviceCreationTags.hashCode() : 0);
            result = 31 * result + (this.kmsKeyArn != null ? this.kmsKeyArn.hashCode() : 0);
            result = 31 * result + (this.maintenanceWindow != null ? this.maintenanceWindow.hashCode() : 0);
            result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
            result = 31 * result + (this.softwareSetUpdateMode != null ? this.softwareSetUpdateMode.hashCode() : 0);
            result = 31 * result + (this.softwareSetUpdateSchedule != null ? this.softwareSetUpdateSchedule.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            return result;
        }
    }
}
