package software.amazon.awscdk;

/**
 * A construct which represents an entire CDK app. This construct is normally the root of the construct tree.
 * <p>
 * You would normally define an <code>App</code> instance in your program's entrypoint,
 * then define constructs where the app is used as the parent scope.
 * <p>
 * After all the child constructs are defined within the app, you should call
 * <code>app.synth()</code> which will emit a "cloud assembly" from this app into the
 * directory specified by <code>outdir</code>. Cloud assemblies includes artifacts such as
 * CloudFormation templates and assets that are needed to deploy this app into
 * the AWS cloud.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.*;
 * import software.amazon.awscdk.services.s3.*;
 * IBucket bucket;
 * App app = new App();
 * Stack stack = new Stack(app, "Stack");
 * Table.Builder.create(stack, "Table")
 *         .partitionKey(Attribute.builder()
 *                 .name("id")
 *                 .type(AttributeType.STRING)
 *                 .build())
 *         .importSource(ImportSourceSpecification.builder()
 *                 .compressionType(InputCompressionType.GZIP)
 *                 .inputFormat(InputFormat.csv(CsvOptions.builder()
 *                         .delimiter(",")
 *                         .headerList(List.of("id", "name"))
 *                         .build()))
 *                 .bucket(bucket)
 *                 .keyPrefix("prefix")
 *                 .build())
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="https://docs.aws.amazon.com/cdk/latest/guide/apps.html">https://docs.aws.amazon.com/cdk/latest/guide/apps.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-05-22T23:39:44.399Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.App")
public class App extends software.amazon.awscdk.Stage {

    protected App(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected App(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * Initializes a CDK application.
     * <p>
     * @param props initialization properties.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public App(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.AppProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { props });
    }

    /**
     * Initializes a CDK application.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public App() {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this);
    }

    /**
     * Checks if an object is an instance of the <code>App</code> class.
     * <p>
     * @return <code>true</code> if <code>obj</code> is an <code>App</code>.
     * @param obj The object to evaluate. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull java.lang.Boolean isApp(final @org.jetbrains.annotations.NotNull java.lang.Object obj) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.App.class, "isApp", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class), new Object[] { obj });
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.App}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.App> {
        /**
         * @return a new instance of {@link Builder}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create() {
            return new Builder();
        }

        private software.amazon.awscdk.AppProps.Builder props;

        private Builder() {
        }

        /**
         * Include runtime versioning information in the Stacks of this app.
         * <p>
         * Default: Value of 'aws:cdk:version-reporting' context key
         * <p>
         * @return {@code this}
         * @param analyticsReporting Include runtime versioning information in the Stacks of this app. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder analyticsReporting(final java.lang.Boolean analyticsReporting) {
            this.props().analyticsReporting(analyticsReporting);
            return this;
        }

        /**
         * Automatically call <code>synth()</code> before the program exits.
         * <p>
         * If you set this, you don't have to call <code>synth()</code> explicitly. Note that
         * this feature is only available for certain programming languages, and
         * calling <code>synth()</code> is still recommended.
         * <p>
         * Default: true if running via CDK CLI (`CDK_OUTDIR` is set), `false`
         * otherwise
         * <p>
         * @return {@code this}
         * @param autoSynth Automatically call <code>synth()</code> before the program exits. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder autoSynth(final java.lang.Boolean autoSynth) {
            this.props().autoSynth(autoSynth);
            return this;
        }

        /**
         * Additional context values for the application.
         * <p>
         * Context set by the CLI or the <code>context</code> key in <code>cdk.json</code> has precedence.
         * <p>
         * Context can be read from any construct using <code>node.getContext(key)</code>.
         * <p>
         * Default: - no additional context
         * <p>
         * @return {@code this}
         * @param context Additional context values for the application. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder context(final java.util.Map<java.lang.String, ? extends java.lang.Object> context) {
            this.props().context(context);
            return this;
        }

        /**
         * The stack synthesizer to use by default for all Stacks in the App.
         * <p>
         * The Stack Synthesizer controls aspects of synthesis and deployment,
         * like how assets are referenced and what IAM roles to use. For more
         * information, see the README of the main CDK package.
         * <p>
         * Default: - A `DefaultStackSynthesizer` with default settings
         * <p>
         * @return {@code this}
         * @param defaultStackSynthesizer The stack synthesizer to use by default for all Stacks in the App. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder defaultStackSynthesizer(final software.amazon.awscdk.IReusableStackSynthesizer defaultStackSynthesizer) {
            this.props().defaultStackSynthesizer(defaultStackSynthesizer);
            return this;
        }

        /**
         * The output directory into which to emit synthesized artifacts.
         * <p>
         * You should never need to set this value. By default, the value you pass to
         * the CLI's <code>--output</code> flag will be used, and if you change it to a different
         * directory the CLI will fail to pick up the generated Cloud Assembly.
         * <p>
         * This property is intended for internal and testing use.
         * <p>
         * Default: - If this value is _not_ set, considers the environment variable `CDK_OUTDIR`.
         *   If `CDK_OUTDIR` is not defined, uses a temp directory.
         * <p>
         * @return {@code this}
         * @param outdir The output directory into which to emit synthesized artifacts. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder outdir(final java.lang.String outdir) {
            this.props().outdir(outdir);
            return this;
        }

        /**
         * Validation plugins to run after synthesis.
         * <p>
         * Default: - no validation plugins
         * <p>
         * @return {@code this}
         * @param policyValidationBeta1 Validation plugins to run after synthesis. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder policyValidationBeta1(final java.util.List<? extends software.amazon.awscdk.IPolicyValidationPluginBeta1> policyValidationBeta1) {
            this.props().policyValidationBeta1(policyValidationBeta1);
            return this;
        }

        /**
         * Additional context values for the application.
         * <p>
         * Context provided here has precedence over context set by:
         * <p>
         * <ul>
         * <li>The CLI via --context</li>
         * <li>The <code>context</code> key in <code>cdk.json</code></li>
         * <li>The <code>AppProps.context</code> property</li>
         * </ul>
         * <p>
         * This property is recommended over the <code>AppProps.context</code> property since you
         * can make final decision over which context value to take in your app.
         * <p>
         * Context can be read from any construct using <code>node.getContext(key)</code>.
         * <p>
         * Default: - no additional context
         * <p>
         * Example:
         * <p>
         * <blockquote><pre>
         * // context from the CLI and from `cdk.json` are stored in the
         * // CDK_CONTEXT env variable
         * Object cliContext = JSON.parse(process.getEnv().getCDK_CONTEXT());
         * // determine whether to take the context passed in the CLI or not
         * Object determineValue = process.env.PROD ? cliContext.SOMEKEY : 'my-prod-value';
         * App.Builder.create()
         *         .postCliContext(Map.of(
         *                 "SOMEKEY", determineValue))
         *         .build();
         * </pre></blockquote>
         * <p>
         * @return {@code this}
         * @param postCliContext Additional context values for the application. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder postCliContext(final java.util.Map<java.lang.String, ? extends java.lang.Object> postCliContext) {
            this.props().postCliContext(postCliContext);
            return this;
        }

        /**
         * A list of IPropertyInjector attached to this App.
         * <p>
         * Default: - no PropertyInjectors
         * <p>
         * @return {@code this}
         * @param propertyInjectors A list of IPropertyInjector attached to this App. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder propertyInjectors(final java.util.List<? extends software.amazon.awscdk.IPropertyInjector> propertyInjectors) {
            this.props().propertyInjectors(propertyInjectors);
            return this;
        }

        /**
         * Include construct creation stack trace in the <code>aws:cdk:trace</code> metadata key of all constructs.
         * <p>
         * Default: true stack traces are included unless `aws:cdk:disable-stack-trace` is set in the context.
         * <p>
         * @return {@code this}
         * @param stackTraces Include construct creation stack trace in the <code>aws:cdk:trace</code> metadata key of all constructs. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder stackTraces(final java.lang.Boolean stackTraces) {
            this.props().stackTraces(stackTraces);
            return this;
        }

        /**
         * Include construct tree metadata as part of the Cloud Assembly.
         * <p>
         * Default: true
         * <p>
         * @return {@code this}
         * @param treeMetadata Include construct tree metadata as part of the Cloud Assembly. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder treeMetadata(final java.lang.Boolean treeMetadata) {
            this.props().treeMetadata(treeMetadata);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.App}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.App build() {
            return new software.amazon.awscdk.App(
                this.props != null ? this.props.build() : null
            );
        }

        private software.amazon.awscdk.AppProps.Builder props() {
            if (this.props == null) {
                this.props = new software.amazon.awscdk.AppProps.Builder();
            }
            return this.props;
        }
    }
}
