package software.amazon.awscdk;

/**
 * Properties for the CliCredentialsStackSynthesizer.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.*;
 * CliCredentialsStackSynthesizerProps cliCredentialsStackSynthesizerProps = CliCredentialsStackSynthesizerProps.builder()
 *         .bucketPrefix("bucketPrefix")
 *         .dockerTagPrefix("dockerTagPrefix")
 *         .fileAssetsBucketName("fileAssetsBucketName")
 *         .imageAssetsRepositoryName("imageAssetsRepositoryName")
 *         .qualifier("qualifier")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-05-22T23:39:44.540Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.CliCredentialsStackSynthesizerProps")
@software.amazon.jsii.Jsii.Proxy(CliCredentialsStackSynthesizerProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CliCredentialsStackSynthesizerProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * bucketPrefix to use while storing S3 Assets.
     * <p>
     * Default: - DefaultStackSynthesizer.DEFAULT_FILE_ASSET_PREFIX
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getBucketPrefix() {
        return null;
    }

    /**
     * A prefix to use while tagging and uploading Docker images to ECR.
     * <p>
     * This does not add any separators - the source hash will be appended to
     * this string directly.
     * <p>
     * Default: - DefaultStackSynthesizer.DEFAULT_DOCKER_ASSET_PREFIX
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDockerTagPrefix() {
        return null;
    }

    /**
     * Name of the S3 bucket to hold file assets.
     * <p>
     * You must supply this if you have given a non-standard name to the staging bucket.
     * <p>
     * The placeholders <code>${Qualifier}</code>, <code>${AWS::AccountId}</code> and <code>${AWS::Region}</code> will
     * be replaced with the values of qualifier and the stack's account and region,
     * respectively.
     * <p>
     * Default: DefaultStackSynthesizer.DEFAULT_FILE_ASSETS_BUCKET_NAME
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getFileAssetsBucketName() {
        return null;
    }

    /**
     * Name of the ECR repository to hold Docker Image assets.
     * <p>
     * You must supply this if you have given a non-standard name to the ECR repository.
     * <p>
     * The placeholders <code>${Qualifier}</code>, <code>${AWS::AccountId}</code> and <code>${AWS::Region}</code> will
     * be replaced with the values of qualifier and the stack's account and region,
     * respectively.
     * <p>
     * Default: DefaultStackSynthesizer.DEFAULT_IMAGE_ASSETS_REPOSITORY_NAME
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getImageAssetsRepositoryName() {
        return null;
    }

    /**
     * Qualifier to disambiguate multiple environments in the same account.
     * <p>
     * You can use this and leave the other naming properties empty if you have deployed
     * the bootstrap environment with standard names but only different qualifiers.
     * <p>
     * Default: - Value of context key '@aws-cdk/core:bootstrapQualifier' if set, otherwise `DefaultStackSynthesizer.DEFAULT_QUALIFIER`
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getQualifier() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CliCredentialsStackSynthesizerProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CliCredentialsStackSynthesizerProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CliCredentialsStackSynthesizerProps> {
        java.lang.String bucketPrefix;
        java.lang.String dockerTagPrefix;
        java.lang.String fileAssetsBucketName;
        java.lang.String imageAssetsRepositoryName;
        java.lang.String qualifier;

        /**
         * Sets the value of {@link CliCredentialsStackSynthesizerProps#getBucketPrefix}
         * @param bucketPrefix bucketPrefix to use while storing S3 Assets.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder bucketPrefix(java.lang.String bucketPrefix) {
            this.bucketPrefix = bucketPrefix;
            return this;
        }

        /**
         * Sets the value of {@link CliCredentialsStackSynthesizerProps#getDockerTagPrefix}
         * @param dockerTagPrefix A prefix to use while tagging and uploading Docker images to ECR.
         *                        This does not add any separators - the source hash will be appended to
         *                        this string directly.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dockerTagPrefix(java.lang.String dockerTagPrefix) {
            this.dockerTagPrefix = dockerTagPrefix;
            return this;
        }

        /**
         * Sets the value of {@link CliCredentialsStackSynthesizerProps#getFileAssetsBucketName}
         * @param fileAssetsBucketName Name of the S3 bucket to hold file assets.
         *                             You must supply this if you have given a non-standard name to the staging bucket.
         *                             <p>
         *                             The placeholders <code>${Qualifier}</code>, <code>${AWS::AccountId}</code> and <code>${AWS::Region}</code> will
         *                             be replaced with the values of qualifier and the stack's account and region,
         *                             respectively.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder fileAssetsBucketName(java.lang.String fileAssetsBucketName) {
            this.fileAssetsBucketName = fileAssetsBucketName;
            return this;
        }

        /**
         * Sets the value of {@link CliCredentialsStackSynthesizerProps#getImageAssetsRepositoryName}
         * @param imageAssetsRepositoryName Name of the ECR repository to hold Docker Image assets.
         *                                  You must supply this if you have given a non-standard name to the ECR repository.
         *                                  <p>
         *                                  The placeholders <code>${Qualifier}</code>, <code>${AWS::AccountId}</code> and <code>${AWS::Region}</code> will
         *                                  be replaced with the values of qualifier and the stack's account and region,
         *                                  respectively.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder imageAssetsRepositoryName(java.lang.String imageAssetsRepositoryName) {
            this.imageAssetsRepositoryName = imageAssetsRepositoryName;
            return this;
        }

        /**
         * Sets the value of {@link CliCredentialsStackSynthesizerProps#getQualifier}
         * @param qualifier Qualifier to disambiguate multiple environments in the same account.
         *                  You can use this and leave the other naming properties empty if you have deployed
         *                  the bootstrap environment with standard names but only different qualifiers.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder qualifier(java.lang.String qualifier) {
            this.qualifier = qualifier;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CliCredentialsStackSynthesizerProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CliCredentialsStackSynthesizerProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CliCredentialsStackSynthesizerProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CliCredentialsStackSynthesizerProps {
        private final java.lang.String bucketPrefix;
        private final java.lang.String dockerTagPrefix;
        private final java.lang.String fileAssetsBucketName;
        private final java.lang.String imageAssetsRepositoryName;
        private final java.lang.String qualifier;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.bucketPrefix = software.amazon.jsii.Kernel.get(this, "bucketPrefix", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.dockerTagPrefix = software.amazon.jsii.Kernel.get(this, "dockerTagPrefix", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.fileAssetsBucketName = software.amazon.jsii.Kernel.get(this, "fileAssetsBucketName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.imageAssetsRepositoryName = software.amazon.jsii.Kernel.get(this, "imageAssetsRepositoryName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.qualifier = software.amazon.jsii.Kernel.get(this, "qualifier", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.bucketPrefix = builder.bucketPrefix;
            this.dockerTagPrefix = builder.dockerTagPrefix;
            this.fileAssetsBucketName = builder.fileAssetsBucketName;
            this.imageAssetsRepositoryName = builder.imageAssetsRepositoryName;
            this.qualifier = builder.qualifier;
        }

        @Override
        public final java.lang.String getBucketPrefix() {
            return this.bucketPrefix;
        }

        @Override
        public final java.lang.String getDockerTagPrefix() {
            return this.dockerTagPrefix;
        }

        @Override
        public final java.lang.String getFileAssetsBucketName() {
            return this.fileAssetsBucketName;
        }

        @Override
        public final java.lang.String getImageAssetsRepositoryName() {
            return this.imageAssetsRepositoryName;
        }

        @Override
        public final java.lang.String getQualifier() {
            return this.qualifier;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getBucketPrefix() != null) {
                data.set("bucketPrefix", om.valueToTree(this.getBucketPrefix()));
            }
            if (this.getDockerTagPrefix() != null) {
                data.set("dockerTagPrefix", om.valueToTree(this.getDockerTagPrefix()));
            }
            if (this.getFileAssetsBucketName() != null) {
                data.set("fileAssetsBucketName", om.valueToTree(this.getFileAssetsBucketName()));
            }
            if (this.getImageAssetsRepositoryName() != null) {
                data.set("imageAssetsRepositoryName", om.valueToTree(this.getImageAssetsRepositoryName()));
            }
            if (this.getQualifier() != null) {
                data.set("qualifier", om.valueToTree(this.getQualifier()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.CliCredentialsStackSynthesizerProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CliCredentialsStackSynthesizerProps.Jsii$Proxy that = (CliCredentialsStackSynthesizerProps.Jsii$Proxy) o;

            if (this.bucketPrefix != null ? !this.bucketPrefix.equals(that.bucketPrefix) : that.bucketPrefix != null) return false;
            if (this.dockerTagPrefix != null ? !this.dockerTagPrefix.equals(that.dockerTagPrefix) : that.dockerTagPrefix != null) return false;
            if (this.fileAssetsBucketName != null ? !this.fileAssetsBucketName.equals(that.fileAssetsBucketName) : that.fileAssetsBucketName != null) return false;
            if (this.imageAssetsRepositoryName != null ? !this.imageAssetsRepositoryName.equals(that.imageAssetsRepositoryName) : that.imageAssetsRepositoryName != null) return false;
            return this.qualifier != null ? this.qualifier.equals(that.qualifier) : that.qualifier == null;
        }

        @Override
        public final int hashCode() {
            int result = this.bucketPrefix != null ? this.bucketPrefix.hashCode() : 0;
            result = 31 * result + (this.dockerTagPrefix != null ? this.dockerTagPrefix.hashCode() : 0);
            result = 31 * result + (this.fileAssetsBucketName != null ? this.fileAssetsBucketName.hashCode() : 0);
            result = 31 * result + (this.imageAssetsRepositoryName != null ? this.imageAssetsRepositoryName.hashCode() : 0);
            result = 31 * result + (this.qualifier != null ? this.qualifier.hashCode() : 0);
            return result;
        }
    }
}
