package software.amazon.awscdk;

/**
 * Base class for the model side of context providers.
 * <p>
 * Instances of this class communicate with context provider plugins in the 'cdk
 * toolkit' via context variables (input), outputting specialized queries for
 * more context variables (output).
 * <p>
 * ContextProvider needs access to a Construct to hook into the context mechanism.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-05-22T23:39:44.540Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.ContextProvider")
public class ContextProvider extends software.amazon.jsii.JsiiObject {

    protected ContextProvider(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected ContextProvider(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @return the context key or undefined if a key cannot be rendered (due to tokens used in any of the props)
     * @param scope This parameter is required.
     * @param options This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.GetContextKeyResult getKey(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.GetContextKeyOptions options) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.ContextProvider.class, "getKey", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.GetContextKeyResult.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(options, "options is required") });
    }

    /**
     * @param scope This parameter is required.
     * @param options This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.GetContextValueResult getValue(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.GetContextValueOptions options) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.ContextProvider.class, "getValue", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.GetContextValueResult.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(options, "options is required") });
    }
}
