package software.amazon.awscdk;

/**
 * Instantiation of a custom resource, whose implementation is provided a Provider.
 * <p>
 * This class is intended to be used by construct library authors. Application
 * builder should not be able to tell whether or not a construct is backed by
 * a custom resource, and so the use of this class should be invisible.
 * <p>
 * Instead, construct library authors declare a custom construct that hides the
 * choice of provider, and accepts a strongly-typed properties object with the
 * properties your provider accepts.
 * <p>
 * Your custom resource provider (identified by the <code>serviceToken</code> property)
 * can be one of 4 constructs:
 * <p>
 * <ul>
 * <li>If you are authoring a construct library or application, we recommend you
 * use the <code>Provider</code> class in the <code>custom-resources</code> module.</li>
 * <li>If you are authoring a construct for the CDK's AWS Construct Library,
 * you should use the <code>CustomResourceProvider</code> construct in this package.</li>
 * <li>If you want full control over the provider, you can always directly use
 * a Lambda Function or SNS Topic by passing the ARN into <code>serviceToken</code>.</li>
 * </ul>
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Stack stack = new Stack();
 * CfnParameter durToken = CfnParameter.Builder.create(stack, "MyParameter")
 *         .type("Number")
 *         .default(60)
 *         .build();
 * CustomResource.Builder.create(stack, "MyCustomResource")
 *         .serviceToken("MyServiceToken")
 *         .serviceTimeout(Duration.seconds(durToken.getValueAsNumber()))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-05-22T23:39:44.541Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.CustomResource")
public class CustomResource extends software.amazon.awscdk.Resource {

    protected CustomResource(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CustomResource(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        PROPERTY_INJECTION_ID = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.CustomResource.class, "PROPERTY_INJECTION_ID", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CustomResource(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.CustomResourceProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Returns the value of an attribute of the custom resource of an arbitrary type.
     * <p>
     * Attributes are returned from the custom resource provider through the
     * <code>Data</code> map where the key is the attribute name.
     * <p>
     * @return a token for <code>Fn::GetAtt</code>. Use <code>Token.asXxx</code> to encode the returned <code>Reference</code> as a specific type or
     * use the convenience <code>getAttString</code> for string attributes.
     * @param attributeName the name of the attribute. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.Reference getAtt(final @org.jetbrains.annotations.NotNull java.lang.String attributeName) {
        return software.amazon.jsii.Kernel.call(this, "getAtt", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.Reference.class), new Object[] { java.util.Objects.requireNonNull(attributeName, "attributeName is required") });
    }

    /**
     * Returns the value of an attribute of the custom resource of type string.
     * <p>
     * Attributes are returned from the custom resource provider through the
     * <code>Data</code> map where the key is the attribute name.
     * <p>
     * @return a token for <code>Fn::GetAtt</code> encoded as a string.
     * @param attributeName the name of the attribute. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttString(final @org.jetbrains.annotations.NotNull java.lang.String attributeName) {
        return software.amazon.jsii.Kernel.call(this, "getAttString", software.amazon.jsii.NativeType.forClass(java.lang.String.class), new Object[] { java.util.Objects.requireNonNull(attributeName, "attributeName is required") });
    }

    /**
     * Uniquely identifies this class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String PROPERTY_INJECTION_ID;

    /**
     * The physical name of this custom resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getRef() {
        return software.amazon.jsii.Kernel.get(this, "ref", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.CustomResource}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.CustomResource> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope This parameter is required.
         * @param id This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.CustomResourceProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.CustomResourceProps.Builder();
        }

        /**
         * The ARN of the provider which implements this custom resource type.
         * <p>
         * You can implement a provider by listening to raw AWS CloudFormation events
         * and specify the ARN of an SNS topic (<code>topic.topicArn</code>) or the ARN of an AWS
         * Lambda function (<code>lambda.functionArn</code>) or use the CDK's custom <a href="https://docs.aws.amazon.com/cdk/api/latest/docs/custom-resources-readme.html">resource
         * provider framework</a> which makes it easier to implement robust providers.
         * <p>
         * Provider framework:
         * <p>
         * <blockquote><pre>
         * // use the provider framework from aws-cdk/custom-resources:
         * Provider provider = Provider.Builder.create(this, "ResourceProvider")
         *         .onEventHandler(onEventHandler)
         *         .isCompleteHandler(isCompleteHandler)
         *         .build();
         * CustomResource.Builder.create(this, "MyResource")
         *         .serviceToken(provider.getServiceToken())
         *         .build();
         * </pre></blockquote>
         * <p>
         * AWS Lambda function (not recommended to use AWS Lambda Functions directly,
         * see the module README):
         * <p>
         * <blockquote><pre>
         * // invoke an AWS Lambda function when a lifecycle event occurs:
         * // invoke an AWS Lambda function when a lifecycle event occurs:
         * CustomResource.Builder.create(this, "MyResource")
         *         .serviceToken(myFunction.getFunctionArn())
         *         .build();
         * </pre></blockquote>
         * <p>
         * SNS topic (not recommended to use AWS Lambda Functions directly, see the
         * module README):
         * <p>
         * <blockquote><pre>
         * // publish lifecycle events to an SNS topic:
         * // publish lifecycle events to an SNS topic:
         * CustomResource.Builder.create(this, "MyResource")
         *         .serviceToken(myTopic.getTopicArn())
         *         .build();
         * </pre></blockquote>
         * <p>
         * Maps to <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudformation-customresource.html#cfn-cloudformation-customresource-servicetoken">ServiceToken</a> property for the <code>AWS::CloudFormation::CustomResource</code> resource
         * <p>
         * @return {@code this}
         * @param serviceToken The ARN of the provider which implements this custom resource type. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder serviceToken(final java.lang.String serviceToken) {
            this.props.serviceToken(serviceToken);
            return this;
        }

        /**
         * Convert all property keys to pascal case.
         * <p>
         * Default: false
         * <p>
         * @return {@code this}
         * @param pascalCaseProperties Convert all property keys to pascal case. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder pascalCaseProperties(final java.lang.Boolean pascalCaseProperties) {
            this.props.pascalCaseProperties(pascalCaseProperties);
            return this;
        }

        /**
         * Properties to pass to the Lambda.
         * <p>
         * Values in this <code>properties</code> dictionary can possibly overwrite other values in <code>CustomResourceProps</code>
         * E.g. <code>ServiceToken</code> and <code>ServiceTimeout</code>
         * It is recommended to avoid using same keys that exist in <code>CustomResourceProps</code>
         * <p>
         * Default: - No properties.
         * <p>
         * @return {@code this}
         * @param properties Properties to pass to the Lambda. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder properties(final java.util.Map<java.lang.String, ? extends java.lang.Object> properties) {
            this.props.properties(properties);
            return this;
        }

        /**
         * The policy to apply when this resource is removed from the application.
         * <p>
         * Default: cdk.RemovalPolicy.Destroy
         * <p>
         * @return {@code this}
         * @param removalPolicy The policy to apply when this resource is removed from the application. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder removalPolicy(final software.amazon.awscdk.RemovalPolicy removalPolicy) {
            this.props.removalPolicy(removalPolicy);
            return this;
        }

        /**
         * For custom resources, you can specify AWS::CloudFormation::CustomResource (the default) as the resource type, or you can specify your own resource type name.
         * <p>
         * For example, you can use "Custom::MyCustomResourceTypeName".
         * <p>
         * Custom resource type names must begin with "Custom::" and can include
         * alphanumeric characters and the following characters: _&#64;-. You can specify
         * a custom resource type name up to a maximum length of 60 characters. You
         * cannot change the type during an update.
         * <p>
         * Using your own resource type names helps you quickly differentiate the
         * types of custom resources in your stack. For example, if you had two custom
         * resources that conduct two different ping tests, you could name their type
         * as Custom::PingTester to make them easily identifiable as ping testers
         * (instead of using AWS::CloudFormation::CustomResource).
         * <p>
         * Default: - AWS::CloudFormation::CustomResource
         * <p>
         * @return {@code this}
         * @see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cfn-customresource.html#aws-cfn-resource-type-name">https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cfn-customresource.html#aws-cfn-resource-type-name</a>
         * @param resourceType For custom resources, you can specify AWS::CloudFormation::CustomResource (the default) as the resource type, or you can specify your own resource type name. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder resourceType(final java.lang.String resourceType) {
            this.props.resourceType(resourceType);
            return this;
        }

        /**
         * The maximum time that can elapse before a custom resource operation times out.
         * <p>
         * The value must be between 1 second and 3600 seconds.
         * <p>
         * Maps to <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudformation-customresource.html#cfn-cloudformation-customresource-servicetimeout">ServiceTimeout</a> property for the <code>AWS::CloudFormation::CustomResource</code> resource
         * <p>
         * A token can be specified for this property, but it must be specified with <code>Duration.seconds()</code>.
         * <p>
         * Default: Duration.seconds(3600)
         * <p>
         * Example:
         * <p>
         * <blockquote><pre>
         * Stack stack = new Stack();
         * CfnParameter durToken = CfnParameter.Builder.create(stack, "MyParameter")
         *         .type("Number")
         *         .default(60)
         *         .build();
         * CustomResource.Builder.create(stack, "MyCustomResource")
         *         .serviceToken("MyServiceToken")
         *         .serviceTimeout(Duration.seconds(durToken.getValueAsNumber()))
         *         .build();
         * </pre></blockquote>
         * <p>
         * @return {@code this}
         * @param serviceTimeout The maximum time that can elapse before a custom resource operation times out. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder serviceTimeout(final software.amazon.awscdk.Duration serviceTimeout) {
            this.props.serviceTimeout(serviceTimeout);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.CustomResource}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.CustomResource build() {
            return new software.amazon.awscdk.CustomResource(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
