package software.amazon.awscdk;

/**
 * This interface define an inject function that operates on a Construct's Property.
 * <p>
 * The Construct must have a constructUniqueId to uniquely identify itself.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-05-22T23:39:44.592Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.IPropertyInjector")
@software.amazon.jsii.Jsii.Proxy(IPropertyInjector.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface IPropertyInjector extends software.amazon.jsii.JsiiSerializable {

    /**
     * The unique Id of the Construct class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getConstructUniqueId();

    /**
     * The injector to be applied to the constructor properties of the Construct.
     * <p>
     * @param originalProps This parameter is required.
     * @param context This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Object inject(final @org.jetbrains.annotations.NotNull java.lang.Object originalProps, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.InjectionContext context);

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.IPropertyInjector.Jsii$Default {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
        }

        /**
         * The unique Id of the Construct class.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public final @org.jetbrains.annotations.NotNull java.lang.String getConstructUniqueId() {
            return software.amazon.jsii.Kernel.get(this, "constructUniqueId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * The injector to be applied to the constructor properties of the Construct.
         * <p>
         * @param originalProps This parameter is required.
         * @param context This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public final @org.jetbrains.annotations.NotNull java.lang.Object inject(final @org.jetbrains.annotations.NotNull java.lang.Object originalProps, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.InjectionContext context) {
            return software.amazon.jsii.Kernel.call(this, "inject", software.amazon.jsii.NativeType.forClass(java.lang.Object.class), new Object[] { originalProps, java.util.Objects.requireNonNull(context, "context is required") });
        }
    }

    /**
     * Internal default implementation for {@link IPropertyInjector}.
     */
    @software.amazon.jsii.Internal
    interface Jsii$Default extends IPropertyInjector {

        /**
         * The unique Id of the Construct class.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.NotNull java.lang.String getConstructUniqueId() {
            return software.amazon.jsii.Kernel.get(this, "constructUniqueId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * The injector to be applied to the constructor properties of the Construct.
         * <p>
         * @param originalProps This parameter is required.
         * @param context This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        default @org.jetbrains.annotations.NotNull java.lang.Object inject(final @org.jetbrains.annotations.NotNull java.lang.Object originalProps, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.InjectionContext context) {
            return software.amazon.jsii.Kernel.call(this, "inject", software.amazon.jsii.NativeType.forClass(java.lang.Object.class), new Object[] { originalProps, java.util.Objects.requireNonNull(context, "context is required") });
        }
    }
}
