package software.amazon.awscdk.assertions;

/**
 * Allows assertions on the tags associated with a synthesized CDK stack's manifest.
 * <p>
 * Stack tags are not part of the synthesized template, so can only be
 * checked from the manifest in this manner.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Tags tags = Tags.fromStack(stack);
 * // using a default 'objectLike' Matcher
 * tags.hasValues(Map.of(
 *         "tag-name", "tag-value"));
 * // ... with Matchers embedded
 * tags.hasValues(Map.of(
 *         "tag-name", Match.stringLikeRegexp("value")));
 * // or another object Matcher at the top level
 * tags.hasValues(Match.objectEquals(Map.of(
 *         "tag-name", Match.anyValue())));
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-05-22T23:39:44.695Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.assertions.Tags")
public class Tags extends software.amazon.jsii.JsiiObject {

    protected Tags(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected Tags(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * Find tags associated with a synthesized CDK <code>Stack</code>.
     * <p>
     * @param stack the CDK Stack to find tags on. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.assertions.Tags fromStack(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.Stack stack) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.assertions.Tags.class, "fromStack", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.assertions.Tags.class), new Object[] { java.util.Objects.requireNonNull(stack, "stack is required") });
    }

    /**
     * Get the tags associated with the manifest.
     * <p>
     * This will be an empty object if
     * no tags were supplied.
     * <p>
     * @return The tags associated with the stack's synthesized manifest.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.String> all() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "all", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))));
    }

    /**
     * Assert that the there are no tags associated with the synthesized CDK Stack's manifest.
     * <p>
     * This is a convenience method over <code>hasValues(Match.exact({}))</code>, and is
     * present because the more obvious method of detecting no tags
     * (<code>Match.absent()</code>) will not work. Manifests default the tag set to an empty
     * object.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void hasNone() {
        software.amazon.jsii.Kernel.call(this, "hasNone", software.amazon.jsii.NativeType.VOID);
    }

    /**
     * Assert that the given Matcher or object matches the tags associated with the synthesized CDK Stack's manifest.
     * <p>
     * @param tags the expected set of tags. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void hasValues(final @org.jetbrains.annotations.NotNull java.lang.Object tags) {
        software.amazon.jsii.Kernel.call(this, "hasValues", software.amazon.jsii.NativeType.VOID, new Object[] { tags });
    }
}
