package software.amazon.awscdk.pipelines;

/**
 * Run a script as a CodeBuild Project.
 * <p>
 * The BuildSpec must be available inline--it cannot reference a file
 * on disk. If your current build instructions are in a file like
 * <code>buildspec.yml</code> in your repository, extract them to a script
 * (say, <code>build.sh</code>) and invoke that script as part of the build:
 * <p>
 * <blockquote><pre>
 * CodeBuildStep.Builder.create("Synth")
 *         .commands(List.of("./build.sh"))
 *         .build();
 * </pre></blockquote>
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * CodePipeline pipeline = CodePipeline.Builder.create(this, "Pipeline")
 *         .synth(ShellStep.Builder.create("Synth")
 *                 .input(CodePipelineSource.connection("my-org/my-app", "main", ConnectionSourceOptions.builder()
 *                         .connectionArn("arn:aws:codestar-connections:us-east-1:222222222222:connection/7d2469ff-514a-4e4f-9003-5ca4a43cdc41")
 *                         .build()))
 *                 .commands(List.of("npm ci", "npm run build", "npx cdk synth"))
 *                 .build())
 *         // Turn this on because the pipeline uses Docker image assets
 *         .dockerEnabledForSelfMutation(true)
 *         .build();
 * pipeline.addWave("MyWave", WaveOptions.builder()
 *         .post(List.of(
 *             CodeBuildStep.Builder.create("RunApproval")
 *                     .commands(List.of("command-from-image"))
 *                     .buildEnvironment(BuildEnvironment.builder()
 *                             // The user of a Docker image asset in the pipeline requires turning on
 *                             // 'dockerEnabledForSelfMutation'.
 *                             .buildImage(LinuxBuildImage.fromAsset(this, "Image", DockerImageAssetProps.builder()
 *                                     .directory("./docker-image")
 *                                     .build()))
 *                             .build())
 *                     .build()))
 *         .build());
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-05-22T23:40:01.101Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.pipelines.CodeBuildStep")
public class CodeBuildStep extends software.amazon.awscdk.pipelines.ShellStep {

    protected CodeBuildStep(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CodeBuildStep(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param id Identifier for this step. This parameter is required.
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CodeBuildStep(final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.pipelines.CodeBuildStepProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Reference a CodePipeline variable defined by the CodeBuildStep.
     * <p>
     * The variable must be set in the shell of the CodeBuild step when
     * it finishes its <code>post_build</code> phase.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // Access the output of one CodeBuildStep in another CodeBuildStep
     * CodePipeline pipeline;
     * CodeBuildStep step1 = CodeBuildStep.Builder.create("Step1")
     *         .commands(List.of("export MY_VAR=hello"))
     *         .build();
     * CodeBuildStep step2 = CodeBuildStep.Builder.create("Step2")
     *         .env(Map.of(
     *                 "IMPORTED_VAR", step1.exportedVariable("MY_VAR")))
     *         .commands(List.of("echo $IMPORTED_VAR"))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @param variableName the name of the variable for reference. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String exportedVariable(final @org.jetbrains.annotations.NotNull java.lang.String variableName) {
        return software.amazon.jsii.Kernel.call(this, "exportedVariable", software.amazon.jsii.NativeType.forClass(java.lang.String.class), new Object[] { java.util.Objects.requireNonNull(variableName, "variableName is required") });
    }

    /**
     * The CodeBuild Project's principal.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IPrincipal getGrantPrincipal() {
        return software.amazon.jsii.Kernel.get(this, "grantPrincipal", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.IPrincipal.class));
    }

    /**
     * CodeBuild Project generated for the pipeline.
     * <p>
     * Will only be available after the pipeline has been built.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codebuild.IProject getProject() {
        return software.amazon.jsii.Kernel.get(this, "project", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codebuild.IProject.class));
    }

    /**
     * Custom execution role to be used for the Code Build Action.
     * <p>
     * Default: - A role is automatically created
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.iam.IRole getActionRole() {
        return software.amazon.jsii.Kernel.get(this, "actionRole", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.IRole.class));
    }

    /**
     * Build environment.
     * <p>
     * Default: - No value specified at construction time, use defaults
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.codebuild.BuildEnvironment getBuildEnvironment() {
        return software.amazon.jsii.Kernel.get(this, "buildEnvironment", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codebuild.BuildEnvironment.class));
    }

    /**
     * Caching strategy to use.
     * <p>
     * Default: - No cache
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.codebuild.Cache getCache() {
        return software.amazon.jsii.Kernel.get(this, "cache", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codebuild.Cache.class));
    }

    /**
     * ProjectFileSystemLocation objects for CodeBuild build projects.
     * <p>
     * A ProjectFileSystemLocation object specifies the identifier, location, mountOptions, mountPoint,
     * and type of a file system created using Amazon Elastic File System.
     * <p>
     * Default: - no file system locations
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.services.codebuild.IFileSystemLocation> getFileSystemLocations() {
        return java.util.Optional.ofNullable((java.util.List<software.amazon.awscdk.services.codebuild.IFileSystemLocation>)(software.amazon.jsii.Kernel.get(this, "fileSystemLocations", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codebuild.IFileSystemLocation.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     * Information about logs for CodeBuild projects.
     * <p>
     * A CodeBuilde project can create logs in Amazon CloudWatch Logs, an S3 bucket, or both.
     * <p>
     * Default: - no log configuration is set
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.codebuild.LoggingOptions getLogging() {
        return software.amazon.jsii.Kernel.get(this, "logging", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codebuild.LoggingOptions.class));
    }

    /**
     * Additional configuration that can only be configured via BuildSpec.
     * <p>
     * Contains exported variables
     * <p>
     * Default: - Contains the exported variables
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.codebuild.BuildSpec getPartialBuildSpec() {
        return software.amazon.jsii.Kernel.get(this, "partialBuildSpec", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codebuild.BuildSpec.class));
    }

    /**
     * Name for the generated CodeBuild project.
     * <p>
     * Default: - No value specified at construction time, use defaults
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getProjectName() {
        return software.amazon.jsii.Kernel.get(this, "projectName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Custom execution role to be used for the CodeBuild project.
     * <p>
     * Default: - No value specified at construction time, use defaults
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.iam.IRole getRole() {
        return software.amazon.jsii.Kernel.get(this, "role", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.IRole.class));
    }

    /**
     * Policy statements to add to role used during the synth.
     * <p>
     * Default: - No value specified at construction time, use defaults
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.services.iam.PolicyStatement> getRolePolicyStatements() {
        return java.util.Optional.ofNullable((java.util.List<software.amazon.awscdk.services.iam.PolicyStatement>)(software.amazon.jsii.Kernel.get(this, "rolePolicyStatements", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.PolicyStatement.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     * Which security group to associate with the script's project network interfaces.
     * <p>
     * Default: - No value specified at construction time, use defaults
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.services.ec2.ISecurityGroup> getSecurityGroups() {
        return java.util.Optional.ofNullable((java.util.List<software.amazon.awscdk.services.ec2.ISecurityGroup>)(software.amazon.jsii.Kernel.get(this, "securityGroups", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.ISecurityGroup.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     * Which subnets to use.
     * <p>
     * Default: - No value specified at construction time, use defaults
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ec2.SubnetSelection getSubnetSelection() {
        return software.amazon.jsii.Kernel.get(this, "subnetSelection", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.SubnetSelection.class));
    }

    /**
     * The number of minutes after which AWS CodeBuild stops the build if it's not complete.
     * <p>
     * For valid values, see the timeoutInMinutes field in the AWS
     * CodeBuild User Guide.
     * <p>
     * Default: Duration.hours(1)
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable software.amazon.awscdk.Duration getTimeout() {
        return software.amazon.jsii.Kernel.get(this, "timeout", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.Duration.class));
    }

    /**
     * The VPC where to execute the SimpleSynth.
     * <p>
     * Default: - No value specified at construction time, use defaults
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ec2.IVpc getVpc() {
        return software.amazon.jsii.Kernel.get(this, "vpc", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.IVpc.class));
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.pipelines.CodeBuildStep}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.pipelines.CodeBuildStep> {
        /**
         * @return a new instance of {@link Builder}.
         * @param id Identifier for this step. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final java.lang.String id) {
            return new Builder(id);
        }

        private final java.lang.String id;
        private final software.amazon.awscdk.pipelines.CodeBuildStepProps.Builder props;

        private Builder(final java.lang.String id) {
            this.id = id;
            this.props = new software.amazon.awscdk.pipelines.CodeBuildStepProps.Builder();
        }

        /**
         * Commands to run.
         * <p>
         * @return {@code this}
         * @param commands Commands to run. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder commands(final java.util.List<java.lang.String> commands) {
            this.props.commands(commands);
            return this;
        }

        /**
         * Additional FileSets to put in other directories.
         * <p>
         * Specifies a mapping from directory name to FileSets. During the
         * script execution, the FileSets will be available in the directories
         * indicated.
         * <p>
         * The directory names may be relative. For example, you can put
         * the main input and an additional input side-by-side with the
         * following configuration:
         * <p>
         * <blockquote><pre>
         * ShellStep script = ShellStep.Builder.create("MainScript")
         *         .commands(List.of("npm ci", "npm run build", "npx cdk synth"))
         *         .input(CodePipelineSource.gitHub("org/source1", "main"))
         *         .additionalInputs(Map.of(
         *                 "../siblingdir", CodePipelineSource.gitHub("org/source2", "main")))
         *         .build();
         * </pre></blockquote>
         * <p>
         * Default: - No additional inputs
         * <p>
         * @return {@code this}
         * @param additionalInputs Additional FileSets to put in other directories. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder additionalInputs(final java.util.Map<java.lang.String, ? extends software.amazon.awscdk.pipelines.IFileSetProducer> additionalInputs) {
            this.props.additionalInputs(additionalInputs);
            return this;
        }

        /**
         * Environment variables to set.
         * <p>
         * Default: - No environment variables
         * <p>
         * @return {@code this}
         * @param env Environment variables to set. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder env(final java.util.Map<java.lang.String, java.lang.String> env) {
            this.props.env(env);
            return this;
        }

        /**
         * Set environment variables based on Stack Outputs.
         * <p>
         * <code>ShellStep</code>s following stack or stage deployments may
         * access the <code>CfnOutput</code>s of those stacks to get access to
         * --for example--automatically generated resource names or
         * endpoint URLs.
         * <p>
         * Default: - No environment variables created from stack outputs
         * <p>
         * @return {@code this}
         * @param envFromCfnOutputs Set environment variables based on Stack Outputs. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder envFromCfnOutputs(final java.util.Map<java.lang.String, ? extends software.amazon.awscdk.CfnOutput> envFromCfnOutputs) {
            this.props.envFromCfnOutputs(envFromCfnOutputs);
            return this;
        }

        /**
         * FileSet to run these scripts on.
         * <p>
         * The files in the FileSet will be placed in the working directory when
         * the script is executed. Use <code>additionalInputs</code> to download file sets
         * to other directories as well.
         * <p>
         * Default: - No input specified
         * <p>
         * @return {@code this}
         * @param input FileSet to run these scripts on. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder input(final software.amazon.awscdk.pipelines.IFileSetProducer input) {
            this.props.input(input);
            return this;
        }

        /**
         * Installation commands to run before the regular commands.
         * <p>
         * For deployment engines that support it, install commands will be classified
         * differently in the job history from the regular <code>commands</code>.
         * <p>
         * Default: - No installation commands
         * <p>
         * @return {@code this}
         * @param installCommands Installation commands to run before the regular commands. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder installCommands(final java.util.List<java.lang.String> installCommands) {
            this.props.installCommands(installCommands);
            return this;
        }

        /**
         * The directory that will contain the primary output fileset.
         * <p>
         * After running the script, the contents of the given directory
         * will be treated as the primary output of this Step.
         * <p>
         * Default: - No primary output
         * <p>
         * @return {@code this}
         * @param primaryOutputDirectory The directory that will contain the primary output fileset. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder primaryOutputDirectory(final java.lang.String primaryOutputDirectory) {
            this.props.primaryOutputDirectory(primaryOutputDirectory);
            return this;
        }

        /**
         * Custom execution role to be used for the Code Build Action.
         * <p>
         * Default: - A role is automatically created
         * <p>
         * @return {@code this}
         * @param actionRole Custom execution role to be used for the Code Build Action. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder actionRole(final software.amazon.awscdk.services.iam.IRole actionRole) {
            this.props.actionRole(actionRole);
            return this;
        }

        /**
         * Changes to environment.
         * <p>
         * This environment will be combined with the pipeline's default
         * environment.
         * <p>
         * Default: - Use the pipeline's default build environment
         * <p>
         * @return {@code this}
         * @param buildEnvironment Changes to environment. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder buildEnvironment(final software.amazon.awscdk.services.codebuild.BuildEnvironment buildEnvironment) {
            this.props.buildEnvironment(buildEnvironment);
            return this;
        }

        /**
         * Caching strategy to use.
         * <p>
         * Default: - No cache
         * <p>
         * @return {@code this}
         * @param cache Caching strategy to use. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cache(final software.amazon.awscdk.services.codebuild.Cache cache) {
            this.props.cache(cache);
            return this;
        }

        /**
         * ProjectFileSystemLocation objects for CodeBuild build projects.
         * <p>
         * A ProjectFileSystemLocation object specifies the identifier, location, mountOptions, mountPoint,
         * and type of a file system created using Amazon Elastic File System.
         * <p>
         * Default: - no file system locations
         * <p>
         * @return {@code this}
         * @param fileSystemLocations ProjectFileSystemLocation objects for CodeBuild build projects. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder fileSystemLocations(final java.util.List<? extends software.amazon.awscdk.services.codebuild.IFileSystemLocation> fileSystemLocations) {
            this.props.fileSystemLocations(fileSystemLocations);
            return this;
        }

        /**
         * Information about logs for CodeBuild projects.
         * <p>
         * A CodeBuild project can create logs in Amazon CloudWatch Logs, an S3 bucket, or both.
         * <p>
         * Default: - no log configuration is set
         * <p>
         * @return {@code this}
         * @param logging Information about logs for CodeBuild projects. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder logging(final software.amazon.awscdk.services.codebuild.LoggingOptions logging) {
            this.props.logging(logging);
            return this;
        }

        /**
         * Additional configuration that can only be configured via BuildSpec.
         * <p>
         * You should not use this to specify output artifacts; those
         * should be supplied via the other properties of this class, otherwise
         * CDK Pipelines won't be able to inspect the artifacts.
         * <p>
         * Set the <code>commands</code> to an empty array if you want to fully specify
         * the BuildSpec using this field.
         * <p>
         * The BuildSpec must be available inline--it cannot reference a file
         * on disk.
         * <p>
         * Default: - BuildSpec completely derived from other properties
         * <p>
         * @return {@code this}
         * @param partialBuildSpec Additional configuration that can only be configured via BuildSpec. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder partialBuildSpec(final software.amazon.awscdk.services.codebuild.BuildSpec partialBuildSpec) {
            this.props.partialBuildSpec(partialBuildSpec);
            return this;
        }

        /**
         * Name for the generated CodeBuild project.
         * <p>
         * Default: - Automatically generated
         * <p>
         * @return {@code this}
         * @param projectName Name for the generated CodeBuild project. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder projectName(final java.lang.String projectName) {
            this.props.projectName(projectName);
            return this;
        }

        /**
         * Custom execution role to be used for the CodeBuild project.
         * <p>
         * Default: - A role is automatically created
         * <p>
         * @return {@code this}
         * @param role Custom execution role to be used for the CodeBuild project. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder role(final software.amazon.awscdk.services.iam.IRole role) {
            this.props.role(role);
            return this;
        }

        /**
         * Policy statements to add to role used during the synth.
         * <p>
         * Can be used to add acces to a CodeArtifact repository etc.
         * <p>
         * Default: - No policy statements added to CodeBuild Project Role
         * <p>
         * @return {@code this}
         * @param rolePolicyStatements Policy statements to add to role used during the synth. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder rolePolicyStatements(final java.util.List<? extends software.amazon.awscdk.services.iam.PolicyStatement> rolePolicyStatements) {
            this.props.rolePolicyStatements(rolePolicyStatements);
            return this;
        }

        /**
         * Which security group to associate with the script's project network interfaces.
         * <p>
         * If no security group is identified, one will be created automatically.
         * <p>
         * Only used if 'vpc' is supplied.
         * <p>
         * Default: - Security group will be automatically created.
         * <p>
         * @return {@code this}
         * @param securityGroups Which security group to associate with the script's project network interfaces. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder securityGroups(final java.util.List<? extends software.amazon.awscdk.services.ec2.ISecurityGroup> securityGroups) {
            this.props.securityGroups(securityGroups);
            return this;
        }

        /**
         * Which subnets to use.
         * <p>
         * Only used if 'vpc' is supplied.
         * <p>
         * Default: - All private subnets.
         * <p>
         * @return {@code this}
         * @param subnetSelection Which subnets to use. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder subnetSelection(final software.amazon.awscdk.services.ec2.SubnetSelection subnetSelection) {
            this.props.subnetSelection(subnetSelection);
            return this;
        }

        /**
         * The number of minutes after which AWS CodeBuild stops the build if it's not complete.
         * <p>
         * For valid values, see the timeoutInMinutes field in the AWS
         * CodeBuild User Guide.
         * <p>
         * Default: Duration.hours(1)
         * <p>
         * @return {@code this}
         * @param timeout The number of minutes after which AWS CodeBuild stops the build if it's not complete. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder timeout(final software.amazon.awscdk.Duration timeout) {
            this.props.timeout(timeout);
            return this;
        }

        /**
         * The VPC where to execute the SimpleSynth.
         * <p>
         * Default: - No VPC
         * <p>
         * @return {@code this}
         * @param vpc The VPC where to execute the SimpleSynth. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder vpc(final software.amazon.awscdk.services.ec2.IVpc vpc) {
            this.props.vpc(vpc);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.pipelines.CodeBuildStep}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.pipelines.CodeBuildStep build() {
            return new software.amazon.awscdk.pipelines.CodeBuildStep(
                this.id,
                this.props.build()
            );
        }
    }
}
