package software.amazon.awscdk.services.acmpca;

/**
 * Properties for defining a <code>CfnCertificateAuthority</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * CfnCertificateAuthority cfnCertificateAuthority = CfnCertificateAuthority.Builder.create(this, "CA")
 *         .type("ROOT")
 *         .keyAlgorithm("RSA_2048")
 *         .signingAlgorithm("SHA256WITHRSA")
 *         .subject(SubjectProperty.builder()
 *                 .country("US")
 *                 .organization("string")
 *                 .organizationalUnit("string")
 *                 .distinguishedNameQualifier("string")
 *                 .state("string")
 *                 .commonName("123")
 *                 .serialNumber("string")
 *                 .locality("string")
 *                 .title("string")
 *                 .surname("string")
 *                 .givenName("string")
 *                 .initials("DG")
 *                 .pseudonym("string")
 *                 .generationQualifier("DBG")
 *                 .build())
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-acmpca-certificateauthority.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-acmpca-certificateauthority.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-05-22T23:39:44.740Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_acmpca.CfnCertificateAuthorityProps")
@software.amazon.jsii.Jsii.Proxy(CfnCertificateAuthorityProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnCertificateAuthorityProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * Type of the public key algorithm and size, in bits, of the key pair that your CA creates when it issues a certificate.
     * <p>
     * When you create a subordinate CA, you must use a key algorithm supported by the parent CA.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-acmpca-certificateauthority.html#cfn-acmpca-certificateauthority-keyalgorithm">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-acmpca-certificateauthority.html#cfn-acmpca-certificateauthority-keyalgorithm</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getKeyAlgorithm();

    /**
     * Name of the algorithm your private CA uses to sign certificate requests.
     * <p>
     * This parameter should not be confused with the <code>SigningAlgorithm</code> parameter used to sign certificates when they are issued.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-acmpca-certificateauthority.html#cfn-acmpca-certificateauthority-signingalgorithm">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-acmpca-certificateauthority.html#cfn-acmpca-certificateauthority-signingalgorithm</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getSigningAlgorithm();

    /**
     * Structure that contains X.500 distinguished name information for your private CA.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-acmpca-certificateauthority.html#cfn-acmpca-certificateauthority-subject">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-acmpca-certificateauthority.html#cfn-acmpca-certificateauthority-subject</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Object getSubject();

    /**
     * Type of your private CA.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-acmpca-certificateauthority.html#cfn-acmpca-certificateauthority-type">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-acmpca-certificateauthority.html#cfn-acmpca-certificateauthority-type</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getType();

    /**
     * Specifies information to be added to the extension section of the certificate signing request (CSR).
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-acmpca-certificateauthority.html#cfn-acmpca-certificateauthority-csrextensions">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-acmpca-certificateauthority.html#cfn-acmpca-certificateauthority-csrextensions</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getCsrExtensions() {
        return null;
    }

    /**
     * Specifies a cryptographic key management compliance standard for handling and protecting CA keys.
     * <p>
     * Default: FIPS_140_2_LEVEL_3_OR_HIGHER
     * <p>
     * <blockquote>
     * <p>
     * Some AWS Regions don't support the default value. When you create a CA in these Regions, you must use <code>CCPC_LEVEL_1_OR_HIGHER</code> for the <code>KeyStorageSecurityStandard</code> parameter. If you don't, the operation returns an <code>InvalidArgsException</code> with this message: "A certificate authority cannot be created in this region with the specified security standard."
     * <p>
     * For information about security standard support in different AWS Regions, see <a href="https://docs.aws.amazon.com/privateca/latest/userguide/data-protection.html#private-keys">Storage and security compliance of AWS Private CA private keys</a> .
     * <p>
     * </blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-acmpca-certificateauthority.html#cfn-acmpca-certificateauthority-keystoragesecuritystandard">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-acmpca-certificateauthority.html#cfn-acmpca-certificateauthority-keystoragesecuritystandard</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getKeyStorageSecurityStandard() {
        return null;
    }

    /**
     * Information about the Online Certificate Status Protocol (OCSP) configuration or certificate revocation list (CRL) created and maintained by your private CA.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-acmpca-certificateauthority.html#cfn-acmpca-certificateauthority-revocationconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-acmpca-certificateauthority.html#cfn-acmpca-certificateauthority-revocationconfiguration</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getRevocationConfiguration() {
        return null;
    }

    /**
     * Key-value pairs that will be attached to the new private CA.
     * <p>
     * You can associate up to 50 tags with a private CA. For information using tags with IAM to manage permissions, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_iam-tags.html">Controlling Access Using IAM Tags</a> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-acmpca-certificateauthority.html#cfn-acmpca-certificateauthority-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-acmpca-certificateauthority.html#cfn-acmpca-certificateauthority-tags</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTags() {
        return null;
    }

    /**
     * Specifies whether the CA issues general-purpose certificates that typically require a revocation mechanism, or short-lived certificates that may optionally omit revocation because they expire quickly.
     * <p>
     * Short-lived certificate validity is limited to seven days.
     * <p>
     * The default value is GENERAL_PURPOSE.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-acmpca-certificateauthority.html#cfn-acmpca-certificateauthority-usagemode">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-acmpca-certificateauthority.html#cfn-acmpca-certificateauthority-usagemode</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getUsageMode() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnCertificateAuthorityProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnCertificateAuthorityProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnCertificateAuthorityProps> {
        java.lang.String keyAlgorithm;
        java.lang.String signingAlgorithm;
        java.lang.Object subject;
        java.lang.String type;
        java.lang.Object csrExtensions;
        java.lang.String keyStorageSecurityStandard;
        java.lang.Object revocationConfiguration;
        java.util.List<software.amazon.awscdk.CfnTag> tags;
        java.lang.String usageMode;

        /**
         * Sets the value of {@link CfnCertificateAuthorityProps#getKeyAlgorithm}
         * @param keyAlgorithm Type of the public key algorithm and size, in bits, of the key pair that your CA creates when it issues a certificate. This parameter is required.
         *                     When you create a subordinate CA, you must use a key algorithm supported by the parent CA.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder keyAlgorithm(java.lang.String keyAlgorithm) {
            this.keyAlgorithm = keyAlgorithm;
            return this;
        }

        /**
         * Sets the value of {@link CfnCertificateAuthorityProps#getSigningAlgorithm}
         * @param signingAlgorithm Name of the algorithm your private CA uses to sign certificate requests. This parameter is required.
         *                         This parameter should not be confused with the <code>SigningAlgorithm</code> parameter used to sign certificates when they are issued.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder signingAlgorithm(java.lang.String signingAlgorithm) {
            this.signingAlgorithm = signingAlgorithm;
            return this;
        }

        /**
         * Sets the value of {@link CfnCertificateAuthorityProps#getSubject}
         * @param subject Structure that contains X.500 distinguished name information for your private CA. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder subject(software.amazon.awscdk.IResolvable subject) {
            this.subject = subject;
            return this;
        }

        /**
         * Sets the value of {@link CfnCertificateAuthorityProps#getSubject}
         * @param subject Structure that contains X.500 distinguished name information for your private CA. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder subject(software.amazon.awscdk.services.acmpca.CfnCertificateAuthority.SubjectProperty subject) {
            this.subject = subject;
            return this;
        }

        /**
         * Sets the value of {@link CfnCertificateAuthorityProps#getType}
         * @param type Type of your private CA. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder type(java.lang.String type) {
            this.type = type;
            return this;
        }

        /**
         * Sets the value of {@link CfnCertificateAuthorityProps#getCsrExtensions}
         * @param csrExtensions Specifies information to be added to the extension section of the certificate signing request (CSR).
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder csrExtensions(software.amazon.awscdk.IResolvable csrExtensions) {
            this.csrExtensions = csrExtensions;
            return this;
        }

        /**
         * Sets the value of {@link CfnCertificateAuthorityProps#getCsrExtensions}
         * @param csrExtensions Specifies information to be added to the extension section of the certificate signing request (CSR).
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder csrExtensions(software.amazon.awscdk.services.acmpca.CfnCertificateAuthority.CsrExtensionsProperty csrExtensions) {
            this.csrExtensions = csrExtensions;
            return this;
        }

        /**
         * Sets the value of {@link CfnCertificateAuthorityProps#getKeyStorageSecurityStandard}
         * @param keyStorageSecurityStandard Specifies a cryptographic key management compliance standard for handling and protecting CA keys.
         *                                   Default: FIPS_140_2_LEVEL_3_OR_HIGHER
         *                                   <p>
         *                                   <blockquote>
         *                                   <p>
         *                                   Some AWS Regions don't support the default value. When you create a CA in these Regions, you must use <code>CCPC_LEVEL_1_OR_HIGHER</code> for the <code>KeyStorageSecurityStandard</code> parameter. If you don't, the operation returns an <code>InvalidArgsException</code> with this message: "A certificate authority cannot be created in this region with the specified security standard."
         *                                   <p>
         *                                   For information about security standard support in different AWS Regions, see <a href="https://docs.aws.amazon.com/privateca/latest/userguide/data-protection.html#private-keys">Storage and security compliance of AWS Private CA private keys</a> .
         *                                   <p>
         *                                   </blockquote>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder keyStorageSecurityStandard(java.lang.String keyStorageSecurityStandard) {
            this.keyStorageSecurityStandard = keyStorageSecurityStandard;
            return this;
        }

        /**
         * Sets the value of {@link CfnCertificateAuthorityProps#getRevocationConfiguration}
         * @param revocationConfiguration Information about the Online Certificate Status Protocol (OCSP) configuration or certificate revocation list (CRL) created and maintained by your private CA.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder revocationConfiguration(software.amazon.awscdk.IResolvable revocationConfiguration) {
            this.revocationConfiguration = revocationConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnCertificateAuthorityProps#getRevocationConfiguration}
         * @param revocationConfiguration Information about the Online Certificate Status Protocol (OCSP) configuration or certificate revocation list (CRL) created and maintained by your private CA.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder revocationConfiguration(software.amazon.awscdk.services.acmpca.CfnCertificateAuthority.RevocationConfigurationProperty revocationConfiguration) {
            this.revocationConfiguration = revocationConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnCertificateAuthorityProps#getTags}
         * @param tags Key-value pairs that will be attached to the new private CA.
         *             You can associate up to 50 tags with a private CA. For information using tags with IAM to manage permissions, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_iam-tags.html">Controlling Access Using IAM Tags</a> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder tags(java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)tags;
            return this;
        }

        /**
         * Sets the value of {@link CfnCertificateAuthorityProps#getUsageMode}
         * @param usageMode Specifies whether the CA issues general-purpose certificates that typically require a revocation mechanism, or short-lived certificates that may optionally omit revocation because they expire quickly.
         *                  Short-lived certificate validity is limited to seven days.
         *                  <p>
         *                  The default value is GENERAL_PURPOSE.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder usageMode(java.lang.String usageMode) {
            this.usageMode = usageMode;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnCertificateAuthorityProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnCertificateAuthorityProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnCertificateAuthorityProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnCertificateAuthorityProps {
        private final java.lang.String keyAlgorithm;
        private final java.lang.String signingAlgorithm;
        private final java.lang.Object subject;
        private final java.lang.String type;
        private final java.lang.Object csrExtensions;
        private final java.lang.String keyStorageSecurityStandard;
        private final java.lang.Object revocationConfiguration;
        private final java.util.List<software.amazon.awscdk.CfnTag> tags;
        private final java.lang.String usageMode;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.keyAlgorithm = software.amazon.jsii.Kernel.get(this, "keyAlgorithm", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.signingAlgorithm = software.amazon.jsii.Kernel.get(this, "signingAlgorithm", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.subject = software.amazon.jsii.Kernel.get(this, "subject", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.type = software.amazon.jsii.Kernel.get(this, "type", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.csrExtensions = software.amazon.jsii.Kernel.get(this, "csrExtensions", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.keyStorageSecurityStandard = software.amazon.jsii.Kernel.get(this, "keyStorageSecurityStandard", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.revocationConfiguration = software.amazon.jsii.Kernel.get(this, "revocationConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class)));
            this.usageMode = software.amazon.jsii.Kernel.get(this, "usageMode", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.keyAlgorithm = java.util.Objects.requireNonNull(builder.keyAlgorithm, "keyAlgorithm is required");
            this.signingAlgorithm = java.util.Objects.requireNonNull(builder.signingAlgorithm, "signingAlgorithm is required");
            this.subject = java.util.Objects.requireNonNull(builder.subject, "subject is required");
            this.type = java.util.Objects.requireNonNull(builder.type, "type is required");
            this.csrExtensions = builder.csrExtensions;
            this.keyStorageSecurityStandard = builder.keyStorageSecurityStandard;
            this.revocationConfiguration = builder.revocationConfiguration;
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)builder.tags;
            this.usageMode = builder.usageMode;
        }

        @Override
        public final java.lang.String getKeyAlgorithm() {
            return this.keyAlgorithm;
        }

        @Override
        public final java.lang.String getSigningAlgorithm() {
            return this.signingAlgorithm;
        }

        @Override
        public final java.lang.Object getSubject() {
            return this.subject;
        }

        @Override
        public final java.lang.String getType() {
            return this.type;
        }

        @Override
        public final java.lang.Object getCsrExtensions() {
            return this.csrExtensions;
        }

        @Override
        public final java.lang.String getKeyStorageSecurityStandard() {
            return this.keyStorageSecurityStandard;
        }

        @Override
        public final java.lang.Object getRevocationConfiguration() {
            return this.revocationConfiguration;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.CfnTag> getTags() {
            return this.tags;
        }

        @Override
        public final java.lang.String getUsageMode() {
            return this.usageMode;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("keyAlgorithm", om.valueToTree(this.getKeyAlgorithm()));
            data.set("signingAlgorithm", om.valueToTree(this.getSigningAlgorithm()));
            data.set("subject", om.valueToTree(this.getSubject()));
            data.set("type", om.valueToTree(this.getType()));
            if (this.getCsrExtensions() != null) {
                data.set("csrExtensions", om.valueToTree(this.getCsrExtensions()));
            }
            if (this.getKeyStorageSecurityStandard() != null) {
                data.set("keyStorageSecurityStandard", om.valueToTree(this.getKeyStorageSecurityStandard()));
            }
            if (this.getRevocationConfiguration() != null) {
                data.set("revocationConfiguration", om.valueToTree(this.getRevocationConfiguration()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }
            if (this.getUsageMode() != null) {
                data.set("usageMode", om.valueToTree(this.getUsageMode()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_acmpca.CfnCertificateAuthorityProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnCertificateAuthorityProps.Jsii$Proxy that = (CfnCertificateAuthorityProps.Jsii$Proxy) o;

            if (!keyAlgorithm.equals(that.keyAlgorithm)) return false;
            if (!signingAlgorithm.equals(that.signingAlgorithm)) return false;
            if (!subject.equals(that.subject)) return false;
            if (!type.equals(that.type)) return false;
            if (this.csrExtensions != null ? !this.csrExtensions.equals(that.csrExtensions) : that.csrExtensions != null) return false;
            if (this.keyStorageSecurityStandard != null ? !this.keyStorageSecurityStandard.equals(that.keyStorageSecurityStandard) : that.keyStorageSecurityStandard != null) return false;
            if (this.revocationConfiguration != null ? !this.revocationConfiguration.equals(that.revocationConfiguration) : that.revocationConfiguration != null) return false;
            if (this.tags != null ? !this.tags.equals(that.tags) : that.tags != null) return false;
            return this.usageMode != null ? this.usageMode.equals(that.usageMode) : that.usageMode == null;
        }

        @Override
        public final int hashCode() {
            int result = this.keyAlgorithm.hashCode();
            result = 31 * result + (this.signingAlgorithm.hashCode());
            result = 31 * result + (this.subject.hashCode());
            result = 31 * result + (this.type.hashCode());
            result = 31 * result + (this.csrExtensions != null ? this.csrExtensions.hashCode() : 0);
            result = 31 * result + (this.keyStorageSecurityStandard != null ? this.keyStorageSecurityStandard.hashCode() : 0);
            result = 31 * result + (this.revocationConfiguration != null ? this.revocationConfiguration.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            result = 31 * result + (this.usageMode != null ? this.usageMode.hashCode() : 0);
            return result;
        }
    }
}
