package software.amazon.awscdk.services.apigatewayv2;

/**
 * Properties for defining a <code>CfnStage</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.apigatewayv2.*;
 * Object routeSettings;
 * Object stageVariables;
 * Object tags;
 * CfnStageProps cfnStageProps = CfnStageProps.builder()
 *         .apiId("apiId")
 *         .stageName("stageName")
 *         // the properties below are optional
 *         .accessLogSettings(AccessLogSettingsProperty.builder()
 *                 .destinationArn("destinationArn")
 *                 .format("format")
 *                 .build())
 *         .accessPolicyId("accessPolicyId")
 *         .autoDeploy(false)
 *         .clientCertificateId("clientCertificateId")
 *         .defaultRouteSettings(RouteSettingsProperty.builder()
 *                 .dataTraceEnabled(false)
 *                 .detailedMetricsEnabled(false)
 *                 .loggingLevel("loggingLevel")
 *                 .throttlingBurstLimit(123)
 *                 .throttlingRateLimit(123)
 *                 .build())
 *         .deploymentId("deploymentId")
 *         .description("description")
 *         .routeSettings(routeSettings)
 *         .stageVariables(stageVariables)
 *         .tags(tags)
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-stage.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-stage.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-05-22T23:39:45.178Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_apigatewayv2.CfnStageProps")
@software.amazon.jsii.Jsii.Proxy(CfnStageProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnStageProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The API identifier.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-stage.html#cfn-apigatewayv2-stage-apiid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-stage.html#cfn-apigatewayv2-stage-apiid</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getApiId();

    /**
     * The stage name.
     * <p>
     * Stage names can contain only alphanumeric characters, hyphens, and underscores, or be <code>$default</code> . Maximum length is 128 characters.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-stage.html#cfn-apigatewayv2-stage-stagename">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-stage.html#cfn-apigatewayv2-stage-stagename</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getStageName();

    /**
     * Settings for logging access in this stage.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-stage.html#cfn-apigatewayv2-stage-accesslogsettings">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-stage.html#cfn-apigatewayv2-stage-accesslogsettings</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getAccessLogSettings() {
        return null;
    }

    /**
     * This parameter is not currently supported.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-stage.html#cfn-apigatewayv2-stage-accesspolicyid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-stage.html#cfn-apigatewayv2-stage-accesspolicyid</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getAccessPolicyId() {
        return null;
    }

    /**
     * Specifies whether updates to an API automatically trigger a new deployment.
     * <p>
     * The default value is <code>false</code> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-stage.html#cfn-apigatewayv2-stage-autodeploy">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-stage.html#cfn-apigatewayv2-stage-autodeploy</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getAutoDeploy() {
        return null;
    }

    /**
     * The identifier of a client certificate for a <code>Stage</code> .
     * <p>
     * Supported only for WebSocket APIs.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-stage.html#cfn-apigatewayv2-stage-clientcertificateid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-stage.html#cfn-apigatewayv2-stage-clientcertificateid</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getClientCertificateId() {
        return null;
    }

    /**
     * The default route settings for the stage.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-stage.html#cfn-apigatewayv2-stage-defaultroutesettings">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-stage.html#cfn-apigatewayv2-stage-defaultroutesettings</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getDefaultRouteSettings() {
        return null;
    }

    /**
     * The deployment identifier for the API stage.
     * <p>
     * Can't be updated if <code>autoDeploy</code> is enabled.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-stage.html#cfn-apigatewayv2-stage-deploymentid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-stage.html#cfn-apigatewayv2-stage-deploymentid</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDeploymentId() {
        return null;
    }

    /**
     * The description for the API stage.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-stage.html#cfn-apigatewayv2-stage-description">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-stage.html#cfn-apigatewayv2-stage-description</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
        return null;
    }

    /**
     * Route settings for the stage.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-stage.html#cfn-apigatewayv2-stage-routesettings">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-stage.html#cfn-apigatewayv2-stage-routesettings</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getRouteSettings() {
        return null;
    }

    /**
     * A map that defines the stage variables for a <code>Stage</code> .
     * <p>
     * Variable names can have alphanumeric and underscore characters, and the values must match [A-Za-z0-9-._~:/?#&amp;=,]+.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-stage.html#cfn-apigatewayv2-stage-stagevariables">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-stage.html#cfn-apigatewayv2-stage-stagevariables</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getStageVariables() {
        return null;
    }

    /**
     * The collection of tags.
     * <p>
     * Each tag element is associated with a given resource.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-stage.html#cfn-apigatewayv2-stage-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-stage.html#cfn-apigatewayv2-stage-tags</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getTags() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnStageProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnStageProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnStageProps> {
        java.lang.String apiId;
        java.lang.String stageName;
        java.lang.Object accessLogSettings;
        java.lang.String accessPolicyId;
        java.lang.Object autoDeploy;
        java.lang.String clientCertificateId;
        java.lang.Object defaultRouteSettings;
        java.lang.String deploymentId;
        java.lang.String description;
        java.lang.Object routeSettings;
        java.lang.Object stageVariables;
        java.lang.Object tags;

        /**
         * Sets the value of {@link CfnStageProps#getApiId}
         * @param apiId The API identifier. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder apiId(java.lang.String apiId) {
            this.apiId = apiId;
            return this;
        }

        /**
         * Sets the value of {@link CfnStageProps#getStageName}
         * @param stageName The stage name. This parameter is required.
         *                  Stage names can contain only alphanumeric characters, hyphens, and underscores, or be <code>$default</code> . Maximum length is 128 characters.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder stageName(java.lang.String stageName) {
            this.stageName = stageName;
            return this;
        }

        /**
         * Sets the value of {@link CfnStageProps#getAccessLogSettings}
         * @param accessLogSettings Settings for logging access in this stage.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder accessLogSettings(software.amazon.awscdk.IResolvable accessLogSettings) {
            this.accessLogSettings = accessLogSettings;
            return this;
        }

        /**
         * Sets the value of {@link CfnStageProps#getAccessLogSettings}
         * @param accessLogSettings Settings for logging access in this stage.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder accessLogSettings(software.amazon.awscdk.services.apigatewayv2.CfnStage.AccessLogSettingsProperty accessLogSettings) {
            this.accessLogSettings = accessLogSettings;
            return this;
        }

        /**
         * Sets the value of {@link CfnStageProps#getAccessPolicyId}
         * @param accessPolicyId This parameter is not currently supported.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder accessPolicyId(java.lang.String accessPolicyId) {
            this.accessPolicyId = accessPolicyId;
            return this;
        }

        /**
         * Sets the value of {@link CfnStageProps#getAutoDeploy}
         * @param autoDeploy Specifies whether updates to an API automatically trigger a new deployment.
         *                   The default value is <code>false</code> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder autoDeploy(java.lang.Boolean autoDeploy) {
            this.autoDeploy = autoDeploy;
            return this;
        }

        /**
         * Sets the value of {@link CfnStageProps#getAutoDeploy}
         * @param autoDeploy Specifies whether updates to an API automatically trigger a new deployment.
         *                   The default value is <code>false</code> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder autoDeploy(software.amazon.awscdk.IResolvable autoDeploy) {
            this.autoDeploy = autoDeploy;
            return this;
        }

        /**
         * Sets the value of {@link CfnStageProps#getClientCertificateId}
         * @param clientCertificateId The identifier of a client certificate for a <code>Stage</code> .
         *                            Supported only for WebSocket APIs.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder clientCertificateId(java.lang.String clientCertificateId) {
            this.clientCertificateId = clientCertificateId;
            return this;
        }

        /**
         * Sets the value of {@link CfnStageProps#getDefaultRouteSettings}
         * @param defaultRouteSettings The default route settings for the stage.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder defaultRouteSettings(software.amazon.awscdk.IResolvable defaultRouteSettings) {
            this.defaultRouteSettings = defaultRouteSettings;
            return this;
        }

        /**
         * Sets the value of {@link CfnStageProps#getDefaultRouteSettings}
         * @param defaultRouteSettings The default route settings for the stage.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder defaultRouteSettings(software.amazon.awscdk.services.apigatewayv2.CfnStage.RouteSettingsProperty defaultRouteSettings) {
            this.defaultRouteSettings = defaultRouteSettings;
            return this;
        }

        /**
         * Sets the value of {@link CfnStageProps#getDeploymentId}
         * @param deploymentId The deployment identifier for the API stage.
         *                     Can't be updated if <code>autoDeploy</code> is enabled.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder deploymentId(java.lang.String deploymentId) {
            this.deploymentId = deploymentId;
            return this;
        }

        /**
         * Sets the value of {@link CfnStageProps#getDescription}
         * @param description The description for the API stage.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(java.lang.String description) {
            this.description = description;
            return this;
        }

        /**
         * Sets the value of {@link CfnStageProps#getRouteSettings}
         * @param routeSettings Route settings for the stage.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder routeSettings(java.lang.Object routeSettings) {
            this.routeSettings = routeSettings;
            return this;
        }

        /**
         * Sets the value of {@link CfnStageProps#getStageVariables}
         * @param stageVariables A map that defines the stage variables for a <code>Stage</code> .
         *                       Variable names can have alphanumeric and underscore characters, and the values must match [A-Za-z0-9-._~:/?#&amp;=,]+.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder stageVariables(java.lang.Object stageVariables) {
            this.stageVariables = stageVariables;
            return this;
        }

        /**
         * Sets the value of {@link CfnStageProps#getTags}
         * @param tags The collection of tags.
         *             Each tag element is associated with a given resource.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(java.lang.Object tags) {
            this.tags = tags;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnStageProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnStageProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnStageProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnStageProps {
        private final java.lang.String apiId;
        private final java.lang.String stageName;
        private final java.lang.Object accessLogSettings;
        private final java.lang.String accessPolicyId;
        private final java.lang.Object autoDeploy;
        private final java.lang.String clientCertificateId;
        private final java.lang.Object defaultRouteSettings;
        private final java.lang.String deploymentId;
        private final java.lang.String description;
        private final java.lang.Object routeSettings;
        private final java.lang.Object stageVariables;
        private final java.lang.Object tags;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.apiId = software.amazon.jsii.Kernel.get(this, "apiId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.stageName = software.amazon.jsii.Kernel.get(this, "stageName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.accessLogSettings = software.amazon.jsii.Kernel.get(this, "accessLogSettings", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.accessPolicyId = software.amazon.jsii.Kernel.get(this, "accessPolicyId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.autoDeploy = software.amazon.jsii.Kernel.get(this, "autoDeploy", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.clientCertificateId = software.amazon.jsii.Kernel.get(this, "clientCertificateId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.defaultRouteSettings = software.amazon.jsii.Kernel.get(this, "defaultRouteSettings", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.deploymentId = software.amazon.jsii.Kernel.get(this, "deploymentId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.description = software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.routeSettings = software.amazon.jsii.Kernel.get(this, "routeSettings", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.stageVariables = software.amazon.jsii.Kernel.get(this, "stageVariables", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.apiId = java.util.Objects.requireNonNull(builder.apiId, "apiId is required");
            this.stageName = java.util.Objects.requireNonNull(builder.stageName, "stageName is required");
            this.accessLogSettings = builder.accessLogSettings;
            this.accessPolicyId = builder.accessPolicyId;
            this.autoDeploy = builder.autoDeploy;
            this.clientCertificateId = builder.clientCertificateId;
            this.defaultRouteSettings = builder.defaultRouteSettings;
            this.deploymentId = builder.deploymentId;
            this.description = builder.description;
            this.routeSettings = builder.routeSettings;
            this.stageVariables = builder.stageVariables;
            this.tags = builder.tags;
        }

        @Override
        public final java.lang.String getApiId() {
            return this.apiId;
        }

        @Override
        public final java.lang.String getStageName() {
            return this.stageName;
        }

        @Override
        public final java.lang.Object getAccessLogSettings() {
            return this.accessLogSettings;
        }

        @Override
        public final java.lang.String getAccessPolicyId() {
            return this.accessPolicyId;
        }

        @Override
        public final java.lang.Object getAutoDeploy() {
            return this.autoDeploy;
        }

        @Override
        public final java.lang.String getClientCertificateId() {
            return this.clientCertificateId;
        }

        @Override
        public final java.lang.Object getDefaultRouteSettings() {
            return this.defaultRouteSettings;
        }

        @Override
        public final java.lang.String getDeploymentId() {
            return this.deploymentId;
        }

        @Override
        public final java.lang.String getDescription() {
            return this.description;
        }

        @Override
        public final java.lang.Object getRouteSettings() {
            return this.routeSettings;
        }

        @Override
        public final java.lang.Object getStageVariables() {
            return this.stageVariables;
        }

        @Override
        public final java.lang.Object getTags() {
            return this.tags;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("apiId", om.valueToTree(this.getApiId()));
            data.set("stageName", om.valueToTree(this.getStageName()));
            if (this.getAccessLogSettings() != null) {
                data.set("accessLogSettings", om.valueToTree(this.getAccessLogSettings()));
            }
            if (this.getAccessPolicyId() != null) {
                data.set("accessPolicyId", om.valueToTree(this.getAccessPolicyId()));
            }
            if (this.getAutoDeploy() != null) {
                data.set("autoDeploy", om.valueToTree(this.getAutoDeploy()));
            }
            if (this.getClientCertificateId() != null) {
                data.set("clientCertificateId", om.valueToTree(this.getClientCertificateId()));
            }
            if (this.getDefaultRouteSettings() != null) {
                data.set("defaultRouteSettings", om.valueToTree(this.getDefaultRouteSettings()));
            }
            if (this.getDeploymentId() != null) {
                data.set("deploymentId", om.valueToTree(this.getDeploymentId()));
            }
            if (this.getDescription() != null) {
                data.set("description", om.valueToTree(this.getDescription()));
            }
            if (this.getRouteSettings() != null) {
                data.set("routeSettings", om.valueToTree(this.getRouteSettings()));
            }
            if (this.getStageVariables() != null) {
                data.set("stageVariables", om.valueToTree(this.getStageVariables()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_apigatewayv2.CfnStageProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnStageProps.Jsii$Proxy that = (CfnStageProps.Jsii$Proxy) o;

            if (!apiId.equals(that.apiId)) return false;
            if (!stageName.equals(that.stageName)) return false;
            if (this.accessLogSettings != null ? !this.accessLogSettings.equals(that.accessLogSettings) : that.accessLogSettings != null) return false;
            if (this.accessPolicyId != null ? !this.accessPolicyId.equals(that.accessPolicyId) : that.accessPolicyId != null) return false;
            if (this.autoDeploy != null ? !this.autoDeploy.equals(that.autoDeploy) : that.autoDeploy != null) return false;
            if (this.clientCertificateId != null ? !this.clientCertificateId.equals(that.clientCertificateId) : that.clientCertificateId != null) return false;
            if (this.defaultRouteSettings != null ? !this.defaultRouteSettings.equals(that.defaultRouteSettings) : that.defaultRouteSettings != null) return false;
            if (this.deploymentId != null ? !this.deploymentId.equals(that.deploymentId) : that.deploymentId != null) return false;
            if (this.description != null ? !this.description.equals(that.description) : that.description != null) return false;
            if (this.routeSettings != null ? !this.routeSettings.equals(that.routeSettings) : that.routeSettings != null) return false;
            if (this.stageVariables != null ? !this.stageVariables.equals(that.stageVariables) : that.stageVariables != null) return false;
            return this.tags != null ? this.tags.equals(that.tags) : that.tags == null;
        }

        @Override
        public final int hashCode() {
            int result = this.apiId.hashCode();
            result = 31 * result + (this.stageName.hashCode());
            result = 31 * result + (this.accessLogSettings != null ? this.accessLogSettings.hashCode() : 0);
            result = 31 * result + (this.accessPolicyId != null ? this.accessPolicyId.hashCode() : 0);
            result = 31 * result + (this.autoDeploy != null ? this.autoDeploy.hashCode() : 0);
            result = 31 * result + (this.clientCertificateId != null ? this.clientCertificateId.hashCode() : 0);
            result = 31 * result + (this.defaultRouteSettings != null ? this.defaultRouteSettings.hashCode() : 0);
            result = 31 * result + (this.deploymentId != null ? this.deploymentId.hashCode() : 0);
            result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
            result = 31 * result + (this.routeSettings != null ? this.routeSettings.hashCode() : 0);
            result = 31 * result + (this.stageVariables != null ? this.stageVariables.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            return result;
        }
    }
}
