package software.amazon.awscdk.services.apigatewayv2;

/**
 * Config returned back as a result of the bind.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.*;
 * import software.amazon.awscdk.services.apigatewayv2.*;
 * import software.amazon.awscdk.services.iam.*;
 * Role role;
 * WebSocketRouteIntegrationConfig webSocketRouteIntegrationConfig = WebSocketRouteIntegrationConfig.builder()
 *         .type(WebSocketIntegrationType.AWS_PROXY)
 *         .uri("uri")
 *         // the properties below are optional
 *         .contentHandling(ContentHandling.CONVERT_TO_BINARY)
 *         .credentialsRole(role)
 *         .method("method")
 *         .passthroughBehavior(PassthroughBehavior.WHEN_NO_MATCH)
 *         .requestParameters(Map.of(
 *                 "requestParametersKey", "requestParameters"))
 *         .requestTemplates(Map.of(
 *                 "requestTemplatesKey", "requestTemplates"))
 *         .templateSelectionExpression("templateSelectionExpression")
 *         .timeout(Duration.minutes(30))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-05-22T23:39:45.256Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_apigatewayv2.WebSocketRouteIntegrationConfig")
@software.amazon.jsii.Jsii.Proxy(WebSocketRouteIntegrationConfig.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface WebSocketRouteIntegrationConfig extends software.amazon.jsii.JsiiSerializable {

    /**
     * Integration type.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.apigatewayv2.WebSocketIntegrationType getType();

    /**
     * Integration URI.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getUri();

    /**
     * Specifies how to handle response payload content type conversions.
     * <p>
     * Default: - The response payload will be passed through from the integration response to
     * the route response or method response without modification.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.apigatewayv2.ContentHandling getContentHandling() {
        return null;
    }

    /**
     * Credentials role.
     * <p>
     * Default: - No role provided.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.iam.IRole getCredentialsRole() {
        return null;
    }

    /**
     * Integration method.
     * <p>
     * Default: - No integration method.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getMethod() {
        return null;
    }

    /**
     * Integration passthrough behaviors.
     * <p>
     * Default: - No pass through bahavior.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.apigatewayv2.PassthroughBehavior getPassthroughBehavior() {
        return null;
    }

    /**
     * Request parameters.
     * <p>
     * Default: - No request parameters provided.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, java.lang.String> getRequestParameters() {
        return null;
    }

    /**
     * Request template.
     * <p>
     * Default: - No request template provided.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, java.lang.String> getRequestTemplates() {
        return null;
    }

    /**
     * Template selection expression.
     * <p>
     * Default: - No template selection expression.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getTemplateSelectionExpression() {
        return null;
    }

    /**
     * The maximum amount of time an integration will run before it returns without a response.
     * <p>
     * Must be between 50 milliseconds and 29 seconds.
     * <p>
     * Default: Duration.seconds(29)
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.Duration getTimeout() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link WebSocketRouteIntegrationConfig}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link WebSocketRouteIntegrationConfig}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<WebSocketRouteIntegrationConfig> {
        software.amazon.awscdk.services.apigatewayv2.WebSocketIntegrationType type;
        java.lang.String uri;
        software.amazon.awscdk.services.apigatewayv2.ContentHandling contentHandling;
        software.amazon.awscdk.services.iam.IRole credentialsRole;
        java.lang.String method;
        software.amazon.awscdk.services.apigatewayv2.PassthroughBehavior passthroughBehavior;
        java.util.Map<java.lang.String, java.lang.String> requestParameters;
        java.util.Map<java.lang.String, java.lang.String> requestTemplates;
        java.lang.String templateSelectionExpression;
        software.amazon.awscdk.Duration timeout;

        /**
         * Sets the value of {@link WebSocketRouteIntegrationConfig#getType}
         * @param type Integration type. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder type(software.amazon.awscdk.services.apigatewayv2.WebSocketIntegrationType type) {
            this.type = type;
            return this;
        }

        /**
         * Sets the value of {@link WebSocketRouteIntegrationConfig#getUri}
         * @param uri Integration URI. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder uri(java.lang.String uri) {
            this.uri = uri;
            return this;
        }

        /**
         * Sets the value of {@link WebSocketRouteIntegrationConfig#getContentHandling}
         * @param contentHandling Specifies how to handle response payload content type conversions.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder contentHandling(software.amazon.awscdk.services.apigatewayv2.ContentHandling contentHandling) {
            this.contentHandling = contentHandling;
            return this;
        }

        /**
         * Sets the value of {@link WebSocketRouteIntegrationConfig#getCredentialsRole}
         * @param credentialsRole Credentials role.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder credentialsRole(software.amazon.awscdk.services.iam.IRole credentialsRole) {
            this.credentialsRole = credentialsRole;
            return this;
        }

        /**
         * Sets the value of {@link WebSocketRouteIntegrationConfig#getMethod}
         * @param method Integration method.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder method(java.lang.String method) {
            this.method = method;
            return this;
        }

        /**
         * Sets the value of {@link WebSocketRouteIntegrationConfig#getPassthroughBehavior}
         * @param passthroughBehavior Integration passthrough behaviors.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder passthroughBehavior(software.amazon.awscdk.services.apigatewayv2.PassthroughBehavior passthroughBehavior) {
            this.passthroughBehavior = passthroughBehavior;
            return this;
        }

        /**
         * Sets the value of {@link WebSocketRouteIntegrationConfig#getRequestParameters}
         * @param requestParameters Request parameters.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder requestParameters(java.util.Map<java.lang.String, java.lang.String> requestParameters) {
            this.requestParameters = requestParameters;
            return this;
        }

        /**
         * Sets the value of {@link WebSocketRouteIntegrationConfig#getRequestTemplates}
         * @param requestTemplates Request template.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder requestTemplates(java.util.Map<java.lang.String, java.lang.String> requestTemplates) {
            this.requestTemplates = requestTemplates;
            return this;
        }

        /**
         * Sets the value of {@link WebSocketRouteIntegrationConfig#getTemplateSelectionExpression}
         * @param templateSelectionExpression Template selection expression.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder templateSelectionExpression(java.lang.String templateSelectionExpression) {
            this.templateSelectionExpression = templateSelectionExpression;
            return this;
        }

        /**
         * Sets the value of {@link WebSocketRouteIntegrationConfig#getTimeout}
         * @param timeout The maximum amount of time an integration will run before it returns without a response.
         *                Must be between 50 milliseconds and 29 seconds.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder timeout(software.amazon.awscdk.Duration timeout) {
            this.timeout = timeout;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link WebSocketRouteIntegrationConfig}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public WebSocketRouteIntegrationConfig build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link WebSocketRouteIntegrationConfig}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements WebSocketRouteIntegrationConfig {
        private final software.amazon.awscdk.services.apigatewayv2.WebSocketIntegrationType type;
        private final java.lang.String uri;
        private final software.amazon.awscdk.services.apigatewayv2.ContentHandling contentHandling;
        private final software.amazon.awscdk.services.iam.IRole credentialsRole;
        private final java.lang.String method;
        private final software.amazon.awscdk.services.apigatewayv2.PassthroughBehavior passthroughBehavior;
        private final java.util.Map<java.lang.String, java.lang.String> requestParameters;
        private final java.util.Map<java.lang.String, java.lang.String> requestTemplates;
        private final java.lang.String templateSelectionExpression;
        private final software.amazon.awscdk.Duration timeout;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.type = software.amazon.jsii.Kernel.get(this, "type", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.apigatewayv2.WebSocketIntegrationType.class));
            this.uri = software.amazon.jsii.Kernel.get(this, "uri", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.contentHandling = software.amazon.jsii.Kernel.get(this, "contentHandling", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.apigatewayv2.ContentHandling.class));
            this.credentialsRole = software.amazon.jsii.Kernel.get(this, "credentialsRole", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.IRole.class));
            this.method = software.amazon.jsii.Kernel.get(this, "method", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.passthroughBehavior = software.amazon.jsii.Kernel.get(this, "passthroughBehavior", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.apigatewayv2.PassthroughBehavior.class));
            this.requestParameters = software.amazon.jsii.Kernel.get(this, "requestParameters", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.requestTemplates = software.amazon.jsii.Kernel.get(this, "requestTemplates", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.templateSelectionExpression = software.amazon.jsii.Kernel.get(this, "templateSelectionExpression", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.timeout = software.amazon.jsii.Kernel.get(this, "timeout", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.Duration.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.type = java.util.Objects.requireNonNull(builder.type, "type is required");
            this.uri = java.util.Objects.requireNonNull(builder.uri, "uri is required");
            this.contentHandling = builder.contentHandling;
            this.credentialsRole = builder.credentialsRole;
            this.method = builder.method;
            this.passthroughBehavior = builder.passthroughBehavior;
            this.requestParameters = builder.requestParameters;
            this.requestTemplates = builder.requestTemplates;
            this.templateSelectionExpression = builder.templateSelectionExpression;
            this.timeout = builder.timeout;
        }

        @Override
        public final software.amazon.awscdk.services.apigatewayv2.WebSocketIntegrationType getType() {
            return this.type;
        }

        @Override
        public final java.lang.String getUri() {
            return this.uri;
        }

        @Override
        public final software.amazon.awscdk.services.apigatewayv2.ContentHandling getContentHandling() {
            return this.contentHandling;
        }

        @Override
        public final software.amazon.awscdk.services.iam.IRole getCredentialsRole() {
            return this.credentialsRole;
        }

        @Override
        public final java.lang.String getMethod() {
            return this.method;
        }

        @Override
        public final software.amazon.awscdk.services.apigatewayv2.PassthroughBehavior getPassthroughBehavior() {
            return this.passthroughBehavior;
        }

        @Override
        public final java.util.Map<java.lang.String, java.lang.String> getRequestParameters() {
            return this.requestParameters;
        }

        @Override
        public final java.util.Map<java.lang.String, java.lang.String> getRequestTemplates() {
            return this.requestTemplates;
        }

        @Override
        public final java.lang.String getTemplateSelectionExpression() {
            return this.templateSelectionExpression;
        }

        @Override
        public final software.amazon.awscdk.Duration getTimeout() {
            return this.timeout;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("type", om.valueToTree(this.getType()));
            data.set("uri", om.valueToTree(this.getUri()));
            if (this.getContentHandling() != null) {
                data.set("contentHandling", om.valueToTree(this.getContentHandling()));
            }
            if (this.getCredentialsRole() != null) {
                data.set("credentialsRole", om.valueToTree(this.getCredentialsRole()));
            }
            if (this.getMethod() != null) {
                data.set("method", om.valueToTree(this.getMethod()));
            }
            if (this.getPassthroughBehavior() != null) {
                data.set("passthroughBehavior", om.valueToTree(this.getPassthroughBehavior()));
            }
            if (this.getRequestParameters() != null) {
                data.set("requestParameters", om.valueToTree(this.getRequestParameters()));
            }
            if (this.getRequestTemplates() != null) {
                data.set("requestTemplates", om.valueToTree(this.getRequestTemplates()));
            }
            if (this.getTemplateSelectionExpression() != null) {
                data.set("templateSelectionExpression", om.valueToTree(this.getTemplateSelectionExpression()));
            }
            if (this.getTimeout() != null) {
                data.set("timeout", om.valueToTree(this.getTimeout()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_apigatewayv2.WebSocketRouteIntegrationConfig"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            WebSocketRouteIntegrationConfig.Jsii$Proxy that = (WebSocketRouteIntegrationConfig.Jsii$Proxy) o;

            if (!type.equals(that.type)) return false;
            if (!uri.equals(that.uri)) return false;
            if (this.contentHandling != null ? !this.contentHandling.equals(that.contentHandling) : that.contentHandling != null) return false;
            if (this.credentialsRole != null ? !this.credentialsRole.equals(that.credentialsRole) : that.credentialsRole != null) return false;
            if (this.method != null ? !this.method.equals(that.method) : that.method != null) return false;
            if (this.passthroughBehavior != null ? !this.passthroughBehavior.equals(that.passthroughBehavior) : that.passthroughBehavior != null) return false;
            if (this.requestParameters != null ? !this.requestParameters.equals(that.requestParameters) : that.requestParameters != null) return false;
            if (this.requestTemplates != null ? !this.requestTemplates.equals(that.requestTemplates) : that.requestTemplates != null) return false;
            if (this.templateSelectionExpression != null ? !this.templateSelectionExpression.equals(that.templateSelectionExpression) : that.templateSelectionExpression != null) return false;
            return this.timeout != null ? this.timeout.equals(that.timeout) : that.timeout == null;
        }

        @Override
        public final int hashCode() {
            int result = this.type.hashCode();
            result = 31 * result + (this.uri.hashCode());
            result = 31 * result + (this.contentHandling != null ? this.contentHandling.hashCode() : 0);
            result = 31 * result + (this.credentialsRole != null ? this.credentialsRole.hashCode() : 0);
            result = 31 * result + (this.method != null ? this.method.hashCode() : 0);
            result = 31 * result + (this.passthroughBehavior != null ? this.passthroughBehavior.hashCode() : 0);
            result = 31 * result + (this.requestParameters != null ? this.requestParameters.hashCode() : 0);
            result = 31 * result + (this.requestTemplates != null ? this.requestTemplates.hashCode() : 0);
            result = 31 * result + (this.templateSelectionExpression != null ? this.templateSelectionExpression.hashCode() : 0);
            result = 31 * result + (this.timeout != null ? this.timeout.hashCode() : 0);
            return result;
        }
    }
}
