package software.amazon.awscdk.services.appmesh;

/**
 * The criterion for determining a request match for this Route.
 * <p>
 * At least one match type must be selected.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * VirtualRouter router;
 * VirtualNode node;
 * router.addRoute("route-grpc-retry", RouteBaseProps.builder()
 *         .routeSpec(RouteSpec.grpc(GrpcRouteSpecOptions.builder()
 *                 .weightedTargets(List.of(WeightedTarget.builder().virtualNode(node).build()))
 *                 .match(GrpcRouteMatch.builder()
 *                         // When method name is specified, service name must be also specified.
 *                         .methodName("methodname")
 *                         .serviceName("servicename")
 *                         .metadata(List.of(HeaderMatch.valueStartsWith("Content-Type", "application/"), HeaderMatch.valueDoesNotStartWith("Content-Type", "text/")))
 *                         .build())
 *                 .build()))
 *         .build());
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-05-22T23:39:45.736Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appmesh.GrpcRouteMatch")
@software.amazon.jsii.Jsii.Proxy(GrpcRouteMatch.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface GrpcRouteMatch extends software.amazon.jsii.JsiiSerializable {

    /**
     * Create metadata based gRPC route match.
     * <p>
     * All specified metadata must match for the route to match.
     * <p>
     * Default: - do not match on metadata
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.services.appmesh.HeaderMatch> getMetadata() {
        return null;
    }

    /**
     * The method name to match from the request.
     * <p>
     * If the method name is specified, service name must be also provided.
     * <p>
     * Default: - do not match on method name
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getMethodName() {
        return null;
    }

    /**
     * The port to match from the request.
     * <p>
     * Default: - do not match on port
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getPort() {
        return null;
    }

    /**
     * Create service name based gRPC route match.
     * <p>
     * Default: - do not match on service name
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getServiceName() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link GrpcRouteMatch}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link GrpcRouteMatch}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<GrpcRouteMatch> {
        java.util.List<software.amazon.awscdk.services.appmesh.HeaderMatch> metadata;
        java.lang.String methodName;
        java.lang.Number port;
        java.lang.String serviceName;

        /**
         * Sets the value of {@link GrpcRouteMatch#getMetadata}
         * @param metadata Create metadata based gRPC route match.
         *                 All specified metadata must match for the route to match.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder metadata(java.util.List<? extends software.amazon.awscdk.services.appmesh.HeaderMatch> metadata) {
            this.metadata = (java.util.List<software.amazon.awscdk.services.appmesh.HeaderMatch>)metadata;
            return this;
        }

        /**
         * Sets the value of {@link GrpcRouteMatch#getMethodName}
         * @param methodName The method name to match from the request.
         *                   If the method name is specified, service name must be also provided.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder methodName(java.lang.String methodName) {
            this.methodName = methodName;
            return this;
        }

        /**
         * Sets the value of {@link GrpcRouteMatch#getPort}
         * @param port The port to match from the request.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder port(java.lang.Number port) {
            this.port = port;
            return this;
        }

        /**
         * Sets the value of {@link GrpcRouteMatch#getServiceName}
         * @param serviceName Create service name based gRPC route match.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder serviceName(java.lang.String serviceName) {
            this.serviceName = serviceName;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link GrpcRouteMatch}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public GrpcRouteMatch build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link GrpcRouteMatch}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements GrpcRouteMatch {
        private final java.util.List<software.amazon.awscdk.services.appmesh.HeaderMatch> metadata;
        private final java.lang.String methodName;
        private final java.lang.Number port;
        private final java.lang.String serviceName;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.metadata = software.amazon.jsii.Kernel.get(this, "metadata", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appmesh.HeaderMatch.class)));
            this.methodName = software.amazon.jsii.Kernel.get(this, "methodName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.port = software.amazon.jsii.Kernel.get(this, "port", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.serviceName = software.amazon.jsii.Kernel.get(this, "serviceName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.metadata = (java.util.List<software.amazon.awscdk.services.appmesh.HeaderMatch>)builder.metadata;
            this.methodName = builder.methodName;
            this.port = builder.port;
            this.serviceName = builder.serviceName;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.services.appmesh.HeaderMatch> getMetadata() {
            return this.metadata;
        }

        @Override
        public final java.lang.String getMethodName() {
            return this.methodName;
        }

        @Override
        public final java.lang.Number getPort() {
            return this.port;
        }

        @Override
        public final java.lang.String getServiceName() {
            return this.serviceName;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getMetadata() != null) {
                data.set("metadata", om.valueToTree(this.getMetadata()));
            }
            if (this.getMethodName() != null) {
                data.set("methodName", om.valueToTree(this.getMethodName()));
            }
            if (this.getPort() != null) {
                data.set("port", om.valueToTree(this.getPort()));
            }
            if (this.getServiceName() != null) {
                data.set("serviceName", om.valueToTree(this.getServiceName()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_appmesh.GrpcRouteMatch"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            GrpcRouteMatch.Jsii$Proxy that = (GrpcRouteMatch.Jsii$Proxy) o;

            if (this.metadata != null ? !this.metadata.equals(that.metadata) : that.metadata != null) return false;
            if (this.methodName != null ? !this.methodName.equals(that.methodName) : that.methodName != null) return false;
            if (this.port != null ? !this.port.equals(that.port) : that.port != null) return false;
            return this.serviceName != null ? this.serviceName.equals(that.serviceName) : that.serviceName == null;
        }

        @Override
        public final int hashCode() {
            int result = this.metadata != null ? this.metadata.hashCode() : 0;
            result = 31 * result + (this.methodName != null ? this.methodName.hashCode() : 0);
            result = 31 * result + (this.port != null ? this.port.hashCode() : 0);
            result = 31 * result + (this.serviceName != null ? this.serviceName.hashCode() : 0);
            return result;
        }
    }
}
