package software.amazon.awscdk.services.appmesh;

/**
 * The type returned from the <code>bind()</code> method in <code>HttpGatewayRoutePathMatch</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.appmesh.*;
 * HttpGatewayRoutePathMatchConfig httpGatewayRoutePathMatchConfig = HttpGatewayRoutePathMatchConfig.builder()
 *         .prefixPathMatch("prefixPathMatch")
 *         .prefixPathRewrite(HttpGatewayRoutePrefixRewriteProperty.builder()
 *                 .defaultPrefix("defaultPrefix")
 *                 .value("value")
 *                 .build())
 *         .wholePathMatch(HttpPathMatchProperty.builder()
 *                 .exact("exact")
 *                 .regex("regex")
 *                 .build())
 *         .wholePathRewrite(HttpGatewayRoutePathRewriteProperty.builder()
 *                 .exact("exact")
 *                 .build())
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-05-22T23:39:45.745Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appmesh.HttpGatewayRoutePathMatchConfig")
@software.amazon.jsii.Jsii.Proxy(HttpGatewayRoutePathMatchConfig.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface HttpGatewayRoutePathMatchConfig extends software.amazon.jsii.JsiiSerializable {

    /**
     * Gateway route configuration for matching on the prefix of the URL path of the request.
     * <p>
     * Default: - no matching will be performed on the prefix of the URL path
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getPrefixPathMatch() {
        return null;
    }

    /**
     * Gateway route configuration for rewriting the prefix of the URL path of the request.
     * <p>
     * Default: - rewrites the request's URL path to '/'
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.appmesh.CfnGatewayRoute.HttpGatewayRoutePrefixRewriteProperty getPrefixPathRewrite() {
        return null;
    }

    /**
     * Gateway route configuration for matching on the complete URL path of the request.
     * <p>
     * Default: - no matching will be performed on the complete URL path
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.appmesh.CfnGatewayRoute.HttpPathMatchProperty getWholePathMatch() {
        return null;
    }

    /**
     * Gateway route configuration for rewriting the complete URL path of the request..
     * <p>
     * Default: - no rewrite will be performed on the request's complete URL path
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.appmesh.CfnGatewayRoute.HttpGatewayRoutePathRewriteProperty getWholePathRewrite() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link HttpGatewayRoutePathMatchConfig}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link HttpGatewayRoutePathMatchConfig}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<HttpGatewayRoutePathMatchConfig> {
        java.lang.String prefixPathMatch;
        software.amazon.awscdk.services.appmesh.CfnGatewayRoute.HttpGatewayRoutePrefixRewriteProperty prefixPathRewrite;
        software.amazon.awscdk.services.appmesh.CfnGatewayRoute.HttpPathMatchProperty wholePathMatch;
        software.amazon.awscdk.services.appmesh.CfnGatewayRoute.HttpGatewayRoutePathRewriteProperty wholePathRewrite;

        /**
         * Sets the value of {@link HttpGatewayRoutePathMatchConfig#getPrefixPathMatch}
         * @param prefixPathMatch Gateway route configuration for matching on the prefix of the URL path of the request.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder prefixPathMatch(java.lang.String prefixPathMatch) {
            this.prefixPathMatch = prefixPathMatch;
            return this;
        }

        /**
         * Sets the value of {@link HttpGatewayRoutePathMatchConfig#getPrefixPathRewrite}
         * @param prefixPathRewrite Gateway route configuration for rewriting the prefix of the URL path of the request.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder prefixPathRewrite(software.amazon.awscdk.services.appmesh.CfnGatewayRoute.HttpGatewayRoutePrefixRewriteProperty prefixPathRewrite) {
            this.prefixPathRewrite = prefixPathRewrite;
            return this;
        }

        /**
         * Sets the value of {@link HttpGatewayRoutePathMatchConfig#getWholePathMatch}
         * @param wholePathMatch Gateway route configuration for matching on the complete URL path of the request.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder wholePathMatch(software.amazon.awscdk.services.appmesh.CfnGatewayRoute.HttpPathMatchProperty wholePathMatch) {
            this.wholePathMatch = wholePathMatch;
            return this;
        }

        /**
         * Sets the value of {@link HttpGatewayRoutePathMatchConfig#getWholePathRewrite}
         * @param wholePathRewrite Gateway route configuration for rewriting the complete URL path of the request..
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder wholePathRewrite(software.amazon.awscdk.services.appmesh.CfnGatewayRoute.HttpGatewayRoutePathRewriteProperty wholePathRewrite) {
            this.wholePathRewrite = wholePathRewrite;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link HttpGatewayRoutePathMatchConfig}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public HttpGatewayRoutePathMatchConfig build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link HttpGatewayRoutePathMatchConfig}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements HttpGatewayRoutePathMatchConfig {
        private final java.lang.String prefixPathMatch;
        private final software.amazon.awscdk.services.appmesh.CfnGatewayRoute.HttpGatewayRoutePrefixRewriteProperty prefixPathRewrite;
        private final software.amazon.awscdk.services.appmesh.CfnGatewayRoute.HttpPathMatchProperty wholePathMatch;
        private final software.amazon.awscdk.services.appmesh.CfnGatewayRoute.HttpGatewayRoutePathRewriteProperty wholePathRewrite;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.prefixPathMatch = software.amazon.jsii.Kernel.get(this, "prefixPathMatch", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.prefixPathRewrite = software.amazon.jsii.Kernel.get(this, "prefixPathRewrite", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appmesh.CfnGatewayRoute.HttpGatewayRoutePrefixRewriteProperty.class));
            this.wholePathMatch = software.amazon.jsii.Kernel.get(this, "wholePathMatch", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appmesh.CfnGatewayRoute.HttpPathMatchProperty.class));
            this.wholePathRewrite = software.amazon.jsii.Kernel.get(this, "wholePathRewrite", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appmesh.CfnGatewayRoute.HttpGatewayRoutePathRewriteProperty.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.prefixPathMatch = builder.prefixPathMatch;
            this.prefixPathRewrite = builder.prefixPathRewrite;
            this.wholePathMatch = builder.wholePathMatch;
            this.wholePathRewrite = builder.wholePathRewrite;
        }

        @Override
        public final java.lang.String getPrefixPathMatch() {
            return this.prefixPathMatch;
        }

        @Override
        public final software.amazon.awscdk.services.appmesh.CfnGatewayRoute.HttpGatewayRoutePrefixRewriteProperty getPrefixPathRewrite() {
            return this.prefixPathRewrite;
        }

        @Override
        public final software.amazon.awscdk.services.appmesh.CfnGatewayRoute.HttpPathMatchProperty getWholePathMatch() {
            return this.wholePathMatch;
        }

        @Override
        public final software.amazon.awscdk.services.appmesh.CfnGatewayRoute.HttpGatewayRoutePathRewriteProperty getWholePathRewrite() {
            return this.wholePathRewrite;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getPrefixPathMatch() != null) {
                data.set("prefixPathMatch", om.valueToTree(this.getPrefixPathMatch()));
            }
            if (this.getPrefixPathRewrite() != null) {
                data.set("prefixPathRewrite", om.valueToTree(this.getPrefixPathRewrite()));
            }
            if (this.getWholePathMatch() != null) {
                data.set("wholePathMatch", om.valueToTree(this.getWholePathMatch()));
            }
            if (this.getWholePathRewrite() != null) {
                data.set("wholePathRewrite", om.valueToTree(this.getWholePathRewrite()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_appmesh.HttpGatewayRoutePathMatchConfig"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            HttpGatewayRoutePathMatchConfig.Jsii$Proxy that = (HttpGatewayRoutePathMatchConfig.Jsii$Proxy) o;

            if (this.prefixPathMatch != null ? !this.prefixPathMatch.equals(that.prefixPathMatch) : that.prefixPathMatch != null) return false;
            if (this.prefixPathRewrite != null ? !this.prefixPathRewrite.equals(that.prefixPathRewrite) : that.prefixPathRewrite != null) return false;
            if (this.wholePathMatch != null ? !this.wholePathMatch.equals(that.wholePathMatch) : that.wholePathMatch != null) return false;
            return this.wholePathRewrite != null ? this.wholePathRewrite.equals(that.wholePathRewrite) : that.wholePathRewrite == null;
        }

        @Override
        public final int hashCode() {
            int result = this.prefixPathMatch != null ? this.prefixPathMatch.hashCode() : 0;
            result = 31 * result + (this.prefixPathRewrite != null ? this.prefixPathRewrite.hashCode() : 0);
            result = 31 * result + (this.wholePathMatch != null ? this.wholePathMatch.hashCode() : 0);
            result = 31 * result + (this.wholePathRewrite != null ? this.wholePathRewrite.hashCode() : 0);
            return result;
        }
    }
}
