package software.amazon.awscdk.services.appsync;

/**
 * An Appsync datasource backed by OpenSearch.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.services.opensearchservice.*;
 * Domain domain = Domain.Builder.create(this, "Domain")
 *         .version(EngineVersion.OPENSEARCH_2_17)
 *         .encryptionAtRest(EncryptionAtRestOptions.builder()
 *                 .enabled(true)
 *                 .build())
 *         .nodeToNodeEncryption(true)
 *         .enforceHttps(true)
 *         .capacity(CapacityConfig.builder()
 *                 .multiAzWithStandbyEnabled(false)
 *                 .build())
 *         .ebs(EbsOptions.builder()
 *                 .enabled(true)
 *                 .volumeSize(10)
 *                 .build())
 *         .build();
 * EventApi api = EventApi.Builder.create(this, "EventApiOpenSearch")
 *         .apiName("OpenSearchEventApi")
 *         .build();
 * AppSyncOpenSearchDataSource dataSource = api.addOpenSearchDataSource("opensearchds", domain);
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-05-22T23:39:45.917Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appsync.AppSyncOpenSearchDataSource")
public class AppSyncOpenSearchDataSource extends software.amazon.awscdk.services.appsync.AppSyncBackedDataSource {

    protected AppSyncOpenSearchDataSource(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected AppSyncOpenSearchDataSource(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public AppSyncOpenSearchDataSource(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appsync.AppSyncOpenSearchDataSourceProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.appsync.AppSyncOpenSearchDataSource}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.appsync.AppSyncOpenSearchDataSource> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope This parameter is required.
         * @param id This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.appsync.AppSyncOpenSearchDataSourceProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.appsync.AppSyncOpenSearchDataSourceProps.Builder();
        }

        /**
         * The API to attach this data source to.
         * <p>
         * @return {@code this}
         * @param api The API to attach this data source to. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder api(final software.amazon.awscdk.services.appsync.IApi api) {
            this.props.api(api);
            return this;
        }

        /**
         * The description of the data source.
         * <p>
         * Default: - None
         * <p>
         * @return {@code this}
         * @param description The description of the data source. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(final java.lang.String description) {
            this.props.description(description);
            return this;
        }

        /**
         * The name of the data source.
         * <p>
         * The only allowed pattern is: {[_A-Za-z][_0-9A-Za-z]*}.
         * Any invalid characters will be automatically removed.
         * <p>
         * Default: - id of data source
         * <p>
         * @return {@code this}
         * @param name The name of the data source. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(final java.lang.String name) {
            this.props.name(name);
            return this;
        }

        /**
         * The IAM service role to be assumed by AppSync to interact with the data source.
         * <p>
         * Default: -  Create a new role
         * <p>
         * @return {@code this}
         * @param serviceRole The IAM service role to be assumed by AppSync to interact with the data source. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder serviceRole(final software.amazon.awscdk.services.iam.IRole serviceRole) {
            this.props.serviceRole(serviceRole);
            return this;
        }

        /**
         * The OpenSearch domain containing the endpoint for the data source.
         * <p>
         * @return {@code this}
         * @param domain The OpenSearch domain containing the endpoint for the data source. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder domain(final software.amazon.awscdk.services.opensearchservice.IDomain domain) {
            this.props.domain(domain);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.appsync.AppSyncOpenSearchDataSource}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.appsync.AppSyncOpenSearchDataSource build() {
            return new software.amazon.awscdk.services.appsync.AppSyncOpenSearchDataSource(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
