package software.amazon.awscdk.services.appsync;

/**
 * Configuration of the API authorization modes.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.services.appsync.*;
 * GraphqlApi api = GraphqlApi.Builder.create(this, "api")
 *         .name("api")
 *         .definition(Definition.fromFile("schema.graphql"))
 *         .authorizationConfig(AuthorizationConfig.builder()
 *                 .defaultAuthorization(AuthorizationMode.builder().authorizationType(AuthorizationType.IAM).build())
 *                 .build())
 *         .build();
 * Rule rule = Rule.Builder.create(this, "Rule")
 *         .schedule(Schedule.rate(Duration.hours(1)))
 *         .build();
 * rule.addTarget(AppSync.Builder.create(api)
 *         .graphQLOperation("mutation Publish($message: String!){ publish(message: $message) { message } }")
 *         .variables(RuleTargetInput.fromObject(Map.of(
 *                 "message", "hello world")))
 *         .build());
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-05-22T23:39:45.924Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appsync.AuthorizationConfig")
@software.amazon.jsii.Jsii.Proxy(AuthorizationConfig.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface AuthorizationConfig extends software.amazon.jsii.JsiiSerializable {

    /**
     * Additional authorization modes.
     * <p>
     * Default: - No other modes
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.services.appsync.AuthorizationMode> getAdditionalAuthorizationModes() {
        return null;
    }

    /**
     * Optional authorization configuration.
     * <p>
     * Default: - API Key authorization
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.appsync.AuthorizationMode getDefaultAuthorization() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link AuthorizationConfig}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link AuthorizationConfig}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<AuthorizationConfig> {
        java.util.List<software.amazon.awscdk.services.appsync.AuthorizationMode> additionalAuthorizationModes;
        software.amazon.awscdk.services.appsync.AuthorizationMode defaultAuthorization;

        /**
         * Sets the value of {@link AuthorizationConfig#getAdditionalAuthorizationModes}
         * @param additionalAuthorizationModes Additional authorization modes.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder additionalAuthorizationModes(java.util.List<? extends software.amazon.awscdk.services.appsync.AuthorizationMode> additionalAuthorizationModes) {
            this.additionalAuthorizationModes = (java.util.List<software.amazon.awscdk.services.appsync.AuthorizationMode>)additionalAuthorizationModes;
            return this;
        }

        /**
         * Sets the value of {@link AuthorizationConfig#getDefaultAuthorization}
         * @param defaultAuthorization Optional authorization configuration.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder defaultAuthorization(software.amazon.awscdk.services.appsync.AuthorizationMode defaultAuthorization) {
            this.defaultAuthorization = defaultAuthorization;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link AuthorizationConfig}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public AuthorizationConfig build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link AuthorizationConfig}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AuthorizationConfig {
        private final java.util.List<software.amazon.awscdk.services.appsync.AuthorizationMode> additionalAuthorizationModes;
        private final software.amazon.awscdk.services.appsync.AuthorizationMode defaultAuthorization;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.additionalAuthorizationModes = software.amazon.jsii.Kernel.get(this, "additionalAuthorizationModes", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appsync.AuthorizationMode.class)));
            this.defaultAuthorization = software.amazon.jsii.Kernel.get(this, "defaultAuthorization", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appsync.AuthorizationMode.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.additionalAuthorizationModes = (java.util.List<software.amazon.awscdk.services.appsync.AuthorizationMode>)builder.additionalAuthorizationModes;
            this.defaultAuthorization = builder.defaultAuthorization;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.services.appsync.AuthorizationMode> getAdditionalAuthorizationModes() {
            return this.additionalAuthorizationModes;
        }

        @Override
        public final software.amazon.awscdk.services.appsync.AuthorizationMode getDefaultAuthorization() {
            return this.defaultAuthorization;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getAdditionalAuthorizationModes() != null) {
                data.set("additionalAuthorizationModes", om.valueToTree(this.getAdditionalAuthorizationModes()));
            }
            if (this.getDefaultAuthorization() != null) {
                data.set("defaultAuthorization", om.valueToTree(this.getDefaultAuthorization()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_appsync.AuthorizationConfig"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            AuthorizationConfig.Jsii$Proxy that = (AuthorizationConfig.Jsii$Proxy) o;

            if (this.additionalAuthorizationModes != null ? !this.additionalAuthorizationModes.equals(that.additionalAuthorizationModes) : that.additionalAuthorizationModes != null) return false;
            return this.defaultAuthorization != null ? this.defaultAuthorization.equals(that.defaultAuthorization) : that.defaultAuthorization == null;
        }

        @Override
        public final int hashCode() {
            int result = this.additionalAuthorizationModes != null ? this.additionalAuthorizationModes.hashCode() : 0;
            result = 31 * result + (this.defaultAuthorization != null ? this.defaultAuthorization.hashCode() : 0);
            return result;
        }
    }
}
