package software.amazon.awscdk.services.autoscalingplans;

/**
 * The <code>AWS::AutoScalingPlans::ScalingPlan</code> resource defines an AWS Auto Scaling scaling plan.
 * <p>
 * A scaling plan is used to scale application resources to size them appropriately to ensure that enough resource is available in the application at peak times and to reduce allocated resource during periods of low utilization. The following resources can be added to a scaling plan:
 * <p>
 * <ul>
 * <li>Amazon EC2 Auto Scaling groups</li>
 * <li>Amazon EC2 Spot Fleet requests</li>
 * <li>Amazon ECS services</li>
 * <li>Amazon DynamoDB tables and global secondary indexes</li>
 * <li>Amazon Aurora Replicas</li>
 * </ul>
 * <p>
 * For more information, see the <a href="https://docs.aws.amazon.com/autoscaling/plans/userguide/what-is-a-scaling-plan.html">Scaling Plans User Guide</a>
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.autoscalingplans.*;
 * CfnScalingPlan cfnScalingPlan = CfnScalingPlan.Builder.create(this, "MyCfnScalingPlan")
 *         .applicationSource(ApplicationSourceProperty.builder()
 *                 .cloudFormationStackArn("cloudFormationStackArn")
 *                 .tagFilters(List.of(TagFilterProperty.builder()
 *                         .key("key")
 *                         // the properties below are optional
 *                         .values(List.of("values"))
 *                         .build()))
 *                 .build())
 *         .scalingInstructions(List.of(ScalingInstructionProperty.builder()
 *                 .maxCapacity(123)
 *                 .minCapacity(123)
 *                 .resourceId("resourceId")
 *                 .scalableDimension("scalableDimension")
 *                 .serviceNamespace("serviceNamespace")
 *                 .targetTrackingConfigurations(List.of(TargetTrackingConfigurationProperty.builder()
 *                         .targetValue(123)
 *                         // the properties below are optional
 *                         .customizedScalingMetricSpecification(CustomizedScalingMetricSpecificationProperty.builder()
 *                                 .metricName("metricName")
 *                                 .namespace("namespace")
 *                                 .statistic("statistic")
 *                                 // the properties below are optional
 *                                 .dimensions(List.of(MetricDimensionProperty.builder()
 *                                         .name("name")
 *                                         .value("value")
 *                                         .build()))
 *                                 .unit("unit")
 *                                 .build())
 *                         .disableScaleIn(false)
 *                         .estimatedInstanceWarmup(123)
 *                         .predefinedScalingMetricSpecification(PredefinedScalingMetricSpecificationProperty.builder()
 *                                 .predefinedScalingMetricType("predefinedScalingMetricType")
 *                                 // the properties below are optional
 *                                 .resourceLabel("resourceLabel")
 *                                 .build())
 *                         .scaleInCooldown(123)
 *                         .scaleOutCooldown(123)
 *                         .build()))
 *                 // the properties below are optional
 *                 .customizedLoadMetricSpecification(CustomizedLoadMetricSpecificationProperty.builder()
 *                         .metricName("metricName")
 *                         .namespace("namespace")
 *                         .statistic("statistic")
 *                         // the properties below are optional
 *                         .dimensions(List.of(MetricDimensionProperty.builder()
 *                                 .name("name")
 *                                 .value("value")
 *                                 .build()))
 *                         .unit("unit")
 *                         .build())
 *                 .disableDynamicScaling(false)
 *                 .predefinedLoadMetricSpecification(PredefinedLoadMetricSpecificationProperty.builder()
 *                         .predefinedLoadMetricType("predefinedLoadMetricType")
 *                         // the properties below are optional
 *                         .resourceLabel("resourceLabel")
 *                         .build())
 *                 .predictiveScalingMaxCapacityBehavior("predictiveScalingMaxCapacityBehavior")
 *                 .predictiveScalingMaxCapacityBuffer(123)
 *                 .predictiveScalingMode("predictiveScalingMode")
 *                 .scalingPolicyUpdateBehavior("scalingPolicyUpdateBehavior")
 *                 .scheduledActionBufferTime(123)
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-autoscalingplans-scalingplan.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-autoscalingplans-scalingplan.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-05-22T23:39:46.334Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_autoscalingplans.CfnScalingPlan")
public class CfnScalingPlan extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable {

    protected CfnScalingPlan(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnScalingPlan(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.autoscalingplans.CfnScalingPlan.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * @param scope Scope in which this resource is defined. This parameter is required.
     * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
     * @param props Resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnScalingPlan(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.autoscalingplans.CfnScalingPlanProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrId() {
        return software.amazon.jsii.Kernel.get(this, "attrId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrScalingPlanName() {
        return software.amazon.jsii.Kernel.get(this, "attrScalingPlanName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrScalingPlanVersion() {
        return software.amazon.jsii.Kernel.get(this, "attrScalingPlanVersion", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * A CloudFormation stack or a set of tags.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Object getApplicationSource() {
        return software.amazon.jsii.Kernel.get(this, "applicationSource", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * A CloudFormation stack or a set of tags.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setApplicationSource(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "applicationSource", java.util.Objects.requireNonNull(value, "applicationSource is required"));
    }

    /**
     * A CloudFormation stack or a set of tags.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setApplicationSource(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.autoscalingplans.CfnScalingPlan.ApplicationSourceProperty value) {
        software.amazon.jsii.Kernel.set(this, "applicationSource", java.util.Objects.requireNonNull(value, "applicationSource is required"));
    }

    /**
     * The scaling instructions.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Object getScalingInstructions() {
        return software.amazon.jsii.Kernel.get(this, "scalingInstructions", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The scaling instructions.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setScalingInstructions(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "scalingInstructions", java.util.Objects.requireNonNull(value, "scalingInstructions is required"));
    }

    /**
     * The scaling instructions.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setScalingInstructions(final @org.jetbrains.annotations.NotNull java.util.List<java.lang.Object> value) {
        if (software.amazon.jsii.Configuration.getRuntimeTypeChecking()) {
            for (int __idx_ac66f0 = 0; __idx_ac66f0 < value.size(); __idx_ac66f0++) {
                final java.lang.Object __val_ac66f0 = value.get(__idx_ac66f0);
                if (
                     !(__val_ac66f0 instanceof software.amazon.awscdk.IResolvable)
                    && !(__val_ac66f0 instanceof software.amazon.awscdk.services.autoscalingplans.CfnScalingPlan.ScalingInstructionProperty)
                    && !(__val_ac66f0.getClass().equals(software.amazon.jsii.JsiiObject.class))
                ) {
                    throw new IllegalArgumentException(
                        new java.lang.StringBuilder("Expected ")
                            .append("value").append(".get(").append(__idx_ac66f0).append(")")
                            .append(" to be one of: software.amazon.awscdk.IResolvable, software.amazon.awscdk.services.autoscalingplans.CfnScalingPlan.ScalingInstructionProperty; received ")
                            .append(__val_ac66f0.getClass()).toString());
                }
            }
        }
        software.amazon.jsii.Kernel.set(this, "scalingInstructions", java.util.Objects.requireNonNull(value, "scalingInstructions is required"));
    }
    /**
     * <code>ApplicationSource</code> is a property of <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-autoscalingplans-scalingplan.html">ScalingPlan</a> that specifies the application source to use with a scaling plan. You can create one scaling plan per application source.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.autoscalingplans.*;
     * ApplicationSourceProperty applicationSourceProperty = ApplicationSourceProperty.builder()
     *         .cloudFormationStackArn("cloudFormationStackArn")
     *         .tagFilters(List.of(TagFilterProperty.builder()
     *                 .key("key")
     *                 // the properties below are optional
     *                 .values(List.of("values"))
     *                 .build()))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-autoscalingplans-scalingplan-applicationsource.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-autoscalingplans-scalingplan-applicationsource.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_autoscalingplans.CfnScalingPlan.ApplicationSourceProperty")
    @software.amazon.jsii.Jsii.Proxy(ApplicationSourceProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ApplicationSourceProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The Amazon Resource Name (ARN) of a CloudFormation stack.
         * <p>
         * You must specify either a <code>CloudFormationStackARN</code> or <code>TagFilters</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-autoscalingplans-scalingplan-applicationsource.html#cfn-autoscalingplans-scalingplan-applicationsource-cloudformationstackarn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-autoscalingplans-scalingplan-applicationsource.html#cfn-autoscalingplans-scalingplan-applicationsource-cloudformationstackarn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getCloudFormationStackArn() {
            return null;
        }

        /**
         * A set of tag filters (keys and values).
         * <p>
         * Each tag filter specified must contain a key with values as optional. Each scaling plan can include up to 50 keys, and each key can include up to 20 values.
         * <p>
         * Tags are part of the syntax that you use to specify the resources you want returned when configuring a scaling plan from the AWS Auto Scaling console. You do not need to specify valid tag filter values when you create a scaling plan with CloudFormation. The <code>Key</code> and <code>Values</code> properties can accept any value as long as the combination of values is unique across scaling plans. However, if you also want to use the AWS Auto Scaling console to edit the scaling plan, then you must specify valid values.
         * <p>
         * You must specify either a <code>CloudFormationStackARN</code> or <code>TagFilters</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-autoscalingplans-scalingplan-applicationsource.html#cfn-autoscalingplans-scalingplan-applicationsource-tagfilters">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-autoscalingplans-scalingplan-applicationsource.html#cfn-autoscalingplans-scalingplan-applicationsource-tagfilters</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getTagFilters() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ApplicationSourceProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ApplicationSourceProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ApplicationSourceProperty> {
            java.lang.String cloudFormationStackArn;
            java.lang.Object tagFilters;

            /**
             * Sets the value of {@link ApplicationSourceProperty#getCloudFormationStackArn}
             * @param cloudFormationStackArn The Amazon Resource Name (ARN) of a CloudFormation stack.
             *                               You must specify either a <code>CloudFormationStackARN</code> or <code>TagFilters</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder cloudFormationStackArn(java.lang.String cloudFormationStackArn) {
                this.cloudFormationStackArn = cloudFormationStackArn;
                return this;
            }

            /**
             * Sets the value of {@link ApplicationSourceProperty#getTagFilters}
             * @param tagFilters A set of tag filters (keys and values).
             *                   Each tag filter specified must contain a key with values as optional. Each scaling plan can include up to 50 keys, and each key can include up to 20 values.
             *                   <p>
             *                   Tags are part of the syntax that you use to specify the resources you want returned when configuring a scaling plan from the AWS Auto Scaling console. You do not need to specify valid tag filter values when you create a scaling plan with CloudFormation. The <code>Key</code> and <code>Values</code> properties can accept any value as long as the combination of values is unique across scaling plans. However, if you also want to use the AWS Auto Scaling console to edit the scaling plan, then you must specify valid values.
             *                   <p>
             *                   You must specify either a <code>CloudFormationStackARN</code> or <code>TagFilters</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder tagFilters(software.amazon.awscdk.IResolvable tagFilters) {
                this.tagFilters = tagFilters;
                return this;
            }

            /**
             * Sets the value of {@link ApplicationSourceProperty#getTagFilters}
             * @param tagFilters A set of tag filters (keys and values).
             *                   Each tag filter specified must contain a key with values as optional. Each scaling plan can include up to 50 keys, and each key can include up to 20 values.
             *                   <p>
             *                   Tags are part of the syntax that you use to specify the resources you want returned when configuring a scaling plan from the AWS Auto Scaling console. You do not need to specify valid tag filter values when you create a scaling plan with CloudFormation. The <code>Key</code> and <code>Values</code> properties can accept any value as long as the combination of values is unique across scaling plans. However, if you also want to use the AWS Auto Scaling console to edit the scaling plan, then you must specify valid values.
             *                   <p>
             *                   You must specify either a <code>CloudFormationStackARN</code> or <code>TagFilters</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder tagFilters(java.util.List<? extends java.lang.Object> tagFilters) {
                this.tagFilters = tagFilters;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ApplicationSourceProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ApplicationSourceProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ApplicationSourceProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ApplicationSourceProperty {
            private final java.lang.String cloudFormationStackArn;
            private final java.lang.Object tagFilters;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.cloudFormationStackArn = software.amazon.jsii.Kernel.get(this, "cloudFormationStackArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.tagFilters = software.amazon.jsii.Kernel.get(this, "tagFilters", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.cloudFormationStackArn = builder.cloudFormationStackArn;
                this.tagFilters = builder.tagFilters;
            }

            @Override
            public final java.lang.String getCloudFormationStackArn() {
                return this.cloudFormationStackArn;
            }

            @Override
            public final java.lang.Object getTagFilters() {
                return this.tagFilters;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getCloudFormationStackArn() != null) {
                    data.set("cloudFormationStackArn", om.valueToTree(this.getCloudFormationStackArn()));
                }
                if (this.getTagFilters() != null) {
                    data.set("tagFilters", om.valueToTree(this.getTagFilters()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_autoscalingplans.CfnScalingPlan.ApplicationSourceProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ApplicationSourceProperty.Jsii$Proxy that = (ApplicationSourceProperty.Jsii$Proxy) o;

                if (this.cloudFormationStackArn != null ? !this.cloudFormationStackArn.equals(that.cloudFormationStackArn) : that.cloudFormationStackArn != null) return false;
                return this.tagFilters != null ? this.tagFilters.equals(that.tagFilters) : that.tagFilters == null;
            }

            @Override
            public final int hashCode() {
                int result = this.cloudFormationStackArn != null ? this.cloudFormationStackArn.hashCode() : 0;
                result = 31 * result + (this.tagFilters != null ? this.tagFilters.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * <code>CustomizedLoadMetricSpecification</code> is a subproperty of <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-autoscalingplans-scalingplan-scalinginstruction.html">ScalingInstruction</a> that specifies a customized load metric for predictive scaling to use with a scaling plan.
     * <p>
     * For predictive scaling to work with a customized load metric specification, AWS Auto Scaling needs access to the <code>Sum</code> and <code>Average</code> statistics that CloudWatch computes from metric data.
     * <p>
     * When you choose a load metric, make sure that the required <code>Sum</code> and <code>Average</code> statistics for your metric are available in CloudWatch and that they provide relevant data for predictive scaling. The <code>Sum</code> statistic must represent the total load on the resource, and the <code>Average</code> statistic must represent the average load per capacity unit of the resource. For example, there is a metric that counts the number of requests processed by your Auto Scaling group. If the <code>Sum</code> statistic represents the total request count processed by the group, then the <code>Average</code> statistic for the specified metric must represent the average request count processed by each instance of the group.
     * <p>
     * If you publish your own metrics, you can aggregate the data points at a given interval and then publish the aggregated data points to CloudWatch. Before AWS Auto Scaling generates the forecast, it sums up all the metric data points that occurred within each hour to match the granularity period that is used in the forecast (60 minutes).
     * <p>
     * For information about terminology, available metrics, or how to publish new metrics, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/cloudwatch_concepts.html">Amazon CloudWatch Concepts</a> in the <em>Amazon CloudWatch User Guide</em> .
     * <p>
     * After creating your scaling plan, you can use the AWS Auto Scaling console to visualize forecasts for the specified metric. For more information, see <a href="https://docs.aws.amazon.com/autoscaling/plans/userguide/gs-create-scaling-plan.html#gs-view-resource">View scaling information for a resource</a> in the <em>Scaling Plans User Guide</em> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.autoscalingplans.*;
     * CustomizedLoadMetricSpecificationProperty customizedLoadMetricSpecificationProperty = CustomizedLoadMetricSpecificationProperty.builder()
     *         .metricName("metricName")
     *         .namespace("namespace")
     *         .statistic("statistic")
     *         // the properties below are optional
     *         .dimensions(List.of(MetricDimensionProperty.builder()
     *                 .name("name")
     *                 .value("value")
     *                 .build()))
     *         .unit("unit")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-autoscalingplans-scalingplan-customizedloadmetricspecification.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-autoscalingplans-scalingplan-customizedloadmetricspecification.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_autoscalingplans.CfnScalingPlan.CustomizedLoadMetricSpecificationProperty")
    @software.amazon.jsii.Jsii.Proxy(CustomizedLoadMetricSpecificationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface CustomizedLoadMetricSpecificationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The name of the metric.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-autoscalingplans-scalingplan-customizedloadmetricspecification.html#cfn-autoscalingplans-scalingplan-customizedloadmetricspecification-metricname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-autoscalingplans-scalingplan-customizedloadmetricspecification.html#cfn-autoscalingplans-scalingplan-customizedloadmetricspecification-metricname</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getMetricName();

        /**
         * The namespace of the metric.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-autoscalingplans-scalingplan-customizedloadmetricspecification.html#cfn-autoscalingplans-scalingplan-customizedloadmetricspecification-namespace">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-autoscalingplans-scalingplan-customizedloadmetricspecification.html#cfn-autoscalingplans-scalingplan-customizedloadmetricspecification-namespace</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getNamespace();

        /**
         * The statistic of the metric.
         * <p>
         * <em>Allowed Values</em> : <code>Sum</code>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-autoscalingplans-scalingplan-customizedloadmetricspecification.html#cfn-autoscalingplans-scalingplan-customizedloadmetricspecification-statistic">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-autoscalingplans-scalingplan-customizedloadmetricspecification.html#cfn-autoscalingplans-scalingplan-customizedloadmetricspecification-statistic</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getStatistic();

        /**
         * The dimensions of the metric.
         * <p>
         * Conditional: If you published your metric with dimensions, you must specify the same dimensions in your customized load metric specification.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-autoscalingplans-scalingplan-customizedloadmetricspecification.html#cfn-autoscalingplans-scalingplan-customizedloadmetricspecification-dimensions">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-autoscalingplans-scalingplan-customizedloadmetricspecification.html#cfn-autoscalingplans-scalingplan-customizedloadmetricspecification-dimensions</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getDimensions() {
            return null;
        }

        /**
         * The unit of the metric.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-autoscalingplans-scalingplan-customizedloadmetricspecification.html#cfn-autoscalingplans-scalingplan-customizedloadmetricspecification-unit">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-autoscalingplans-scalingplan-customizedloadmetricspecification.html#cfn-autoscalingplans-scalingplan-customizedloadmetricspecification-unit</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getUnit() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link CustomizedLoadMetricSpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link CustomizedLoadMetricSpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<CustomizedLoadMetricSpecificationProperty> {
            java.lang.String metricName;
            java.lang.String namespace;
            java.lang.String statistic;
            java.lang.Object dimensions;
            java.lang.String unit;

            /**
             * Sets the value of {@link CustomizedLoadMetricSpecificationProperty#getMetricName}
             * @param metricName The name of the metric. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder metricName(java.lang.String metricName) {
                this.metricName = metricName;
                return this;
            }

            /**
             * Sets the value of {@link CustomizedLoadMetricSpecificationProperty#getNamespace}
             * @param namespace The namespace of the metric. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder namespace(java.lang.String namespace) {
                this.namespace = namespace;
                return this;
            }

            /**
             * Sets the value of {@link CustomizedLoadMetricSpecificationProperty#getStatistic}
             * @param statistic The statistic of the metric. This parameter is required.
             *                  <em>Allowed Values</em> : <code>Sum</code>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder statistic(java.lang.String statistic) {
                this.statistic = statistic;
                return this;
            }

            /**
             * Sets the value of {@link CustomizedLoadMetricSpecificationProperty#getDimensions}
             * @param dimensions The dimensions of the metric.
             *                   Conditional: If you published your metric with dimensions, you must specify the same dimensions in your customized load metric specification.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dimensions(software.amazon.awscdk.IResolvable dimensions) {
                this.dimensions = dimensions;
                return this;
            }

            /**
             * Sets the value of {@link CustomizedLoadMetricSpecificationProperty#getDimensions}
             * @param dimensions The dimensions of the metric.
             *                   Conditional: If you published your metric with dimensions, you must specify the same dimensions in your customized load metric specification.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dimensions(java.util.List<? extends java.lang.Object> dimensions) {
                this.dimensions = dimensions;
                return this;
            }

            /**
             * Sets the value of {@link CustomizedLoadMetricSpecificationProperty#getUnit}
             * @param unit The unit of the metric.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder unit(java.lang.String unit) {
                this.unit = unit;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link CustomizedLoadMetricSpecificationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public CustomizedLoadMetricSpecificationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link CustomizedLoadMetricSpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CustomizedLoadMetricSpecificationProperty {
            private final java.lang.String metricName;
            private final java.lang.String namespace;
            private final java.lang.String statistic;
            private final java.lang.Object dimensions;
            private final java.lang.String unit;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.metricName = software.amazon.jsii.Kernel.get(this, "metricName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.namespace = software.amazon.jsii.Kernel.get(this, "namespace", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.statistic = software.amazon.jsii.Kernel.get(this, "statistic", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.dimensions = software.amazon.jsii.Kernel.get(this, "dimensions", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.unit = software.amazon.jsii.Kernel.get(this, "unit", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.metricName = java.util.Objects.requireNonNull(builder.metricName, "metricName is required");
                this.namespace = java.util.Objects.requireNonNull(builder.namespace, "namespace is required");
                this.statistic = java.util.Objects.requireNonNull(builder.statistic, "statistic is required");
                this.dimensions = builder.dimensions;
                this.unit = builder.unit;
            }

            @Override
            public final java.lang.String getMetricName() {
                return this.metricName;
            }

            @Override
            public final java.lang.String getNamespace() {
                return this.namespace;
            }

            @Override
            public final java.lang.String getStatistic() {
                return this.statistic;
            }

            @Override
            public final java.lang.Object getDimensions() {
                return this.dimensions;
            }

            @Override
            public final java.lang.String getUnit() {
                return this.unit;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("metricName", om.valueToTree(this.getMetricName()));
                data.set("namespace", om.valueToTree(this.getNamespace()));
                data.set("statistic", om.valueToTree(this.getStatistic()));
                if (this.getDimensions() != null) {
                    data.set("dimensions", om.valueToTree(this.getDimensions()));
                }
                if (this.getUnit() != null) {
                    data.set("unit", om.valueToTree(this.getUnit()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_autoscalingplans.CfnScalingPlan.CustomizedLoadMetricSpecificationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                CustomizedLoadMetricSpecificationProperty.Jsii$Proxy that = (CustomizedLoadMetricSpecificationProperty.Jsii$Proxy) o;

                if (!metricName.equals(that.metricName)) return false;
                if (!namespace.equals(that.namespace)) return false;
                if (!statistic.equals(that.statistic)) return false;
                if (this.dimensions != null ? !this.dimensions.equals(that.dimensions) : that.dimensions != null) return false;
                return this.unit != null ? this.unit.equals(that.unit) : that.unit == null;
            }

            @Override
            public final int hashCode() {
                int result = this.metricName.hashCode();
                result = 31 * result + (this.namespace.hashCode());
                result = 31 * result + (this.statistic.hashCode());
                result = 31 * result + (this.dimensions != null ? this.dimensions.hashCode() : 0);
                result = 31 * result + (this.unit != null ? this.unit.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * <code>CustomizedScalingMetricSpecification</code> is a subproperty of <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-autoscalingplans-scalingplan-targettrackingconfiguration.html">TargetTrackingConfiguration</a> that specifies a customized scaling metric for a target tracking configuration to use with a scaling plan.
     * <p>
     * To create your customized scaling metric specification:
     * <p>
     * <ul>
     * <li>Add values for each required property from CloudWatch. You can use an existing metric, or a new metric that you create. To use your own metric, you must first publish the metric to CloudWatch. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/publishingMetrics.html">Publish Custom Metrics</a> in the <em>Amazon CloudWatch User Guide</em> .</li>
     * <li>Choose a metric that changes proportionally with capacity. The value of the metric should increase or decrease in inverse proportion to the number of capacity units. That is, the value of the metric should decrease when capacity increases.</li>
     * </ul>
     * <p>
     * For information about terminology, available metrics, or how to publish new metrics, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/cloudwatch_concepts.html">Amazon CloudWatch Concepts</a> in the <em>Amazon CloudWatch User Guide</em> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.autoscalingplans.*;
     * CustomizedScalingMetricSpecificationProperty customizedScalingMetricSpecificationProperty = CustomizedScalingMetricSpecificationProperty.builder()
     *         .metricName("metricName")
     *         .namespace("namespace")
     *         .statistic("statistic")
     *         // the properties below are optional
     *         .dimensions(List.of(MetricDimensionProperty.builder()
     *                 .name("name")
     *                 .value("value")
     *                 .build()))
     *         .unit("unit")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-autoscalingplans-scalingplan-customizedscalingmetricspecification.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-autoscalingplans-scalingplan-customizedscalingmetricspecification.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_autoscalingplans.CfnScalingPlan.CustomizedScalingMetricSpecificationProperty")
    @software.amazon.jsii.Jsii.Proxy(CustomizedScalingMetricSpecificationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface CustomizedScalingMetricSpecificationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The name of the metric.
         * <p>
         * To get the exact metric name, namespace, and dimensions, inspect the <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/APIReference/API_Metric.html">Metrics</a> object that is returned by a call to <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/APIReference/API_ListMetrics.html">ListMetrics</a> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-autoscalingplans-scalingplan-customizedscalingmetricspecification.html#cfn-autoscalingplans-scalingplan-customizedscalingmetricspecification-metricname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-autoscalingplans-scalingplan-customizedscalingmetricspecification.html#cfn-autoscalingplans-scalingplan-customizedscalingmetricspecification-metricname</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getMetricName();

        /**
         * The namespace of the metric.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-autoscalingplans-scalingplan-customizedscalingmetricspecification.html#cfn-autoscalingplans-scalingplan-customizedscalingmetricspecification-namespace">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-autoscalingplans-scalingplan-customizedscalingmetricspecification.html#cfn-autoscalingplans-scalingplan-customizedscalingmetricspecification-namespace</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getNamespace();

        /**
         * The statistic of the metric.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-autoscalingplans-scalingplan-customizedscalingmetricspecification.html#cfn-autoscalingplans-scalingplan-customizedscalingmetricspecification-statistic">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-autoscalingplans-scalingplan-customizedscalingmetricspecification.html#cfn-autoscalingplans-scalingplan-customizedscalingmetricspecification-statistic</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getStatistic();

        /**
         * The dimensions of the metric.
         * <p>
         * Conditional: If you published your metric with dimensions, you must specify the same dimensions in your scaling policy.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-autoscalingplans-scalingplan-customizedscalingmetricspecification.html#cfn-autoscalingplans-scalingplan-customizedscalingmetricspecification-dimensions">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-autoscalingplans-scalingplan-customizedscalingmetricspecification.html#cfn-autoscalingplans-scalingplan-customizedscalingmetricspecification-dimensions</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getDimensions() {
            return null;
        }

        /**
         * The unit of the metric.
         * <p>
         * For a complete list of the units that CloudWatch supports, see the <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/APIReference/API_MetricDatum.html">MetricDatum</a> data type in the <em>Amazon CloudWatch API Reference</em> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-autoscalingplans-scalingplan-customizedscalingmetricspecification.html#cfn-autoscalingplans-scalingplan-customizedscalingmetricspecification-unit">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-autoscalingplans-scalingplan-customizedscalingmetricspecification.html#cfn-autoscalingplans-scalingplan-customizedscalingmetricspecification-unit</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getUnit() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link CustomizedScalingMetricSpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link CustomizedScalingMetricSpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<CustomizedScalingMetricSpecificationProperty> {
            java.lang.String metricName;
            java.lang.String namespace;
            java.lang.String statistic;
            java.lang.Object dimensions;
            java.lang.String unit;

            /**
             * Sets the value of {@link CustomizedScalingMetricSpecificationProperty#getMetricName}
             * @param metricName The name of the metric. This parameter is required.
             *                   To get the exact metric name, namespace, and dimensions, inspect the <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/APIReference/API_Metric.html">Metrics</a> object that is returned by a call to <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/APIReference/API_ListMetrics.html">ListMetrics</a> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder metricName(java.lang.String metricName) {
                this.metricName = metricName;
                return this;
            }

            /**
             * Sets the value of {@link CustomizedScalingMetricSpecificationProperty#getNamespace}
             * @param namespace The namespace of the metric. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder namespace(java.lang.String namespace) {
                this.namespace = namespace;
                return this;
            }

            /**
             * Sets the value of {@link CustomizedScalingMetricSpecificationProperty#getStatistic}
             * @param statistic The statistic of the metric. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder statistic(java.lang.String statistic) {
                this.statistic = statistic;
                return this;
            }

            /**
             * Sets the value of {@link CustomizedScalingMetricSpecificationProperty#getDimensions}
             * @param dimensions The dimensions of the metric.
             *                   Conditional: If you published your metric with dimensions, you must specify the same dimensions in your scaling policy.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dimensions(software.amazon.awscdk.IResolvable dimensions) {
                this.dimensions = dimensions;
                return this;
            }

            /**
             * Sets the value of {@link CustomizedScalingMetricSpecificationProperty#getDimensions}
             * @param dimensions The dimensions of the metric.
             *                   Conditional: If you published your metric with dimensions, you must specify the same dimensions in your scaling policy.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dimensions(java.util.List<? extends java.lang.Object> dimensions) {
                this.dimensions = dimensions;
                return this;
            }

            /**
             * Sets the value of {@link CustomizedScalingMetricSpecificationProperty#getUnit}
             * @param unit The unit of the metric.
             *             For a complete list of the units that CloudWatch supports, see the <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/APIReference/API_MetricDatum.html">MetricDatum</a> data type in the <em>Amazon CloudWatch API Reference</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder unit(java.lang.String unit) {
                this.unit = unit;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link CustomizedScalingMetricSpecificationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public CustomizedScalingMetricSpecificationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link CustomizedScalingMetricSpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CustomizedScalingMetricSpecificationProperty {
            private final java.lang.String metricName;
            private final java.lang.String namespace;
            private final java.lang.String statistic;
            private final java.lang.Object dimensions;
            private final java.lang.String unit;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.metricName = software.amazon.jsii.Kernel.get(this, "metricName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.namespace = software.amazon.jsii.Kernel.get(this, "namespace", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.statistic = software.amazon.jsii.Kernel.get(this, "statistic", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.dimensions = software.amazon.jsii.Kernel.get(this, "dimensions", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.unit = software.amazon.jsii.Kernel.get(this, "unit", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.metricName = java.util.Objects.requireNonNull(builder.metricName, "metricName is required");
                this.namespace = java.util.Objects.requireNonNull(builder.namespace, "namespace is required");
                this.statistic = java.util.Objects.requireNonNull(builder.statistic, "statistic is required");
                this.dimensions = builder.dimensions;
                this.unit = builder.unit;
            }

            @Override
            public final java.lang.String getMetricName() {
                return this.metricName;
            }

            @Override
            public final java.lang.String getNamespace() {
                return this.namespace;
            }

            @Override
            public final java.lang.String getStatistic() {
                return this.statistic;
            }

            @Override
            public final java.lang.Object getDimensions() {
                return this.dimensions;
            }

            @Override
            public final java.lang.String getUnit() {
                return this.unit;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("metricName", om.valueToTree(this.getMetricName()));
                data.set("namespace", om.valueToTree(this.getNamespace()));
                data.set("statistic", om.valueToTree(this.getStatistic()));
                if (this.getDimensions() != null) {
                    data.set("dimensions", om.valueToTree(this.getDimensions()));
                }
                if (this.getUnit() != null) {
                    data.set("unit", om.valueToTree(this.getUnit()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_autoscalingplans.CfnScalingPlan.CustomizedScalingMetricSpecificationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                CustomizedScalingMetricSpecificationProperty.Jsii$Proxy that = (CustomizedScalingMetricSpecificationProperty.Jsii$Proxy) o;

                if (!metricName.equals(that.metricName)) return false;
                if (!namespace.equals(that.namespace)) return false;
                if (!statistic.equals(that.statistic)) return false;
                if (this.dimensions != null ? !this.dimensions.equals(that.dimensions) : that.dimensions != null) return false;
                return this.unit != null ? this.unit.equals(that.unit) : that.unit == null;
            }

            @Override
            public final int hashCode() {
                int result = this.metricName.hashCode();
                result = 31 * result + (this.namespace.hashCode());
                result = 31 * result + (this.statistic.hashCode());
                result = 31 * result + (this.dimensions != null ? this.dimensions.hashCode() : 0);
                result = 31 * result + (this.unit != null ? this.unit.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * <code>MetricDimension</code> is a subproperty of <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-autoscalingplans-scalingplan-customizedscalingmetricspecification.html">CustomizedScalingMetricSpecification</a> that specifies a dimension for a customized metric to use with a scaling plan. Dimensions are arbitrary name/value pairs that can be associated with a CloudWatch metric. Duplicate dimensions are not allowed.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.autoscalingplans.*;
     * MetricDimensionProperty metricDimensionProperty = MetricDimensionProperty.builder()
     *         .name("name")
     *         .value("value")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-autoscalingplans-scalingplan-metricdimension.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-autoscalingplans-scalingplan-metricdimension.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_autoscalingplans.CfnScalingPlan.MetricDimensionProperty")
    @software.amazon.jsii.Jsii.Proxy(MetricDimensionProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface MetricDimensionProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The name of the dimension.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-autoscalingplans-scalingplan-metricdimension.html#cfn-autoscalingplans-scalingplan-metricdimension-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-autoscalingplans-scalingplan-metricdimension.html#cfn-autoscalingplans-scalingplan-metricdimension-name</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getName();

        /**
         * The value of the dimension.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-autoscalingplans-scalingplan-metricdimension.html#cfn-autoscalingplans-scalingplan-metricdimension-value">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-autoscalingplans-scalingplan-metricdimension.html#cfn-autoscalingplans-scalingplan-metricdimension-value</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getValue();

        /**
         * @return a {@link Builder} of {@link MetricDimensionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link MetricDimensionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<MetricDimensionProperty> {
            java.lang.String name;
            java.lang.String value;

            /**
             * Sets the value of {@link MetricDimensionProperty#getName}
             * @param name The name of the dimension. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder name(java.lang.String name) {
                this.name = name;
                return this;
            }

            /**
             * Sets the value of {@link MetricDimensionProperty#getValue}
             * @param value The value of the dimension. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder value(java.lang.String value) {
                this.value = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link MetricDimensionProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public MetricDimensionProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link MetricDimensionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements MetricDimensionProperty {
            private final java.lang.String name;
            private final java.lang.String value;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.value = software.amazon.jsii.Kernel.get(this, "value", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.name = java.util.Objects.requireNonNull(builder.name, "name is required");
                this.value = java.util.Objects.requireNonNull(builder.value, "value is required");
            }

            @Override
            public final java.lang.String getName() {
                return this.name;
            }

            @Override
            public final java.lang.String getValue() {
                return this.value;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("name", om.valueToTree(this.getName()));
                data.set("value", om.valueToTree(this.getValue()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_autoscalingplans.CfnScalingPlan.MetricDimensionProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                MetricDimensionProperty.Jsii$Proxy that = (MetricDimensionProperty.Jsii$Proxy) o;

                if (!name.equals(that.name)) return false;
                return this.value.equals(that.value);
            }

            @Override
            public final int hashCode() {
                int result = this.name.hashCode();
                result = 31 * result + (this.value.hashCode());
                return result;
            }
        }
    }
    /**
     * <code>PredefinedLoadMetricSpecification</code> is a subproperty of <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-autoscalingplans-scalingplan-scalinginstruction.html">ScalingInstruction</a> that specifies a predefined load metric for predictive scaling to use with a scaling plan.
     * <p>
     * After creating your scaling plan, you can use the AWS Auto Scaling console to visualize forecasts for the specified metric. For more information, see <a href="https://docs.aws.amazon.com/autoscaling/plans/userguide/gs-create-scaling-plan.html#gs-view-resource">View scaling information for a resource</a> in the <em>Scaling Plans User Guide</em> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.autoscalingplans.*;
     * PredefinedLoadMetricSpecificationProperty predefinedLoadMetricSpecificationProperty = PredefinedLoadMetricSpecificationProperty.builder()
     *         .predefinedLoadMetricType("predefinedLoadMetricType")
     *         // the properties below are optional
     *         .resourceLabel("resourceLabel")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-autoscalingplans-scalingplan-predefinedloadmetricspecification.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-autoscalingplans-scalingplan-predefinedloadmetricspecification.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_autoscalingplans.CfnScalingPlan.PredefinedLoadMetricSpecificationProperty")
    @software.amazon.jsii.Jsii.Proxy(PredefinedLoadMetricSpecificationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface PredefinedLoadMetricSpecificationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The metric type.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-autoscalingplans-scalingplan-predefinedloadmetricspecification.html#cfn-autoscalingplans-scalingplan-predefinedloadmetricspecification-predefinedloadmetrictype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-autoscalingplans-scalingplan-predefinedloadmetricspecification.html#cfn-autoscalingplans-scalingplan-predefinedloadmetricspecification-predefinedloadmetrictype</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getPredefinedLoadMetricType();

        /**
         * Identifies the resource associated with the metric type.
         * <p>
         * You can't specify a resource label unless the metric type is <code>ALBTargetGroupRequestCount</code> and there is a target group for an Application Load Balancer attached to the Auto Scaling group.
         * <p>
         * You create the resource label by appending the final portion of the load balancer ARN and the final portion of the target group ARN into a single value, separated by a forward slash (/). The format is app/<load-balancer-name>/<load-balancer-id>/targetgroup/<target-group-name>/<target-group-id>, where:
         * <p>
         * <ul>
         * <li>app/<load-balancer-name>/<load-balancer-id> is the final portion of the load balancer ARN</li>
         * <li>targetgroup/<target-group-name>/<target-group-id> is the final portion of the target group ARN.</li>
         * </ul>
         * <p>
         * This is an example: app/EC2Co-EcsEl-1TKLTMITMM0EO/f37c06a68c1748aa/targetgroup/EC2Co-Defau-LDNM7Q3ZH1ZN/6d4ea56ca2d6a18d.
         * <p>
         * To find the ARN for an Application Load Balancer, use the <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/APIReference/API_DescribeLoadBalancers.html">DescribeLoadBalancers</a> API operation. To find the ARN for the target group, use the <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/APIReference/API_DescribeTargetGroups.html">DescribeTargetGroups</a> API operation.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-autoscalingplans-scalingplan-predefinedloadmetricspecification.html#cfn-autoscalingplans-scalingplan-predefinedloadmetricspecification-resourcelabel">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-autoscalingplans-scalingplan-predefinedloadmetricspecification.html#cfn-autoscalingplans-scalingplan-predefinedloadmetricspecification-resourcelabel</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getResourceLabel() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link PredefinedLoadMetricSpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link PredefinedLoadMetricSpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<PredefinedLoadMetricSpecificationProperty> {
            java.lang.String predefinedLoadMetricType;
            java.lang.String resourceLabel;

            /**
             * Sets the value of {@link PredefinedLoadMetricSpecificationProperty#getPredefinedLoadMetricType}
             * @param predefinedLoadMetricType The metric type. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder predefinedLoadMetricType(java.lang.String predefinedLoadMetricType) {
                this.predefinedLoadMetricType = predefinedLoadMetricType;
                return this;
            }

            /**
             * Sets the value of {@link PredefinedLoadMetricSpecificationProperty#getResourceLabel}
             * @param resourceLabel Identifies the resource associated with the metric type.
             *                      You can't specify a resource label unless the metric type is <code>ALBTargetGroupRequestCount</code> and there is a target group for an Application Load Balancer attached to the Auto Scaling group.
             *                      <p>
             *                      You create the resource label by appending the final portion of the load balancer ARN and the final portion of the target group ARN into a single value, separated by a forward slash (/). The format is app/<load-balancer-name>/<load-balancer-id>/targetgroup/<target-group-name>/<target-group-id>, where:
             *                      <p>
             *                      <ul>
             *                      <li>app/<load-balancer-name>/<load-balancer-id> is the final portion of the load balancer ARN</li>
             *                      <li>targetgroup/<target-group-name>/<target-group-id> is the final portion of the target group ARN.</li>
             *                      </ul>
             *                      <p>
             *                      This is an example: app/EC2Co-EcsEl-1TKLTMITMM0EO/f37c06a68c1748aa/targetgroup/EC2Co-Defau-LDNM7Q3ZH1ZN/6d4ea56ca2d6a18d.
             *                      <p>
             *                      To find the ARN for an Application Load Balancer, use the <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/APIReference/API_DescribeLoadBalancers.html">DescribeLoadBalancers</a> API operation. To find the ARN for the target group, use the <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/APIReference/API_DescribeTargetGroups.html">DescribeTargetGroups</a> API operation.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder resourceLabel(java.lang.String resourceLabel) {
                this.resourceLabel = resourceLabel;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link PredefinedLoadMetricSpecificationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public PredefinedLoadMetricSpecificationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link PredefinedLoadMetricSpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements PredefinedLoadMetricSpecificationProperty {
            private final java.lang.String predefinedLoadMetricType;
            private final java.lang.String resourceLabel;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.predefinedLoadMetricType = software.amazon.jsii.Kernel.get(this, "predefinedLoadMetricType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.resourceLabel = software.amazon.jsii.Kernel.get(this, "resourceLabel", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.predefinedLoadMetricType = java.util.Objects.requireNonNull(builder.predefinedLoadMetricType, "predefinedLoadMetricType is required");
                this.resourceLabel = builder.resourceLabel;
            }

            @Override
            public final java.lang.String getPredefinedLoadMetricType() {
                return this.predefinedLoadMetricType;
            }

            @Override
            public final java.lang.String getResourceLabel() {
                return this.resourceLabel;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("predefinedLoadMetricType", om.valueToTree(this.getPredefinedLoadMetricType()));
                if (this.getResourceLabel() != null) {
                    data.set("resourceLabel", om.valueToTree(this.getResourceLabel()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_autoscalingplans.CfnScalingPlan.PredefinedLoadMetricSpecificationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                PredefinedLoadMetricSpecificationProperty.Jsii$Proxy that = (PredefinedLoadMetricSpecificationProperty.Jsii$Proxy) o;

                if (!predefinedLoadMetricType.equals(that.predefinedLoadMetricType)) return false;
                return this.resourceLabel != null ? this.resourceLabel.equals(that.resourceLabel) : that.resourceLabel == null;
            }

            @Override
            public final int hashCode() {
                int result = this.predefinedLoadMetricType.hashCode();
                result = 31 * result + (this.resourceLabel != null ? this.resourceLabel.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * <code>PredefinedScalingMetricSpecification</code> is a subproperty of <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-autoscalingplans-scalingplan-targettrackingconfiguration.html">TargetTrackingConfiguration</a> that specifies a customized scaling metric for a target tracking configuration to use with a scaling plan.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.autoscalingplans.*;
     * PredefinedScalingMetricSpecificationProperty predefinedScalingMetricSpecificationProperty = PredefinedScalingMetricSpecificationProperty.builder()
     *         .predefinedScalingMetricType("predefinedScalingMetricType")
     *         // the properties below are optional
     *         .resourceLabel("resourceLabel")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-autoscalingplans-scalingplan-predefinedscalingmetricspecification.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-autoscalingplans-scalingplan-predefinedscalingmetricspecification.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_autoscalingplans.CfnScalingPlan.PredefinedScalingMetricSpecificationProperty")
    @software.amazon.jsii.Jsii.Proxy(PredefinedScalingMetricSpecificationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface PredefinedScalingMetricSpecificationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The metric type.
         * <p>
         * The <code>ALBRequestCountPerTarget</code> metric type applies only to Auto Scaling groups, Spot Fleet requests, and ECS services.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-autoscalingplans-scalingplan-predefinedscalingmetricspecification.html#cfn-autoscalingplans-scalingplan-predefinedscalingmetricspecification-predefinedscalingmetrictype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-autoscalingplans-scalingplan-predefinedscalingmetricspecification.html#cfn-autoscalingplans-scalingplan-predefinedscalingmetricspecification-predefinedscalingmetrictype</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getPredefinedScalingMetricType();

        /**
         * Identifies the resource associated with the metric type.
         * <p>
         * You can't specify a resource label unless the metric type is <code>ALBRequestCountPerTarget</code> and there is a target group for an Application Load Balancer attached to the Auto Scaling group, Spot Fleet request, or ECS service.
         * <p>
         * You create the resource label by appending the final portion of the load balancer ARN and the final portion of the target group ARN into a single value, separated by a forward slash (/). The format is app/<load-balancer-name>/<load-balancer-id>/targetgroup/<target-group-name>/<target-group-id>, where:
         * <p>
         * <ul>
         * <li>app/<load-balancer-name>/<load-balancer-id> is the final portion of the load balancer ARN</li>
         * <li>targetgroup/<target-group-name>/<target-group-id> is the final portion of the target group ARN.</li>
         * </ul>
         * <p>
         * This is an example: app/EC2Co-EcsEl-1TKLTMITMM0EO/f37c06a68c1748aa/targetgroup/EC2Co-Defau-LDNM7Q3ZH1ZN/6d4ea56ca2d6a18d.
         * <p>
         * To find the ARN for an Application Load Balancer, use the <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/APIReference/API_DescribeLoadBalancers.html">DescribeLoadBalancers</a> API operation. To find the ARN for the target group, use the <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/APIReference/API_DescribeTargetGroups.html">DescribeTargetGroups</a> API operation.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-autoscalingplans-scalingplan-predefinedscalingmetricspecification.html#cfn-autoscalingplans-scalingplan-predefinedscalingmetricspecification-resourcelabel">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-autoscalingplans-scalingplan-predefinedscalingmetricspecification.html#cfn-autoscalingplans-scalingplan-predefinedscalingmetricspecification-resourcelabel</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getResourceLabel() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link PredefinedScalingMetricSpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link PredefinedScalingMetricSpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<PredefinedScalingMetricSpecificationProperty> {
            java.lang.String predefinedScalingMetricType;
            java.lang.String resourceLabel;

            /**
             * Sets the value of {@link PredefinedScalingMetricSpecificationProperty#getPredefinedScalingMetricType}
             * @param predefinedScalingMetricType The metric type. This parameter is required.
             *                                    The <code>ALBRequestCountPerTarget</code> metric type applies only to Auto Scaling groups, Spot Fleet requests, and ECS services.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder predefinedScalingMetricType(java.lang.String predefinedScalingMetricType) {
                this.predefinedScalingMetricType = predefinedScalingMetricType;
                return this;
            }

            /**
             * Sets the value of {@link PredefinedScalingMetricSpecificationProperty#getResourceLabel}
             * @param resourceLabel Identifies the resource associated with the metric type.
             *                      You can't specify a resource label unless the metric type is <code>ALBRequestCountPerTarget</code> and there is a target group for an Application Load Balancer attached to the Auto Scaling group, Spot Fleet request, or ECS service.
             *                      <p>
             *                      You create the resource label by appending the final portion of the load balancer ARN and the final portion of the target group ARN into a single value, separated by a forward slash (/). The format is app/<load-balancer-name>/<load-balancer-id>/targetgroup/<target-group-name>/<target-group-id>, where:
             *                      <p>
             *                      <ul>
             *                      <li>app/<load-balancer-name>/<load-balancer-id> is the final portion of the load balancer ARN</li>
             *                      <li>targetgroup/<target-group-name>/<target-group-id> is the final portion of the target group ARN.</li>
             *                      </ul>
             *                      <p>
             *                      This is an example: app/EC2Co-EcsEl-1TKLTMITMM0EO/f37c06a68c1748aa/targetgroup/EC2Co-Defau-LDNM7Q3ZH1ZN/6d4ea56ca2d6a18d.
             *                      <p>
             *                      To find the ARN for an Application Load Balancer, use the <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/APIReference/API_DescribeLoadBalancers.html">DescribeLoadBalancers</a> API operation. To find the ARN for the target group, use the <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/APIReference/API_DescribeTargetGroups.html">DescribeTargetGroups</a> API operation.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder resourceLabel(java.lang.String resourceLabel) {
                this.resourceLabel = resourceLabel;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link PredefinedScalingMetricSpecificationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public PredefinedScalingMetricSpecificationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link PredefinedScalingMetricSpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements PredefinedScalingMetricSpecificationProperty {
            private final java.lang.String predefinedScalingMetricType;
            private final java.lang.String resourceLabel;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.predefinedScalingMetricType = software.amazon.jsii.Kernel.get(this, "predefinedScalingMetricType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.resourceLabel = software.amazon.jsii.Kernel.get(this, "resourceLabel", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.predefinedScalingMetricType = java.util.Objects.requireNonNull(builder.predefinedScalingMetricType, "predefinedScalingMetricType is required");
                this.resourceLabel = builder.resourceLabel;
            }

            @Override
            public final java.lang.String getPredefinedScalingMetricType() {
                return this.predefinedScalingMetricType;
            }

            @Override
            public final java.lang.String getResourceLabel() {
                return this.resourceLabel;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("predefinedScalingMetricType", om.valueToTree(this.getPredefinedScalingMetricType()));
                if (this.getResourceLabel() != null) {
                    data.set("resourceLabel", om.valueToTree(this.getResourceLabel()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_autoscalingplans.CfnScalingPlan.PredefinedScalingMetricSpecificationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                PredefinedScalingMetricSpecificationProperty.Jsii$Proxy that = (PredefinedScalingMetricSpecificationProperty.Jsii$Proxy) o;

                if (!predefinedScalingMetricType.equals(that.predefinedScalingMetricType)) return false;
                return this.resourceLabel != null ? this.resourceLabel.equals(that.resourceLabel) : that.resourceLabel == null;
            }

            @Override
            public final int hashCode() {
                int result = this.predefinedScalingMetricType.hashCode();
                result = 31 * result + (this.resourceLabel != null ? this.resourceLabel.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * <code>ScalingInstruction</code> is a property of <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-autoscalingplans-scalingplan.html">ScalingPlan</a> that specifies the scaling instruction for a scalable resource in a scaling plan. Each scaling instruction applies to one resource.
     * <p>
     * AWS Auto Scaling creates target tracking scaling policies based on the scaling instructions. Target tracking scaling policies adjust the capacity of your scalable resource as required to maintain resource utilization at the target value that you specified.
     * <p>
     * AWS Auto Scaling also configures predictive scaling for your Amazon EC2 Auto Scaling groups using a subset of properties, including the load metric, the scaling metric, the target value for the scaling metric, the predictive scaling mode (forecast and scale or forecast only), and the desired behavior when the forecast capacity exceeds the maximum capacity of the resource. With predictive scaling, AWS Auto Scaling generates forecasts with traffic predictions for the two days ahead and schedules scaling actions that proactively add and remove resource capacity to match the forecast.
     * <p>
     * <blockquote>
     * <p>
     * We recommend waiting a minimum of 24 hours after creating an Auto Scaling group to configure predictive scaling. At minimum, there must be 24 hours of historical data to generate a forecast. For more information, see <a href="https://docs.aws.amazon.com/autoscaling/plans/userguide/gs-best-practices.html">Best practices for scaling plans</a> in the <em>Scaling Plans User Guide</em> .
     * <p>
     * </blockquote>
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.autoscalingplans.*;
     * ScalingInstructionProperty scalingInstructionProperty = ScalingInstructionProperty.builder()
     *         .maxCapacity(123)
     *         .minCapacity(123)
     *         .resourceId("resourceId")
     *         .scalableDimension("scalableDimension")
     *         .serviceNamespace("serviceNamespace")
     *         .targetTrackingConfigurations(List.of(TargetTrackingConfigurationProperty.builder()
     *                 .targetValue(123)
     *                 // the properties below are optional
     *                 .customizedScalingMetricSpecification(CustomizedScalingMetricSpecificationProperty.builder()
     *                         .metricName("metricName")
     *                         .namespace("namespace")
     *                         .statistic("statistic")
     *                         // the properties below are optional
     *                         .dimensions(List.of(MetricDimensionProperty.builder()
     *                                 .name("name")
     *                                 .value("value")
     *                                 .build()))
     *                         .unit("unit")
     *                         .build())
     *                 .disableScaleIn(false)
     *                 .estimatedInstanceWarmup(123)
     *                 .predefinedScalingMetricSpecification(PredefinedScalingMetricSpecificationProperty.builder()
     *                         .predefinedScalingMetricType("predefinedScalingMetricType")
     *                         // the properties below are optional
     *                         .resourceLabel("resourceLabel")
     *                         .build())
     *                 .scaleInCooldown(123)
     *                 .scaleOutCooldown(123)
     *                 .build()))
     *         // the properties below are optional
     *         .customizedLoadMetricSpecification(CustomizedLoadMetricSpecificationProperty.builder()
     *                 .metricName("metricName")
     *                 .namespace("namespace")
     *                 .statistic("statistic")
     *                 // the properties below are optional
     *                 .dimensions(List.of(MetricDimensionProperty.builder()
     *                         .name("name")
     *                         .value("value")
     *                         .build()))
     *                 .unit("unit")
     *                 .build())
     *         .disableDynamicScaling(false)
     *         .predefinedLoadMetricSpecification(PredefinedLoadMetricSpecificationProperty.builder()
     *                 .predefinedLoadMetricType("predefinedLoadMetricType")
     *                 // the properties below are optional
     *                 .resourceLabel("resourceLabel")
     *                 .build())
     *         .predictiveScalingMaxCapacityBehavior("predictiveScalingMaxCapacityBehavior")
     *         .predictiveScalingMaxCapacityBuffer(123)
     *         .predictiveScalingMode("predictiveScalingMode")
     *         .scalingPolicyUpdateBehavior("scalingPolicyUpdateBehavior")
     *         .scheduledActionBufferTime(123)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-autoscalingplans-scalingplan-scalinginstruction.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-autoscalingplans-scalingplan-scalinginstruction.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_autoscalingplans.CfnScalingPlan.ScalingInstructionProperty")
    @software.amazon.jsii.Jsii.Proxy(ScalingInstructionProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ScalingInstructionProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The maximum capacity of the resource.
         * <p>
         * The exception to this upper limit is if you specify a non-default setting for <em>PredictiveScalingMaxCapacityBehavior</em> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-autoscalingplans-scalingplan-scalinginstruction.html#cfn-autoscalingplans-scalingplan-scalinginstruction-maxcapacity">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-autoscalingplans-scalingplan-scalinginstruction.html#cfn-autoscalingplans-scalingplan-scalinginstruction-maxcapacity</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Number getMaxCapacity();

        /**
         * The minimum capacity of the resource.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-autoscalingplans-scalingplan-scalinginstruction.html#cfn-autoscalingplans-scalingplan-scalinginstruction-mincapacity">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-autoscalingplans-scalingplan-scalinginstruction.html#cfn-autoscalingplans-scalingplan-scalinginstruction-mincapacity</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Number getMinCapacity();

        /**
         * The ID of the resource. This string consists of the resource type and unique identifier.
         * <p>
         * <ul>
         * <li>Auto Scaling group - The resource type is <code>autoScalingGroup</code> and the unique identifier is the name of the Auto Scaling group. Example: <code>autoScalingGroup/my-asg</code> .</li>
         * <li>ECS service - The resource type is <code>service</code> and the unique identifier is the cluster name and service name. Example: <code>service/default/sample-webapp</code> .</li>
         * <li>Spot Fleet request - The resource type is <code>spot-fleet-request</code> and the unique identifier is the Spot Fleet request ID. Example: <code>spot-fleet-request/sfr-73fbd2ce-aa30-494c-8788-1cee4EXAMPLE</code> .</li>
         * <li>DynamoDB table - The resource type is <code>table</code> and the unique identifier is the resource ID. Example: <code>table/my-table</code> .</li>
         * <li>DynamoDB global secondary index - The resource type is <code>index</code> and the unique identifier is the resource ID. Example: <code>table/my-table/index/my-table-index</code> .</li>
         * <li>Aurora DB cluster - The resource type is <code>cluster</code> and the unique identifier is the cluster name. Example: <code>cluster:my-db-cluster</code> .</li>
         * </ul>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-autoscalingplans-scalingplan-scalinginstruction.html#cfn-autoscalingplans-scalingplan-scalinginstruction-resourceid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-autoscalingplans-scalingplan-scalinginstruction.html#cfn-autoscalingplans-scalingplan-scalinginstruction-resourceid</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getResourceId();

        /**
         * The scalable dimension associated with the resource.
         * <p>
         * <ul>
         * <li><code>autoscaling:autoScalingGroup:DesiredCapacity</code> - The desired capacity of an Auto Scaling group.</li>
         * <li><code>ecs:service:DesiredCount</code> - The desired task count of an ECS service.</li>
         * <li><code>ec2:spot-fleet-request:TargetCapacity</code> - The target capacity of a Spot Fleet request.</li>
         * <li><code>dynamodb:table:ReadCapacityUnits</code> - The provisioned read capacity for a DynamoDB table.</li>
         * <li><code>dynamodb:table:WriteCapacityUnits</code> - The provisioned write capacity for a DynamoDB table.</li>
         * <li><code>dynamodb:index:ReadCapacityUnits</code> - The provisioned read capacity for a DynamoDB global secondary index.</li>
         * <li><code>dynamodb:index:WriteCapacityUnits</code> - The provisioned write capacity for a DynamoDB global secondary index.</li>
         * <li><code>rds:cluster:ReadReplicaCount</code> - The count of Aurora Replicas in an Aurora DB cluster. Available for Aurora MySQL-compatible edition and Aurora PostgreSQL-compatible edition.</li>
         * </ul>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-autoscalingplans-scalingplan-scalinginstruction.html#cfn-autoscalingplans-scalingplan-scalinginstruction-scalabledimension">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-autoscalingplans-scalingplan-scalinginstruction.html#cfn-autoscalingplans-scalingplan-scalinginstruction-scalabledimension</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getScalableDimension();

        /**
         * The namespace of the AWS service.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-autoscalingplans-scalingplan-scalinginstruction.html#cfn-autoscalingplans-scalingplan-scalinginstruction-servicenamespace">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-autoscalingplans-scalingplan-scalinginstruction.html#cfn-autoscalingplans-scalingplan-scalinginstruction-servicenamespace</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getServiceNamespace();

        /**
         * The target tracking configurations (up to 10).
         * <p>
         * Each of these structures must specify a unique scaling metric and a target value for the metric.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-autoscalingplans-scalingplan-scalinginstruction.html#cfn-autoscalingplans-scalingplan-scalinginstruction-targettrackingconfigurations">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-autoscalingplans-scalingplan-scalinginstruction.html#cfn-autoscalingplans-scalingplan-scalinginstruction-targettrackingconfigurations</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getTargetTrackingConfigurations();

        /**
         * The customized load metric to use for predictive scaling.
         * <p>
         * This property or a <em>PredefinedLoadMetricSpecification</em> is required when configuring predictive scaling, and cannot be used otherwise.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-autoscalingplans-scalingplan-scalinginstruction.html#cfn-autoscalingplans-scalingplan-scalinginstruction-customizedloadmetricspecification">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-autoscalingplans-scalingplan-scalinginstruction.html#cfn-autoscalingplans-scalingplan-scalinginstruction-customizedloadmetricspecification</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getCustomizedLoadMetricSpecification() {
            return null;
        }

        /**
         * Controls whether dynamic scaling is disabled.
         * <p>
         * When dynamic scaling is enabled, AWS Auto Scaling creates target tracking scaling policies based on the specified target tracking configurations.
         * <p>
         * The default is enabled ( <code>false</code> ).
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-autoscalingplans-scalingplan-scalinginstruction.html#cfn-autoscalingplans-scalingplan-scalinginstruction-disabledynamicscaling">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-autoscalingplans-scalingplan-scalinginstruction.html#cfn-autoscalingplans-scalingplan-scalinginstruction-disabledynamicscaling</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getDisableDynamicScaling() {
            return null;
        }

        /**
         * The predefined load metric to use for predictive scaling.
         * <p>
         * This property or a <em>CustomizedLoadMetricSpecification</em> is required when configuring predictive scaling, and cannot be used otherwise.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-autoscalingplans-scalingplan-scalinginstruction.html#cfn-autoscalingplans-scalingplan-scalinginstruction-predefinedloadmetricspecification">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-autoscalingplans-scalingplan-scalinginstruction.html#cfn-autoscalingplans-scalingplan-scalinginstruction-predefinedloadmetricspecification</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getPredefinedLoadMetricSpecification() {
            return null;
        }

        /**
         * Defines the behavior that should be applied if the forecast capacity approaches or exceeds the maximum capacity specified for the resource.
         * <p>
         * The default value is <code>SetForecastCapacityToMaxCapacity</code> .
         * <p>
         * The following are possible values:
         * <p>
         * <ul>
         * <li><code>SetForecastCapacityToMaxCapacity</code> - AWS Auto Scaling cannot scale resource capacity higher than the maximum capacity. The maximum capacity is enforced as a hard limit.</li>
         * <li><code>SetMaxCapacityToForecastCapacity</code> - AWS Auto Scaling can scale resource capacity higher than the maximum capacity to equal but not exceed forecast capacity.</li>
         * <li><code>SetMaxCapacityAboveForecastCapacity</code> - AWS Auto Scaling can scale resource capacity higher than the maximum capacity by a specified buffer value. The intention is to give the target tracking scaling policy extra capacity if unexpected traffic occurs.</li>
         * </ul>
         * <p>
         * Valid only when configuring predictive scaling.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-autoscalingplans-scalingplan-scalinginstruction.html#cfn-autoscalingplans-scalingplan-scalinginstruction-predictivescalingmaxcapacitybehavior">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-autoscalingplans-scalingplan-scalinginstruction.html#cfn-autoscalingplans-scalingplan-scalinginstruction-predictivescalingmaxcapacitybehavior</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getPredictiveScalingMaxCapacityBehavior() {
            return null;
        }

        /**
         * The size of the capacity buffer to use when the forecast capacity is close to or exceeds the maximum capacity.
         * <p>
         * The value is specified as a percentage relative to the forecast capacity. For example, if the buffer is 10, this means a 10 percent buffer. With a 10 percent buffer, if the forecast capacity is 50, and the maximum capacity is 40, then the effective maximum capacity is 55.
         * <p>
         * Valid only when configuring predictive scaling. Required if <em>PredictiveScalingMaxCapacityBehavior</em> is set to <code>SetMaxCapacityAboveForecastCapacity</code> , and cannot be used otherwise.
         * <p>
         * The range is 1-100.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-autoscalingplans-scalingplan-scalinginstruction.html#cfn-autoscalingplans-scalingplan-scalinginstruction-predictivescalingmaxcapacitybuffer">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-autoscalingplans-scalingplan-scalinginstruction.html#cfn-autoscalingplans-scalingplan-scalinginstruction-predictivescalingmaxcapacitybuffer</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getPredictiveScalingMaxCapacityBuffer() {
            return null;
        }

        /**
         * The predictive scaling mode.
         * <p>
         * The default value is <code>ForecastAndScale</code> . Otherwise, AWS Auto Scaling forecasts capacity but does not apply any scheduled scaling actions based on the capacity forecast.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-autoscalingplans-scalingplan-scalinginstruction.html#cfn-autoscalingplans-scalingplan-scalinginstruction-predictivescalingmode">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-autoscalingplans-scalingplan-scalinginstruction.html#cfn-autoscalingplans-scalingplan-scalinginstruction-predictivescalingmode</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getPredictiveScalingMode() {
            return null;
        }

        /**
         * Controls whether a resource's externally created scaling policies are deleted and new target tracking scaling policies created.
         * <p>
         * The default value is <code>KeepExternalPolicies</code> .
         * <p>
         * Valid only when configuring dynamic scaling.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-autoscalingplans-scalingplan-scalinginstruction.html#cfn-autoscalingplans-scalingplan-scalinginstruction-scalingpolicyupdatebehavior">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-autoscalingplans-scalingplan-scalinginstruction.html#cfn-autoscalingplans-scalingplan-scalinginstruction-scalingpolicyupdatebehavior</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getScalingPolicyUpdateBehavior() {
            return null;
        }

        /**
         * The amount of time, in seconds, to buffer the run time of scheduled scaling actions when scaling out.
         * <p>
         * For example, if the forecast says to add capacity at 10:00 AM, and the buffer time is 5 minutes, then the run time of the corresponding scheduled scaling action will be 9:55 AM. The intention is to give resources time to be provisioned. For example, it can take a few minutes to launch an EC2 instance. The actual amount of time required depends on several factors, such as the size of the instance and whether there are startup scripts to complete.
         * <p>
         * The value must be less than the forecast interval duration of 3600 seconds (60 minutes). The default is 300 seconds.
         * <p>
         * Valid only when configuring predictive scaling.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-autoscalingplans-scalingplan-scalinginstruction.html#cfn-autoscalingplans-scalingplan-scalinginstruction-scheduledactionbuffertime">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-autoscalingplans-scalingplan-scalinginstruction.html#cfn-autoscalingplans-scalingplan-scalinginstruction-scheduledactionbuffertime</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getScheduledActionBufferTime() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ScalingInstructionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ScalingInstructionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ScalingInstructionProperty> {
            java.lang.Number maxCapacity;
            java.lang.Number minCapacity;
            java.lang.String resourceId;
            java.lang.String scalableDimension;
            java.lang.String serviceNamespace;
            java.lang.Object targetTrackingConfigurations;
            java.lang.Object customizedLoadMetricSpecification;
            java.lang.Object disableDynamicScaling;
            java.lang.Object predefinedLoadMetricSpecification;
            java.lang.String predictiveScalingMaxCapacityBehavior;
            java.lang.Number predictiveScalingMaxCapacityBuffer;
            java.lang.String predictiveScalingMode;
            java.lang.String scalingPolicyUpdateBehavior;
            java.lang.Number scheduledActionBufferTime;

            /**
             * Sets the value of {@link ScalingInstructionProperty#getMaxCapacity}
             * @param maxCapacity The maximum capacity of the resource. This parameter is required.
             *                    The exception to this upper limit is if you specify a non-default setting for <em>PredictiveScalingMaxCapacityBehavior</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder maxCapacity(java.lang.Number maxCapacity) {
                this.maxCapacity = maxCapacity;
                return this;
            }

            /**
             * Sets the value of {@link ScalingInstructionProperty#getMinCapacity}
             * @param minCapacity The minimum capacity of the resource. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder minCapacity(java.lang.Number minCapacity) {
                this.minCapacity = minCapacity;
                return this;
            }

            /**
             * Sets the value of {@link ScalingInstructionProperty#getResourceId}
             * @param resourceId The ID of the resource. This string consists of the resource type and unique identifier. This parameter is required.
             *                   <ul>
             *                   <li>Auto Scaling group - The resource type is <code>autoScalingGroup</code> and the unique identifier is the name of the Auto Scaling group. Example: <code>autoScalingGroup/my-asg</code> .</li>
             *                   <li>ECS service - The resource type is <code>service</code> and the unique identifier is the cluster name and service name. Example: <code>service/default/sample-webapp</code> .</li>
             *                   <li>Spot Fleet request - The resource type is <code>spot-fleet-request</code> and the unique identifier is the Spot Fleet request ID. Example: <code>spot-fleet-request/sfr-73fbd2ce-aa30-494c-8788-1cee4EXAMPLE</code> .</li>
             *                   <li>DynamoDB table - The resource type is <code>table</code> and the unique identifier is the resource ID. Example: <code>table/my-table</code> .</li>
             *                   <li>DynamoDB global secondary index - The resource type is <code>index</code> and the unique identifier is the resource ID. Example: <code>table/my-table/index/my-table-index</code> .</li>
             *                   <li>Aurora DB cluster - The resource type is <code>cluster</code> and the unique identifier is the cluster name. Example: <code>cluster:my-db-cluster</code> .</li>
             *                   </ul>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder resourceId(java.lang.String resourceId) {
                this.resourceId = resourceId;
                return this;
            }

            /**
             * Sets the value of {@link ScalingInstructionProperty#getScalableDimension}
             * @param scalableDimension The scalable dimension associated with the resource. This parameter is required.
             *                          <ul>
             *                          <li><code>autoscaling:autoScalingGroup:DesiredCapacity</code> - The desired capacity of an Auto Scaling group.</li>
             *                          <li><code>ecs:service:DesiredCount</code> - The desired task count of an ECS service.</li>
             *                          <li><code>ec2:spot-fleet-request:TargetCapacity</code> - The target capacity of a Spot Fleet request.</li>
             *                          <li><code>dynamodb:table:ReadCapacityUnits</code> - The provisioned read capacity for a DynamoDB table.</li>
             *                          <li><code>dynamodb:table:WriteCapacityUnits</code> - The provisioned write capacity for a DynamoDB table.</li>
             *                          <li><code>dynamodb:index:ReadCapacityUnits</code> - The provisioned read capacity for a DynamoDB global secondary index.</li>
             *                          <li><code>dynamodb:index:WriteCapacityUnits</code> - The provisioned write capacity for a DynamoDB global secondary index.</li>
             *                          <li><code>rds:cluster:ReadReplicaCount</code> - The count of Aurora Replicas in an Aurora DB cluster. Available for Aurora MySQL-compatible edition and Aurora PostgreSQL-compatible edition.</li>
             *                          </ul>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder scalableDimension(java.lang.String scalableDimension) {
                this.scalableDimension = scalableDimension;
                return this;
            }

            /**
             * Sets the value of {@link ScalingInstructionProperty#getServiceNamespace}
             * @param serviceNamespace The namespace of the AWS service. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder serviceNamespace(java.lang.String serviceNamespace) {
                this.serviceNamespace = serviceNamespace;
                return this;
            }

            /**
             * Sets the value of {@link ScalingInstructionProperty#getTargetTrackingConfigurations}
             * @param targetTrackingConfigurations The target tracking configurations (up to 10). This parameter is required.
             *                                     Each of these structures must specify a unique scaling metric and a target value for the metric.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder targetTrackingConfigurations(software.amazon.awscdk.IResolvable targetTrackingConfigurations) {
                this.targetTrackingConfigurations = targetTrackingConfigurations;
                return this;
            }

            /**
             * Sets the value of {@link ScalingInstructionProperty#getTargetTrackingConfigurations}
             * @param targetTrackingConfigurations The target tracking configurations (up to 10). This parameter is required.
             *                                     Each of these structures must specify a unique scaling metric and a target value for the metric.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder targetTrackingConfigurations(java.util.List<? extends java.lang.Object> targetTrackingConfigurations) {
                this.targetTrackingConfigurations = targetTrackingConfigurations;
                return this;
            }

            /**
             * Sets the value of {@link ScalingInstructionProperty#getCustomizedLoadMetricSpecification}
             * @param customizedLoadMetricSpecification The customized load metric to use for predictive scaling.
             *                                          This property or a <em>PredefinedLoadMetricSpecification</em> is required when configuring predictive scaling, and cannot be used otherwise.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder customizedLoadMetricSpecification(software.amazon.awscdk.IResolvable customizedLoadMetricSpecification) {
                this.customizedLoadMetricSpecification = customizedLoadMetricSpecification;
                return this;
            }

            /**
             * Sets the value of {@link ScalingInstructionProperty#getCustomizedLoadMetricSpecification}
             * @param customizedLoadMetricSpecification The customized load metric to use for predictive scaling.
             *                                          This property or a <em>PredefinedLoadMetricSpecification</em> is required when configuring predictive scaling, and cannot be used otherwise.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder customizedLoadMetricSpecification(software.amazon.awscdk.services.autoscalingplans.CfnScalingPlan.CustomizedLoadMetricSpecificationProperty customizedLoadMetricSpecification) {
                this.customizedLoadMetricSpecification = customizedLoadMetricSpecification;
                return this;
            }

            /**
             * Sets the value of {@link ScalingInstructionProperty#getDisableDynamicScaling}
             * @param disableDynamicScaling Controls whether dynamic scaling is disabled.
             *                              When dynamic scaling is enabled, AWS Auto Scaling creates target tracking scaling policies based on the specified target tracking configurations.
             *                              <p>
             *                              The default is enabled ( <code>false</code> ).
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder disableDynamicScaling(java.lang.Boolean disableDynamicScaling) {
                this.disableDynamicScaling = disableDynamicScaling;
                return this;
            }

            /**
             * Sets the value of {@link ScalingInstructionProperty#getDisableDynamicScaling}
             * @param disableDynamicScaling Controls whether dynamic scaling is disabled.
             *                              When dynamic scaling is enabled, AWS Auto Scaling creates target tracking scaling policies based on the specified target tracking configurations.
             *                              <p>
             *                              The default is enabled ( <code>false</code> ).
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder disableDynamicScaling(software.amazon.awscdk.IResolvable disableDynamicScaling) {
                this.disableDynamicScaling = disableDynamicScaling;
                return this;
            }

            /**
             * Sets the value of {@link ScalingInstructionProperty#getPredefinedLoadMetricSpecification}
             * @param predefinedLoadMetricSpecification The predefined load metric to use for predictive scaling.
             *                                          This property or a <em>CustomizedLoadMetricSpecification</em> is required when configuring predictive scaling, and cannot be used otherwise.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder predefinedLoadMetricSpecification(software.amazon.awscdk.IResolvable predefinedLoadMetricSpecification) {
                this.predefinedLoadMetricSpecification = predefinedLoadMetricSpecification;
                return this;
            }

            /**
             * Sets the value of {@link ScalingInstructionProperty#getPredefinedLoadMetricSpecification}
             * @param predefinedLoadMetricSpecification The predefined load metric to use for predictive scaling.
             *                                          This property or a <em>CustomizedLoadMetricSpecification</em> is required when configuring predictive scaling, and cannot be used otherwise.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder predefinedLoadMetricSpecification(software.amazon.awscdk.services.autoscalingplans.CfnScalingPlan.PredefinedLoadMetricSpecificationProperty predefinedLoadMetricSpecification) {
                this.predefinedLoadMetricSpecification = predefinedLoadMetricSpecification;
                return this;
            }

            /**
             * Sets the value of {@link ScalingInstructionProperty#getPredictiveScalingMaxCapacityBehavior}
             * @param predictiveScalingMaxCapacityBehavior Defines the behavior that should be applied if the forecast capacity approaches or exceeds the maximum capacity specified for the resource.
             *                                             The default value is <code>SetForecastCapacityToMaxCapacity</code> .
             *                                             <p>
             *                                             The following are possible values:
             *                                             <p>
             *                                             <ul>
             *                                             <li><code>SetForecastCapacityToMaxCapacity</code> - AWS Auto Scaling cannot scale resource capacity higher than the maximum capacity. The maximum capacity is enforced as a hard limit.</li>
             *                                             <li><code>SetMaxCapacityToForecastCapacity</code> - AWS Auto Scaling can scale resource capacity higher than the maximum capacity to equal but not exceed forecast capacity.</li>
             *                                             <li><code>SetMaxCapacityAboveForecastCapacity</code> - AWS Auto Scaling can scale resource capacity higher than the maximum capacity by a specified buffer value. The intention is to give the target tracking scaling policy extra capacity if unexpected traffic occurs.</li>
             *                                             </ul>
             *                                             <p>
             *                                             Valid only when configuring predictive scaling.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder predictiveScalingMaxCapacityBehavior(java.lang.String predictiveScalingMaxCapacityBehavior) {
                this.predictiveScalingMaxCapacityBehavior = predictiveScalingMaxCapacityBehavior;
                return this;
            }

            /**
             * Sets the value of {@link ScalingInstructionProperty#getPredictiveScalingMaxCapacityBuffer}
             * @param predictiveScalingMaxCapacityBuffer The size of the capacity buffer to use when the forecast capacity is close to or exceeds the maximum capacity.
             *                                           The value is specified as a percentage relative to the forecast capacity. For example, if the buffer is 10, this means a 10 percent buffer. With a 10 percent buffer, if the forecast capacity is 50, and the maximum capacity is 40, then the effective maximum capacity is 55.
             *                                           <p>
             *                                           Valid only when configuring predictive scaling. Required if <em>PredictiveScalingMaxCapacityBehavior</em> is set to <code>SetMaxCapacityAboveForecastCapacity</code> , and cannot be used otherwise.
             *                                           <p>
             *                                           The range is 1-100.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder predictiveScalingMaxCapacityBuffer(java.lang.Number predictiveScalingMaxCapacityBuffer) {
                this.predictiveScalingMaxCapacityBuffer = predictiveScalingMaxCapacityBuffer;
                return this;
            }

            /**
             * Sets the value of {@link ScalingInstructionProperty#getPredictiveScalingMode}
             * @param predictiveScalingMode The predictive scaling mode.
             *                              The default value is <code>ForecastAndScale</code> . Otherwise, AWS Auto Scaling forecasts capacity but does not apply any scheduled scaling actions based on the capacity forecast.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder predictiveScalingMode(java.lang.String predictiveScalingMode) {
                this.predictiveScalingMode = predictiveScalingMode;
                return this;
            }

            /**
             * Sets the value of {@link ScalingInstructionProperty#getScalingPolicyUpdateBehavior}
             * @param scalingPolicyUpdateBehavior Controls whether a resource's externally created scaling policies are deleted and new target tracking scaling policies created.
             *                                    The default value is <code>KeepExternalPolicies</code> .
             *                                    <p>
             *                                    Valid only when configuring dynamic scaling.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder scalingPolicyUpdateBehavior(java.lang.String scalingPolicyUpdateBehavior) {
                this.scalingPolicyUpdateBehavior = scalingPolicyUpdateBehavior;
                return this;
            }

            /**
             * Sets the value of {@link ScalingInstructionProperty#getScheduledActionBufferTime}
             * @param scheduledActionBufferTime The amount of time, in seconds, to buffer the run time of scheduled scaling actions when scaling out.
             *                                  For example, if the forecast says to add capacity at 10:00 AM, and the buffer time is 5 minutes, then the run time of the corresponding scheduled scaling action will be 9:55 AM. The intention is to give resources time to be provisioned. For example, it can take a few minutes to launch an EC2 instance. The actual amount of time required depends on several factors, such as the size of the instance and whether there are startup scripts to complete.
             *                                  <p>
             *                                  The value must be less than the forecast interval duration of 3600 seconds (60 minutes). The default is 300 seconds.
             *                                  <p>
             *                                  Valid only when configuring predictive scaling.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder scheduledActionBufferTime(java.lang.Number scheduledActionBufferTime) {
                this.scheduledActionBufferTime = scheduledActionBufferTime;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ScalingInstructionProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ScalingInstructionProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ScalingInstructionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ScalingInstructionProperty {
            private final java.lang.Number maxCapacity;
            private final java.lang.Number minCapacity;
            private final java.lang.String resourceId;
            private final java.lang.String scalableDimension;
            private final java.lang.String serviceNamespace;
            private final java.lang.Object targetTrackingConfigurations;
            private final java.lang.Object customizedLoadMetricSpecification;
            private final java.lang.Object disableDynamicScaling;
            private final java.lang.Object predefinedLoadMetricSpecification;
            private final java.lang.String predictiveScalingMaxCapacityBehavior;
            private final java.lang.Number predictiveScalingMaxCapacityBuffer;
            private final java.lang.String predictiveScalingMode;
            private final java.lang.String scalingPolicyUpdateBehavior;
            private final java.lang.Number scheduledActionBufferTime;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.maxCapacity = software.amazon.jsii.Kernel.get(this, "maxCapacity", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.minCapacity = software.amazon.jsii.Kernel.get(this, "minCapacity", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.resourceId = software.amazon.jsii.Kernel.get(this, "resourceId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.scalableDimension = software.amazon.jsii.Kernel.get(this, "scalableDimension", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.serviceNamespace = software.amazon.jsii.Kernel.get(this, "serviceNamespace", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.targetTrackingConfigurations = software.amazon.jsii.Kernel.get(this, "targetTrackingConfigurations", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.customizedLoadMetricSpecification = software.amazon.jsii.Kernel.get(this, "customizedLoadMetricSpecification", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.disableDynamicScaling = software.amazon.jsii.Kernel.get(this, "disableDynamicScaling", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.predefinedLoadMetricSpecification = software.amazon.jsii.Kernel.get(this, "predefinedLoadMetricSpecification", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.predictiveScalingMaxCapacityBehavior = software.amazon.jsii.Kernel.get(this, "predictiveScalingMaxCapacityBehavior", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.predictiveScalingMaxCapacityBuffer = software.amazon.jsii.Kernel.get(this, "predictiveScalingMaxCapacityBuffer", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.predictiveScalingMode = software.amazon.jsii.Kernel.get(this, "predictiveScalingMode", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.scalingPolicyUpdateBehavior = software.amazon.jsii.Kernel.get(this, "scalingPolicyUpdateBehavior", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.scheduledActionBufferTime = software.amazon.jsii.Kernel.get(this, "scheduledActionBufferTime", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.maxCapacity = java.util.Objects.requireNonNull(builder.maxCapacity, "maxCapacity is required");
                this.minCapacity = java.util.Objects.requireNonNull(builder.minCapacity, "minCapacity is required");
                this.resourceId = java.util.Objects.requireNonNull(builder.resourceId, "resourceId is required");
                this.scalableDimension = java.util.Objects.requireNonNull(builder.scalableDimension, "scalableDimension is required");
                this.serviceNamespace = java.util.Objects.requireNonNull(builder.serviceNamespace, "serviceNamespace is required");
                this.targetTrackingConfigurations = java.util.Objects.requireNonNull(builder.targetTrackingConfigurations, "targetTrackingConfigurations is required");
                this.customizedLoadMetricSpecification = builder.customizedLoadMetricSpecification;
                this.disableDynamicScaling = builder.disableDynamicScaling;
                this.predefinedLoadMetricSpecification = builder.predefinedLoadMetricSpecification;
                this.predictiveScalingMaxCapacityBehavior = builder.predictiveScalingMaxCapacityBehavior;
                this.predictiveScalingMaxCapacityBuffer = builder.predictiveScalingMaxCapacityBuffer;
                this.predictiveScalingMode = builder.predictiveScalingMode;
                this.scalingPolicyUpdateBehavior = builder.scalingPolicyUpdateBehavior;
                this.scheduledActionBufferTime = builder.scheduledActionBufferTime;
            }

            @Override
            public final java.lang.Number getMaxCapacity() {
                return this.maxCapacity;
            }

            @Override
            public final java.lang.Number getMinCapacity() {
                return this.minCapacity;
            }

            @Override
            public final java.lang.String getResourceId() {
                return this.resourceId;
            }

            @Override
            public final java.lang.String getScalableDimension() {
                return this.scalableDimension;
            }

            @Override
            public final java.lang.String getServiceNamespace() {
                return this.serviceNamespace;
            }

            @Override
            public final java.lang.Object getTargetTrackingConfigurations() {
                return this.targetTrackingConfigurations;
            }

            @Override
            public final java.lang.Object getCustomizedLoadMetricSpecification() {
                return this.customizedLoadMetricSpecification;
            }

            @Override
            public final java.lang.Object getDisableDynamicScaling() {
                return this.disableDynamicScaling;
            }

            @Override
            public final java.lang.Object getPredefinedLoadMetricSpecification() {
                return this.predefinedLoadMetricSpecification;
            }

            @Override
            public final java.lang.String getPredictiveScalingMaxCapacityBehavior() {
                return this.predictiveScalingMaxCapacityBehavior;
            }

            @Override
            public final java.lang.Number getPredictiveScalingMaxCapacityBuffer() {
                return this.predictiveScalingMaxCapacityBuffer;
            }

            @Override
            public final java.lang.String getPredictiveScalingMode() {
                return this.predictiveScalingMode;
            }

            @Override
            public final java.lang.String getScalingPolicyUpdateBehavior() {
                return this.scalingPolicyUpdateBehavior;
            }

            @Override
            public final java.lang.Number getScheduledActionBufferTime() {
                return this.scheduledActionBufferTime;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("maxCapacity", om.valueToTree(this.getMaxCapacity()));
                data.set("minCapacity", om.valueToTree(this.getMinCapacity()));
                data.set("resourceId", om.valueToTree(this.getResourceId()));
                data.set("scalableDimension", om.valueToTree(this.getScalableDimension()));
                data.set("serviceNamespace", om.valueToTree(this.getServiceNamespace()));
                data.set("targetTrackingConfigurations", om.valueToTree(this.getTargetTrackingConfigurations()));
                if (this.getCustomizedLoadMetricSpecification() != null) {
                    data.set("customizedLoadMetricSpecification", om.valueToTree(this.getCustomizedLoadMetricSpecification()));
                }
                if (this.getDisableDynamicScaling() != null) {
                    data.set("disableDynamicScaling", om.valueToTree(this.getDisableDynamicScaling()));
                }
                if (this.getPredefinedLoadMetricSpecification() != null) {
                    data.set("predefinedLoadMetricSpecification", om.valueToTree(this.getPredefinedLoadMetricSpecification()));
                }
                if (this.getPredictiveScalingMaxCapacityBehavior() != null) {
                    data.set("predictiveScalingMaxCapacityBehavior", om.valueToTree(this.getPredictiveScalingMaxCapacityBehavior()));
                }
                if (this.getPredictiveScalingMaxCapacityBuffer() != null) {
                    data.set("predictiveScalingMaxCapacityBuffer", om.valueToTree(this.getPredictiveScalingMaxCapacityBuffer()));
                }
                if (this.getPredictiveScalingMode() != null) {
                    data.set("predictiveScalingMode", om.valueToTree(this.getPredictiveScalingMode()));
                }
                if (this.getScalingPolicyUpdateBehavior() != null) {
                    data.set("scalingPolicyUpdateBehavior", om.valueToTree(this.getScalingPolicyUpdateBehavior()));
                }
                if (this.getScheduledActionBufferTime() != null) {
                    data.set("scheduledActionBufferTime", om.valueToTree(this.getScheduledActionBufferTime()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_autoscalingplans.CfnScalingPlan.ScalingInstructionProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ScalingInstructionProperty.Jsii$Proxy that = (ScalingInstructionProperty.Jsii$Proxy) o;

                if (!maxCapacity.equals(that.maxCapacity)) return false;
                if (!minCapacity.equals(that.minCapacity)) return false;
                if (!resourceId.equals(that.resourceId)) return false;
                if (!scalableDimension.equals(that.scalableDimension)) return false;
                if (!serviceNamespace.equals(that.serviceNamespace)) return false;
                if (!targetTrackingConfigurations.equals(that.targetTrackingConfigurations)) return false;
                if (this.customizedLoadMetricSpecification != null ? !this.customizedLoadMetricSpecification.equals(that.customizedLoadMetricSpecification) : that.customizedLoadMetricSpecification != null) return false;
                if (this.disableDynamicScaling != null ? !this.disableDynamicScaling.equals(that.disableDynamicScaling) : that.disableDynamicScaling != null) return false;
                if (this.predefinedLoadMetricSpecification != null ? !this.predefinedLoadMetricSpecification.equals(that.predefinedLoadMetricSpecification) : that.predefinedLoadMetricSpecification != null) return false;
                if (this.predictiveScalingMaxCapacityBehavior != null ? !this.predictiveScalingMaxCapacityBehavior.equals(that.predictiveScalingMaxCapacityBehavior) : that.predictiveScalingMaxCapacityBehavior != null) return false;
                if (this.predictiveScalingMaxCapacityBuffer != null ? !this.predictiveScalingMaxCapacityBuffer.equals(that.predictiveScalingMaxCapacityBuffer) : that.predictiveScalingMaxCapacityBuffer != null) return false;
                if (this.predictiveScalingMode != null ? !this.predictiveScalingMode.equals(that.predictiveScalingMode) : that.predictiveScalingMode != null) return false;
                if (this.scalingPolicyUpdateBehavior != null ? !this.scalingPolicyUpdateBehavior.equals(that.scalingPolicyUpdateBehavior) : that.scalingPolicyUpdateBehavior != null) return false;
                return this.scheduledActionBufferTime != null ? this.scheduledActionBufferTime.equals(that.scheduledActionBufferTime) : that.scheduledActionBufferTime == null;
            }

            @Override
            public final int hashCode() {
                int result = this.maxCapacity.hashCode();
                result = 31 * result + (this.minCapacity.hashCode());
                result = 31 * result + (this.resourceId.hashCode());
                result = 31 * result + (this.scalableDimension.hashCode());
                result = 31 * result + (this.serviceNamespace.hashCode());
                result = 31 * result + (this.targetTrackingConfigurations.hashCode());
                result = 31 * result + (this.customizedLoadMetricSpecification != null ? this.customizedLoadMetricSpecification.hashCode() : 0);
                result = 31 * result + (this.disableDynamicScaling != null ? this.disableDynamicScaling.hashCode() : 0);
                result = 31 * result + (this.predefinedLoadMetricSpecification != null ? this.predefinedLoadMetricSpecification.hashCode() : 0);
                result = 31 * result + (this.predictiveScalingMaxCapacityBehavior != null ? this.predictiveScalingMaxCapacityBehavior.hashCode() : 0);
                result = 31 * result + (this.predictiveScalingMaxCapacityBuffer != null ? this.predictiveScalingMaxCapacityBuffer.hashCode() : 0);
                result = 31 * result + (this.predictiveScalingMode != null ? this.predictiveScalingMode.hashCode() : 0);
                result = 31 * result + (this.scalingPolicyUpdateBehavior != null ? this.scalingPolicyUpdateBehavior.hashCode() : 0);
                result = 31 * result + (this.scheduledActionBufferTime != null ? this.scheduledActionBufferTime.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * <code>TagFilter</code> is a subproperty of <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-autoscalingplans-scalingplan-applicationsource.html">ApplicationSource</a> that specifies a tag for an application source to use with a scaling plan.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.autoscalingplans.*;
     * TagFilterProperty tagFilterProperty = TagFilterProperty.builder()
     *         .key("key")
     *         // the properties below are optional
     *         .values(List.of("values"))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-autoscalingplans-scalingplan-tagfilter.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-autoscalingplans-scalingplan-tagfilter.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_autoscalingplans.CfnScalingPlan.TagFilterProperty")
    @software.amazon.jsii.Jsii.Proxy(TagFilterProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface TagFilterProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The tag key.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-autoscalingplans-scalingplan-tagfilter.html#cfn-autoscalingplans-scalingplan-tagfilter-key">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-autoscalingplans-scalingplan-tagfilter.html#cfn-autoscalingplans-scalingplan-tagfilter-key</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getKey();

        /**
         * The tag values (0 to 20).
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-autoscalingplans-scalingplan-tagfilter.html#cfn-autoscalingplans-scalingplan-tagfilter-values">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-autoscalingplans-scalingplan-tagfilter.html#cfn-autoscalingplans-scalingplan-tagfilter-values</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getValues() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link TagFilterProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link TagFilterProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<TagFilterProperty> {
            java.lang.String key;
            java.util.List<java.lang.String> values;

            /**
             * Sets the value of {@link TagFilterProperty#getKey}
             * @param key The tag key. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder key(java.lang.String key) {
                this.key = key;
                return this;
            }

            /**
             * Sets the value of {@link TagFilterProperty#getValues}
             * @param values The tag values (0 to 20).
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder values(java.util.List<java.lang.String> values) {
                this.values = values;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link TagFilterProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public TagFilterProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link TagFilterProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements TagFilterProperty {
            private final java.lang.String key;
            private final java.util.List<java.lang.String> values;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.key = software.amazon.jsii.Kernel.get(this, "key", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.values = software.amazon.jsii.Kernel.get(this, "values", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.key = java.util.Objects.requireNonNull(builder.key, "key is required");
                this.values = builder.values;
            }

            @Override
            public final java.lang.String getKey() {
                return this.key;
            }

            @Override
            public final java.util.List<java.lang.String> getValues() {
                return this.values;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("key", om.valueToTree(this.getKey()));
                if (this.getValues() != null) {
                    data.set("values", om.valueToTree(this.getValues()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_autoscalingplans.CfnScalingPlan.TagFilterProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                TagFilterProperty.Jsii$Proxy that = (TagFilterProperty.Jsii$Proxy) o;

                if (!key.equals(that.key)) return false;
                return this.values != null ? this.values.equals(that.values) : that.values == null;
            }

            @Override
            public final int hashCode() {
                int result = this.key.hashCode();
                result = 31 * result + (this.values != null ? this.values.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * <code>TargetTrackingConfiguration</code> is a subproperty of <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-autoscalingplans-scalingplan-scalinginstruction.html">ScalingInstruction</a> that specifies a target tracking configuration for a scalable resource.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.autoscalingplans.*;
     * TargetTrackingConfigurationProperty targetTrackingConfigurationProperty = TargetTrackingConfigurationProperty.builder()
     *         .targetValue(123)
     *         // the properties below are optional
     *         .customizedScalingMetricSpecification(CustomizedScalingMetricSpecificationProperty.builder()
     *                 .metricName("metricName")
     *                 .namespace("namespace")
     *                 .statistic("statistic")
     *                 // the properties below are optional
     *                 .dimensions(List.of(MetricDimensionProperty.builder()
     *                         .name("name")
     *                         .value("value")
     *                         .build()))
     *                 .unit("unit")
     *                 .build())
     *         .disableScaleIn(false)
     *         .estimatedInstanceWarmup(123)
     *         .predefinedScalingMetricSpecification(PredefinedScalingMetricSpecificationProperty.builder()
     *                 .predefinedScalingMetricType("predefinedScalingMetricType")
     *                 // the properties below are optional
     *                 .resourceLabel("resourceLabel")
     *                 .build())
     *         .scaleInCooldown(123)
     *         .scaleOutCooldown(123)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-autoscalingplans-scalingplan-targettrackingconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-autoscalingplans-scalingplan-targettrackingconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_autoscalingplans.CfnScalingPlan.TargetTrackingConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(TargetTrackingConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface TargetTrackingConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The target value for the metric.
         * <p>
         * Although this property accepts numbers of type Double, it won't accept values that are either too small or too large. Values must be in the range of -2^360 to 2^360.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-autoscalingplans-scalingplan-targettrackingconfiguration.html#cfn-autoscalingplans-scalingplan-targettrackingconfiguration-targetvalue">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-autoscalingplans-scalingplan-targettrackingconfiguration.html#cfn-autoscalingplans-scalingplan-targettrackingconfiguration-targetvalue</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Number getTargetValue();

        /**
         * A customized metric.
         * <p>
         * You can specify either a predefined metric or a customized metric.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-autoscalingplans-scalingplan-targettrackingconfiguration.html#cfn-autoscalingplans-scalingplan-targettrackingconfiguration-customizedscalingmetricspecification">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-autoscalingplans-scalingplan-targettrackingconfiguration.html#cfn-autoscalingplans-scalingplan-targettrackingconfiguration-customizedscalingmetricspecification</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getCustomizedScalingMetricSpecification() {
            return null;
        }

        /**
         * Indicates whether scale in by the target tracking scaling policy is disabled.
         * <p>
         * If the value is <code>true</code> , scale in is disabled and the target tracking scaling policy doesn't remove capacity from the scalable resource. Otherwise, scale in is enabled and the target tracking scaling policy can remove capacity from the scalable resource.
         * <p>
         * The default value is <code>false</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-autoscalingplans-scalingplan-targettrackingconfiguration.html#cfn-autoscalingplans-scalingplan-targettrackingconfiguration-disablescalein">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-autoscalingplans-scalingplan-targettrackingconfiguration.html#cfn-autoscalingplans-scalingplan-targettrackingconfiguration-disablescalein</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getDisableScaleIn() {
            return null;
        }

        /**
         * The estimated time, in seconds, until a newly launched instance can contribute to the CloudWatch metrics.
         * <p>
         * This value is used only if the resource is an Auto Scaling group.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-autoscalingplans-scalingplan-targettrackingconfiguration.html#cfn-autoscalingplans-scalingplan-targettrackingconfiguration-estimatedinstancewarmup">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-autoscalingplans-scalingplan-targettrackingconfiguration.html#cfn-autoscalingplans-scalingplan-targettrackingconfiguration-estimatedinstancewarmup</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getEstimatedInstanceWarmup() {
            return null;
        }

        /**
         * A predefined metric.
         * <p>
         * You can specify either a predefined metric or a customized metric.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-autoscalingplans-scalingplan-targettrackingconfiguration.html#cfn-autoscalingplans-scalingplan-targettrackingconfiguration-predefinedscalingmetricspecification">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-autoscalingplans-scalingplan-targettrackingconfiguration.html#cfn-autoscalingplans-scalingplan-targettrackingconfiguration-predefinedscalingmetricspecification</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getPredefinedScalingMetricSpecification() {
            return null;
        }

        /**
         * The amount of time, in seconds, after a scale-in activity completes before another scale in activity can start.
         * <p>
         * This value is not used if the scalable resource is an Auto Scaling group.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-autoscalingplans-scalingplan-targettrackingconfiguration.html#cfn-autoscalingplans-scalingplan-targettrackingconfiguration-scaleincooldown">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-autoscalingplans-scalingplan-targettrackingconfiguration.html#cfn-autoscalingplans-scalingplan-targettrackingconfiguration-scaleincooldown</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getScaleInCooldown() {
            return null;
        }

        /**
         * The amount of time, in seconds, after a scale-out activity completes before another scale-out activity can start.
         * <p>
         * This value is not used if the scalable resource is an Auto Scaling group.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-autoscalingplans-scalingplan-targettrackingconfiguration.html#cfn-autoscalingplans-scalingplan-targettrackingconfiguration-scaleoutcooldown">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-autoscalingplans-scalingplan-targettrackingconfiguration.html#cfn-autoscalingplans-scalingplan-targettrackingconfiguration-scaleoutcooldown</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getScaleOutCooldown() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link TargetTrackingConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link TargetTrackingConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<TargetTrackingConfigurationProperty> {
            java.lang.Number targetValue;
            java.lang.Object customizedScalingMetricSpecification;
            java.lang.Object disableScaleIn;
            java.lang.Number estimatedInstanceWarmup;
            java.lang.Object predefinedScalingMetricSpecification;
            java.lang.Number scaleInCooldown;
            java.lang.Number scaleOutCooldown;

            /**
             * Sets the value of {@link TargetTrackingConfigurationProperty#getTargetValue}
             * @param targetValue The target value for the metric. This parameter is required.
             *                    Although this property accepts numbers of type Double, it won't accept values that are either too small or too large. Values must be in the range of -2^360 to 2^360.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder targetValue(java.lang.Number targetValue) {
                this.targetValue = targetValue;
                return this;
            }

            /**
             * Sets the value of {@link TargetTrackingConfigurationProperty#getCustomizedScalingMetricSpecification}
             * @param customizedScalingMetricSpecification A customized metric.
             *                                             You can specify either a predefined metric or a customized metric.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder customizedScalingMetricSpecification(software.amazon.awscdk.IResolvable customizedScalingMetricSpecification) {
                this.customizedScalingMetricSpecification = customizedScalingMetricSpecification;
                return this;
            }

            /**
             * Sets the value of {@link TargetTrackingConfigurationProperty#getCustomizedScalingMetricSpecification}
             * @param customizedScalingMetricSpecification A customized metric.
             *                                             You can specify either a predefined metric or a customized metric.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder customizedScalingMetricSpecification(software.amazon.awscdk.services.autoscalingplans.CfnScalingPlan.CustomizedScalingMetricSpecificationProperty customizedScalingMetricSpecification) {
                this.customizedScalingMetricSpecification = customizedScalingMetricSpecification;
                return this;
            }

            /**
             * Sets the value of {@link TargetTrackingConfigurationProperty#getDisableScaleIn}
             * @param disableScaleIn Indicates whether scale in by the target tracking scaling policy is disabled.
             *                       If the value is <code>true</code> , scale in is disabled and the target tracking scaling policy doesn't remove capacity from the scalable resource. Otherwise, scale in is enabled and the target tracking scaling policy can remove capacity from the scalable resource.
             *                       <p>
             *                       The default value is <code>false</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder disableScaleIn(java.lang.Boolean disableScaleIn) {
                this.disableScaleIn = disableScaleIn;
                return this;
            }

            /**
             * Sets the value of {@link TargetTrackingConfigurationProperty#getDisableScaleIn}
             * @param disableScaleIn Indicates whether scale in by the target tracking scaling policy is disabled.
             *                       If the value is <code>true</code> , scale in is disabled and the target tracking scaling policy doesn't remove capacity from the scalable resource. Otherwise, scale in is enabled and the target tracking scaling policy can remove capacity from the scalable resource.
             *                       <p>
             *                       The default value is <code>false</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder disableScaleIn(software.amazon.awscdk.IResolvable disableScaleIn) {
                this.disableScaleIn = disableScaleIn;
                return this;
            }

            /**
             * Sets the value of {@link TargetTrackingConfigurationProperty#getEstimatedInstanceWarmup}
             * @param estimatedInstanceWarmup The estimated time, in seconds, until a newly launched instance can contribute to the CloudWatch metrics.
             *                                This value is used only if the resource is an Auto Scaling group.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder estimatedInstanceWarmup(java.lang.Number estimatedInstanceWarmup) {
                this.estimatedInstanceWarmup = estimatedInstanceWarmup;
                return this;
            }

            /**
             * Sets the value of {@link TargetTrackingConfigurationProperty#getPredefinedScalingMetricSpecification}
             * @param predefinedScalingMetricSpecification A predefined metric.
             *                                             You can specify either a predefined metric or a customized metric.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder predefinedScalingMetricSpecification(software.amazon.awscdk.IResolvable predefinedScalingMetricSpecification) {
                this.predefinedScalingMetricSpecification = predefinedScalingMetricSpecification;
                return this;
            }

            /**
             * Sets the value of {@link TargetTrackingConfigurationProperty#getPredefinedScalingMetricSpecification}
             * @param predefinedScalingMetricSpecification A predefined metric.
             *                                             You can specify either a predefined metric or a customized metric.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder predefinedScalingMetricSpecification(software.amazon.awscdk.services.autoscalingplans.CfnScalingPlan.PredefinedScalingMetricSpecificationProperty predefinedScalingMetricSpecification) {
                this.predefinedScalingMetricSpecification = predefinedScalingMetricSpecification;
                return this;
            }

            /**
             * Sets the value of {@link TargetTrackingConfigurationProperty#getScaleInCooldown}
             * @param scaleInCooldown The amount of time, in seconds, after a scale-in activity completes before another scale in activity can start.
             *                        This value is not used if the scalable resource is an Auto Scaling group.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder scaleInCooldown(java.lang.Number scaleInCooldown) {
                this.scaleInCooldown = scaleInCooldown;
                return this;
            }

            /**
             * Sets the value of {@link TargetTrackingConfigurationProperty#getScaleOutCooldown}
             * @param scaleOutCooldown The amount of time, in seconds, after a scale-out activity completes before another scale-out activity can start.
             *                         This value is not used if the scalable resource is an Auto Scaling group.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder scaleOutCooldown(java.lang.Number scaleOutCooldown) {
                this.scaleOutCooldown = scaleOutCooldown;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link TargetTrackingConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public TargetTrackingConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link TargetTrackingConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements TargetTrackingConfigurationProperty {
            private final java.lang.Number targetValue;
            private final java.lang.Object customizedScalingMetricSpecification;
            private final java.lang.Object disableScaleIn;
            private final java.lang.Number estimatedInstanceWarmup;
            private final java.lang.Object predefinedScalingMetricSpecification;
            private final java.lang.Number scaleInCooldown;
            private final java.lang.Number scaleOutCooldown;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.targetValue = software.amazon.jsii.Kernel.get(this, "targetValue", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.customizedScalingMetricSpecification = software.amazon.jsii.Kernel.get(this, "customizedScalingMetricSpecification", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.disableScaleIn = software.amazon.jsii.Kernel.get(this, "disableScaleIn", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.estimatedInstanceWarmup = software.amazon.jsii.Kernel.get(this, "estimatedInstanceWarmup", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.predefinedScalingMetricSpecification = software.amazon.jsii.Kernel.get(this, "predefinedScalingMetricSpecification", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.scaleInCooldown = software.amazon.jsii.Kernel.get(this, "scaleInCooldown", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.scaleOutCooldown = software.amazon.jsii.Kernel.get(this, "scaleOutCooldown", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.targetValue = java.util.Objects.requireNonNull(builder.targetValue, "targetValue is required");
                this.customizedScalingMetricSpecification = builder.customizedScalingMetricSpecification;
                this.disableScaleIn = builder.disableScaleIn;
                this.estimatedInstanceWarmup = builder.estimatedInstanceWarmup;
                this.predefinedScalingMetricSpecification = builder.predefinedScalingMetricSpecification;
                this.scaleInCooldown = builder.scaleInCooldown;
                this.scaleOutCooldown = builder.scaleOutCooldown;
            }

            @Override
            public final java.lang.Number getTargetValue() {
                return this.targetValue;
            }

            @Override
            public final java.lang.Object getCustomizedScalingMetricSpecification() {
                return this.customizedScalingMetricSpecification;
            }

            @Override
            public final java.lang.Object getDisableScaleIn() {
                return this.disableScaleIn;
            }

            @Override
            public final java.lang.Number getEstimatedInstanceWarmup() {
                return this.estimatedInstanceWarmup;
            }

            @Override
            public final java.lang.Object getPredefinedScalingMetricSpecification() {
                return this.predefinedScalingMetricSpecification;
            }

            @Override
            public final java.lang.Number getScaleInCooldown() {
                return this.scaleInCooldown;
            }

            @Override
            public final java.lang.Number getScaleOutCooldown() {
                return this.scaleOutCooldown;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("targetValue", om.valueToTree(this.getTargetValue()));
                if (this.getCustomizedScalingMetricSpecification() != null) {
                    data.set("customizedScalingMetricSpecification", om.valueToTree(this.getCustomizedScalingMetricSpecification()));
                }
                if (this.getDisableScaleIn() != null) {
                    data.set("disableScaleIn", om.valueToTree(this.getDisableScaleIn()));
                }
                if (this.getEstimatedInstanceWarmup() != null) {
                    data.set("estimatedInstanceWarmup", om.valueToTree(this.getEstimatedInstanceWarmup()));
                }
                if (this.getPredefinedScalingMetricSpecification() != null) {
                    data.set("predefinedScalingMetricSpecification", om.valueToTree(this.getPredefinedScalingMetricSpecification()));
                }
                if (this.getScaleInCooldown() != null) {
                    data.set("scaleInCooldown", om.valueToTree(this.getScaleInCooldown()));
                }
                if (this.getScaleOutCooldown() != null) {
                    data.set("scaleOutCooldown", om.valueToTree(this.getScaleOutCooldown()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_autoscalingplans.CfnScalingPlan.TargetTrackingConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                TargetTrackingConfigurationProperty.Jsii$Proxy that = (TargetTrackingConfigurationProperty.Jsii$Proxy) o;

                if (!targetValue.equals(that.targetValue)) return false;
                if (this.customizedScalingMetricSpecification != null ? !this.customizedScalingMetricSpecification.equals(that.customizedScalingMetricSpecification) : that.customizedScalingMetricSpecification != null) return false;
                if (this.disableScaleIn != null ? !this.disableScaleIn.equals(that.disableScaleIn) : that.disableScaleIn != null) return false;
                if (this.estimatedInstanceWarmup != null ? !this.estimatedInstanceWarmup.equals(that.estimatedInstanceWarmup) : that.estimatedInstanceWarmup != null) return false;
                if (this.predefinedScalingMetricSpecification != null ? !this.predefinedScalingMetricSpecification.equals(that.predefinedScalingMetricSpecification) : that.predefinedScalingMetricSpecification != null) return false;
                if (this.scaleInCooldown != null ? !this.scaleInCooldown.equals(that.scaleInCooldown) : that.scaleInCooldown != null) return false;
                return this.scaleOutCooldown != null ? this.scaleOutCooldown.equals(that.scaleOutCooldown) : that.scaleOutCooldown == null;
            }

            @Override
            public final int hashCode() {
                int result = this.targetValue.hashCode();
                result = 31 * result + (this.customizedScalingMetricSpecification != null ? this.customizedScalingMetricSpecification.hashCode() : 0);
                result = 31 * result + (this.disableScaleIn != null ? this.disableScaleIn.hashCode() : 0);
                result = 31 * result + (this.estimatedInstanceWarmup != null ? this.estimatedInstanceWarmup.hashCode() : 0);
                result = 31 * result + (this.predefinedScalingMetricSpecification != null ? this.predefinedScalingMetricSpecification.hashCode() : 0);
                result = 31 * result + (this.scaleInCooldown != null ? this.scaleInCooldown.hashCode() : 0);
                result = 31 * result + (this.scaleOutCooldown != null ? this.scaleOutCooldown.hashCode() : 0);
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.autoscalingplans.CfnScalingPlan}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.autoscalingplans.CfnScalingPlan> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope Scope in which this resource is defined. This parameter is required.
         * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.autoscalingplans.CfnScalingPlanProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.autoscalingplans.CfnScalingPlanProps.Builder();
        }

        /**
         * A CloudFormation stack or a set of tags.
         * <p>
         * You can create one scaling plan per application source. The <code>ApplicationSource</code> property must be present to ensure interoperability with the AWS Auto Scaling console.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-autoscalingplans-scalingplan.html#cfn-autoscalingplans-scalingplan-applicationsource">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-autoscalingplans-scalingplan.html#cfn-autoscalingplans-scalingplan-applicationsource</a>
         * @param applicationSource A CloudFormation stack or a set of tags. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder applicationSource(final software.amazon.awscdk.IResolvable applicationSource) {
            this.props.applicationSource(applicationSource);
            return this;
        }
        /**
         * A CloudFormation stack or a set of tags.
         * <p>
         * You can create one scaling plan per application source. The <code>ApplicationSource</code> property must be present to ensure interoperability with the AWS Auto Scaling console.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-autoscalingplans-scalingplan.html#cfn-autoscalingplans-scalingplan-applicationsource">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-autoscalingplans-scalingplan.html#cfn-autoscalingplans-scalingplan-applicationsource</a>
         * @param applicationSource A CloudFormation stack or a set of tags. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder applicationSource(final software.amazon.awscdk.services.autoscalingplans.CfnScalingPlan.ApplicationSourceProperty applicationSource) {
            this.props.applicationSource(applicationSource);
            return this;
        }

        /**
         * The scaling instructions.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-autoscalingplans-scalingplan.html#cfn-autoscalingplans-scalingplan-scalinginstructions">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-autoscalingplans-scalingplan.html#cfn-autoscalingplans-scalingplan-scalinginstructions</a>
         * @param scalingInstructions The scaling instructions. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder scalingInstructions(final software.amazon.awscdk.IResolvable scalingInstructions) {
            this.props.scalingInstructions(scalingInstructions);
            return this;
        }
        /**
         * The scaling instructions.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-autoscalingplans-scalingplan.html#cfn-autoscalingplans-scalingplan-scalinginstructions">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-autoscalingplans-scalingplan.html#cfn-autoscalingplans-scalingplan-scalinginstructions</a>
         * @param scalingInstructions The scaling instructions. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder scalingInstructions(final java.util.List<? extends java.lang.Object> scalingInstructions) {
            this.props.scalingInstructions(scalingInstructions);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.autoscalingplans.CfnScalingPlan}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.autoscalingplans.CfnScalingPlan build() {
            return new software.amazon.awscdk.services.autoscalingplans.CfnScalingPlan(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
