package software.amazon.awscdk.services.backup;

/**
 * This request can be sent after CreateRestoreTestingPlan request returns successfully.
 * <p>
 * This is the second part of creating a resource testing plan, and it must be completed sequentially.
 * <p>
 * This consists of <code>RestoreTestingSelectionName</code> , <code>ProtectedResourceType</code> , and one of the following:
 * <p>
 * <ul>
 * <li><code>ProtectedResourceArns</code></li>
 * <li><code>ProtectedResourceConditions</code></li>
 * </ul>
 * <p>
 * Each protected resource type can have one single value.
 * <p>
 * A restore testing selection can include a wildcard value ("*") for <code>ProtectedResourceArns</code> along with <code>ProtectedResourceConditions</code> . Alternatively, you can include up to 30 specific protected resource ARNs in <code>ProtectedResourceArns</code> .
 * <p>
 * Cannot select by both protected resource types AND specific ARNs. Request will fail if both are included.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.backup.*;
 * CfnRestoreTestingSelection cfnRestoreTestingSelection = CfnRestoreTestingSelection.Builder.create(this, "MyCfnRestoreTestingSelection")
 *         .iamRoleArn("iamRoleArn")
 *         .protectedResourceType("protectedResourceType")
 *         .restoreTestingPlanName("restoreTestingPlanName")
 *         .restoreTestingSelectionName("restoreTestingSelectionName")
 *         // the properties below are optional
 *         .protectedResourceArns(List.of("protectedResourceArns"))
 *         .protectedResourceConditions(ProtectedResourceConditionsProperty.builder()
 *                 .stringEquals(List.of(KeyValueProperty.builder()
 *                         .key("key")
 *                         .value("value")
 *                         .build()))
 *                 .stringNotEquals(List.of(KeyValueProperty.builder()
 *                         .key("key")
 *                         .value("value")
 *                         .build()))
 *                 .build())
 *         .restoreMetadataOverrides(Map.of(
 *                 "restoreMetadataOverridesKey", "restoreMetadataOverrides"))
 *         .validationWindowHours(123)
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-backup-restoretestingselection.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-backup-restoretestingselection.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-05-22T23:39:46.416Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_backup.CfnRestoreTestingSelection")
public class CfnRestoreTestingSelection extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable {

    protected CfnRestoreTestingSelection(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnRestoreTestingSelection(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.backup.CfnRestoreTestingSelection.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * @param scope Scope in which this resource is defined. This parameter is required.
     * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
     * @param props Resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnRestoreTestingSelection(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.backup.CfnRestoreTestingSelectionProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * The Amazon Resource Name (ARN) of the IAM role that AWS Backup uses to create the target resource;
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getIamRoleArn() {
        return software.amazon.jsii.Kernel.get(this, "iamRoleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The Amazon Resource Name (ARN) of the IAM role that AWS Backup uses to create the target resource;
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setIamRoleArn(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "iamRoleArn", java.util.Objects.requireNonNull(value, "iamRoleArn is required"));
    }

    /**
     * The type of AWS resource included in a resource testing selection;
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getProtectedResourceType() {
        return software.amazon.jsii.Kernel.get(this, "protectedResourceType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The type of AWS resource included in a resource testing selection;
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setProtectedResourceType(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "protectedResourceType", java.util.Objects.requireNonNull(value, "protectedResourceType is required"));
    }

    /**
     * Unique string that is the name of the restore testing plan.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getRestoreTestingPlanName() {
        return software.amazon.jsii.Kernel.get(this, "restoreTestingPlanName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Unique string that is the name of the restore testing plan.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setRestoreTestingPlanName(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "restoreTestingPlanName", java.util.Objects.requireNonNull(value, "restoreTestingPlanName is required"));
    }

    /**
     * The unique name of the restore testing selection that belongs to the related restore testing plan.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getRestoreTestingSelectionName() {
        return software.amazon.jsii.Kernel.get(this, "restoreTestingSelectionName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The unique name of the restore testing selection that belongs to the related restore testing plan.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setRestoreTestingSelectionName(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "restoreTestingSelectionName", java.util.Objects.requireNonNull(value, "restoreTestingSelectionName is required"));
    }

    /**
     * You can include specific ARNs, such as <code>ProtectedResourceArns: ["arn:aws:...", "arn:aws:..."]</code> or you can include a wildcard: <code>ProtectedResourceArns: ["*"]</code> , but not both.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getProtectedResourceArns() {
        return java.util.Optional.ofNullable((java.util.List<java.lang.String>)(software.amazon.jsii.Kernel.get(this, "protectedResourceArns", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     * You can include specific ARNs, such as <code>ProtectedResourceArns: ["arn:aws:...", "arn:aws:..."]</code> or you can include a wildcard: <code>ProtectedResourceArns: ["*"]</code> , but not both.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setProtectedResourceArns(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> value) {
        software.amazon.jsii.Kernel.set(this, "protectedResourceArns", value);
    }

    /**
     * In a resource testing selection, this parameter filters by specific conditions such as <code>StringEquals</code> or <code>StringNotEquals</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getProtectedResourceConditions() {
        return software.amazon.jsii.Kernel.get(this, "protectedResourceConditions", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * In a resource testing selection, this parameter filters by specific conditions such as <code>StringEquals</code> or <code>StringNotEquals</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setProtectedResourceConditions(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "protectedResourceConditions", value);
    }

    /**
     * In a resource testing selection, this parameter filters by specific conditions such as <code>StringEquals</code> or <code>StringNotEquals</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setProtectedResourceConditions(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.backup.CfnRestoreTestingSelection.ProtectedResourceConditionsProperty value) {
        software.amazon.jsii.Kernel.set(this, "protectedResourceConditions", value);
    }

    /**
     * You can override certain restore metadata keys by including the parameter <code>RestoreMetadataOverrides</code> in the body of <code>RestoreTestingSelection</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getRestoreMetadataOverrides() {
        return software.amazon.jsii.Kernel.get(this, "restoreMetadataOverrides", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * You can override certain restore metadata keys by including the parameter <code>RestoreMetadataOverrides</code> in the body of <code>RestoreTestingSelection</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setRestoreMetadataOverrides(final @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, java.lang.String> value) {
        software.amazon.jsii.Kernel.set(this, "restoreMetadataOverrides", value);
    }

    /**
     * You can override certain restore metadata keys by including the parameter <code>RestoreMetadataOverrides</code> in the body of <code>RestoreTestingSelection</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setRestoreMetadataOverrides(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "restoreMetadataOverrides", value);
    }

    /**
     * This is amount of hours (1 to 168) available to run a validation script on the data.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Number getValidationWindowHours() {
        return software.amazon.jsii.Kernel.get(this, "validationWindowHours", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
    }

    /**
     * This is amount of hours (1 to 168) available to run a validation script on the data.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setValidationWindowHours(final @org.jetbrains.annotations.Nullable java.lang.Number value) {
        software.amazon.jsii.Kernel.set(this, "validationWindowHours", value);
    }
    /**
     * Pair of two related strings.
     * <p>
     * Allowed characters are letters, white space, and numbers that can be represented in UTF-8 and the following characters: <code>+ - = . _ : /</code>
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.backup.*;
     * KeyValueProperty keyValueProperty = KeyValueProperty.builder()
     *         .key("key")
     *         .value("value")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-backup-restoretestingselection-keyvalue.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-backup-restoretestingselection-keyvalue.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_backup.CfnRestoreTestingSelection.KeyValueProperty")
    @software.amazon.jsii.Jsii.Proxy(KeyValueProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface KeyValueProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The tag key.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-backup-restoretestingselection-keyvalue.html#cfn-backup-restoretestingselection-keyvalue-key">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-backup-restoretestingselection-keyvalue.html#cfn-backup-restoretestingselection-keyvalue-key</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getKey();

        /**
         * The tag value.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-backup-restoretestingselection-keyvalue.html#cfn-backup-restoretestingselection-keyvalue-value">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-backup-restoretestingselection-keyvalue.html#cfn-backup-restoretestingselection-keyvalue-value</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getValue();

        /**
         * @return a {@link Builder} of {@link KeyValueProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link KeyValueProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<KeyValueProperty> {
            java.lang.String key;
            java.lang.String value;

            /**
             * Sets the value of {@link KeyValueProperty#getKey}
             * @param key The tag key. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder key(java.lang.String key) {
                this.key = key;
                return this;
            }

            /**
             * Sets the value of {@link KeyValueProperty#getValue}
             * @param value The tag value. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder value(java.lang.String value) {
                this.value = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link KeyValueProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public KeyValueProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link KeyValueProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements KeyValueProperty {
            private final java.lang.String key;
            private final java.lang.String value;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.key = software.amazon.jsii.Kernel.get(this, "key", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.value = software.amazon.jsii.Kernel.get(this, "value", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.key = java.util.Objects.requireNonNull(builder.key, "key is required");
                this.value = java.util.Objects.requireNonNull(builder.value, "value is required");
            }

            @Override
            public final java.lang.String getKey() {
                return this.key;
            }

            @Override
            public final java.lang.String getValue() {
                return this.value;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("key", om.valueToTree(this.getKey()));
                data.set("value", om.valueToTree(this.getValue()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_backup.CfnRestoreTestingSelection.KeyValueProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                KeyValueProperty.Jsii$Proxy that = (KeyValueProperty.Jsii$Proxy) o;

                if (!key.equals(that.key)) return false;
                return this.value.equals(that.value);
            }

            @Override
            public final int hashCode() {
                int result = this.key.hashCode();
                result = 31 * result + (this.value.hashCode());
                return result;
            }
        }
    }
    /**
     * The conditions that you define for resources in your restore testing plan using tags.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.backup.*;
     * ProtectedResourceConditionsProperty protectedResourceConditionsProperty = ProtectedResourceConditionsProperty.builder()
     *         .stringEquals(List.of(KeyValueProperty.builder()
     *                 .key("key")
     *                 .value("value")
     *                 .build()))
     *         .stringNotEquals(List.of(KeyValueProperty.builder()
     *                 .key("key")
     *                 .value("value")
     *                 .build()))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-backup-restoretestingselection-protectedresourceconditions.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-backup-restoretestingselection-protectedresourceconditions.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_backup.CfnRestoreTestingSelection.ProtectedResourceConditionsProperty")
    @software.amazon.jsii.Jsii.Proxy(ProtectedResourceConditionsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ProtectedResourceConditionsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Filters the values of your tagged resources for only those resources that you tagged with the same value.
         * <p>
         * Also called "exact matching."
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-backup-restoretestingselection-protectedresourceconditions.html#cfn-backup-restoretestingselection-protectedresourceconditions-stringequals">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-backup-restoretestingselection-protectedresourceconditions.html#cfn-backup-restoretestingselection-protectedresourceconditions-stringequals</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getStringEquals() {
            return null;
        }

        /**
         * Filters the values of your tagged resources for only those resources that you tagged that do not have the same value.
         * <p>
         * Also called "negated matching."
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-backup-restoretestingselection-protectedresourceconditions.html#cfn-backup-restoretestingselection-protectedresourceconditions-stringnotequals">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-backup-restoretestingselection-protectedresourceconditions.html#cfn-backup-restoretestingselection-protectedresourceconditions-stringnotequals</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getStringNotEquals() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ProtectedResourceConditionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ProtectedResourceConditionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ProtectedResourceConditionsProperty> {
            java.lang.Object stringEquals;
            java.lang.Object stringNotEquals;

            /**
             * Sets the value of {@link ProtectedResourceConditionsProperty#getStringEquals}
             * @param stringEquals Filters the values of your tagged resources for only those resources that you tagged with the same value.
             *                     Also called "exact matching."
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder stringEquals(software.amazon.awscdk.IResolvable stringEquals) {
                this.stringEquals = stringEquals;
                return this;
            }

            /**
             * Sets the value of {@link ProtectedResourceConditionsProperty#getStringEquals}
             * @param stringEquals Filters the values of your tagged resources for only those resources that you tagged with the same value.
             *                     Also called "exact matching."
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder stringEquals(java.util.List<? extends java.lang.Object> stringEquals) {
                this.stringEquals = stringEquals;
                return this;
            }

            /**
             * Sets the value of {@link ProtectedResourceConditionsProperty#getStringNotEquals}
             * @param stringNotEquals Filters the values of your tagged resources for only those resources that you tagged that do not have the same value.
             *                        Also called "negated matching."
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder stringNotEquals(software.amazon.awscdk.IResolvable stringNotEquals) {
                this.stringNotEquals = stringNotEquals;
                return this;
            }

            /**
             * Sets the value of {@link ProtectedResourceConditionsProperty#getStringNotEquals}
             * @param stringNotEquals Filters the values of your tagged resources for only those resources that you tagged that do not have the same value.
             *                        Also called "negated matching."
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder stringNotEquals(java.util.List<? extends java.lang.Object> stringNotEquals) {
                this.stringNotEquals = stringNotEquals;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ProtectedResourceConditionsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ProtectedResourceConditionsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ProtectedResourceConditionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ProtectedResourceConditionsProperty {
            private final java.lang.Object stringEquals;
            private final java.lang.Object stringNotEquals;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.stringEquals = software.amazon.jsii.Kernel.get(this, "stringEquals", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.stringNotEquals = software.amazon.jsii.Kernel.get(this, "stringNotEquals", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.stringEquals = builder.stringEquals;
                this.stringNotEquals = builder.stringNotEquals;
            }

            @Override
            public final java.lang.Object getStringEquals() {
                return this.stringEquals;
            }

            @Override
            public final java.lang.Object getStringNotEquals() {
                return this.stringNotEquals;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getStringEquals() != null) {
                    data.set("stringEquals", om.valueToTree(this.getStringEquals()));
                }
                if (this.getStringNotEquals() != null) {
                    data.set("stringNotEquals", om.valueToTree(this.getStringNotEquals()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_backup.CfnRestoreTestingSelection.ProtectedResourceConditionsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ProtectedResourceConditionsProperty.Jsii$Proxy that = (ProtectedResourceConditionsProperty.Jsii$Proxy) o;

                if (this.stringEquals != null ? !this.stringEquals.equals(that.stringEquals) : that.stringEquals != null) return false;
                return this.stringNotEquals != null ? this.stringNotEquals.equals(that.stringNotEquals) : that.stringNotEquals == null;
            }

            @Override
            public final int hashCode() {
                int result = this.stringEquals != null ? this.stringEquals.hashCode() : 0;
                result = 31 * result + (this.stringNotEquals != null ? this.stringNotEquals.hashCode() : 0);
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.backup.CfnRestoreTestingSelection}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.backup.CfnRestoreTestingSelection> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope Scope in which this resource is defined. This parameter is required.
         * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.backup.CfnRestoreTestingSelectionProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.backup.CfnRestoreTestingSelectionProps.Builder();
        }

        /**
         * The Amazon Resource Name (ARN) of the IAM role that AWS Backup uses to create the target resource;
         * <p>
         * for example: <code>arn:aws:iam::123456789012:role/S3Access</code> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-backup-restoretestingselection.html#cfn-backup-restoretestingselection-iamrolearn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-backup-restoretestingselection.html#cfn-backup-restoretestingselection-iamrolearn</a>
         * @param iamRoleArn The Amazon Resource Name (ARN) of the IAM role that AWS Backup uses to create the target resource;. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder iamRoleArn(final java.lang.String iamRoleArn) {
            this.props.iamRoleArn(iamRoleArn);
            return this;
        }

        /**
         * The type of AWS resource included in a resource testing selection;
         * <p>
         * for example, an Amazon EBS volume or an Amazon RDS database.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-backup-restoretestingselection.html#cfn-backup-restoretestingselection-protectedresourcetype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-backup-restoretestingselection.html#cfn-backup-restoretestingselection-protectedresourcetype</a>
         * @param protectedResourceType The type of AWS resource included in a resource testing selection;. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder protectedResourceType(final java.lang.String protectedResourceType) {
            this.props.protectedResourceType(protectedResourceType);
            return this;
        }

        /**
         * Unique string that is the name of the restore testing plan.
         * <p>
         * The name cannot be changed after creation. The name must consist of only alphanumeric characters and underscores. Maximum length is 50.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-backup-restoretestingselection.html#cfn-backup-restoretestingselection-restoretestingplanname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-backup-restoretestingselection.html#cfn-backup-restoretestingselection-restoretestingplanname</a>
         * @param restoreTestingPlanName Unique string that is the name of the restore testing plan. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder restoreTestingPlanName(final java.lang.String restoreTestingPlanName) {
            this.props.restoreTestingPlanName(restoreTestingPlanName);
            return this;
        }

        /**
         * The unique name of the restore testing selection that belongs to the related restore testing plan.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-backup-restoretestingselection.html#cfn-backup-restoretestingselection-restoretestingselectionname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-backup-restoretestingselection.html#cfn-backup-restoretestingselection-restoretestingselectionname</a>
         * @param restoreTestingSelectionName The unique name of the restore testing selection that belongs to the related restore testing plan. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder restoreTestingSelectionName(final java.lang.String restoreTestingSelectionName) {
            this.props.restoreTestingSelectionName(restoreTestingSelectionName);
            return this;
        }

        /**
         * You can include specific ARNs, such as <code>ProtectedResourceArns: ["arn:aws:...", "arn:aws:..."]</code> or you can include a wildcard: <code>ProtectedResourceArns: ["*"]</code> , but not both.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-backup-restoretestingselection.html#cfn-backup-restoretestingselection-protectedresourcearns">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-backup-restoretestingselection.html#cfn-backup-restoretestingselection-protectedresourcearns</a>
         * @param protectedResourceArns You can include specific ARNs, such as <code>ProtectedResourceArns: ["arn:aws:...", "arn:aws:..."]</code> or you can include a wildcard: <code>ProtectedResourceArns: ["*"]</code> , but not both. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder protectedResourceArns(final java.util.List<java.lang.String> protectedResourceArns) {
            this.props.protectedResourceArns(protectedResourceArns);
            return this;
        }

        /**
         * In a resource testing selection, this parameter filters by specific conditions such as <code>StringEquals</code> or <code>StringNotEquals</code> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-backup-restoretestingselection.html#cfn-backup-restoretestingselection-protectedresourceconditions">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-backup-restoretestingselection.html#cfn-backup-restoretestingselection-protectedresourceconditions</a>
         * @param protectedResourceConditions In a resource testing selection, this parameter filters by specific conditions such as <code>StringEquals</code> or <code>StringNotEquals</code> . This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder protectedResourceConditions(final software.amazon.awscdk.IResolvable protectedResourceConditions) {
            this.props.protectedResourceConditions(protectedResourceConditions);
            return this;
        }
        /**
         * In a resource testing selection, this parameter filters by specific conditions such as <code>StringEquals</code> or <code>StringNotEquals</code> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-backup-restoretestingselection.html#cfn-backup-restoretestingselection-protectedresourceconditions">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-backup-restoretestingselection.html#cfn-backup-restoretestingselection-protectedresourceconditions</a>
         * @param protectedResourceConditions In a resource testing selection, this parameter filters by specific conditions such as <code>StringEquals</code> or <code>StringNotEquals</code> . This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder protectedResourceConditions(final software.amazon.awscdk.services.backup.CfnRestoreTestingSelection.ProtectedResourceConditionsProperty protectedResourceConditions) {
            this.props.protectedResourceConditions(protectedResourceConditions);
            return this;
        }

        /**
         * You can override certain restore metadata keys by including the parameter <code>RestoreMetadataOverrides</code> in the body of <code>RestoreTestingSelection</code> .
         * <p>
         * Key values are not case sensitive.
         * <p>
         * See the complete list of <a href="https://docs.aws.amazon.com/aws-backup/latest/devguide/restore-testing-inferred-metadata.html">restore testing inferred metadata</a> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-backup-restoretestingselection.html#cfn-backup-restoretestingselection-restoremetadataoverrides">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-backup-restoretestingselection.html#cfn-backup-restoretestingselection-restoremetadataoverrides</a>
         * @param restoreMetadataOverrides You can override certain restore metadata keys by including the parameter <code>RestoreMetadataOverrides</code> in the body of <code>RestoreTestingSelection</code> . This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder restoreMetadataOverrides(final java.util.Map<java.lang.String, java.lang.String> restoreMetadataOverrides) {
            this.props.restoreMetadataOverrides(restoreMetadataOverrides);
            return this;
        }
        /**
         * You can override certain restore metadata keys by including the parameter <code>RestoreMetadataOverrides</code> in the body of <code>RestoreTestingSelection</code> .
         * <p>
         * Key values are not case sensitive.
         * <p>
         * See the complete list of <a href="https://docs.aws.amazon.com/aws-backup/latest/devguide/restore-testing-inferred-metadata.html">restore testing inferred metadata</a> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-backup-restoretestingselection.html#cfn-backup-restoretestingselection-restoremetadataoverrides">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-backup-restoretestingselection.html#cfn-backup-restoretestingselection-restoremetadataoverrides</a>
         * @param restoreMetadataOverrides You can override certain restore metadata keys by including the parameter <code>RestoreMetadataOverrides</code> in the body of <code>RestoreTestingSelection</code> . This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder restoreMetadataOverrides(final software.amazon.awscdk.IResolvable restoreMetadataOverrides) {
            this.props.restoreMetadataOverrides(restoreMetadataOverrides);
            return this;
        }

        /**
         * This is amount of hours (1 to 168) available to run a validation script on the data.
         * <p>
         * The data will be deleted upon the completion of the validation script or the end of the specified retention period, whichever comes first.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-backup-restoretestingselection.html#cfn-backup-restoretestingselection-validationwindowhours">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-backup-restoretestingselection.html#cfn-backup-restoretestingselection-validationwindowhours</a>
         * @param validationWindowHours This is amount of hours (1 to 168) available to run a validation script on the data. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder validationWindowHours(final java.lang.Number validationWindowHours) {
            this.props.validationWindowHours(validationWindowHours);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.backup.CfnRestoreTestingSelection}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.backup.CfnRestoreTestingSelection build() {
            return new software.amazon.awscdk.services.backup.CfnRestoreTestingSelection(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
