package software.amazon.awscdk.services.budgets;

/**
 * The <code>AWS::Budgets::BudgetsAction</code> resource enables you to take predefined actions that are initiated when a budget threshold has been exceeded.
 * <p>
 * For more information, see <a href="https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/budgets-managing-costs.html">Managing Your Costs with Budgets</a> in the <em>Billing and Cost Management User Guide</em> .
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.budgets.*;
 * CfnBudgetsAction cfnBudgetsAction = CfnBudgetsAction.Builder.create(this, "MyCfnBudgetsAction")
 *         .actionThreshold(ActionThresholdProperty.builder()
 *                 .type("type")
 *                 .value(123)
 *                 .build())
 *         .actionType("actionType")
 *         .budgetName("budgetName")
 *         .definition(DefinitionProperty.builder()
 *                 .iamActionDefinition(IamActionDefinitionProperty.builder()
 *                         .policyArn("policyArn")
 *                         // the properties below are optional
 *                         .groups(List.of("groups"))
 *                         .roles(List.of("roles"))
 *                         .users(List.of("users"))
 *                         .build())
 *                 .scpActionDefinition(ScpActionDefinitionProperty.builder()
 *                         .policyId("policyId")
 *                         .targetIds(List.of("targetIds"))
 *                         .build())
 *                 .ssmActionDefinition(SsmActionDefinitionProperty.builder()
 *                         .instanceIds(List.of("instanceIds"))
 *                         .region("region")
 *                         .subtype("subtype")
 *                         .build())
 *                 .build())
 *         .executionRoleArn("executionRoleArn")
 *         .notificationType("notificationType")
 *         .subscribers(List.of(SubscriberProperty.builder()
 *                 .address("address")
 *                 .type("type")
 *                 .build()))
 *         // the properties below are optional
 *         .approvalModel("approvalModel")
 *         .resourceTags(List.of(ResourceTagProperty.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-budgets-budgetsaction.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-budgets-budgetsaction.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-05-22T23:39:46.910Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_budgets.CfnBudgetsAction")
public class CfnBudgetsAction extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable, software.amazon.awscdk.ITaggableV2 {

    protected CfnBudgetsAction(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnBudgetsAction(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.budgets.CfnBudgetsAction.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * @param scope Scope in which this resource is defined. This parameter is required.
     * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
     * @param props Resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnBudgetsAction(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.budgets.CfnBudgetsActionProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     * A system-generated universally unique identifier (UUID) for the action.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrActionId() {
        return software.amazon.jsii.Kernel.get(this, "attrActionId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Tag Manager which manages the tags for this resource.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.TagManager getCdkTagManager() {
        return software.amazon.jsii.Kernel.get(this, "cdkTagManager", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TagManager.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * The trigger threshold of the action.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Object getActionThreshold() {
        return software.amazon.jsii.Kernel.get(this, "actionThreshold", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The trigger threshold of the action.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setActionThreshold(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "actionThreshold", java.util.Objects.requireNonNull(value, "actionThreshold is required"));
    }

    /**
     * The trigger threshold of the action.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setActionThreshold(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.budgets.CfnBudgetsAction.ActionThresholdProperty value) {
        software.amazon.jsii.Kernel.set(this, "actionThreshold", java.util.Objects.requireNonNull(value, "actionThreshold is required"));
    }

    /**
     * The type of action.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getActionType() {
        return software.amazon.jsii.Kernel.get(this, "actionType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The type of action.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setActionType(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "actionType", java.util.Objects.requireNonNull(value, "actionType is required"));
    }

    /**
     * A string that represents the budget name.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getBudgetName() {
        return software.amazon.jsii.Kernel.get(this, "budgetName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * A string that represents the budget name.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setBudgetName(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "budgetName", java.util.Objects.requireNonNull(value, "budgetName is required"));
    }

    /**
     * Specifies all of the type-specific parameters.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Object getDefinition() {
        return software.amazon.jsii.Kernel.get(this, "definition", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Specifies all of the type-specific parameters.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDefinition(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "definition", java.util.Objects.requireNonNull(value, "definition is required"));
    }

    /**
     * Specifies all of the type-specific parameters.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDefinition(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.budgets.CfnBudgetsAction.DefinitionProperty value) {
        software.amazon.jsii.Kernel.set(this, "definition", java.util.Objects.requireNonNull(value, "definition is required"));
    }

    /**
     * The role passed for action execution and reversion.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getExecutionRoleArn() {
        return software.amazon.jsii.Kernel.get(this, "executionRoleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The role passed for action execution and reversion.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setExecutionRoleArn(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "executionRoleArn", java.util.Objects.requireNonNull(value, "executionRoleArn is required"));
    }

    /**
     * The type of a notification.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getNotificationType() {
        return software.amazon.jsii.Kernel.get(this, "notificationType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The type of a notification.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setNotificationType(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "notificationType", java.util.Objects.requireNonNull(value, "notificationType is required"));
    }

    /**
     * A list of subscribers.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Object getSubscribers() {
        return software.amazon.jsii.Kernel.get(this, "subscribers", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * A list of subscribers.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSubscribers(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "subscribers", java.util.Objects.requireNonNull(value, "subscribers is required"));
    }

    /**
     * A list of subscribers.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSubscribers(final @org.jetbrains.annotations.NotNull java.util.List<java.lang.Object> value) {
        if (software.amazon.jsii.Configuration.getRuntimeTypeChecking()) {
            for (int __idx_ac66f0 = 0; __idx_ac66f0 < value.size(); __idx_ac66f0++) {
                final java.lang.Object __val_ac66f0 = value.get(__idx_ac66f0);
                if (
                     !(__val_ac66f0 instanceof software.amazon.awscdk.IResolvable)
                    && !(__val_ac66f0 instanceof software.amazon.awscdk.services.budgets.CfnBudgetsAction.SubscriberProperty)
                    && !(__val_ac66f0.getClass().equals(software.amazon.jsii.JsiiObject.class))
                ) {
                    throw new IllegalArgumentException(
                        new java.lang.StringBuilder("Expected ")
                            .append("value").append(".get(").append(__idx_ac66f0).append(")")
                            .append(" to be one of: software.amazon.awscdk.IResolvable, software.amazon.awscdk.services.budgets.CfnBudgetsAction.SubscriberProperty; received ")
                            .append(__val_ac66f0.getClass()).toString());
                }
            }
        }
        software.amazon.jsii.Kernel.set(this, "subscribers", java.util.Objects.requireNonNull(value, "subscribers is required"));
    }

    /**
     * This specifies if the action needs manual or automatic approval.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getApprovalModel() {
        return software.amazon.jsii.Kernel.get(this, "approvalModel", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * This specifies if the action needs manual or automatic approval.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setApprovalModel(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "approvalModel", value);
    }

    /**
     * An optional list of tags to associate with the specified budget action.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.services.budgets.CfnBudgetsAction.ResourceTagProperty> getResourceTags() {
        return java.util.Optional.ofNullable((java.util.List<software.amazon.awscdk.services.budgets.CfnBudgetsAction.ResourceTagProperty>)(software.amazon.jsii.Kernel.get(this, "resourceTags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.budgets.CfnBudgetsAction.ResourceTagProperty.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     * An optional list of tags to associate with the specified budget action.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setResourceTags(final @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.services.budgets.CfnBudgetsAction.ResourceTagProperty> value) {
        software.amazon.jsii.Kernel.set(this, "resourceTags", value);
    }
    /**
     * The trigger threshold of the action.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.budgets.*;
     * ActionThresholdProperty actionThresholdProperty = ActionThresholdProperty.builder()
     *         .type("type")
     *         .value(123)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-budgets-budgetsaction-actionthreshold.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-budgets-budgetsaction-actionthreshold.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_budgets.CfnBudgetsAction.ActionThresholdProperty")
    @software.amazon.jsii.Jsii.Proxy(ActionThresholdProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ActionThresholdProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The type of threshold for a notification.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-budgets-budgetsaction-actionthreshold.html#cfn-budgets-budgetsaction-actionthreshold-type">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-budgets-budgetsaction-actionthreshold.html#cfn-budgets-budgetsaction-actionthreshold-type</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getType();

        /**
         * The threshold of a notification.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-budgets-budgetsaction-actionthreshold.html#cfn-budgets-budgetsaction-actionthreshold-value">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-budgets-budgetsaction-actionthreshold.html#cfn-budgets-budgetsaction-actionthreshold-value</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Number getValue();

        /**
         * @return a {@link Builder} of {@link ActionThresholdProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ActionThresholdProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ActionThresholdProperty> {
            java.lang.String type;
            java.lang.Number value;

            /**
             * Sets the value of {@link ActionThresholdProperty#getType}
             * @param type The type of threshold for a notification. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder type(java.lang.String type) {
                this.type = type;
                return this;
            }

            /**
             * Sets the value of {@link ActionThresholdProperty#getValue}
             * @param value The threshold of a notification. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder value(java.lang.Number value) {
                this.value = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ActionThresholdProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ActionThresholdProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ActionThresholdProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ActionThresholdProperty {
            private final java.lang.String type;
            private final java.lang.Number value;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.type = software.amazon.jsii.Kernel.get(this, "type", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.value = software.amazon.jsii.Kernel.get(this, "value", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.type = java.util.Objects.requireNonNull(builder.type, "type is required");
                this.value = java.util.Objects.requireNonNull(builder.value, "value is required");
            }

            @Override
            public final java.lang.String getType() {
                return this.type;
            }

            @Override
            public final java.lang.Number getValue() {
                return this.value;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("type", om.valueToTree(this.getType()));
                data.set("value", om.valueToTree(this.getValue()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_budgets.CfnBudgetsAction.ActionThresholdProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ActionThresholdProperty.Jsii$Proxy that = (ActionThresholdProperty.Jsii$Proxy) o;

                if (!type.equals(that.type)) return false;
                return this.value.equals(that.value);
            }

            @Override
            public final int hashCode() {
                int result = this.type.hashCode();
                result = 31 * result + (this.value.hashCode());
                return result;
            }
        }
    }
    /**
     * The definition is where you specify all of the type-specific parameters.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.budgets.*;
     * DefinitionProperty definitionProperty = DefinitionProperty.builder()
     *         .iamActionDefinition(IamActionDefinitionProperty.builder()
     *                 .policyArn("policyArn")
     *                 // the properties below are optional
     *                 .groups(List.of("groups"))
     *                 .roles(List.of("roles"))
     *                 .users(List.of("users"))
     *                 .build())
     *         .scpActionDefinition(ScpActionDefinitionProperty.builder()
     *                 .policyId("policyId")
     *                 .targetIds(List.of("targetIds"))
     *                 .build())
     *         .ssmActionDefinition(SsmActionDefinitionProperty.builder()
     *                 .instanceIds(List.of("instanceIds"))
     *                 .region("region")
     *                 .subtype("subtype")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-budgets-budgetsaction-definition.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-budgets-budgetsaction-definition.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_budgets.CfnBudgetsAction.DefinitionProperty")
    @software.amazon.jsii.Jsii.Proxy(DefinitionProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface DefinitionProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The AWS Identity and Access Management ( IAM ) action definition details.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-budgets-budgetsaction-definition.html#cfn-budgets-budgetsaction-definition-iamactiondefinition">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-budgets-budgetsaction-definition.html#cfn-budgets-budgetsaction-definition-iamactiondefinition</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getIamActionDefinition() {
            return null;
        }

        /**
         * The service control policies (SCP) action definition details.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-budgets-budgetsaction-definition.html#cfn-budgets-budgetsaction-definition-scpactiondefinition">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-budgets-budgetsaction-definition.html#cfn-budgets-budgetsaction-definition-scpactiondefinition</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getScpActionDefinition() {
            return null;
        }

        /**
         * The Amazon EC2 Systems Manager ( SSM ) action definition details.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-budgets-budgetsaction-definition.html#cfn-budgets-budgetsaction-definition-ssmactiondefinition">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-budgets-budgetsaction-definition.html#cfn-budgets-budgetsaction-definition-ssmactiondefinition</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getSsmActionDefinition() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link DefinitionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link DefinitionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<DefinitionProperty> {
            java.lang.Object iamActionDefinition;
            java.lang.Object scpActionDefinition;
            java.lang.Object ssmActionDefinition;

            /**
             * Sets the value of {@link DefinitionProperty#getIamActionDefinition}
             * @param iamActionDefinition The AWS Identity and Access Management ( IAM ) action definition details.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder iamActionDefinition(software.amazon.awscdk.IResolvable iamActionDefinition) {
                this.iamActionDefinition = iamActionDefinition;
                return this;
            }

            /**
             * Sets the value of {@link DefinitionProperty#getIamActionDefinition}
             * @param iamActionDefinition The AWS Identity and Access Management ( IAM ) action definition details.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder iamActionDefinition(software.amazon.awscdk.services.budgets.CfnBudgetsAction.IamActionDefinitionProperty iamActionDefinition) {
                this.iamActionDefinition = iamActionDefinition;
                return this;
            }

            /**
             * Sets the value of {@link DefinitionProperty#getScpActionDefinition}
             * @param scpActionDefinition The service control policies (SCP) action definition details.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder scpActionDefinition(software.amazon.awscdk.IResolvable scpActionDefinition) {
                this.scpActionDefinition = scpActionDefinition;
                return this;
            }

            /**
             * Sets the value of {@link DefinitionProperty#getScpActionDefinition}
             * @param scpActionDefinition The service control policies (SCP) action definition details.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder scpActionDefinition(software.amazon.awscdk.services.budgets.CfnBudgetsAction.ScpActionDefinitionProperty scpActionDefinition) {
                this.scpActionDefinition = scpActionDefinition;
                return this;
            }

            /**
             * Sets the value of {@link DefinitionProperty#getSsmActionDefinition}
             * @param ssmActionDefinition The Amazon EC2 Systems Manager ( SSM ) action definition details.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder ssmActionDefinition(software.amazon.awscdk.IResolvable ssmActionDefinition) {
                this.ssmActionDefinition = ssmActionDefinition;
                return this;
            }

            /**
             * Sets the value of {@link DefinitionProperty#getSsmActionDefinition}
             * @param ssmActionDefinition The Amazon EC2 Systems Manager ( SSM ) action definition details.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder ssmActionDefinition(software.amazon.awscdk.services.budgets.CfnBudgetsAction.SsmActionDefinitionProperty ssmActionDefinition) {
                this.ssmActionDefinition = ssmActionDefinition;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link DefinitionProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public DefinitionProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link DefinitionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DefinitionProperty {
            private final java.lang.Object iamActionDefinition;
            private final java.lang.Object scpActionDefinition;
            private final java.lang.Object ssmActionDefinition;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.iamActionDefinition = software.amazon.jsii.Kernel.get(this, "iamActionDefinition", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.scpActionDefinition = software.amazon.jsii.Kernel.get(this, "scpActionDefinition", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.ssmActionDefinition = software.amazon.jsii.Kernel.get(this, "ssmActionDefinition", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.iamActionDefinition = builder.iamActionDefinition;
                this.scpActionDefinition = builder.scpActionDefinition;
                this.ssmActionDefinition = builder.ssmActionDefinition;
            }

            @Override
            public final java.lang.Object getIamActionDefinition() {
                return this.iamActionDefinition;
            }

            @Override
            public final java.lang.Object getScpActionDefinition() {
                return this.scpActionDefinition;
            }

            @Override
            public final java.lang.Object getSsmActionDefinition() {
                return this.ssmActionDefinition;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getIamActionDefinition() != null) {
                    data.set("iamActionDefinition", om.valueToTree(this.getIamActionDefinition()));
                }
                if (this.getScpActionDefinition() != null) {
                    data.set("scpActionDefinition", om.valueToTree(this.getScpActionDefinition()));
                }
                if (this.getSsmActionDefinition() != null) {
                    data.set("ssmActionDefinition", om.valueToTree(this.getSsmActionDefinition()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_budgets.CfnBudgetsAction.DefinitionProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                DefinitionProperty.Jsii$Proxy that = (DefinitionProperty.Jsii$Proxy) o;

                if (this.iamActionDefinition != null ? !this.iamActionDefinition.equals(that.iamActionDefinition) : that.iamActionDefinition != null) return false;
                if (this.scpActionDefinition != null ? !this.scpActionDefinition.equals(that.scpActionDefinition) : that.scpActionDefinition != null) return false;
                return this.ssmActionDefinition != null ? this.ssmActionDefinition.equals(that.ssmActionDefinition) : that.ssmActionDefinition == null;
            }

            @Override
            public final int hashCode() {
                int result = this.iamActionDefinition != null ? this.iamActionDefinition.hashCode() : 0;
                result = 31 * result + (this.scpActionDefinition != null ? this.scpActionDefinition.hashCode() : 0);
                result = 31 * result + (this.ssmActionDefinition != null ? this.ssmActionDefinition.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The AWS Identity and Access Management ( IAM ) action definition details.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.budgets.*;
     * IamActionDefinitionProperty iamActionDefinitionProperty = IamActionDefinitionProperty.builder()
     *         .policyArn("policyArn")
     *         // the properties below are optional
     *         .groups(List.of("groups"))
     *         .roles(List.of("roles"))
     *         .users(List.of("users"))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-budgets-budgetsaction-iamactiondefinition.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-budgets-budgetsaction-iamactiondefinition.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_budgets.CfnBudgetsAction.IamActionDefinitionProperty")
    @software.amazon.jsii.Jsii.Proxy(IamActionDefinitionProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface IamActionDefinitionProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The Amazon Resource Name (ARN) of the policy to be attached.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-budgets-budgetsaction-iamactiondefinition.html#cfn-budgets-budgetsaction-iamactiondefinition-policyarn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-budgets-budgetsaction-iamactiondefinition.html#cfn-budgets-budgetsaction-iamactiondefinition-policyarn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getPolicyArn();

        /**
         * A list of groups to be attached.
         * <p>
         * There must be at least one group.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-budgets-budgetsaction-iamactiondefinition.html#cfn-budgets-budgetsaction-iamactiondefinition-groups">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-budgets-budgetsaction-iamactiondefinition.html#cfn-budgets-budgetsaction-iamactiondefinition-groups</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getGroups() {
            return null;
        }

        /**
         * A list of roles to be attached.
         * <p>
         * There must be at least one role.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-budgets-budgetsaction-iamactiondefinition.html#cfn-budgets-budgetsaction-iamactiondefinition-roles">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-budgets-budgetsaction-iamactiondefinition.html#cfn-budgets-budgetsaction-iamactiondefinition-roles</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getRoles() {
            return null;
        }

        /**
         * A list of users to be attached.
         * <p>
         * There must be at least one user.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-budgets-budgetsaction-iamactiondefinition.html#cfn-budgets-budgetsaction-iamactiondefinition-users">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-budgets-budgetsaction-iamactiondefinition.html#cfn-budgets-budgetsaction-iamactiondefinition-users</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getUsers() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link IamActionDefinitionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link IamActionDefinitionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<IamActionDefinitionProperty> {
            java.lang.String policyArn;
            java.util.List<java.lang.String> groups;
            java.util.List<java.lang.String> roles;
            java.util.List<java.lang.String> users;

            /**
             * Sets the value of {@link IamActionDefinitionProperty#getPolicyArn}
             * @param policyArn The Amazon Resource Name (ARN) of the policy to be attached. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder policyArn(java.lang.String policyArn) {
                this.policyArn = policyArn;
                return this;
            }

            /**
             * Sets the value of {@link IamActionDefinitionProperty#getGroups}
             * @param groups A list of groups to be attached.
             *               There must be at least one group.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder groups(java.util.List<java.lang.String> groups) {
                this.groups = groups;
                return this;
            }

            /**
             * Sets the value of {@link IamActionDefinitionProperty#getRoles}
             * @param roles A list of roles to be attached.
             *              There must be at least one role.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder roles(java.util.List<java.lang.String> roles) {
                this.roles = roles;
                return this;
            }

            /**
             * Sets the value of {@link IamActionDefinitionProperty#getUsers}
             * @param users A list of users to be attached.
             *              There must be at least one user.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder users(java.util.List<java.lang.String> users) {
                this.users = users;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link IamActionDefinitionProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public IamActionDefinitionProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link IamActionDefinitionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements IamActionDefinitionProperty {
            private final java.lang.String policyArn;
            private final java.util.List<java.lang.String> groups;
            private final java.util.List<java.lang.String> roles;
            private final java.util.List<java.lang.String> users;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.policyArn = software.amazon.jsii.Kernel.get(this, "policyArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.groups = software.amazon.jsii.Kernel.get(this, "groups", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.roles = software.amazon.jsii.Kernel.get(this, "roles", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.users = software.amazon.jsii.Kernel.get(this, "users", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.policyArn = java.util.Objects.requireNonNull(builder.policyArn, "policyArn is required");
                this.groups = builder.groups;
                this.roles = builder.roles;
                this.users = builder.users;
            }

            @Override
            public final java.lang.String getPolicyArn() {
                return this.policyArn;
            }

            @Override
            public final java.util.List<java.lang.String> getGroups() {
                return this.groups;
            }

            @Override
            public final java.util.List<java.lang.String> getRoles() {
                return this.roles;
            }

            @Override
            public final java.util.List<java.lang.String> getUsers() {
                return this.users;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("policyArn", om.valueToTree(this.getPolicyArn()));
                if (this.getGroups() != null) {
                    data.set("groups", om.valueToTree(this.getGroups()));
                }
                if (this.getRoles() != null) {
                    data.set("roles", om.valueToTree(this.getRoles()));
                }
                if (this.getUsers() != null) {
                    data.set("users", om.valueToTree(this.getUsers()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_budgets.CfnBudgetsAction.IamActionDefinitionProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                IamActionDefinitionProperty.Jsii$Proxy that = (IamActionDefinitionProperty.Jsii$Proxy) o;

                if (!policyArn.equals(that.policyArn)) return false;
                if (this.groups != null ? !this.groups.equals(that.groups) : that.groups != null) return false;
                if (this.roles != null ? !this.roles.equals(that.roles) : that.roles != null) return false;
                return this.users != null ? this.users.equals(that.users) : that.users == null;
            }

            @Override
            public final int hashCode() {
                int result = this.policyArn.hashCode();
                result = 31 * result + (this.groups != null ? this.groups.hashCode() : 0);
                result = 31 * result + (this.roles != null ? this.roles.hashCode() : 0);
                result = 31 * result + (this.users != null ? this.users.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The tag structure that contains a tag key and value.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.budgets.*;
     * ResourceTagProperty resourceTagProperty = ResourceTagProperty.builder()
     *         .key("key")
     *         .value("value")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-budgets-budgetsaction-resourcetag.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-budgets-budgetsaction-resourcetag.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_budgets.CfnBudgetsAction.ResourceTagProperty")
    @software.amazon.jsii.Jsii.Proxy(ResourceTagProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ResourceTagProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The key that's associated with the tag.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-budgets-budgetsaction-resourcetag.html#cfn-budgets-budgetsaction-resourcetag-key">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-budgets-budgetsaction-resourcetag.html#cfn-budgets-budgetsaction-resourcetag-key</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getKey();

        /**
         * The value that's associated with the tag.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-budgets-budgetsaction-resourcetag.html#cfn-budgets-budgetsaction-resourcetag-value">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-budgets-budgetsaction-resourcetag.html#cfn-budgets-budgetsaction-resourcetag-value</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getValue();

        /**
         * @return a {@link Builder} of {@link ResourceTagProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ResourceTagProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ResourceTagProperty> {
            java.lang.String key;
            java.lang.String value;

            /**
             * Sets the value of {@link ResourceTagProperty#getKey}
             * @param key The key that's associated with the tag. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder key(java.lang.String key) {
                this.key = key;
                return this;
            }

            /**
             * Sets the value of {@link ResourceTagProperty#getValue}
             * @param value The value that's associated with the tag. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder value(java.lang.String value) {
                this.value = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ResourceTagProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ResourceTagProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ResourceTagProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ResourceTagProperty {
            private final java.lang.String key;
            private final java.lang.String value;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.key = software.amazon.jsii.Kernel.get(this, "key", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.value = software.amazon.jsii.Kernel.get(this, "value", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.key = java.util.Objects.requireNonNull(builder.key, "key is required");
                this.value = java.util.Objects.requireNonNull(builder.value, "value is required");
            }

            @Override
            public final java.lang.String getKey() {
                return this.key;
            }

            @Override
            public final java.lang.String getValue() {
                return this.value;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("key", om.valueToTree(this.getKey()));
                data.set("value", om.valueToTree(this.getValue()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_budgets.CfnBudgetsAction.ResourceTagProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ResourceTagProperty.Jsii$Proxy that = (ResourceTagProperty.Jsii$Proxy) o;

                if (!key.equals(that.key)) return false;
                return this.value.equals(that.value);
            }

            @Override
            public final int hashCode() {
                int result = this.key.hashCode();
                result = 31 * result + (this.value.hashCode());
                return result;
            }
        }
    }
    /**
     * The service control policies (SCP) action definition details.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.budgets.*;
     * ScpActionDefinitionProperty scpActionDefinitionProperty = ScpActionDefinitionProperty.builder()
     *         .policyId("policyId")
     *         .targetIds(List.of("targetIds"))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-budgets-budgetsaction-scpactiondefinition.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-budgets-budgetsaction-scpactiondefinition.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_budgets.CfnBudgetsAction.ScpActionDefinitionProperty")
    @software.amazon.jsii.Jsii.Proxy(ScpActionDefinitionProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ScpActionDefinitionProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The policy ID attached.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-budgets-budgetsaction-scpactiondefinition.html#cfn-budgets-budgetsaction-scpactiondefinition-policyid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-budgets-budgetsaction-scpactiondefinition.html#cfn-budgets-budgetsaction-scpactiondefinition-policyid</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getPolicyId();

        /**
         * A list of target IDs.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-budgets-budgetsaction-scpactiondefinition.html#cfn-budgets-budgetsaction-scpactiondefinition-targetids">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-budgets-budgetsaction-scpactiondefinition.html#cfn-budgets-budgetsaction-scpactiondefinition-targetids</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> getTargetIds();

        /**
         * @return a {@link Builder} of {@link ScpActionDefinitionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ScpActionDefinitionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ScpActionDefinitionProperty> {
            java.lang.String policyId;
            java.util.List<java.lang.String> targetIds;

            /**
             * Sets the value of {@link ScpActionDefinitionProperty#getPolicyId}
             * @param policyId The policy ID attached. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder policyId(java.lang.String policyId) {
                this.policyId = policyId;
                return this;
            }

            /**
             * Sets the value of {@link ScpActionDefinitionProperty#getTargetIds}
             * @param targetIds A list of target IDs. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder targetIds(java.util.List<java.lang.String> targetIds) {
                this.targetIds = targetIds;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ScpActionDefinitionProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ScpActionDefinitionProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ScpActionDefinitionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ScpActionDefinitionProperty {
            private final java.lang.String policyId;
            private final java.util.List<java.lang.String> targetIds;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.policyId = software.amazon.jsii.Kernel.get(this, "policyId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.targetIds = software.amazon.jsii.Kernel.get(this, "targetIds", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.policyId = java.util.Objects.requireNonNull(builder.policyId, "policyId is required");
                this.targetIds = java.util.Objects.requireNonNull(builder.targetIds, "targetIds is required");
            }

            @Override
            public final java.lang.String getPolicyId() {
                return this.policyId;
            }

            @Override
            public final java.util.List<java.lang.String> getTargetIds() {
                return this.targetIds;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("policyId", om.valueToTree(this.getPolicyId()));
                data.set("targetIds", om.valueToTree(this.getTargetIds()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_budgets.CfnBudgetsAction.ScpActionDefinitionProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ScpActionDefinitionProperty.Jsii$Proxy that = (ScpActionDefinitionProperty.Jsii$Proxy) o;

                if (!policyId.equals(that.policyId)) return false;
                return this.targetIds.equals(that.targetIds);
            }

            @Override
            public final int hashCode() {
                int result = this.policyId.hashCode();
                result = 31 * result + (this.targetIds.hashCode());
                return result;
            }
        }
    }
    /**
     * The Amazon EC2 Systems Manager ( SSM ) action definition details.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.budgets.*;
     * SsmActionDefinitionProperty ssmActionDefinitionProperty = SsmActionDefinitionProperty.builder()
     *         .instanceIds(List.of("instanceIds"))
     *         .region("region")
     *         .subtype("subtype")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-budgets-budgetsaction-ssmactiondefinition.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-budgets-budgetsaction-ssmactiondefinition.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_budgets.CfnBudgetsAction.SsmActionDefinitionProperty")
    @software.amazon.jsii.Jsii.Proxy(SsmActionDefinitionProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface SsmActionDefinitionProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The EC2 and RDS instance IDs.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-budgets-budgetsaction-ssmactiondefinition.html#cfn-budgets-budgetsaction-ssmactiondefinition-instanceids">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-budgets-budgetsaction-ssmactiondefinition.html#cfn-budgets-budgetsaction-ssmactiondefinition-instanceids</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> getInstanceIds();

        /**
         * The Region to run the ( SSM ) document.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-budgets-budgetsaction-ssmactiondefinition.html#cfn-budgets-budgetsaction-ssmactiondefinition-region">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-budgets-budgetsaction-ssmactiondefinition.html#cfn-budgets-budgetsaction-ssmactiondefinition-region</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getRegion();

        /**
         * The action subType.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-budgets-budgetsaction-ssmactiondefinition.html#cfn-budgets-budgetsaction-ssmactiondefinition-subtype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-budgets-budgetsaction-ssmactiondefinition.html#cfn-budgets-budgetsaction-ssmactiondefinition-subtype</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getSubtype();

        /**
         * @return a {@link Builder} of {@link SsmActionDefinitionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link SsmActionDefinitionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<SsmActionDefinitionProperty> {
            java.util.List<java.lang.String> instanceIds;
            java.lang.String region;
            java.lang.String subtype;

            /**
             * Sets the value of {@link SsmActionDefinitionProperty#getInstanceIds}
             * @param instanceIds The EC2 and RDS instance IDs. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder instanceIds(java.util.List<java.lang.String> instanceIds) {
                this.instanceIds = instanceIds;
                return this;
            }

            /**
             * Sets the value of {@link SsmActionDefinitionProperty#getRegion}
             * @param region The Region to run the ( SSM ) document. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder region(java.lang.String region) {
                this.region = region;
                return this;
            }

            /**
             * Sets the value of {@link SsmActionDefinitionProperty#getSubtype}
             * @param subtype The action subType. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder subtype(java.lang.String subtype) {
                this.subtype = subtype;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link SsmActionDefinitionProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public SsmActionDefinitionProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link SsmActionDefinitionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SsmActionDefinitionProperty {
            private final java.util.List<java.lang.String> instanceIds;
            private final java.lang.String region;
            private final java.lang.String subtype;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.instanceIds = software.amazon.jsii.Kernel.get(this, "instanceIds", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.region = software.amazon.jsii.Kernel.get(this, "region", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.subtype = software.amazon.jsii.Kernel.get(this, "subtype", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.instanceIds = java.util.Objects.requireNonNull(builder.instanceIds, "instanceIds is required");
                this.region = java.util.Objects.requireNonNull(builder.region, "region is required");
                this.subtype = java.util.Objects.requireNonNull(builder.subtype, "subtype is required");
            }

            @Override
            public final java.util.List<java.lang.String> getInstanceIds() {
                return this.instanceIds;
            }

            @Override
            public final java.lang.String getRegion() {
                return this.region;
            }

            @Override
            public final java.lang.String getSubtype() {
                return this.subtype;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("instanceIds", om.valueToTree(this.getInstanceIds()));
                data.set("region", om.valueToTree(this.getRegion()));
                data.set("subtype", om.valueToTree(this.getSubtype()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_budgets.CfnBudgetsAction.SsmActionDefinitionProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                SsmActionDefinitionProperty.Jsii$Proxy that = (SsmActionDefinitionProperty.Jsii$Proxy) o;

                if (!instanceIds.equals(that.instanceIds)) return false;
                if (!region.equals(that.region)) return false;
                return this.subtype.equals(that.subtype);
            }

            @Override
            public final int hashCode() {
                int result = this.instanceIds.hashCode();
                result = 31 * result + (this.region.hashCode());
                result = 31 * result + (this.subtype.hashCode());
                return result;
            }
        }
    }
    /**
     * The subscriber to a budget notification.
     * <p>
     * The subscriber consists of a subscription type and either an Amazon SNS topic or an email address.
     * <p>
     * For example, an email subscriber has the following parameters:
     * <p>
     * <ul>
     * <li>A <code>subscriptionType</code> of <code>EMAIL</code></li>
     * <li>An <code>address</code> of <code>example&#64;example.com</code></li>
     * </ul>
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.budgets.*;
     * SubscriberProperty subscriberProperty = SubscriberProperty.builder()
     *         .address("address")
     *         .type("type")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-budgets-budgetsaction-subscriber.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-budgets-budgetsaction-subscriber.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_budgets.CfnBudgetsAction.SubscriberProperty")
    @software.amazon.jsii.Jsii.Proxy(SubscriberProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface SubscriberProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The address that AWS sends budget notifications to, either an SNS topic or an email.
         * <p>
         * When you create a subscriber, the value of <code>Address</code> can't contain line breaks.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-budgets-budgetsaction-subscriber.html#cfn-budgets-budgetsaction-subscriber-address">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-budgets-budgetsaction-subscriber.html#cfn-budgets-budgetsaction-subscriber-address</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getAddress();

        /**
         * The type of notification that AWS sends to a subscriber.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-budgets-budgetsaction-subscriber.html#cfn-budgets-budgetsaction-subscriber-type">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-budgets-budgetsaction-subscriber.html#cfn-budgets-budgetsaction-subscriber-type</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getType();

        /**
         * @return a {@link Builder} of {@link SubscriberProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link SubscriberProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<SubscriberProperty> {
            java.lang.String address;
            java.lang.String type;

            /**
             * Sets the value of {@link SubscriberProperty#getAddress}
             * @param address The address that AWS sends budget notifications to, either an SNS topic or an email. This parameter is required.
             *                When you create a subscriber, the value of <code>Address</code> can't contain line breaks.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder address(java.lang.String address) {
                this.address = address;
                return this;
            }

            /**
             * Sets the value of {@link SubscriberProperty#getType}
             * @param type The type of notification that AWS sends to a subscriber. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder type(java.lang.String type) {
                this.type = type;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link SubscriberProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public SubscriberProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link SubscriberProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SubscriberProperty {
            private final java.lang.String address;
            private final java.lang.String type;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.address = software.amazon.jsii.Kernel.get(this, "address", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.type = software.amazon.jsii.Kernel.get(this, "type", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.address = java.util.Objects.requireNonNull(builder.address, "address is required");
                this.type = java.util.Objects.requireNonNull(builder.type, "type is required");
            }

            @Override
            public final java.lang.String getAddress() {
                return this.address;
            }

            @Override
            public final java.lang.String getType() {
                return this.type;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("address", om.valueToTree(this.getAddress()));
                data.set("type", om.valueToTree(this.getType()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_budgets.CfnBudgetsAction.SubscriberProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                SubscriberProperty.Jsii$Proxy that = (SubscriberProperty.Jsii$Proxy) o;

                if (!address.equals(that.address)) return false;
                return this.type.equals(that.type);
            }

            @Override
            public final int hashCode() {
                int result = this.address.hashCode();
                result = 31 * result + (this.type.hashCode());
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.budgets.CfnBudgetsAction}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.budgets.CfnBudgetsAction> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope Scope in which this resource is defined. This parameter is required.
         * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.budgets.CfnBudgetsActionProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.budgets.CfnBudgetsActionProps.Builder();
        }

        /**
         * The trigger threshold of the action.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-budgets-budgetsaction.html#cfn-budgets-budgetsaction-actionthreshold">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-budgets-budgetsaction.html#cfn-budgets-budgetsaction-actionthreshold</a>
         * @param actionThreshold The trigger threshold of the action. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder actionThreshold(final software.amazon.awscdk.IResolvable actionThreshold) {
            this.props.actionThreshold(actionThreshold);
            return this;
        }
        /**
         * The trigger threshold of the action.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-budgets-budgetsaction.html#cfn-budgets-budgetsaction-actionthreshold">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-budgets-budgetsaction.html#cfn-budgets-budgetsaction-actionthreshold</a>
         * @param actionThreshold The trigger threshold of the action. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder actionThreshold(final software.amazon.awscdk.services.budgets.CfnBudgetsAction.ActionThresholdProperty actionThreshold) {
            this.props.actionThreshold(actionThreshold);
            return this;
        }

        /**
         * The type of action.
         * <p>
         * This defines the type of tasks that can be carried out by this action. This field also determines the format for definition.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-budgets-budgetsaction.html#cfn-budgets-budgetsaction-actiontype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-budgets-budgetsaction.html#cfn-budgets-budgetsaction-actiontype</a>
         * @param actionType The type of action. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder actionType(final java.lang.String actionType) {
            this.props.actionType(actionType);
            return this;
        }

        /**
         * A string that represents the budget name.
         * <p>
         * ":" and "" characters aren't allowed.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-budgets-budgetsaction.html#cfn-budgets-budgetsaction-budgetname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-budgets-budgetsaction.html#cfn-budgets-budgetsaction-budgetname</a>
         * @param budgetName A string that represents the budget name. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder budgetName(final java.lang.String budgetName) {
            this.props.budgetName(budgetName);
            return this;
        }

        /**
         * Specifies all of the type-specific parameters.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-budgets-budgetsaction.html#cfn-budgets-budgetsaction-definition">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-budgets-budgetsaction.html#cfn-budgets-budgetsaction-definition</a>
         * @param definition Specifies all of the type-specific parameters. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder definition(final software.amazon.awscdk.IResolvable definition) {
            this.props.definition(definition);
            return this;
        }
        /**
         * Specifies all of the type-specific parameters.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-budgets-budgetsaction.html#cfn-budgets-budgetsaction-definition">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-budgets-budgetsaction.html#cfn-budgets-budgetsaction-definition</a>
         * @param definition Specifies all of the type-specific parameters. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder definition(final software.amazon.awscdk.services.budgets.CfnBudgetsAction.DefinitionProperty definition) {
            this.props.definition(definition);
            return this;
        }

        /**
         * The role passed for action execution and reversion.
         * <p>
         * Roles and actions must be in the same account.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-budgets-budgetsaction.html#cfn-budgets-budgetsaction-executionrolearn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-budgets-budgetsaction.html#cfn-budgets-budgetsaction-executionrolearn</a>
         * @param executionRoleArn The role passed for action execution and reversion. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder executionRoleArn(final java.lang.String executionRoleArn) {
            this.props.executionRoleArn(executionRoleArn);
            return this;
        }

        /**
         * The type of a notification.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-budgets-budgetsaction.html#cfn-budgets-budgetsaction-notificationtype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-budgets-budgetsaction.html#cfn-budgets-budgetsaction-notificationtype</a>
         * @param notificationType The type of a notification. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder notificationType(final java.lang.String notificationType) {
            this.props.notificationType(notificationType);
            return this;
        }

        /**
         * A list of subscribers.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-budgets-budgetsaction.html#cfn-budgets-budgetsaction-subscribers">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-budgets-budgetsaction.html#cfn-budgets-budgetsaction-subscribers</a>
         * @param subscribers A list of subscribers. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder subscribers(final software.amazon.awscdk.IResolvable subscribers) {
            this.props.subscribers(subscribers);
            return this;
        }
        /**
         * A list of subscribers.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-budgets-budgetsaction.html#cfn-budgets-budgetsaction-subscribers">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-budgets-budgetsaction.html#cfn-budgets-budgetsaction-subscribers</a>
         * @param subscribers A list of subscribers. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder subscribers(final java.util.List<? extends java.lang.Object> subscribers) {
            this.props.subscribers(subscribers);
            return this;
        }

        /**
         * This specifies if the action needs manual or automatic approval.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-budgets-budgetsaction.html#cfn-budgets-budgetsaction-approvalmodel">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-budgets-budgetsaction.html#cfn-budgets-budgetsaction-approvalmodel</a>
         * @param approvalModel This specifies if the action needs manual or automatic approval. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder approvalModel(final java.lang.String approvalModel) {
            this.props.approvalModel(approvalModel);
            return this;
        }

        /**
         * An optional list of tags to associate with the specified budget action.
         * <p>
         * Each tag consists of a key and a value, and each key must be unique for the resource.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-budgets-budgetsaction.html#cfn-budgets-budgetsaction-resourcetags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-budgets-budgetsaction.html#cfn-budgets-budgetsaction-resourcetags</a>
         * @param resourceTags An optional list of tags to associate with the specified budget action. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder resourceTags(final java.util.List<? extends software.amazon.awscdk.services.budgets.CfnBudgetsAction.ResourceTagProperty> resourceTags) {
            this.props.resourceTags(resourceTags);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.budgets.CfnBudgetsAction}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.budgets.CfnBudgetsAction build() {
            return new software.amazon.awscdk.services.budgets.CfnBudgetsAction(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
