package software.amazon.awscdk.services.cloudfront;

/**
 * A CloudFront behavior wrapper.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.*;
 * import software.amazon.awscdk.services.cloudfront.*;
 * import software.amazon.awscdk.services.lambda.*;
 * Function function_;
 * KeyGroup keyGroup;
 * Version version;
 * Behavior behavior = Behavior.builder()
 *         .allowedMethods(CloudFrontAllowedMethods.GET_HEAD)
 *         .cachedMethods(CloudFrontAllowedCachedMethods.GET_HEAD)
 *         .compress(false)
 *         .defaultTtl(Duration.minutes(30))
 *         .forwardedValues(ForwardedValuesProperty.builder()
 *                 .queryString(false)
 *                 // the properties below are optional
 *                 .cookies(CookiesProperty.builder()
 *                         .forward("forward")
 *                         // the properties below are optional
 *                         .whitelistedNames(List.of("whitelistedNames"))
 *                         .build())
 *                 .headers(List.of("headers"))
 *                 .queryStringCacheKeys(List.of("queryStringCacheKeys"))
 *                 .build())
 *         .functionAssociations(List.of(FunctionAssociation.builder()
 *                 .eventType(FunctionEventType.VIEWER_REQUEST)
 *                 .function(function_)
 *                 .build()))
 *         .isDefaultBehavior(false)
 *         .lambdaFunctionAssociations(List.of(LambdaFunctionAssociation.builder()
 *                 .eventType(LambdaEdgeEventType.ORIGIN_REQUEST)
 *                 .lambdaFunction(version)
 *                 // the properties below are optional
 *                 .includeBody(false)
 *                 .build()))
 *         .maxTtl(Duration.minutes(30))
 *         .minTtl(Duration.minutes(30))
 *         .pathPattern("pathPattern")
 *         .trustedKeyGroups(List.of(keyGroup))
 *         .trustedSigners(List.of("trustedSigners"))
 *         .viewerProtocolPolicy(ViewerProtocolPolicy.HTTPS_ONLY)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-05-22T23:39:47.163Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_cloudfront.Behavior")
@software.amazon.jsii.Jsii.Proxy(Behavior.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface Behavior extends software.amazon.jsii.JsiiSerializable {

    /**
     * The method this CloudFront distribution responds do.
     * <p>
     * Default: GET_HEAD
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudfront.CloudFrontAllowedMethods getAllowedMethods() {
        return null;
    }

    /**
     * Which methods are cached by CloudFront by default.
     * <p>
     * Default: GET_HEAD
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudfront.CloudFrontAllowedCachedMethods getCachedMethods() {
        return null;
    }

    /**
     * If CloudFront should automatically compress some content types.
     * <p>
     * Default: true
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getCompress() {
        return null;
    }

    /**
     * The default amount of time CloudFront will cache an object.
     * <p>
     * This value applies only when your custom origin does not add HTTP headers,
     * such as Cache-Control max-age, Cache-Control s-maxage, and Expires to objects.
     * <p>
     * Default: 86400 (1 day)
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.Duration getDefaultTtl() {
        return null;
    }

    /**
     * The values CloudFront will forward to the origin when making a request.
     * <p>
     * Default: none (no cookies - no headers)
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudfront.CfnDistribution.ForwardedValuesProperty getForwardedValues() {
        return null;
    }

    /**
     * The CloudFront functions to invoke before serving the contents.
     * <p>
     * Default: - no functions will be invoked
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.services.cloudfront.FunctionAssociation> getFunctionAssociations() {
        return null;
    }

    /**
     * If this behavior is the default behavior for the distribution.
     * <p>
     * You must specify exactly one default distribution per CloudFront distribution.
     * The default behavior is allowed to omit the "path" property.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getIsDefaultBehavior() {
        return null;
    }

    /**
     * Declares associated lambda&#64;edge functions for this distribution behaviour.
     * <p>
     * Default: No lambda function associated
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.services.cloudfront.LambdaFunctionAssociation> getLambdaFunctionAssociations() {
        return null;
    }

    /**
     * The max amount of time you want objects to stay in the cache before CloudFront queries your origin.
     * <p>
     * Default: Duration.seconds(31536000) (one year)
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.Duration getMaxTtl() {
        return null;
    }

    /**
     * The minimum amount of time that you want objects to stay in the cache before CloudFront queries your origin.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.Duration getMinTtl() {
        return null;
    }

    /**
     * The path this behavior responds to.
     * <p>
     * Required for all non-default behaviors. (The default behavior implicitly has "*" as the path pattern. )
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getPathPattern() {
        return null;
    }

    /**
     * A list of Key Groups that CloudFront can use to validate signed URLs or signed cookies.
     * <p>
     * Default: - no KeyGroups are associated with cache behavior
     * <p>
     * @see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/PrivateContent.html">https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/PrivateContent.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.services.cloudfront.IKeyGroup> getTrustedKeyGroups() {
        return null;
    }

    /**
     * (deprecated) Trusted signers is how CloudFront allows you to serve private content.
     * <p>
     * The signers are the account IDs that are allowed to sign cookies/presigned URLs for this distribution.
     * <p>
     * If you pass a non empty value, all requests for this behavior must be signed (no public access will be allowed)
     * <p>
     * @deprecated <ul>
     * <li>We recommend using trustedKeyGroups instead of trustedSigners.</li>
     * </ul>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getTrustedSigners() {
        return null;
    }

    /**
     * The viewer policy for this behavior.
     * <p>
     * Default: - the distribution wide viewer protocol policy will be used
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudfront.ViewerProtocolPolicy getViewerProtocolPolicy() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link Behavior}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link Behavior}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<Behavior> {
        software.amazon.awscdk.services.cloudfront.CloudFrontAllowedMethods allowedMethods;
        software.amazon.awscdk.services.cloudfront.CloudFrontAllowedCachedMethods cachedMethods;
        java.lang.Boolean compress;
        software.amazon.awscdk.Duration defaultTtl;
        software.amazon.awscdk.services.cloudfront.CfnDistribution.ForwardedValuesProperty forwardedValues;
        java.util.List<software.amazon.awscdk.services.cloudfront.FunctionAssociation> functionAssociations;
        java.lang.Boolean isDefaultBehavior;
        java.util.List<software.amazon.awscdk.services.cloudfront.LambdaFunctionAssociation> lambdaFunctionAssociations;
        software.amazon.awscdk.Duration maxTtl;
        software.amazon.awscdk.Duration minTtl;
        java.lang.String pathPattern;
        java.util.List<software.amazon.awscdk.services.cloudfront.IKeyGroup> trustedKeyGroups;
        java.util.List<java.lang.String> trustedSigners;
        software.amazon.awscdk.services.cloudfront.ViewerProtocolPolicy viewerProtocolPolicy;

        /**
         * Sets the value of {@link Behavior#getAllowedMethods}
         * @param allowedMethods The method this CloudFront distribution responds do.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder allowedMethods(software.amazon.awscdk.services.cloudfront.CloudFrontAllowedMethods allowedMethods) {
            this.allowedMethods = allowedMethods;
            return this;
        }

        /**
         * Sets the value of {@link Behavior#getCachedMethods}
         * @param cachedMethods Which methods are cached by CloudFront by default.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cachedMethods(software.amazon.awscdk.services.cloudfront.CloudFrontAllowedCachedMethods cachedMethods) {
            this.cachedMethods = cachedMethods;
            return this;
        }

        /**
         * Sets the value of {@link Behavior#getCompress}
         * @param compress If CloudFront should automatically compress some content types.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder compress(java.lang.Boolean compress) {
            this.compress = compress;
            return this;
        }

        /**
         * Sets the value of {@link Behavior#getDefaultTtl}
         * @param defaultTtl The default amount of time CloudFront will cache an object.
         *                   This value applies only when your custom origin does not add HTTP headers,
         *                   such as Cache-Control max-age, Cache-Control s-maxage, and Expires to objects.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder defaultTtl(software.amazon.awscdk.Duration defaultTtl) {
            this.defaultTtl = defaultTtl;
            return this;
        }

        /**
         * Sets the value of {@link Behavior#getForwardedValues}
         * @param forwardedValues The values CloudFront will forward to the origin when making a request.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder forwardedValues(software.amazon.awscdk.services.cloudfront.CfnDistribution.ForwardedValuesProperty forwardedValues) {
            this.forwardedValues = forwardedValues;
            return this;
        }

        /**
         * Sets the value of {@link Behavior#getFunctionAssociations}
         * @param functionAssociations The CloudFront functions to invoke before serving the contents.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder functionAssociations(java.util.List<? extends software.amazon.awscdk.services.cloudfront.FunctionAssociation> functionAssociations) {
            this.functionAssociations = (java.util.List<software.amazon.awscdk.services.cloudfront.FunctionAssociation>)functionAssociations;
            return this;
        }

        /**
         * Sets the value of {@link Behavior#getIsDefaultBehavior}
         * @param isDefaultBehavior If this behavior is the default behavior for the distribution.
         *                          You must specify exactly one default distribution per CloudFront distribution.
         *                          The default behavior is allowed to omit the "path" property.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder isDefaultBehavior(java.lang.Boolean isDefaultBehavior) {
            this.isDefaultBehavior = isDefaultBehavior;
            return this;
        }

        /**
         * Sets the value of {@link Behavior#getLambdaFunctionAssociations}
         * @param lambdaFunctionAssociations Declares associated lambda&#64;edge functions for this distribution behaviour.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder lambdaFunctionAssociations(java.util.List<? extends software.amazon.awscdk.services.cloudfront.LambdaFunctionAssociation> lambdaFunctionAssociations) {
            this.lambdaFunctionAssociations = (java.util.List<software.amazon.awscdk.services.cloudfront.LambdaFunctionAssociation>)lambdaFunctionAssociations;
            return this;
        }

        /**
         * Sets the value of {@link Behavior#getMaxTtl}
         * @param maxTtl The max amount of time you want objects to stay in the cache before CloudFront queries your origin.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder maxTtl(software.amazon.awscdk.Duration maxTtl) {
            this.maxTtl = maxTtl;
            return this;
        }

        /**
         * Sets the value of {@link Behavior#getMinTtl}
         * @param minTtl The minimum amount of time that you want objects to stay in the cache before CloudFront queries your origin.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder minTtl(software.amazon.awscdk.Duration minTtl) {
            this.minTtl = minTtl;
            return this;
        }

        /**
         * Sets the value of {@link Behavior#getPathPattern}
         * @param pathPattern The path this behavior responds to.
         *                    Required for all non-default behaviors. (The default behavior implicitly has "*" as the path pattern. )
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder pathPattern(java.lang.String pathPattern) {
            this.pathPattern = pathPattern;
            return this;
        }

        /**
         * Sets the value of {@link Behavior#getTrustedKeyGroups}
         * @param trustedKeyGroups A list of Key Groups that CloudFront can use to validate signed URLs or signed cookies.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder trustedKeyGroups(java.util.List<? extends software.amazon.awscdk.services.cloudfront.IKeyGroup> trustedKeyGroups) {
            this.trustedKeyGroups = (java.util.List<software.amazon.awscdk.services.cloudfront.IKeyGroup>)trustedKeyGroups;
            return this;
        }

        /**
         * Sets the value of {@link Behavior#getTrustedSigners}
         * @param trustedSigners Trusted signers is how CloudFront allows you to serve private content.
         *                       The signers are the account IDs that are allowed to sign cookies/presigned URLs for this distribution.
         *                       <p>
         *                       If you pass a non empty value, all requests for this behavior must be signed (no public access will be allowed)
         * @return {@code this}
         * @deprecated - We recommend using trustedKeyGroups instead of trustedSigners.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
        @Deprecated
        public Builder trustedSigners(java.util.List<java.lang.String> trustedSigners) {
            this.trustedSigners = trustedSigners;
            return this;
        }

        /**
         * Sets the value of {@link Behavior#getViewerProtocolPolicy}
         * @param viewerProtocolPolicy The viewer policy for this behavior.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder viewerProtocolPolicy(software.amazon.awscdk.services.cloudfront.ViewerProtocolPolicy viewerProtocolPolicy) {
            this.viewerProtocolPolicy = viewerProtocolPolicy;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link Behavior}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public Behavior build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link Behavior}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements Behavior {
        private final software.amazon.awscdk.services.cloudfront.CloudFrontAllowedMethods allowedMethods;
        private final software.amazon.awscdk.services.cloudfront.CloudFrontAllowedCachedMethods cachedMethods;
        private final java.lang.Boolean compress;
        private final software.amazon.awscdk.Duration defaultTtl;
        private final software.amazon.awscdk.services.cloudfront.CfnDistribution.ForwardedValuesProperty forwardedValues;
        private final java.util.List<software.amazon.awscdk.services.cloudfront.FunctionAssociation> functionAssociations;
        private final java.lang.Boolean isDefaultBehavior;
        private final java.util.List<software.amazon.awscdk.services.cloudfront.LambdaFunctionAssociation> lambdaFunctionAssociations;
        private final software.amazon.awscdk.Duration maxTtl;
        private final software.amazon.awscdk.Duration minTtl;
        private final java.lang.String pathPattern;
        private final java.util.List<software.amazon.awscdk.services.cloudfront.IKeyGroup> trustedKeyGroups;
        private final java.util.List<java.lang.String> trustedSigners;
        private final software.amazon.awscdk.services.cloudfront.ViewerProtocolPolicy viewerProtocolPolicy;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.allowedMethods = software.amazon.jsii.Kernel.get(this, "allowedMethods", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudfront.CloudFrontAllowedMethods.class));
            this.cachedMethods = software.amazon.jsii.Kernel.get(this, "cachedMethods", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudfront.CloudFrontAllowedCachedMethods.class));
            this.compress = software.amazon.jsii.Kernel.get(this, "compress", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.defaultTtl = software.amazon.jsii.Kernel.get(this, "defaultTtl", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.Duration.class));
            this.forwardedValues = software.amazon.jsii.Kernel.get(this, "forwardedValues", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudfront.CfnDistribution.ForwardedValuesProperty.class));
            this.functionAssociations = software.amazon.jsii.Kernel.get(this, "functionAssociations", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudfront.FunctionAssociation.class)));
            this.isDefaultBehavior = software.amazon.jsii.Kernel.get(this, "isDefaultBehavior", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.lambdaFunctionAssociations = software.amazon.jsii.Kernel.get(this, "lambdaFunctionAssociations", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudfront.LambdaFunctionAssociation.class)));
            this.maxTtl = software.amazon.jsii.Kernel.get(this, "maxTtl", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.Duration.class));
            this.minTtl = software.amazon.jsii.Kernel.get(this, "minTtl", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.Duration.class));
            this.pathPattern = software.amazon.jsii.Kernel.get(this, "pathPattern", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.trustedKeyGroups = software.amazon.jsii.Kernel.get(this, "trustedKeyGroups", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudfront.IKeyGroup.class)));
            this.trustedSigners = software.amazon.jsii.Kernel.get(this, "trustedSigners", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.viewerProtocolPolicy = software.amazon.jsii.Kernel.get(this, "viewerProtocolPolicy", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudfront.ViewerProtocolPolicy.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.allowedMethods = builder.allowedMethods;
            this.cachedMethods = builder.cachedMethods;
            this.compress = builder.compress;
            this.defaultTtl = builder.defaultTtl;
            this.forwardedValues = builder.forwardedValues;
            this.functionAssociations = (java.util.List<software.amazon.awscdk.services.cloudfront.FunctionAssociation>)builder.functionAssociations;
            this.isDefaultBehavior = builder.isDefaultBehavior;
            this.lambdaFunctionAssociations = (java.util.List<software.amazon.awscdk.services.cloudfront.LambdaFunctionAssociation>)builder.lambdaFunctionAssociations;
            this.maxTtl = builder.maxTtl;
            this.minTtl = builder.minTtl;
            this.pathPattern = builder.pathPattern;
            this.trustedKeyGroups = (java.util.List<software.amazon.awscdk.services.cloudfront.IKeyGroup>)builder.trustedKeyGroups;
            this.trustedSigners = builder.trustedSigners;
            this.viewerProtocolPolicy = builder.viewerProtocolPolicy;
        }

        @Override
        public final software.amazon.awscdk.services.cloudfront.CloudFrontAllowedMethods getAllowedMethods() {
            return this.allowedMethods;
        }

        @Override
        public final software.amazon.awscdk.services.cloudfront.CloudFrontAllowedCachedMethods getCachedMethods() {
            return this.cachedMethods;
        }

        @Override
        public final java.lang.Boolean getCompress() {
            return this.compress;
        }

        @Override
        public final software.amazon.awscdk.Duration getDefaultTtl() {
            return this.defaultTtl;
        }

        @Override
        public final software.amazon.awscdk.services.cloudfront.CfnDistribution.ForwardedValuesProperty getForwardedValues() {
            return this.forwardedValues;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.services.cloudfront.FunctionAssociation> getFunctionAssociations() {
            return this.functionAssociations;
        }

        @Override
        public final java.lang.Boolean getIsDefaultBehavior() {
            return this.isDefaultBehavior;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.services.cloudfront.LambdaFunctionAssociation> getLambdaFunctionAssociations() {
            return this.lambdaFunctionAssociations;
        }

        @Override
        public final software.amazon.awscdk.Duration getMaxTtl() {
            return this.maxTtl;
        }

        @Override
        public final software.amazon.awscdk.Duration getMinTtl() {
            return this.minTtl;
        }

        @Override
        public final java.lang.String getPathPattern() {
            return this.pathPattern;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.services.cloudfront.IKeyGroup> getTrustedKeyGroups() {
            return this.trustedKeyGroups;
        }

        @Override
        public final java.util.List<java.lang.String> getTrustedSigners() {
            return this.trustedSigners;
        }

        @Override
        public final software.amazon.awscdk.services.cloudfront.ViewerProtocolPolicy getViewerProtocolPolicy() {
            return this.viewerProtocolPolicy;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getAllowedMethods() != null) {
                data.set("allowedMethods", om.valueToTree(this.getAllowedMethods()));
            }
            if (this.getCachedMethods() != null) {
                data.set("cachedMethods", om.valueToTree(this.getCachedMethods()));
            }
            if (this.getCompress() != null) {
                data.set("compress", om.valueToTree(this.getCompress()));
            }
            if (this.getDefaultTtl() != null) {
                data.set("defaultTtl", om.valueToTree(this.getDefaultTtl()));
            }
            if (this.getForwardedValues() != null) {
                data.set("forwardedValues", om.valueToTree(this.getForwardedValues()));
            }
            if (this.getFunctionAssociations() != null) {
                data.set("functionAssociations", om.valueToTree(this.getFunctionAssociations()));
            }
            if (this.getIsDefaultBehavior() != null) {
                data.set("isDefaultBehavior", om.valueToTree(this.getIsDefaultBehavior()));
            }
            if (this.getLambdaFunctionAssociations() != null) {
                data.set("lambdaFunctionAssociations", om.valueToTree(this.getLambdaFunctionAssociations()));
            }
            if (this.getMaxTtl() != null) {
                data.set("maxTtl", om.valueToTree(this.getMaxTtl()));
            }
            if (this.getMinTtl() != null) {
                data.set("minTtl", om.valueToTree(this.getMinTtl()));
            }
            if (this.getPathPattern() != null) {
                data.set("pathPattern", om.valueToTree(this.getPathPattern()));
            }
            if (this.getTrustedKeyGroups() != null) {
                data.set("trustedKeyGroups", om.valueToTree(this.getTrustedKeyGroups()));
            }
            if (this.getTrustedSigners() != null) {
                data.set("trustedSigners", om.valueToTree(this.getTrustedSigners()));
            }
            if (this.getViewerProtocolPolicy() != null) {
                data.set("viewerProtocolPolicy", om.valueToTree(this.getViewerProtocolPolicy()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_cloudfront.Behavior"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            Behavior.Jsii$Proxy that = (Behavior.Jsii$Proxy) o;

            if (this.allowedMethods != null ? !this.allowedMethods.equals(that.allowedMethods) : that.allowedMethods != null) return false;
            if (this.cachedMethods != null ? !this.cachedMethods.equals(that.cachedMethods) : that.cachedMethods != null) return false;
            if (this.compress != null ? !this.compress.equals(that.compress) : that.compress != null) return false;
            if (this.defaultTtl != null ? !this.defaultTtl.equals(that.defaultTtl) : that.defaultTtl != null) return false;
            if (this.forwardedValues != null ? !this.forwardedValues.equals(that.forwardedValues) : that.forwardedValues != null) return false;
            if (this.functionAssociations != null ? !this.functionAssociations.equals(that.functionAssociations) : that.functionAssociations != null) return false;
            if (this.isDefaultBehavior != null ? !this.isDefaultBehavior.equals(that.isDefaultBehavior) : that.isDefaultBehavior != null) return false;
            if (this.lambdaFunctionAssociations != null ? !this.lambdaFunctionAssociations.equals(that.lambdaFunctionAssociations) : that.lambdaFunctionAssociations != null) return false;
            if (this.maxTtl != null ? !this.maxTtl.equals(that.maxTtl) : that.maxTtl != null) return false;
            if (this.minTtl != null ? !this.minTtl.equals(that.minTtl) : that.minTtl != null) return false;
            if (this.pathPattern != null ? !this.pathPattern.equals(that.pathPattern) : that.pathPattern != null) return false;
            if (this.trustedKeyGroups != null ? !this.trustedKeyGroups.equals(that.trustedKeyGroups) : that.trustedKeyGroups != null) return false;
            if (this.trustedSigners != null ? !this.trustedSigners.equals(that.trustedSigners) : that.trustedSigners != null) return false;
            return this.viewerProtocolPolicy != null ? this.viewerProtocolPolicy.equals(that.viewerProtocolPolicy) : that.viewerProtocolPolicy == null;
        }

        @Override
        public final int hashCode() {
            int result = this.allowedMethods != null ? this.allowedMethods.hashCode() : 0;
            result = 31 * result + (this.cachedMethods != null ? this.cachedMethods.hashCode() : 0);
            result = 31 * result + (this.compress != null ? this.compress.hashCode() : 0);
            result = 31 * result + (this.defaultTtl != null ? this.defaultTtl.hashCode() : 0);
            result = 31 * result + (this.forwardedValues != null ? this.forwardedValues.hashCode() : 0);
            result = 31 * result + (this.functionAssociations != null ? this.functionAssociations.hashCode() : 0);
            result = 31 * result + (this.isDefaultBehavior != null ? this.isDefaultBehavior.hashCode() : 0);
            result = 31 * result + (this.lambdaFunctionAssociations != null ? this.lambdaFunctionAssociations.hashCode() : 0);
            result = 31 * result + (this.maxTtl != null ? this.maxTtl.hashCode() : 0);
            result = 31 * result + (this.minTtl != null ? this.minTtl.hashCode() : 0);
            result = 31 * result + (this.pathPattern != null ? this.pathPattern.hashCode() : 0);
            result = 31 * result + (this.trustedKeyGroups != null ? this.trustedKeyGroups.hashCode() : 0);
            result = 31 * result + (this.trustedSigners != null ? this.trustedSigners.hashCode() : 0);
            result = 31 * result + (this.viewerProtocolPolicy != null ? this.viewerProtocolPolicy.hashCode() : 0);
            return result;
        }
    }
}
