package software.amazon.awscdk.services.cloudfront;

/**
 * Properties for defining a <code>CfnCloudFrontOriginAccessIdentity</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.cloudfront.*;
 * CfnCloudFrontOriginAccessIdentityProps cfnCloudFrontOriginAccessIdentityProps = CfnCloudFrontOriginAccessIdentityProps.builder()
 *         .cloudFrontOriginAccessIdentityConfig(CloudFrontOriginAccessIdentityConfigProperty.builder()
 *                 .comment("comment")
 *                 .build())
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudfront-cloudfrontoriginaccessidentity.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudfront-cloudfrontoriginaccessidentity.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-05-22T23:39:47.177Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_cloudfront.CfnCloudFrontOriginAccessIdentityProps")
@software.amazon.jsii.Jsii.Proxy(CfnCloudFrontOriginAccessIdentityProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnCloudFrontOriginAccessIdentityProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The current configuration information for the identity.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudfront-cloudfrontoriginaccessidentity.html#cfn-cloudfront-cloudfrontoriginaccessidentity-cloudfrontoriginaccessidentityconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudfront-cloudfrontoriginaccessidentity.html#cfn-cloudfront-cloudfrontoriginaccessidentity-cloudfrontoriginaccessidentityconfig</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Object getCloudFrontOriginAccessIdentityConfig();

    /**
     * @return a {@link Builder} of {@link CfnCloudFrontOriginAccessIdentityProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnCloudFrontOriginAccessIdentityProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnCloudFrontOriginAccessIdentityProps> {
        java.lang.Object cloudFrontOriginAccessIdentityConfig;

        /**
         * Sets the value of {@link CfnCloudFrontOriginAccessIdentityProps#getCloudFrontOriginAccessIdentityConfig}
         * @param cloudFrontOriginAccessIdentityConfig The current configuration information for the identity. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cloudFrontOriginAccessIdentityConfig(software.amazon.awscdk.IResolvable cloudFrontOriginAccessIdentityConfig) {
            this.cloudFrontOriginAccessIdentityConfig = cloudFrontOriginAccessIdentityConfig;
            return this;
        }

        /**
         * Sets the value of {@link CfnCloudFrontOriginAccessIdentityProps#getCloudFrontOriginAccessIdentityConfig}
         * @param cloudFrontOriginAccessIdentityConfig The current configuration information for the identity. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cloudFrontOriginAccessIdentityConfig(software.amazon.awscdk.services.cloudfront.CfnCloudFrontOriginAccessIdentity.CloudFrontOriginAccessIdentityConfigProperty cloudFrontOriginAccessIdentityConfig) {
            this.cloudFrontOriginAccessIdentityConfig = cloudFrontOriginAccessIdentityConfig;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnCloudFrontOriginAccessIdentityProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnCloudFrontOriginAccessIdentityProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnCloudFrontOriginAccessIdentityProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnCloudFrontOriginAccessIdentityProps {
        private final java.lang.Object cloudFrontOriginAccessIdentityConfig;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.cloudFrontOriginAccessIdentityConfig = software.amazon.jsii.Kernel.get(this, "cloudFrontOriginAccessIdentityConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.cloudFrontOriginAccessIdentityConfig = java.util.Objects.requireNonNull(builder.cloudFrontOriginAccessIdentityConfig, "cloudFrontOriginAccessIdentityConfig is required");
        }

        @Override
        public final java.lang.Object getCloudFrontOriginAccessIdentityConfig() {
            return this.cloudFrontOriginAccessIdentityConfig;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("cloudFrontOriginAccessIdentityConfig", om.valueToTree(this.getCloudFrontOriginAccessIdentityConfig()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_cloudfront.CfnCloudFrontOriginAccessIdentityProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnCloudFrontOriginAccessIdentityProps.Jsii$Proxy that = (CfnCloudFrontOriginAccessIdentityProps.Jsii$Proxy) o;

            return this.cloudFrontOriginAccessIdentityConfig.equals(that.cloudFrontOriginAccessIdentityConfig);
        }

        @Override
        public final int hashCode() {
            int result = this.cloudFrontOriginAccessIdentityConfig.hashCode();
            return result;
        }
    }
}
