package software.amazon.awscdk.services.cloudfront;

/**
 * Properties for creating a Origin Request Policy.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // Creating a custom origin request policy for a Distribution -- all parameters optional
 * S3Origin bucketOrigin;
 * OriginRequestPolicy myOriginRequestPolicy = OriginRequestPolicy.Builder.create(this, "OriginRequestPolicy")
 *         .originRequestPolicyName("MyPolicy")
 *         .comment("A default policy")
 *         .cookieBehavior(OriginRequestCookieBehavior.none())
 *         .headerBehavior(OriginRequestHeaderBehavior.all("CloudFront-Is-Android-Viewer"))
 *         .queryStringBehavior(OriginRequestQueryStringBehavior.allowList("username"))
 *         .build();
 * Distribution.Builder.create(this, "myDistCustomPolicy")
 *         .defaultBehavior(BehaviorOptions.builder()
 *                 .origin(bucketOrigin)
 *                 .originRequestPolicy(myOriginRequestPolicy)
 *                 .build())
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-05-22T23:39:47.329Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_cloudfront.OriginRequestPolicyProps")
@software.amazon.jsii.Jsii.Proxy(OriginRequestPolicyProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface OriginRequestPolicyProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * A comment to describe the origin request policy.
     * <p>
     * Default: - no comment
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getComment() {
        return null;
    }

    /**
     * The cookies from viewer requests to include in origin requests.
     * <p>
     * Default: OriginRequestCookieBehavior.none()
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudfront.OriginRequestCookieBehavior getCookieBehavior() {
        return null;
    }

    /**
     * The HTTP headers to include in origin requests.
     * <p>
     * These can include headers from viewer requests and additional headers added by CloudFront.
     * <p>
     * Default: OriginRequestHeaderBehavior.none()
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudfront.OriginRequestHeaderBehavior getHeaderBehavior() {
        return null;
    }

    /**
     * A unique name to identify the origin request policy.
     * <p>
     * The name must only include '-', '_', or alphanumeric characters.
     * <p>
     * Default: - generated from the `id`
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getOriginRequestPolicyName() {
        return null;
    }

    /**
     * The URL query strings from viewer requests to include in origin requests.
     * <p>
     * Default: OriginRequestQueryStringBehavior.none()
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudfront.OriginRequestQueryStringBehavior getQueryStringBehavior() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link OriginRequestPolicyProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link OriginRequestPolicyProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<OriginRequestPolicyProps> {
        java.lang.String comment;
        software.amazon.awscdk.services.cloudfront.OriginRequestCookieBehavior cookieBehavior;
        software.amazon.awscdk.services.cloudfront.OriginRequestHeaderBehavior headerBehavior;
        java.lang.String originRequestPolicyName;
        software.amazon.awscdk.services.cloudfront.OriginRequestQueryStringBehavior queryStringBehavior;

        /**
         * Sets the value of {@link OriginRequestPolicyProps#getComment}
         * @param comment A comment to describe the origin request policy.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder comment(java.lang.String comment) {
            this.comment = comment;
            return this;
        }

        /**
         * Sets the value of {@link OriginRequestPolicyProps#getCookieBehavior}
         * @param cookieBehavior The cookies from viewer requests to include in origin requests.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cookieBehavior(software.amazon.awscdk.services.cloudfront.OriginRequestCookieBehavior cookieBehavior) {
            this.cookieBehavior = cookieBehavior;
            return this;
        }

        /**
         * Sets the value of {@link OriginRequestPolicyProps#getHeaderBehavior}
         * @param headerBehavior The HTTP headers to include in origin requests.
         *                       These can include headers from viewer requests and additional headers added by CloudFront.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder headerBehavior(software.amazon.awscdk.services.cloudfront.OriginRequestHeaderBehavior headerBehavior) {
            this.headerBehavior = headerBehavior;
            return this;
        }

        /**
         * Sets the value of {@link OriginRequestPolicyProps#getOriginRequestPolicyName}
         * @param originRequestPolicyName A unique name to identify the origin request policy.
         *                                The name must only include '-', '_', or alphanumeric characters.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder originRequestPolicyName(java.lang.String originRequestPolicyName) {
            this.originRequestPolicyName = originRequestPolicyName;
            return this;
        }

        /**
         * Sets the value of {@link OriginRequestPolicyProps#getQueryStringBehavior}
         * @param queryStringBehavior The URL query strings from viewer requests to include in origin requests.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder queryStringBehavior(software.amazon.awscdk.services.cloudfront.OriginRequestQueryStringBehavior queryStringBehavior) {
            this.queryStringBehavior = queryStringBehavior;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link OriginRequestPolicyProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public OriginRequestPolicyProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link OriginRequestPolicyProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements OriginRequestPolicyProps {
        private final java.lang.String comment;
        private final software.amazon.awscdk.services.cloudfront.OriginRequestCookieBehavior cookieBehavior;
        private final software.amazon.awscdk.services.cloudfront.OriginRequestHeaderBehavior headerBehavior;
        private final java.lang.String originRequestPolicyName;
        private final software.amazon.awscdk.services.cloudfront.OriginRequestQueryStringBehavior queryStringBehavior;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.comment = software.amazon.jsii.Kernel.get(this, "comment", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.cookieBehavior = software.amazon.jsii.Kernel.get(this, "cookieBehavior", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudfront.OriginRequestCookieBehavior.class));
            this.headerBehavior = software.amazon.jsii.Kernel.get(this, "headerBehavior", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudfront.OriginRequestHeaderBehavior.class));
            this.originRequestPolicyName = software.amazon.jsii.Kernel.get(this, "originRequestPolicyName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.queryStringBehavior = software.amazon.jsii.Kernel.get(this, "queryStringBehavior", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudfront.OriginRequestQueryStringBehavior.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.comment = builder.comment;
            this.cookieBehavior = builder.cookieBehavior;
            this.headerBehavior = builder.headerBehavior;
            this.originRequestPolicyName = builder.originRequestPolicyName;
            this.queryStringBehavior = builder.queryStringBehavior;
        }

        @Override
        public final java.lang.String getComment() {
            return this.comment;
        }

        @Override
        public final software.amazon.awscdk.services.cloudfront.OriginRequestCookieBehavior getCookieBehavior() {
            return this.cookieBehavior;
        }

        @Override
        public final software.amazon.awscdk.services.cloudfront.OriginRequestHeaderBehavior getHeaderBehavior() {
            return this.headerBehavior;
        }

        @Override
        public final java.lang.String getOriginRequestPolicyName() {
            return this.originRequestPolicyName;
        }

        @Override
        public final software.amazon.awscdk.services.cloudfront.OriginRequestQueryStringBehavior getQueryStringBehavior() {
            return this.queryStringBehavior;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getComment() != null) {
                data.set("comment", om.valueToTree(this.getComment()));
            }
            if (this.getCookieBehavior() != null) {
                data.set("cookieBehavior", om.valueToTree(this.getCookieBehavior()));
            }
            if (this.getHeaderBehavior() != null) {
                data.set("headerBehavior", om.valueToTree(this.getHeaderBehavior()));
            }
            if (this.getOriginRequestPolicyName() != null) {
                data.set("originRequestPolicyName", om.valueToTree(this.getOriginRequestPolicyName()));
            }
            if (this.getQueryStringBehavior() != null) {
                data.set("queryStringBehavior", om.valueToTree(this.getQueryStringBehavior()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_cloudfront.OriginRequestPolicyProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            OriginRequestPolicyProps.Jsii$Proxy that = (OriginRequestPolicyProps.Jsii$Proxy) o;

            if (this.comment != null ? !this.comment.equals(that.comment) : that.comment != null) return false;
            if (this.cookieBehavior != null ? !this.cookieBehavior.equals(that.cookieBehavior) : that.cookieBehavior != null) return false;
            if (this.headerBehavior != null ? !this.headerBehavior.equals(that.headerBehavior) : that.headerBehavior != null) return false;
            if (this.originRequestPolicyName != null ? !this.originRequestPolicyName.equals(that.originRequestPolicyName) : that.originRequestPolicyName != null) return false;
            return this.queryStringBehavior != null ? this.queryStringBehavior.equals(that.queryStringBehavior) : that.queryStringBehavior == null;
        }

        @Override
        public final int hashCode() {
            int result = this.comment != null ? this.comment.hashCode() : 0;
            result = 31 * result + (this.cookieBehavior != null ? this.cookieBehavior.hashCode() : 0);
            result = 31 * result + (this.headerBehavior != null ? this.headerBehavior.hashCode() : 0);
            result = 31 * result + (this.originRequestPolicyName != null ? this.originRequestPolicyName.hashCode() : 0);
            result = 31 * result + (this.queryStringBehavior != null ? this.queryStringBehavior.hashCode() : 0);
            return result;
        }
    }
}
